#!/bin/sh

# Don't write anything if we don't know our bootdev
[ -f /tmp/net.ifaces ] || return 1

read IFACES < /tmp/net.ifaces

for netif in $IFACES ; do
    cat /sys/class/net/$netif/address > /tmp/net.$netif.hwaddr
    echo "# Generated by dracut initrd" > /tmp/net.$netif.ifcfg
    echo "DEVICE=$netif" >> /tmp/net.$netif.ifcfg
    echo "HWADDR=$(cat /sys/class/net/$netif/address)" >> /tmp/net.$netif.ifcfg
    echo "TYPE=Ethernet" >> /tmp/net.$netif.ifcfg
    echo "ONBOOT=yes" >> /tmp/net.$netif.ifcfg
    if [ -f /tmp/net.$netif.lease ]; then
	echo "BOOTPROTO=dhcp" >> /tmp/net.$netif.ifcfg
    else
	echo "BOOTPROTO=none" >> /tmp/net.$netif.ifcfg
        # If we've booted with static ip= lines, the override file is there
	. /tmp/net.$netif.override 
	echo "IPADDR=$ip" >> /tmp/net.$netif.ifcfg
	echo "NETMASK=$mask" >> /tmp/net.$netif.ifcfg
	[ -n "$gw" ] && echo "GATEWAY=$gw" >> /tmp/net.$netif.ifcfg
    fi
done
