/*
 * Copyright (C) 2020  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _dcn_3_0_2_OFFSET_HEADER
#define _dcn_3_0_2_OFFSET_HEADER



// addressBlock: dce_dc_mmhubbub_vga_dispdec
// base address: 0x0
#define mmVGA_MEM_WRITE_PAGE_ADDR                                                                      0x0000
#define mmVGA_MEM_WRITE_PAGE_ADDR_BASE_IDX                                                             0
#define mmVGA_MEM_READ_PAGE_ADDR                                                                       0x0001
#define mmVGA_MEM_READ_PAGE_ADDR_BASE_IDX                                                              0
#define mmVGA_RENDER_CONTROL                                                                           0x0000
#define mmVGA_RENDER_CONTROL_BASE_IDX                                                                  1
#define mmVGA_SEQUENCER_RESET_CONTROL                                                                  0x0001
#define mmVGA_SEQUENCER_RESET_CONTROL_BASE_IDX                                                         1
#define mmVGA_MODE_CONTROL                                                                             0x0002
#define mmVGA_MODE_CONTROL_BASE_IDX                                                                    1
#define mmVGA_SURFACE_PITCH_SELECT                                                                     0x0003
#define mmVGA_SURFACE_PITCH_SELECT_BASE_IDX                                                            1
#define mmVGA_MEMORY_BASE_ADDRESS                                                                      0x0004
#define mmVGA_MEMORY_BASE_ADDRESS_BASE_IDX                                                             1
#define mmVGA_DISPBUF1_SURFACE_ADDR                                                                    0x0006
#define mmVGA_DISPBUF1_SURFACE_ADDR_BASE_IDX                                                           1
#define mmVGA_DISPBUF2_SURFACE_ADDR                                                                    0x0008
#define mmVGA_DISPBUF2_SURFACE_ADDR_BASE_IDX                                                           1
#define mmVGA_MEMORY_BASE_ADDRESS_HIGH                                                                 0x0009
#define mmVGA_MEMORY_BASE_ADDRESS_HIGH_BASE_IDX                                                        1
#define mmVGA_HDP_CONTROL                                                                              0x000a
#define mmVGA_HDP_CONTROL_BASE_IDX                                                                     1
#define mmVGA_CACHE_CONTROL                                                                            0x000b
#define mmVGA_CACHE_CONTROL_BASE_IDX                                                                   1
#define mmD1VGA_CONTROL                                                                                0x000c
#define mmD1VGA_CONTROL_BASE_IDX                                                                       1
#define mmD2VGA_CONTROL                                                                                0x000e
#define mmD2VGA_CONTROL_BASE_IDX                                                                       1
#define mmVGA_STATUS                                                                                   0x0010
#define mmVGA_STATUS_BASE_IDX                                                                          1
#define mmVGA_INTERRUPT_CONTROL                                                                        0x0011
#define mmVGA_INTERRUPT_CONTROL_BASE_IDX                                                               1
#define mmVGA_STATUS_CLEAR                                                                             0x0012
#define mmVGA_STATUS_CLEAR_BASE_IDX                                                                    1
#define mmVGA_INTERRUPT_STATUS                                                                         0x0013
#define mmVGA_INTERRUPT_STATUS_BASE_IDX                                                                1
#define mmVGA_MAIN_CONTROL                                                                             0x0014
#define mmVGA_MAIN_CONTROL_BASE_IDX                                                                    1
#define mmVGA_TEST_CONTROL                                                                             0x0015
#define mmVGA_TEST_CONTROL_BASE_IDX                                                                    1
#define mmVGA_QOS_CTRL                                                                                 0x0018
#define mmVGA_QOS_CTRL_BASE_IDX                                                                        1
#define mmCRTC8_IDX                                                                                    0x002d
#define mmCRTC8_IDX_BASE_IDX                                                                           1
#define mmCRTC8_DATA                                                                                   0x002d
#define mmCRTC8_DATA_BASE_IDX                                                                          1
#define mmGENFC_WT                                                                                     0x002e
#define mmGENFC_WT_BASE_IDX                                                                            1
#define mmGENS1                                                                                        0x002e
#define mmGENS1_BASE_IDX                                                                               1
#define mmATTRDW                                                                                       0x0030
#define mmATTRDW_BASE_IDX                                                                              1
#define mmATTRX                                                                                        0x0030
#define mmATTRX_BASE_IDX                                                                               1
#define mmATTRDR                                                                                       0x0030
#define mmATTRDR_BASE_IDX                                                                              1
#define mmGENMO_WT                                                                                     0x0030
#define mmGENMO_WT_BASE_IDX                                                                            1
#define mmGENS0                                                                                        0x0030
#define mmGENS0_BASE_IDX                                                                               1
#define mmGENENB                                                                                       0x0030
#define mmGENENB_BASE_IDX                                                                              1
#define mmSEQ8_IDX                                                                                     0x0031
#define mmSEQ8_IDX_BASE_IDX                                                                            1
#define mmSEQ8_DATA                                                                                    0x0031
#define mmSEQ8_DATA_BASE_IDX                                                                           1
#define mmDAC_MASK                                                                                     0x0031
#define mmDAC_MASK_BASE_IDX                                                                            1
#define mmDAC_R_INDEX                                                                                  0x0031
#define mmDAC_R_INDEX_BASE_IDX                                                                         1
#define mmDAC_W_INDEX                                                                                  0x0032
#define mmDAC_W_INDEX_BASE_IDX                                                                         1
#define mmDAC_DATA                                                                                     0x0032
#define mmDAC_DATA_BASE_IDX                                                                            1
#define mmGENFC_RD                                                                                     0x0032
#define mmGENFC_RD_BASE_IDX                                                                            1
#define mmGENMO_RD                                                                                     0x0033
#define mmGENMO_RD_BASE_IDX                                                                            1
#define mmGRPH8_IDX                                                                                    0x0033
#define mmGRPH8_IDX_BASE_IDX                                                                           1
#define mmGRPH8_DATA                                                                                   0x0033
#define mmGRPH8_DATA_BASE_IDX                                                                          1
#define mmCRTC8_IDX_1                                                                                  0x0035
#define mmCRTC8_IDX_1_BASE_IDX                                                                         1
#define mmCRTC8_DATA_1                                                                                 0x0035
#define mmCRTC8_DATA_1_BASE_IDX                                                                        1
#define mmGENFC_WT_1                                                                                   0x0036
#define mmGENFC_WT_1_BASE_IDX                                                                          1
#define mmGENS1_1                                                                                      0x0036
#define mmGENS1_1_BASE_IDX                                                                             1
#define mmD3VGA_CONTROL                                                                                0x0038
#define mmD3VGA_CONTROL_BASE_IDX                                                                       1
#define mmD4VGA_CONTROL                                                                                0x0039
#define mmD4VGA_CONTROL_BASE_IDX                                                                       1
#define mmD5VGA_CONTROL                                                                                0x003a
#define mmD5VGA_CONTROL_BASE_IDX                                                                       1
#define mmD6VGA_CONTROL                                                                                0x003b
#define mmD6VGA_CONTROL_BASE_IDX                                                                       1
#define mmVGA_SOURCE_SELECT                                                                            0x003c
#define mmVGA_SOURCE_SELECT_BASE_IDX                                                                   1


// addressBlock: dce_dc_dccg_dccg_dispdec
// base address: 0x0
#define mmPHYPLLA_PIXCLK_RESYNC_CNTL                                                                   0x0040
#define mmPHYPLLA_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define mmPHYPLLB_PIXCLK_RESYNC_CNTL                                                                   0x0041
#define mmPHYPLLB_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define mmPHYPLLC_PIXCLK_RESYNC_CNTL                                                                   0x0042
#define mmPHYPLLC_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define mmPHYPLLD_PIXCLK_RESYNC_CNTL                                                                   0x0043
#define mmPHYPLLD_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define mmDP_DTO_DBUF_EN                                                                               0x0044
#define mmDP_DTO_DBUF_EN_BASE_IDX                                                                      1
#define mmDSCCLK3_DTO_PARAM                                                                            0x0045
#define mmDSCCLK3_DTO_PARAM_BASE_IDX                                                                   1
#define mmDSCCLK4_DTO_PARAM                                                                            0x0046
#define mmDSCCLK4_DTO_PARAM_BASE_IDX                                                                   1
#define mmDPREFCLK_CGTT_BLK_CTRL_REG                                                                   0x0048
#define mmDPREFCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                          1
#define mmREFCLK_CNTL                                                                                  0x0049
#define mmREFCLK_CNTL_BASE_IDX                                                                         1
#define mmREFCLK_CGTT_BLK_CTRL_REG                                                                     0x004b
#define mmREFCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define mmPHYPLLE_PIXCLK_RESYNC_CNTL                                                                   0x004c
#define mmPHYPLLE_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define mmDCCG_PERFMON_CNTL2                                                                           0x004e
#define mmDCCG_PERFMON_CNTL2_BASE_IDX                                                                  1
#define mmDCCG_DS_DTO_INCR                                                                             0x0053
#define mmDCCG_DS_DTO_INCR_BASE_IDX                                                                    1
#define mmDCCG_DS_DTO_MODULO                                                                           0x0054
#define mmDCCG_DS_DTO_MODULO_BASE_IDX                                                                  1
#define mmDCCG_DS_CNTL                                                                                 0x0055
#define mmDCCG_DS_CNTL_BASE_IDX                                                                        1
#define mmDCCG_DS_HW_CAL_INTERVAL                                                                      0x0056
#define mmDCCG_DS_HW_CAL_INTERVAL_BASE_IDX                                                             1
#define mmDPREFCLK_CNTL                                                                                0x0058
#define mmDPREFCLK_CNTL_BASE_IDX                                                                       1
#define mmDCE_VERSION                                                                                  0x005e
#define mmDCE_VERSION_BASE_IDX                                                                         1
#define mmDCCG_GTC_CNTL                                                                                0x0060
#define mmDCCG_GTC_CNTL_BASE_IDX                                                                       1
#define mmDCCG_GTC_DTO_INCR                                                                            0x0061
#define mmDCCG_GTC_DTO_INCR_BASE_IDX                                                                   1
#define mmDCCG_GTC_DTO_MODULO                                                                          0x0062
#define mmDCCG_GTC_DTO_MODULO_BASE_IDX                                                                 1
#define mmDCCG_GTC_CURRENT                                                                             0x0063
#define mmDCCG_GTC_CURRENT_BASE_IDX                                                                    1
#define mmDSCCLK0_DTO_PARAM                                                                            0x006c
#define mmDSCCLK0_DTO_PARAM_BASE_IDX                                                                   1
#define mmDSCCLK1_DTO_PARAM                                                                            0x006d
#define mmDSCCLK1_DTO_PARAM_BASE_IDX                                                                   1
#define mmDSCCLK2_DTO_PARAM                                                                            0x006e
#define mmDSCCLK2_DTO_PARAM_BASE_IDX                                                                   1
#define mmMILLISECOND_TIME_BASE_DIV                                                                    0x0070
#define mmMILLISECOND_TIME_BASE_DIV_BASE_IDX                                                           1
#define mmDISPCLK_FREQ_CHANGE_CNTL                                                                     0x0071
#define mmDISPCLK_FREQ_CHANGE_CNTL_BASE_IDX                                                            1
#define mmDC_MEM_GLOBAL_PWR_REQ_CNTL                                                                   0x0072
#define mmDC_MEM_GLOBAL_PWR_REQ_CNTL_BASE_IDX                                                          1
#define mmDCCG_PERFMON_CNTL                                                                            0x0073
#define mmDCCG_PERFMON_CNTL_BASE_IDX                                                                   1
#define mmDCCG_GATE_DISABLE_CNTL                                                                       0x0074
#define mmDCCG_GATE_DISABLE_CNTL_BASE_IDX                                                              1
#define mmDISPCLK_CGTT_BLK_CTRL_REG                                                                    0x0075
#define mmDISPCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                           1
#define mmSOCCLK_CGTT_BLK_CTRL_REG                                                                     0x0076
#define mmSOCCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define mmDCCG_CAC_STATUS                                                                              0x0077
#define mmDCCG_CAC_STATUS_BASE_IDX                                                                     1
#define mmMICROSECOND_TIME_BASE_DIV                                                                    0x007b
#define mmMICROSECOND_TIME_BASE_DIV_BASE_IDX                                                           1
#define mmDCCG_GATE_DISABLE_CNTL2                                                                      0x007c
#define mmDCCG_GATE_DISABLE_CNTL2_BASE_IDX                                                             1
#define mmSYMCLK_CGTT_BLK_CTRL_REG                                                                     0x007d
#define mmSYMCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define mmDCCG_DISP_CNTL_REG                                                                           0x007f
#define mmDCCG_DISP_CNTL_REG_BASE_IDX                                                                  1
#define mmOTG0_PIXEL_RATE_CNTL                                                                         0x0080
#define mmOTG0_PIXEL_RATE_CNTL_BASE_IDX                                                                1
#define mmDP_DTO0_PHASE                                                                                0x0081
#define mmDP_DTO0_PHASE_BASE_IDX                                                                       1
#define mmDP_DTO0_MODULO                                                                               0x0082
#define mmDP_DTO0_MODULO_BASE_IDX                                                                      1
#define mmOTG0_PHYPLL_PIXEL_RATE_CNTL                                                                  0x0083
#define mmOTG0_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                         1
#define mmOTG1_PIXEL_RATE_CNTL                                                                         0x0084
#define mmOTG1_PIXEL_RATE_CNTL_BASE_IDX                                                                1
#define mmDP_DTO1_PHASE                                                                                0x0085
#define mmDP_DTO1_PHASE_BASE_IDX                                                                       1
#define mmDP_DTO1_MODULO                                                                               0x0086
#define mmDP_DTO1_MODULO_BASE_IDX                                                                      1
#define mmOTG1_PHYPLL_PIXEL_RATE_CNTL                                                                  0x0087
#define mmOTG1_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                         1
#define mmOTG2_PIXEL_RATE_CNTL                                                                         0x0088
#define mmOTG2_PIXEL_RATE_CNTL_BASE_IDX                                                                1
#define mmDP_DTO2_PHASE                                                                                0x0089
#define mmDP_DTO2_PHASE_BASE_IDX                                                                       1
#define mmDP_DTO2_MODULO                                                                               0x008a
#define mmDP_DTO2_MODULO_BASE_IDX                                                                      1
#define mmOTG2_PHYPLL_PIXEL_RATE_CNTL                                                                  0x008b
#define mmOTG2_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                         1
#define mmOTG3_PIXEL_RATE_CNTL                                                                         0x008c
#define mmOTG3_PIXEL_RATE_CNTL_BASE_IDX                                                                1
#define mmDP_DTO3_PHASE                                                                                0x008d
#define mmDP_DTO3_PHASE_BASE_IDX                                                                       1
#define mmDP_DTO3_MODULO                                                                               0x008e
#define mmDP_DTO3_MODULO_BASE_IDX                                                                      1
#define mmOTG3_PHYPLL_PIXEL_RATE_CNTL                                                                  0x008f
#define mmOTG3_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                         1
#define mmOTG4_PIXEL_RATE_CNTL                                                                         0x0090
#define mmOTG4_PIXEL_RATE_CNTL_BASE_IDX                                                                1
#define mmDP_DTO4_PHASE                                                                                0x0091
#define mmDP_DTO4_PHASE_BASE_IDX                                                                       1
#define mmDP_DTO4_MODULO                                                                               0x0092
#define mmDP_DTO4_MODULO_BASE_IDX                                                                      1
#define mmOTG4_PHYPLL_PIXEL_RATE_CNTL                                                                  0x0093
#define mmOTG4_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                         1
#define mmDPPCLK_CGTT_BLK_CTRL_REG                                                                     0x0098
#define mmDPPCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define mmDPPCLK0_DTO_PARAM                                                                            0x0099
#define mmDPPCLK0_DTO_PARAM_BASE_IDX                                                                   1
#define mmDPPCLK1_DTO_PARAM                                                                            0x009a
#define mmDPPCLK1_DTO_PARAM_BASE_IDX                                                                   1
#define mmDPPCLK2_DTO_PARAM                                                                            0x009b
#define mmDPPCLK2_DTO_PARAM_BASE_IDX                                                                   1
#define mmDPPCLK3_DTO_PARAM                                                                            0x009c
#define mmDPPCLK3_DTO_PARAM_BASE_IDX                                                                   1
#define mmDPPCLK4_DTO_PARAM                                                                            0x009d
#define mmDPPCLK4_DTO_PARAM_BASE_IDX                                                                   1
#define mmDCCG_CAC_STATUS2                                                                             0x009f
#define mmDCCG_CAC_STATUS2_BASE_IDX                                                                    1
#define mmSYMCLKA_CLOCK_ENABLE                                                                         0x00a0
#define mmSYMCLKA_CLOCK_ENABLE_BASE_IDX                                                                1
#define mmSYMCLKB_CLOCK_ENABLE                                                                         0x00a1
#define mmSYMCLKB_CLOCK_ENABLE_BASE_IDX                                                                1
#define mmSYMCLKC_CLOCK_ENABLE                                                                         0x00a2
#define mmSYMCLKC_CLOCK_ENABLE_BASE_IDX                                                                1
#define mmSYMCLKD_CLOCK_ENABLE                                                                         0x00a3
#define mmSYMCLKD_CLOCK_ENABLE_BASE_IDX                                                                1
#define mmSYMCLKE_CLOCK_ENABLE                                                                         0x00a4
#define mmSYMCLKE_CLOCK_ENABLE_BASE_IDX                                                                1
#define mmDCCG_SOFT_RESET                                                                              0x00a6
#define mmDCCG_SOFT_RESET_BASE_IDX                                                                     1
#define mmDSCCLK_DTO_CTRL                                                                              0x00a7
#define mmDSCCLK_DTO_CTRL_BASE_IDX                                                                     1
#define mmDCCG_AUDIO_DTO_SOURCE                                                                        0x00ab
#define mmDCCG_AUDIO_DTO_SOURCE_BASE_IDX                                                               1
#define mmDCCG_AUDIO_DTO0_PHASE                                                                        0x00ac
#define mmDCCG_AUDIO_DTO0_PHASE_BASE_IDX                                                               1
#define mmDCCG_AUDIO_DTO0_MODULE                                                                       0x00ad
#define mmDCCG_AUDIO_DTO0_MODULE_BASE_IDX                                                              1
#define mmDCCG_AUDIO_DTO1_PHASE                                                                        0x00ae
#define mmDCCG_AUDIO_DTO1_PHASE_BASE_IDX                                                               1
#define mmDCCG_AUDIO_DTO1_MODULE                                                                       0x00af
#define mmDCCG_AUDIO_DTO1_MODULE_BASE_IDX                                                              1
#define mmDCCG_VSYNC_OTG0_LATCH_VALUE                                                                  0x00b0
#define mmDCCG_VSYNC_OTG0_LATCH_VALUE_BASE_IDX                                                         1
#define mmDCCG_VSYNC_OTG1_LATCH_VALUE                                                                  0x00b1
#define mmDCCG_VSYNC_OTG1_LATCH_VALUE_BASE_IDX                                                         1
#define mmDCCG_VSYNC_OTG2_LATCH_VALUE                                                                  0x00b2
#define mmDCCG_VSYNC_OTG2_LATCH_VALUE_BASE_IDX                                                         1
#define mmDCCG_VSYNC_OTG3_LATCH_VALUE                                                                  0x00b3
#define mmDCCG_VSYNC_OTG3_LATCH_VALUE_BASE_IDX                                                         1
#define mmDCCG_VSYNC_OTG4_LATCH_VALUE                                                                  0x00b4
#define mmDCCG_VSYNC_OTG4_LATCH_VALUE_BASE_IDX                                                         1
#define mmDCCG_VSYNC_OTG5_LATCH_VALUE                                                                  0x00b5
#define mmDCCG_VSYNC_OTG5_LATCH_VALUE_BASE_IDX                                                         1
#define mmDPPCLK_DTO_CTRL                                                                              0x00b6
#define mmDPPCLK_DTO_CTRL_BASE_IDX                                                                     1
#define mmDCCG_VSYNC_CNT_CTRL                                                                          0x00b8
#define mmDCCG_VSYNC_CNT_CTRL_BASE_IDX                                                                 1
#define mmDCCG_VSYNC_CNT_INT_CTRL                                                                      0x00b9
#define mmDCCG_VSYNC_CNT_INT_CTRL_BASE_IDX                                                             1
#define mmFORCE_SYMCLK_DISABLE                                                                         0x00ba
#define mmFORCE_SYMCLK_DISABLE_BASE_IDX                                                                1
#define mmPHYASYMCLK_CLOCK_CNTL                                                                        0x0052
#define mmPHYASYMCLK_CLOCK_CNTL_BASE_IDX                                                               2
#define mmPHYBSYMCLK_CLOCK_CNTL                                                                        0x0053
#define mmPHYBSYMCLK_CLOCK_CNTL_BASE_IDX                                                               2
#define mmPHYCSYMCLK_CLOCK_CNTL                                                                        0x0054
#define mmPHYCSYMCLK_CLOCK_CNTL_BASE_IDX                                                               2
#define mmPHYDSYMCLK_CLOCK_CNTL                                                                        0x0055
#define mmPHYDSYMCLK_CLOCK_CNTL_BASE_IDX                                                               2
#define mmPHYESYMCLK_CLOCK_CNTL                                                                        0x0056
#define mmPHYESYMCLK_CLOCK_CNTL_BASE_IDX                                                               2


// addressBlock: dce_dc_dccg_dccg_dfs_dispdec
// base address: 0x0
#define mmDENTIST_DISPCLK_CNTL                                                                         0x0064
#define mmDENTIST_DISPCLK_CNTL_BASE_IDX                                                                1


// addressBlock: dce_dc_dccg_dccg_dcperfmon0_dc_perfmon_dispdec
// base address: 0x0
#define mmDC_PERFMON0_PERFCOUNTER_CNTL                                                                 0x0000
#define mmDC_PERFMON0_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON0_PERFCOUNTER_CNTL2                                                                0x0001
#define mmDC_PERFMON0_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON0_PERFCOUNTER_STATE                                                                0x0002
#define mmDC_PERFMON0_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON0_PERFMON_CNTL                                                                     0x0003
#define mmDC_PERFMON0_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON0_PERFMON_CNTL2                                                                    0x0004
#define mmDC_PERFMON0_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON0_PERFMON_CVALUE_INT_MISC                                                          0x0005
#define mmDC_PERFMON0_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON0_PERFMON_CVALUE_LOW                                                               0x0006
#define mmDC_PERFMON0_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON0_PERFMON_HI                                                                       0x0007
#define mmDC_PERFMON0_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON0_PERFMON_LOW                                                                      0x0008
#define mmDC_PERFMON0_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dccg_dccg_dcperfmon1_dc_perfmon_dispdec
// base address: 0x30
#define mmDC_PERFMON1_PERFCOUNTER_CNTL                                                                 0x000c
#define mmDC_PERFMON1_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON1_PERFCOUNTER_CNTL2                                                                0x000d
#define mmDC_PERFMON1_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON1_PERFCOUNTER_STATE                                                                0x000e
#define mmDC_PERFMON1_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON1_PERFMON_CNTL                                                                     0x000f
#define mmDC_PERFMON1_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON1_PERFMON_CNTL2                                                                    0x0010
#define mmDC_PERFMON1_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON1_PERFMON_CVALUE_INT_MISC                                                          0x0011
#define mmDC_PERFMON1_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON1_PERFMON_CVALUE_LOW                                                               0x0012
#define mmDC_PERFMON1_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON1_PERFMON_HI                                                                       0x0013
#define mmDC_PERFMON1_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON1_PERFMON_LOW                                                                      0x0014
#define mmDC_PERFMON1_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dmu_dc_pg_dispdec
// base address: 0x0
#define mmDOMAIN0_PG_CONFIG                                                                            0x0080
#define mmDOMAIN0_PG_CONFIG_BASE_IDX                                                                   2
#define mmDOMAIN0_PG_STATUS                                                                            0x0081
#define mmDOMAIN0_PG_STATUS_BASE_IDX                                                                   2
#define mmDOMAIN1_PG_CONFIG                                                                            0x0082
#define mmDOMAIN1_PG_CONFIG_BASE_IDX                                                                   2
#define mmDOMAIN1_PG_STATUS                                                                            0x0083
#define mmDOMAIN1_PG_STATUS_BASE_IDX                                                                   2
#define mmDOMAIN2_PG_CONFIG                                                                            0x0084
#define mmDOMAIN2_PG_CONFIG_BASE_IDX                                                                   2
#define mmDOMAIN2_PG_STATUS                                                                            0x0085
#define mmDOMAIN2_PG_STATUS_BASE_IDX                                                                   2
#define mmDOMAIN3_PG_CONFIG                                                                            0x0086
#define mmDOMAIN3_PG_CONFIG_BASE_IDX                                                                   2
#define mmDOMAIN3_PG_STATUS                                                                            0x0087
#define mmDOMAIN3_PG_STATUS_BASE_IDX                                                                   2
#define mmDOMAIN4_PG_CONFIG                                                                            0x0088
#define mmDOMAIN4_PG_CONFIG_BASE_IDX                                                                   2
#define mmDOMAIN4_PG_STATUS                                                                            0x0089
#define mmDOMAIN4_PG_STATUS_BASE_IDX                                                                   2
#define mmDOMAIN5_PG_CONFIG                                                                            0x008a
#define mmDOMAIN5_PG_CONFIG_BASE_IDX                                                                   2
#define mmDOMAIN5_PG_STATUS                                                                            0x008b
#define mmDOMAIN5_PG_STATUS_BASE_IDX                                                                   2
#define mmDOMAIN6_PG_CONFIG                                                                            0x008c
#define mmDOMAIN6_PG_CONFIG_BASE_IDX                                                                   2
#define mmDOMAIN6_PG_STATUS                                                                            0x008d
#define mmDOMAIN6_PG_STATUS_BASE_IDX                                                                   2
#define mmDOMAIN7_PG_CONFIG                                                                            0x008e
#define mmDOMAIN7_PG_CONFIG_BASE_IDX                                                                   2
#define mmDOMAIN7_PG_STATUS                                                                            0x008f
#define mmDOMAIN7_PG_STATUS_BASE_IDX                                                                   2
#define mmDOMAIN8_PG_CONFIG                                                                            0x0090
#define mmDOMAIN8_PG_CONFIG_BASE_IDX                                                                   2
#define mmDOMAIN8_PG_STATUS                                                                            0x0091
#define mmDOMAIN8_PG_STATUS_BASE_IDX                                                                   2
#define mmDOMAIN9_PG_CONFIG                                                                            0x0092
#define mmDOMAIN9_PG_CONFIG_BASE_IDX                                                                   2
#define mmDOMAIN9_PG_STATUS                                                                            0x0093
#define mmDOMAIN9_PG_STATUS_BASE_IDX                                                                   2
#define mmDOMAIN16_PG_CONFIG                                                                           0x00a1
#define mmDOMAIN16_PG_CONFIG_BASE_IDX                                                                  2
#define mmDOMAIN16_PG_STATUS                                                                           0x00a2
#define mmDOMAIN16_PG_STATUS_BASE_IDX                                                                  2
#define mmDOMAIN17_PG_CONFIG                                                                           0x00a3
#define mmDOMAIN17_PG_CONFIG_BASE_IDX                                                                  2
#define mmDOMAIN17_PG_STATUS                                                                           0x00a4
#define mmDOMAIN17_PG_STATUS_BASE_IDX                                                                  2
#define mmDOMAIN18_PG_CONFIG                                                                           0x00a5
#define mmDOMAIN18_PG_CONFIG_BASE_IDX                                                                  2
#define mmDOMAIN18_PG_STATUS                                                                           0x00a6
#define mmDOMAIN18_PG_STATUS_BASE_IDX                                                                  2
#define mmDOMAIN19_PG_CONFIG                                                                           0x00a7
#define mmDOMAIN19_PG_CONFIG_BASE_IDX                                                                  2
#define mmDOMAIN19_PG_STATUS                                                                           0x00a8
#define mmDOMAIN19_PG_STATUS_BASE_IDX                                                                  2
#define mmDOMAIN20_PG_CONFIG                                                                           0x00a9
#define mmDOMAIN20_PG_CONFIG_BASE_IDX                                                                  2
#define mmDOMAIN20_PG_STATUS                                                                           0x00aa
#define mmDOMAIN20_PG_STATUS_BASE_IDX                                                                  2
#define mmDCPG_INTERRUPT_STATUS                                                                        0x00ad
#define mmDCPG_INTERRUPT_STATUS_BASE_IDX                                                               2
#define mmDCPG_INTERRUPT_STATUS_2                                                                      0x00ae
#define mmDCPG_INTERRUPT_STATUS_2_BASE_IDX                                                             2
#define mmDCPG_INTERRUPT_CONTROL_1                                                                     0x00af
#define mmDCPG_INTERRUPT_CONTROL_1_BASE_IDX                                                            2
#define mmDCPG_INTERRUPT_CONTROL_2                                                                     0x00b0
#define mmDCPG_INTERRUPT_CONTROL_2_BASE_IDX                                                            2
#define mmDCPG_INTERRUPT_CONTROL_3                                                                     0x00b1
#define mmDCPG_INTERRUPT_CONTROL_3_BASE_IDX                                                            2
#define mmDC_IP_REQUEST_CNTL                                                                           0x00b2
#define mmDC_IP_REQUEST_CNTL_BASE_IDX                                                                  2


// addressBlock: dce_dc_dmu_dmu_dcperfmon_dc_perfmon_dispdec
// base address: 0x2f8
#define mmDC_PERFMON2_PERFCOUNTER_CNTL                                                                 0x00be
#define mmDC_PERFMON2_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON2_PERFCOUNTER_CNTL2                                                                0x00bf
#define mmDC_PERFMON2_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON2_PERFCOUNTER_STATE                                                                0x00c0
#define mmDC_PERFMON2_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON2_PERFMON_CNTL                                                                     0x00c1
#define mmDC_PERFMON2_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON2_PERFMON_CNTL2                                                                    0x00c2
#define mmDC_PERFMON2_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON2_PERFMON_CVALUE_INT_MISC                                                          0x00c3
#define mmDC_PERFMON2_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON2_PERFMON_CVALUE_LOW                                                               0x00c4
#define mmDC_PERFMON2_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON2_PERFMON_HI                                                                       0x00c5
#define mmDC_PERFMON2_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON2_PERFMON_LOW                                                                      0x00c6
#define mmDC_PERFMON2_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dmu_dmu_misc_dispdec
// base address: 0x0
#define mmCC_DC_PIPE_DIS                                                                               0x00ca
#define mmCC_DC_PIPE_DIS_BASE_IDX                                                                      2
#define mmDMU_CLK_CNTL                                                                                 0x00cb
#define mmDMU_CLK_CNTL_BASE_IDX                                                                        2
#define mmDMU_MEM_PWR_CNTL                                                                             0x00cc
#define mmDMU_MEM_PWR_CNTL_BASE_IDX                                                                    2
#define mmDMCU_SMU_INTERRUPT_CNTL                                                                      0x00cd
#define mmDMCU_SMU_INTERRUPT_CNTL_BASE_IDX                                                             2
#define mmSMU_INTERRUPT_CONTROL                                                                        0x00ce
#define mmSMU_INTERRUPT_CONTROL_BASE_IDX                                                               2
#define mmDMU_MISC_ALLOW_DS_FORCE                                                                      0x00d6
#define mmDMU_MISC_ALLOW_DS_FORCE_BASE_IDX                                                             2


// addressBlock: dce_dc_dmu_dmcu_dispdec
// base address: 0x0
#define mmDMCU_CTRL                                                                                    0x00da
#define mmDMCU_CTRL_BASE_IDX                                                                           2
#define mmDMCU_STATUS                                                                                  0x00db
#define mmDMCU_STATUS_BASE_IDX                                                                         2
#define mmDMCU_PC_START_ADDR                                                                           0x00dc
#define mmDMCU_PC_START_ADDR_BASE_IDX                                                                  2
#define mmDMCU_FW_START_ADDR                                                                           0x00dd
#define mmDMCU_FW_START_ADDR_BASE_IDX                                                                  2
#define mmDMCU_FW_END_ADDR                                                                             0x00de
#define mmDMCU_FW_END_ADDR_BASE_IDX                                                                    2
#define mmDMCU_FW_ISR_START_ADDR                                                                       0x00df
#define mmDMCU_FW_ISR_START_ADDR_BASE_IDX                                                              2
#define mmDMCU_FW_CS_HI                                                                                0x00e0
#define mmDMCU_FW_CS_HI_BASE_IDX                                                                       2
#define mmDMCU_FW_CS_LO                                                                                0x00e1
#define mmDMCU_FW_CS_LO_BASE_IDX                                                                       2
#define mmDMCU_RAM_ACCESS_CTRL                                                                         0x00e2
#define mmDMCU_RAM_ACCESS_CTRL_BASE_IDX                                                                2
#define mmDMCU_ERAM_WR_CTRL                                                                            0x00e3
#define mmDMCU_ERAM_WR_CTRL_BASE_IDX                                                                   2
#define mmDMCU_ERAM_WR_DATA                                                                            0x00e4
#define mmDMCU_ERAM_WR_DATA_BASE_IDX                                                                   2
#define mmDMCU_ERAM_RD_CTRL                                                                            0x00e5
#define mmDMCU_ERAM_RD_CTRL_BASE_IDX                                                                   2
#define mmDMCU_ERAM_RD_DATA                                                                            0x00e6
#define mmDMCU_ERAM_RD_DATA_BASE_IDX                                                                   2
#define mmDMCU_IRAM_WR_CTRL                                                                            0x00e7
#define mmDMCU_IRAM_WR_CTRL_BASE_IDX                                                                   2
#define mmDMCU_IRAM_WR_DATA                                                                            0x00e8
#define mmDMCU_IRAM_WR_DATA_BASE_IDX                                                                   2
#define mmDMCU_IRAM_RD_CTRL                                                                            0x00e9
#define mmDMCU_IRAM_RD_CTRL_BASE_IDX                                                                   2
#define mmDMCU_IRAM_RD_DATA                                                                            0x00ea
#define mmDMCU_IRAM_RD_DATA_BASE_IDX                                                                   2
#define mmDMCU_EVENT_TRIGGER                                                                           0x00eb
#define mmDMCU_EVENT_TRIGGER_BASE_IDX                                                                  2
#define mmDMCU_UC_INTERNAL_INT_STATUS                                                                  0x00ec
#define mmDMCU_UC_INTERNAL_INT_STATUS_BASE_IDX                                                         2
#define mmDMCU_SS_INTERRUPT_CNTL_STATUS                                                                0x00ed
#define mmDMCU_SS_INTERRUPT_CNTL_STATUS_BASE_IDX                                                       2
#define mmDMCU_INTERRUPT_STATUS                                                                        0x00ee
#define mmDMCU_INTERRUPT_STATUS_BASE_IDX                                                               2
#define mmDMCU_INTERRUPT_STATUS_1                                                                      0x00ef
#define mmDMCU_INTERRUPT_STATUS_1_BASE_IDX                                                             2
#define mmDMCU_INTERRUPT_TO_HOST_EN_MASK                                                               0x00f0
#define mmDMCU_INTERRUPT_TO_HOST_EN_MASK_BASE_IDX                                                      2
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK                                                                 0x00f1
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_BASE_IDX                                                        2
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_1                                                               0x00f2
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_1_BASE_IDX                                                      2
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL                                                            0x00f3
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_BASE_IDX                                                   2
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1                                                          0x00f4
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1_BASE_IDX                                                 2
#define mmDC_DMCU_SCRATCH                                                                              0x00f5
#define mmDC_DMCU_SCRATCH_BASE_IDX                                                                     2
#define mmDMCU_INT_CNT                                                                                 0x00f6
#define mmDMCU_INT_CNT_BASE_IDX                                                                        2
#define mmDMCU_FW_CHECKSUM_SMPL_BYTE_POS                                                               0x00f7
#define mmDMCU_FW_CHECKSUM_SMPL_BYTE_POS_BASE_IDX                                                      2
#define mmDMCU_UC_CLK_GATING_CNTL                                                                      0x00f8
#define mmDMCU_UC_CLK_GATING_CNTL_BASE_IDX                                                             2
#define mmMASTER_COMM_DATA_REG1                                                                        0x00f9
#define mmMASTER_COMM_DATA_REG1_BASE_IDX                                                               2
#define mmMASTER_COMM_DATA_REG2                                                                        0x00fa
#define mmMASTER_COMM_DATA_REG2_BASE_IDX                                                               2
#define mmMASTER_COMM_DATA_REG3                                                                        0x00fb
#define mmMASTER_COMM_DATA_REG3_BASE_IDX                                                               2
#define mmMASTER_COMM_CMD_REG                                                                          0x00fc
#define mmMASTER_COMM_CMD_REG_BASE_IDX                                                                 2
#define mmMASTER_COMM_CNTL_REG                                                                         0x00fd
#define mmMASTER_COMM_CNTL_REG_BASE_IDX                                                                2
#define mmSLAVE_COMM_DATA_REG1                                                                         0x00fe
#define mmSLAVE_COMM_DATA_REG1_BASE_IDX                                                                2
#define mmSLAVE_COMM_DATA_REG2                                                                         0x00ff
#define mmSLAVE_COMM_DATA_REG2_BASE_IDX                                                                2
#define mmSLAVE_COMM_DATA_REG3                                                                         0x0100
#define mmSLAVE_COMM_DATA_REG3_BASE_IDX                                                                2
#define mmSLAVE_COMM_CMD_REG                                                                           0x0101
#define mmSLAVE_COMM_CMD_REG_BASE_IDX                                                                  2
#define mmSLAVE_COMM_CNTL_REG                                                                          0x0102
#define mmSLAVE_COMM_CNTL_REG_BASE_IDX                                                                 2
#define mmDMCU_PERFMON_INTERRUPT_STATUS1                                                               0x0105
#define mmDMCU_PERFMON_INTERRUPT_STATUS1_BASE_IDX                                                      2
#define mmDMCU_PERFMON_INTERRUPT_STATUS2                                                               0x0106
#define mmDMCU_PERFMON_INTERRUPT_STATUS2_BASE_IDX                                                      2
#define mmDMCU_PERFMON_INTERRUPT_STATUS3                                                               0x0107
#define mmDMCU_PERFMON_INTERRUPT_STATUS3_BASE_IDX                                                      2
#define mmDMCU_PERFMON_INTERRUPT_STATUS4                                                               0x0108
#define mmDMCU_PERFMON_INTERRUPT_STATUS4_BASE_IDX                                                      2
#define mmDMCU_PERFMON_INTERRUPT_STATUS5                                                               0x0109
#define mmDMCU_PERFMON_INTERRUPT_STATUS5_BASE_IDX                                                      2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1                                                        0x010a
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2                                                        0x010b
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3                                                        0x010c
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4                                                        0x010d
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5                                                        0x010e
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1                                                   0x010f
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1_BASE_IDX                                          2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2                                                   0x0110
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2_BASE_IDX                                          2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3                                                   0x0111
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3_BASE_IDX                                          2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4                                                   0x0112
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4_BASE_IDX                                          2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5                                                   0x0113
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5_BASE_IDX                                          2
#define mmDMCU_DPRX_INTERRUPT_STATUS1                                                                  0x0114
#define mmDMCU_DPRX_INTERRUPT_STATUS1_BASE_IDX                                                         2
#define mmDMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1                                                           0x0115
#define mmDMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1_BASE_IDX                                                  2
#define mmDMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1                                                      0x0116
#define mmDMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1_BASE_IDX                                             2
#define mmDMCU_INTERRUPT_STATUS_CONTINUE                                                               0x0119
#define mmDMCU_INTERRUPT_STATUS_CONTINUE_BASE_IDX                                                      2
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE                                                        0x011a
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_CONTINUE_BASE_IDX                                               2
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE                                                   0x011b
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONTINUE_BASE_IDX                                          2
#define mmDMCU_INT_CNT_CONTINUE                                                                        0x011c
#define mmDMCU_INT_CNT_CONTINUE_BASE_IDX                                                               2
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONT2                                                      0x011d
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_CONT2_BASE_IDX                                             2
#define mmDMCU_INTERRUPT_STATUS_2                                                                      0x011e
#define mmDMCU_INTERRUPT_STATUS_2_BASE_IDX                                                             2
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_2                                                               0x011f
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_2_BASE_IDX                                                      2
#define mmDMCU_INT_CNT_CONT2                                                                           0x0120
#define mmDMCU_INT_CNT_CONT2_BASE_IDX                                                                  2
#define mmDMCU_INT_CNT_CONT3                                                                           0x0121
#define mmDMCU_INT_CNT_CONT3_BASE_IDX                                                                  2
#define mmDMCU_INT_CNT_CONT4                                                                           0x0122
#define mmDMCU_INT_CNT_CONT4_BASE_IDX                                                                  2


// addressBlock: dce_dc_dmu_ihc_dispdec
// base address: 0x0
#define mmDC_GPU_TIMER_START_POSITION_V_UPDATE                                                         0x0126
#define mmDC_GPU_TIMER_START_POSITION_V_UPDATE_BASE_IDX                                                2
#define mmDC_GPU_TIMER_START_POSITION_VSTARTUP                                                         0x0127
#define mmDC_GPU_TIMER_START_POSITION_VSTARTUP_BASE_IDX                                                2
#define mmDC_GPU_TIMER_READ                                                                            0x0128
#define mmDC_GPU_TIMER_READ_BASE_IDX                                                                   2
#define mmDC_GPU_TIMER_READ_CNTL                                                                       0x0129
#define mmDC_GPU_TIMER_READ_CNTL_BASE_IDX                                                              2
#define mmDISP_INTERRUPT_STATUS                                                                        0x012a
#define mmDISP_INTERRUPT_STATUS_BASE_IDX                                                               2
#define mmDISP_INTERRUPT_STATUS_CONTINUE                                                               0x012b
#define mmDISP_INTERRUPT_STATUS_CONTINUE_BASE_IDX                                                      2
#define mmDISP_INTERRUPT_STATUS_CONTINUE2                                                              0x012c
#define mmDISP_INTERRUPT_STATUS_CONTINUE2_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE3                                                              0x012d
#define mmDISP_INTERRUPT_STATUS_CONTINUE3_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE4                                                              0x012e
#define mmDISP_INTERRUPT_STATUS_CONTINUE4_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE5                                                              0x012f
#define mmDISP_INTERRUPT_STATUS_CONTINUE5_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE6                                                              0x0130
#define mmDISP_INTERRUPT_STATUS_CONTINUE6_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE7                                                              0x0131
#define mmDISP_INTERRUPT_STATUS_CONTINUE7_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE8                                                              0x0132
#define mmDISP_INTERRUPT_STATUS_CONTINUE8_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE9                                                              0x0133
#define mmDISP_INTERRUPT_STATUS_CONTINUE9_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE10                                                             0x0134
#define mmDISP_INTERRUPT_STATUS_CONTINUE10_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE11                                                             0x0135
#define mmDISP_INTERRUPT_STATUS_CONTINUE11_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE12                                                             0x0136
#define mmDISP_INTERRUPT_STATUS_CONTINUE12_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE13                                                             0x0137
#define mmDISP_INTERRUPT_STATUS_CONTINUE13_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE14                                                             0x0138
#define mmDISP_INTERRUPT_STATUS_CONTINUE14_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE15                                                             0x0139
#define mmDISP_INTERRUPT_STATUS_CONTINUE15_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE16                                                             0x013a
#define mmDISP_INTERRUPT_STATUS_CONTINUE16_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE17                                                             0x013b
#define mmDISP_INTERRUPT_STATUS_CONTINUE17_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE18                                                             0x013c
#define mmDISP_INTERRUPT_STATUS_CONTINUE18_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE19                                                             0x013d
#define mmDISP_INTERRUPT_STATUS_CONTINUE19_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE20                                                             0x013e
#define mmDISP_INTERRUPT_STATUS_CONTINUE20_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE21                                                             0x013f
#define mmDISP_INTERRUPT_STATUS_CONTINUE21_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE22                                                             0x0140
#define mmDISP_INTERRUPT_STATUS_CONTINUE22_BASE_IDX                                                    2
#define mmDC_GPU_TIMER_START_POSITION_VREADY                                                           0x0141
#define mmDC_GPU_TIMER_START_POSITION_VREADY_BASE_IDX                                                  2
#define mmDC_GPU_TIMER_START_POSITION_FLIP                                                             0x0142
#define mmDC_GPU_TIMER_START_POSITION_FLIP_BASE_IDX                                                    2
#define mmDC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK                                                 0x0143
#define mmDC_GPU_TIMER_START_POSITION_V_UPDATE_NO_LOCK_BASE_IDX                                        2
#define mmDC_GPU_TIMER_START_POSITION_FLIP_AWAY                                                        0x0144
#define mmDC_GPU_TIMER_START_POSITION_FLIP_AWAY_BASE_IDX                                               2
#define mmDISP_INTERRUPT_STATUS_CONTINUE23                                                             0x0145
#define mmDISP_INTERRUPT_STATUS_CONTINUE23_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE24                                                             0x0146
#define mmDISP_INTERRUPT_STATUS_CONTINUE24_BASE_IDX                                                    2
#define mmDISP_INTERRUPT_STATUS_CONTINUE25                                                             0x0147
#define mmDISP_INTERRUPT_STATUS_CONTINUE25_BASE_IDX                                                    2
#define mmDCCG_INTERRUPT_DEST                                                                          0x0148
#define mmDCCG_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmDMU_INTERRUPT_DEST                                                                           0x0149
#define mmDMU_INTERRUPT_DEST_BASE_IDX                                                                  2
#define mmDMU_INTERRUPT_DEST2                                                                          0x014a
#define mmDMU_INTERRUPT_DEST2_BASE_IDX                                                                 2
#define mmDCPG_INTERRUPT_DEST                                                                          0x014b
#define mmDCPG_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmDCPG_INTERRUPT_DEST2                                                                         0x014c
#define mmDCPG_INTERRUPT_DEST2_BASE_IDX                                                                2
#define mmMMHUBBUB_INTERRUPT_DEST                                                                      0x014d
#define mmMMHUBBUB_INTERRUPT_DEST_BASE_IDX                                                             2
#define mmWB_INTERRUPT_DEST                                                                            0x014e
#define mmWB_INTERRUPT_DEST_BASE_IDX                                                                   2
#define mmDCHUB_INTERRUPT_DEST                                                                         0x014f
#define mmDCHUB_INTERRUPT_DEST_BASE_IDX                                                                2
#define mmDCHUB_PERFCOUNTER_INTERRUPT_DEST                                                             0x0150
#define mmDCHUB_PERFCOUNTER_INTERRUPT_DEST_BASE_IDX                                                    2
#define mmDCHUB_INTERRUPT_DEST2                                                                        0x0151
#define mmDCHUB_INTERRUPT_DEST2_BASE_IDX                                                               2
#define mmDPP_PERFCOUNTER_INTERRUPT_DEST                                                               0x0152
#define mmDPP_PERFCOUNTER_INTERRUPT_DEST_BASE_IDX                                                      2
#define mmMPC_INTERRUPT_DEST                                                                           0x0153
#define mmMPC_INTERRUPT_DEST_BASE_IDX                                                                  2
#define mmOPP_INTERRUPT_DEST                                                                           0x0154
#define mmOPP_INTERRUPT_DEST_BASE_IDX                                                                  2
#define mmOPTC_INTERRUPT_DEST                                                                          0x0155
#define mmOPTC_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmOTG0_INTERRUPT_DEST                                                                          0x0156
#define mmOTG0_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmOTG1_INTERRUPT_DEST                                                                          0x0157
#define mmOTG1_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmOTG2_INTERRUPT_DEST                                                                          0x0158
#define mmOTG2_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmOTG3_INTERRUPT_DEST                                                                          0x0159
#define mmOTG3_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmOTG4_INTERRUPT_DEST                                                                          0x015a
#define mmOTG4_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmOTG5_INTERRUPT_DEST                                                                          0x015b
#define mmOTG5_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmDIG_INTERRUPT_DEST                                                                           0x015c
#define mmDIG_INTERRUPT_DEST_BASE_IDX                                                                  2
#define mmI2C_DDC_HPD_INTERRUPT_DEST                                                                   0x015d
#define mmI2C_DDC_HPD_INTERRUPT_DEST_BASE_IDX                                                          2
#define mmDIO_INTERRUPT_DEST                                                                           0x015f
#define mmDIO_INTERRUPT_DEST_BASE_IDX                                                                  2
#define mmDCIO_INTERRUPT_DEST                                                                          0x0160
#define mmDCIO_INTERRUPT_DEST_BASE_IDX                                                                 2
#define mmHPD_INTERRUPT_DEST                                                                           0x0161
#define mmHPD_INTERRUPT_DEST_BASE_IDX                                                                  2
#define mmAZ_INTERRUPT_DEST                                                                            0x0162
#define mmAZ_INTERRUPT_DEST_BASE_IDX                                                                   2
#define mmAUX_INTERRUPT_DEST                                                                           0x0163
#define mmAUX_INTERRUPT_DEST_BASE_IDX                                                                  2
#define mmDSC_INTERRUPT_DEST                                                                           0x0164
#define mmDSC_INTERRUPT_DEST_BASE_IDX                                                                  2


// addressBlock: dce_dc_dmu_fgsec_dispdec
// base address: 0x0
#define mmDMCUB_RBBMIF_SEC_CNTL                                                                        0x017a
#define mmDMCUB_RBBMIF_SEC_CNTL_BASE_IDX                                                               2


// addressBlock: dce_dc_dmu_rbbmif_dispdec
// base address: 0x0
#define mmRBBMIF_TIMEOUT                                                                               0x017f
#define mmRBBMIF_TIMEOUT_BASE_IDX                                                                      2
#define mmRBBMIF_STATUS                                                                                0x0180
#define mmRBBMIF_STATUS_BASE_IDX                                                                       2
#define mmRBBMIF_STATUS_2                                                                              0x0181
#define mmRBBMIF_STATUS_2_BASE_IDX                                                                     2
#define mmRBBMIF_INT_STATUS                                                                            0x0182
#define mmRBBMIF_INT_STATUS_BASE_IDX                                                                   2
#define mmRBBMIF_TIMEOUT_DIS                                                                           0x0183
#define mmRBBMIF_TIMEOUT_DIS_BASE_IDX                                                                  2
#define mmRBBMIF_TIMEOUT_DIS_2                                                                         0x0184
#define mmRBBMIF_TIMEOUT_DIS_2_BASE_IDX                                                                2
#define mmRBBMIF_STATUS_FLAG                                                                           0x0185
#define mmRBBMIF_STATUS_FLAG_BASE_IDX                                                                  2


// addressBlock: dce_dc_dmu_dmcub_dispdec
// base address: 0x0
#define mmDMCUB_REGION0_OFFSET                                                                         0x018e
#define mmDMCUB_REGION0_OFFSET_BASE_IDX                                                                2
#define mmDMCUB_REGION0_OFFSET_HIGH                                                                    0x018f
#define mmDMCUB_REGION0_OFFSET_HIGH_BASE_IDX                                                           2
#define mmDMCUB_REGION1_OFFSET                                                                         0x0190
#define mmDMCUB_REGION1_OFFSET_BASE_IDX                                                                2
#define mmDMCUB_REGION1_OFFSET_HIGH                                                                    0x0191
#define mmDMCUB_REGION1_OFFSET_HIGH_BASE_IDX                                                           2
#define mmDMCUB_REGION2_OFFSET                                                                         0x0192
#define mmDMCUB_REGION2_OFFSET_BASE_IDX                                                                2
#define mmDMCUB_REGION2_OFFSET_HIGH                                                                    0x0193
#define mmDMCUB_REGION2_OFFSET_HIGH_BASE_IDX                                                           2
#define mmDMCUB_REGION4_OFFSET                                                                         0x0196
#define mmDMCUB_REGION4_OFFSET_BASE_IDX                                                                2
#define mmDMCUB_REGION4_OFFSET_HIGH                                                                    0x0197
#define mmDMCUB_REGION4_OFFSET_HIGH_BASE_IDX                                                           2
#define mmDMCUB_REGION5_OFFSET                                                                         0x0198
#define mmDMCUB_REGION5_OFFSET_BASE_IDX                                                                2
#define mmDMCUB_REGION5_OFFSET_HIGH                                                                    0x0199
#define mmDMCUB_REGION5_OFFSET_HIGH_BASE_IDX                                                           2
#define mmDMCUB_REGION6_OFFSET                                                                         0x019a
#define mmDMCUB_REGION6_OFFSET_BASE_IDX                                                                2
#define mmDMCUB_REGION6_OFFSET_HIGH                                                                    0x019b
#define mmDMCUB_REGION6_OFFSET_HIGH_BASE_IDX                                                           2
#define mmDMCUB_REGION7_OFFSET                                                                         0x019c
#define mmDMCUB_REGION7_OFFSET_BASE_IDX                                                                2
#define mmDMCUB_REGION7_OFFSET_HIGH                                                                    0x019d
#define mmDMCUB_REGION7_OFFSET_HIGH_BASE_IDX                                                           2
#define mmDMCUB_REGION0_TOP_ADDRESS                                                                    0x019e
#define mmDMCUB_REGION0_TOP_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_REGION1_TOP_ADDRESS                                                                    0x019f
#define mmDMCUB_REGION1_TOP_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_REGION2_TOP_ADDRESS                                                                    0x01a0
#define mmDMCUB_REGION2_TOP_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_REGION4_TOP_ADDRESS                                                                    0x01a1
#define mmDMCUB_REGION4_TOP_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_REGION5_TOP_ADDRESS                                                                    0x01a2
#define mmDMCUB_REGION5_TOP_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_REGION6_TOP_ADDRESS                                                                    0x01a3
#define mmDMCUB_REGION6_TOP_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_REGION7_TOP_ADDRESS                                                                    0x01a4
#define mmDMCUB_REGION7_TOP_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_REGION3_CW0_BASE_ADDRESS                                                               0x01a5
#define mmDMCUB_REGION3_CW0_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW1_BASE_ADDRESS                                                               0x01a6
#define mmDMCUB_REGION3_CW1_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW2_BASE_ADDRESS                                                               0x01a7
#define mmDMCUB_REGION3_CW2_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW3_BASE_ADDRESS                                                               0x01a8
#define mmDMCUB_REGION3_CW3_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW4_BASE_ADDRESS                                                               0x01a9
#define mmDMCUB_REGION3_CW4_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW5_BASE_ADDRESS                                                               0x01aa
#define mmDMCUB_REGION3_CW5_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW6_BASE_ADDRESS                                                               0x01ab
#define mmDMCUB_REGION3_CW6_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW7_BASE_ADDRESS                                                               0x01ac
#define mmDMCUB_REGION3_CW7_BASE_ADDRESS_BASE_IDX                                                      2
#define mmDMCUB_REGION3_CW0_TOP_ADDRESS                                                                0x01ad
#define mmDMCUB_REGION3_CW0_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW1_TOP_ADDRESS                                                                0x01ae
#define mmDMCUB_REGION3_CW1_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW2_TOP_ADDRESS                                                                0x01af
#define mmDMCUB_REGION3_CW2_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW3_TOP_ADDRESS                                                                0x01b0
#define mmDMCUB_REGION3_CW3_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW4_TOP_ADDRESS                                                                0x01b1
#define mmDMCUB_REGION3_CW4_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW5_TOP_ADDRESS                                                                0x01b2
#define mmDMCUB_REGION3_CW5_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW6_TOP_ADDRESS                                                                0x01b3
#define mmDMCUB_REGION3_CW6_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW7_TOP_ADDRESS                                                                0x01b4
#define mmDMCUB_REGION3_CW7_TOP_ADDRESS_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW0_OFFSET                                                                     0x01b5
#define mmDMCUB_REGION3_CW0_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW0_OFFSET_HIGH                                                                0x01b6
#define mmDMCUB_REGION3_CW0_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW1_OFFSET                                                                     0x01b7
#define mmDMCUB_REGION3_CW1_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW1_OFFSET_HIGH                                                                0x01b8
#define mmDMCUB_REGION3_CW1_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW2_OFFSET                                                                     0x01b9
#define mmDMCUB_REGION3_CW2_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW2_OFFSET_HIGH                                                                0x01ba
#define mmDMCUB_REGION3_CW2_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW3_OFFSET                                                                     0x01bb
#define mmDMCUB_REGION3_CW3_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW3_OFFSET_HIGH                                                                0x01bc
#define mmDMCUB_REGION3_CW3_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW4_OFFSET                                                                     0x01bd
#define mmDMCUB_REGION3_CW4_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW4_OFFSET_HIGH                                                                0x01be
#define mmDMCUB_REGION3_CW4_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW5_OFFSET                                                                     0x01bf
#define mmDMCUB_REGION3_CW5_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW5_OFFSET_HIGH                                                                0x01c0
#define mmDMCUB_REGION3_CW5_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW6_OFFSET                                                                     0x01c1
#define mmDMCUB_REGION3_CW6_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW6_OFFSET_HIGH                                                                0x01c2
#define mmDMCUB_REGION3_CW6_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_REGION3_CW7_OFFSET                                                                     0x01c3
#define mmDMCUB_REGION3_CW7_OFFSET_BASE_IDX                                                            2
#define mmDMCUB_REGION3_CW7_OFFSET_HIGH                                                                0x01c4
#define mmDMCUB_REGION3_CW7_OFFSET_HIGH_BASE_IDX                                                       2
#define mmDMCUB_INTERRUPT_ENABLE                                                                       0x01c5
#define mmDMCUB_INTERRUPT_ENABLE_BASE_IDX                                                              2
#define mmDMCUB_INTERRUPT_ACK                                                                          0x01c6
#define mmDMCUB_INTERRUPT_ACK_BASE_IDX                                                                 2
#define mmDMCUB_INTERRUPT_STATUS                                                                       0x01c7
#define mmDMCUB_INTERRUPT_STATUS_BASE_IDX                                                              2
#define mmDMCUB_INTERRUPT_TYPE                                                                         0x01c8
#define mmDMCUB_INTERRUPT_TYPE_BASE_IDX                                                                2
#define mmDMCUB_EXT_INTERRUPT_STATUS                                                                   0x01c9
#define mmDMCUB_EXT_INTERRUPT_STATUS_BASE_IDX                                                          2
#define mmDMCUB_EXT_INTERRUPT_CTXID                                                                    0x01ca
#define mmDMCUB_EXT_INTERRUPT_CTXID_BASE_IDX                                                           2
#define mmDMCUB_EXT_INTERRUPT_ACK                                                                      0x01cb
#define mmDMCUB_EXT_INTERRUPT_ACK_BASE_IDX                                                             2
#define mmDMCUB_INST_FETCH_FAULT_ADDR                                                                  0x01cc
#define mmDMCUB_INST_FETCH_FAULT_ADDR_BASE_IDX                                                         2
#define mmDMCUB_DATA_WRITE_FAULT_ADDR                                                                  0x01cd
#define mmDMCUB_DATA_WRITE_FAULT_ADDR_BASE_IDX                                                         2
#define mmDMCUB_SEC_CNTL                                                                               0x01ce
#define mmDMCUB_SEC_CNTL_BASE_IDX                                                                      2
#define mmDMCUB_MEM_CNTL                                                                               0x01cf
#define mmDMCUB_MEM_CNTL_BASE_IDX                                                                      2
#define mmDMCUB_INBOX0_BASE_ADDRESS                                                                    0x01d0
#define mmDMCUB_INBOX0_BASE_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_INBOX0_SIZE                                                                            0x01d1
#define mmDMCUB_INBOX0_SIZE_BASE_IDX                                                                   2
#define mmDMCUB_INBOX0_WPTR                                                                            0x01d2
#define mmDMCUB_INBOX0_WPTR_BASE_IDX                                                                   2
#define mmDMCUB_INBOX0_RPTR                                                                            0x01d3
#define mmDMCUB_INBOX0_RPTR_BASE_IDX                                                                   2
#define mmDMCUB_INBOX1_BASE_ADDRESS                                                                    0x01d4
#define mmDMCUB_INBOX1_BASE_ADDRESS_BASE_IDX                                                           2
#define mmDMCUB_INBOX1_SIZE                                                                            0x01d5
#define mmDMCUB_INBOX1_SIZE_BASE_IDX                                                                   2
#define mmDMCUB_INBOX1_WPTR                                                                            0x01d6
#define mmDMCUB_INBOX1_WPTR_BASE_IDX                                                                   2
#define mmDMCUB_INBOX1_RPTR                                                                            0x01d7
#define mmDMCUB_INBOX1_RPTR_BASE_IDX                                                                   2
#define mmDMCUB_OUTBOX0_BASE_ADDRESS                                                                   0x01d8
#define mmDMCUB_OUTBOX0_BASE_ADDRESS_BASE_IDX                                                          2
#define mmDMCUB_OUTBOX0_SIZE                                                                           0x01d9
#define mmDMCUB_OUTBOX0_SIZE_BASE_IDX                                                                  2
#define mmDMCUB_OUTBOX0_WPTR                                                                           0x01da
#define mmDMCUB_OUTBOX0_WPTR_BASE_IDX                                                                  2
#define mmDMCUB_OUTBOX0_RPTR                                                                           0x01db
#define mmDMCUB_OUTBOX0_RPTR_BASE_IDX                                                                  2
#define mmDMCUB_OUTBOX1_BASE_ADDRESS                                                                   0x01dc
#define mmDMCUB_OUTBOX1_BASE_ADDRESS_BASE_IDX                                                          2
#define mmDMCUB_OUTBOX1_SIZE                                                                           0x01dd
#define mmDMCUB_OUTBOX1_SIZE_BASE_IDX                                                                  2
#define mmDMCUB_OUTBOX1_WPTR                                                                           0x01de
#define mmDMCUB_OUTBOX1_WPTR_BASE_IDX                                                                  2
#define mmDMCUB_OUTBOX1_RPTR                                                                           0x01df
#define mmDMCUB_OUTBOX1_RPTR_BASE_IDX                                                                  2
#define mmDMCUB_TIMER_TRIGGER0                                                                         0x01e0
#define mmDMCUB_TIMER_TRIGGER0_BASE_IDX                                                                2
#define mmDMCUB_TIMER_TRIGGER1                                                                         0x01e1
#define mmDMCUB_TIMER_TRIGGER1_BASE_IDX                                                                2
#define mmDMCUB_TIMER_WINDOW                                                                           0x01e2
#define mmDMCUB_TIMER_WINDOW_BASE_IDX                                                                  2
#define mmDMCUB_SCRATCH0                                                                               0x01e3
#define mmDMCUB_SCRATCH0_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH1                                                                               0x01e4
#define mmDMCUB_SCRATCH1_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH2                                                                               0x01e5
#define mmDMCUB_SCRATCH2_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH3                                                                               0x01e6
#define mmDMCUB_SCRATCH3_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH4                                                                               0x01e7
#define mmDMCUB_SCRATCH4_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH5                                                                               0x01e8
#define mmDMCUB_SCRATCH5_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH6                                                                               0x01e9
#define mmDMCUB_SCRATCH6_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH7                                                                               0x01ea
#define mmDMCUB_SCRATCH7_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH8                                                                               0x01eb
#define mmDMCUB_SCRATCH8_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH9                                                                               0x01ec
#define mmDMCUB_SCRATCH9_BASE_IDX                                                                      2
#define mmDMCUB_SCRATCH10                                                                              0x01ed
#define mmDMCUB_SCRATCH10_BASE_IDX                                                                     2
#define mmDMCUB_SCRATCH11                                                                              0x01ee
#define mmDMCUB_SCRATCH11_BASE_IDX                                                                     2
#define mmDMCUB_SCRATCH12                                                                              0x01ef
#define mmDMCUB_SCRATCH12_BASE_IDX                                                                     2
#define mmDMCUB_SCRATCH13                                                                              0x01f0
#define mmDMCUB_SCRATCH13_BASE_IDX                                                                     2
#define mmDMCUB_SCRATCH14                                                                              0x01f1
#define mmDMCUB_SCRATCH14_BASE_IDX                                                                     2
#define mmDMCUB_SCRATCH15                                                                              0x01f2
#define mmDMCUB_SCRATCH15_BASE_IDX                                                                     2
#define mmDMCUB_CNTL                                                                                   0x01f6
#define mmDMCUB_CNTL_BASE_IDX                                                                          2
#define mmDMCUB_GPINT_DATAIN0                                                                          0x01f7
#define mmDMCUB_GPINT_DATAIN0_BASE_IDX                                                                 2
#define mmDMCUB_GPINT_DATAIN1                                                                          0x01f8
#define mmDMCUB_GPINT_DATAIN1_BASE_IDX                                                                 2
#define mmDMCUB_GPINT_DATAOUT                                                                          0x01f9
#define mmDMCUB_GPINT_DATAOUT_BASE_IDX                                                                 2
#define mmDMCUB_UNDEFINED_ADDRESS_FAULT_ADDR                                                           0x01fa
#define mmDMCUB_UNDEFINED_ADDRESS_FAULT_ADDR_BASE_IDX                                                  2
#define mmDMCUB_LS_WAKE_INT_ENABLE                                                                     0x01fb
#define mmDMCUB_LS_WAKE_INT_ENABLE_BASE_IDX                                                            2
#define mmDMCUB_MEM_PWR_CNTL                                                                           0x01fc
#define mmDMCUB_MEM_PWR_CNTL_BASE_IDX                                                                  2
#define mmDMCUB_TIMER_CURRENT                                                                          0x01fd
#define mmDMCUB_TIMER_CURRENT_BASE_IDX                                                                 2
#define mmDMCUB_PROC_ID                                                                                0x01ff
#define mmDMCUB_PROC_ID_BASE_IDX                                                                       2


// addressBlock: dce_dc_mmhubbub_mcif_wb0_dispdec
// base address: 0x0
#define mmMCIF_WB_BUFMGR_SW_CONTROL                                                                    0x0272
#define mmMCIF_WB_BUFMGR_SW_CONTROL_BASE_IDX                                                           2
#define mmMCIF_WB_BUFMGR_STATUS                                                                        0x0274
#define mmMCIF_WB_BUFMGR_STATUS_BASE_IDX                                                               2
#define mmMCIF_WB_BUF_PITCH                                                                            0x0275
#define mmMCIF_WB_BUF_PITCH_BASE_IDX                                                                   2
#define mmMCIF_WB_BUF_1_STATUS                                                                         0x0276
#define mmMCIF_WB_BUF_1_STATUS_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_1_STATUS2                                                                        0x0277
#define mmMCIF_WB_BUF_1_STATUS2_BASE_IDX                                                               2
#define mmMCIF_WB_BUF_2_STATUS                                                                         0x0278
#define mmMCIF_WB_BUF_2_STATUS_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_2_STATUS2                                                                        0x0279
#define mmMCIF_WB_BUF_2_STATUS2_BASE_IDX                                                               2
#define mmMCIF_WB_BUF_3_STATUS                                                                         0x027a
#define mmMCIF_WB_BUF_3_STATUS_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_3_STATUS2                                                                        0x027b
#define mmMCIF_WB_BUF_3_STATUS2_BASE_IDX                                                               2
#define mmMCIF_WB_BUF_4_STATUS                                                                         0x027c
#define mmMCIF_WB_BUF_4_STATUS_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_4_STATUS2                                                                        0x027d
#define mmMCIF_WB_BUF_4_STATUS2_BASE_IDX                                                               2
#define mmMCIF_WB_ARBITRATION_CONTROL                                                                  0x027e
#define mmMCIF_WB_ARBITRATION_CONTROL_BASE_IDX                                                         2
#define mmMCIF_WB_SCLK_CHANGE                                                                          0x027f
#define mmMCIF_WB_SCLK_CHANGE_BASE_IDX                                                                 2
#define mmMCIF_WB_BUF_1_ADDR_Y                                                                         0x0282
#define mmMCIF_WB_BUF_1_ADDR_Y_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_1_ADDR_C                                                                         0x0284
#define mmMCIF_WB_BUF_1_ADDR_C_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_2_ADDR_Y                                                                         0x0286
#define mmMCIF_WB_BUF_2_ADDR_Y_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_2_ADDR_C                                                                         0x0288
#define mmMCIF_WB_BUF_2_ADDR_C_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_3_ADDR_Y                                                                         0x028a
#define mmMCIF_WB_BUF_3_ADDR_Y_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_3_ADDR_C                                                                         0x028c
#define mmMCIF_WB_BUF_3_ADDR_C_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_4_ADDR_Y                                                                         0x028e
#define mmMCIF_WB_BUF_4_ADDR_Y_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_4_ADDR_C                                                                         0x0290
#define mmMCIF_WB_BUF_4_ADDR_C_BASE_IDX                                                                2
#define mmMCIF_WB_BUFMGR_VCE_CONTROL                                                                   0x0292
#define mmMCIF_WB_BUFMGR_VCE_CONTROL_BASE_IDX                                                          2
#define mmMCIF_WB_NB_PSTATE_CONTROL                                                                    0x0293
#define mmMCIF_WB_NB_PSTATE_CONTROL_BASE_IDX                                                           2
#define mmMCIF_WB_CLOCK_GATER_CONTROL                                                                  0x0294
#define mmMCIF_WB_CLOCK_GATER_CONTROL_BASE_IDX                                                         2
#define mmMCIF_WB_SELF_REFRESH_CONTROL                                                                 0x0296
#define mmMCIF_WB_SELF_REFRESH_CONTROL_BASE_IDX                                                        2
#define mmMULTI_LEVEL_QOS_CTRL                                                                         0x0297
#define mmMULTI_LEVEL_QOS_CTRL_BASE_IDX                                                                2
#define mmMCIF_WB_BUF_LUMA_SIZE                                                                        0x0299
#define mmMCIF_WB_BUF_LUMA_SIZE_BASE_IDX                                                               2
#define mmMCIF_WB_BUF_CHROMA_SIZE                                                                      0x029a
#define mmMCIF_WB_BUF_CHROMA_SIZE_BASE_IDX                                                             2
#define mmMCIF_WB_BUF_1_ADDR_Y_HIGH                                                                    0x029b
#define mmMCIF_WB_BUF_1_ADDR_Y_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_1_ADDR_C_HIGH                                                                    0x029c
#define mmMCIF_WB_BUF_1_ADDR_C_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_2_ADDR_Y_HIGH                                                                    0x029d
#define mmMCIF_WB_BUF_2_ADDR_Y_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_2_ADDR_C_HIGH                                                                    0x029e
#define mmMCIF_WB_BUF_2_ADDR_C_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_3_ADDR_Y_HIGH                                                                    0x029f
#define mmMCIF_WB_BUF_3_ADDR_Y_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_3_ADDR_C_HIGH                                                                    0x02a0
#define mmMCIF_WB_BUF_3_ADDR_C_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_4_ADDR_Y_HIGH                                                                    0x02a1
#define mmMCIF_WB_BUF_4_ADDR_Y_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_4_ADDR_C_HIGH                                                                    0x02a2
#define mmMCIF_WB_BUF_4_ADDR_C_HIGH_BASE_IDX                                                           2
#define mmMCIF_WB_BUF_1_RESOLUTION                                                                     0x02a3
#define mmMCIF_WB_BUF_1_RESOLUTION_BASE_IDX                                                            2
#define mmMCIF_WB_BUF_2_RESOLUTION                                                                     0x02a4
#define mmMCIF_WB_BUF_2_RESOLUTION_BASE_IDX                                                            2
#define mmMCIF_WB_BUF_3_RESOLUTION                                                                     0x02a5
#define mmMCIF_WB_BUF_3_RESOLUTION_BASE_IDX                                                            2
#define mmMCIF_WB_BUF_4_RESOLUTION                                                                     0x02a6
#define mmMCIF_WB_BUF_4_RESOLUTION_BASE_IDX                                                            2
#define mmMCIF_WB_DRAM_SPEED_CHANGE_DURATION_VBI                                                       0x02a7
#define mmMCIF_WB_DRAM_SPEED_CHANGE_DURATION_VBI_BASE_IDX                                              2
#define mmMCIF_WB_VMID_CONTROL                                                                         0x02a8
#define mmMCIF_WB_VMID_CONTROL_BASE_IDX                                                                2
#define mmMCIF_WB_MIN_TTO                                                                              0x02a9
#define mmMCIF_WB_MIN_TTO_BASE_IDX                                                                     2


// addressBlock: dce_dc_mmhubbub_mmhubbub_dispdec
// base address: 0x0
#define mmMCIF_WB_NB_PSTATE_LATENCY_WATERMARK                                                          0x02aa
#define mmMCIF_WB_NB_PSTATE_LATENCY_WATERMARK_BASE_IDX                                                 2
#define mmMCIF_WB_WATERMARK                                                                            0x02ab
#define mmMCIF_WB_WATERMARK_BASE_IDX                                                                   2
#define mmMMHUBBUB_WARMUP_CONFIG                                                                       0x02ac
#define mmMMHUBBUB_WARMUP_CONFIG_BASE_IDX                                                              2
#define mmMMHUBBUB_WARMUP_CONTROL_STATUS                                                               0x02ad
#define mmMMHUBBUB_WARMUP_CONTROL_STATUS_BASE_IDX                                                      2
#define mmMMHUBBUB_WARMUP_BASE_ADDR_LOW                                                                0x02ae
#define mmMMHUBBUB_WARMUP_BASE_ADDR_LOW_BASE_IDX                                                       2
#define mmMMHUBBUB_WARMUP_BASE_ADDR_HIGH                                                               0x02af
#define mmMMHUBBUB_WARMUP_BASE_ADDR_HIGH_BASE_IDX                                                      2
#define mmMMHUBBUB_WARMUP_ADDR_REGION                                                                  0x02b0
#define mmMMHUBBUB_WARMUP_ADDR_REGION_BASE_IDX                                                         2
#define mmMMHUBBUB_MIN_TTO                                                                             0x02b1
#define mmMMHUBBUB_MIN_TTO_BASE_IDX                                                                    2
#define mmWBIF_SMU_WM_CONTROL                                                                          0x0333
#define mmWBIF_SMU_WM_CONTROL_BASE_IDX                                                                 2
#define mmWBIF0_MISC_CTRL                                                                              0x0334
#define mmWBIF0_MISC_CTRL_BASE_IDX                                                                     2
#define mmWBIF0_PHASE0_OUTSTANDING_COUNTER                                                             0x0335
#define mmWBIF0_PHASE0_OUTSTANDING_COUNTER_BASE_IDX                                                    2
#define mmWBIF0_PHASE1_OUTSTANDING_COUNTER                                                             0x0336
#define mmWBIF0_PHASE1_OUTSTANDING_COUNTER_BASE_IDX                                                    2
#define mmVGA_SRC_SPLIT_CNTL                                                                           0x033d
#define mmVGA_SRC_SPLIT_CNTL_BASE_IDX                                                                  2
#define mmMMHUBBUB_MEM_PWR_STATUS                                                                      0x033e
#define mmMMHUBBUB_MEM_PWR_STATUS_BASE_IDX                                                             2
#define mmMMHUBBUB_MEM_PWR_CNTL                                                                        0x033f
#define mmMMHUBBUB_MEM_PWR_CNTL_BASE_IDX                                                               2
#define mmMMHUBBUB_CLOCK_CNTL                                                                          0x0340
#define mmMMHUBBUB_CLOCK_CNTL_BASE_IDX                                                                 2
#define mmMMHUBBUB_SOFT_RESET                                                                          0x0341
#define mmMMHUBBUB_SOFT_RESET_BASE_IDX                                                                 2
#define mmDMU_IF_ERR_STATUS                                                                            0x0345
#define mmDMU_IF_ERR_STATUS_BASE_IDX                                                                   2
#define mmMMHUBBUB_CLIENT_UNIT_ID                                                                      0x0346
#define mmMMHUBBUB_CLIENT_UNIT_ID_BASE_IDX                                                             2
#define mmMMHUBBUB_WARMUP_VMID_CONTROL                                                                 0x0348
#define mmMMHUBBUB_WARMUP_VMID_CONTROL_BASE_IDX                                                        2


// addressBlock: dce_dc_mmhubbub_vgaif_dispdec
// base address: 0x0
#define mmMCIF_CONTROL                                                                                 0x034a
#define mmMCIF_CONTROL_BASE_IDX                                                                        2
#define mmMCIF_WRITE_COMBINE_CONTROL                                                                   0x034b
#define mmMCIF_WRITE_COMBINE_CONTROL_BASE_IDX                                                          2
#define mmMCIF_PHASE0_OUTSTANDING_COUNTER                                                              0x034e
#define mmMCIF_PHASE0_OUTSTANDING_COUNTER_BASE_IDX                                                     2
#define mmMCIF_PHASE1_OUTSTANDING_COUNTER                                                              0x034f
#define mmMCIF_PHASE1_OUTSTANDING_COUNTER_BASE_IDX                                                     2
#define mmMCIF_PHASE2_OUTSTANDING_COUNTER                                                              0x0350
#define mmMCIF_PHASE2_OUTSTANDING_COUNTER_BASE_IDX                                                     2


// addressBlock: dce_dc_mmhubbub_mmhubbub_dcperfmon_dc_perfmon_dispdec
// base address: 0xd48
#define mmDC_PERFMON3_PERFCOUNTER_CNTL                                                                 0x0352
#define mmDC_PERFMON3_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON3_PERFCOUNTER_CNTL2                                                                0x0353
#define mmDC_PERFMON3_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON3_PERFCOUNTER_STATE                                                                0x0354
#define mmDC_PERFMON3_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON3_PERFMON_CNTL                                                                     0x0355
#define mmDC_PERFMON3_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON3_PERFMON_CNTL2                                                                    0x0356
#define mmDC_PERFMON3_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON3_PERFMON_CVALUE_INT_MISC                                                          0x0357
#define mmDC_PERFMON3_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON3_PERFMON_CVALUE_LOW                                                               0x0358
#define mmDC_PERFMON3_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON3_PERFMON_HI                                                                       0x0359
#define mmDC_PERFMON3_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON3_PERFMON_LOW                                                                      0x035a
#define mmDC_PERFMON3_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_hda_azf0stream0_dispdec
// base address: 0x0
#define mmAZF0STREAM0_AZALIA_STREAM_INDEX                                                              0x035e
#define mmAZF0STREAM0_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM0_AZALIA_STREAM_DATA                                                               0x035f
#define mmAZF0STREAM0_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream1_dispdec
// base address: 0x8
#define mmAZF0STREAM1_AZALIA_STREAM_INDEX                                                              0x0360
#define mmAZF0STREAM1_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM1_AZALIA_STREAM_DATA                                                               0x0361
#define mmAZF0STREAM1_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream2_dispdec
// base address: 0x10
#define mmAZF0STREAM2_AZALIA_STREAM_INDEX                                                              0x0362
#define mmAZF0STREAM2_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM2_AZALIA_STREAM_DATA                                                               0x0363
#define mmAZF0STREAM2_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream3_dispdec
// base address: 0x18
#define mmAZF0STREAM3_AZALIA_STREAM_INDEX                                                              0x0364
#define mmAZF0STREAM3_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM3_AZALIA_STREAM_DATA                                                               0x0365
#define mmAZF0STREAM3_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream4_dispdec
// base address: 0x20
#define mmAZF0STREAM4_AZALIA_STREAM_INDEX                                                              0x0366
#define mmAZF0STREAM4_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM4_AZALIA_STREAM_DATA                                                               0x0367
#define mmAZF0STREAM4_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream5_dispdec
// base address: 0x28
#define mmAZF0STREAM5_AZALIA_STREAM_INDEX                                                              0x0368
#define mmAZF0STREAM5_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM5_AZALIA_STREAM_DATA                                                               0x0369
#define mmAZF0STREAM5_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream6_dispdec
// base address: 0x30
#define mmAZF0STREAM6_AZALIA_STREAM_INDEX                                                              0x036a
#define mmAZF0STREAM6_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM6_AZALIA_STREAM_DATA                                                               0x036b
#define mmAZF0STREAM6_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream7_dispdec
// base address: 0x38
#define mmAZF0STREAM7_AZALIA_STREAM_INDEX                                                              0x036c
#define mmAZF0STREAM7_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM7_AZALIA_STREAM_DATA                                                               0x036d
#define mmAZF0STREAM7_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_az_misc_dispdec
// base address: 0x0
#define mmAZ_CLOCK_CNTL                                                                                0x0372
#define mmAZ_CLOCK_CNTL_BASE_IDX                                                                       2


// addressBlock: dce_dc_hda_az_dcperfmon_dc_perfmon_dispdec
// base address: 0xde8
#define mmDC_PERFMON4_PERFCOUNTER_CNTL                                                                 0x037a
#define mmDC_PERFMON4_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON4_PERFCOUNTER_CNTL2                                                                0x037b
#define mmDC_PERFMON4_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON4_PERFCOUNTER_STATE                                                                0x037c
#define mmDC_PERFMON4_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON4_PERFMON_CNTL                                                                     0x037d
#define mmDC_PERFMON4_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON4_PERFMON_CNTL2                                                                    0x037e
#define mmDC_PERFMON4_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON4_PERFMON_CVALUE_INT_MISC                                                          0x037f
#define mmDC_PERFMON4_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON4_PERFMON_CVALUE_LOW                                                               0x0380
#define mmDC_PERFMON4_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON4_PERFMON_HI                                                                       0x0381
#define mmDC_PERFMON4_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON4_PERFMON_LOW                                                                      0x0382
#define mmDC_PERFMON4_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_hda_azf0endpoint0_dispdec
// base address: 0x0
#define mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x0386
#define mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x0387
#define mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint1_dispdec
// base address: 0x18
#define mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x038c
#define mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x038d
#define mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint2_dispdec
// base address: 0x30
#define mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x0392
#define mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x0393
#define mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint3_dispdec
// base address: 0x48
#define mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x0398
#define mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x0399
#define mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint4_dispdec
// base address: 0x60
#define mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x039e
#define mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x039f
#define mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint5_dispdec
// base address: 0x78
#define mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x03a4
#define mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x03a5
#define mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint6_dispdec
// base address: 0x90
#define mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x03aa
#define mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x03ab
#define mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0endpoint7_dispdec
// base address: 0xa8
#define mmAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x03b0
#define mmAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x03b1
#define mmAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_hda_azf0controller_dispdec
// base address: 0x0
#define mmAZALIA_CONTROLLER_CLOCK_GATING                                                               0x03c2
#define mmAZALIA_CONTROLLER_CLOCK_GATING_BASE_IDX                                                      2
#define mmAZALIA_AUDIO_DTO                                                                             0x03c3
#define mmAZALIA_AUDIO_DTO_BASE_IDX                                                                    2
#define mmAZALIA_AUDIO_DTO_CONTROL                                                                     0x03c4
#define mmAZALIA_AUDIO_DTO_CONTROL_BASE_IDX                                                            2
#define mmAZALIA_SOCCLK_CONTROL                                                                        0x03c5
#define mmAZALIA_SOCCLK_CONTROL_BASE_IDX                                                               2
#define mmAZALIA_UNDERFLOW_FILLER_SAMPLE                                                               0x03c6
#define mmAZALIA_UNDERFLOW_FILLER_SAMPLE_BASE_IDX                                                      2
#define mmAZALIA_DATA_DMA_CONTROL                                                                      0x03c7
#define mmAZALIA_DATA_DMA_CONTROL_BASE_IDX                                                             2
#define mmAZALIA_BDL_DMA_CONTROL                                                                       0x03c8
#define mmAZALIA_BDL_DMA_CONTROL_BASE_IDX                                                              2
#define mmAZALIA_RIRB_AND_DP_CONTROL                                                                   0x03c9
#define mmAZALIA_RIRB_AND_DP_CONTROL_BASE_IDX                                                          2
#define mmAZALIA_CORB_DMA_CONTROL                                                                      0x03ca
#define mmAZALIA_CORB_DMA_CONTROL_BASE_IDX                                                             2
#define mmAZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER                                                 0x03d1
#define mmAZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER_BASE_IDX                                        2
#define mmAZALIA_CYCLIC_BUFFER_SYNC                                                                    0x03d2
#define mmAZALIA_CYCLIC_BUFFER_SYNC_BASE_IDX                                                           2
#define mmAZALIA_GLOBAL_CAPABILITIES                                                                   0x03d3
#define mmAZALIA_GLOBAL_CAPABILITIES_BASE_IDX                                                          2
#define mmAZALIA_OUTPUT_PAYLOAD_CAPABILITY                                                             0x03d4
#define mmAZALIA_OUTPUT_PAYLOAD_CAPABILITY_BASE_IDX                                                    2
#define mmAZALIA_OUTPUT_STREAM_ARBITER_CONTROL                                                         0x03d5
#define mmAZALIA_OUTPUT_STREAM_ARBITER_CONTROL_BASE_IDX                                                2
#define mmAZALIA_INPUT_PAYLOAD_CAPABILITY                                                              0x03d6
#define mmAZALIA_INPUT_PAYLOAD_CAPABILITY_BASE_IDX                                                     2
#define mmAZALIA_INPUT_CRC0_CONTROL0                                                                   0x03d9
#define mmAZALIA_INPUT_CRC0_CONTROL0_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC0_CONTROL1                                                                   0x03da
#define mmAZALIA_INPUT_CRC0_CONTROL1_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC0_CONTROL2                                                                   0x03db
#define mmAZALIA_INPUT_CRC0_CONTROL2_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC0_CONTROL3                                                                   0x03dc
#define mmAZALIA_INPUT_CRC0_CONTROL3_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC0_RESULT                                                                     0x03dd
#define mmAZALIA_INPUT_CRC0_RESULT_BASE_IDX                                                            2
#define mmAZALIA_INPUT_CRC1_CONTROL0                                                                   0x03de
#define mmAZALIA_INPUT_CRC1_CONTROL0_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC1_CONTROL1                                                                   0x03df
#define mmAZALIA_INPUT_CRC1_CONTROL1_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC1_CONTROL2                                                                   0x03e0
#define mmAZALIA_INPUT_CRC1_CONTROL2_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC1_CONTROL3                                                                   0x03e1
#define mmAZALIA_INPUT_CRC1_CONTROL3_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC1_RESULT                                                                     0x03e2
#define mmAZALIA_INPUT_CRC1_RESULT_BASE_IDX                                                            2
#define mmAZALIA_CRC0_CONTROL0                                                                         0x03e3
#define mmAZALIA_CRC0_CONTROL0_BASE_IDX                                                                2
#define mmAZALIA_CRC0_CONTROL1                                                                         0x03e4
#define mmAZALIA_CRC0_CONTROL1_BASE_IDX                                                                2
#define mmAZALIA_CRC0_CONTROL2                                                                         0x03e5
#define mmAZALIA_CRC0_CONTROL2_BASE_IDX                                                                2
#define mmAZALIA_CRC0_CONTROL3                                                                         0x03e6
#define mmAZALIA_CRC0_CONTROL3_BASE_IDX                                                                2
#define mmAZALIA_CRC0_RESULT                                                                           0x03e7
#define mmAZALIA_CRC0_RESULT_BASE_IDX                                                                  2
#define mmAZALIA_CRC1_CONTROL0                                                                         0x03e8
#define mmAZALIA_CRC1_CONTROL0_BASE_IDX                                                                2
#define mmAZALIA_CRC1_CONTROL1                                                                         0x03e9
#define mmAZALIA_CRC1_CONTROL1_BASE_IDX                                                                2
#define mmAZALIA_CRC1_CONTROL2                                                                         0x03ea
#define mmAZALIA_CRC1_CONTROL2_BASE_IDX                                                                2
#define mmAZALIA_CRC1_CONTROL3                                                                         0x03eb
#define mmAZALIA_CRC1_CONTROL3_BASE_IDX                                                                2
#define mmAZALIA_CRC1_RESULT                                                                           0x03ec
#define mmAZALIA_CRC1_RESULT_BASE_IDX                                                                  2
#define mmAZALIA_MEM_PWR_CTRL                                                                          0x03ee
#define mmAZALIA_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define mmAZALIA_MEM_PWR_STATUS                                                                        0x03ef
#define mmAZALIA_MEM_PWR_STATUS_BASE_IDX                                                               2


// addressBlock: dce_dc_hda_azf0root_dispdec
// base address: 0x0
#define mmAZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID                                          0x0406
#define mmAZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID_BASE_IDX                                 2
#define mmAZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID                                                   0x0407
#define mmAZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID_BASE_IDX                                          2
#define mmAZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL                                                        0x0408
#define mmAZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL_BASE_IDX                                               2
#define mmAZALIA_F0_CODEC_RESYNC_FIFO_CONTROL                                                          0x0409
#define mmAZALIA_F0_CODEC_RESYNC_FIFO_CONTROL_BASE_IDX                                                 2
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE                                                0x040a
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE_BASE_IDX                                       2
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES                                      0x040b
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES_BASE_IDX                             2
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS                                            0x040c
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS_BASE_IDX                                   2
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES                                              0x040d
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES_BASE_IDX                                     2
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE                                                 0x040e
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE_BASE_IDX                                        2
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESET                                                       0x040f
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESET_BASE_IDX                                              2
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID                                       0x0410
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID_BASE_IDX                              2
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION                                   0x0411
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION_BASE_IDX                          2
#define mmCC_RCU_DC_AUDIO_PORT_CONNECTIVITY                                                            0x0412
#define mmCC_RCU_DC_AUDIO_PORT_CONNECTIVITY_BASE_IDX                                                   2
#define mmCC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY                                                      0x0413
#define mmCC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY_BASE_IDX                                             2
#define mmAZALIA_F0_GTC_GROUP_OFFSET0                                                                  0x0415
#define mmAZALIA_F0_GTC_GROUP_OFFSET0_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET1                                                                  0x0416
#define mmAZALIA_F0_GTC_GROUP_OFFSET1_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET2                                                                  0x0417
#define mmAZALIA_F0_GTC_GROUP_OFFSET2_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET3                                                                  0x0418
#define mmAZALIA_F0_GTC_GROUP_OFFSET3_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET4                                                                  0x0419
#define mmAZALIA_F0_GTC_GROUP_OFFSET4_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET5                                                                  0x041a
#define mmAZALIA_F0_GTC_GROUP_OFFSET5_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET6                                                                  0x041b
#define mmAZALIA_F0_GTC_GROUP_OFFSET6_BASE_IDX                                                         2
#define mmREG_DC_AUDIO_PORT_CONNECTIVITY                                                               0x041c
#define mmREG_DC_AUDIO_PORT_CONNECTIVITY_BASE_IDX                                                      2
#define mmREG_DC_AUDIO_INPUT_PORT_CONNECTIVITY                                                         0x041d
#define mmREG_DC_AUDIO_INPUT_PORT_CONNECTIVITY_BASE_IDX                                                2


// addressBlock: dce_dc_hda_azf0stream8_dispdec
// base address: 0x320
#define mmAZF0STREAM8_AZALIA_STREAM_INDEX                                                              0x0426
#define mmAZF0STREAM8_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM8_AZALIA_STREAM_DATA                                                               0x0427
#define mmAZF0STREAM8_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream9_dispdec
// base address: 0x328
#define mmAZF0STREAM9_AZALIA_STREAM_INDEX                                                              0x0428
#define mmAZF0STREAM9_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM9_AZALIA_STREAM_DATA                                                               0x0429
#define mmAZF0STREAM9_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_hda_azf0stream10_dispdec
// base address: 0x330
#define mmAZF0STREAM10_AZALIA_STREAM_INDEX                                                             0x042a
#define mmAZF0STREAM10_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM10_AZALIA_STREAM_DATA                                                              0x042b
#define mmAZF0STREAM10_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream11_dispdec
// base address: 0x338
#define mmAZF0STREAM11_AZALIA_STREAM_INDEX                                                             0x042c
#define mmAZF0STREAM11_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM11_AZALIA_STREAM_DATA                                                              0x042d
#define mmAZF0STREAM11_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream12_dispdec
// base address: 0x340
#define mmAZF0STREAM12_AZALIA_STREAM_INDEX                                                             0x042e
#define mmAZF0STREAM12_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM12_AZALIA_STREAM_DATA                                                              0x042f
#define mmAZF0STREAM12_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream13_dispdec
// base address: 0x348
#define mmAZF0STREAM13_AZALIA_STREAM_INDEX                                                             0x0430
#define mmAZF0STREAM13_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM13_AZALIA_STREAM_DATA                                                              0x0431
#define mmAZF0STREAM13_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream14_dispdec
// base address: 0x350
#define mmAZF0STREAM14_AZALIA_STREAM_INDEX                                                             0x0432
#define mmAZF0STREAM14_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM14_AZALIA_STREAM_DATA                                                              0x0433
#define mmAZF0STREAM14_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0stream15_dispdec
// base address: 0x358
#define mmAZF0STREAM15_AZALIA_STREAM_INDEX                                                             0x0434
#define mmAZF0STREAM15_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM15_AZALIA_STREAM_DATA                                                              0x0435
#define mmAZF0STREAM15_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_hda_azf0inputendpoint0_dispdec
// base address: 0x0
#define mmAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x043a
#define mmAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x043b
#define mmAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint1_dispdec
// base address: 0x10
#define mmAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x043e
#define mmAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x043f
#define mmAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint2_dispdec
// base address: 0x20
#define mmAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0442
#define mmAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0443
#define mmAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint3_dispdec
// base address: 0x30
#define mmAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0446
#define mmAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0447
#define mmAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint4_dispdec
// base address: 0x40
#define mmAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x044a
#define mmAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x044b
#define mmAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint5_dispdec
// base address: 0x50
#define mmAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x044e
#define mmAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x044f
#define mmAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint6_dispdec
// base address: 0x60
#define mmAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0452
#define mmAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0453
#define mmAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_hda_azf0inputendpoint7_dispdec
// base address: 0x70
#define mmAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0456
#define mmAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0457
#define mmAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_dchubbub_hubbub_sdpif_dispdec
// base address: 0x0
#define mmDCHUBBUB_SDPIF_CFG0                                                                          0x048f
#define mmDCHUBBUB_SDPIF_CFG0_BASE_IDX                                                                 2
#define mmVM_REQUEST_PHYSICAL                                                                          0x0490
#define mmVM_REQUEST_PHYSICAL_BASE_IDX                                                                 2
#define mmDCHUBBUB_FORCE_IO_STATUS_0                                                                   0x0491
#define mmDCHUBBUB_FORCE_IO_STATUS_0_BASE_IDX                                                          2
#define mmDCHUBBUB_FORCE_IO_STATUS_1                                                                   0x0492
#define mmDCHUBBUB_FORCE_IO_STATUS_1_BASE_IDX                                                          2
#define mmDCN_VM_FB_LOCATION_BASE                                                                      0x0493
#define mmDCN_VM_FB_LOCATION_BASE_BASE_IDX                                                             2
#define mmDCN_VM_FB_LOCATION_TOP                                                                       0x0494
#define mmDCN_VM_FB_LOCATION_TOP_BASE_IDX                                                              2
#define mmDCN_VM_FB_OFFSET                                                                             0x0495
#define mmDCN_VM_FB_OFFSET_BASE_IDX                                                                    2
#define mmDCN_VM_AGP_BOT                                                                               0x0496
#define mmDCN_VM_AGP_BOT_BASE_IDX                                                                      2
#define mmDCN_VM_AGP_TOP                                                                               0x0497
#define mmDCN_VM_AGP_TOP_BASE_IDX                                                                      2
#define mmDCN_VM_AGP_BASE                                                                              0x0498
#define mmDCN_VM_AGP_BASE_BASE_IDX                                                                     2
#define mmDCN_VM_LOCAL_HBM_ADDRESS_START                                                               0x0499
#define mmDCN_VM_LOCAL_HBM_ADDRESS_START_BASE_IDX                                                      2
#define mmDCN_VM_LOCAL_HBM_ADDRESS_END                                                                 0x049a
#define mmDCN_VM_LOCAL_HBM_ADDRESS_END_BASE_IDX                                                        2
#define mmDCN_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL                                                           0x049b
#define mmDCN_VM_LOCAL_HBM_ADDRESS_LOCK_CNTL_BASE_IDX                                                  2
#define mmDCHUBBUB_SDPIF_MEM_PWR_CTRL                                                                  0x04ba
#define mmDCHUBBUB_SDPIF_MEM_PWR_CTRL_BASE_IDX                                                         2
#define mmDCHUBBUB_SDPIF_MEM_PWR_STATUS                                                                0x04bb
#define mmDCHUBBUB_SDPIF_MEM_PWR_STATUS_BASE_IDX                                                       2
#define mmDCHUBBUB_SDPIF_CFG1                                                                          0x04bf
#define mmDCHUBBUB_SDPIF_CFG1_BASE_IDX                                                                 2
#define mmDCHUBBUB_SDPIF_CFG2                                                                          0x04c0
#define mmDCHUBBUB_SDPIF_CFG2_BASE_IDX                                                                 2


// addressBlock: dce_dc_dchubbub_hubbub_ret_path_dispdec
// base address: 0x0
#define mmDCHUBBUB_RET_PATH_DCC_CFG                                                                    0x04cf
#define mmDCHUBBUB_RET_PATH_DCC_CFG_BASE_IDX                                                           2
#define mmDCHUBBUB_RET_PATH_DCC_CFG0_0                                                                 0x04d0
#define mmDCHUBBUB_RET_PATH_DCC_CFG0_0_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG0_1                                                                 0x04d1
#define mmDCHUBBUB_RET_PATH_DCC_CFG0_1_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG1_0                                                                 0x04d2
#define mmDCHUBBUB_RET_PATH_DCC_CFG1_0_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG1_1                                                                 0x04d3
#define mmDCHUBBUB_RET_PATH_DCC_CFG1_1_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG2_0                                                                 0x04d4
#define mmDCHUBBUB_RET_PATH_DCC_CFG2_0_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG2_1                                                                 0x04d5
#define mmDCHUBBUB_RET_PATH_DCC_CFG2_1_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG3_0                                                                 0x04d6
#define mmDCHUBBUB_RET_PATH_DCC_CFG3_0_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG3_1                                                                 0x04d7
#define mmDCHUBBUB_RET_PATH_DCC_CFG3_1_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG4_0                                                                 0x04d8
#define mmDCHUBBUB_RET_PATH_DCC_CFG4_0_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG4_1                                                                 0x04d9
#define mmDCHUBBUB_RET_PATH_DCC_CFG4_1_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG5_0                                                                 0x04da
#define mmDCHUBBUB_RET_PATH_DCC_CFG5_0_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG5_1                                                                 0x04db
#define mmDCHUBBUB_RET_PATH_DCC_CFG5_1_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG6_0                                                                 0x04dc
#define mmDCHUBBUB_RET_PATH_DCC_CFG6_0_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG6_1                                                                 0x04dd
#define mmDCHUBBUB_RET_PATH_DCC_CFG6_1_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG7_0                                                                 0x04de
#define mmDCHUBBUB_RET_PATH_DCC_CFG7_0_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG7_1                                                                 0x04df
#define mmDCHUBBUB_RET_PATH_DCC_CFG7_1_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG8_0                                                                 0x04e0
#define mmDCHUBBUB_RET_PATH_DCC_CFG8_0_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG8_1                                                                 0x04e1
#define mmDCHUBBUB_RET_PATH_DCC_CFG8_1_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG9_0                                                                 0x04e2
#define mmDCHUBBUB_RET_PATH_DCC_CFG9_0_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_DCC_CFG9_1                                                                 0x04e3
#define mmDCHUBBUB_RET_PATH_DCC_CFG9_1_BASE_IDX                                                        2
#define mmDCHUBBUB_RET_PATH_MEM_PWR_CTRL                                                               0x04ef
#define mmDCHUBBUB_RET_PATH_MEM_PWR_CTRL_BASE_IDX                                                      2
#define mmDCHUBBUB_RET_PATH_MEM_PWR_STATUS                                                             0x04f0
#define mmDCHUBBUB_RET_PATH_MEM_PWR_STATUS_BASE_IDX                                                    2
#define mmDCHUBBUB_CRC_CTRL                                                                            0x04f1
#define mmDCHUBBUB_CRC_CTRL_BASE_IDX                                                                   2
#define mmDCHUBBUB_CRC0_VAL_R_G                                                                        0x04f2
#define mmDCHUBBUB_CRC0_VAL_R_G_BASE_IDX                                                               2
#define mmDCHUBBUB_CRC0_VAL_B_A                                                                        0x04f3
#define mmDCHUBBUB_CRC0_VAL_B_A_BASE_IDX                                                               2
#define mmDCHUBBUB_CRC1_VAL_R_G                                                                        0x04f4
#define mmDCHUBBUB_CRC1_VAL_R_G_BASE_IDX                                                               2
#define mmDCHUBBUB_CRC1_VAL_B_A                                                                        0x04f5
#define mmDCHUBBUB_CRC1_VAL_B_A_BASE_IDX                                                               2


// addressBlock: dce_dc_dchubbub_hubbub_dispdec
// base address: 0x0
#define mmDCHUBBUB_ARB_DF_REQ_OUTSTAND                                                                 0x0505
#define mmDCHUBBUB_ARB_DF_REQ_OUTSTAND_BASE_IDX                                                        2
#define mmDCHUBBUB_ARB_SAT_LEVEL                                                                       0x0506
#define mmDCHUBBUB_ARB_SAT_LEVEL_BASE_IDX                                                              2
#define mmDCHUBBUB_ARB_QOS_FORCE                                                                       0x0507
#define mmDCHUBBUB_ARB_QOS_FORCE_BASE_IDX                                                              2
#define mmDCHUBBUB_ARB_DRAM_STATE_CNTL                                                                 0x0508
#define mmDCHUBBUB_ARB_DRAM_STATE_CNTL_BASE_IDX                                                        2
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_A                                                        0x0509
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_A_BASE_IDX                                               2
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_A                                                     0x050a
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_A_BASE_IDX                                            2
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_A                                                      0x050b
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_A_BASE_IDX                                             2
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_A                                                       0x050c
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_A_BASE_IDX                                              2
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_A                                               0x050d
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_A_BASE_IDX                                      2
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_B                                                        0x050e
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_B_BASE_IDX                                               2
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_B                                                     0x050f
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_B_BASE_IDX                                            2
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_B                                                      0x0510
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_B_BASE_IDX                                             2
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_B                                                       0x0511
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_B_BASE_IDX                                              2
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_B                                               0x0512
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_B_BASE_IDX                                      2
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_C                                                        0x0513
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_C_BASE_IDX                                               2
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_C                                                     0x0514
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_C_BASE_IDX                                            2
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_C                                                      0x0515
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_C_BASE_IDX                                             2
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_C                                                       0x0516
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_C_BASE_IDX                                              2
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_C                                               0x0517
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_C_BASE_IDX                                      2
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_D                                                        0x0518
#define mmDCHUBBUB_ARB_DATA_URGENCY_WATERMARK_D_BASE_IDX                                               2
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_D                                                     0x0519
#define mmDCHUBBUB_ARB_REFCYC_PER_TRIP_TO_MEMORY_D_BASE_IDX                                            2
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_D                                                      0x051a
#define mmDCHUBBUB_ARB_ALLOW_SR_ENTER_WATERMARK_D_BASE_IDX                                             2
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_D                                                       0x051b
#define mmDCHUBBUB_ARB_ALLOW_SR_EXIT_WATERMARK_D_BASE_IDX                                              2
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_D                                               0x051c
#define mmDCHUBBUB_ARB_ALLOW_DRAM_CLK_CHANGE_WATERMARK_D_BASE_IDX                                      2
#define mmDCHUBBUB_ARB_WATERMARK_CHANGE_CNTL                                                           0x051d
#define mmDCHUBBUB_ARB_WATERMARK_CHANGE_CNTL_BASE_IDX                                                  2
#define mmDCHUBBUB_ARB_TIMEOUT_ENABLE                                                                  0x051e
#define mmDCHUBBUB_ARB_TIMEOUT_ENABLE_BASE_IDX                                                         2
#define mmDCHUBBUB_GLOBAL_TIMER_CNTL                                                                   0x051f
#define mmDCHUBBUB_GLOBAL_TIMER_CNTL_BASE_IDX                                                          2
#define mmSURFACE_CHECK0_ADDRESS_LSB                                                                   0x0520
#define mmSURFACE_CHECK0_ADDRESS_LSB_BASE_IDX                                                          2
#define mmSURFACE_CHECK0_ADDRESS_MSB                                                                   0x0521
#define mmSURFACE_CHECK0_ADDRESS_MSB_BASE_IDX                                                          2
#define mmSURFACE_CHECK1_ADDRESS_LSB                                                                   0x0522
#define mmSURFACE_CHECK1_ADDRESS_LSB_BASE_IDX                                                          2
#define mmSURFACE_CHECK1_ADDRESS_MSB                                                                   0x0523
#define mmSURFACE_CHECK1_ADDRESS_MSB_BASE_IDX                                                          2
#define mmSURFACE_CHECK2_ADDRESS_LSB                                                                   0x0524
#define mmSURFACE_CHECK2_ADDRESS_LSB_BASE_IDX                                                          2
#define mmSURFACE_CHECK2_ADDRESS_MSB                                                                   0x0525
#define mmSURFACE_CHECK2_ADDRESS_MSB_BASE_IDX                                                          2
#define mmSURFACE_CHECK3_ADDRESS_LSB                                                                   0x0526
#define mmSURFACE_CHECK3_ADDRESS_LSB_BASE_IDX                                                          2
#define mmSURFACE_CHECK3_ADDRESS_MSB                                                                   0x0527
#define mmSURFACE_CHECK3_ADDRESS_MSB_BASE_IDX                                                          2
#define mmVTG0_CONTROL                                                                                 0x0528
#define mmVTG0_CONTROL_BASE_IDX                                                                        2
#define mmVTG1_CONTROL                                                                                 0x0529
#define mmVTG1_CONTROL_BASE_IDX                                                                        2
#define mmVTG2_CONTROL                                                                                 0x052a
#define mmVTG2_CONTROL_BASE_IDX                                                                        2
#define mmVTG3_CONTROL                                                                                 0x052b
#define mmVTG3_CONTROL_BASE_IDX                                                                        2
#define mmVTG4_CONTROL                                                                                 0x052c
#define mmVTG4_CONTROL_BASE_IDX                                                                        2
#define mmDCHUBBUB_SOFT_RESET                                                                          0x052e
#define mmDCHUBBUB_SOFT_RESET_BASE_IDX                                                                 2
#define mmDCHUBBUB_CLOCK_CNTL                                                                          0x052f
#define mmDCHUBBUB_CLOCK_CNTL_BASE_IDX                                                                 2
#define mmDCFCLK_CNTL                                                                                  0x0530
#define mmDCFCLK_CNTL_BASE_IDX                                                                         2
#define mmDCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL                                                        0x0531
#define mmDCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL_BASE_IDX                                               2
#define mmDCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2                                                       0x0532
#define mmDCHUBBUB_PERFORMANCE_MEASUREMENT_CNTL2_BASE_IDX                                              2
#define mmDCHUBBUB_VLINE_SNAPSHOT                                                                      0x0533
#define mmDCHUBBUB_VLINE_SNAPSHOT_BASE_IDX                                                             2
#define mmDCHUBBUB_CTRL_STATUS                                                                         0x0534
#define mmDCHUBBUB_CTRL_STATUS_BASE_IDX                                                                2
#define mmDCHUBBUB_TIMEOUT_DETECTION_CTRL1                                                             0x053a
#define mmDCHUBBUB_TIMEOUT_DETECTION_CTRL1_BASE_IDX                                                    2
#define mmDCHUBBUB_TIMEOUT_DETECTION_CTRL2                                                             0x053b
#define mmDCHUBBUB_TIMEOUT_DETECTION_CTRL2_BASE_IDX                                                    2
#define mmDCHUBBUB_TIMEOUT_INTERRUPT_STATUS                                                            0x053c
#define mmDCHUBBUB_TIMEOUT_INTERRUPT_STATUS_BASE_IDX                                                   2
#define mmDCHUBBUB_TEST_DEBUG_INDEX                                                                    0x053d
#define mmDCHUBBUB_TEST_DEBUG_INDEX_BASE_IDX                                                           2
#define mmDCHUBBUB_TEST_DEBUG_DATA                                                                     0x053e
#define mmDCHUBBUB_TEST_DEBUG_DATA_BASE_IDX                                                            2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_A                                                               0x053f
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_A_BASE_IDX                                                      2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_A                                                              0x0540
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_A_BASE_IDX                                                     2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_B                                                               0x0541
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_B_BASE_IDX                                                      2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_B                                                              0x0542
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_B_BASE_IDX                                                     2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_C                                                               0x0543
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_C_BASE_IDX                                                      2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_C                                                              0x0544
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_C_BASE_IDX                                                     2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_D                                                               0x0545
#define mmDCHUBBUB_ARB_FRAC_URG_BW_NOM_D_BASE_IDX                                                      2
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_D                                                              0x0546
#define mmDCHUBBUB_ARB_FRAC_URG_BW_FLIP_D_BASE_IDX                                                     2
#define mmFMON_CTRL                                                                                    0x0548
#define mmFMON_CTRL_BASE_IDX                                                                           2
#define mmFMON_CTRL_1                                                                                  0x0548
#define mmFMON_CTRL_1_BASE_IDX                                                                         2


// addressBlock: dce_dc_dchubbub_dchubbub_dcperfmon_dc_perfmon_dispdec
// base address: 0x1534
#define mmDC_PERFMON5_PERFCOUNTER_CNTL                                                                 0x054d
#define mmDC_PERFMON5_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON5_PERFCOUNTER_CNTL2                                                                0x054e
#define mmDC_PERFMON5_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON5_PERFCOUNTER_STATE                                                                0x054f
#define mmDC_PERFMON5_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON5_PERFMON_CNTL                                                                     0x0550
#define mmDC_PERFMON5_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON5_PERFMON_CNTL2                                                                    0x0551
#define mmDC_PERFMON5_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON5_PERFMON_CVALUE_INT_MISC                                                          0x0552
#define mmDC_PERFMON5_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON5_PERFMON_CVALUE_LOW                                                               0x0553
#define mmDC_PERFMON5_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON5_PERFMON_HI                                                                       0x0554
#define mmDC_PERFMON5_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON5_PERFMON_LOW                                                                      0x0555
#define mmDC_PERFMON5_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dchubbub_hubbub_vmrq_if_dispdec
// base address: 0x0
#define mmDCN_VM_CONTEXT0_CNTL                                                                         0x0559
#define mmDCN_VM_CONTEXT0_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32                                                    0x055a
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32                                                    0x055b
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32                                                   0x055c
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32                                                   0x055d
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32                                                     0x055e
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32                                                     0x055f
#define mmDCN_VM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT1_CNTL                                                                         0x0560
#define mmDCN_VM_CONTEXT1_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0561
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0562
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32                                                   0x0563
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32                                                   0x0564
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32                                                     0x0565
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32                                                     0x0566
#define mmDCN_VM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT2_CNTL                                                                         0x0567
#define mmDCN_VM_CONTEXT2_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0568
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0569
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32                                                   0x056a
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32                                                   0x056b
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32                                                     0x056c
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32                                                     0x056d
#define mmDCN_VM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT3_CNTL                                                                         0x056e
#define mmDCN_VM_CONTEXT3_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32                                                    0x056f
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0570
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32                                                   0x0571
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32                                                   0x0572
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32                                                     0x0573
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32                                                     0x0574
#define mmDCN_VM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT4_CNTL                                                                         0x0575
#define mmDCN_VM_CONTEXT4_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0576
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0577
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32                                                   0x0578
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32                                                   0x0579
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32                                                     0x057a
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32                                                     0x057b
#define mmDCN_VM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT5_CNTL                                                                         0x057c
#define mmDCN_VM_CONTEXT5_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32                                                    0x057d
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32                                                    0x057e
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32                                                   0x057f
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32                                                   0x0580
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32                                                     0x0581
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32                                                     0x0582
#define mmDCN_VM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT6_CNTL                                                                         0x0583
#define mmDCN_VM_CONTEXT6_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0584
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0585
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32                                                   0x0586
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32                                                   0x0587
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32                                                     0x0588
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32                                                     0x0589
#define mmDCN_VM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT7_CNTL                                                                         0x058a
#define mmDCN_VM_CONTEXT7_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32                                                    0x058b
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32                                                    0x058c
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32                                                   0x058d
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32                                                   0x058e
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32                                                     0x058f
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32                                                     0x0590
#define mmDCN_VM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT8_CNTL                                                                         0x0591
#define mmDCN_VM_CONTEXT8_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0592
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32                                                    0x0593
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32                                                   0x0594
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32                                                   0x0595
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32                                                     0x0596
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32                                                     0x0597
#define mmDCN_VM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT9_CNTL                                                                         0x0598
#define mmDCN_VM_CONTEXT9_CNTL_BASE_IDX                                                                2
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32                                                    0x0599
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32                                                    0x059a
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32                                                   0x059b
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32                                                   0x059c
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32                                                     0x059d
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32                                                     0x059e
#define mmDCN_VM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                            2
#define mmDCN_VM_CONTEXT10_CNTL                                                                        0x059f
#define mmDCN_VM_CONTEXT10_CNTL_BASE_IDX                                                               2
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05a0
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05a1
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32                                                  0x05a2
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32                                                  0x05a3
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32                                                    0x05a4
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32                                                    0x05a5
#define mmDCN_VM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT11_CNTL                                                                        0x05a6
#define mmDCN_VM_CONTEXT11_CNTL_BASE_IDX                                                               2
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05a7
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05a8
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32                                                  0x05a9
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32                                                  0x05aa
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32                                                    0x05ab
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32                                                    0x05ac
#define mmDCN_VM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT12_CNTL                                                                        0x05ad
#define mmDCN_VM_CONTEXT12_CNTL_BASE_IDX                                                               2
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05ae
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05af
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32                                                  0x05b0
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32                                                  0x05b1
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32                                                    0x05b2
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32                                                    0x05b3
#define mmDCN_VM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT13_CNTL                                                                        0x05b4
#define mmDCN_VM_CONTEXT13_CNTL_BASE_IDX                                                               2
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05b5
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05b6
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32                                                  0x05b7
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32                                                  0x05b8
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32                                                    0x05b9
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32                                                    0x05ba
#define mmDCN_VM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT14_CNTL                                                                        0x05bb
#define mmDCN_VM_CONTEXT14_CNTL_BASE_IDX                                                               2
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05bc
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05bd
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32                                                  0x05be
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32                                                  0x05bf
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32                                                    0x05c0
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32                                                    0x05c1
#define mmDCN_VM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT15_CNTL                                                                        0x05c2
#define mmDCN_VM_CONTEXT15_CNTL_BASE_IDX                                                               2
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32                                                   0x05c3
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32                                                   0x05c4
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                          2
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32                                                  0x05c5
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32                                                  0x05c6
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                         2
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32                                                    0x05c7
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                           2
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32                                                    0x05c8
#define mmDCN_VM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                           2
#define mmDCN_VM_DEFAULT_ADDR_MSB                                                                      0x05c9
#define mmDCN_VM_DEFAULT_ADDR_MSB_BASE_IDX                                                             2
#define mmDCN_VM_DEFAULT_ADDR_LSB                                                                      0x05ca
#define mmDCN_VM_DEFAULT_ADDR_LSB_BASE_IDX                                                             2
#define mmDCN_VM_FAULT_CNTL                                                                            0x05cb
#define mmDCN_VM_FAULT_CNTL_BASE_IDX                                                                   2
#define mmDCN_VM_FAULT_STATUS                                                                          0x05cc
#define mmDCN_VM_FAULT_STATUS_BASE_IDX                                                                 2
#define mmDCN_VM_FAULT_ADDR_MSB                                                                        0x05cd
#define mmDCN_VM_FAULT_ADDR_MSB_BASE_IDX                                                               2
#define mmDCN_VM_FAULT_ADDR_LSB                                                                        0x05ce
#define mmDCN_VM_FAULT_ADDR_LSB_BASE_IDX                                                               2


// addressBlock: dce_dc_dcbubp0_dispdec_hubp_dispdec
// base address: 0x0
#define mmHUBP0_DCSURF_SURFACE_CONFIG                                                                  0x05e5
#define mmHUBP0_DCSURF_SURFACE_CONFIG_BASE_IDX                                                         2
#define mmHUBP0_DCSURF_ADDR_CONFIG                                                                     0x05e6
#define mmHUBP0_DCSURF_ADDR_CONFIG_BASE_IDX                                                            2
#define mmHUBP0_DCSURF_TILING_CONFIG                                                                   0x05e7
#define mmHUBP0_DCSURF_TILING_CONFIG_BASE_IDX                                                          2
#define mmHUBP0_DCSURF_PRI_VIEWPORT_START                                                              0x05e9
#define mmHUBP0_DCSURF_PRI_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP0_DCSURF_PRI_VIEWPORT_DIMENSION                                                          0x05ea
#define mmHUBP0_DCSURF_PRI_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP0_DCSURF_PRI_VIEWPORT_START_C                                                            0x05eb
#define mmHUBP0_DCSURF_PRI_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP0_DCSURF_PRI_VIEWPORT_DIMENSION_C                                                        0x05ec
#define mmHUBP0_DCSURF_PRI_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP0_DCSURF_SEC_VIEWPORT_START                                                              0x05ed
#define mmHUBP0_DCSURF_SEC_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP0_DCSURF_SEC_VIEWPORT_DIMENSION                                                          0x05ee
#define mmHUBP0_DCSURF_SEC_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP0_DCSURF_SEC_VIEWPORT_START_C                                                            0x05ef
#define mmHUBP0_DCSURF_SEC_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP0_DCSURF_SEC_VIEWPORT_DIMENSION_C                                                        0x05f0
#define mmHUBP0_DCSURF_SEC_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP0_DCHUBP_REQ_SIZE_CONFIG                                                                 0x05f1
#define mmHUBP0_DCHUBP_REQ_SIZE_CONFIG_BASE_IDX                                                        2
#define mmHUBP0_DCHUBP_REQ_SIZE_CONFIG_C                                                               0x05f2
#define mmHUBP0_DCHUBP_REQ_SIZE_CONFIG_C_BASE_IDX                                                      2
#define mmHUBP0_DCHUBP_CNTL                                                                            0x05f3
#define mmHUBP0_DCHUBP_CNTL_BASE_IDX                                                                   2
#define mmHUBP0_HUBP_CLK_CNTL                                                                          0x05f4
#define mmHUBP0_HUBP_CLK_CNTL_BASE_IDX                                                                 2
#define mmHUBP0_DCHUBP_VMPG_CONFIG                                                                     0x05f5
#define mmHUBP0_DCHUBP_VMPG_CONFIG_BASE_IDX                                                            2
#define mmHUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK                                                           0x05fb
#define mmHUBP0_HUBP_MEASURE_WIN_CTRL_DCFCLK_BASE_IDX                                                  2
#define mmHUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK                                                           0x05fc
#define mmHUBP0_HUBP_MEASURE_WIN_CTRL_DPPCLK_BASE_IDX                                                  2
#define mmHUBP0_HUBPREQ_DEBUG_DB                                                                       0x05f6
#define mmHUBP0_HUBPREQ_DEBUG_DB_BASE_IDX                                                              2
#define mmHUBP0_HUBPREQ_DEBUG                                                                          0x05f7
#define mmHUBP0_HUBPREQ_DEBUG_BASE_IDX                                                                 2


// addressBlock: dce_dc_dcbubp0_dispdec_hubpreq_dispdec
// base address: 0x0
#define mmHUBPREQ0_DCSURF_SURFACE_PITCH                                                                0x0607
#define mmHUBPREQ0_DCSURF_SURFACE_PITCH_BASE_IDX                                                       2
#define mmHUBPREQ0_DCSURF_SURFACE_PITCH_C                                                              0x0608
#define mmHUBPREQ0_DCSURF_SURFACE_PITCH_C_BASE_IDX                                                     2
#define mmHUBPREQ0_VMID_SETTINGS_0                                                                     0x0609
#define mmHUBPREQ0_VMID_SETTINGS_0_BASE_IDX                                                            2
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS                                                      0x060a
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                             2
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH                                                 0x060b
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_C                                                    0x060c
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_C_BASE_IDX                                           2
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C                                               0x060d
#define mmHUBPREQ0_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                      2
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS                                                    0x060e
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                           2
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH                                               0x060f
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                      2
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_C                                                  0x0610
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_C_BASE_IDX                                         2
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C                                             0x0611
#define mmHUBPREQ0_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                    2
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS                                                 0x0612
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_BASE_IDX                                        2
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH                                            0x0613
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                   2
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C                                               0x0614
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C_BASE_IDX                                      2
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C                                          0x0615
#define mmHUBPREQ0_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                 2
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS                                               0x0616
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_BASE_IDX                                      2
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH                                          0x0617
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                 2
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C                                             0x0618
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C_BASE_IDX                                    2
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C                                        0x0619
#define mmHUBPREQ0_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                               2
#define mmHUBPREQ0_DCSURF_SURFACE_CONTROL                                                              0x061a
#define mmHUBPREQ0_DCSURF_SURFACE_CONTROL_BASE_IDX                                                     2
#define mmHUBPREQ0_DCSURF_FLIP_CONTROL                                                                 0x061b
#define mmHUBPREQ0_DCSURF_FLIP_CONTROL_BASE_IDX                                                        2
#define mmHUBPREQ0_DCSURF_FLIP_CONTROL2                                                                0x061c
#define mmHUBPREQ0_DCSURF_FLIP_CONTROL2_BASE_IDX                                                       2
#define mmHUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT                                                       0x0620
#define mmHUBPREQ0_DCSURF_SURFACE_FLIP_INTERRUPT_BASE_IDX                                              2
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE                                                                0x0621
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE_BASE_IDX                                                       2
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE_HIGH                                                           0x0622
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE_HIGH_BASE_IDX                                                  2
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE_C                                                              0x0623
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE_C_BASE_IDX                                                     2
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE_HIGH_C                                                         0x0624
#define mmHUBPREQ0_DCSURF_SURFACE_INUSE_HIGH_C_BASE_IDX                                                2
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE                                                       0x0625
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_BASE_IDX                                              2
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH                                                  0x0626
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_BASE_IDX                                         2
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_C                                                     0x0627
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_C_BASE_IDX                                            2
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C                                                0x0628
#define mmHUBPREQ0_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C_BASE_IDX                                       2
#define mmHUBPREQ0_DCN_EXPANSION_MODE                                                                  0x0629
#define mmHUBPREQ0_DCN_EXPANSION_MODE_BASE_IDX                                                         2
#define mmHUBPREQ0_DCN_TTU_QOS_WM                                                                      0x062a
#define mmHUBPREQ0_DCN_TTU_QOS_WM_BASE_IDX                                                             2
#define mmHUBPREQ0_DCN_GLOBAL_TTU_CNTL                                                                 0x062b
#define mmHUBPREQ0_DCN_GLOBAL_TTU_CNTL_BASE_IDX                                                        2
#define mmHUBPREQ0_DCN_SURF0_TTU_CNTL0                                                                 0x062c
#define mmHUBPREQ0_DCN_SURF0_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ0_DCN_SURF0_TTU_CNTL1                                                                 0x062d
#define mmHUBPREQ0_DCN_SURF0_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ0_DCN_SURF1_TTU_CNTL0                                                                 0x062e
#define mmHUBPREQ0_DCN_SURF1_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ0_DCN_SURF1_TTU_CNTL1                                                                 0x062f
#define mmHUBPREQ0_DCN_SURF1_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ0_DCN_CUR0_TTU_CNTL0                                                                  0x0630
#define mmHUBPREQ0_DCN_CUR0_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ0_DCN_CUR0_TTU_CNTL1                                                                  0x0631
#define mmHUBPREQ0_DCN_CUR0_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ0_DCN_CUR1_TTU_CNTL0                                                                  0x0632
#define mmHUBPREQ0_DCN_CUR1_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ0_DCN_CUR1_TTU_CNTL1                                                                  0x0633
#define mmHUBPREQ0_DCN_CUR1_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ0_DCN_DMDATA_VM_CNTL                                                                  0x0634
#define mmHUBPREQ0_DCN_DMDATA_VM_CNTL_BASE_IDX                                                         2
#define mmHUBPREQ0_DCN_VM_SYSTEM_APERTURE_LOW_ADDR                                                     0x0635
#define mmHUBPREQ0_DCN_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                            2
#define mmHUBPREQ0_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR                                                    0x0636
#define mmHUBPREQ0_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                           2
#define mmHUBPREQ0_DCN_VM_MX_L1_TLB_CNTL                                                               0x0643
#define mmHUBPREQ0_DCN_VM_MX_L1_TLB_CNTL_BASE_IDX                                                      2
#define mmHUBPREQ0_BLANK_OFFSET_0                                                                      0x0644
#define mmHUBPREQ0_BLANK_OFFSET_0_BASE_IDX                                                             2
#define mmHUBPREQ0_BLANK_OFFSET_1                                                                      0x0645
#define mmHUBPREQ0_BLANK_OFFSET_1_BASE_IDX                                                             2
#define mmHUBPREQ0_DST_DIMENSIONS                                                                      0x0646
#define mmHUBPREQ0_DST_DIMENSIONS_BASE_IDX                                                             2
#define mmHUBPREQ0_DST_AFTER_SCALER                                                                    0x0647
#define mmHUBPREQ0_DST_AFTER_SCALER_BASE_IDX                                                           2
#define mmHUBPREQ0_PREFETCH_SETTINGS                                                                   0x0648
#define mmHUBPREQ0_PREFETCH_SETTINGS_BASE_IDX                                                          2
#define mmHUBPREQ0_PREFETCH_SETTINGS_C                                                                 0x0649
#define mmHUBPREQ0_PREFETCH_SETTINGS_C_BASE_IDX                                                        2
#define mmHUBPREQ0_VBLANK_PARAMETERS_0                                                                 0x064a
#define mmHUBPREQ0_VBLANK_PARAMETERS_0_BASE_IDX                                                        2
#define mmHUBPREQ0_VBLANK_PARAMETERS_1                                                                 0x064b
#define mmHUBPREQ0_VBLANK_PARAMETERS_1_BASE_IDX                                                        2
#define mmHUBPREQ0_VBLANK_PARAMETERS_2                                                                 0x064c
#define mmHUBPREQ0_VBLANK_PARAMETERS_2_BASE_IDX                                                        2
#define mmHUBPREQ0_VBLANK_PARAMETERS_3                                                                 0x064d
#define mmHUBPREQ0_VBLANK_PARAMETERS_3_BASE_IDX                                                        2
#define mmHUBPREQ0_VBLANK_PARAMETERS_4                                                                 0x064e
#define mmHUBPREQ0_VBLANK_PARAMETERS_4_BASE_IDX                                                        2
#define mmHUBPREQ0_FLIP_PARAMETERS_0                                                                   0x064f
#define mmHUBPREQ0_FLIP_PARAMETERS_0_BASE_IDX                                                          2
#define mmHUBPREQ0_FLIP_PARAMETERS_1                                                                   0x0650
#define mmHUBPREQ0_FLIP_PARAMETERS_1_BASE_IDX                                                          2
#define mmHUBPREQ0_FLIP_PARAMETERS_2                                                                   0x0651
#define mmHUBPREQ0_FLIP_PARAMETERS_2_BASE_IDX                                                          2
#define mmHUBPREQ0_NOM_PARAMETERS_0                                                                    0x0652
#define mmHUBPREQ0_NOM_PARAMETERS_0_BASE_IDX                                                           2
#define mmHUBPREQ0_NOM_PARAMETERS_1                                                                    0x0653
#define mmHUBPREQ0_NOM_PARAMETERS_1_BASE_IDX                                                           2
#define mmHUBPREQ0_NOM_PARAMETERS_2                                                                    0x0654
#define mmHUBPREQ0_NOM_PARAMETERS_2_BASE_IDX                                                           2
#define mmHUBPREQ0_NOM_PARAMETERS_3                                                                    0x0655
#define mmHUBPREQ0_NOM_PARAMETERS_3_BASE_IDX                                                           2
#define mmHUBPREQ0_NOM_PARAMETERS_4                                                                    0x0656
#define mmHUBPREQ0_NOM_PARAMETERS_4_BASE_IDX                                                           2
#define mmHUBPREQ0_NOM_PARAMETERS_5                                                                    0x0657
#define mmHUBPREQ0_NOM_PARAMETERS_5_BASE_IDX                                                           2
#define mmHUBPREQ0_NOM_PARAMETERS_6                                                                    0x0658
#define mmHUBPREQ0_NOM_PARAMETERS_6_BASE_IDX                                                           2
#define mmHUBPREQ0_NOM_PARAMETERS_7                                                                    0x0659
#define mmHUBPREQ0_NOM_PARAMETERS_7_BASE_IDX                                                           2
#define mmHUBPREQ0_PER_LINE_DELIVERY_PRE                                                               0x065a
#define mmHUBPREQ0_PER_LINE_DELIVERY_PRE_BASE_IDX                                                      2
#define mmHUBPREQ0_PER_LINE_DELIVERY                                                                   0x065b
#define mmHUBPREQ0_PER_LINE_DELIVERY_BASE_IDX                                                          2
#define mmHUBPREQ0_CURSOR_SETTINGS                                                                     0x065c
#define mmHUBPREQ0_CURSOR_SETTINGS_BASE_IDX                                                            2
#define mmHUBPREQ0_REF_FREQ_TO_PIX_FREQ                                                                0x065d
#define mmHUBPREQ0_REF_FREQ_TO_PIX_FREQ_BASE_IDX                                                       2
#define mmHUBPREQ0_DST_Y_DELTA_DRQ_LIMIT                                                               0x065e
#define mmHUBPREQ0_DST_Y_DELTA_DRQ_LIMIT_BASE_IDX                                                      2
#define mmHUBPREQ0_HUBPREQ_MEM_PWR_CTRL                                                                0x065f
#define mmHUBPREQ0_HUBPREQ_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPREQ0_HUBPREQ_MEM_PWR_STATUS                                                              0x0660
#define mmHUBPREQ0_HUBPREQ_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPREQ0_VBLANK_PARAMETERS_5                                                                 0x0663
#define mmHUBPREQ0_VBLANK_PARAMETERS_5_BASE_IDX                                                        2
#define mmHUBPREQ0_VBLANK_PARAMETERS_6                                                                 0x0664
#define mmHUBPREQ0_VBLANK_PARAMETERS_6_BASE_IDX                                                        2
#define mmHUBPREQ0_FLIP_PARAMETERS_3                                                                   0x0665
#define mmHUBPREQ0_FLIP_PARAMETERS_3_BASE_IDX                                                          2
#define mmHUBPREQ0_FLIP_PARAMETERS_4                                                                   0x0666
#define mmHUBPREQ0_FLIP_PARAMETERS_4_BASE_IDX                                                          2
#define mmHUBPREQ0_FLIP_PARAMETERS_5                                                                   0x0667
#define mmHUBPREQ0_FLIP_PARAMETERS_5_BASE_IDX                                                          2
#define mmHUBPREQ0_FLIP_PARAMETERS_6                                                                   0x0668
#define mmHUBPREQ0_FLIP_PARAMETERS_6_BASE_IDX                                                          2


// addressBlock: dce_dc_dcbubp0_dispdec_hubpret_dispdec
// base address: 0x0
#define mmHUBPRET0_HUBPRET_CONTROL                                                                     0x066c
#define mmHUBPRET0_HUBPRET_CONTROL_BASE_IDX                                                            2
#define mmHUBPRET0_HUBPRET_MEM_PWR_CTRL                                                                0x066d
#define mmHUBPRET0_HUBPRET_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPRET0_HUBPRET_MEM_PWR_STATUS                                                              0x066e
#define mmHUBPRET0_HUBPRET_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPRET0_HUBPRET_READ_LINE_CTRL0                                                             0x066f
#define mmHUBPRET0_HUBPRET_READ_LINE_CTRL0_BASE_IDX                                                    2
#define mmHUBPRET0_HUBPRET_READ_LINE_CTRL1                                                             0x0670
#define mmHUBPRET0_HUBPRET_READ_LINE_CTRL1_BASE_IDX                                                    2
#define mmHUBPRET0_HUBPRET_READ_LINE0                                                                  0x0671
#define mmHUBPRET0_HUBPRET_READ_LINE0_BASE_IDX                                                         2
#define mmHUBPRET0_HUBPRET_READ_LINE1                                                                  0x0672
#define mmHUBPRET0_HUBPRET_READ_LINE1_BASE_IDX                                                         2
#define mmHUBPRET0_HUBPRET_INTERRUPT                                                                   0x0673
#define mmHUBPRET0_HUBPRET_INTERRUPT_BASE_IDX                                                          2
#define mmHUBPRET0_HUBPRET_READ_LINE_VALUE                                                             0x0674
#define mmHUBPRET0_HUBPRET_READ_LINE_VALUE_BASE_IDX                                                    2
#define mmHUBPRET0_HUBPRET_READ_LINE_STATUS                                                            0x0675
#define mmHUBPRET0_HUBPRET_READ_LINE_STATUS_BASE_IDX                                                   2


// addressBlock: dce_dc_dcbubp0_dispdec_cursor0_dispdec
// base address: 0x0
#define mmCURSOR0_0_CURSOR_CONTROL                                                                     0x0678
#define mmCURSOR0_0_CURSOR_CONTROL_BASE_IDX                                                            2
#define mmCURSOR0_0_CURSOR_SURFACE_ADDRESS                                                             0x0679
#define mmCURSOR0_0_CURSOR_SURFACE_ADDRESS_BASE_IDX                                                    2
#define mmCURSOR0_0_CURSOR_SURFACE_ADDRESS_HIGH                                                        0x067a
#define mmCURSOR0_0_CURSOR_SURFACE_ADDRESS_HIGH_BASE_IDX                                               2
#define mmCURSOR0_0_CURSOR_SIZE                                                                        0x067b
#define mmCURSOR0_0_CURSOR_SIZE_BASE_IDX                                                               2
#define mmCURSOR0_0_CURSOR_POSITION                                                                    0x067c
#define mmCURSOR0_0_CURSOR_POSITION_BASE_IDX                                                           2
#define mmCURSOR0_0_CURSOR_HOT_SPOT                                                                    0x067d
#define mmCURSOR0_0_CURSOR_HOT_SPOT_BASE_IDX                                                           2
#define mmCURSOR0_0_CURSOR_STEREO_CONTROL                                                              0x067e
#define mmCURSOR0_0_CURSOR_STEREO_CONTROL_BASE_IDX                                                     2
#define mmCURSOR0_0_CURSOR_DST_OFFSET                                                                  0x067f
#define mmCURSOR0_0_CURSOR_DST_OFFSET_BASE_IDX                                                         2
#define mmCURSOR0_0_CURSOR_MEM_PWR_CTRL                                                                0x0680
#define mmCURSOR0_0_CURSOR_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmCURSOR0_0_CURSOR_MEM_PWR_STATUS                                                              0x0681
#define mmCURSOR0_0_CURSOR_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmCURSOR0_0_DMDATA_ADDRESS_HIGH                                                                0x0682
#define mmCURSOR0_0_DMDATA_ADDRESS_HIGH_BASE_IDX                                                       2
#define mmCURSOR0_0_DMDATA_ADDRESS_LOW                                                                 0x0683
#define mmCURSOR0_0_DMDATA_ADDRESS_LOW_BASE_IDX                                                        2
#define mmCURSOR0_0_DMDATA_CNTL                                                                        0x0684
#define mmCURSOR0_0_DMDATA_CNTL_BASE_IDX                                                               2
#define mmCURSOR0_0_DMDATA_QOS_CNTL                                                                    0x0685
#define mmCURSOR0_0_DMDATA_QOS_CNTL_BASE_IDX                                                           2
#define mmCURSOR0_0_DMDATA_STATUS                                                                      0x0686
#define mmCURSOR0_0_DMDATA_STATUS_BASE_IDX                                                             2
#define mmCURSOR0_0_DMDATA_SW_CNTL                                                                     0x0687
#define mmCURSOR0_0_DMDATA_SW_CNTL_BASE_IDX                                                            2
#define mmCURSOR0_0_DMDATA_SW_DATA                                                                     0x0688
#define mmCURSOR0_0_DMDATA_SW_DATA_BASE_IDX                                                            2


// addressBlock: dce_dc_dcbubp0_dispdec_hubp_dcperfmon_dc_perfmon_dispdec
// base address: 0x1a74
#define mmDC_PERFMON6_PERFCOUNTER_CNTL                                                                 0x069d
#define mmDC_PERFMON6_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON6_PERFCOUNTER_CNTL2                                                                0x069e
#define mmDC_PERFMON6_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON6_PERFCOUNTER_STATE                                                                0x069f
#define mmDC_PERFMON6_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON6_PERFMON_CNTL                                                                     0x06a0
#define mmDC_PERFMON6_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON6_PERFMON_CNTL2                                                                    0x06a1
#define mmDC_PERFMON6_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON6_PERFMON_CVALUE_INT_MISC                                                          0x06a2
#define mmDC_PERFMON6_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON6_PERFMON_CVALUE_LOW                                                               0x06a3
#define mmDC_PERFMON6_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON6_PERFMON_HI                                                                       0x06a4
#define mmDC_PERFMON6_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON6_PERFMON_LOW                                                                      0x06a5
#define mmDC_PERFMON6_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dcbubp1_dispdec_hubp_dispdec
// base address: 0x370
#define mmHUBP1_DCSURF_SURFACE_CONFIG                                                                  0x06c1
#define mmHUBP1_DCSURF_SURFACE_CONFIG_BASE_IDX                                                         2
#define mmHUBP1_DCSURF_ADDR_CONFIG                                                                     0x06c2
#define mmHUBP1_DCSURF_ADDR_CONFIG_BASE_IDX                                                            2
#define mmHUBP1_DCSURF_TILING_CONFIG                                                                   0x06c3
#define mmHUBP1_DCSURF_TILING_CONFIG_BASE_IDX                                                          2
#define mmHUBP1_DCSURF_PRI_VIEWPORT_START                                                              0x06c5
#define mmHUBP1_DCSURF_PRI_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP1_DCSURF_PRI_VIEWPORT_DIMENSION                                                          0x06c6
#define mmHUBP1_DCSURF_PRI_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP1_DCSURF_PRI_VIEWPORT_START_C                                                            0x06c7
#define mmHUBP1_DCSURF_PRI_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP1_DCSURF_PRI_VIEWPORT_DIMENSION_C                                                        0x06c8
#define mmHUBP1_DCSURF_PRI_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP1_DCSURF_SEC_VIEWPORT_START                                                              0x06c9
#define mmHUBP1_DCSURF_SEC_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP1_DCSURF_SEC_VIEWPORT_DIMENSION                                                          0x06ca
#define mmHUBP1_DCSURF_SEC_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP1_DCSURF_SEC_VIEWPORT_START_C                                                            0x06cb
#define mmHUBP1_DCSURF_SEC_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP1_DCSURF_SEC_VIEWPORT_DIMENSION_C                                                        0x06cc
#define mmHUBP1_DCSURF_SEC_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP1_DCHUBP_REQ_SIZE_CONFIG                                                                 0x06cd
#define mmHUBP1_DCHUBP_REQ_SIZE_CONFIG_BASE_IDX                                                        2
#define mmHUBP1_DCHUBP_REQ_SIZE_CONFIG_C                                                               0x06ce
#define mmHUBP1_DCHUBP_REQ_SIZE_CONFIG_C_BASE_IDX                                                      2
#define mmHUBP1_DCHUBP_CNTL                                                                            0x06cf
#define mmHUBP1_DCHUBP_CNTL_BASE_IDX                                                                   2
#define mmHUBP1_HUBP_CLK_CNTL                                                                          0x06d0
#define mmHUBP1_HUBP_CLK_CNTL_BASE_IDX                                                                 2
#define mmHUBP1_DCHUBP_VMPG_CONFIG                                                                     0x06d1
#define mmHUBP1_DCHUBP_VMPG_CONFIG_BASE_IDX                                                            2
#define mmHUBP1_HUBPREQ_DEBUG_DB                                                                       0x06d2
#define mmHUBP1_HUBPREQ_DEBUG_DB_BASE_IDX                                                              2
#define mmHUBP1_HUBPREQ_DEBUG                                                                          0x06d3
#define mmHUBP1_HUBPREQ_DEBUG_BASE_IDX                                                                 2
#define mmHUBP1_HUBP_MEASURE_WIN_CTRL_DCFCLK                                                           0x06d7
#define mmHUBP1_HUBP_MEASURE_WIN_CTRL_DCFCLK_BASE_IDX                                                  2
#define mmHUBP1_HUBP_MEASURE_WIN_CTRL_DPPCLK                                                           0x06d8
#define mmHUBP1_HUBP_MEASURE_WIN_CTRL_DPPCLK_BASE_IDX                                                  2


// addressBlock: dce_dc_dcbubp1_dispdec_hubpreq_dispdec
// base address: 0x370
#define mmHUBPREQ1_DCSURF_SURFACE_PITCH                                                                0x06e3
#define mmHUBPREQ1_DCSURF_SURFACE_PITCH_BASE_IDX                                                       2
#define mmHUBPREQ1_DCSURF_SURFACE_PITCH_C                                                              0x06e4
#define mmHUBPREQ1_DCSURF_SURFACE_PITCH_C_BASE_IDX                                                     2
#define mmHUBPREQ1_VMID_SETTINGS_0                                                                     0x06e5
#define mmHUBPREQ1_VMID_SETTINGS_0_BASE_IDX                                                            2
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS                                                      0x06e6
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                             2
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH                                                 0x06e7
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_C                                                    0x06e8
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_C_BASE_IDX                                           2
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C                                               0x06e9
#define mmHUBPREQ1_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                      2
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS                                                    0x06ea
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                           2
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH                                               0x06eb
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                      2
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_C                                                  0x06ec
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_C_BASE_IDX                                         2
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C                                             0x06ed
#define mmHUBPREQ1_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                    2
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS                                                 0x06ee
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_BASE_IDX                                        2
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH                                            0x06ef
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                   2
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C                                               0x06f0
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C_BASE_IDX                                      2
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C                                          0x06f1
#define mmHUBPREQ1_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                 2
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS                                               0x06f2
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_BASE_IDX                                      2
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH                                          0x06f3
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                 2
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C                                             0x06f4
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C_BASE_IDX                                    2
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C                                        0x06f5
#define mmHUBPREQ1_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                               2
#define mmHUBPREQ1_DCSURF_SURFACE_CONTROL                                                              0x06f6
#define mmHUBPREQ1_DCSURF_SURFACE_CONTROL_BASE_IDX                                                     2
#define mmHUBPREQ1_DCSURF_FLIP_CONTROL                                                                 0x06f7
#define mmHUBPREQ1_DCSURF_FLIP_CONTROL_BASE_IDX                                                        2
#define mmHUBPREQ1_DCSURF_FLIP_CONTROL2                                                                0x06f8
#define mmHUBPREQ1_DCSURF_FLIP_CONTROL2_BASE_IDX                                                       2
#define mmHUBPREQ1_DCSURF_SURFACE_FLIP_INTERRUPT                                                       0x06fc
#define mmHUBPREQ1_DCSURF_SURFACE_FLIP_INTERRUPT_BASE_IDX                                              2
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE                                                                0x06fd
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE_BASE_IDX                                                       2
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE_HIGH                                                           0x06fe
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE_HIGH_BASE_IDX                                                  2
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE_C                                                              0x06ff
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE_C_BASE_IDX                                                     2
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE_HIGH_C                                                         0x0700
#define mmHUBPREQ1_DCSURF_SURFACE_INUSE_HIGH_C_BASE_IDX                                                2
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE                                                       0x0701
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_BASE_IDX                                              2
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_HIGH                                                  0x0702
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_BASE_IDX                                         2
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_C                                                     0x0703
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_C_BASE_IDX                                            2
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C                                                0x0704
#define mmHUBPREQ1_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C_BASE_IDX                                       2
#define mmHUBPREQ1_DCN_EXPANSION_MODE                                                                  0x0705
#define mmHUBPREQ1_DCN_EXPANSION_MODE_BASE_IDX                                                         2
#define mmHUBPREQ1_DCN_TTU_QOS_WM                                                                      0x0706
#define mmHUBPREQ1_DCN_TTU_QOS_WM_BASE_IDX                                                             2
#define mmHUBPREQ1_DCN_GLOBAL_TTU_CNTL                                                                 0x0707
#define mmHUBPREQ1_DCN_GLOBAL_TTU_CNTL_BASE_IDX                                                        2
#define mmHUBPREQ1_DCN_SURF0_TTU_CNTL0                                                                 0x0708
#define mmHUBPREQ1_DCN_SURF0_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ1_DCN_SURF0_TTU_CNTL1                                                                 0x0709
#define mmHUBPREQ1_DCN_SURF0_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ1_DCN_SURF1_TTU_CNTL0                                                                 0x070a
#define mmHUBPREQ1_DCN_SURF1_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ1_DCN_SURF1_TTU_CNTL1                                                                 0x070b
#define mmHUBPREQ1_DCN_SURF1_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ1_DCN_CUR0_TTU_CNTL0                                                                  0x070c
#define mmHUBPREQ1_DCN_CUR0_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ1_DCN_CUR0_TTU_CNTL1                                                                  0x070d
#define mmHUBPREQ1_DCN_CUR0_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ1_DCN_CUR1_TTU_CNTL0                                                                  0x070e
#define mmHUBPREQ1_DCN_CUR1_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ1_DCN_CUR1_TTU_CNTL1                                                                  0x070f
#define mmHUBPREQ1_DCN_CUR1_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ1_DCN_DMDATA_VM_CNTL                                                                  0x0710
#define mmHUBPREQ1_DCN_DMDATA_VM_CNTL_BASE_IDX                                                         2
#define mmHUBPREQ1_DCN_VM_SYSTEM_APERTURE_LOW_ADDR                                                     0x0711
#define mmHUBPREQ1_DCN_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                            2
#define mmHUBPREQ1_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR                                                    0x0712
#define mmHUBPREQ1_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                           2
#define mmHUBPREQ1_DCN_VM_MX_L1_TLB_CNTL                                                               0x071f
#define mmHUBPREQ1_DCN_VM_MX_L1_TLB_CNTL_BASE_IDX                                                      2
#define mmHUBPREQ1_BLANK_OFFSET_0                                                                      0x0720
#define mmHUBPREQ1_BLANK_OFFSET_0_BASE_IDX                                                             2
#define mmHUBPREQ1_BLANK_OFFSET_1                                                                      0x0721
#define mmHUBPREQ1_BLANK_OFFSET_1_BASE_IDX                                                             2
#define mmHUBPREQ1_DST_DIMENSIONS                                                                      0x0722
#define mmHUBPREQ1_DST_DIMENSIONS_BASE_IDX                                                             2
#define mmHUBPREQ1_DST_AFTER_SCALER                                                                    0x0723
#define mmHUBPREQ1_DST_AFTER_SCALER_BASE_IDX                                                           2
#define mmHUBPREQ1_PREFETCH_SETTINGS                                                                   0x0724
#define mmHUBPREQ1_PREFETCH_SETTINGS_BASE_IDX                                                          2
#define mmHUBPREQ1_PREFETCH_SETTINGS_C                                                                 0x0725
#define mmHUBPREQ1_PREFETCH_SETTINGS_C_BASE_IDX                                                        2
#define mmHUBPREQ1_VBLANK_PARAMETERS_0                                                                 0x0726
#define mmHUBPREQ1_VBLANK_PARAMETERS_0_BASE_IDX                                                        2
#define mmHUBPREQ1_VBLANK_PARAMETERS_1                                                                 0x0727
#define mmHUBPREQ1_VBLANK_PARAMETERS_1_BASE_IDX                                                        2
#define mmHUBPREQ1_VBLANK_PARAMETERS_2                                                                 0x0728
#define mmHUBPREQ1_VBLANK_PARAMETERS_2_BASE_IDX                                                        2
#define mmHUBPREQ1_VBLANK_PARAMETERS_3                                                                 0x0729
#define mmHUBPREQ1_VBLANK_PARAMETERS_3_BASE_IDX                                                        2
#define mmHUBPREQ1_VBLANK_PARAMETERS_4                                                                 0x072a
#define mmHUBPREQ1_VBLANK_PARAMETERS_4_BASE_IDX                                                        2
#define mmHUBPREQ1_FLIP_PARAMETERS_0                                                                   0x072b
#define mmHUBPREQ1_FLIP_PARAMETERS_0_BASE_IDX                                                          2
#define mmHUBPREQ1_FLIP_PARAMETERS_1                                                                   0x072c
#define mmHUBPREQ1_FLIP_PARAMETERS_1_BASE_IDX                                                          2
#define mmHUBPREQ1_FLIP_PARAMETERS_2                                                                   0x072d
#define mmHUBPREQ1_FLIP_PARAMETERS_2_BASE_IDX                                                          2
#define mmHUBPREQ1_NOM_PARAMETERS_0                                                                    0x072e
#define mmHUBPREQ1_NOM_PARAMETERS_0_BASE_IDX                                                           2
#define mmHUBPREQ1_NOM_PARAMETERS_1                                                                    0x072f
#define mmHUBPREQ1_NOM_PARAMETERS_1_BASE_IDX                                                           2
#define mmHUBPREQ1_NOM_PARAMETERS_2                                                                    0x0730
#define mmHUBPREQ1_NOM_PARAMETERS_2_BASE_IDX                                                           2
#define mmHUBPREQ1_NOM_PARAMETERS_3                                                                    0x0731
#define mmHUBPREQ1_NOM_PARAMETERS_3_BASE_IDX                                                           2
#define mmHUBPREQ1_NOM_PARAMETERS_4                                                                    0x0732
#define mmHUBPREQ1_NOM_PARAMETERS_4_BASE_IDX                                                           2
#define mmHUBPREQ1_NOM_PARAMETERS_5                                                                    0x0733
#define mmHUBPREQ1_NOM_PARAMETERS_5_BASE_IDX                                                           2
#define mmHUBPREQ1_NOM_PARAMETERS_6                                                                    0x0734
#define mmHUBPREQ1_NOM_PARAMETERS_6_BASE_IDX                                                           2
#define mmHUBPREQ1_NOM_PARAMETERS_7                                                                    0x0735
#define mmHUBPREQ1_NOM_PARAMETERS_7_BASE_IDX                                                           2
#define mmHUBPREQ1_PER_LINE_DELIVERY_PRE                                                               0x0736
#define mmHUBPREQ1_PER_LINE_DELIVERY_PRE_BASE_IDX                                                      2
#define mmHUBPREQ1_PER_LINE_DELIVERY                                                                   0x0737
#define mmHUBPREQ1_PER_LINE_DELIVERY_BASE_IDX                                                          2
#define mmHUBPREQ1_CURSOR_SETTINGS                                                                     0x0738
#define mmHUBPREQ1_CURSOR_SETTINGS_BASE_IDX                                                            2
#define mmHUBPREQ1_REF_FREQ_TO_PIX_FREQ                                                                0x0739
#define mmHUBPREQ1_REF_FREQ_TO_PIX_FREQ_BASE_IDX                                                       2
#define mmHUBPREQ1_DST_Y_DELTA_DRQ_LIMIT                                                               0x073a
#define mmHUBPREQ1_DST_Y_DELTA_DRQ_LIMIT_BASE_IDX                                                      2
#define mmHUBPREQ1_HUBPREQ_MEM_PWR_CTRL                                                                0x073b
#define mmHUBPREQ1_HUBPREQ_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPREQ1_HUBPREQ_MEM_PWR_STATUS                                                              0x073c
#define mmHUBPREQ1_HUBPREQ_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPREQ1_VBLANK_PARAMETERS_5                                                                 0x073f
#define mmHUBPREQ1_VBLANK_PARAMETERS_5_BASE_IDX                                                        2
#define mmHUBPREQ1_VBLANK_PARAMETERS_6                                                                 0x0740
#define mmHUBPREQ1_VBLANK_PARAMETERS_6_BASE_IDX                                                        2
#define mmHUBPREQ1_FLIP_PARAMETERS_3                                                                   0x0741
#define mmHUBPREQ1_FLIP_PARAMETERS_3_BASE_IDX                                                          2
#define mmHUBPREQ1_FLIP_PARAMETERS_4                                                                   0x0742
#define mmHUBPREQ1_FLIP_PARAMETERS_4_BASE_IDX                                                          2
#define mmHUBPREQ1_FLIP_PARAMETERS_5                                                                   0x0743
#define mmHUBPREQ1_FLIP_PARAMETERS_5_BASE_IDX                                                          2
#define mmHUBPREQ1_FLIP_PARAMETERS_6                                                                   0x0744
#define mmHUBPREQ1_FLIP_PARAMETERS_6_BASE_IDX                                                          2


// addressBlock: dce_dc_dcbubp1_dispdec_hubpret_dispdec
// base address: 0x370
#define mmHUBPRET1_HUBPRET_CONTROL                                                                     0x0748
#define mmHUBPRET1_HUBPRET_CONTROL_BASE_IDX                                                            2
#define mmHUBPRET1_HUBPRET_MEM_PWR_CTRL                                                                0x0749
#define mmHUBPRET1_HUBPRET_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPRET1_HUBPRET_MEM_PWR_STATUS                                                              0x074a
#define mmHUBPRET1_HUBPRET_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPRET1_HUBPRET_READ_LINE_CTRL0                                                             0x074b
#define mmHUBPRET1_HUBPRET_READ_LINE_CTRL0_BASE_IDX                                                    2
#define mmHUBPRET1_HUBPRET_READ_LINE_CTRL1                                                             0x074c
#define mmHUBPRET1_HUBPRET_READ_LINE_CTRL1_BASE_IDX                                                    2
#define mmHUBPRET1_HUBPRET_READ_LINE0                                                                  0x074d
#define mmHUBPRET1_HUBPRET_READ_LINE0_BASE_IDX                                                         2
#define mmHUBPRET1_HUBPRET_READ_LINE1                                                                  0x074e
#define mmHUBPRET1_HUBPRET_READ_LINE1_BASE_IDX                                                         2
#define mmHUBPRET1_HUBPRET_INTERRUPT                                                                   0x074f
#define mmHUBPRET1_HUBPRET_INTERRUPT_BASE_IDX                                                          2
#define mmHUBPRET1_HUBPRET_READ_LINE_VALUE                                                             0x0750
#define mmHUBPRET1_HUBPRET_READ_LINE_VALUE_BASE_IDX                                                    2
#define mmHUBPRET1_HUBPRET_READ_LINE_STATUS                                                            0x0751
#define mmHUBPRET1_HUBPRET_READ_LINE_STATUS_BASE_IDX                                                   2


// addressBlock: dce_dc_dcbubp1_dispdec_cursor0_dispdec
// base address: 0x370
#define mmCURSOR0_1_CURSOR_CONTROL                                                                     0x0754
#define mmCURSOR0_1_CURSOR_CONTROL_BASE_IDX                                                            2
#define mmCURSOR0_1_CURSOR_SURFACE_ADDRESS                                                             0x0755
#define mmCURSOR0_1_CURSOR_SURFACE_ADDRESS_BASE_IDX                                                    2
#define mmCURSOR0_1_CURSOR_SURFACE_ADDRESS_HIGH                                                        0x0756
#define mmCURSOR0_1_CURSOR_SURFACE_ADDRESS_HIGH_BASE_IDX                                               2
#define mmCURSOR0_1_CURSOR_SIZE                                                                        0x0757
#define mmCURSOR0_1_CURSOR_SIZE_BASE_IDX                                                               2
#define mmCURSOR0_1_CURSOR_POSITION                                                                    0x0758
#define mmCURSOR0_1_CURSOR_POSITION_BASE_IDX                                                           2
#define mmCURSOR0_1_CURSOR_HOT_SPOT                                                                    0x0759
#define mmCURSOR0_1_CURSOR_HOT_SPOT_BASE_IDX                                                           2
#define mmCURSOR0_1_CURSOR_STEREO_CONTROL                                                              0x075a
#define mmCURSOR0_1_CURSOR_STEREO_CONTROL_BASE_IDX                                                     2
#define mmCURSOR0_1_CURSOR_DST_OFFSET                                                                  0x075b
#define mmCURSOR0_1_CURSOR_DST_OFFSET_BASE_IDX                                                         2
#define mmCURSOR0_1_CURSOR_MEM_PWR_CTRL                                                                0x075c
#define mmCURSOR0_1_CURSOR_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmCURSOR0_1_CURSOR_MEM_PWR_STATUS                                                              0x075d
#define mmCURSOR0_1_CURSOR_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmCURSOR0_1_DMDATA_ADDRESS_HIGH                                                                0x075e
#define mmCURSOR0_1_DMDATA_ADDRESS_HIGH_BASE_IDX                                                       2
#define mmCURSOR0_1_DMDATA_ADDRESS_LOW                                                                 0x075f
#define mmCURSOR0_1_DMDATA_ADDRESS_LOW_BASE_IDX                                                        2
#define mmCURSOR0_1_DMDATA_CNTL                                                                        0x0760
#define mmCURSOR0_1_DMDATA_CNTL_BASE_IDX                                                               2
#define mmCURSOR0_1_DMDATA_QOS_CNTL                                                                    0x0761
#define mmCURSOR0_1_DMDATA_QOS_CNTL_BASE_IDX                                                           2
#define mmCURSOR0_1_DMDATA_STATUS                                                                      0x0762
#define mmCURSOR0_1_DMDATA_STATUS_BASE_IDX                                                             2
#define mmCURSOR0_1_DMDATA_SW_CNTL                                                                     0x0763
#define mmCURSOR0_1_DMDATA_SW_CNTL_BASE_IDX                                                            2
#define mmCURSOR0_1_DMDATA_SW_DATA                                                                     0x0764
#define mmCURSOR0_1_DMDATA_SW_DATA_BASE_IDX                                                            2


// addressBlock: dce_dc_dcbubp1_dispdec_hubp_dcperfmon_dc_perfmon_dispdec
// base address: 0x1de4
#define mmDC_PERFMON7_PERFCOUNTER_CNTL                                                                 0x0779
#define mmDC_PERFMON7_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON7_PERFCOUNTER_CNTL2                                                                0x077a
#define mmDC_PERFMON7_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON7_PERFCOUNTER_STATE                                                                0x077b
#define mmDC_PERFMON7_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON7_PERFMON_CNTL                                                                     0x077c
#define mmDC_PERFMON7_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON7_PERFMON_CNTL2                                                                    0x077d
#define mmDC_PERFMON7_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON7_PERFMON_CVALUE_INT_MISC                                                          0x077e
#define mmDC_PERFMON7_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON7_PERFMON_CVALUE_LOW                                                               0x077f
#define mmDC_PERFMON7_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON7_PERFMON_HI                                                                       0x0780
#define mmDC_PERFMON7_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON7_PERFMON_LOW                                                                      0x0781
#define mmDC_PERFMON7_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dcbubp2_dispdec_hubp_dispdec
// base address: 0x6e0
#define mmHUBP2_DCSURF_SURFACE_CONFIG                                                                  0x079d
#define mmHUBP2_DCSURF_SURFACE_CONFIG_BASE_IDX                                                         2
#define mmHUBP2_DCSURF_ADDR_CONFIG                                                                     0x079e
#define mmHUBP2_DCSURF_ADDR_CONFIG_BASE_IDX                                                            2
#define mmHUBP2_DCSURF_TILING_CONFIG                                                                   0x079f
#define mmHUBP2_DCSURF_TILING_CONFIG_BASE_IDX                                                          2
#define mmHUBP2_DCSURF_PRI_VIEWPORT_START                                                              0x07a1
#define mmHUBP2_DCSURF_PRI_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP2_DCSURF_PRI_VIEWPORT_DIMENSION                                                          0x07a2
#define mmHUBP2_DCSURF_PRI_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP2_DCSURF_PRI_VIEWPORT_START_C                                                            0x07a3
#define mmHUBP2_DCSURF_PRI_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP2_DCSURF_PRI_VIEWPORT_DIMENSION_C                                                        0x07a4
#define mmHUBP2_DCSURF_PRI_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP2_DCSURF_SEC_VIEWPORT_START                                                              0x07a5
#define mmHUBP2_DCSURF_SEC_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP2_DCSURF_SEC_VIEWPORT_DIMENSION                                                          0x07a6
#define mmHUBP2_DCSURF_SEC_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP2_DCSURF_SEC_VIEWPORT_START_C                                                            0x07a7
#define mmHUBP2_DCSURF_SEC_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP2_DCSURF_SEC_VIEWPORT_DIMENSION_C                                                        0x07a8
#define mmHUBP2_DCSURF_SEC_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP2_DCHUBP_REQ_SIZE_CONFIG                                                                 0x07a9
#define mmHUBP2_DCHUBP_REQ_SIZE_CONFIG_BASE_IDX                                                        2
#define mmHUBP2_DCHUBP_REQ_SIZE_CONFIG_C                                                               0x07aa
#define mmHUBP2_DCHUBP_REQ_SIZE_CONFIG_C_BASE_IDX                                                      2
#define mmHUBP2_DCHUBP_CNTL                                                                            0x07ab
#define mmHUBP2_DCHUBP_CNTL_BASE_IDX                                                                   2
#define mmHUBP2_HUBP_CLK_CNTL                                                                          0x07ac
#define mmHUBP2_HUBP_CLK_CNTL_BASE_IDX                                                                 2
#define mmHUBP2_DCHUBP_VMPG_CONFIG                                                                     0x07ad
#define mmHUBP2_DCHUBP_VMPG_CONFIG_BASE_IDX                                                            2
#define mmHUBP2_HUBPREQ_DEBUG_DB                                                                       0x07ae
#define mmHUBP2_HUBPREQ_DEBUG_DB_BASE_IDX                                                              2
#define mmHUBP2_HUBPREQ_DEBUG                                                                          0x07af
#define mmHUBP2_HUBPREQ_DEBUG_BASE_IDX                                                                 2
#define mmHUBP2_HUBP_MEASURE_WIN_CTRL_DCFCLK                                                           0x07b3
#define mmHUBP2_HUBP_MEASURE_WIN_CTRL_DCFCLK_BASE_IDX                                                  2
#define mmHUBP2_HUBP_MEASURE_WIN_CTRL_DPPCLK                                                           0x07b4
#define mmHUBP2_HUBP_MEASURE_WIN_CTRL_DPPCLK_BASE_IDX                                                  2


// addressBlock: dce_dc_dcbubp2_dispdec_hubpreq_dispdec
// base address: 0x6e0
#define mmHUBPREQ2_DCSURF_SURFACE_PITCH                                                                0x07bf
#define mmHUBPREQ2_DCSURF_SURFACE_PITCH_BASE_IDX                                                       2
#define mmHUBPREQ2_DCSURF_SURFACE_PITCH_C                                                              0x07c0
#define mmHUBPREQ2_DCSURF_SURFACE_PITCH_C_BASE_IDX                                                     2
#define mmHUBPREQ2_VMID_SETTINGS_0                                                                     0x07c1
#define mmHUBPREQ2_VMID_SETTINGS_0_BASE_IDX                                                            2
#define mmHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS                                                      0x07c2
#define mmHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                             2
#define mmHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH                                                 0x07c3
#define mmHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define mmHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS_C                                                    0x07c4
#define mmHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS_C_BASE_IDX                                           2
#define mmHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C                                               0x07c5
#define mmHUBPREQ2_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                      2
#define mmHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS                                                    0x07c6
#define mmHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                           2
#define mmHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH                                               0x07c7
#define mmHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                      2
#define mmHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS_C                                                  0x07c8
#define mmHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS_C_BASE_IDX                                         2
#define mmHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C                                             0x07c9
#define mmHUBPREQ2_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                    2
#define mmHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS                                                 0x07ca
#define mmHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS_BASE_IDX                                        2
#define mmHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH                                            0x07cb
#define mmHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                   2
#define mmHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C                                               0x07cc
#define mmHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C_BASE_IDX                                      2
#define mmHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C                                          0x07cd
#define mmHUBPREQ2_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                 2
#define mmHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS                                               0x07ce
#define mmHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS_BASE_IDX                                      2
#define mmHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH                                          0x07cf
#define mmHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                 2
#define mmHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C                                             0x07d0
#define mmHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C_BASE_IDX                                    2
#define mmHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C                                        0x07d1
#define mmHUBPREQ2_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                               2
#define mmHUBPREQ2_DCSURF_SURFACE_CONTROL                                                              0x07d2
#define mmHUBPREQ2_DCSURF_SURFACE_CONTROL_BASE_IDX                                                     2
#define mmHUBPREQ2_DCSURF_FLIP_CONTROL                                                                 0x07d3
#define mmHUBPREQ2_DCSURF_FLIP_CONTROL_BASE_IDX                                                        2
#define mmHUBPREQ2_DCSURF_FLIP_CONTROL2                                                                0x07d4
#define mmHUBPREQ2_DCSURF_FLIP_CONTROL2_BASE_IDX                                                       2
#define mmHUBPREQ2_DCSURF_SURFACE_FLIP_INTERRUPT                                                       0x07d8
#define mmHUBPREQ2_DCSURF_SURFACE_FLIP_INTERRUPT_BASE_IDX                                              2
#define mmHUBPREQ2_DCSURF_SURFACE_INUSE                                                                0x07d9
#define mmHUBPREQ2_DCSURF_SURFACE_INUSE_BASE_IDX                                                       2
#define mmHUBPREQ2_DCSURF_SURFACE_INUSE_HIGH                                                           0x07da
#define mmHUBPREQ2_DCSURF_SURFACE_INUSE_HIGH_BASE_IDX                                                  2
#define mmHUBPREQ2_DCSURF_SURFACE_INUSE_C                                                              0x07db
#define mmHUBPREQ2_DCSURF_SURFACE_INUSE_C_BASE_IDX                                                     2
#define mmHUBPREQ2_DCSURF_SURFACE_INUSE_HIGH_C                                                         0x07dc
#define mmHUBPREQ2_DCSURF_SURFACE_INUSE_HIGH_C_BASE_IDX                                                2
#define mmHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE                                                       0x07dd
#define mmHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE_BASE_IDX                                              2
#define mmHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE_HIGH                                                  0x07de
#define mmHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_BASE_IDX                                         2
#define mmHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE_C                                                     0x07df
#define mmHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE_C_BASE_IDX                                            2
#define mmHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C                                                0x07e0
#define mmHUBPREQ2_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C_BASE_IDX                                       2
#define mmHUBPREQ2_DCN_EXPANSION_MODE                                                                  0x07e1
#define mmHUBPREQ2_DCN_EXPANSION_MODE_BASE_IDX                                                         2
#define mmHUBPREQ2_DCN_TTU_QOS_WM                                                                      0x07e2
#define mmHUBPREQ2_DCN_TTU_QOS_WM_BASE_IDX                                                             2
#define mmHUBPREQ2_DCN_GLOBAL_TTU_CNTL                                                                 0x07e3
#define mmHUBPREQ2_DCN_GLOBAL_TTU_CNTL_BASE_IDX                                                        2
#define mmHUBPREQ2_DCN_SURF0_TTU_CNTL0                                                                 0x07e4
#define mmHUBPREQ2_DCN_SURF0_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ2_DCN_SURF0_TTU_CNTL1                                                                 0x07e5
#define mmHUBPREQ2_DCN_SURF0_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ2_DCN_SURF1_TTU_CNTL0                                                                 0x07e6
#define mmHUBPREQ2_DCN_SURF1_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ2_DCN_SURF1_TTU_CNTL1                                                                 0x07e7
#define mmHUBPREQ2_DCN_SURF1_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ2_DCN_CUR0_TTU_CNTL0                                                                  0x07e8
#define mmHUBPREQ2_DCN_CUR0_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ2_DCN_CUR0_TTU_CNTL1                                                                  0x07e9
#define mmHUBPREQ2_DCN_CUR0_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ2_DCN_CUR1_TTU_CNTL0                                                                  0x07ea
#define mmHUBPREQ2_DCN_CUR1_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ2_DCN_CUR1_TTU_CNTL1                                                                  0x07eb
#define mmHUBPREQ2_DCN_CUR1_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ2_DCN_DMDATA_VM_CNTL                                                                  0x07ec
#define mmHUBPREQ2_DCN_DMDATA_VM_CNTL_BASE_IDX                                                         2
#define mmHUBPREQ2_DCN_VM_SYSTEM_APERTURE_LOW_ADDR                                                     0x07ed
#define mmHUBPREQ2_DCN_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                            2
#define mmHUBPREQ2_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR                                                    0x07ee
#define mmHUBPREQ2_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                           2
#define mmHUBPREQ2_DCN_VM_MX_L1_TLB_CNTL                                                               0x07fb
#define mmHUBPREQ2_DCN_VM_MX_L1_TLB_CNTL_BASE_IDX                                                      2
#define mmHUBPREQ2_BLANK_OFFSET_0                                                                      0x07fc
#define mmHUBPREQ2_BLANK_OFFSET_0_BASE_IDX                                                             2
#define mmHUBPREQ2_BLANK_OFFSET_1                                                                      0x07fd
#define mmHUBPREQ2_BLANK_OFFSET_1_BASE_IDX                                                             2
#define mmHUBPREQ2_DST_DIMENSIONS                                                                      0x07fe
#define mmHUBPREQ2_DST_DIMENSIONS_BASE_IDX                                                             2
#define mmHUBPREQ2_DST_AFTER_SCALER                                                                    0x07ff
#define mmHUBPREQ2_DST_AFTER_SCALER_BASE_IDX                                                           2
#define mmHUBPREQ2_PREFETCH_SETTINGS                                                                   0x0800
#define mmHUBPREQ2_PREFETCH_SETTINGS_BASE_IDX                                                          2
#define mmHUBPREQ2_PREFETCH_SETTINGS_C                                                                 0x0801
#define mmHUBPREQ2_PREFETCH_SETTINGS_C_BASE_IDX                                                        2
#define mmHUBPREQ2_VBLANK_PARAMETERS_0                                                                 0x0802
#define mmHUBPREQ2_VBLANK_PARAMETERS_0_BASE_IDX                                                        2
#define mmHUBPREQ2_VBLANK_PARAMETERS_1                                                                 0x0803
#define mmHUBPREQ2_VBLANK_PARAMETERS_1_BASE_IDX                                                        2
#define mmHUBPREQ2_VBLANK_PARAMETERS_2                                                                 0x0804
#define mmHUBPREQ2_VBLANK_PARAMETERS_2_BASE_IDX                                                        2
#define mmHUBPREQ2_VBLANK_PARAMETERS_3                                                                 0x0805
#define mmHUBPREQ2_VBLANK_PARAMETERS_3_BASE_IDX                                                        2
#define mmHUBPREQ2_VBLANK_PARAMETERS_4                                                                 0x0806
#define mmHUBPREQ2_VBLANK_PARAMETERS_4_BASE_IDX                                                        2
#define mmHUBPREQ2_FLIP_PARAMETERS_0                                                                   0x0807
#define mmHUBPREQ2_FLIP_PARAMETERS_0_BASE_IDX                                                          2
#define mmHUBPREQ2_FLIP_PARAMETERS_1                                                                   0x0808
#define mmHUBPREQ2_FLIP_PARAMETERS_1_BASE_IDX                                                          2
#define mmHUBPREQ2_FLIP_PARAMETERS_2                                                                   0x0809
#define mmHUBPREQ2_FLIP_PARAMETERS_2_BASE_IDX                                                          2
#define mmHUBPREQ2_NOM_PARAMETERS_0                                                                    0x080a
#define mmHUBPREQ2_NOM_PARAMETERS_0_BASE_IDX                                                           2
#define mmHUBPREQ2_NOM_PARAMETERS_1                                                                    0x080b
#define mmHUBPREQ2_NOM_PARAMETERS_1_BASE_IDX                                                           2
#define mmHUBPREQ2_NOM_PARAMETERS_2                                                                    0x080c
#define mmHUBPREQ2_NOM_PARAMETERS_2_BASE_IDX                                                           2
#define mmHUBPREQ2_NOM_PARAMETERS_3                                                                    0x080d
#define mmHUBPREQ2_NOM_PARAMETERS_3_BASE_IDX                                                           2
#define mmHUBPREQ2_NOM_PARAMETERS_4                                                                    0x080e
#define mmHUBPREQ2_NOM_PARAMETERS_4_BASE_IDX                                                           2
#define mmHUBPREQ2_NOM_PARAMETERS_5                                                                    0x080f
#define mmHUBPREQ2_NOM_PARAMETERS_5_BASE_IDX                                                           2
#define mmHUBPREQ2_NOM_PARAMETERS_6                                                                    0x0810
#define mmHUBPREQ2_NOM_PARAMETERS_6_BASE_IDX                                                           2
#define mmHUBPREQ2_NOM_PARAMETERS_7                                                                    0x0811
#define mmHUBPREQ2_NOM_PARAMETERS_7_BASE_IDX                                                           2
#define mmHUBPREQ2_PER_LINE_DELIVERY_PRE                                                               0x0812
#define mmHUBPREQ2_PER_LINE_DELIVERY_PRE_BASE_IDX                                                      2
#define mmHUBPREQ2_PER_LINE_DELIVERY                                                                   0x0813
#define mmHUBPREQ2_PER_LINE_DELIVERY_BASE_IDX                                                          2
#define mmHUBPREQ2_CURSOR_SETTINGS                                                                     0x0814
#define mmHUBPREQ2_CURSOR_SETTINGS_BASE_IDX                                                            2
#define mmHUBPREQ2_REF_FREQ_TO_PIX_FREQ                                                                0x0815
#define mmHUBPREQ2_REF_FREQ_TO_PIX_FREQ_BASE_IDX                                                       2
#define mmHUBPREQ2_DST_Y_DELTA_DRQ_LIMIT                                                               0x0816
#define mmHUBPREQ2_DST_Y_DELTA_DRQ_LIMIT_BASE_IDX                                                      2
#define mmHUBPREQ2_HUBPREQ_MEM_PWR_CTRL                                                                0x0817
#define mmHUBPREQ2_HUBPREQ_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPREQ2_HUBPREQ_MEM_PWR_STATUS                                                              0x0818
#define mmHUBPREQ2_HUBPREQ_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPREQ2_VBLANK_PARAMETERS_5                                                                 0x081b
#define mmHUBPREQ2_VBLANK_PARAMETERS_5_BASE_IDX                                                        2
#define mmHUBPREQ2_VBLANK_PARAMETERS_6                                                                 0x081c
#define mmHUBPREQ2_VBLANK_PARAMETERS_6_BASE_IDX                                                        2
#define mmHUBPREQ2_FLIP_PARAMETERS_3                                                                   0x081d
#define mmHUBPREQ2_FLIP_PARAMETERS_3_BASE_IDX                                                          2
#define mmHUBPREQ2_FLIP_PARAMETERS_4                                                                   0x081e
#define mmHUBPREQ2_FLIP_PARAMETERS_4_BASE_IDX                                                          2
#define mmHUBPREQ2_FLIP_PARAMETERS_5                                                                   0x081f
#define mmHUBPREQ2_FLIP_PARAMETERS_5_BASE_IDX                                                          2
#define mmHUBPREQ2_FLIP_PARAMETERS_6                                                                   0x0820
#define mmHUBPREQ2_FLIP_PARAMETERS_6_BASE_IDX                                                          2


// addressBlock: dce_dc_dcbubp2_dispdec_hubpret_dispdec
// base address: 0x6e0
#define mmHUBPRET2_HUBPRET_CONTROL                                                                     0x0824
#define mmHUBPRET2_HUBPRET_CONTROL_BASE_IDX                                                            2
#define mmHUBPRET2_HUBPRET_MEM_PWR_CTRL                                                                0x0825
#define mmHUBPRET2_HUBPRET_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPRET2_HUBPRET_MEM_PWR_STATUS                                                              0x0826
#define mmHUBPRET2_HUBPRET_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPRET2_HUBPRET_READ_LINE_CTRL0                                                             0x0827
#define mmHUBPRET2_HUBPRET_READ_LINE_CTRL0_BASE_IDX                                                    2
#define mmHUBPRET2_HUBPRET_READ_LINE_CTRL1                                                             0x0828
#define mmHUBPRET2_HUBPRET_READ_LINE_CTRL1_BASE_IDX                                                    2
#define mmHUBPRET2_HUBPRET_READ_LINE0                                                                  0x0829
#define mmHUBPRET2_HUBPRET_READ_LINE0_BASE_IDX                                                         2
#define mmHUBPRET2_HUBPRET_READ_LINE1                                                                  0x082a
#define mmHUBPRET2_HUBPRET_READ_LINE1_BASE_IDX                                                         2
#define mmHUBPRET2_HUBPRET_INTERRUPT                                                                   0x082b
#define mmHUBPRET2_HUBPRET_INTERRUPT_BASE_IDX                                                          2
#define mmHUBPRET2_HUBPRET_READ_LINE_VALUE                                                             0x082c
#define mmHUBPRET2_HUBPRET_READ_LINE_VALUE_BASE_IDX                                                    2
#define mmHUBPRET2_HUBPRET_READ_LINE_STATUS                                                            0x082d
#define mmHUBPRET2_HUBPRET_READ_LINE_STATUS_BASE_IDX                                                   2


// addressBlock: dce_dc_dcbubp2_dispdec_cursor0_dispdec
// base address: 0x6e0
#define mmCURSOR0_2_CURSOR_CONTROL                                                                     0x0830
#define mmCURSOR0_2_CURSOR_CONTROL_BASE_IDX                                                            2
#define mmCURSOR0_2_CURSOR_SURFACE_ADDRESS                                                             0x0831
#define mmCURSOR0_2_CURSOR_SURFACE_ADDRESS_BASE_IDX                                                    2
#define mmCURSOR0_2_CURSOR_SURFACE_ADDRESS_HIGH                                                        0x0832
#define mmCURSOR0_2_CURSOR_SURFACE_ADDRESS_HIGH_BASE_IDX                                               2
#define mmCURSOR0_2_CURSOR_SIZE                                                                        0x0833
#define mmCURSOR0_2_CURSOR_SIZE_BASE_IDX                                                               2
#define mmCURSOR0_2_CURSOR_POSITION                                                                    0x0834
#define mmCURSOR0_2_CURSOR_POSITION_BASE_IDX                                                           2
#define mmCURSOR0_2_CURSOR_HOT_SPOT                                                                    0x0835
#define mmCURSOR0_2_CURSOR_HOT_SPOT_BASE_IDX                                                           2
#define mmCURSOR0_2_CURSOR_STEREO_CONTROL                                                              0x0836
#define mmCURSOR0_2_CURSOR_STEREO_CONTROL_BASE_IDX                                                     2
#define mmCURSOR0_2_CURSOR_DST_OFFSET                                                                  0x0837
#define mmCURSOR0_2_CURSOR_DST_OFFSET_BASE_IDX                                                         2
#define mmCURSOR0_2_CURSOR_MEM_PWR_CTRL                                                                0x0838
#define mmCURSOR0_2_CURSOR_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmCURSOR0_2_CURSOR_MEM_PWR_STATUS                                                              0x0839
#define mmCURSOR0_2_CURSOR_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmCURSOR0_2_DMDATA_ADDRESS_HIGH                                                                0x083a
#define mmCURSOR0_2_DMDATA_ADDRESS_HIGH_BASE_IDX                                                       2
#define mmCURSOR0_2_DMDATA_ADDRESS_LOW                                                                 0x083b
#define mmCURSOR0_2_DMDATA_ADDRESS_LOW_BASE_IDX                                                        2
#define mmCURSOR0_2_DMDATA_CNTL                                                                        0x083c
#define mmCURSOR0_2_DMDATA_CNTL_BASE_IDX                                                               2
#define mmCURSOR0_2_DMDATA_QOS_CNTL                                                                    0x083d
#define mmCURSOR0_2_DMDATA_QOS_CNTL_BASE_IDX                                                           2
#define mmCURSOR0_2_DMDATA_STATUS                                                                      0x083e
#define mmCURSOR0_2_DMDATA_STATUS_BASE_IDX                                                             2
#define mmCURSOR0_2_DMDATA_SW_CNTL                                                                     0x083f
#define mmCURSOR0_2_DMDATA_SW_CNTL_BASE_IDX                                                            2
#define mmCURSOR0_2_DMDATA_SW_DATA                                                                     0x0840
#define mmCURSOR0_2_DMDATA_SW_DATA_BASE_IDX                                                            2


// addressBlock: dce_dc_dcbubp2_dispdec_hubp_dcperfmon_dc_perfmon_dispdec
// base address: 0x2154
#define mmDC_PERFMON8_PERFCOUNTER_CNTL                                                                 0x0855
#define mmDC_PERFMON8_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON8_PERFCOUNTER_CNTL2                                                                0x0856
#define mmDC_PERFMON8_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON8_PERFCOUNTER_STATE                                                                0x0857
#define mmDC_PERFMON8_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON8_PERFMON_CNTL                                                                     0x0858
#define mmDC_PERFMON8_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON8_PERFMON_CNTL2                                                                    0x0859
#define mmDC_PERFMON8_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON8_PERFMON_CVALUE_INT_MISC                                                          0x085a
#define mmDC_PERFMON8_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON8_PERFMON_CVALUE_LOW                                                               0x085b
#define mmDC_PERFMON8_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON8_PERFMON_HI                                                                       0x085c
#define mmDC_PERFMON8_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON8_PERFMON_LOW                                                                      0x085d
#define mmDC_PERFMON8_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dcbubp3_dispdec_hubp_dispdec
// base address: 0xa50
#define mmHUBP3_DCSURF_SURFACE_CONFIG                                                                  0x0879
#define mmHUBP3_DCSURF_SURFACE_CONFIG_BASE_IDX                                                         2
#define mmHUBP3_DCSURF_ADDR_CONFIG                                                                     0x087a
#define mmHUBP3_DCSURF_ADDR_CONFIG_BASE_IDX                                                            2
#define mmHUBP3_DCSURF_TILING_CONFIG                                                                   0x087b
#define mmHUBP3_DCSURF_TILING_CONFIG_BASE_IDX                                                          2
#define mmHUBP3_DCSURF_PRI_VIEWPORT_START                                                              0x087d
#define mmHUBP3_DCSURF_PRI_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP3_DCSURF_PRI_VIEWPORT_DIMENSION                                                          0x087e
#define mmHUBP3_DCSURF_PRI_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP3_DCSURF_PRI_VIEWPORT_START_C                                                            0x087f
#define mmHUBP3_DCSURF_PRI_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP3_DCSURF_PRI_VIEWPORT_DIMENSION_C                                                        0x0880
#define mmHUBP3_DCSURF_PRI_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP3_DCSURF_SEC_VIEWPORT_START                                                              0x0881
#define mmHUBP3_DCSURF_SEC_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP3_DCSURF_SEC_VIEWPORT_DIMENSION                                                          0x0882
#define mmHUBP3_DCSURF_SEC_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP3_DCSURF_SEC_VIEWPORT_START_C                                                            0x0883
#define mmHUBP3_DCSURF_SEC_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP3_DCSURF_SEC_VIEWPORT_DIMENSION_C                                                        0x0884
#define mmHUBP3_DCSURF_SEC_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP3_DCHUBP_REQ_SIZE_CONFIG                                                                 0x0885
#define mmHUBP3_DCHUBP_REQ_SIZE_CONFIG_BASE_IDX                                                        2
#define mmHUBP3_DCHUBP_REQ_SIZE_CONFIG_C                                                               0x0886
#define mmHUBP3_DCHUBP_REQ_SIZE_CONFIG_C_BASE_IDX                                                      2
#define mmHUBP3_DCHUBP_CNTL                                                                            0x0887
#define mmHUBP3_DCHUBP_CNTL_BASE_IDX                                                                   2
#define mmHUBP3_HUBP_CLK_CNTL                                                                          0x0888
#define mmHUBP3_HUBP_CLK_CNTL_BASE_IDX                                                                 2
#define mmHUBP3_DCHUBP_VMPG_CONFIG                                                                     0x0889
#define mmHUBP3_DCHUBP_VMPG_CONFIG_BASE_IDX                                                            2
#define mmHUBP3_HUBPREQ_DEBUG_DB                                                                       0x088a
#define mmHUBP3_HUBPREQ_DEBUG_DB_BASE_IDX                                                              2
#define mmHUBP3_HUBPREQ_DEBUG                                                                          0x088b
#define mmHUBP3_HUBPREQ_DEBUG_BASE_IDX                                                                 2
#define mmHUBP3_HUBP_MEASURE_WIN_CTRL_DCFCLK                                                           0x088f
#define mmHUBP3_HUBP_MEASURE_WIN_CTRL_DCFCLK_BASE_IDX                                                  2
#define mmHUBP3_HUBP_MEASURE_WIN_CTRL_DPPCLK                                                           0x0890
#define mmHUBP3_HUBP_MEASURE_WIN_CTRL_DPPCLK_BASE_IDX                                                  2


// addressBlock: dce_dc_dcbubp3_dispdec_hubpreq_dispdec
// base address: 0xa50
#define mmHUBPREQ3_DCSURF_SURFACE_PITCH                                                                0x089b
#define mmHUBPREQ3_DCSURF_SURFACE_PITCH_BASE_IDX                                                       2
#define mmHUBPREQ3_DCSURF_SURFACE_PITCH_C                                                              0x089c
#define mmHUBPREQ3_DCSURF_SURFACE_PITCH_C_BASE_IDX                                                     2
#define mmHUBPREQ3_VMID_SETTINGS_0                                                                     0x089d
#define mmHUBPREQ3_VMID_SETTINGS_0_BASE_IDX                                                            2
#define mmHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS                                                      0x089e
#define mmHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                             2
#define mmHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH                                                 0x089f
#define mmHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define mmHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS_C                                                    0x08a0
#define mmHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS_C_BASE_IDX                                           2
#define mmHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C                                               0x08a1
#define mmHUBPREQ3_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                      2
#define mmHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS                                                    0x08a2
#define mmHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                           2
#define mmHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH                                               0x08a3
#define mmHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                      2
#define mmHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS_C                                                  0x08a4
#define mmHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS_C_BASE_IDX                                         2
#define mmHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C                                             0x08a5
#define mmHUBPREQ3_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                    2
#define mmHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS                                                 0x08a6
#define mmHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS_BASE_IDX                                        2
#define mmHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH                                            0x08a7
#define mmHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                   2
#define mmHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C                                               0x08a8
#define mmHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C_BASE_IDX                                      2
#define mmHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C                                          0x08a9
#define mmHUBPREQ3_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                 2
#define mmHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS                                               0x08aa
#define mmHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS_BASE_IDX                                      2
#define mmHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH                                          0x08ab
#define mmHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                 2
#define mmHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C                                             0x08ac
#define mmHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C_BASE_IDX                                    2
#define mmHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C                                        0x08ad
#define mmHUBPREQ3_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                               2
#define mmHUBPREQ3_DCSURF_SURFACE_CONTROL                                                              0x08ae
#define mmHUBPREQ3_DCSURF_SURFACE_CONTROL_BASE_IDX                                                     2
#define mmHUBPREQ3_DCSURF_FLIP_CONTROL                                                                 0x08af
#define mmHUBPREQ3_DCSURF_FLIP_CONTROL_BASE_IDX                                                        2
#define mmHUBPREQ3_DCSURF_FLIP_CONTROL2                                                                0x08b0
#define mmHUBPREQ3_DCSURF_FLIP_CONTROL2_BASE_IDX                                                       2
#define mmHUBPREQ3_DCSURF_SURFACE_FLIP_INTERRUPT                                                       0x08b4
#define mmHUBPREQ3_DCSURF_SURFACE_FLIP_INTERRUPT_BASE_IDX                                              2
#define mmHUBPREQ3_DCSURF_SURFACE_INUSE                                                                0x08b5
#define mmHUBPREQ3_DCSURF_SURFACE_INUSE_BASE_IDX                                                       2
#define mmHUBPREQ3_DCSURF_SURFACE_INUSE_HIGH                                                           0x08b6
#define mmHUBPREQ3_DCSURF_SURFACE_INUSE_HIGH_BASE_IDX                                                  2
#define mmHUBPREQ3_DCSURF_SURFACE_INUSE_C                                                              0x08b7
#define mmHUBPREQ3_DCSURF_SURFACE_INUSE_C_BASE_IDX                                                     2
#define mmHUBPREQ3_DCSURF_SURFACE_INUSE_HIGH_C                                                         0x08b8
#define mmHUBPREQ3_DCSURF_SURFACE_INUSE_HIGH_C_BASE_IDX                                                2
#define mmHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE                                                       0x08b9
#define mmHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE_BASE_IDX                                              2
#define mmHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE_HIGH                                                  0x08ba
#define mmHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_BASE_IDX                                         2
#define mmHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE_C                                                     0x08bb
#define mmHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE_C_BASE_IDX                                            2
#define mmHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C                                                0x08bc
#define mmHUBPREQ3_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C_BASE_IDX                                       2
#define mmHUBPREQ3_DCN_EXPANSION_MODE                                                                  0x08bd
#define mmHUBPREQ3_DCN_EXPANSION_MODE_BASE_IDX                                                         2
#define mmHUBPREQ3_DCN_TTU_QOS_WM                                                                      0x08be
#define mmHUBPREQ3_DCN_TTU_QOS_WM_BASE_IDX                                                             2
#define mmHUBPREQ3_DCN_GLOBAL_TTU_CNTL                                                                 0x08bf
#define mmHUBPREQ3_DCN_GLOBAL_TTU_CNTL_BASE_IDX                                                        2
#define mmHUBPREQ3_DCN_SURF0_TTU_CNTL0                                                                 0x08c0
#define mmHUBPREQ3_DCN_SURF0_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ3_DCN_SURF0_TTU_CNTL1                                                                 0x08c1
#define mmHUBPREQ3_DCN_SURF0_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ3_DCN_SURF1_TTU_CNTL0                                                                 0x08c2
#define mmHUBPREQ3_DCN_SURF1_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ3_DCN_SURF1_TTU_CNTL1                                                                 0x08c3
#define mmHUBPREQ3_DCN_SURF1_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ3_DCN_CUR0_TTU_CNTL0                                                                  0x08c4
#define mmHUBPREQ3_DCN_CUR0_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ3_DCN_CUR0_TTU_CNTL1                                                                  0x08c5
#define mmHUBPREQ3_DCN_CUR0_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ3_DCN_CUR1_TTU_CNTL0                                                                  0x08c6
#define mmHUBPREQ3_DCN_CUR1_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ3_DCN_CUR1_TTU_CNTL1                                                                  0x08c7
#define mmHUBPREQ3_DCN_CUR1_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ3_DCN_DMDATA_VM_CNTL                                                                  0x08c8
#define mmHUBPREQ3_DCN_DMDATA_VM_CNTL_BASE_IDX                                                         2
#define mmHUBPREQ3_DCN_VM_SYSTEM_APERTURE_LOW_ADDR                                                     0x08c9
#define mmHUBPREQ3_DCN_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                            2
#define mmHUBPREQ3_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR                                                    0x08ca
#define mmHUBPREQ3_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                           2
#define mmHUBPREQ3_DCN_VM_MX_L1_TLB_CNTL                                                               0x08d7
#define mmHUBPREQ3_DCN_VM_MX_L1_TLB_CNTL_BASE_IDX                                                      2
#define mmHUBPREQ3_BLANK_OFFSET_0                                                                      0x08d8
#define mmHUBPREQ3_BLANK_OFFSET_0_BASE_IDX                                                             2
#define mmHUBPREQ3_BLANK_OFFSET_1                                                                      0x08d9
#define mmHUBPREQ3_BLANK_OFFSET_1_BASE_IDX                                                             2
#define mmHUBPREQ3_DST_DIMENSIONS                                                                      0x08da
#define mmHUBPREQ3_DST_DIMENSIONS_BASE_IDX                                                             2
#define mmHUBPREQ3_DST_AFTER_SCALER                                                                    0x08db
#define mmHUBPREQ3_DST_AFTER_SCALER_BASE_IDX                                                           2
#define mmHUBPREQ3_PREFETCH_SETTINGS                                                                   0x08dc
#define mmHUBPREQ3_PREFETCH_SETTINGS_BASE_IDX                                                          2
#define mmHUBPREQ3_PREFETCH_SETTINGS_C                                                                 0x08dd
#define mmHUBPREQ3_PREFETCH_SETTINGS_C_BASE_IDX                                                        2
#define mmHUBPREQ3_VBLANK_PARAMETERS_0                                                                 0x08de
#define mmHUBPREQ3_VBLANK_PARAMETERS_0_BASE_IDX                                                        2
#define mmHUBPREQ3_VBLANK_PARAMETERS_1                                                                 0x08df
#define mmHUBPREQ3_VBLANK_PARAMETERS_1_BASE_IDX                                                        2
#define mmHUBPREQ3_VBLANK_PARAMETERS_2                                                                 0x08e0
#define mmHUBPREQ3_VBLANK_PARAMETERS_2_BASE_IDX                                                        2
#define mmHUBPREQ3_VBLANK_PARAMETERS_3                                                                 0x08e1
#define mmHUBPREQ3_VBLANK_PARAMETERS_3_BASE_IDX                                                        2
#define mmHUBPREQ3_VBLANK_PARAMETERS_4                                                                 0x08e2
#define mmHUBPREQ3_VBLANK_PARAMETERS_4_BASE_IDX                                                        2
#define mmHUBPREQ3_FLIP_PARAMETERS_0                                                                   0x08e3
#define mmHUBPREQ3_FLIP_PARAMETERS_0_BASE_IDX                                                          2
#define mmHUBPREQ3_FLIP_PARAMETERS_1                                                                   0x08e4
#define mmHUBPREQ3_FLIP_PARAMETERS_1_BASE_IDX                                                          2
#define mmHUBPREQ3_FLIP_PARAMETERS_2                                                                   0x08e5
#define mmHUBPREQ3_FLIP_PARAMETERS_2_BASE_IDX                                                          2
#define mmHUBPREQ3_NOM_PARAMETERS_0                                                                    0x08e6
#define mmHUBPREQ3_NOM_PARAMETERS_0_BASE_IDX                                                           2
#define mmHUBPREQ3_NOM_PARAMETERS_1                                                                    0x08e7
#define mmHUBPREQ3_NOM_PARAMETERS_1_BASE_IDX                                                           2
#define mmHUBPREQ3_NOM_PARAMETERS_2                                                                    0x08e8
#define mmHUBPREQ3_NOM_PARAMETERS_2_BASE_IDX                                                           2
#define mmHUBPREQ3_NOM_PARAMETERS_3                                                                    0x08e9
#define mmHUBPREQ3_NOM_PARAMETERS_3_BASE_IDX                                                           2
#define mmHUBPREQ3_NOM_PARAMETERS_4                                                                    0x08ea
#define mmHUBPREQ3_NOM_PARAMETERS_4_BASE_IDX                                                           2
#define mmHUBPREQ3_NOM_PARAMETERS_5                                                                    0x08eb
#define mmHUBPREQ3_NOM_PARAMETERS_5_BASE_IDX                                                           2
#define mmHUBPREQ3_NOM_PARAMETERS_6                                                                    0x08ec
#define mmHUBPREQ3_NOM_PARAMETERS_6_BASE_IDX                                                           2
#define mmHUBPREQ3_NOM_PARAMETERS_7                                                                    0x08ed
#define mmHUBPREQ3_NOM_PARAMETERS_7_BASE_IDX                                                           2
#define mmHUBPREQ3_PER_LINE_DELIVERY_PRE                                                               0x08ee
#define mmHUBPREQ3_PER_LINE_DELIVERY_PRE_BASE_IDX                                                      2
#define mmHUBPREQ3_PER_LINE_DELIVERY                                                                   0x08ef
#define mmHUBPREQ3_PER_LINE_DELIVERY_BASE_IDX                                                          2
#define mmHUBPREQ3_CURSOR_SETTINGS                                                                     0x08f0
#define mmHUBPREQ3_CURSOR_SETTINGS_BASE_IDX                                                            2
#define mmHUBPREQ3_REF_FREQ_TO_PIX_FREQ                                                                0x08f1
#define mmHUBPREQ3_REF_FREQ_TO_PIX_FREQ_BASE_IDX                                                       2
#define mmHUBPREQ3_DST_Y_DELTA_DRQ_LIMIT                                                               0x08f2
#define mmHUBPREQ3_DST_Y_DELTA_DRQ_LIMIT_BASE_IDX                                                      2
#define mmHUBPREQ3_HUBPREQ_MEM_PWR_CTRL                                                                0x08f3
#define mmHUBPREQ3_HUBPREQ_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPREQ3_HUBPREQ_MEM_PWR_STATUS                                                              0x08f4
#define mmHUBPREQ3_HUBPREQ_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPREQ3_VBLANK_PARAMETERS_5                                                                 0x08f7
#define mmHUBPREQ3_VBLANK_PARAMETERS_5_BASE_IDX                                                        2
#define mmHUBPREQ3_VBLANK_PARAMETERS_6                                                                 0x08f8
#define mmHUBPREQ3_VBLANK_PARAMETERS_6_BASE_IDX                                                        2
#define mmHUBPREQ3_FLIP_PARAMETERS_3                                                                   0x08f9
#define mmHUBPREQ3_FLIP_PARAMETERS_3_BASE_IDX                                                          2
#define mmHUBPREQ3_FLIP_PARAMETERS_4                                                                   0x08fa
#define mmHUBPREQ3_FLIP_PARAMETERS_4_BASE_IDX                                                          2
#define mmHUBPREQ3_FLIP_PARAMETERS_5                                                                   0x08fb
#define mmHUBPREQ3_FLIP_PARAMETERS_5_BASE_IDX                                                          2
#define mmHUBPREQ3_FLIP_PARAMETERS_6                                                                   0x08fc
#define mmHUBPREQ3_FLIP_PARAMETERS_6_BASE_IDX                                                          2


// addressBlock: dce_dc_dcbubp3_dispdec_hubpret_dispdec
// base address: 0xa50
#define mmHUBPRET3_HUBPRET_CONTROL                                                                     0x0900
#define mmHUBPRET3_HUBPRET_CONTROL_BASE_IDX                                                            2
#define mmHUBPRET3_HUBPRET_MEM_PWR_CTRL                                                                0x0901
#define mmHUBPRET3_HUBPRET_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPRET3_HUBPRET_MEM_PWR_STATUS                                                              0x0902
#define mmHUBPRET3_HUBPRET_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPRET3_HUBPRET_READ_LINE_CTRL0                                                             0x0903
#define mmHUBPRET3_HUBPRET_READ_LINE_CTRL0_BASE_IDX                                                    2
#define mmHUBPRET3_HUBPRET_READ_LINE_CTRL1                                                             0x0904
#define mmHUBPRET3_HUBPRET_READ_LINE_CTRL1_BASE_IDX                                                    2
#define mmHUBPRET3_HUBPRET_READ_LINE0                                                                  0x0905
#define mmHUBPRET3_HUBPRET_READ_LINE0_BASE_IDX                                                         2
#define mmHUBPRET3_HUBPRET_READ_LINE1                                                                  0x0906
#define mmHUBPRET3_HUBPRET_READ_LINE1_BASE_IDX                                                         2
#define mmHUBPRET3_HUBPRET_INTERRUPT                                                                   0x0907
#define mmHUBPRET3_HUBPRET_INTERRUPT_BASE_IDX                                                          2
#define mmHUBPRET3_HUBPRET_READ_LINE_VALUE                                                             0x0908
#define mmHUBPRET3_HUBPRET_READ_LINE_VALUE_BASE_IDX                                                    2
#define mmHUBPRET3_HUBPRET_READ_LINE_STATUS                                                            0x0909
#define mmHUBPRET3_HUBPRET_READ_LINE_STATUS_BASE_IDX                                                   2


// addressBlock: dce_dc_dcbubp3_dispdec_cursor0_dispdec
// base address: 0xa50
#define mmCURSOR0_3_CURSOR_CONTROL                                                                     0x090c
#define mmCURSOR0_3_CURSOR_CONTROL_BASE_IDX                                                            2
#define mmCURSOR0_3_CURSOR_SURFACE_ADDRESS                                                             0x090d
#define mmCURSOR0_3_CURSOR_SURFACE_ADDRESS_BASE_IDX                                                    2
#define mmCURSOR0_3_CURSOR_SURFACE_ADDRESS_HIGH                                                        0x090e
#define mmCURSOR0_3_CURSOR_SURFACE_ADDRESS_HIGH_BASE_IDX                                               2
#define mmCURSOR0_3_CURSOR_SIZE                                                                        0x090f
#define mmCURSOR0_3_CURSOR_SIZE_BASE_IDX                                                               2
#define mmCURSOR0_3_CURSOR_POSITION                                                                    0x0910
#define mmCURSOR0_3_CURSOR_POSITION_BASE_IDX                                                           2
#define mmCURSOR0_3_CURSOR_HOT_SPOT                                                                    0x0911
#define mmCURSOR0_3_CURSOR_HOT_SPOT_BASE_IDX                                                           2
#define mmCURSOR0_3_CURSOR_STEREO_CONTROL                                                              0x0912
#define mmCURSOR0_3_CURSOR_STEREO_CONTROL_BASE_IDX                                                     2
#define mmCURSOR0_3_CURSOR_DST_OFFSET                                                                  0x0913
#define mmCURSOR0_3_CURSOR_DST_OFFSET_BASE_IDX                                                         2
#define mmCURSOR0_3_CURSOR_MEM_PWR_CTRL                                                                0x0914
#define mmCURSOR0_3_CURSOR_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmCURSOR0_3_CURSOR_MEM_PWR_STATUS                                                              0x0915
#define mmCURSOR0_3_CURSOR_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmCURSOR0_3_DMDATA_ADDRESS_HIGH                                                                0x0916
#define mmCURSOR0_3_DMDATA_ADDRESS_HIGH_BASE_IDX                                                       2
#define mmCURSOR0_3_DMDATA_ADDRESS_LOW                                                                 0x0917
#define mmCURSOR0_3_DMDATA_ADDRESS_LOW_BASE_IDX                                                        2
#define mmCURSOR0_3_DMDATA_CNTL                                                                        0x0918
#define mmCURSOR0_3_DMDATA_CNTL_BASE_IDX                                                               2
#define mmCURSOR0_3_DMDATA_QOS_CNTL                                                                    0x0919
#define mmCURSOR0_3_DMDATA_QOS_CNTL_BASE_IDX                                                           2
#define mmCURSOR0_3_DMDATA_STATUS                                                                      0x091a
#define mmCURSOR0_3_DMDATA_STATUS_BASE_IDX                                                             2
#define mmCURSOR0_3_DMDATA_SW_CNTL                                                                     0x091b
#define mmCURSOR0_3_DMDATA_SW_CNTL_BASE_IDX                                                            2
#define mmCURSOR0_3_DMDATA_SW_DATA                                                                     0x091c
#define mmCURSOR0_3_DMDATA_SW_DATA_BASE_IDX                                                            2


// addressBlock: dce_dc_dcbubp3_dispdec_hubp_dcperfmon_dc_perfmon_dispdec
// base address: 0x24c4
#define mmDC_PERFMON9_PERFCOUNTER_CNTL                                                                 0x0931
#define mmDC_PERFMON9_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON9_PERFCOUNTER_CNTL2                                                                0x0932
#define mmDC_PERFMON9_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON9_PERFCOUNTER_STATE                                                                0x0933
#define mmDC_PERFMON9_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON9_PERFMON_CNTL                                                                     0x0934
#define mmDC_PERFMON9_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON9_PERFMON_CNTL2                                                                    0x0935
#define mmDC_PERFMON9_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON9_PERFMON_CVALUE_INT_MISC                                                          0x0936
#define mmDC_PERFMON9_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON9_PERFMON_CVALUE_LOW                                                               0x0937
#define mmDC_PERFMON9_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON9_PERFMON_HI                                                                       0x0938
#define mmDC_PERFMON9_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON9_PERFMON_LOW                                                                      0x0939
#define mmDC_PERFMON9_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dcbubp4_dispdec_hubp_dispdec
// base address: 0xdc0
#define mmHUBP4_DCSURF_SURFACE_CONFIG                                                                  0x0955
#define mmHUBP4_DCSURF_SURFACE_CONFIG_BASE_IDX                                                         2
#define mmHUBP4_DCSURF_ADDR_CONFIG                                                                     0x0956
#define mmHUBP4_DCSURF_ADDR_CONFIG_BASE_IDX                                                            2
#define mmHUBP4_DCSURF_TILING_CONFIG                                                                   0x0957
#define mmHUBP4_DCSURF_TILING_CONFIG_BASE_IDX                                                          2
#define mmHUBP4_DCSURF_PRI_VIEWPORT_START                                                              0x0959
#define mmHUBP4_DCSURF_PRI_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP4_DCSURF_PRI_VIEWPORT_DIMENSION                                                          0x095a
#define mmHUBP4_DCSURF_PRI_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP4_DCSURF_PRI_VIEWPORT_START_C                                                            0x095b
#define mmHUBP4_DCSURF_PRI_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP4_DCSURF_PRI_VIEWPORT_DIMENSION_C                                                        0x095c
#define mmHUBP4_DCSURF_PRI_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP4_DCSURF_SEC_VIEWPORT_START                                                              0x095d
#define mmHUBP4_DCSURF_SEC_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP4_DCSURF_SEC_VIEWPORT_DIMENSION                                                          0x095e
#define mmHUBP4_DCSURF_SEC_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP4_DCSURF_SEC_VIEWPORT_START_C                                                            0x095f
#define mmHUBP4_DCSURF_SEC_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP4_DCSURF_SEC_VIEWPORT_DIMENSION_C                                                        0x0960
#define mmHUBP4_DCSURF_SEC_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP4_DCHUBP_REQ_SIZE_CONFIG                                                                 0x0961
#define mmHUBP4_DCHUBP_REQ_SIZE_CONFIG_BASE_IDX                                                        2
#define mmHUBP4_DCHUBP_REQ_SIZE_CONFIG_C                                                               0x0962
#define mmHUBP4_DCHUBP_REQ_SIZE_CONFIG_C_BASE_IDX                                                      2
#define mmHUBP4_DCHUBP_CNTL                                                                            0x0963
#define mmHUBP4_DCHUBP_CNTL_BASE_IDX                                                                   2
#define mmHUBP4_HUBP_CLK_CNTL                                                                          0x0964
#define mmHUBP4_HUBP_CLK_CNTL_BASE_IDX                                                                 2
#define mmHUBP4_DCHUBP_VMPG_CONFIG                                                                     0x0965
#define mmHUBP4_DCHUBP_VMPG_CONFIG_BASE_IDX                                                            2
#define mmHUBP4_HUBPREQ_DEBUG_DB                                                                       0x0966
#define mmHUBP4_HUBPREQ_DEBUG_DB_BASE_IDX                                                              2
#define mmHUBP4_HUBPREQ_DEBUG                                                                          0x0967
#define mmHUBP4_HUBPREQ_DEBUG_BASE_IDX                                                                 2
#define mmHUBP4_HUBP_MEASURE_WIN_CTRL_DCFCLK                                                           0x096b
#define mmHUBP4_HUBP_MEASURE_WIN_CTRL_DCFCLK_BASE_IDX                                                  2
#define mmHUBP4_HUBP_MEASURE_WIN_CTRL_DPPCLK                                                           0x096c
#define mmHUBP4_HUBP_MEASURE_WIN_CTRL_DPPCLK_BASE_IDX                                                  2


// addressBlock: dce_dc_dcbubp4_dispdec_hubpreq_dispdec
// base address: 0xdc0
#define mmHUBPREQ4_DCSURF_SURFACE_PITCH                                                                0x0977
#define mmHUBPREQ4_DCSURF_SURFACE_PITCH_BASE_IDX                                                       2
#define mmHUBPREQ4_DCSURF_SURFACE_PITCH_C                                                              0x0978
#define mmHUBPREQ4_DCSURF_SURFACE_PITCH_C_BASE_IDX                                                     2
#define mmHUBPREQ4_VMID_SETTINGS_0                                                                     0x0979
#define mmHUBPREQ4_VMID_SETTINGS_0_BASE_IDX                                                            2
#define mmHUBPREQ4_DCSURF_PRIMARY_SURFACE_ADDRESS                                                      0x097a
#define mmHUBPREQ4_DCSURF_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                             2
#define mmHUBPREQ4_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH                                                 0x097b
#define mmHUBPREQ4_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define mmHUBPREQ4_DCSURF_PRIMARY_SURFACE_ADDRESS_C                                                    0x097c
#define mmHUBPREQ4_DCSURF_PRIMARY_SURFACE_ADDRESS_C_BASE_IDX                                           2
#define mmHUBPREQ4_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C                                               0x097d
#define mmHUBPREQ4_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                      2
#define mmHUBPREQ4_DCSURF_SECONDARY_SURFACE_ADDRESS                                                    0x097e
#define mmHUBPREQ4_DCSURF_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                           2
#define mmHUBPREQ4_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH                                               0x097f
#define mmHUBPREQ4_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                      2
#define mmHUBPREQ4_DCSURF_SECONDARY_SURFACE_ADDRESS_C                                                  0x0980
#define mmHUBPREQ4_DCSURF_SECONDARY_SURFACE_ADDRESS_C_BASE_IDX                                         2
#define mmHUBPREQ4_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C                                             0x0981
#define mmHUBPREQ4_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                    2
#define mmHUBPREQ4_DCSURF_PRIMARY_META_SURFACE_ADDRESS                                                 0x0982
#define mmHUBPREQ4_DCSURF_PRIMARY_META_SURFACE_ADDRESS_BASE_IDX                                        2
#define mmHUBPREQ4_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH                                            0x0983
#define mmHUBPREQ4_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                   2
#define mmHUBPREQ4_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C                                               0x0984
#define mmHUBPREQ4_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C_BASE_IDX                                      2
#define mmHUBPREQ4_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C                                          0x0985
#define mmHUBPREQ4_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                 2
#define mmHUBPREQ4_DCSURF_SECONDARY_META_SURFACE_ADDRESS                                               0x0986
#define mmHUBPREQ4_DCSURF_SECONDARY_META_SURFACE_ADDRESS_BASE_IDX                                      2
#define mmHUBPREQ4_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH                                          0x0987
#define mmHUBPREQ4_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                 2
#define mmHUBPREQ4_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C                                             0x0988
#define mmHUBPREQ4_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C_BASE_IDX                                    2
#define mmHUBPREQ4_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C                                        0x0989
#define mmHUBPREQ4_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                               2
#define mmHUBPREQ4_DCSURF_SURFACE_CONTROL                                                              0x098a
#define mmHUBPREQ4_DCSURF_SURFACE_CONTROL_BASE_IDX                                                     2
#define mmHUBPREQ4_DCSURF_FLIP_CONTROL                                                                 0x098b
#define mmHUBPREQ4_DCSURF_FLIP_CONTROL_BASE_IDX                                                        2
#define mmHUBPREQ4_DCSURF_FLIP_CONTROL2                                                                0x098c
#define mmHUBPREQ4_DCSURF_FLIP_CONTROL2_BASE_IDX                                                       2
#define mmHUBPREQ4_DCSURF_SURFACE_FLIP_INTERRUPT                                                       0x0990
#define mmHUBPREQ4_DCSURF_SURFACE_FLIP_INTERRUPT_BASE_IDX                                              2
#define mmHUBPREQ4_DCSURF_SURFACE_INUSE                                                                0x0991
#define mmHUBPREQ4_DCSURF_SURFACE_INUSE_BASE_IDX                                                       2
#define mmHUBPREQ4_DCSURF_SURFACE_INUSE_HIGH                                                           0x0992
#define mmHUBPREQ4_DCSURF_SURFACE_INUSE_HIGH_BASE_IDX                                                  2
#define mmHUBPREQ4_DCSURF_SURFACE_INUSE_C                                                              0x0993
#define mmHUBPREQ4_DCSURF_SURFACE_INUSE_C_BASE_IDX                                                     2
#define mmHUBPREQ4_DCSURF_SURFACE_INUSE_HIGH_C                                                         0x0994
#define mmHUBPREQ4_DCSURF_SURFACE_INUSE_HIGH_C_BASE_IDX                                                2
#define mmHUBPREQ4_DCSURF_SURFACE_EARLIEST_INUSE                                                       0x0995
#define mmHUBPREQ4_DCSURF_SURFACE_EARLIEST_INUSE_BASE_IDX                                              2
#define mmHUBPREQ4_DCSURF_SURFACE_EARLIEST_INUSE_HIGH                                                  0x0996
#define mmHUBPREQ4_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_BASE_IDX                                         2
#define mmHUBPREQ4_DCSURF_SURFACE_EARLIEST_INUSE_C                                                     0x0997
#define mmHUBPREQ4_DCSURF_SURFACE_EARLIEST_INUSE_C_BASE_IDX                                            2
#define mmHUBPREQ4_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C                                                0x0998
#define mmHUBPREQ4_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C_BASE_IDX                                       2
#define mmHUBPREQ4_DCN_EXPANSION_MODE                                                                  0x0999
#define mmHUBPREQ4_DCN_EXPANSION_MODE_BASE_IDX                                                         2
#define mmHUBPREQ4_DCN_TTU_QOS_WM                                                                      0x099a
#define mmHUBPREQ4_DCN_TTU_QOS_WM_BASE_IDX                                                             2
#define mmHUBPREQ4_DCN_GLOBAL_TTU_CNTL                                                                 0x099b
#define mmHUBPREQ4_DCN_GLOBAL_TTU_CNTL_BASE_IDX                                                        2
#define mmHUBPREQ4_DCN_SURF0_TTU_CNTL0                                                                 0x099c
#define mmHUBPREQ4_DCN_SURF0_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ4_DCN_SURF0_TTU_CNTL1                                                                 0x099d
#define mmHUBPREQ4_DCN_SURF0_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ4_DCN_SURF1_TTU_CNTL0                                                                 0x099e
#define mmHUBPREQ4_DCN_SURF1_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ4_DCN_SURF1_TTU_CNTL1                                                                 0x099f
#define mmHUBPREQ4_DCN_SURF1_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ4_DCN_CUR0_TTU_CNTL0                                                                  0x09a0
#define mmHUBPREQ4_DCN_CUR0_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ4_DCN_CUR0_TTU_CNTL1                                                                  0x09a1
#define mmHUBPREQ4_DCN_CUR0_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ4_DCN_CUR1_TTU_CNTL0                                                                  0x09a2
#define mmHUBPREQ4_DCN_CUR1_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ4_DCN_CUR1_TTU_CNTL1                                                                  0x09a3
#define mmHUBPREQ4_DCN_CUR1_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ4_DCN_DMDATA_VM_CNTL                                                                  0x09a4
#define mmHUBPREQ4_DCN_DMDATA_VM_CNTL_BASE_IDX                                                         2
#define mmHUBPREQ4_DCN_VM_SYSTEM_APERTURE_LOW_ADDR                                                     0x09a5
#define mmHUBPREQ4_DCN_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                            2
#define mmHUBPREQ4_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR                                                    0x09a6
#define mmHUBPREQ4_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                           2
#define mmHUBPREQ4_DCN_VM_MX_L1_TLB_CNTL                                                               0x09b3
#define mmHUBPREQ4_DCN_VM_MX_L1_TLB_CNTL_BASE_IDX                                                      2
#define mmHUBPREQ4_BLANK_OFFSET_0                                                                      0x09b4
#define mmHUBPREQ4_BLANK_OFFSET_0_BASE_IDX                                                             2
#define mmHUBPREQ4_BLANK_OFFSET_1                                                                      0x09b5
#define mmHUBPREQ4_BLANK_OFFSET_1_BASE_IDX                                                             2
#define mmHUBPREQ4_DST_DIMENSIONS                                                                      0x09b6
#define mmHUBPREQ4_DST_DIMENSIONS_BASE_IDX                                                             2
#define mmHUBPREQ4_DST_AFTER_SCALER                                                                    0x09b7
#define mmHUBPREQ4_DST_AFTER_SCALER_BASE_IDX                                                           2
#define mmHUBPREQ4_PREFETCH_SETTINGS                                                                   0x09b8
#define mmHUBPREQ4_PREFETCH_SETTINGS_BASE_IDX                                                          2
#define mmHUBPREQ4_PREFETCH_SETTINGS_C                                                                 0x09b9
#define mmHUBPREQ4_PREFETCH_SETTINGS_C_BASE_IDX                                                        2
#define mmHUBPREQ4_VBLANK_PARAMETERS_0                                                                 0x09ba
#define mmHUBPREQ4_VBLANK_PARAMETERS_0_BASE_IDX                                                        2
#define mmHUBPREQ4_VBLANK_PARAMETERS_1                                                                 0x09bb
#define mmHUBPREQ4_VBLANK_PARAMETERS_1_BASE_IDX                                                        2
#define mmHUBPREQ4_VBLANK_PARAMETERS_2                                                                 0x09bc
#define mmHUBPREQ4_VBLANK_PARAMETERS_2_BASE_IDX                                                        2
#define mmHUBPREQ4_VBLANK_PARAMETERS_3                                                                 0x09bd
#define mmHUBPREQ4_VBLANK_PARAMETERS_3_BASE_IDX                                                        2
#define mmHUBPREQ4_VBLANK_PARAMETERS_4                                                                 0x09be
#define mmHUBPREQ4_VBLANK_PARAMETERS_4_BASE_IDX                                                        2
#define mmHUBPREQ4_FLIP_PARAMETERS_0                                                                   0x09bf
#define mmHUBPREQ4_FLIP_PARAMETERS_0_BASE_IDX                                                          2
#define mmHUBPREQ4_FLIP_PARAMETERS_1                                                                   0x09c0
#define mmHUBPREQ4_FLIP_PARAMETERS_1_BASE_IDX                                                          2
#define mmHUBPREQ4_FLIP_PARAMETERS_2                                                                   0x09c1
#define mmHUBPREQ4_FLIP_PARAMETERS_2_BASE_IDX                                                          2
#define mmHUBPREQ4_NOM_PARAMETERS_0                                                                    0x09c2
#define mmHUBPREQ4_NOM_PARAMETERS_0_BASE_IDX                                                           2
#define mmHUBPREQ4_NOM_PARAMETERS_1                                                                    0x09c3
#define mmHUBPREQ4_NOM_PARAMETERS_1_BASE_IDX                                                           2
#define mmHUBPREQ4_NOM_PARAMETERS_2                                                                    0x09c4
#define mmHUBPREQ4_NOM_PARAMETERS_2_BASE_IDX                                                           2
#define mmHUBPREQ4_NOM_PARAMETERS_3                                                                    0x09c5
#define mmHUBPREQ4_NOM_PARAMETERS_3_BASE_IDX                                                           2
#define mmHUBPREQ4_NOM_PARAMETERS_4                                                                    0x09c6
#define mmHUBPREQ4_NOM_PARAMETERS_4_BASE_IDX                                                           2
#define mmHUBPREQ4_NOM_PARAMETERS_5                                                                    0x09c7
#define mmHUBPREQ4_NOM_PARAMETERS_5_BASE_IDX                                                           2
#define mmHUBPREQ4_NOM_PARAMETERS_6                                                                    0x09c8
#define mmHUBPREQ4_NOM_PARAMETERS_6_BASE_IDX                                                           2
#define mmHUBPREQ4_NOM_PARAMETERS_7                                                                    0x09c9
#define mmHUBPREQ4_NOM_PARAMETERS_7_BASE_IDX                                                           2
#define mmHUBPREQ4_PER_LINE_DELIVERY_PRE                                                               0x09ca
#define mmHUBPREQ4_PER_LINE_DELIVERY_PRE_BASE_IDX                                                      2
#define mmHUBPREQ4_PER_LINE_DELIVERY                                                                   0x09cb
#define mmHUBPREQ4_PER_LINE_DELIVERY_BASE_IDX                                                          2
#define mmHUBPREQ4_CURSOR_SETTINGS                                                                     0x09cc
#define mmHUBPREQ4_CURSOR_SETTINGS_BASE_IDX                                                            2
#define mmHUBPREQ4_REF_FREQ_TO_PIX_FREQ                                                                0x09cd
#define mmHUBPREQ4_REF_FREQ_TO_PIX_FREQ_BASE_IDX                                                       2
#define mmHUBPREQ4_DST_Y_DELTA_DRQ_LIMIT                                                               0x09ce
#define mmHUBPREQ4_DST_Y_DELTA_DRQ_LIMIT_BASE_IDX                                                      2
#define mmHUBPREQ4_HUBPREQ_MEM_PWR_CTRL                                                                0x09cf
#define mmHUBPREQ4_HUBPREQ_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPREQ4_HUBPREQ_MEM_PWR_STATUS                                                              0x09d0
#define mmHUBPREQ4_HUBPREQ_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPREQ4_VBLANK_PARAMETERS_5                                                                 0x09d3
#define mmHUBPREQ4_VBLANK_PARAMETERS_5_BASE_IDX                                                        2
#define mmHUBPREQ4_VBLANK_PARAMETERS_6                                                                 0x09d4
#define mmHUBPREQ4_VBLANK_PARAMETERS_6_BASE_IDX                                                        2
#define mmHUBPREQ4_FLIP_PARAMETERS_3                                                                   0x09d5
#define mmHUBPREQ4_FLIP_PARAMETERS_3_BASE_IDX                                                          2
#define mmHUBPREQ4_FLIP_PARAMETERS_4                                                                   0x09d6
#define mmHUBPREQ4_FLIP_PARAMETERS_4_BASE_IDX                                                          2
#define mmHUBPREQ4_FLIP_PARAMETERS_5                                                                   0x09d7
#define mmHUBPREQ4_FLIP_PARAMETERS_5_BASE_IDX                                                          2
#define mmHUBPREQ4_FLIP_PARAMETERS_6                                                                   0x09d8
#define mmHUBPREQ4_FLIP_PARAMETERS_6_BASE_IDX                                                          2


// addressBlock: dce_dc_dcbubp4_dispdec_hubpret_dispdec
// base address: 0xdc0
#define mmHUBPRET4_HUBPRET_CONTROL                                                                     0x09dc
#define mmHUBPRET4_HUBPRET_CONTROL_BASE_IDX                                                            2
#define mmHUBPRET4_HUBPRET_MEM_PWR_CTRL                                                                0x09dd
#define mmHUBPRET4_HUBPRET_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPRET4_HUBPRET_MEM_PWR_STATUS                                                              0x09de
#define mmHUBPRET4_HUBPRET_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPRET4_HUBPRET_READ_LINE_CTRL0                                                             0x09df
#define mmHUBPRET4_HUBPRET_READ_LINE_CTRL0_BASE_IDX                                                    2
#define mmHUBPRET4_HUBPRET_READ_LINE_CTRL1                                                             0x09e0
#define mmHUBPRET4_HUBPRET_READ_LINE_CTRL1_BASE_IDX                                                    2
#define mmHUBPRET4_HUBPRET_READ_LINE0                                                                  0x09e1
#define mmHUBPRET4_HUBPRET_READ_LINE0_BASE_IDX                                                         2
#define mmHUBPRET4_HUBPRET_READ_LINE1                                                                  0x09e2
#define mmHUBPRET4_HUBPRET_READ_LINE1_BASE_IDX                                                         2
#define mmHUBPRET4_HUBPRET_INTERRUPT                                                                   0x09e3
#define mmHUBPRET4_HUBPRET_INTERRUPT_BASE_IDX                                                          2
#define mmHUBPRET4_HUBPRET_READ_LINE_VALUE                                                             0x09e4
#define mmHUBPRET4_HUBPRET_READ_LINE_VALUE_BASE_IDX                                                    2
#define mmHUBPRET4_HUBPRET_READ_LINE_STATUS                                                            0x09e5
#define mmHUBPRET4_HUBPRET_READ_LINE_STATUS_BASE_IDX                                                   2


// addressBlock: dce_dc_dcbubp4_dispdec_cursor0_dispdec
// base address: 0xdc0
#define mmCURSOR0_4_CURSOR_CONTROL                                                                     0x09e8
#define mmCURSOR0_4_CURSOR_CONTROL_BASE_IDX                                                            2
#define mmCURSOR0_4_CURSOR_SURFACE_ADDRESS                                                             0x09e9
#define mmCURSOR0_4_CURSOR_SURFACE_ADDRESS_BASE_IDX                                                    2
#define mmCURSOR0_4_CURSOR_SURFACE_ADDRESS_HIGH                                                        0x09ea
#define mmCURSOR0_4_CURSOR_SURFACE_ADDRESS_HIGH_BASE_IDX                                               2
#define mmCURSOR0_4_CURSOR_SIZE                                                                        0x09eb
#define mmCURSOR0_4_CURSOR_SIZE_BASE_IDX                                                               2
#define mmCURSOR0_4_CURSOR_POSITION                                                                    0x09ec
#define mmCURSOR0_4_CURSOR_POSITION_BASE_IDX                                                           2
#define mmCURSOR0_4_CURSOR_HOT_SPOT                                                                    0x09ed
#define mmCURSOR0_4_CURSOR_HOT_SPOT_BASE_IDX                                                           2
#define mmCURSOR0_4_CURSOR_STEREO_CONTROL                                                              0x09ee
#define mmCURSOR0_4_CURSOR_STEREO_CONTROL_BASE_IDX                                                     2
#define mmCURSOR0_4_CURSOR_DST_OFFSET                                                                  0x09ef
#define mmCURSOR0_4_CURSOR_DST_OFFSET_BASE_IDX                                                         2
#define mmCURSOR0_4_CURSOR_MEM_PWR_CTRL                                                                0x09f0
#define mmCURSOR0_4_CURSOR_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmCURSOR0_4_CURSOR_MEM_PWR_STATUS                                                              0x09f1
#define mmCURSOR0_4_CURSOR_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmCURSOR0_4_DMDATA_ADDRESS_HIGH                                                                0x09f2
#define mmCURSOR0_4_DMDATA_ADDRESS_HIGH_BASE_IDX                                                       2
#define mmCURSOR0_4_DMDATA_ADDRESS_LOW                                                                 0x09f3
#define mmCURSOR0_4_DMDATA_ADDRESS_LOW_BASE_IDX                                                        2
#define mmCURSOR0_4_DMDATA_CNTL                                                                        0x09f4
#define mmCURSOR0_4_DMDATA_CNTL_BASE_IDX                                                               2
#define mmCURSOR0_4_DMDATA_QOS_CNTL                                                                    0x09f5
#define mmCURSOR0_4_DMDATA_QOS_CNTL_BASE_IDX                                                           2
#define mmCURSOR0_4_DMDATA_STATUS                                                                      0x09f6
#define mmCURSOR0_4_DMDATA_STATUS_BASE_IDX                                                             2
#define mmCURSOR0_4_DMDATA_SW_CNTL                                                                     0x09f7
#define mmCURSOR0_4_DMDATA_SW_CNTL_BASE_IDX                                                            2
#define mmCURSOR0_4_DMDATA_SW_DATA                                                                     0x09f8
#define mmCURSOR0_4_DMDATA_SW_DATA_BASE_IDX                                                            2


// addressBlock: dce_dc_dcbubp4_dispdec_hubp_dcperfmon_dc_perfmon_dispdec
// base address: 0x2834
#define mmDC_PERFMON10_PERFCOUNTER_CNTL                                                                0x0a0d
#define mmDC_PERFMON10_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON10_PERFCOUNTER_CNTL2                                                               0x0a0e
#define mmDC_PERFMON10_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON10_PERFCOUNTER_STATE                                                               0x0a0f
#define mmDC_PERFMON10_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON10_PERFMON_CNTL                                                                    0x0a10
#define mmDC_PERFMON10_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON10_PERFMON_CNTL2                                                                   0x0a11
#define mmDC_PERFMON10_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON10_PERFMON_CVALUE_INT_MISC                                                         0x0a12
#define mmDC_PERFMON10_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON10_PERFMON_CVALUE_LOW                                                              0x0a13
#define mmDC_PERFMON10_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON10_PERFMON_HI                                                                      0x0a14
#define mmDC_PERFMON10_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON10_PERFMON_LOW                                                                     0x0a15
#define mmDC_PERFMON10_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dcbubp5_dispdec_hubp_dispdec
// base address: 0x1130
#define mmHUBP5_DCSURF_SURFACE_CONFIG                                                                  0x0a31
#define mmHUBP5_DCSURF_SURFACE_CONFIG_BASE_IDX                                                         2
#define mmHUBP5_DCSURF_ADDR_CONFIG                                                                     0x0a32
#define mmHUBP5_DCSURF_ADDR_CONFIG_BASE_IDX                                                            2
#define mmHUBP5_DCSURF_TILING_CONFIG                                                                   0x0a33
#define mmHUBP5_DCSURF_TILING_CONFIG_BASE_IDX                                                          2
#define mmHUBP5_DCSURF_PRI_VIEWPORT_START                                                              0x0a35
#define mmHUBP5_DCSURF_PRI_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP5_DCSURF_PRI_VIEWPORT_DIMENSION                                                          0x0a36
#define mmHUBP5_DCSURF_PRI_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP5_DCSURF_PRI_VIEWPORT_START_C                                                            0x0a37
#define mmHUBP5_DCSURF_PRI_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP5_DCSURF_PRI_VIEWPORT_DIMENSION_C                                                        0x0a38
#define mmHUBP5_DCSURF_PRI_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP5_DCSURF_SEC_VIEWPORT_START                                                              0x0a39
#define mmHUBP5_DCSURF_SEC_VIEWPORT_START_BASE_IDX                                                     2
#define mmHUBP5_DCSURF_SEC_VIEWPORT_DIMENSION                                                          0x0a3a
#define mmHUBP5_DCSURF_SEC_VIEWPORT_DIMENSION_BASE_IDX                                                 2
#define mmHUBP5_DCSURF_SEC_VIEWPORT_START_C                                                            0x0a3b
#define mmHUBP5_DCSURF_SEC_VIEWPORT_START_C_BASE_IDX                                                   2
#define mmHUBP5_DCSURF_SEC_VIEWPORT_DIMENSION_C                                                        0x0a3c
#define mmHUBP5_DCSURF_SEC_VIEWPORT_DIMENSION_C_BASE_IDX                                               2
#define mmHUBP5_DCHUBP_REQ_SIZE_CONFIG                                                                 0x0a3d
#define mmHUBP5_DCHUBP_REQ_SIZE_CONFIG_BASE_IDX                                                        2
#define mmHUBP5_DCHUBP_REQ_SIZE_CONFIG_C                                                               0x0a3e
#define mmHUBP5_DCHUBP_REQ_SIZE_CONFIG_C_BASE_IDX                                                      2
#define mmHUBP5_DCHUBP_CNTL                                                                            0x0a3f
#define mmHUBP5_DCHUBP_CNTL_BASE_IDX                                                                   2
#define mmHUBP5_HUBP_CLK_CNTL                                                                          0x0a40
#define mmHUBP5_HUBP_CLK_CNTL_BASE_IDX                                                                 2
#define mmHUBP5_DCHUBP_VMPG_CONFIG                                                                     0x0a41
#define mmHUBP5_DCHUBP_VMPG_CONFIG_BASE_IDX                                                            2
#define mmHUBP5_HUBPREQ_DEBUG_DB                                                                       0x0a42
#define mmHUBP5_HUBPREQ_DEBUG_DB_BASE_IDX                                                              2
#define mmHUBP5_HUBPREQ_DEBUG                                                                          0x0a43
#define mmHUBP5_HUBPREQ_DEBUG_BASE_IDX                                                                 2
#define mmHUBP5_HUBP_MEASURE_WIN_CTRL_DCFCLK                                                           0x0a47
#define mmHUBP5_HUBP_MEASURE_WIN_CTRL_DCFCLK_BASE_IDX                                                  2
#define mmHUBP5_HUBP_MEASURE_WIN_CTRL_DPPCLK                                                           0x0a48
#define mmHUBP5_HUBP_MEASURE_WIN_CTRL_DPPCLK_BASE_IDX                                                  2


// addressBlock: dce_dc_dcbubp5_dispdec_hubpreq_dispdec
// base address: 0x1130
#define mmHUBPREQ5_DCSURF_SURFACE_PITCH                                                                0x0a53
#define mmHUBPREQ5_DCSURF_SURFACE_PITCH_BASE_IDX                                                       2
#define mmHUBPREQ5_DCSURF_SURFACE_PITCH_C                                                              0x0a54
#define mmHUBPREQ5_DCSURF_SURFACE_PITCH_C_BASE_IDX                                                     2
#define mmHUBPREQ5_VMID_SETTINGS_0                                                                     0x0a55
#define mmHUBPREQ5_VMID_SETTINGS_0_BASE_IDX                                                            2
#define mmHUBPREQ5_DCSURF_PRIMARY_SURFACE_ADDRESS                                                      0x0a56
#define mmHUBPREQ5_DCSURF_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                             2
#define mmHUBPREQ5_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH                                                 0x0a57
#define mmHUBPREQ5_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define mmHUBPREQ5_DCSURF_PRIMARY_SURFACE_ADDRESS_C                                                    0x0a58
#define mmHUBPREQ5_DCSURF_PRIMARY_SURFACE_ADDRESS_C_BASE_IDX                                           2
#define mmHUBPREQ5_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C                                               0x0a59
#define mmHUBPREQ5_DCSURF_PRIMARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                      2
#define mmHUBPREQ5_DCSURF_SECONDARY_SURFACE_ADDRESS                                                    0x0a5a
#define mmHUBPREQ5_DCSURF_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                           2
#define mmHUBPREQ5_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH                                               0x0a5b
#define mmHUBPREQ5_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                      2
#define mmHUBPREQ5_DCSURF_SECONDARY_SURFACE_ADDRESS_C                                                  0x0a5c
#define mmHUBPREQ5_DCSURF_SECONDARY_SURFACE_ADDRESS_C_BASE_IDX                                         2
#define mmHUBPREQ5_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C                                             0x0a5d
#define mmHUBPREQ5_DCSURF_SECONDARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                    2
#define mmHUBPREQ5_DCSURF_PRIMARY_META_SURFACE_ADDRESS                                                 0x0a5e
#define mmHUBPREQ5_DCSURF_PRIMARY_META_SURFACE_ADDRESS_BASE_IDX                                        2
#define mmHUBPREQ5_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH                                            0x0a5f
#define mmHUBPREQ5_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                   2
#define mmHUBPREQ5_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C                                               0x0a60
#define mmHUBPREQ5_DCSURF_PRIMARY_META_SURFACE_ADDRESS_C_BASE_IDX                                      2
#define mmHUBPREQ5_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C                                          0x0a61
#define mmHUBPREQ5_DCSURF_PRIMARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                 2
#define mmHUBPREQ5_DCSURF_SECONDARY_META_SURFACE_ADDRESS                                               0x0a62
#define mmHUBPREQ5_DCSURF_SECONDARY_META_SURFACE_ADDRESS_BASE_IDX                                      2
#define mmHUBPREQ5_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH                                          0x0a63
#define mmHUBPREQ5_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_BASE_IDX                                 2
#define mmHUBPREQ5_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C                                             0x0a64
#define mmHUBPREQ5_DCSURF_SECONDARY_META_SURFACE_ADDRESS_C_BASE_IDX                                    2
#define mmHUBPREQ5_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C                                        0x0a65
#define mmHUBPREQ5_DCSURF_SECONDARY_META_SURFACE_ADDRESS_HIGH_C_BASE_IDX                               2
#define mmHUBPREQ5_DCSURF_SURFACE_CONTROL                                                              0x0a66
#define mmHUBPREQ5_DCSURF_SURFACE_CONTROL_BASE_IDX                                                     2
#define mmHUBPREQ5_DCSURF_FLIP_CONTROL                                                                 0x0a67
#define mmHUBPREQ5_DCSURF_FLIP_CONTROL_BASE_IDX                                                        2
#define mmHUBPREQ5_DCSURF_FLIP_CONTROL2                                                                0x0a68
#define mmHUBPREQ5_DCSURF_FLIP_CONTROL2_BASE_IDX                                                       2
#define mmHUBPREQ5_DCSURF_SURFACE_FLIP_INTERRUPT                                                       0x0a6c
#define mmHUBPREQ5_DCSURF_SURFACE_FLIP_INTERRUPT_BASE_IDX                                              2
#define mmHUBPREQ5_DCSURF_SURFACE_INUSE                                                                0x0a6d
#define mmHUBPREQ5_DCSURF_SURFACE_INUSE_BASE_IDX                                                       2
#define mmHUBPREQ5_DCSURF_SURFACE_INUSE_HIGH                                                           0x0a6e
#define mmHUBPREQ5_DCSURF_SURFACE_INUSE_HIGH_BASE_IDX                                                  2
#define mmHUBPREQ5_DCSURF_SURFACE_INUSE_C                                                              0x0a6f
#define mmHUBPREQ5_DCSURF_SURFACE_INUSE_C_BASE_IDX                                                     2
#define mmHUBPREQ5_DCSURF_SURFACE_INUSE_HIGH_C                                                         0x0a70
#define mmHUBPREQ5_DCSURF_SURFACE_INUSE_HIGH_C_BASE_IDX                                                2
#define mmHUBPREQ5_DCSURF_SURFACE_EARLIEST_INUSE                                                       0x0a71
#define mmHUBPREQ5_DCSURF_SURFACE_EARLIEST_INUSE_BASE_IDX                                              2
#define mmHUBPREQ5_DCSURF_SURFACE_EARLIEST_INUSE_HIGH                                                  0x0a72
#define mmHUBPREQ5_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_BASE_IDX                                         2
#define mmHUBPREQ5_DCSURF_SURFACE_EARLIEST_INUSE_C                                                     0x0a73
#define mmHUBPREQ5_DCSURF_SURFACE_EARLIEST_INUSE_C_BASE_IDX                                            2
#define mmHUBPREQ5_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C                                                0x0a74
#define mmHUBPREQ5_DCSURF_SURFACE_EARLIEST_INUSE_HIGH_C_BASE_IDX                                       2
#define mmHUBPREQ5_DCN_EXPANSION_MODE                                                                  0x0a75
#define mmHUBPREQ5_DCN_EXPANSION_MODE_BASE_IDX                                                         2
#define mmHUBPREQ5_DCN_TTU_QOS_WM                                                                      0x0a76
#define mmHUBPREQ5_DCN_TTU_QOS_WM_BASE_IDX                                                             2
#define mmHUBPREQ5_DCN_GLOBAL_TTU_CNTL                                                                 0x0a77
#define mmHUBPREQ5_DCN_GLOBAL_TTU_CNTL_BASE_IDX                                                        2
#define mmHUBPREQ5_DCN_SURF0_TTU_CNTL0                                                                 0x0a78
#define mmHUBPREQ5_DCN_SURF0_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ5_DCN_SURF0_TTU_CNTL1                                                                 0x0a79
#define mmHUBPREQ5_DCN_SURF0_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ5_DCN_SURF1_TTU_CNTL0                                                                 0x0a7a
#define mmHUBPREQ5_DCN_SURF1_TTU_CNTL0_BASE_IDX                                                        2
#define mmHUBPREQ5_DCN_SURF1_TTU_CNTL1                                                                 0x0a7b
#define mmHUBPREQ5_DCN_SURF1_TTU_CNTL1_BASE_IDX                                                        2
#define mmHUBPREQ5_DCN_CUR0_TTU_CNTL0                                                                  0x0a7c
#define mmHUBPREQ5_DCN_CUR0_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ5_DCN_CUR0_TTU_CNTL1                                                                  0x0a7d
#define mmHUBPREQ5_DCN_CUR0_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ5_DCN_CUR1_TTU_CNTL0                                                                  0x0a7e
#define mmHUBPREQ5_DCN_CUR1_TTU_CNTL0_BASE_IDX                                                         2
#define mmHUBPREQ5_DCN_CUR1_TTU_CNTL1                                                                  0x0a7f
#define mmHUBPREQ5_DCN_CUR1_TTU_CNTL1_BASE_IDX                                                         2
#define mmHUBPREQ5_DCN_DMDATA_VM_CNTL                                                                  0x0a80
#define mmHUBPREQ5_DCN_DMDATA_VM_CNTL_BASE_IDX                                                         2
#define mmHUBPREQ5_DCN_VM_SYSTEM_APERTURE_LOW_ADDR                                                     0x0a81
#define mmHUBPREQ5_DCN_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                            2
#define mmHUBPREQ5_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR                                                    0x0a82
#define mmHUBPREQ5_DCN_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                           2
#define mmHUBPREQ5_DCN_VM_MX_L1_TLB_CNTL                                                               0x0a8f
#define mmHUBPREQ5_DCN_VM_MX_L1_TLB_CNTL_BASE_IDX                                                      2
#define mmHUBPREQ5_BLANK_OFFSET_0                                                                      0x0a90
#define mmHUBPREQ5_BLANK_OFFSET_0_BASE_IDX                                                             2
#define mmHUBPREQ5_BLANK_OFFSET_1                                                                      0x0a91
#define mmHUBPREQ5_BLANK_OFFSET_1_BASE_IDX                                                             2
#define mmHUBPREQ5_DST_DIMENSIONS                                                                      0x0a92
#define mmHUBPREQ5_DST_DIMENSIONS_BASE_IDX                                                             2
#define mmHUBPREQ5_DST_AFTER_SCALER                                                                    0x0a93
#define mmHUBPREQ5_DST_AFTER_SCALER_BASE_IDX                                                           2
#define mmHUBPREQ5_PREFETCH_SETTINGS                                                                   0x0a94
#define mmHUBPREQ5_PREFETCH_SETTINGS_BASE_IDX                                                          2
#define mmHUBPREQ5_PREFETCH_SETTINGS_C                                                                 0x0a95
#define mmHUBPREQ5_PREFETCH_SETTINGS_C_BASE_IDX                                                        2
#define mmHUBPREQ5_VBLANK_PARAMETERS_0                                                                 0x0a96
#define mmHUBPREQ5_VBLANK_PARAMETERS_0_BASE_IDX                                                        2
#define mmHUBPREQ5_VBLANK_PARAMETERS_1                                                                 0x0a97
#define mmHUBPREQ5_VBLANK_PARAMETERS_1_BASE_IDX                                                        2
#define mmHUBPREQ5_VBLANK_PARAMETERS_2                                                                 0x0a98
#define mmHUBPREQ5_VBLANK_PARAMETERS_2_BASE_IDX                                                        2
#define mmHUBPREQ5_VBLANK_PARAMETERS_3                                                                 0x0a99
#define mmHUBPREQ5_VBLANK_PARAMETERS_3_BASE_IDX                                                        2
#define mmHUBPREQ5_VBLANK_PARAMETERS_4                                                                 0x0a9a
#define mmHUBPREQ5_VBLANK_PARAMETERS_4_BASE_IDX                                                        2
#define mmHUBPREQ5_FLIP_PARAMETERS_0                                                                   0x0a9b
#define mmHUBPREQ5_FLIP_PARAMETERS_0_BASE_IDX                                                          2
#define mmHUBPREQ5_FLIP_PARAMETERS_1                                                                   0x0a9c
#define mmHUBPREQ5_FLIP_PARAMETERS_1_BASE_IDX                                                          2
#define mmHUBPREQ5_FLIP_PARAMETERS_2                                                                   0x0a9d
#define mmHUBPREQ5_FLIP_PARAMETERS_2_BASE_IDX                                                          2
#define mmHUBPREQ5_NOM_PARAMETERS_0                                                                    0x0a9e
#define mmHUBPREQ5_NOM_PARAMETERS_0_BASE_IDX                                                           2
#define mmHUBPREQ5_NOM_PARAMETERS_1                                                                    0x0a9f
#define mmHUBPREQ5_NOM_PARAMETERS_1_BASE_IDX                                                           2
#define mmHUBPREQ5_NOM_PARAMETERS_2                                                                    0x0aa0
#define mmHUBPREQ5_NOM_PARAMETERS_2_BASE_IDX                                                           2
#define mmHUBPREQ5_NOM_PARAMETERS_3                                                                    0x0aa1
#define mmHUBPREQ5_NOM_PARAMETERS_3_BASE_IDX                                                           2
#define mmHUBPREQ5_NOM_PARAMETERS_4                                                                    0x0aa2
#define mmHUBPREQ5_NOM_PARAMETERS_4_BASE_IDX                                                           2
#define mmHUBPREQ5_NOM_PARAMETERS_5                                                                    0x0aa3
#define mmHUBPREQ5_NOM_PARAMETERS_5_BASE_IDX                                                           2
#define mmHUBPREQ5_NOM_PARAMETERS_6                                                                    0x0aa4
#define mmHUBPREQ5_NOM_PARAMETERS_6_BASE_IDX                                                           2
#define mmHUBPREQ5_NOM_PARAMETERS_7                                                                    0x0aa5
#define mmHUBPREQ5_NOM_PARAMETERS_7_BASE_IDX                                                           2
#define mmHUBPREQ5_PER_LINE_DELIVERY_PRE                                                               0x0aa6
#define mmHUBPREQ5_PER_LINE_DELIVERY_PRE_BASE_IDX                                                      2
#define mmHUBPREQ5_PER_LINE_DELIVERY                                                                   0x0aa7
#define mmHUBPREQ5_PER_LINE_DELIVERY_BASE_IDX                                                          2
#define mmHUBPREQ5_CURSOR_SETTINGS                                                                     0x0aa8
#define mmHUBPREQ5_CURSOR_SETTINGS_BASE_IDX                                                            2
#define mmHUBPREQ5_REF_FREQ_TO_PIX_FREQ                                                                0x0aa9
#define mmHUBPREQ5_REF_FREQ_TO_PIX_FREQ_BASE_IDX                                                       2
#define mmHUBPREQ5_DST_Y_DELTA_DRQ_LIMIT                                                               0x0aaa
#define mmHUBPREQ5_DST_Y_DELTA_DRQ_LIMIT_BASE_IDX                                                      2
#define mmHUBPREQ5_HUBPREQ_MEM_PWR_CTRL                                                                0x0aab
#define mmHUBPREQ5_HUBPREQ_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPREQ5_HUBPREQ_MEM_PWR_STATUS                                                              0x0aac
#define mmHUBPREQ5_HUBPREQ_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPREQ5_VBLANK_PARAMETERS_5                                                                 0x0aaf
#define mmHUBPREQ5_VBLANK_PARAMETERS_5_BASE_IDX                                                        2
#define mmHUBPREQ5_VBLANK_PARAMETERS_6                                                                 0x0ab0
#define mmHUBPREQ5_VBLANK_PARAMETERS_6_BASE_IDX                                                        2
#define mmHUBPREQ5_FLIP_PARAMETERS_3                                                                   0x0ab1
#define mmHUBPREQ5_FLIP_PARAMETERS_3_BASE_IDX                                                          2
#define mmHUBPREQ5_FLIP_PARAMETERS_4                                                                   0x0ab2
#define mmHUBPREQ5_FLIP_PARAMETERS_4_BASE_IDX                                                          2
#define mmHUBPREQ5_FLIP_PARAMETERS_5                                                                   0x0ab3
#define mmHUBPREQ5_FLIP_PARAMETERS_5_BASE_IDX                                                          2
#define mmHUBPREQ5_FLIP_PARAMETERS_6                                                                   0x0ab4
#define mmHUBPREQ5_FLIP_PARAMETERS_6_BASE_IDX                                                          2


// addressBlock: dce_dc_dcbubp5_dispdec_hubpret_dispdec
// base address: 0x1130
#define mmHUBPRET5_HUBPRET_CONTROL                                                                     0x0ab8
#define mmHUBPRET5_HUBPRET_CONTROL_BASE_IDX                                                            2
#define mmHUBPRET5_HUBPRET_MEM_PWR_CTRL                                                                0x0ab9
#define mmHUBPRET5_HUBPRET_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmHUBPRET5_HUBPRET_MEM_PWR_STATUS                                                              0x0aba
#define mmHUBPRET5_HUBPRET_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmHUBPRET5_HUBPRET_READ_LINE_CTRL0                                                             0x0abb
#define mmHUBPRET5_HUBPRET_READ_LINE_CTRL0_BASE_IDX                                                    2
#define mmHUBPRET5_HUBPRET_READ_LINE_CTRL1                                                             0x0abc
#define mmHUBPRET5_HUBPRET_READ_LINE_CTRL1_BASE_IDX                                                    2
#define mmHUBPRET5_HUBPRET_READ_LINE0                                                                  0x0abd
#define mmHUBPRET5_HUBPRET_READ_LINE0_BASE_IDX                                                         2
#define mmHUBPRET5_HUBPRET_READ_LINE1                                                                  0x0abe
#define mmHUBPRET5_HUBPRET_READ_LINE1_BASE_IDX                                                         2
#define mmHUBPRET5_HUBPRET_INTERRUPT                                                                   0x0abf
#define mmHUBPRET5_HUBPRET_INTERRUPT_BASE_IDX                                                          2
#define mmHUBPRET5_HUBPRET_READ_LINE_VALUE                                                             0x0ac0
#define mmHUBPRET5_HUBPRET_READ_LINE_VALUE_BASE_IDX                                                    2
#define mmHUBPRET5_HUBPRET_READ_LINE_STATUS                                                            0x0ac1
#define mmHUBPRET5_HUBPRET_READ_LINE_STATUS_BASE_IDX                                                   2


// addressBlock: dce_dc_dcbubp5_dispdec_cursor0_dispdec
// base address: 0x1130
#define mmCURSOR0_5_CURSOR_CONTROL                                                                     0x0ac4
#define mmCURSOR0_5_CURSOR_CONTROL_BASE_IDX                                                            2
#define mmCURSOR0_5_CURSOR_SURFACE_ADDRESS                                                             0x0ac5
#define mmCURSOR0_5_CURSOR_SURFACE_ADDRESS_BASE_IDX                                                    2
#define mmCURSOR0_5_CURSOR_SURFACE_ADDRESS_HIGH                                                        0x0ac6
#define mmCURSOR0_5_CURSOR_SURFACE_ADDRESS_HIGH_BASE_IDX                                               2
#define mmCURSOR0_5_CURSOR_SIZE                                                                        0x0ac7
#define mmCURSOR0_5_CURSOR_SIZE_BASE_IDX                                                               2
#define mmCURSOR0_5_CURSOR_POSITION                                                                    0x0ac8
#define mmCURSOR0_5_CURSOR_POSITION_BASE_IDX                                                           2
#define mmCURSOR0_5_CURSOR_HOT_SPOT                                                                    0x0ac9
#define mmCURSOR0_5_CURSOR_HOT_SPOT_BASE_IDX                                                           2
#define mmCURSOR0_5_CURSOR_STEREO_CONTROL                                                              0x0aca
#define mmCURSOR0_5_CURSOR_STEREO_CONTROL_BASE_IDX                                                     2
#define mmCURSOR0_5_CURSOR_DST_OFFSET                                                                  0x0acb
#define mmCURSOR0_5_CURSOR_DST_OFFSET_BASE_IDX                                                         2
#define mmCURSOR0_5_CURSOR_MEM_PWR_CTRL                                                                0x0acc
#define mmCURSOR0_5_CURSOR_MEM_PWR_CTRL_BASE_IDX                                                       2
#define mmCURSOR0_5_CURSOR_MEM_PWR_STATUS                                                              0x0acd
#define mmCURSOR0_5_CURSOR_MEM_PWR_STATUS_BASE_IDX                                                     2
#define mmCURSOR0_5_DMDATA_ADDRESS_HIGH                                                                0x0ace
#define mmCURSOR0_5_DMDATA_ADDRESS_HIGH_BASE_IDX                                                       2
#define mmCURSOR0_5_DMDATA_ADDRESS_LOW                                                                 0x0acf
#define mmCURSOR0_5_DMDATA_ADDRESS_LOW_BASE_IDX                                                        2
#define mmCURSOR0_5_DMDATA_CNTL                                                                        0x0ad0
#define mmCURSOR0_5_DMDATA_CNTL_BASE_IDX                                                               2
#define mmCURSOR0_5_DMDATA_QOS_CNTL                                                                    0x0ad1
#define mmCURSOR0_5_DMDATA_QOS_CNTL_BASE_IDX                                                           2
#define mmCURSOR0_5_DMDATA_STATUS                                                                      0x0ad2
#define mmCURSOR0_5_DMDATA_STATUS_BASE_IDX                                                             2
#define mmCURSOR0_5_DMDATA_SW_CNTL                                                                     0x0ad3
#define mmCURSOR0_5_DMDATA_SW_CNTL_BASE_IDX                                                            2
#define mmCURSOR0_5_DMDATA_SW_DATA                                                                     0x0ad4
#define mmCURSOR0_5_DMDATA_SW_DATA_BASE_IDX                                                            2

// addressBlock: dce_dc_dpp0_dispdec_dpp_top_dispdec
// base address: 0x0
#define mmDPP_TOP0_DPP_CONTROL                                                                         0x0cc5
#define mmDPP_TOP0_DPP_CONTROL_BASE_IDX                                                                2
#define mmDPP_TOP0_DPP_SOFT_RESET                                                                      0x0cc6
#define mmDPP_TOP0_DPP_SOFT_RESET_BASE_IDX                                                             2
#define mmDPP_TOP0_DPP_CRC_VAL_R_G                                                                     0x0cc7
#define mmDPP_TOP0_DPP_CRC_VAL_R_G_BASE_IDX                                                            2
#define mmDPP_TOP0_DPP_CRC_VAL_B_A                                                                     0x0cc8
#define mmDPP_TOP0_DPP_CRC_VAL_B_A_BASE_IDX                                                            2
#define mmDPP_TOP0_DPP_CRC_CTRL                                                                        0x0cc9
#define mmDPP_TOP0_DPP_CRC_CTRL_BASE_IDX                                                               2
#define mmDPP_TOP0_HOST_READ_CONTROL                                                                   0x0cca
#define mmDPP_TOP0_HOST_READ_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_dpp0_dispdec_cnvc_cfg_dispdec
// base address: 0x0
#define mmCNVC_CFG0_CNVC_SURFACE_PIXEL_FORMAT                                                          0x0ccf
#define mmCNVC_CFG0_CNVC_SURFACE_PIXEL_FORMAT_BASE_IDX                                                 2
#define mmCNVC_CFG0_FORMAT_CONTROL                                                                     0x0cd0
#define mmCNVC_CFG0_FORMAT_CONTROL_BASE_IDX                                                            2
#define mmCNVC_CFG0_FCNV_FP_BIAS_R                                                                     0x0cd1
#define mmCNVC_CFG0_FCNV_FP_BIAS_R_BASE_IDX                                                            2
#define mmCNVC_CFG0_FCNV_FP_BIAS_G                                                                     0x0cd2
#define mmCNVC_CFG0_FCNV_FP_BIAS_G_BASE_IDX                                                            2
#define mmCNVC_CFG0_FCNV_FP_BIAS_B                                                                     0x0cd3
#define mmCNVC_CFG0_FCNV_FP_BIAS_B_BASE_IDX                                                            2
#define mmCNVC_CFG0_FCNV_FP_SCALE_R                                                                    0x0cd4
#define mmCNVC_CFG0_FCNV_FP_SCALE_R_BASE_IDX                                                           2
#define mmCNVC_CFG0_FCNV_FP_SCALE_G                                                                    0x0cd5
#define mmCNVC_CFG0_FCNV_FP_SCALE_G_BASE_IDX                                                           2
#define mmCNVC_CFG0_FCNV_FP_SCALE_B                                                                    0x0cd6
#define mmCNVC_CFG0_FCNV_FP_SCALE_B_BASE_IDX                                                           2
#define mmCNVC_CFG0_COLOR_KEYER_CONTROL                                                                0x0cd7
#define mmCNVC_CFG0_COLOR_KEYER_CONTROL_BASE_IDX                                                       2
#define mmCNVC_CFG0_COLOR_KEYER_ALPHA                                                                  0x0cd8
#define mmCNVC_CFG0_COLOR_KEYER_ALPHA_BASE_IDX                                                         2
#define mmCNVC_CFG0_COLOR_KEYER_RED                                                                    0x0cd9
#define mmCNVC_CFG0_COLOR_KEYER_RED_BASE_IDX                                                           2
#define mmCNVC_CFG0_COLOR_KEYER_GREEN                                                                  0x0cda
#define mmCNVC_CFG0_COLOR_KEYER_GREEN_BASE_IDX                                                         2
#define mmCNVC_CFG0_COLOR_KEYER_BLUE                                                                   0x0cdb
#define mmCNVC_CFG0_COLOR_KEYER_BLUE_BASE_IDX                                                          2
#define mmCNVC_CFG0_ALPHA_2BIT_LUT                                                                     0x0cdd
#define mmCNVC_CFG0_ALPHA_2BIT_LUT_BASE_IDX                                                            2
#define mmCNVC_CFG0_PRE_DEALPHA                                                                        0x0cde
#define mmCNVC_CFG0_PRE_DEALPHA_BASE_IDX                                                               2
#define mmCNVC_CFG0_PRE_CSC_MODE                                                                       0x0cdf
#define mmCNVC_CFG0_PRE_CSC_MODE_BASE_IDX                                                              2
#define mmCNVC_CFG0_PRE_CSC_C11_C12                                                                    0x0ce0
#define mmCNVC_CFG0_PRE_CSC_C11_C12_BASE_IDX                                                           2
#define mmCNVC_CFG0_PRE_CSC_C13_C14                                                                    0x0ce1
#define mmCNVC_CFG0_PRE_CSC_C13_C14_BASE_IDX                                                           2
#define mmCNVC_CFG0_PRE_CSC_C21_C22                                                                    0x0ce2
#define mmCNVC_CFG0_PRE_CSC_C21_C22_BASE_IDX                                                           2
#define mmCNVC_CFG0_PRE_CSC_C23_C24                                                                    0x0ce3
#define mmCNVC_CFG0_PRE_CSC_C23_C24_BASE_IDX                                                           2
#define mmCNVC_CFG0_PRE_CSC_C31_C32                                                                    0x0ce4
#define mmCNVC_CFG0_PRE_CSC_C31_C32_BASE_IDX                                                           2
#define mmCNVC_CFG0_PRE_CSC_C33_C34                                                                    0x0ce5
#define mmCNVC_CFG0_PRE_CSC_C33_C34_BASE_IDX                                                           2
#define mmCNVC_CFG0_PRE_CSC_B_C11_C12                                                                  0x0ce6
#define mmCNVC_CFG0_PRE_CSC_B_C11_C12_BASE_IDX                                                         2
#define mmCNVC_CFG0_PRE_CSC_B_C13_C14                                                                  0x0ce7
#define mmCNVC_CFG0_PRE_CSC_B_C13_C14_BASE_IDX                                                         2
#define mmCNVC_CFG0_PRE_CSC_B_C21_C22                                                                  0x0ce8
#define mmCNVC_CFG0_PRE_CSC_B_C21_C22_BASE_IDX                                                         2
#define mmCNVC_CFG0_PRE_CSC_B_C23_C24                                                                  0x0ce9
#define mmCNVC_CFG0_PRE_CSC_B_C23_C24_BASE_IDX                                                         2
#define mmCNVC_CFG0_PRE_CSC_B_C31_C32                                                                  0x0cea
#define mmCNVC_CFG0_PRE_CSC_B_C31_C32_BASE_IDX                                                         2
#define mmCNVC_CFG0_PRE_CSC_B_C33_C34                                                                  0x0ceb
#define mmCNVC_CFG0_PRE_CSC_B_C33_C34_BASE_IDX                                                         2
#define mmCNVC_CFG0_CNVC_COEF_FORMAT                                                                   0x0cec
#define mmCNVC_CFG0_CNVC_COEF_FORMAT_BASE_IDX                                                          2
#define mmCNVC_CFG0_PRE_DEGAM                                                                          0x0ced
#define mmCNVC_CFG0_PRE_DEGAM_BASE_IDX                                                                 2
#define mmCNVC_CFG0_PRE_REALPHA                                                                        0x0cee
#define mmCNVC_CFG0_PRE_REALPHA_BASE_IDX                                                               2


// addressBlock: dce_dc_dpp0_dispdec_cnvc_cur_dispdec
// base address: 0x0
#define mmCNVC_CUR0_CURSOR0_CONTROL                                                                    0x0cf1
#define mmCNVC_CUR0_CURSOR0_CONTROL_BASE_IDX                                                           2
#define mmCNVC_CUR0_CURSOR0_COLOR0                                                                     0x0cf2
#define mmCNVC_CUR0_CURSOR0_COLOR0_BASE_IDX                                                            2
#define mmCNVC_CUR0_CURSOR0_COLOR1                                                                     0x0cf3
#define mmCNVC_CUR0_CURSOR0_COLOR1_BASE_IDX                                                            2
#define mmCNVC_CUR0_CURSOR0_FP_SCALE_BIAS                                                              0x0cf4
#define mmCNVC_CUR0_CURSOR0_FP_SCALE_BIAS_BASE_IDX                                                     2


// addressBlock: dce_dc_dpp0_dispdec_dscl_dispdec
// base address: 0x0
#define mmDSCL0_SCL_COEF_RAM_TAP_SELECT                                                                0x0cf9
#define mmDSCL0_SCL_COEF_RAM_TAP_SELECT_BASE_IDX                                                       2
#define mmDSCL0_SCL_COEF_RAM_TAP_DATA                                                                  0x0cfa
#define mmDSCL0_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                         2
#define mmDSCL0_SCL_MODE                                                                               0x0cfb
#define mmDSCL0_SCL_MODE_BASE_IDX                                                                      2
#define mmDSCL0_SCL_TAP_CONTROL                                                                        0x0cfc
#define mmDSCL0_SCL_TAP_CONTROL_BASE_IDX                                                               2
#define mmDSCL0_DSCL_CONTROL                                                                           0x0cfd
#define mmDSCL0_DSCL_CONTROL_BASE_IDX                                                                  2
#define mmDSCL0_DSCL_2TAP_CONTROL                                                                      0x0cfe
#define mmDSCL0_DSCL_2TAP_CONTROL_BASE_IDX                                                             2
#define mmDSCL0_SCL_MANUAL_REPLICATE_CONTROL                                                           0x0cff
#define mmDSCL0_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                  2
#define mmDSCL0_SCL_HORZ_FILTER_SCALE_RATIO                                                            0x0d00
#define mmDSCL0_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define mmDSCL0_SCL_HORZ_FILTER_INIT                                                                   0x0d01
#define mmDSCL0_SCL_HORZ_FILTER_INIT_BASE_IDX                                                          2
#define mmDSCL0_SCL_HORZ_FILTER_SCALE_RATIO_C                                                          0x0d02
#define mmDSCL0_SCL_HORZ_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define mmDSCL0_SCL_HORZ_FILTER_INIT_C                                                                 0x0d03
#define mmDSCL0_SCL_HORZ_FILTER_INIT_C_BASE_IDX                                                        2
#define mmDSCL0_SCL_VERT_FILTER_SCALE_RATIO                                                            0x0d04
#define mmDSCL0_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define mmDSCL0_SCL_VERT_FILTER_INIT                                                                   0x0d05
#define mmDSCL0_SCL_VERT_FILTER_INIT_BASE_IDX                                                          2
#define mmDSCL0_SCL_VERT_FILTER_INIT_BOT                                                               0x0d06
#define mmDSCL0_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                      2
#define mmDSCL0_SCL_VERT_FILTER_SCALE_RATIO_C                                                          0x0d07
#define mmDSCL0_SCL_VERT_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define mmDSCL0_SCL_VERT_FILTER_INIT_C                                                                 0x0d08
#define mmDSCL0_SCL_VERT_FILTER_INIT_C_BASE_IDX                                                        2
#define mmDSCL0_SCL_VERT_FILTER_INIT_BOT_C                                                             0x0d09
#define mmDSCL0_SCL_VERT_FILTER_INIT_BOT_C_BASE_IDX                                                    2
#define mmDSCL0_SCL_BLACK_COLOR                                                                        0x0d0a
#define mmDSCL0_SCL_BLACK_COLOR_BASE_IDX                                                               2
#define mmDSCL0_DSCL_UPDATE                                                                            0x0d0b
#define mmDSCL0_DSCL_UPDATE_BASE_IDX                                                                   2
#define mmDSCL0_DSCL_AUTOCAL                                                                           0x0d0c
#define mmDSCL0_DSCL_AUTOCAL_BASE_IDX                                                                  2
#define mmDSCL0_DSCL_EXT_OVERSCAN_LEFT_RIGHT                                                           0x0d0d
#define mmDSCL0_DSCL_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                  2
#define mmDSCL0_DSCL_EXT_OVERSCAN_TOP_BOTTOM                                                           0x0d0e
#define mmDSCL0_DSCL_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                  2
#define mmDSCL0_OTG_H_BLANK                                                                            0x0d0f
#define mmDSCL0_OTG_H_BLANK_BASE_IDX                                                                   2
#define mmDSCL0_OTG_V_BLANK                                                                            0x0d10
#define mmDSCL0_OTG_V_BLANK_BASE_IDX                                                                   2
#define mmDSCL0_RECOUT_START                                                                           0x0d11
#define mmDSCL0_RECOUT_START_BASE_IDX                                                                  2
#define mmDSCL0_RECOUT_SIZE                                                                            0x0d12
#define mmDSCL0_RECOUT_SIZE_BASE_IDX                                                                   2
#define mmDSCL0_MPC_SIZE                                                                               0x0d13
#define mmDSCL0_MPC_SIZE_BASE_IDX                                                                      2
#define mmDSCL0_LB_DATA_FORMAT                                                                         0x0d14
#define mmDSCL0_LB_DATA_FORMAT_BASE_IDX                                                                2
#define mmDSCL0_LB_MEMORY_CTRL                                                                         0x0d15
#define mmDSCL0_LB_MEMORY_CTRL_BASE_IDX                                                                2
#define mmDSCL0_LB_V_COUNTER                                                                           0x0d16
#define mmDSCL0_LB_V_COUNTER_BASE_IDX                                                                  2
#define mmDSCL0_DSCL_MEM_PWR_CTRL                                                                      0x0d17
#define mmDSCL0_DSCL_MEM_PWR_CTRL_BASE_IDX                                                             2
#define mmDSCL0_DSCL_MEM_PWR_STATUS                                                                    0x0d18
#define mmDSCL0_DSCL_MEM_PWR_STATUS_BASE_IDX                                                           2
#define mmDSCL0_OBUF_CONTROL                                                                           0x0d19
#define mmDSCL0_OBUF_CONTROL_BASE_IDX                                                                  2
#define mmDSCL0_OBUF_MEM_PWR_CTRL                                                                      0x0d1a
#define mmDSCL0_OBUF_MEM_PWR_CTRL_BASE_IDX                                                             2


// addressBlock: dce_dc_dpp0_dispdec_cm_dispdec
// base address: 0x0
#define mmCM0_CM_CONTROL                                                                               0x0d20
#define mmCM0_CM_CONTROL_BASE_IDX                                                                      2
#define mmCM0_CM_POST_CSC_CONTROL                                                                      0x0d21
#define mmCM0_CM_POST_CSC_CONTROL_BASE_IDX                                                             2
#define mmCM0_CM_POST_CSC_C11_C12                                                                      0x0d22
#define mmCM0_CM_POST_CSC_C11_C12_BASE_IDX                                                             2
#define mmCM0_CM_POST_CSC_C13_C14                                                                      0x0d23
#define mmCM0_CM_POST_CSC_C13_C14_BASE_IDX                                                             2
#define mmCM0_CM_POST_CSC_C21_C22                                                                      0x0d24
#define mmCM0_CM_POST_CSC_C21_C22_BASE_IDX                                                             2
#define mmCM0_CM_POST_CSC_C23_C24                                                                      0x0d25
#define mmCM0_CM_POST_CSC_C23_C24_BASE_IDX                                                             2
#define mmCM0_CM_POST_CSC_C31_C32                                                                      0x0d26
#define mmCM0_CM_POST_CSC_C31_C32_BASE_IDX                                                             2
#define mmCM0_CM_POST_CSC_C33_C34                                                                      0x0d27
#define mmCM0_CM_POST_CSC_C33_C34_BASE_IDX                                                             2
#define mmCM0_CM_POST_CSC_B_C11_C12                                                                    0x0d28
#define mmCM0_CM_POST_CSC_B_C11_C12_BASE_IDX                                                           2
#define mmCM0_CM_POST_CSC_B_C13_C14                                                                    0x0d29
#define mmCM0_CM_POST_CSC_B_C13_C14_BASE_IDX                                                           2
#define mmCM0_CM_POST_CSC_B_C21_C22                                                                    0x0d2a
#define mmCM0_CM_POST_CSC_B_C21_C22_BASE_IDX                                                           2
#define mmCM0_CM_POST_CSC_B_C23_C24                                                                    0x0d2b
#define mmCM0_CM_POST_CSC_B_C23_C24_BASE_IDX                                                           2
#define mmCM0_CM_POST_CSC_B_C31_C32                                                                    0x0d2c
#define mmCM0_CM_POST_CSC_B_C31_C32_BASE_IDX                                                           2
#define mmCM0_CM_POST_CSC_B_C33_C34                                                                    0x0d2d
#define mmCM0_CM_POST_CSC_B_C33_C34_BASE_IDX                                                           2
#define mmCM0_CM_GAMUT_REMAP_CONTROL                                                                   0x0d2e
#define mmCM0_CM_GAMUT_REMAP_CONTROL_BASE_IDX                                                          2
#define mmCM0_CM_GAMUT_REMAP_C11_C12                                                                   0x0d2f
#define mmCM0_CM_GAMUT_REMAP_C11_C12_BASE_IDX                                                          2
#define mmCM0_CM_GAMUT_REMAP_C13_C14                                                                   0x0d30
#define mmCM0_CM_GAMUT_REMAP_C13_C14_BASE_IDX                                                          2
#define mmCM0_CM_GAMUT_REMAP_C21_C22                                                                   0x0d31
#define mmCM0_CM_GAMUT_REMAP_C21_C22_BASE_IDX                                                          2
#define mmCM0_CM_GAMUT_REMAP_C23_C24                                                                   0x0d32
#define mmCM0_CM_GAMUT_REMAP_C23_C24_BASE_IDX                                                          2
#define mmCM0_CM_GAMUT_REMAP_C31_C32                                                                   0x0d33
#define mmCM0_CM_GAMUT_REMAP_C31_C32_BASE_IDX                                                          2
#define mmCM0_CM_GAMUT_REMAP_C33_C34                                                                   0x0d34
#define mmCM0_CM_GAMUT_REMAP_C33_C34_BASE_IDX                                                          2
#define mmCM0_CM_GAMUT_REMAP_B_C11_C12                                                                 0x0d35
#define mmCM0_CM_GAMUT_REMAP_B_C11_C12_BASE_IDX                                                        2
#define mmCM0_CM_GAMUT_REMAP_B_C13_C14                                                                 0x0d36
#define mmCM0_CM_GAMUT_REMAP_B_C13_C14_BASE_IDX                                                        2
#define mmCM0_CM_GAMUT_REMAP_B_C21_C22                                                                 0x0d37
#define mmCM0_CM_GAMUT_REMAP_B_C21_C22_BASE_IDX                                                        2
#define mmCM0_CM_GAMUT_REMAP_B_C23_C24                                                                 0x0d38
#define mmCM0_CM_GAMUT_REMAP_B_C23_C24_BASE_IDX                                                        2
#define mmCM0_CM_GAMUT_REMAP_B_C31_C32                                                                 0x0d39
#define mmCM0_CM_GAMUT_REMAP_B_C31_C32_BASE_IDX                                                        2
#define mmCM0_CM_GAMUT_REMAP_B_C33_C34                                                                 0x0d3a
#define mmCM0_CM_GAMUT_REMAP_B_C33_C34_BASE_IDX                                                        2
#define mmCM0_CM_BIAS_CR_R                                                                             0x0d3b
#define mmCM0_CM_BIAS_CR_R_BASE_IDX                                                                    2
#define mmCM0_CM_BIAS_Y_G_CB_B                                                                         0x0d3c
#define mmCM0_CM_BIAS_Y_G_CB_B_BASE_IDX                                                                2
#define mmCM0_CM_GAMCOR_CONTROL                                                                        0x0d3d
#define mmCM0_CM_GAMCOR_CONTROL_BASE_IDX                                                               2
#define mmCM0_CM_GAMCOR_LUT_INDEX                                                                      0x0d3e
#define mmCM0_CM_GAMCOR_LUT_INDEX_BASE_IDX                                                             2
#define mmCM0_CM_GAMCOR_LUT_DATA                                                                       0x0d3f
#define mmCM0_CM_GAMCOR_LUT_DATA_BASE_IDX                                                              2
#define mmCM0_CM_GAMCOR_LUT_CONTROL                                                                    0x0d40
#define mmCM0_CM_GAMCOR_LUT_CONTROL_BASE_IDX                                                           2
#define mmCM0_CM_GAMCOR_RAMA_START_CNTL_B                                                              0x0d41
#define mmCM0_CM_GAMCOR_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_START_CNTL_G                                                              0x0d42
#define mmCM0_CM_GAMCOR_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_START_CNTL_R                                                              0x0d43
#define mmCM0_CM_GAMCOR_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B                                                        0x0d44
#define mmCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define mmCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G                                                        0x0d45
#define mmCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define mmCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R                                                        0x0d46
#define mmCM0_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define mmCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_B                                                         0x0d47
#define mmCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_B_BASE_IDX                                                2
#define mmCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_G                                                         0x0d48
#define mmCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_G_BASE_IDX                                                2
#define mmCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_R                                                         0x0d49
#define mmCM0_CM_GAMCOR_RAMA_START_BASE_CNTL_R_BASE_IDX                                                2
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL1_B                                                               0x0d4a
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL1_B_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL2_B                                                               0x0d4b
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL2_B_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL1_G                                                               0x0d4c
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL1_G_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL2_G                                                               0x0d4d
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL2_G_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL1_R                                                               0x0d4e
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL1_R_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL2_R                                                               0x0d4f
#define mmCM0_CM_GAMCOR_RAMA_END_CNTL2_R_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMA_OFFSET_B                                                                  0x0d50
#define mmCM0_CM_GAMCOR_RAMA_OFFSET_B_BASE_IDX                                                         2
#define mmCM0_CM_GAMCOR_RAMA_OFFSET_G                                                                  0x0d51
#define mmCM0_CM_GAMCOR_RAMA_OFFSET_G_BASE_IDX                                                         2
#define mmCM0_CM_GAMCOR_RAMA_OFFSET_R                                                                  0x0d52
#define mmCM0_CM_GAMCOR_RAMA_OFFSET_R_BASE_IDX                                                         2
#define mmCM0_CM_GAMCOR_RAMA_REGION_0_1                                                                0x0d53
#define mmCM0_CM_GAMCOR_RAMA_REGION_0_1_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMA_REGION_2_3                                                                0x0d54
#define mmCM0_CM_GAMCOR_RAMA_REGION_2_3_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMA_REGION_4_5                                                                0x0d55
#define mmCM0_CM_GAMCOR_RAMA_REGION_4_5_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMA_REGION_6_7                                                                0x0d56
#define mmCM0_CM_GAMCOR_RAMA_REGION_6_7_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMA_REGION_8_9                                                                0x0d57
#define mmCM0_CM_GAMCOR_RAMA_REGION_8_9_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMA_REGION_10_11                                                              0x0d58
#define mmCM0_CM_GAMCOR_RAMA_REGION_10_11_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_12_13                                                              0x0d59
#define mmCM0_CM_GAMCOR_RAMA_REGION_12_13_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_14_15                                                              0x0d5a
#define mmCM0_CM_GAMCOR_RAMA_REGION_14_15_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_16_17                                                              0x0d5b
#define mmCM0_CM_GAMCOR_RAMA_REGION_16_17_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_18_19                                                              0x0d5c
#define mmCM0_CM_GAMCOR_RAMA_REGION_18_19_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_20_21                                                              0x0d5d
#define mmCM0_CM_GAMCOR_RAMA_REGION_20_21_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_22_23                                                              0x0d5e
#define mmCM0_CM_GAMCOR_RAMA_REGION_22_23_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_24_25                                                              0x0d5f
#define mmCM0_CM_GAMCOR_RAMA_REGION_24_25_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_26_27                                                              0x0d60
#define mmCM0_CM_GAMCOR_RAMA_REGION_26_27_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_28_29                                                              0x0d61
#define mmCM0_CM_GAMCOR_RAMA_REGION_28_29_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_30_31                                                              0x0d62
#define mmCM0_CM_GAMCOR_RAMA_REGION_30_31_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMA_REGION_32_33                                                              0x0d63
#define mmCM0_CM_GAMCOR_RAMA_REGION_32_33_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_START_CNTL_B                                                              0x0d64
#define mmCM0_CM_GAMCOR_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_START_CNTL_G                                                              0x0d65
#define mmCM0_CM_GAMCOR_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_START_CNTL_R                                                              0x0d66
#define mmCM0_CM_GAMCOR_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B                                                        0x0d67
#define mmCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define mmCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G                                                        0x0d68
#define mmCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define mmCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R                                                        0x0d69
#define mmCM0_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define mmCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_B                                                         0x0d6a
#define mmCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_B_BASE_IDX                                                2
#define mmCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_G                                                         0x0d6b
#define mmCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_G_BASE_IDX                                                2
#define mmCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_R                                                         0x0d6c
#define mmCM0_CM_GAMCOR_RAMB_START_BASE_CNTL_R_BASE_IDX                                                2
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL1_B                                                               0x0d6d
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL1_B_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL2_B                                                               0x0d6e
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL2_B_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL1_G                                                               0x0d6f
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL1_G_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL2_G                                                               0x0d70
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL2_G_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL1_R                                                               0x0d71
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL1_R_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL2_R                                                               0x0d72
#define mmCM0_CM_GAMCOR_RAMB_END_CNTL2_R_BASE_IDX                                                      2
#define mmCM0_CM_GAMCOR_RAMB_OFFSET_B                                                                  0x0d73
#define mmCM0_CM_GAMCOR_RAMB_OFFSET_B_BASE_IDX                                                         2
#define mmCM0_CM_GAMCOR_RAMB_OFFSET_G                                                                  0x0d74
#define mmCM0_CM_GAMCOR_RAMB_OFFSET_G_BASE_IDX                                                         2
#define mmCM0_CM_GAMCOR_RAMB_OFFSET_R                                                                  0x0d75
#define mmCM0_CM_GAMCOR_RAMB_OFFSET_R_BASE_IDX                                                         2
#define mmCM0_CM_GAMCOR_RAMB_REGION_0_1                                                                0x0d76
#define mmCM0_CM_GAMCOR_RAMB_REGION_0_1_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMB_REGION_2_3                                                                0x0d77
#define mmCM0_CM_GAMCOR_RAMB_REGION_2_3_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMB_REGION_4_5                                                                0x0d78
#define mmCM0_CM_GAMCOR_RAMB_REGION_4_5_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMB_REGION_6_7                                                                0x0d79
#define mmCM0_CM_GAMCOR_RAMB_REGION_6_7_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMB_REGION_8_9                                                                0x0d7a
#define mmCM0_CM_GAMCOR_RAMB_REGION_8_9_BASE_IDX                                                       2
#define mmCM0_CM_GAMCOR_RAMB_REGION_10_11                                                              0x0d7b
#define mmCM0_CM_GAMCOR_RAMB_REGION_10_11_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_12_13                                                              0x0d7c
#define mmCM0_CM_GAMCOR_RAMB_REGION_12_13_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_14_15                                                              0x0d7d
#define mmCM0_CM_GAMCOR_RAMB_REGION_14_15_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_16_17                                                              0x0d7e
#define mmCM0_CM_GAMCOR_RAMB_REGION_16_17_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_18_19                                                              0x0d7f
#define mmCM0_CM_GAMCOR_RAMB_REGION_18_19_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_20_21                                                              0x0d80
#define mmCM0_CM_GAMCOR_RAMB_REGION_20_21_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_22_23                                                              0x0d81
#define mmCM0_CM_GAMCOR_RAMB_REGION_22_23_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_24_25                                                              0x0d82
#define mmCM0_CM_GAMCOR_RAMB_REGION_24_25_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_26_27                                                              0x0d83
#define mmCM0_CM_GAMCOR_RAMB_REGION_26_27_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_28_29                                                              0x0d84
#define mmCM0_CM_GAMCOR_RAMB_REGION_28_29_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_30_31                                                              0x0d85
#define mmCM0_CM_GAMCOR_RAMB_REGION_30_31_BASE_IDX                                                     2
#define mmCM0_CM_GAMCOR_RAMB_REGION_32_33                                                              0x0d86
#define mmCM0_CM_GAMCOR_RAMB_REGION_32_33_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_CONTROL                                                                       0x0d87
#define mmCM0_CM_BLNDGAM_CONTROL_BASE_IDX                                                              2
#define mmCM0_CM_BLNDGAM_LUT_INDEX                                                                     0x0d88
#define mmCM0_CM_BLNDGAM_LUT_INDEX_BASE_IDX                                                            2
#define mmCM0_CM_BLNDGAM_LUT_DATA                                                                      0x0d89
#define mmCM0_CM_BLNDGAM_LUT_DATA_BASE_IDX                                                             2
#define mmCM0_CM_BLNDGAM_LUT_CONTROL                                                                   0x0d8a
#define mmCM0_CM_BLNDGAM_LUT_CONTROL_BASE_IDX                                                          2
#define mmCM0_CM_BLNDGAM_RAMA_START_CNTL_B                                                             0x0d8b
#define mmCM0_CM_BLNDGAM_RAMA_START_CNTL_B_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_START_CNTL_G                                                             0x0d8c
#define mmCM0_CM_BLNDGAM_RAMA_START_CNTL_G_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_START_CNTL_R                                                             0x0d8d
#define mmCM0_CM_BLNDGAM_RAMA_START_CNTL_R_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_B                                                       0x0d8e
#define mmCM0_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                              2
#define mmCM0_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_G                                                       0x0d8f
#define mmCM0_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                              2
#define mmCM0_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_R                                                       0x0d90
#define mmCM0_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                              2
#define mmCM0_CM_BLNDGAM_RAMA_START_BASE_CNTL_B                                                        0x0d91
#define mmCM0_CM_BLNDGAM_RAMA_START_BASE_CNTL_B_BASE_IDX                                               2
#define mmCM0_CM_BLNDGAM_RAMA_START_BASE_CNTL_G                                                        0x0d92
#define mmCM0_CM_BLNDGAM_RAMA_START_BASE_CNTL_G_BASE_IDX                                               2
#define mmCM0_CM_BLNDGAM_RAMA_START_BASE_CNTL_R                                                        0x0d93
#define mmCM0_CM_BLNDGAM_RAMA_START_BASE_CNTL_R_BASE_IDX                                               2
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL1_B                                                              0x0d94
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL1_B_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL2_B                                                              0x0d95
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL2_B_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL1_G                                                              0x0d96
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL1_G_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL2_G                                                              0x0d97
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL2_G_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL1_R                                                              0x0d98
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL1_R_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL2_R                                                              0x0d99
#define mmCM0_CM_BLNDGAM_RAMA_END_CNTL2_R_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMA_OFFSET_B                                                                 0x0d9a
#define mmCM0_CM_BLNDGAM_RAMA_OFFSET_B_BASE_IDX                                                        2
#define mmCM0_CM_BLNDGAM_RAMA_OFFSET_G                                                                 0x0d9b
#define mmCM0_CM_BLNDGAM_RAMA_OFFSET_G_BASE_IDX                                                        2
#define mmCM0_CM_BLNDGAM_RAMA_OFFSET_R                                                                 0x0d9c
#define mmCM0_CM_BLNDGAM_RAMA_OFFSET_R_BASE_IDX                                                        2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_0_1                                                               0x0d9d
#define mmCM0_CM_BLNDGAM_RAMA_REGION_0_1_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_2_3                                                               0x0d9e
#define mmCM0_CM_BLNDGAM_RAMA_REGION_2_3_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_4_5                                                               0x0d9f
#define mmCM0_CM_BLNDGAM_RAMA_REGION_4_5_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_6_7                                                               0x0da0
#define mmCM0_CM_BLNDGAM_RAMA_REGION_6_7_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_8_9                                                               0x0da1
#define mmCM0_CM_BLNDGAM_RAMA_REGION_8_9_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_10_11                                                             0x0da2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_10_11_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_12_13                                                             0x0da3
#define mmCM0_CM_BLNDGAM_RAMA_REGION_12_13_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_14_15                                                             0x0da4
#define mmCM0_CM_BLNDGAM_RAMA_REGION_14_15_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_16_17                                                             0x0da5
#define mmCM0_CM_BLNDGAM_RAMA_REGION_16_17_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_18_19                                                             0x0da6
#define mmCM0_CM_BLNDGAM_RAMA_REGION_18_19_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_20_21                                                             0x0da7
#define mmCM0_CM_BLNDGAM_RAMA_REGION_20_21_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_22_23                                                             0x0da8
#define mmCM0_CM_BLNDGAM_RAMA_REGION_22_23_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_24_25                                                             0x0da9
#define mmCM0_CM_BLNDGAM_RAMA_REGION_24_25_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_26_27                                                             0x0daa
#define mmCM0_CM_BLNDGAM_RAMA_REGION_26_27_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_28_29                                                             0x0dab
#define mmCM0_CM_BLNDGAM_RAMA_REGION_28_29_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_30_31                                                             0x0dac
#define mmCM0_CM_BLNDGAM_RAMA_REGION_30_31_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMA_REGION_32_33                                                             0x0dad
#define mmCM0_CM_BLNDGAM_RAMA_REGION_32_33_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_START_CNTL_B                                                             0x0dae
#define mmCM0_CM_BLNDGAM_RAMB_START_CNTL_B_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_START_CNTL_G                                                             0x0daf
#define mmCM0_CM_BLNDGAM_RAMB_START_CNTL_G_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_START_CNTL_R                                                             0x0db0
#define mmCM0_CM_BLNDGAM_RAMB_START_CNTL_R_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_B                                                       0x0db1
#define mmCM0_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                              2
#define mmCM0_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_G                                                       0x0db2
#define mmCM0_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                              2
#define mmCM0_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_R                                                       0x0db3
#define mmCM0_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                              2
#define mmCM0_CM_BLNDGAM_RAMB_START_BASE_CNTL_B                                                        0x0db4
#define mmCM0_CM_BLNDGAM_RAMB_START_BASE_CNTL_B_BASE_IDX                                               2
#define mmCM0_CM_BLNDGAM_RAMB_START_BASE_CNTL_G                                                        0x0db5
#define mmCM0_CM_BLNDGAM_RAMB_START_BASE_CNTL_G_BASE_IDX                                               2
#define mmCM0_CM_BLNDGAM_RAMB_START_BASE_CNTL_R                                                        0x0db6
#define mmCM0_CM_BLNDGAM_RAMB_START_BASE_CNTL_R_BASE_IDX                                               2
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL1_B                                                              0x0db7
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL1_B_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL2_B                                                              0x0db8
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL2_B_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL1_G                                                              0x0db9
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL1_G_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL2_G                                                              0x0dba
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL2_G_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL1_R                                                              0x0dbb
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL1_R_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL2_R                                                              0x0dbc
#define mmCM0_CM_BLNDGAM_RAMB_END_CNTL2_R_BASE_IDX                                                     2
#define mmCM0_CM_BLNDGAM_RAMB_OFFSET_B                                                                 0x0dbd
#define mmCM0_CM_BLNDGAM_RAMB_OFFSET_B_BASE_IDX                                                        2
#define mmCM0_CM_BLNDGAM_RAMB_OFFSET_G                                                                 0x0dbe
#define mmCM0_CM_BLNDGAM_RAMB_OFFSET_G_BASE_IDX                                                        2
#define mmCM0_CM_BLNDGAM_RAMB_OFFSET_R                                                                 0x0dbf
#define mmCM0_CM_BLNDGAM_RAMB_OFFSET_R_BASE_IDX                                                        2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_0_1                                                               0x0dc0
#define mmCM0_CM_BLNDGAM_RAMB_REGION_0_1_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_2_3                                                               0x0dc1
#define mmCM0_CM_BLNDGAM_RAMB_REGION_2_3_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_4_5                                                               0x0dc2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_4_5_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_6_7                                                               0x0dc3
#define mmCM0_CM_BLNDGAM_RAMB_REGION_6_7_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_8_9                                                               0x0dc4
#define mmCM0_CM_BLNDGAM_RAMB_REGION_8_9_BASE_IDX                                                      2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_10_11                                                             0x0dc5
#define mmCM0_CM_BLNDGAM_RAMB_REGION_10_11_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_12_13                                                             0x0dc6
#define mmCM0_CM_BLNDGAM_RAMB_REGION_12_13_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_14_15                                                             0x0dc7
#define mmCM0_CM_BLNDGAM_RAMB_REGION_14_15_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_16_17                                                             0x0dc8
#define mmCM0_CM_BLNDGAM_RAMB_REGION_16_17_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_18_19                                                             0x0dc9
#define mmCM0_CM_BLNDGAM_RAMB_REGION_18_19_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_20_21                                                             0x0dca
#define mmCM0_CM_BLNDGAM_RAMB_REGION_20_21_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_22_23                                                             0x0dcb
#define mmCM0_CM_BLNDGAM_RAMB_REGION_22_23_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_24_25                                                             0x0dcc
#define mmCM0_CM_BLNDGAM_RAMB_REGION_24_25_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_26_27                                                             0x0dcd
#define mmCM0_CM_BLNDGAM_RAMB_REGION_26_27_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_28_29                                                             0x0dce
#define mmCM0_CM_BLNDGAM_RAMB_REGION_28_29_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_30_31                                                             0x0dcf
#define mmCM0_CM_BLNDGAM_RAMB_REGION_30_31_BASE_IDX                                                    2
#define mmCM0_CM_BLNDGAM_RAMB_REGION_32_33                                                             0x0dd0
#define mmCM0_CM_BLNDGAM_RAMB_REGION_32_33_BASE_IDX                                                    2
#define mmCM0_CM_HDR_MULT_COEF                                                                         0x0dd1
#define mmCM0_CM_HDR_MULT_COEF_BASE_IDX                                                                2
#define mmCM0_CM_MEM_PWR_CTRL                                                                          0x0dd2
#define mmCM0_CM_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define mmCM0_CM_MEM_PWR_STATUS                                                                        0x0dd3
#define mmCM0_CM_MEM_PWR_STATUS_BASE_IDX                                                               2
#define mmCM0_CM_DEALPHA                                                                               0x0dd5
#define mmCM0_CM_DEALPHA_BASE_IDX                                                                      2
#define mmCM0_CM_COEF_FORMAT                                                                           0x0dd6
#define mmCM0_CM_COEF_FORMAT_BASE_IDX                                                                  2
#define mmCM0_CM_SHAPER_CONTROL                                                                        0x0dd7
#define mmCM0_CM_SHAPER_CONTROL_BASE_IDX                                                               2
#define mmCM0_CM_SHAPER_OFFSET_R                                                                       0x0dd8
#define mmCM0_CM_SHAPER_OFFSET_R_BASE_IDX                                                              2
#define mmCM0_CM_SHAPER_OFFSET_G                                                                       0x0dd9
#define mmCM0_CM_SHAPER_OFFSET_G_BASE_IDX                                                              2
#define mmCM0_CM_SHAPER_OFFSET_B                                                                       0x0dda
#define mmCM0_CM_SHAPER_OFFSET_B_BASE_IDX                                                              2
#define mmCM0_CM_SHAPER_SCALE_R                                                                        0x0ddb
#define mmCM0_CM_SHAPER_SCALE_R_BASE_IDX                                                               2
#define mmCM0_CM_SHAPER_SCALE_G_B                                                                      0x0ddc
#define mmCM0_CM_SHAPER_SCALE_G_B_BASE_IDX                                                             2
#define mmCM0_CM_SHAPER_LUT_INDEX                                                                      0x0ddd
#define mmCM0_CM_SHAPER_LUT_INDEX_BASE_IDX                                                             2
#define mmCM0_CM_SHAPER_LUT_DATA                                                                       0x0dde
#define mmCM0_CM_SHAPER_LUT_DATA_BASE_IDX                                                              2
#define mmCM0_CM_SHAPER_LUT_WRITE_EN_MASK                                                              0x0ddf
#define mmCM0_CM_SHAPER_LUT_WRITE_EN_MASK_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_START_CNTL_B                                                              0x0de0
#define mmCM0_CM_SHAPER_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_START_CNTL_G                                                              0x0de1
#define mmCM0_CM_SHAPER_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_START_CNTL_R                                                              0x0de2
#define mmCM0_CM_SHAPER_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_END_CNTL_B                                                                0x0de3
#define mmCM0_CM_SHAPER_RAMA_END_CNTL_B_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_END_CNTL_G                                                                0x0de4
#define mmCM0_CM_SHAPER_RAMA_END_CNTL_G_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_END_CNTL_R                                                                0x0de5
#define mmCM0_CM_SHAPER_RAMA_END_CNTL_R_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_REGION_0_1                                                                0x0de6
#define mmCM0_CM_SHAPER_RAMA_REGION_0_1_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_REGION_2_3                                                                0x0de7
#define mmCM0_CM_SHAPER_RAMA_REGION_2_3_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_REGION_4_5                                                                0x0de8
#define mmCM0_CM_SHAPER_RAMA_REGION_4_5_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_REGION_6_7                                                                0x0de9
#define mmCM0_CM_SHAPER_RAMA_REGION_6_7_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_REGION_8_9                                                                0x0dea
#define mmCM0_CM_SHAPER_RAMA_REGION_8_9_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMA_REGION_10_11                                                              0x0deb
#define mmCM0_CM_SHAPER_RAMA_REGION_10_11_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_12_13                                                              0x0dec
#define mmCM0_CM_SHAPER_RAMA_REGION_12_13_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_14_15                                                              0x0ded
#define mmCM0_CM_SHAPER_RAMA_REGION_14_15_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_16_17                                                              0x0dee
#define mmCM0_CM_SHAPER_RAMA_REGION_16_17_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_18_19                                                              0x0def
#define mmCM0_CM_SHAPER_RAMA_REGION_18_19_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_20_21                                                              0x0df0
#define mmCM0_CM_SHAPER_RAMA_REGION_20_21_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_22_23                                                              0x0df1
#define mmCM0_CM_SHAPER_RAMA_REGION_22_23_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_24_25                                                              0x0df2
#define mmCM0_CM_SHAPER_RAMA_REGION_24_25_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_26_27                                                              0x0df3
#define mmCM0_CM_SHAPER_RAMA_REGION_26_27_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_28_29                                                              0x0df4
#define mmCM0_CM_SHAPER_RAMA_REGION_28_29_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_30_31                                                              0x0df5
#define mmCM0_CM_SHAPER_RAMA_REGION_30_31_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMA_REGION_32_33                                                              0x0df6
#define mmCM0_CM_SHAPER_RAMA_REGION_32_33_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_START_CNTL_B                                                              0x0df7
#define mmCM0_CM_SHAPER_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_START_CNTL_G                                                              0x0df8
#define mmCM0_CM_SHAPER_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_START_CNTL_R                                                              0x0df9
#define mmCM0_CM_SHAPER_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_END_CNTL_B                                                                0x0dfa
#define mmCM0_CM_SHAPER_RAMB_END_CNTL_B_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_END_CNTL_G                                                                0x0dfb
#define mmCM0_CM_SHAPER_RAMB_END_CNTL_G_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_END_CNTL_R                                                                0x0dfc
#define mmCM0_CM_SHAPER_RAMB_END_CNTL_R_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_REGION_0_1                                                                0x0dfd
#define mmCM0_CM_SHAPER_RAMB_REGION_0_1_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_REGION_2_3                                                                0x0dfe
#define mmCM0_CM_SHAPER_RAMB_REGION_2_3_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_REGION_4_5                                                                0x0dff
#define mmCM0_CM_SHAPER_RAMB_REGION_4_5_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_REGION_6_7                                                                0x0e00
#define mmCM0_CM_SHAPER_RAMB_REGION_6_7_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_REGION_8_9                                                                0x0e01
#define mmCM0_CM_SHAPER_RAMB_REGION_8_9_BASE_IDX                                                       2
#define mmCM0_CM_SHAPER_RAMB_REGION_10_11                                                              0x0e02
#define mmCM0_CM_SHAPER_RAMB_REGION_10_11_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_12_13                                                              0x0e03
#define mmCM0_CM_SHAPER_RAMB_REGION_12_13_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_14_15                                                              0x0e04
#define mmCM0_CM_SHAPER_RAMB_REGION_14_15_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_16_17                                                              0x0e05
#define mmCM0_CM_SHAPER_RAMB_REGION_16_17_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_18_19                                                              0x0e06
#define mmCM0_CM_SHAPER_RAMB_REGION_18_19_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_20_21                                                              0x0e07
#define mmCM0_CM_SHAPER_RAMB_REGION_20_21_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_22_23                                                              0x0e08
#define mmCM0_CM_SHAPER_RAMB_REGION_22_23_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_24_25                                                              0x0e09
#define mmCM0_CM_SHAPER_RAMB_REGION_24_25_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_26_27                                                              0x0e0a
#define mmCM0_CM_SHAPER_RAMB_REGION_26_27_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_28_29                                                              0x0e0b
#define mmCM0_CM_SHAPER_RAMB_REGION_28_29_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_30_31                                                              0x0e0c
#define mmCM0_CM_SHAPER_RAMB_REGION_30_31_BASE_IDX                                                     2
#define mmCM0_CM_SHAPER_RAMB_REGION_32_33                                                              0x0e0d
#define mmCM0_CM_SHAPER_RAMB_REGION_32_33_BASE_IDX                                                     2
#define mmCM0_CM_MEM_PWR_CTRL2                                                                         0x0e0e
#define mmCM0_CM_MEM_PWR_CTRL2_BASE_IDX                                                                2
#define mmCM0_CM_MEM_PWR_STATUS2                                                                       0x0e0f
#define mmCM0_CM_MEM_PWR_STATUS2_BASE_IDX                                                              2
#define mmCM0_CM_3DLUT_MODE                                                                            0x0e10
#define mmCM0_CM_3DLUT_MODE_BASE_IDX                                                                   2
#define mmCM0_CM_3DLUT_INDEX                                                                           0x0e11
#define mmCM0_CM_3DLUT_INDEX_BASE_IDX                                                                  2
#define mmCM0_CM_3DLUT_DATA                                                                            0x0e12
#define mmCM0_CM_3DLUT_DATA_BASE_IDX                                                                   2
#define mmCM0_CM_3DLUT_DATA_30BIT                                                                      0x0e13
#define mmCM0_CM_3DLUT_DATA_30BIT_BASE_IDX                                                             2
#define mmCM0_CM_3DLUT_READ_WRITE_CONTROL                                                              0x0e14
#define mmCM0_CM_3DLUT_READ_WRITE_CONTROL_BASE_IDX                                                     2
#define mmCM0_CM_3DLUT_OUT_NORM_FACTOR                                                                 0x0e15
#define mmCM0_CM_3DLUT_OUT_NORM_FACTOR_BASE_IDX                                                        2
#define mmCM0_CM_3DLUT_OUT_OFFSET_R                                                                    0x0e16
#define mmCM0_CM_3DLUT_OUT_OFFSET_R_BASE_IDX                                                           2
#define mmCM0_CM_3DLUT_OUT_OFFSET_G                                                                    0x0e17
#define mmCM0_CM_3DLUT_OUT_OFFSET_G_BASE_IDX                                                           2
#define mmCM0_CM_3DLUT_OUT_OFFSET_B                                                                    0x0e18
#define mmCM0_CM_3DLUT_OUT_OFFSET_B_BASE_IDX                                                           2
#define mmCM0_CM_TEST_DEBUG_INDEX                                                                      0x0e19
#define mmCM0_CM_TEST_DEBUG_INDEX_BASE_IDX                                                             2
#define mmCM0_CM_TEST_DEBUG_DATA                                                                       0x0e1a
#define mmCM0_CM_TEST_DEBUG_DATA_BASE_IDX                                                              2


// addressBlock: dce_dc_dpp0_dispdec_dpp_dcperfmon_dc_perfmon_dispdec
// base address: 0x3890
#define mmDC_PERFMON11_PERFCOUNTER_CNTL                                                                0x0e24
#define mmDC_PERFMON11_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON11_PERFCOUNTER_CNTL2                                                               0x0e25
#define mmDC_PERFMON11_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON11_PERFCOUNTER_STATE                                                               0x0e26
#define mmDC_PERFMON11_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON11_PERFMON_CNTL                                                                    0x0e27
#define mmDC_PERFMON11_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON11_PERFMON_CNTL2                                                                   0x0e28
#define mmDC_PERFMON11_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON11_PERFMON_CVALUE_INT_MISC                                                         0x0e29
#define mmDC_PERFMON11_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON11_PERFMON_CVALUE_LOW                                                              0x0e2a
#define mmDC_PERFMON11_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON11_PERFMON_HI                                                                      0x0e2b
#define mmDC_PERFMON11_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON11_PERFMON_LOW                                                                     0x0e2c
#define mmDC_PERFMON11_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dpp1_dispdec_dpp_top_dispdec
// base address: 0x5ac
#define mmDPP_TOP1_DPP_CONTROL                                                                         0x0e30
#define mmDPP_TOP1_DPP_CONTROL_BASE_IDX                                                                2
#define mmDPP_TOP1_DPP_SOFT_RESET                                                                      0x0e31
#define mmDPP_TOP1_DPP_SOFT_RESET_BASE_IDX                                                             2
#define mmDPP_TOP1_DPP_CRC_VAL_R_G                                                                     0x0e32
#define mmDPP_TOP1_DPP_CRC_VAL_R_G_BASE_IDX                                                            2
#define mmDPP_TOP1_DPP_CRC_VAL_B_A                                                                     0x0e33
#define mmDPP_TOP1_DPP_CRC_VAL_B_A_BASE_IDX                                                            2
#define mmDPP_TOP1_DPP_CRC_CTRL                                                                        0x0e34
#define mmDPP_TOP1_DPP_CRC_CTRL_BASE_IDX                                                               2
#define mmDPP_TOP1_HOST_READ_CONTROL                                                                   0x0e35
#define mmDPP_TOP1_HOST_READ_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_dpp1_dispdec_cnvc_cfg_dispdec
// base address: 0x5ac
#define mmCNVC_CFG1_CNVC_SURFACE_PIXEL_FORMAT                                                          0x0e3a
#define mmCNVC_CFG1_CNVC_SURFACE_PIXEL_FORMAT_BASE_IDX                                                 2
#define mmCNVC_CFG1_FORMAT_CONTROL                                                                     0x0e3b
#define mmCNVC_CFG1_FORMAT_CONTROL_BASE_IDX                                                            2
#define mmCNVC_CFG1_FCNV_FP_BIAS_R                                                                     0x0e3c
#define mmCNVC_CFG1_FCNV_FP_BIAS_R_BASE_IDX                                                            2
#define mmCNVC_CFG1_FCNV_FP_BIAS_G                                                                     0x0e3d
#define mmCNVC_CFG1_FCNV_FP_BIAS_G_BASE_IDX                                                            2
#define mmCNVC_CFG1_FCNV_FP_BIAS_B                                                                     0x0e3e
#define mmCNVC_CFG1_FCNV_FP_BIAS_B_BASE_IDX                                                            2
#define mmCNVC_CFG1_FCNV_FP_SCALE_R                                                                    0x0e3f
#define mmCNVC_CFG1_FCNV_FP_SCALE_R_BASE_IDX                                                           2
#define mmCNVC_CFG1_FCNV_FP_SCALE_G                                                                    0x0e40
#define mmCNVC_CFG1_FCNV_FP_SCALE_G_BASE_IDX                                                           2
#define mmCNVC_CFG1_FCNV_FP_SCALE_B                                                                    0x0e41
#define mmCNVC_CFG1_FCNV_FP_SCALE_B_BASE_IDX                                                           2
#define mmCNVC_CFG1_COLOR_KEYER_CONTROL                                                                0x0e42
#define mmCNVC_CFG1_COLOR_KEYER_CONTROL_BASE_IDX                                                       2
#define mmCNVC_CFG1_COLOR_KEYER_ALPHA                                                                  0x0e43
#define mmCNVC_CFG1_COLOR_KEYER_ALPHA_BASE_IDX                                                         2
#define mmCNVC_CFG1_COLOR_KEYER_RED                                                                    0x0e44
#define mmCNVC_CFG1_COLOR_KEYER_RED_BASE_IDX                                                           2
#define mmCNVC_CFG1_COLOR_KEYER_GREEN                                                                  0x0e45
#define mmCNVC_CFG1_COLOR_KEYER_GREEN_BASE_IDX                                                         2
#define mmCNVC_CFG1_COLOR_KEYER_BLUE                                                                   0x0e46
#define mmCNVC_CFG1_COLOR_KEYER_BLUE_BASE_IDX                                                          2
#define mmCNVC_CFG1_ALPHA_2BIT_LUT                                                                     0x0e48
#define mmCNVC_CFG1_ALPHA_2BIT_LUT_BASE_IDX                                                            2
#define mmCNVC_CFG1_PRE_DEALPHA                                                                        0x0e49
#define mmCNVC_CFG1_PRE_DEALPHA_BASE_IDX                                                               2
#define mmCNVC_CFG1_PRE_CSC_MODE                                                                       0x0e4a
#define mmCNVC_CFG1_PRE_CSC_MODE_BASE_IDX                                                              2
#define mmCNVC_CFG1_PRE_CSC_C11_C12                                                                    0x0e4b
#define mmCNVC_CFG1_PRE_CSC_C11_C12_BASE_IDX                                                           2
#define mmCNVC_CFG1_PRE_CSC_C13_C14                                                                    0x0e4c
#define mmCNVC_CFG1_PRE_CSC_C13_C14_BASE_IDX                                                           2
#define mmCNVC_CFG1_PRE_CSC_C21_C22                                                                    0x0e4d
#define mmCNVC_CFG1_PRE_CSC_C21_C22_BASE_IDX                                                           2
#define mmCNVC_CFG1_PRE_CSC_C23_C24                                                                    0x0e4e
#define mmCNVC_CFG1_PRE_CSC_C23_C24_BASE_IDX                                                           2
#define mmCNVC_CFG1_PRE_CSC_C31_C32                                                                    0x0e4f
#define mmCNVC_CFG1_PRE_CSC_C31_C32_BASE_IDX                                                           2
#define mmCNVC_CFG1_PRE_CSC_C33_C34                                                                    0x0e50
#define mmCNVC_CFG1_PRE_CSC_C33_C34_BASE_IDX                                                           2
#define mmCNVC_CFG1_PRE_CSC_B_C11_C12                                                                  0x0e51
#define mmCNVC_CFG1_PRE_CSC_B_C11_C12_BASE_IDX                                                         2
#define mmCNVC_CFG1_PRE_CSC_B_C13_C14                                                                  0x0e52
#define mmCNVC_CFG1_PRE_CSC_B_C13_C14_BASE_IDX                                                         2
#define mmCNVC_CFG1_PRE_CSC_B_C21_C22                                                                  0x0e53
#define mmCNVC_CFG1_PRE_CSC_B_C21_C22_BASE_IDX                                                         2
#define mmCNVC_CFG1_PRE_CSC_B_C23_C24                                                                  0x0e54
#define mmCNVC_CFG1_PRE_CSC_B_C23_C24_BASE_IDX                                                         2
#define mmCNVC_CFG1_PRE_CSC_B_C31_C32                                                                  0x0e55
#define mmCNVC_CFG1_PRE_CSC_B_C31_C32_BASE_IDX                                                         2
#define mmCNVC_CFG1_PRE_CSC_B_C33_C34                                                                  0x0e56
#define mmCNVC_CFG1_PRE_CSC_B_C33_C34_BASE_IDX                                                         2
#define mmCNVC_CFG1_CNVC_COEF_FORMAT                                                                   0x0e57
#define mmCNVC_CFG1_CNVC_COEF_FORMAT_BASE_IDX                                                          2
#define mmCNVC_CFG1_PRE_DEGAM                                                                          0x0e58
#define mmCNVC_CFG1_PRE_DEGAM_BASE_IDX                                                                 2
#define mmCNVC_CFG1_PRE_REALPHA                                                                        0x0e59
#define mmCNVC_CFG1_PRE_REALPHA_BASE_IDX                                                               2


// addressBlock: dce_dc_dpp1_dispdec_cnvc_cur_dispdec
// base address: 0x5ac
#define mmCNVC_CUR1_CURSOR0_CONTROL                                                                    0x0e5c
#define mmCNVC_CUR1_CURSOR0_CONTROL_BASE_IDX                                                           2
#define mmCNVC_CUR1_CURSOR0_COLOR0                                                                     0x0e5d
#define mmCNVC_CUR1_CURSOR0_COLOR0_BASE_IDX                                                            2
#define mmCNVC_CUR1_CURSOR0_COLOR1                                                                     0x0e5e
#define mmCNVC_CUR1_CURSOR0_COLOR1_BASE_IDX                                                            2
#define mmCNVC_CUR1_CURSOR0_FP_SCALE_BIAS                                                              0x0e5f
#define mmCNVC_CUR1_CURSOR0_FP_SCALE_BIAS_BASE_IDX                                                     2


// addressBlock: dce_dc_dpp1_dispdec_dscl_dispdec
// base address: 0x5ac
#define mmDSCL1_SCL_COEF_RAM_TAP_SELECT                                                                0x0e64
#define mmDSCL1_SCL_COEF_RAM_TAP_SELECT_BASE_IDX                                                       2
#define mmDSCL1_SCL_COEF_RAM_TAP_DATA                                                                  0x0e65
#define mmDSCL1_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                         2
#define mmDSCL1_SCL_MODE                                                                               0x0e66
#define mmDSCL1_SCL_MODE_BASE_IDX                                                                      2
#define mmDSCL1_SCL_TAP_CONTROL                                                                        0x0e67
#define mmDSCL1_SCL_TAP_CONTROL_BASE_IDX                                                               2
#define mmDSCL1_DSCL_CONTROL                                                                           0x0e68
#define mmDSCL1_DSCL_CONTROL_BASE_IDX                                                                  2
#define mmDSCL1_DSCL_2TAP_CONTROL                                                                      0x0e69
#define mmDSCL1_DSCL_2TAP_CONTROL_BASE_IDX                                                             2
#define mmDSCL1_SCL_MANUAL_REPLICATE_CONTROL                                                           0x0e6a
#define mmDSCL1_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                  2
#define mmDSCL1_SCL_HORZ_FILTER_SCALE_RATIO                                                            0x0e6b
#define mmDSCL1_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define mmDSCL1_SCL_HORZ_FILTER_INIT                                                                   0x0e6c
#define mmDSCL1_SCL_HORZ_FILTER_INIT_BASE_IDX                                                          2
#define mmDSCL1_SCL_HORZ_FILTER_SCALE_RATIO_C                                                          0x0e6d
#define mmDSCL1_SCL_HORZ_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define mmDSCL1_SCL_HORZ_FILTER_INIT_C                                                                 0x0e6e
#define mmDSCL1_SCL_HORZ_FILTER_INIT_C_BASE_IDX                                                        2
#define mmDSCL1_SCL_VERT_FILTER_SCALE_RATIO                                                            0x0e6f
#define mmDSCL1_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define mmDSCL1_SCL_VERT_FILTER_INIT                                                                   0x0e70
#define mmDSCL1_SCL_VERT_FILTER_INIT_BASE_IDX                                                          2
#define mmDSCL1_SCL_VERT_FILTER_INIT_BOT                                                               0x0e71
#define mmDSCL1_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                      2
#define mmDSCL1_SCL_VERT_FILTER_SCALE_RATIO_C                                                          0x0e72
#define mmDSCL1_SCL_VERT_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define mmDSCL1_SCL_VERT_FILTER_INIT_C                                                                 0x0e73
#define mmDSCL1_SCL_VERT_FILTER_INIT_C_BASE_IDX                                                        2
#define mmDSCL1_SCL_VERT_FILTER_INIT_BOT_C                                                             0x0e74
#define mmDSCL1_SCL_VERT_FILTER_INIT_BOT_C_BASE_IDX                                                    2
#define mmDSCL1_SCL_BLACK_COLOR                                                                        0x0e75
#define mmDSCL1_SCL_BLACK_COLOR_BASE_IDX                                                               2
#define mmDSCL1_DSCL_UPDATE                                                                            0x0e76
#define mmDSCL1_DSCL_UPDATE_BASE_IDX                                                                   2
#define mmDSCL1_DSCL_AUTOCAL                                                                           0x0e77
#define mmDSCL1_DSCL_AUTOCAL_BASE_IDX                                                                  2
#define mmDSCL1_DSCL_EXT_OVERSCAN_LEFT_RIGHT                                                           0x0e78
#define mmDSCL1_DSCL_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                  2
#define mmDSCL1_DSCL_EXT_OVERSCAN_TOP_BOTTOM                                                           0x0e79
#define mmDSCL1_DSCL_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                  2
#define mmDSCL1_OTG_H_BLANK                                                                            0x0e7a
#define mmDSCL1_OTG_H_BLANK_BASE_IDX                                                                   2
#define mmDSCL1_OTG_V_BLANK                                                                            0x0e7b
#define mmDSCL1_OTG_V_BLANK_BASE_IDX                                                                   2
#define mmDSCL1_RECOUT_START                                                                           0x0e7c
#define mmDSCL1_RECOUT_START_BASE_IDX                                                                  2
#define mmDSCL1_RECOUT_SIZE                                                                            0x0e7d
#define mmDSCL1_RECOUT_SIZE_BASE_IDX                                                                   2
#define mmDSCL1_MPC_SIZE                                                                               0x0e7e
#define mmDSCL1_MPC_SIZE_BASE_IDX                                                                      2
#define mmDSCL1_LB_DATA_FORMAT                                                                         0x0e7f
#define mmDSCL1_LB_DATA_FORMAT_BASE_IDX                                                                2
#define mmDSCL1_LB_MEMORY_CTRL                                                                         0x0e80
#define mmDSCL1_LB_MEMORY_CTRL_BASE_IDX                                                                2
#define mmDSCL1_LB_V_COUNTER                                                                           0x0e81
#define mmDSCL1_LB_V_COUNTER_BASE_IDX                                                                  2
#define mmDSCL1_DSCL_MEM_PWR_CTRL                                                                      0x0e82
#define mmDSCL1_DSCL_MEM_PWR_CTRL_BASE_IDX                                                             2
#define mmDSCL1_DSCL_MEM_PWR_STATUS                                                                    0x0e83
#define mmDSCL1_DSCL_MEM_PWR_STATUS_BASE_IDX                                                           2
#define mmDSCL1_OBUF_CONTROL                                                                           0x0e84
#define mmDSCL1_OBUF_CONTROL_BASE_IDX                                                                  2
#define mmDSCL1_OBUF_MEM_PWR_CTRL                                                                      0x0e85
#define mmDSCL1_OBUF_MEM_PWR_CTRL_BASE_IDX                                                             2


// addressBlock: dce_dc_dpp1_dispdec_cm_dispdec
// base address: 0x5ac
#define mmCM1_CM_CONTROL                                                                               0x0e8b
#define mmCM1_CM_CONTROL_BASE_IDX                                                                      2
#define mmCM1_CM_POST_CSC_CONTROL                                                                      0x0e8c
#define mmCM1_CM_POST_CSC_CONTROL_BASE_IDX                                                             2
#define mmCM1_CM_POST_CSC_C11_C12                                                                      0x0e8d
#define mmCM1_CM_POST_CSC_C11_C12_BASE_IDX                                                             2
#define mmCM1_CM_POST_CSC_C13_C14                                                                      0x0e8e
#define mmCM1_CM_POST_CSC_C13_C14_BASE_IDX                                                             2
#define mmCM1_CM_POST_CSC_C21_C22                                                                      0x0e8f
#define mmCM1_CM_POST_CSC_C21_C22_BASE_IDX                                                             2
#define mmCM1_CM_POST_CSC_C23_C24                                                                      0x0e90
#define mmCM1_CM_POST_CSC_C23_C24_BASE_IDX                                                             2
#define mmCM1_CM_POST_CSC_C31_C32                                                                      0x0e91
#define mmCM1_CM_POST_CSC_C31_C32_BASE_IDX                                                             2
#define mmCM1_CM_POST_CSC_C33_C34                                                                      0x0e92
#define mmCM1_CM_POST_CSC_C33_C34_BASE_IDX                                                             2
#define mmCM1_CM_POST_CSC_B_C11_C12                                                                    0x0e93
#define mmCM1_CM_POST_CSC_B_C11_C12_BASE_IDX                                                           2
#define mmCM1_CM_POST_CSC_B_C13_C14                                                                    0x0e94
#define mmCM1_CM_POST_CSC_B_C13_C14_BASE_IDX                                                           2
#define mmCM1_CM_POST_CSC_B_C21_C22                                                                    0x0e95
#define mmCM1_CM_POST_CSC_B_C21_C22_BASE_IDX                                                           2
#define mmCM1_CM_POST_CSC_B_C23_C24                                                                    0x0e96
#define mmCM1_CM_POST_CSC_B_C23_C24_BASE_IDX                                                           2
#define mmCM1_CM_POST_CSC_B_C31_C32                                                                    0x0e97
#define mmCM1_CM_POST_CSC_B_C31_C32_BASE_IDX                                                           2
#define mmCM1_CM_POST_CSC_B_C33_C34                                                                    0x0e98
#define mmCM1_CM_POST_CSC_B_C33_C34_BASE_IDX                                                           2
#define mmCM1_CM_GAMUT_REMAP_CONTROL                                                                   0x0e99
#define mmCM1_CM_GAMUT_REMAP_CONTROL_BASE_IDX                                                          2
#define mmCM1_CM_GAMUT_REMAP_C11_C12                                                                   0x0e9a
#define mmCM1_CM_GAMUT_REMAP_C11_C12_BASE_IDX                                                          2
#define mmCM1_CM_GAMUT_REMAP_C13_C14                                                                   0x0e9b
#define mmCM1_CM_GAMUT_REMAP_C13_C14_BASE_IDX                                                          2
#define mmCM1_CM_GAMUT_REMAP_C21_C22                                                                   0x0e9c
#define mmCM1_CM_GAMUT_REMAP_C21_C22_BASE_IDX                                                          2
#define mmCM1_CM_GAMUT_REMAP_C23_C24                                                                   0x0e9d
#define mmCM1_CM_GAMUT_REMAP_C23_C24_BASE_IDX                                                          2
#define mmCM1_CM_GAMUT_REMAP_C31_C32                                                                   0x0e9e
#define mmCM1_CM_GAMUT_REMAP_C31_C32_BASE_IDX                                                          2
#define mmCM1_CM_GAMUT_REMAP_C33_C34                                                                   0x0e9f
#define mmCM1_CM_GAMUT_REMAP_C33_C34_BASE_IDX                                                          2
#define mmCM1_CM_GAMUT_REMAP_B_C11_C12                                                                 0x0ea0
#define mmCM1_CM_GAMUT_REMAP_B_C11_C12_BASE_IDX                                                        2
#define mmCM1_CM_GAMUT_REMAP_B_C13_C14                                                                 0x0ea1
#define mmCM1_CM_GAMUT_REMAP_B_C13_C14_BASE_IDX                                                        2
#define mmCM1_CM_GAMUT_REMAP_B_C21_C22                                                                 0x0ea2
#define mmCM1_CM_GAMUT_REMAP_B_C21_C22_BASE_IDX                                                        2
#define mmCM1_CM_GAMUT_REMAP_B_C23_C24                                                                 0x0ea3
#define mmCM1_CM_GAMUT_REMAP_B_C23_C24_BASE_IDX                                                        2
#define mmCM1_CM_GAMUT_REMAP_B_C31_C32                                                                 0x0ea4
#define mmCM1_CM_GAMUT_REMAP_B_C31_C32_BASE_IDX                                                        2
#define mmCM1_CM_GAMUT_REMAP_B_C33_C34                                                                 0x0ea5
#define mmCM1_CM_GAMUT_REMAP_B_C33_C34_BASE_IDX                                                        2
#define mmCM1_CM_BIAS_CR_R                                                                             0x0ea6
#define mmCM1_CM_BIAS_CR_R_BASE_IDX                                                                    2
#define mmCM1_CM_BIAS_Y_G_CB_B                                                                         0x0ea7
#define mmCM1_CM_BIAS_Y_G_CB_B_BASE_IDX                                                                2
#define mmCM1_CM_GAMCOR_CONTROL                                                                        0x0ea8
#define mmCM1_CM_GAMCOR_CONTROL_BASE_IDX                                                               2
#define mmCM1_CM_GAMCOR_LUT_INDEX                                                                      0x0ea9
#define mmCM1_CM_GAMCOR_LUT_INDEX_BASE_IDX                                                             2
#define mmCM1_CM_GAMCOR_LUT_DATA                                                                       0x0eaa
#define mmCM1_CM_GAMCOR_LUT_DATA_BASE_IDX                                                              2
#define mmCM1_CM_GAMCOR_LUT_CONTROL                                                                    0x0eab
#define mmCM1_CM_GAMCOR_LUT_CONTROL_BASE_IDX                                                           2
#define mmCM1_CM_GAMCOR_RAMA_START_CNTL_B                                                              0x0eac
#define mmCM1_CM_GAMCOR_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_START_CNTL_G                                                              0x0ead
#define mmCM1_CM_GAMCOR_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_START_CNTL_R                                                              0x0eae
#define mmCM1_CM_GAMCOR_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B                                                        0x0eaf
#define mmCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define mmCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G                                                        0x0eb0
#define mmCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define mmCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R                                                        0x0eb1
#define mmCM1_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define mmCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_B                                                         0x0eb2
#define mmCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_B_BASE_IDX                                                2
#define mmCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_G                                                         0x0eb3
#define mmCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_G_BASE_IDX                                                2
#define mmCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_R                                                         0x0eb4
#define mmCM1_CM_GAMCOR_RAMA_START_BASE_CNTL_R_BASE_IDX                                                2
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL1_B                                                               0x0eb5
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL1_B_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL2_B                                                               0x0eb6
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL2_B_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL1_G                                                               0x0eb7
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL1_G_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL2_G                                                               0x0eb8
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL2_G_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL1_R                                                               0x0eb9
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL1_R_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL2_R                                                               0x0eba
#define mmCM1_CM_GAMCOR_RAMA_END_CNTL2_R_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMA_OFFSET_B                                                                  0x0ebb
#define mmCM1_CM_GAMCOR_RAMA_OFFSET_B_BASE_IDX                                                         2
#define mmCM1_CM_GAMCOR_RAMA_OFFSET_G                                                                  0x0ebc
#define mmCM1_CM_GAMCOR_RAMA_OFFSET_G_BASE_IDX                                                         2
#define mmCM1_CM_GAMCOR_RAMA_OFFSET_R                                                                  0x0ebd
#define mmCM1_CM_GAMCOR_RAMA_OFFSET_R_BASE_IDX                                                         2
#define mmCM1_CM_GAMCOR_RAMA_REGION_0_1                                                                0x0ebe
#define mmCM1_CM_GAMCOR_RAMA_REGION_0_1_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMA_REGION_2_3                                                                0x0ebf
#define mmCM1_CM_GAMCOR_RAMA_REGION_2_3_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMA_REGION_4_5                                                                0x0ec0
#define mmCM1_CM_GAMCOR_RAMA_REGION_4_5_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMA_REGION_6_7                                                                0x0ec1
#define mmCM1_CM_GAMCOR_RAMA_REGION_6_7_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMA_REGION_8_9                                                                0x0ec2
#define mmCM1_CM_GAMCOR_RAMA_REGION_8_9_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMA_REGION_10_11                                                              0x0ec3
#define mmCM1_CM_GAMCOR_RAMA_REGION_10_11_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_12_13                                                              0x0ec4
#define mmCM1_CM_GAMCOR_RAMA_REGION_12_13_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_14_15                                                              0x0ec5
#define mmCM1_CM_GAMCOR_RAMA_REGION_14_15_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_16_17                                                              0x0ec6
#define mmCM1_CM_GAMCOR_RAMA_REGION_16_17_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_18_19                                                              0x0ec7
#define mmCM1_CM_GAMCOR_RAMA_REGION_18_19_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_20_21                                                              0x0ec8
#define mmCM1_CM_GAMCOR_RAMA_REGION_20_21_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_22_23                                                              0x0ec9
#define mmCM1_CM_GAMCOR_RAMA_REGION_22_23_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_24_25                                                              0x0eca
#define mmCM1_CM_GAMCOR_RAMA_REGION_24_25_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_26_27                                                              0x0ecb
#define mmCM1_CM_GAMCOR_RAMA_REGION_26_27_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_28_29                                                              0x0ecc
#define mmCM1_CM_GAMCOR_RAMA_REGION_28_29_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_30_31                                                              0x0ecd
#define mmCM1_CM_GAMCOR_RAMA_REGION_30_31_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMA_REGION_32_33                                                              0x0ece
#define mmCM1_CM_GAMCOR_RAMA_REGION_32_33_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_START_CNTL_B                                                              0x0ecf
#define mmCM1_CM_GAMCOR_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_START_CNTL_G                                                              0x0ed0
#define mmCM1_CM_GAMCOR_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_START_CNTL_R                                                              0x0ed1
#define mmCM1_CM_GAMCOR_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B                                                        0x0ed2
#define mmCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define mmCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G                                                        0x0ed3
#define mmCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define mmCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R                                                        0x0ed4
#define mmCM1_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define mmCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_B                                                         0x0ed5
#define mmCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_B_BASE_IDX                                                2
#define mmCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_G                                                         0x0ed6
#define mmCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_G_BASE_IDX                                                2
#define mmCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_R                                                         0x0ed7
#define mmCM1_CM_GAMCOR_RAMB_START_BASE_CNTL_R_BASE_IDX                                                2
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL1_B                                                               0x0ed8
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL1_B_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL2_B                                                               0x0ed9
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL2_B_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL1_G                                                               0x0eda
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL1_G_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL2_G                                                               0x0edb
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL2_G_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL1_R                                                               0x0edc
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL1_R_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL2_R                                                               0x0edd
#define mmCM1_CM_GAMCOR_RAMB_END_CNTL2_R_BASE_IDX                                                      2
#define mmCM1_CM_GAMCOR_RAMB_OFFSET_B                                                                  0x0ede
#define mmCM1_CM_GAMCOR_RAMB_OFFSET_B_BASE_IDX                                                         2
#define mmCM1_CM_GAMCOR_RAMB_OFFSET_G                                                                  0x0edf
#define mmCM1_CM_GAMCOR_RAMB_OFFSET_G_BASE_IDX                                                         2
#define mmCM1_CM_GAMCOR_RAMB_OFFSET_R                                                                  0x0ee0
#define mmCM1_CM_GAMCOR_RAMB_OFFSET_R_BASE_IDX                                                         2
#define mmCM1_CM_GAMCOR_RAMB_REGION_0_1                                                                0x0ee1
#define mmCM1_CM_GAMCOR_RAMB_REGION_0_1_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMB_REGION_2_3                                                                0x0ee2
#define mmCM1_CM_GAMCOR_RAMB_REGION_2_3_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMB_REGION_4_5                                                                0x0ee3
#define mmCM1_CM_GAMCOR_RAMB_REGION_4_5_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMB_REGION_6_7                                                                0x0ee4
#define mmCM1_CM_GAMCOR_RAMB_REGION_6_7_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMB_REGION_8_9                                                                0x0ee5
#define mmCM1_CM_GAMCOR_RAMB_REGION_8_9_BASE_IDX                                                       2
#define mmCM1_CM_GAMCOR_RAMB_REGION_10_11                                                              0x0ee6
#define mmCM1_CM_GAMCOR_RAMB_REGION_10_11_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_12_13                                                              0x0ee7
#define mmCM1_CM_GAMCOR_RAMB_REGION_12_13_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_14_15                                                              0x0ee8
#define mmCM1_CM_GAMCOR_RAMB_REGION_14_15_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_16_17                                                              0x0ee9
#define mmCM1_CM_GAMCOR_RAMB_REGION_16_17_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_18_19                                                              0x0eea
#define mmCM1_CM_GAMCOR_RAMB_REGION_18_19_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_20_21                                                              0x0eeb
#define mmCM1_CM_GAMCOR_RAMB_REGION_20_21_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_22_23                                                              0x0eec
#define mmCM1_CM_GAMCOR_RAMB_REGION_22_23_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_24_25                                                              0x0eed
#define mmCM1_CM_GAMCOR_RAMB_REGION_24_25_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_26_27                                                              0x0eee
#define mmCM1_CM_GAMCOR_RAMB_REGION_26_27_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_28_29                                                              0x0eef
#define mmCM1_CM_GAMCOR_RAMB_REGION_28_29_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_30_31                                                              0x0ef0
#define mmCM1_CM_GAMCOR_RAMB_REGION_30_31_BASE_IDX                                                     2
#define mmCM1_CM_GAMCOR_RAMB_REGION_32_33                                                              0x0ef1
#define mmCM1_CM_GAMCOR_RAMB_REGION_32_33_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_CONTROL                                                                       0x0ef2
#define mmCM1_CM_BLNDGAM_CONTROL_BASE_IDX                                                              2
#define mmCM1_CM_BLNDGAM_LUT_INDEX                                                                     0x0ef3
#define mmCM1_CM_BLNDGAM_LUT_INDEX_BASE_IDX                                                            2
#define mmCM1_CM_BLNDGAM_LUT_DATA                                                                      0x0ef4
#define mmCM1_CM_BLNDGAM_LUT_DATA_BASE_IDX                                                             2
#define mmCM1_CM_BLNDGAM_LUT_CONTROL                                                                   0x0ef5
#define mmCM1_CM_BLNDGAM_LUT_CONTROL_BASE_IDX                                                          2
#define mmCM1_CM_BLNDGAM_RAMA_START_CNTL_B                                                             0x0ef6
#define mmCM1_CM_BLNDGAM_RAMA_START_CNTL_B_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_START_CNTL_G                                                             0x0ef7
#define mmCM1_CM_BLNDGAM_RAMA_START_CNTL_G_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_START_CNTL_R                                                             0x0ef8
#define mmCM1_CM_BLNDGAM_RAMA_START_CNTL_R_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_B                                                       0x0ef9
#define mmCM1_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                              2
#define mmCM1_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_G                                                       0x0efa
#define mmCM1_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                              2
#define mmCM1_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_R                                                       0x0efb
#define mmCM1_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                              2
#define mmCM1_CM_BLNDGAM_RAMA_START_BASE_CNTL_B                                                        0x0efc
#define mmCM1_CM_BLNDGAM_RAMA_START_BASE_CNTL_B_BASE_IDX                                               2
#define mmCM1_CM_BLNDGAM_RAMA_START_BASE_CNTL_G                                                        0x0efd
#define mmCM1_CM_BLNDGAM_RAMA_START_BASE_CNTL_G_BASE_IDX                                               2
#define mmCM1_CM_BLNDGAM_RAMA_START_BASE_CNTL_R                                                        0x0efe
#define mmCM1_CM_BLNDGAM_RAMA_START_BASE_CNTL_R_BASE_IDX                                               2
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL1_B                                                              0x0eff
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL1_B_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL2_B                                                              0x0f00
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL2_B_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL1_G                                                              0x0f01
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL1_G_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL2_G                                                              0x0f02
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL2_G_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL1_R                                                              0x0f03
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL1_R_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL2_R                                                              0x0f04
#define mmCM1_CM_BLNDGAM_RAMA_END_CNTL2_R_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMA_OFFSET_B                                                                 0x0f05
#define mmCM1_CM_BLNDGAM_RAMA_OFFSET_B_BASE_IDX                                                        2
#define mmCM1_CM_BLNDGAM_RAMA_OFFSET_G                                                                 0x0f06
#define mmCM1_CM_BLNDGAM_RAMA_OFFSET_G_BASE_IDX                                                        2
#define mmCM1_CM_BLNDGAM_RAMA_OFFSET_R                                                                 0x0f07
#define mmCM1_CM_BLNDGAM_RAMA_OFFSET_R_BASE_IDX                                                        2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_0_1                                                               0x0f08
#define mmCM1_CM_BLNDGAM_RAMA_REGION_0_1_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_2_3                                                               0x0f09
#define mmCM1_CM_BLNDGAM_RAMA_REGION_2_3_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_4_5                                                               0x0f0a
#define mmCM1_CM_BLNDGAM_RAMA_REGION_4_5_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_6_7                                                               0x0f0b
#define mmCM1_CM_BLNDGAM_RAMA_REGION_6_7_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_8_9                                                               0x0f0c
#define mmCM1_CM_BLNDGAM_RAMA_REGION_8_9_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_10_11                                                             0x0f0d
#define mmCM1_CM_BLNDGAM_RAMA_REGION_10_11_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_12_13                                                             0x0f0e
#define mmCM1_CM_BLNDGAM_RAMA_REGION_12_13_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_14_15                                                             0x0f0f
#define mmCM1_CM_BLNDGAM_RAMA_REGION_14_15_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_16_17                                                             0x0f10
#define mmCM1_CM_BLNDGAM_RAMA_REGION_16_17_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_18_19                                                             0x0f11
#define mmCM1_CM_BLNDGAM_RAMA_REGION_18_19_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_20_21                                                             0x0f12
#define mmCM1_CM_BLNDGAM_RAMA_REGION_20_21_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_22_23                                                             0x0f13
#define mmCM1_CM_BLNDGAM_RAMA_REGION_22_23_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_24_25                                                             0x0f14
#define mmCM1_CM_BLNDGAM_RAMA_REGION_24_25_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_26_27                                                             0x0f15
#define mmCM1_CM_BLNDGAM_RAMA_REGION_26_27_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_28_29                                                             0x0f16
#define mmCM1_CM_BLNDGAM_RAMA_REGION_28_29_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_30_31                                                             0x0f17
#define mmCM1_CM_BLNDGAM_RAMA_REGION_30_31_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMA_REGION_32_33                                                             0x0f18
#define mmCM1_CM_BLNDGAM_RAMA_REGION_32_33_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_START_CNTL_B                                                             0x0f19
#define mmCM1_CM_BLNDGAM_RAMB_START_CNTL_B_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_START_CNTL_G                                                             0x0f1a
#define mmCM1_CM_BLNDGAM_RAMB_START_CNTL_G_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_START_CNTL_R                                                             0x0f1b
#define mmCM1_CM_BLNDGAM_RAMB_START_CNTL_R_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_B                                                       0x0f1c
#define mmCM1_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                              2
#define mmCM1_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_G                                                       0x0f1d
#define mmCM1_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                              2
#define mmCM1_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_R                                                       0x0f1e
#define mmCM1_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                              2
#define mmCM1_CM_BLNDGAM_RAMB_START_BASE_CNTL_B                                                        0x0f1f
#define mmCM1_CM_BLNDGAM_RAMB_START_BASE_CNTL_B_BASE_IDX                                               2
#define mmCM1_CM_BLNDGAM_RAMB_START_BASE_CNTL_G                                                        0x0f20
#define mmCM1_CM_BLNDGAM_RAMB_START_BASE_CNTL_G_BASE_IDX                                               2
#define mmCM1_CM_BLNDGAM_RAMB_START_BASE_CNTL_R                                                        0x0f21
#define mmCM1_CM_BLNDGAM_RAMB_START_BASE_CNTL_R_BASE_IDX                                               2
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL1_B                                                              0x0f22
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL1_B_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL2_B                                                              0x0f23
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL2_B_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL1_G                                                              0x0f24
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL1_G_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL2_G                                                              0x0f25
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL2_G_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL1_R                                                              0x0f26
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL1_R_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL2_R                                                              0x0f27
#define mmCM1_CM_BLNDGAM_RAMB_END_CNTL2_R_BASE_IDX                                                     2
#define mmCM1_CM_BLNDGAM_RAMB_OFFSET_B                                                                 0x0f28
#define mmCM1_CM_BLNDGAM_RAMB_OFFSET_B_BASE_IDX                                                        2
#define mmCM1_CM_BLNDGAM_RAMB_OFFSET_G                                                                 0x0f29
#define mmCM1_CM_BLNDGAM_RAMB_OFFSET_G_BASE_IDX                                                        2
#define mmCM1_CM_BLNDGAM_RAMB_OFFSET_R                                                                 0x0f2a
#define mmCM1_CM_BLNDGAM_RAMB_OFFSET_R_BASE_IDX                                                        2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_0_1                                                               0x0f2b
#define mmCM1_CM_BLNDGAM_RAMB_REGION_0_1_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_2_3                                                               0x0f2c
#define mmCM1_CM_BLNDGAM_RAMB_REGION_2_3_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_4_5                                                               0x0f2d
#define mmCM1_CM_BLNDGAM_RAMB_REGION_4_5_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_6_7                                                               0x0f2e
#define mmCM1_CM_BLNDGAM_RAMB_REGION_6_7_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_8_9                                                               0x0f2f
#define mmCM1_CM_BLNDGAM_RAMB_REGION_8_9_BASE_IDX                                                      2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_10_11                                                             0x0f30
#define mmCM1_CM_BLNDGAM_RAMB_REGION_10_11_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_12_13                                                             0x0f31
#define mmCM1_CM_BLNDGAM_RAMB_REGION_12_13_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_14_15                                                             0x0f32
#define mmCM1_CM_BLNDGAM_RAMB_REGION_14_15_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_16_17                                                             0x0f33
#define mmCM1_CM_BLNDGAM_RAMB_REGION_16_17_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_18_19                                                             0x0f34
#define mmCM1_CM_BLNDGAM_RAMB_REGION_18_19_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_20_21                                                             0x0f35
#define mmCM1_CM_BLNDGAM_RAMB_REGION_20_21_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_22_23                                                             0x0f36
#define mmCM1_CM_BLNDGAM_RAMB_REGION_22_23_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_24_25                                                             0x0f37
#define mmCM1_CM_BLNDGAM_RAMB_REGION_24_25_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_26_27                                                             0x0f38
#define mmCM1_CM_BLNDGAM_RAMB_REGION_26_27_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_28_29                                                             0x0f39
#define mmCM1_CM_BLNDGAM_RAMB_REGION_28_29_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_30_31                                                             0x0f3a
#define mmCM1_CM_BLNDGAM_RAMB_REGION_30_31_BASE_IDX                                                    2
#define mmCM1_CM_BLNDGAM_RAMB_REGION_32_33                                                             0x0f3b
#define mmCM1_CM_BLNDGAM_RAMB_REGION_32_33_BASE_IDX                                                    2
#define mmCM1_CM_HDR_MULT_COEF                                                                         0x0f3c
#define mmCM1_CM_HDR_MULT_COEF_BASE_IDX                                                                2
#define mmCM1_CM_MEM_PWR_CTRL                                                                          0x0f3d
#define mmCM1_CM_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define mmCM1_CM_MEM_PWR_STATUS                                                                        0x0f3e
#define mmCM1_CM_MEM_PWR_STATUS_BASE_IDX                                                               2
#define mmCM1_CM_DEALPHA                                                                               0x0f40
#define mmCM1_CM_DEALPHA_BASE_IDX                                                                      2
#define mmCM1_CM_COEF_FORMAT                                                                           0x0f41
#define mmCM1_CM_COEF_FORMAT_BASE_IDX                                                                  2
#define mmCM1_CM_SHAPER_CONTROL                                                                        0x0f42
#define mmCM1_CM_SHAPER_CONTROL_BASE_IDX                                                               2
#define mmCM1_CM_SHAPER_OFFSET_R                                                                       0x0f43
#define mmCM1_CM_SHAPER_OFFSET_R_BASE_IDX                                                              2
#define mmCM1_CM_SHAPER_OFFSET_G                                                                       0x0f44
#define mmCM1_CM_SHAPER_OFFSET_G_BASE_IDX                                                              2
#define mmCM1_CM_SHAPER_OFFSET_B                                                                       0x0f45
#define mmCM1_CM_SHAPER_OFFSET_B_BASE_IDX                                                              2
#define mmCM1_CM_SHAPER_SCALE_R                                                                        0x0f46
#define mmCM1_CM_SHAPER_SCALE_R_BASE_IDX                                                               2
#define mmCM1_CM_SHAPER_SCALE_G_B                                                                      0x0f47
#define mmCM1_CM_SHAPER_SCALE_G_B_BASE_IDX                                                             2
#define mmCM1_CM_SHAPER_LUT_INDEX                                                                      0x0f48
#define mmCM1_CM_SHAPER_LUT_INDEX_BASE_IDX                                                             2
#define mmCM1_CM_SHAPER_LUT_DATA                                                                       0x0f49
#define mmCM1_CM_SHAPER_LUT_DATA_BASE_IDX                                                              2
#define mmCM1_CM_SHAPER_LUT_WRITE_EN_MASK                                                              0x0f4a
#define mmCM1_CM_SHAPER_LUT_WRITE_EN_MASK_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_START_CNTL_B                                                              0x0f4b
#define mmCM1_CM_SHAPER_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_START_CNTL_G                                                              0x0f4c
#define mmCM1_CM_SHAPER_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_START_CNTL_R                                                              0x0f4d
#define mmCM1_CM_SHAPER_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_END_CNTL_B                                                                0x0f4e
#define mmCM1_CM_SHAPER_RAMA_END_CNTL_B_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_END_CNTL_G                                                                0x0f4f
#define mmCM1_CM_SHAPER_RAMA_END_CNTL_G_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_END_CNTL_R                                                                0x0f50
#define mmCM1_CM_SHAPER_RAMA_END_CNTL_R_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_REGION_0_1                                                                0x0f51
#define mmCM1_CM_SHAPER_RAMA_REGION_0_1_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_REGION_2_3                                                                0x0f52
#define mmCM1_CM_SHAPER_RAMA_REGION_2_3_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_REGION_4_5                                                                0x0f53
#define mmCM1_CM_SHAPER_RAMA_REGION_4_5_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_REGION_6_7                                                                0x0f54
#define mmCM1_CM_SHAPER_RAMA_REGION_6_7_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_REGION_8_9                                                                0x0f55
#define mmCM1_CM_SHAPER_RAMA_REGION_8_9_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMA_REGION_10_11                                                              0x0f56
#define mmCM1_CM_SHAPER_RAMA_REGION_10_11_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_12_13                                                              0x0f57
#define mmCM1_CM_SHAPER_RAMA_REGION_12_13_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_14_15                                                              0x0f58
#define mmCM1_CM_SHAPER_RAMA_REGION_14_15_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_16_17                                                              0x0f59
#define mmCM1_CM_SHAPER_RAMA_REGION_16_17_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_18_19                                                              0x0f5a
#define mmCM1_CM_SHAPER_RAMA_REGION_18_19_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_20_21                                                              0x0f5b
#define mmCM1_CM_SHAPER_RAMA_REGION_20_21_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_22_23                                                              0x0f5c
#define mmCM1_CM_SHAPER_RAMA_REGION_22_23_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_24_25                                                              0x0f5d
#define mmCM1_CM_SHAPER_RAMA_REGION_24_25_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_26_27                                                              0x0f5e
#define mmCM1_CM_SHAPER_RAMA_REGION_26_27_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_28_29                                                              0x0f5f
#define mmCM1_CM_SHAPER_RAMA_REGION_28_29_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_30_31                                                              0x0f60
#define mmCM1_CM_SHAPER_RAMA_REGION_30_31_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMA_REGION_32_33                                                              0x0f61
#define mmCM1_CM_SHAPER_RAMA_REGION_32_33_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_START_CNTL_B                                                              0x0f62
#define mmCM1_CM_SHAPER_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_START_CNTL_G                                                              0x0f63
#define mmCM1_CM_SHAPER_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_START_CNTL_R                                                              0x0f64
#define mmCM1_CM_SHAPER_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_END_CNTL_B                                                                0x0f65
#define mmCM1_CM_SHAPER_RAMB_END_CNTL_B_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_END_CNTL_G                                                                0x0f66
#define mmCM1_CM_SHAPER_RAMB_END_CNTL_G_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_END_CNTL_R                                                                0x0f67
#define mmCM1_CM_SHAPER_RAMB_END_CNTL_R_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_REGION_0_1                                                                0x0f68
#define mmCM1_CM_SHAPER_RAMB_REGION_0_1_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_REGION_2_3                                                                0x0f69
#define mmCM1_CM_SHAPER_RAMB_REGION_2_3_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_REGION_4_5                                                                0x0f6a
#define mmCM1_CM_SHAPER_RAMB_REGION_4_5_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_REGION_6_7                                                                0x0f6b
#define mmCM1_CM_SHAPER_RAMB_REGION_6_7_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_REGION_8_9                                                                0x0f6c
#define mmCM1_CM_SHAPER_RAMB_REGION_8_9_BASE_IDX                                                       2
#define mmCM1_CM_SHAPER_RAMB_REGION_10_11                                                              0x0f6d
#define mmCM1_CM_SHAPER_RAMB_REGION_10_11_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_12_13                                                              0x0f6e
#define mmCM1_CM_SHAPER_RAMB_REGION_12_13_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_14_15                                                              0x0f6f
#define mmCM1_CM_SHAPER_RAMB_REGION_14_15_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_16_17                                                              0x0f70
#define mmCM1_CM_SHAPER_RAMB_REGION_16_17_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_18_19                                                              0x0f71
#define mmCM1_CM_SHAPER_RAMB_REGION_18_19_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_20_21                                                              0x0f72
#define mmCM1_CM_SHAPER_RAMB_REGION_20_21_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_22_23                                                              0x0f73
#define mmCM1_CM_SHAPER_RAMB_REGION_22_23_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_24_25                                                              0x0f74
#define mmCM1_CM_SHAPER_RAMB_REGION_24_25_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_26_27                                                              0x0f75
#define mmCM1_CM_SHAPER_RAMB_REGION_26_27_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_28_29                                                              0x0f76
#define mmCM1_CM_SHAPER_RAMB_REGION_28_29_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_30_31                                                              0x0f77
#define mmCM1_CM_SHAPER_RAMB_REGION_30_31_BASE_IDX                                                     2
#define mmCM1_CM_SHAPER_RAMB_REGION_32_33                                                              0x0f78
#define mmCM1_CM_SHAPER_RAMB_REGION_32_33_BASE_IDX                                                     2
#define mmCM1_CM_MEM_PWR_CTRL2                                                                         0x0f79
#define mmCM1_CM_MEM_PWR_CTRL2_BASE_IDX                                                                2
#define mmCM1_CM_MEM_PWR_STATUS2                                                                       0x0f7a
#define mmCM1_CM_MEM_PWR_STATUS2_BASE_IDX                                                              2
#define mmCM1_CM_3DLUT_MODE                                                                            0x0f7b
#define mmCM1_CM_3DLUT_MODE_BASE_IDX                                                                   2
#define mmCM1_CM_3DLUT_INDEX                                                                           0x0f7c
#define mmCM1_CM_3DLUT_INDEX_BASE_IDX                                                                  2
#define mmCM1_CM_3DLUT_DATA                                                                            0x0f7d
#define mmCM1_CM_3DLUT_DATA_BASE_IDX                                                                   2
#define mmCM1_CM_3DLUT_DATA_30BIT                                                                      0x0f7e
#define mmCM1_CM_3DLUT_DATA_30BIT_BASE_IDX                                                             2
#define mmCM1_CM_3DLUT_READ_WRITE_CONTROL                                                              0x0f7f
#define mmCM1_CM_3DLUT_READ_WRITE_CONTROL_BASE_IDX                                                     2
#define mmCM1_CM_3DLUT_OUT_NORM_FACTOR                                                                 0x0f80
#define mmCM1_CM_3DLUT_OUT_NORM_FACTOR_BASE_IDX                                                        2
#define mmCM1_CM_3DLUT_OUT_OFFSET_R                                                                    0x0f81
#define mmCM1_CM_3DLUT_OUT_OFFSET_R_BASE_IDX                                                           2
#define mmCM1_CM_3DLUT_OUT_OFFSET_G                                                                    0x0f82
#define mmCM1_CM_3DLUT_OUT_OFFSET_G_BASE_IDX                                                           2
#define mmCM1_CM_3DLUT_OUT_OFFSET_B                                                                    0x0f83
#define mmCM1_CM_3DLUT_OUT_OFFSET_B_BASE_IDX                                                           2
#define mmCM1_CM_TEST_DEBUG_INDEX                                                                      0x0f84
#define mmCM1_CM_TEST_DEBUG_INDEX_BASE_IDX                                                             2
#define mmCM1_CM_TEST_DEBUG_DATA                                                                       0x0f85
#define mmCM1_CM_TEST_DEBUG_DATA_BASE_IDX                                                              2


// addressBlock: dce_dc_dpp1_dispdec_dpp_dcperfmon_dc_perfmon_dispdec
// base address: 0x3e3c
#define mmDC_PERFMON12_PERFCOUNTER_CNTL                                                                0x0f8f
#define mmDC_PERFMON12_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON12_PERFCOUNTER_CNTL2                                                               0x0f90
#define mmDC_PERFMON12_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON12_PERFCOUNTER_STATE                                                               0x0f91
#define mmDC_PERFMON12_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON12_PERFMON_CNTL                                                                    0x0f92
#define mmDC_PERFMON12_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON12_PERFMON_CNTL2                                                                   0x0f93
#define mmDC_PERFMON12_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON12_PERFMON_CVALUE_INT_MISC                                                         0x0f94
#define mmDC_PERFMON12_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON12_PERFMON_CVALUE_LOW                                                              0x0f95
#define mmDC_PERFMON12_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON12_PERFMON_HI                                                                      0x0f96
#define mmDC_PERFMON12_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON12_PERFMON_LOW                                                                     0x0f97
#define mmDC_PERFMON12_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dpp2_dispdec_dpp_top_dispdec
// base address: 0xb58
#define mmDPP_TOP2_DPP_CONTROL                                                                         0x0f9b
#define mmDPP_TOP2_DPP_CONTROL_BASE_IDX                                                                2
#define mmDPP_TOP2_DPP_SOFT_RESET                                                                      0x0f9c
#define mmDPP_TOP2_DPP_SOFT_RESET_BASE_IDX                                                             2
#define mmDPP_TOP2_DPP_CRC_VAL_R_G                                                                     0x0f9d
#define mmDPP_TOP2_DPP_CRC_VAL_R_G_BASE_IDX                                                            2
#define mmDPP_TOP2_DPP_CRC_VAL_B_A                                                                     0x0f9e
#define mmDPP_TOP2_DPP_CRC_VAL_B_A_BASE_IDX                                                            2
#define mmDPP_TOP2_DPP_CRC_CTRL                                                                        0x0f9f
#define mmDPP_TOP2_DPP_CRC_CTRL_BASE_IDX                                                               2
#define mmDPP_TOP2_HOST_READ_CONTROL                                                                   0x0fa0
#define mmDPP_TOP2_HOST_READ_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_dpp2_dispdec_cnvc_cfg_dispdec
// base address: 0xb58
#define mmCNVC_CFG2_CNVC_SURFACE_PIXEL_FORMAT                                                          0x0fa5
#define mmCNVC_CFG2_CNVC_SURFACE_PIXEL_FORMAT_BASE_IDX                                                 2
#define mmCNVC_CFG2_FORMAT_CONTROL                                                                     0x0fa6
#define mmCNVC_CFG2_FORMAT_CONTROL_BASE_IDX                                                            2
#define mmCNVC_CFG2_FCNV_FP_BIAS_R                                                                     0x0fa7
#define mmCNVC_CFG2_FCNV_FP_BIAS_R_BASE_IDX                                                            2
#define mmCNVC_CFG2_FCNV_FP_BIAS_G                                                                     0x0fa8
#define mmCNVC_CFG2_FCNV_FP_BIAS_G_BASE_IDX                                                            2
#define mmCNVC_CFG2_FCNV_FP_BIAS_B                                                                     0x0fa9
#define mmCNVC_CFG2_FCNV_FP_BIAS_B_BASE_IDX                                                            2
#define mmCNVC_CFG2_FCNV_FP_SCALE_R                                                                    0x0faa
#define mmCNVC_CFG2_FCNV_FP_SCALE_R_BASE_IDX                                                           2
#define mmCNVC_CFG2_FCNV_FP_SCALE_G                                                                    0x0fab
#define mmCNVC_CFG2_FCNV_FP_SCALE_G_BASE_IDX                                                           2
#define mmCNVC_CFG2_FCNV_FP_SCALE_B                                                                    0x0fac
#define mmCNVC_CFG2_FCNV_FP_SCALE_B_BASE_IDX                                                           2
#define mmCNVC_CFG2_COLOR_KEYER_CONTROL                                                                0x0fad
#define mmCNVC_CFG2_COLOR_KEYER_CONTROL_BASE_IDX                                                       2
#define mmCNVC_CFG2_COLOR_KEYER_ALPHA                                                                  0x0fae
#define mmCNVC_CFG2_COLOR_KEYER_ALPHA_BASE_IDX                                                         2
#define mmCNVC_CFG2_COLOR_KEYER_RED                                                                    0x0faf
#define mmCNVC_CFG2_COLOR_KEYER_RED_BASE_IDX                                                           2
#define mmCNVC_CFG2_COLOR_KEYER_GREEN                                                                  0x0fb0
#define mmCNVC_CFG2_COLOR_KEYER_GREEN_BASE_IDX                                                         2
#define mmCNVC_CFG2_COLOR_KEYER_BLUE                                                                   0x0fb1
#define mmCNVC_CFG2_COLOR_KEYER_BLUE_BASE_IDX                                                          2
#define mmCNVC_CFG2_ALPHA_2BIT_LUT                                                                     0x0fb3
#define mmCNVC_CFG2_ALPHA_2BIT_LUT_BASE_IDX                                                            2
#define mmCNVC_CFG2_PRE_DEALPHA                                                                        0x0fb4
#define mmCNVC_CFG2_PRE_DEALPHA_BASE_IDX                                                               2
#define mmCNVC_CFG2_PRE_CSC_MODE                                                                       0x0fb5
#define mmCNVC_CFG2_PRE_CSC_MODE_BASE_IDX                                                              2
#define mmCNVC_CFG2_PRE_CSC_C11_C12                                                                    0x0fb6
#define mmCNVC_CFG2_PRE_CSC_C11_C12_BASE_IDX                                                           2
#define mmCNVC_CFG2_PRE_CSC_C13_C14                                                                    0x0fb7
#define mmCNVC_CFG2_PRE_CSC_C13_C14_BASE_IDX                                                           2
#define mmCNVC_CFG2_PRE_CSC_C21_C22                                                                    0x0fb8
#define mmCNVC_CFG2_PRE_CSC_C21_C22_BASE_IDX                                                           2
#define mmCNVC_CFG2_PRE_CSC_C23_C24                                                                    0x0fb9
#define mmCNVC_CFG2_PRE_CSC_C23_C24_BASE_IDX                                                           2
#define mmCNVC_CFG2_PRE_CSC_C31_C32                                                                    0x0fba
#define mmCNVC_CFG2_PRE_CSC_C31_C32_BASE_IDX                                                           2
#define mmCNVC_CFG2_PRE_CSC_C33_C34                                                                    0x0fbb
#define mmCNVC_CFG2_PRE_CSC_C33_C34_BASE_IDX                                                           2
#define mmCNVC_CFG2_PRE_CSC_B_C11_C12                                                                  0x0fbc
#define mmCNVC_CFG2_PRE_CSC_B_C11_C12_BASE_IDX                                                         2
#define mmCNVC_CFG2_PRE_CSC_B_C13_C14                                                                  0x0fbd
#define mmCNVC_CFG2_PRE_CSC_B_C13_C14_BASE_IDX                                                         2
#define mmCNVC_CFG2_PRE_CSC_B_C21_C22                                                                  0x0fbe
#define mmCNVC_CFG2_PRE_CSC_B_C21_C22_BASE_IDX                                                         2
#define mmCNVC_CFG2_PRE_CSC_B_C23_C24                                                                  0x0fbf
#define mmCNVC_CFG2_PRE_CSC_B_C23_C24_BASE_IDX                                                         2
#define mmCNVC_CFG2_PRE_CSC_B_C31_C32                                                                  0x0fc0
#define mmCNVC_CFG2_PRE_CSC_B_C31_C32_BASE_IDX                                                         2
#define mmCNVC_CFG2_PRE_CSC_B_C33_C34                                                                  0x0fc1
#define mmCNVC_CFG2_PRE_CSC_B_C33_C34_BASE_IDX                                                         2
#define mmCNVC_CFG2_CNVC_COEF_FORMAT                                                                   0x0fc2
#define mmCNVC_CFG2_CNVC_COEF_FORMAT_BASE_IDX                                                          2
#define mmCNVC_CFG2_PRE_DEGAM                                                                          0x0fc3
#define mmCNVC_CFG2_PRE_DEGAM_BASE_IDX                                                                 2
#define mmCNVC_CFG2_PRE_REALPHA                                                                        0x0fc4
#define mmCNVC_CFG2_PRE_REALPHA_BASE_IDX                                                               2


// addressBlock: dce_dc_dpp2_dispdec_cnvc_cur_dispdec
// base address: 0xb58
#define mmCNVC_CUR2_CURSOR0_CONTROL                                                                    0x0fc7
#define mmCNVC_CUR2_CURSOR0_CONTROL_BASE_IDX                                                           2
#define mmCNVC_CUR2_CURSOR0_COLOR0                                                                     0x0fc8
#define mmCNVC_CUR2_CURSOR0_COLOR0_BASE_IDX                                                            2
#define mmCNVC_CUR2_CURSOR0_COLOR1                                                                     0x0fc9
#define mmCNVC_CUR2_CURSOR0_COLOR1_BASE_IDX                                                            2
#define mmCNVC_CUR2_CURSOR0_FP_SCALE_BIAS                                                              0x0fca
#define mmCNVC_CUR2_CURSOR0_FP_SCALE_BIAS_BASE_IDX                                                     2

// addressBlock: dce_dc_dpp2_dispdec_dscl_dispdec
// base address: 0xb58
#define mmDSCL2_SCL_COEF_RAM_TAP_SELECT                                                                0x0fcf
#define mmDSCL2_SCL_COEF_RAM_TAP_SELECT_BASE_IDX                                                       2
#define mmDSCL2_SCL_COEF_RAM_TAP_DATA                                                                  0x0fd0
#define mmDSCL2_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                         2
#define mmDSCL2_SCL_MODE                                                                               0x0fd1
#define mmDSCL2_SCL_MODE_BASE_IDX                                                                      2
#define mmDSCL2_SCL_TAP_CONTROL                                                                        0x0fd2
#define mmDSCL2_SCL_TAP_CONTROL_BASE_IDX                                                               2
#define mmDSCL2_DSCL_CONTROL                                                                           0x0fd3
#define mmDSCL2_DSCL_CONTROL_BASE_IDX                                                                  2
#define mmDSCL2_DSCL_2TAP_CONTROL                                                                      0x0fd4
#define mmDSCL2_DSCL_2TAP_CONTROL_BASE_IDX                                                             2
#define mmDSCL2_SCL_MANUAL_REPLICATE_CONTROL                                                           0x0fd5
#define mmDSCL2_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                  2
#define mmDSCL2_SCL_HORZ_FILTER_SCALE_RATIO                                                            0x0fd6
#define mmDSCL2_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define mmDSCL2_SCL_HORZ_FILTER_INIT                                                                   0x0fd7
#define mmDSCL2_SCL_HORZ_FILTER_INIT_BASE_IDX                                                          2
#define mmDSCL2_SCL_HORZ_FILTER_SCALE_RATIO_C                                                          0x0fd8
#define mmDSCL2_SCL_HORZ_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define mmDSCL2_SCL_HORZ_FILTER_INIT_C                                                                 0x0fd9
#define mmDSCL2_SCL_HORZ_FILTER_INIT_C_BASE_IDX                                                        2
#define mmDSCL2_SCL_VERT_FILTER_SCALE_RATIO                                                            0x0fda
#define mmDSCL2_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define mmDSCL2_SCL_VERT_FILTER_INIT                                                                   0x0fdb
#define mmDSCL2_SCL_VERT_FILTER_INIT_BASE_IDX                                                          2
#define mmDSCL2_SCL_VERT_FILTER_INIT_BOT                                                               0x0fdc
#define mmDSCL2_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                      2
#define mmDSCL2_SCL_VERT_FILTER_SCALE_RATIO_C                                                          0x0fdd
#define mmDSCL2_SCL_VERT_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define mmDSCL2_SCL_VERT_FILTER_INIT_C                                                                 0x0fde
#define mmDSCL2_SCL_VERT_FILTER_INIT_C_BASE_IDX                                                        2
#define mmDSCL2_SCL_VERT_FILTER_INIT_BOT_C                                                             0x0fdf
#define mmDSCL2_SCL_VERT_FILTER_INIT_BOT_C_BASE_IDX                                                    2
#define mmDSCL2_SCL_BLACK_COLOR                                                                        0x0fe0
#define mmDSCL2_SCL_BLACK_COLOR_BASE_IDX                                                               2
#define mmDSCL2_DSCL_UPDATE                                                                            0x0fe1
#define mmDSCL2_DSCL_UPDATE_BASE_IDX                                                                   2
#define mmDSCL2_DSCL_AUTOCAL                                                                           0x0fe2
#define mmDSCL2_DSCL_AUTOCAL_BASE_IDX                                                                  2
#define mmDSCL2_DSCL_EXT_OVERSCAN_LEFT_RIGHT                                                           0x0fe3
#define mmDSCL2_DSCL_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                  2
#define mmDSCL2_DSCL_EXT_OVERSCAN_TOP_BOTTOM                                                           0x0fe4
#define mmDSCL2_DSCL_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                  2
#define mmDSCL2_OTG_H_BLANK                                                                            0x0fe5
#define mmDSCL2_OTG_H_BLANK_BASE_IDX                                                                   2
#define mmDSCL2_OTG_V_BLANK                                                                            0x0fe6
#define mmDSCL2_OTG_V_BLANK_BASE_IDX                                                                   2
#define mmDSCL2_RECOUT_START                                                                           0x0fe7
#define mmDSCL2_RECOUT_START_BASE_IDX                                                                  2
#define mmDSCL2_RECOUT_SIZE                                                                            0x0fe8
#define mmDSCL2_RECOUT_SIZE_BASE_IDX                                                                   2
#define mmDSCL2_MPC_SIZE                                                                               0x0fe9
#define mmDSCL2_MPC_SIZE_BASE_IDX                                                                      2
#define mmDSCL2_LB_DATA_FORMAT                                                                         0x0fea
#define mmDSCL2_LB_DATA_FORMAT_BASE_IDX                                                                2
#define mmDSCL2_LB_MEMORY_CTRL                                                                         0x0feb
#define mmDSCL2_LB_MEMORY_CTRL_BASE_IDX                                                                2
#define mmDSCL2_LB_V_COUNTER                                                                           0x0fec
#define mmDSCL2_LB_V_COUNTER_BASE_IDX                                                                  2
#define mmDSCL2_DSCL_MEM_PWR_CTRL                                                                      0x0fed
#define mmDSCL2_DSCL_MEM_PWR_CTRL_BASE_IDX                                                             2
#define mmDSCL2_DSCL_MEM_PWR_STATUS                                                                    0x0fee
#define mmDSCL2_DSCL_MEM_PWR_STATUS_BASE_IDX                                                           2
#define mmDSCL2_OBUF_CONTROL                                                                           0x0fef
#define mmDSCL2_OBUF_CONTROL_BASE_IDX                                                                  2
#define mmDSCL2_OBUF_MEM_PWR_CTRL                                                                      0x0ff0
#define mmDSCL2_OBUF_MEM_PWR_CTRL_BASE_IDX                                                             2


// addressBlock: dce_dc_dpp2_dispdec_cm_dispdec
// base address: 0xb58
#define mmCM2_CM_CONTROL                                                                               0x0ff6
#define mmCM2_CM_CONTROL_BASE_IDX                                                                      2
#define mmCM2_CM_POST_CSC_CONTROL                                                                      0x0ff7
#define mmCM2_CM_POST_CSC_CONTROL_BASE_IDX                                                             2
#define mmCM2_CM_POST_CSC_C11_C12                                                                      0x0ff8
#define mmCM2_CM_POST_CSC_C11_C12_BASE_IDX                                                             2
#define mmCM2_CM_POST_CSC_C13_C14                                                                      0x0ff9
#define mmCM2_CM_POST_CSC_C13_C14_BASE_IDX                                                             2
#define mmCM2_CM_POST_CSC_C21_C22                                                                      0x0ffa
#define mmCM2_CM_POST_CSC_C21_C22_BASE_IDX                                                             2
#define mmCM2_CM_POST_CSC_C23_C24                                                                      0x0ffb
#define mmCM2_CM_POST_CSC_C23_C24_BASE_IDX                                                             2
#define mmCM2_CM_POST_CSC_C31_C32                                                                      0x0ffc
#define mmCM2_CM_POST_CSC_C31_C32_BASE_IDX                                                             2
#define mmCM2_CM_POST_CSC_C33_C34                                                                      0x0ffd
#define mmCM2_CM_POST_CSC_C33_C34_BASE_IDX                                                             2
#define mmCM2_CM_POST_CSC_B_C11_C12                                                                    0x0ffe
#define mmCM2_CM_POST_CSC_B_C11_C12_BASE_IDX                                                           2
#define mmCM2_CM_POST_CSC_B_C13_C14                                                                    0x0fff
#define mmCM2_CM_POST_CSC_B_C13_C14_BASE_IDX                                                           2
#define mmCM2_CM_POST_CSC_B_C21_C22                                                                    0x1000
#define mmCM2_CM_POST_CSC_B_C21_C22_BASE_IDX                                                           2
#define mmCM2_CM_POST_CSC_B_C23_C24                                                                    0x1001
#define mmCM2_CM_POST_CSC_B_C23_C24_BASE_IDX                                                           2
#define mmCM2_CM_POST_CSC_B_C31_C32                                                                    0x1002
#define mmCM2_CM_POST_CSC_B_C31_C32_BASE_IDX                                                           2
#define mmCM2_CM_POST_CSC_B_C33_C34                                                                    0x1003
#define mmCM2_CM_POST_CSC_B_C33_C34_BASE_IDX                                                           2
#define mmCM2_CM_GAMUT_REMAP_CONTROL                                                                   0x1004
#define mmCM2_CM_GAMUT_REMAP_CONTROL_BASE_IDX                                                          2
#define mmCM2_CM_GAMUT_REMAP_C11_C12                                                                   0x1005
#define mmCM2_CM_GAMUT_REMAP_C11_C12_BASE_IDX                                                          2
#define mmCM2_CM_GAMUT_REMAP_C13_C14                                                                   0x1006
#define mmCM2_CM_GAMUT_REMAP_C13_C14_BASE_IDX                                                          2
#define mmCM2_CM_GAMUT_REMAP_C21_C22                                                                   0x1007
#define mmCM2_CM_GAMUT_REMAP_C21_C22_BASE_IDX                                                          2
#define mmCM2_CM_GAMUT_REMAP_C23_C24                                                                   0x1008
#define mmCM2_CM_GAMUT_REMAP_C23_C24_BASE_IDX                                                          2
#define mmCM2_CM_GAMUT_REMAP_C31_C32                                                                   0x1009
#define mmCM2_CM_GAMUT_REMAP_C31_C32_BASE_IDX                                                          2
#define mmCM2_CM_GAMUT_REMAP_C33_C34                                                                   0x100a
#define mmCM2_CM_GAMUT_REMAP_C33_C34_BASE_IDX                                                          2
#define mmCM2_CM_GAMUT_REMAP_B_C11_C12                                                                 0x100b
#define mmCM2_CM_GAMUT_REMAP_B_C11_C12_BASE_IDX                                                        2
#define mmCM2_CM_GAMUT_REMAP_B_C13_C14                                                                 0x100c
#define mmCM2_CM_GAMUT_REMAP_B_C13_C14_BASE_IDX                                                        2
#define mmCM2_CM_GAMUT_REMAP_B_C21_C22                                                                 0x100d
#define mmCM2_CM_GAMUT_REMAP_B_C21_C22_BASE_IDX                                                        2
#define mmCM2_CM_GAMUT_REMAP_B_C23_C24                                                                 0x100e
#define mmCM2_CM_GAMUT_REMAP_B_C23_C24_BASE_IDX                                                        2
#define mmCM2_CM_GAMUT_REMAP_B_C31_C32                                                                 0x100f
#define mmCM2_CM_GAMUT_REMAP_B_C31_C32_BASE_IDX                                                        2
#define mmCM2_CM_GAMUT_REMAP_B_C33_C34                                                                 0x1010
#define mmCM2_CM_GAMUT_REMAP_B_C33_C34_BASE_IDX                                                        2
#define mmCM2_CM_BIAS_CR_R                                                                             0x1011
#define mmCM2_CM_BIAS_CR_R_BASE_IDX                                                                    2
#define mmCM2_CM_BIAS_Y_G_CB_B                                                                         0x1012
#define mmCM2_CM_BIAS_Y_G_CB_B_BASE_IDX                                                                2
#define mmCM2_CM_GAMCOR_CONTROL                                                                        0x1013
#define mmCM2_CM_GAMCOR_CONTROL_BASE_IDX                                                               2
#define mmCM2_CM_GAMCOR_LUT_INDEX                                                                      0x1014
#define mmCM2_CM_GAMCOR_LUT_INDEX_BASE_IDX                                                             2
#define mmCM2_CM_GAMCOR_LUT_DATA                                                                       0x1015
#define mmCM2_CM_GAMCOR_LUT_DATA_BASE_IDX                                                              2
#define mmCM2_CM_GAMCOR_LUT_CONTROL                                                                    0x1016
#define mmCM2_CM_GAMCOR_LUT_CONTROL_BASE_IDX                                                           2
#define mmCM2_CM_GAMCOR_RAMA_START_CNTL_B                                                              0x1017
#define mmCM2_CM_GAMCOR_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMA_START_CNTL_G                                                              0x1018
#define mmCM2_CM_GAMCOR_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMA_START_CNTL_R                                                              0x1019
#define mmCM2_CM_GAMCOR_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B                                                        0x101a
#define mmCM2_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define mmCM2_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G                                                        0x101b
#define mmCM2_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define mmCM2_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R                                                        0x101c
#define mmCM2_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define mmCM2_CM_GAMCOR_RAMA_START_BASE_CNTL_B                                                         0x101d
#define mmCM2_CM_GAMCOR_RAMA_START_BASE_CNTL_B_BASE_IDX                                                2
#define mmCM2_CM_GAMCOR_RAMA_START_BASE_CNTL_G                                                         0x101e
#define mmCM2_CM_GAMCOR_RAMA_START_BASE_CNTL_G_BASE_IDX                                                2
#define mmCM2_CM_GAMCOR_RAMA_START_BASE_CNTL_R                                                         0x101f
#define mmCM2_CM_GAMCOR_RAMA_START_BASE_CNTL_R_BASE_IDX                                                2
#define mmCM2_CM_GAMCOR_RAMA_END_CNTL1_B                                                               0x1020
#define mmCM2_CM_GAMCOR_RAMA_END_CNTL1_B_BASE_IDX                                                      2
#define mmCM2_CM_GAMCOR_RAMA_END_CNTL2_B                                                               0x1021
#define mmCM2_CM_GAMCOR_RAMA_END_CNTL2_B_BASE_IDX                                                      2
#define mmCM2_CM_GAMCOR_RAMA_END_CNTL1_G                                                               0x1022
#define mmCM2_CM_GAMCOR_RAMA_END_CNTL1_G_BASE_IDX                                                      2
#define mmCM2_CM_GAMCOR_RAMA_END_CNTL2_G                                                               0x1023
#define mmCM2_CM_GAMCOR_RAMA_END_CNTL2_G_BASE_IDX                                                      2
#define mmCM2_CM_GAMCOR_RAMA_END_CNTL1_R                                                               0x1024
#define mmCM2_CM_GAMCOR_RAMA_END_CNTL1_R_BASE_IDX                                                      2
#define mmCM2_CM_GAMCOR_RAMA_END_CNTL2_R                                                               0x1025
#define mmCM2_CM_GAMCOR_RAMA_END_CNTL2_R_BASE_IDX                                                      2
#define mmCM2_CM_GAMCOR_RAMA_OFFSET_B                                                                  0x1026
#define mmCM2_CM_GAMCOR_RAMA_OFFSET_B_BASE_IDX                                                         2
#define mmCM2_CM_GAMCOR_RAMA_OFFSET_G                                                                  0x1027
#define mmCM2_CM_GAMCOR_RAMA_OFFSET_G_BASE_IDX                                                         2
#define mmCM2_CM_GAMCOR_RAMA_OFFSET_R                                                                  0x1028
#define mmCM2_CM_GAMCOR_RAMA_OFFSET_R_BASE_IDX                                                         2
#define mmCM2_CM_GAMCOR_RAMA_REGION_0_1                                                                0x1029
#define mmCM2_CM_GAMCOR_RAMA_REGION_0_1_BASE_IDX                                                       2
#define mmCM2_CM_GAMCOR_RAMA_REGION_2_3                                                                0x102a
#define mmCM2_CM_GAMCOR_RAMA_REGION_2_3_BASE_IDX                                                       2
#define mmCM2_CM_GAMCOR_RAMA_REGION_4_5                                                                0x102b
#define mmCM2_CM_GAMCOR_RAMA_REGION_4_5_BASE_IDX                                                       2
#define mmCM2_CM_GAMCOR_RAMA_REGION_6_7                                                                0x102c
#define mmCM2_CM_GAMCOR_RAMA_REGION_6_7_BASE_IDX                                                       2
#define mmCM2_CM_GAMCOR_RAMA_REGION_8_9                                                                0x102d
#define mmCM2_CM_GAMCOR_RAMA_REGION_8_9_BASE_IDX                                                       2
#define mmCM2_CM_GAMCOR_RAMA_REGION_10_11                                                              0x102e
#define mmCM2_CM_GAMCOR_RAMA_REGION_10_11_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMA_REGION_12_13                                                              0x102f
#define mmCM2_CM_GAMCOR_RAMA_REGION_12_13_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMA_REGION_14_15                                                              0x1030
#define mmCM2_CM_GAMCOR_RAMA_REGION_14_15_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMA_REGION_16_17                                                              0x1031
#define mmCM2_CM_GAMCOR_RAMA_REGION_16_17_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMA_REGION_18_19                                                              0x1032
#define mmCM2_CM_GAMCOR_RAMA_REGION_18_19_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMA_REGION_20_21                                                              0x1033
#define mmCM2_CM_GAMCOR_RAMA_REGION_20_21_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMA_REGION_22_23                                                              0x1034
#define mmCM2_CM_GAMCOR_RAMA_REGION_22_23_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMA_REGION_24_25                                                              0x1035
#define mmCM2_CM_GAMCOR_RAMA_REGION_24_25_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMA_REGION_26_27                                                              0x1036
#define mmCM2_CM_GAMCOR_RAMA_REGION_26_27_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMA_REGION_28_29                                                              0x1037
#define mmCM2_CM_GAMCOR_RAMA_REGION_28_29_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMA_REGION_30_31                                                              0x1038
#define mmCM2_CM_GAMCOR_RAMA_REGION_30_31_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMA_REGION_32_33                                                              0x1039
#define mmCM2_CM_GAMCOR_RAMA_REGION_32_33_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_START_CNTL_B                                                              0x103a
#define mmCM2_CM_GAMCOR_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_START_CNTL_G                                                              0x103b
#define mmCM2_CM_GAMCOR_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_START_CNTL_R                                                              0x103c
#define mmCM2_CM_GAMCOR_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B                                                        0x103d
#define mmCM2_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define mmCM2_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G                                                        0x103e
#define mmCM2_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define mmCM2_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R                                                        0x103f
#define mmCM2_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define mmCM2_CM_GAMCOR_RAMB_START_BASE_CNTL_B                                                         0x1040
#define mmCM2_CM_GAMCOR_RAMB_START_BASE_CNTL_B_BASE_IDX                                                2
#define mmCM2_CM_GAMCOR_RAMB_START_BASE_CNTL_G                                                         0x1041
#define mmCM2_CM_GAMCOR_RAMB_START_BASE_CNTL_G_BASE_IDX                                                2
#define mmCM2_CM_GAMCOR_RAMB_START_BASE_CNTL_R                                                         0x1042
#define mmCM2_CM_GAMCOR_RAMB_START_BASE_CNTL_R_BASE_IDX                                                2
#define mmCM2_CM_GAMCOR_RAMB_END_CNTL1_B                                                               0x1043
#define mmCM2_CM_GAMCOR_RAMB_END_CNTL1_B_BASE_IDX                                                      2
#define mmCM2_CM_GAMCOR_RAMB_END_CNTL2_B                                                               0x1044
#define mmCM2_CM_GAMCOR_RAMB_END_CNTL2_B_BASE_IDX                                                      2
#define mmCM2_CM_GAMCOR_RAMB_END_CNTL1_G                                                               0x1045
#define mmCM2_CM_GAMCOR_RAMB_END_CNTL1_G_BASE_IDX                                                      2
#define mmCM2_CM_GAMCOR_RAMB_END_CNTL2_G                                                               0x1046
#define mmCM2_CM_GAMCOR_RAMB_END_CNTL2_G_BASE_IDX                                                      2
#define mmCM2_CM_GAMCOR_RAMB_END_CNTL1_R                                                               0x1047
#define mmCM2_CM_GAMCOR_RAMB_END_CNTL1_R_BASE_IDX                                                      2
#define mmCM2_CM_GAMCOR_RAMB_END_CNTL2_R                                                               0x1048
#define mmCM2_CM_GAMCOR_RAMB_END_CNTL2_R_BASE_IDX                                                      2
#define mmCM2_CM_GAMCOR_RAMB_OFFSET_B                                                                  0x1049
#define mmCM2_CM_GAMCOR_RAMB_OFFSET_B_BASE_IDX                                                         2
#define mmCM2_CM_GAMCOR_RAMB_OFFSET_G                                                                  0x104a
#define mmCM2_CM_GAMCOR_RAMB_OFFSET_G_BASE_IDX                                                         2
#define mmCM2_CM_GAMCOR_RAMB_OFFSET_R                                                                  0x104b
#define mmCM2_CM_GAMCOR_RAMB_OFFSET_R_BASE_IDX                                                         2
#define mmCM2_CM_GAMCOR_RAMB_REGION_0_1                                                                0x104c
#define mmCM2_CM_GAMCOR_RAMB_REGION_0_1_BASE_IDX                                                       2
#define mmCM2_CM_GAMCOR_RAMB_REGION_2_3                                                                0x104d
#define mmCM2_CM_GAMCOR_RAMB_REGION_2_3_BASE_IDX                                                       2
#define mmCM2_CM_GAMCOR_RAMB_REGION_4_5                                                                0x104e
#define mmCM2_CM_GAMCOR_RAMB_REGION_4_5_BASE_IDX                                                       2
#define mmCM2_CM_GAMCOR_RAMB_REGION_6_7                                                                0x104f
#define mmCM2_CM_GAMCOR_RAMB_REGION_6_7_BASE_IDX                                                       2
#define mmCM2_CM_GAMCOR_RAMB_REGION_8_9                                                                0x1050
#define mmCM2_CM_GAMCOR_RAMB_REGION_8_9_BASE_IDX                                                       2
#define mmCM2_CM_GAMCOR_RAMB_REGION_10_11                                                              0x1051
#define mmCM2_CM_GAMCOR_RAMB_REGION_10_11_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_REGION_12_13                                                              0x1052
#define mmCM2_CM_GAMCOR_RAMB_REGION_12_13_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_REGION_14_15                                                              0x1053
#define mmCM2_CM_GAMCOR_RAMB_REGION_14_15_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_REGION_16_17                                                              0x1054
#define mmCM2_CM_GAMCOR_RAMB_REGION_16_17_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_REGION_18_19                                                              0x1055
#define mmCM2_CM_GAMCOR_RAMB_REGION_18_19_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_REGION_20_21                                                              0x1056
#define mmCM2_CM_GAMCOR_RAMB_REGION_20_21_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_REGION_22_23                                                              0x1057
#define mmCM2_CM_GAMCOR_RAMB_REGION_22_23_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_REGION_24_25                                                              0x1058
#define mmCM2_CM_GAMCOR_RAMB_REGION_24_25_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_REGION_26_27                                                              0x1059
#define mmCM2_CM_GAMCOR_RAMB_REGION_26_27_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_REGION_28_29                                                              0x105a
#define mmCM2_CM_GAMCOR_RAMB_REGION_28_29_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_REGION_30_31                                                              0x105b
#define mmCM2_CM_GAMCOR_RAMB_REGION_30_31_BASE_IDX                                                     2
#define mmCM2_CM_GAMCOR_RAMB_REGION_32_33                                                              0x105c
#define mmCM2_CM_GAMCOR_RAMB_REGION_32_33_BASE_IDX                                                     2
#define mmCM2_CM_BLNDGAM_CONTROL                                                                       0x105d
#define mmCM2_CM_BLNDGAM_CONTROL_BASE_IDX                                                              2
#define mmCM2_CM_BLNDGAM_LUT_INDEX                                                                     0x105e
#define mmCM2_CM_BLNDGAM_LUT_INDEX_BASE_IDX                                                            2
#define mmCM2_CM_BLNDGAM_LUT_DATA                                                                      0x105f
#define mmCM2_CM_BLNDGAM_LUT_DATA_BASE_IDX                                                             2
#define mmCM2_CM_BLNDGAM_LUT_CONTROL                                                                   0x1060
#define mmCM2_CM_BLNDGAM_LUT_CONTROL_BASE_IDX                                                          2
#define mmCM2_CM_BLNDGAM_RAMA_START_CNTL_B                                                             0x1061
#define mmCM2_CM_BLNDGAM_RAMA_START_CNTL_B_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMA_START_CNTL_G                                                             0x1062
#define mmCM2_CM_BLNDGAM_RAMA_START_CNTL_G_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMA_START_CNTL_R                                                             0x1063
#define mmCM2_CM_BLNDGAM_RAMA_START_CNTL_R_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_B                                                       0x1064
#define mmCM2_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                              2
#define mmCM2_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_G                                                       0x1065
#define mmCM2_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                              2
#define mmCM2_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_R                                                       0x1066
#define mmCM2_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                              2
#define mmCM2_CM_BLNDGAM_RAMA_START_BASE_CNTL_B                                                        0x1067
#define mmCM2_CM_BLNDGAM_RAMA_START_BASE_CNTL_B_BASE_IDX                                               2
#define mmCM2_CM_BLNDGAM_RAMA_START_BASE_CNTL_G                                                        0x1068
#define mmCM2_CM_BLNDGAM_RAMA_START_BASE_CNTL_G_BASE_IDX                                               2
#define mmCM2_CM_BLNDGAM_RAMA_START_BASE_CNTL_R                                                        0x1069
#define mmCM2_CM_BLNDGAM_RAMA_START_BASE_CNTL_R_BASE_IDX                                               2
#define mmCM2_CM_BLNDGAM_RAMA_END_CNTL1_B                                                              0x106a
#define mmCM2_CM_BLNDGAM_RAMA_END_CNTL1_B_BASE_IDX                                                     2
#define mmCM2_CM_BLNDGAM_RAMA_END_CNTL2_B                                                              0x106b
#define mmCM2_CM_BLNDGAM_RAMA_END_CNTL2_B_BASE_IDX                                                     2
#define mmCM2_CM_BLNDGAM_RAMA_END_CNTL1_G                                                              0x106c
#define mmCM2_CM_BLNDGAM_RAMA_END_CNTL1_G_BASE_IDX                                                     2
#define mmCM2_CM_BLNDGAM_RAMA_END_CNTL2_G                                                              0x106d
#define mmCM2_CM_BLNDGAM_RAMA_END_CNTL2_G_BASE_IDX                                                     2
#define mmCM2_CM_BLNDGAM_RAMA_END_CNTL1_R                                                              0x106e
#define mmCM2_CM_BLNDGAM_RAMA_END_CNTL1_R_BASE_IDX                                                     2
#define mmCM2_CM_BLNDGAM_RAMA_END_CNTL2_R                                                              0x106f
#define mmCM2_CM_BLNDGAM_RAMA_END_CNTL2_R_BASE_IDX                                                     2
#define mmCM2_CM_BLNDGAM_RAMA_OFFSET_B                                                                 0x1070
#define mmCM2_CM_BLNDGAM_RAMA_OFFSET_B_BASE_IDX                                                        2
#define mmCM2_CM_BLNDGAM_RAMA_OFFSET_G                                                                 0x1071
#define mmCM2_CM_BLNDGAM_RAMA_OFFSET_G_BASE_IDX                                                        2
#define mmCM2_CM_BLNDGAM_RAMA_OFFSET_R                                                                 0x1072
#define mmCM2_CM_BLNDGAM_RAMA_OFFSET_R_BASE_IDX                                                        2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_0_1                                                               0x1073
#define mmCM2_CM_BLNDGAM_RAMA_REGION_0_1_BASE_IDX                                                      2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_2_3                                                               0x1074
#define mmCM2_CM_BLNDGAM_RAMA_REGION_2_3_BASE_IDX                                                      2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_4_5                                                               0x1075
#define mmCM2_CM_BLNDGAM_RAMA_REGION_4_5_BASE_IDX                                                      2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_6_7                                                               0x1076
#define mmCM2_CM_BLNDGAM_RAMA_REGION_6_7_BASE_IDX                                                      2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_8_9                                                               0x1077
#define mmCM2_CM_BLNDGAM_RAMA_REGION_8_9_BASE_IDX                                                      2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_10_11                                                             0x1078
#define mmCM2_CM_BLNDGAM_RAMA_REGION_10_11_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_12_13                                                             0x1079
#define mmCM2_CM_BLNDGAM_RAMA_REGION_12_13_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_14_15                                                             0x107a
#define mmCM2_CM_BLNDGAM_RAMA_REGION_14_15_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_16_17                                                             0x107b
#define mmCM2_CM_BLNDGAM_RAMA_REGION_16_17_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_18_19                                                             0x107c
#define mmCM2_CM_BLNDGAM_RAMA_REGION_18_19_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_20_21                                                             0x107d
#define mmCM2_CM_BLNDGAM_RAMA_REGION_20_21_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_22_23                                                             0x107e
#define mmCM2_CM_BLNDGAM_RAMA_REGION_22_23_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_24_25                                                             0x107f
#define mmCM2_CM_BLNDGAM_RAMA_REGION_24_25_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_26_27                                                             0x1080
#define mmCM2_CM_BLNDGAM_RAMA_REGION_26_27_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_28_29                                                             0x1081
#define mmCM2_CM_BLNDGAM_RAMA_REGION_28_29_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_30_31                                                             0x1082
#define mmCM2_CM_BLNDGAM_RAMA_REGION_30_31_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMA_REGION_32_33                                                             0x1083
#define mmCM2_CM_BLNDGAM_RAMA_REGION_32_33_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_START_CNTL_B                                                             0x1084
#define mmCM2_CM_BLNDGAM_RAMB_START_CNTL_B_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_START_CNTL_G                                                             0x1085
#define mmCM2_CM_BLNDGAM_RAMB_START_CNTL_G_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_START_CNTL_R                                                             0x1086
#define mmCM2_CM_BLNDGAM_RAMB_START_CNTL_R_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_B                                                       0x1087
#define mmCM2_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                              2
#define mmCM2_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_G                                                       0x1088
#define mmCM2_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                              2
#define mmCM2_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_R                                                       0x1089
#define mmCM2_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                              2
#define mmCM2_CM_BLNDGAM_RAMB_START_BASE_CNTL_B                                                        0x108a
#define mmCM2_CM_BLNDGAM_RAMB_START_BASE_CNTL_B_BASE_IDX                                               2
#define mmCM2_CM_BLNDGAM_RAMB_START_BASE_CNTL_G                                                        0x108b
#define mmCM2_CM_BLNDGAM_RAMB_START_BASE_CNTL_G_BASE_IDX                                               2
#define mmCM2_CM_BLNDGAM_RAMB_START_BASE_CNTL_R                                                        0x108c
#define mmCM2_CM_BLNDGAM_RAMB_START_BASE_CNTL_R_BASE_IDX                                               2
#define mmCM2_CM_BLNDGAM_RAMB_END_CNTL1_B                                                              0x108d
#define mmCM2_CM_BLNDGAM_RAMB_END_CNTL1_B_BASE_IDX                                                     2
#define mmCM2_CM_BLNDGAM_RAMB_END_CNTL2_B                                                              0x108e
#define mmCM2_CM_BLNDGAM_RAMB_END_CNTL2_B_BASE_IDX                                                     2
#define mmCM2_CM_BLNDGAM_RAMB_END_CNTL1_G                                                              0x108f
#define mmCM2_CM_BLNDGAM_RAMB_END_CNTL1_G_BASE_IDX                                                     2
#define mmCM2_CM_BLNDGAM_RAMB_END_CNTL2_G                                                              0x1090
#define mmCM2_CM_BLNDGAM_RAMB_END_CNTL2_G_BASE_IDX                                                     2
#define mmCM2_CM_BLNDGAM_RAMB_END_CNTL1_R                                                              0x1091
#define mmCM2_CM_BLNDGAM_RAMB_END_CNTL1_R_BASE_IDX                                                     2
#define mmCM2_CM_BLNDGAM_RAMB_END_CNTL2_R                                                              0x1092
#define mmCM2_CM_BLNDGAM_RAMB_END_CNTL2_R_BASE_IDX                                                     2
#define mmCM2_CM_BLNDGAM_RAMB_OFFSET_B                                                                 0x1093
#define mmCM2_CM_BLNDGAM_RAMB_OFFSET_B_BASE_IDX                                                        2
#define mmCM2_CM_BLNDGAM_RAMB_OFFSET_G                                                                 0x1094
#define mmCM2_CM_BLNDGAM_RAMB_OFFSET_G_BASE_IDX                                                        2
#define mmCM2_CM_BLNDGAM_RAMB_OFFSET_R                                                                 0x1095
#define mmCM2_CM_BLNDGAM_RAMB_OFFSET_R_BASE_IDX                                                        2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_0_1                                                               0x1096
#define mmCM2_CM_BLNDGAM_RAMB_REGION_0_1_BASE_IDX                                                      2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_2_3                                                               0x1097
#define mmCM2_CM_BLNDGAM_RAMB_REGION_2_3_BASE_IDX                                                      2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_4_5                                                               0x1098
#define mmCM2_CM_BLNDGAM_RAMB_REGION_4_5_BASE_IDX                                                      2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_6_7                                                               0x1099
#define mmCM2_CM_BLNDGAM_RAMB_REGION_6_7_BASE_IDX                                                      2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_8_9                                                               0x109a
#define mmCM2_CM_BLNDGAM_RAMB_REGION_8_9_BASE_IDX                                                      2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_10_11                                                             0x109b
#define mmCM2_CM_BLNDGAM_RAMB_REGION_10_11_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_12_13                                                             0x109c
#define mmCM2_CM_BLNDGAM_RAMB_REGION_12_13_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_14_15                                                             0x109d
#define mmCM2_CM_BLNDGAM_RAMB_REGION_14_15_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_16_17                                                             0x109e
#define mmCM2_CM_BLNDGAM_RAMB_REGION_16_17_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_18_19                                                             0x109f
#define mmCM2_CM_BLNDGAM_RAMB_REGION_18_19_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_20_21                                                             0x10a0
#define mmCM2_CM_BLNDGAM_RAMB_REGION_20_21_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_22_23                                                             0x10a1
#define mmCM2_CM_BLNDGAM_RAMB_REGION_22_23_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_24_25                                                             0x10a2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_24_25_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_26_27                                                             0x10a3
#define mmCM2_CM_BLNDGAM_RAMB_REGION_26_27_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_28_29                                                             0x10a4
#define mmCM2_CM_BLNDGAM_RAMB_REGION_28_29_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_30_31                                                             0x10a5
#define mmCM2_CM_BLNDGAM_RAMB_REGION_30_31_BASE_IDX                                                    2
#define mmCM2_CM_BLNDGAM_RAMB_REGION_32_33                                                             0x10a6
#define mmCM2_CM_BLNDGAM_RAMB_REGION_32_33_BASE_IDX                                                    2
#define mmCM2_CM_HDR_MULT_COEF                                                                         0x10a7
#define mmCM2_CM_HDR_MULT_COEF_BASE_IDX                                                                2
#define mmCM2_CM_MEM_PWR_CTRL                                                                          0x10a8
#define mmCM2_CM_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define mmCM2_CM_MEM_PWR_STATUS                                                                        0x10a9
#define mmCM2_CM_MEM_PWR_STATUS_BASE_IDX                                                               2
#define mmCM2_CM_DEALPHA                                                                               0x10ab
#define mmCM2_CM_DEALPHA_BASE_IDX                                                                      2
#define mmCM2_CM_COEF_FORMAT                                                                           0x10ac
#define mmCM2_CM_COEF_FORMAT_BASE_IDX                                                                  2
#define mmCM2_CM_SHAPER_CONTROL                                                                        0x10ad
#define mmCM2_CM_SHAPER_CONTROL_BASE_IDX                                                               2
#define mmCM2_CM_SHAPER_OFFSET_R                                                                       0x10ae
#define mmCM2_CM_SHAPER_OFFSET_R_BASE_IDX                                                              2
#define mmCM2_CM_SHAPER_OFFSET_G                                                                       0x10af
#define mmCM2_CM_SHAPER_OFFSET_G_BASE_IDX                                                              2
#define mmCM2_CM_SHAPER_OFFSET_B                                                                       0x10b0
#define mmCM2_CM_SHAPER_OFFSET_B_BASE_IDX                                                              2
#define mmCM2_CM_SHAPER_SCALE_R                                                                        0x10b1
#define mmCM2_CM_SHAPER_SCALE_R_BASE_IDX                                                               2
#define mmCM2_CM_SHAPER_SCALE_G_B                                                                      0x10b2
#define mmCM2_CM_SHAPER_SCALE_G_B_BASE_IDX                                                             2
#define mmCM2_CM_SHAPER_LUT_INDEX                                                                      0x10b3
#define mmCM2_CM_SHAPER_LUT_INDEX_BASE_IDX                                                             2
#define mmCM2_CM_SHAPER_LUT_DATA                                                                       0x10b4
#define mmCM2_CM_SHAPER_LUT_DATA_BASE_IDX                                                              2
#define mmCM2_CM_SHAPER_LUT_WRITE_EN_MASK                                                              0x10b5
#define mmCM2_CM_SHAPER_LUT_WRITE_EN_MASK_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_START_CNTL_B                                                              0x10b6
#define mmCM2_CM_SHAPER_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_START_CNTL_G                                                              0x10b7
#define mmCM2_CM_SHAPER_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_START_CNTL_R                                                              0x10b8
#define mmCM2_CM_SHAPER_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_END_CNTL_B                                                                0x10b9
#define mmCM2_CM_SHAPER_RAMA_END_CNTL_B_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMA_END_CNTL_G                                                                0x10ba
#define mmCM2_CM_SHAPER_RAMA_END_CNTL_G_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMA_END_CNTL_R                                                                0x10bb
#define mmCM2_CM_SHAPER_RAMA_END_CNTL_R_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMA_REGION_0_1                                                                0x10bc
#define mmCM2_CM_SHAPER_RAMA_REGION_0_1_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMA_REGION_2_3                                                                0x10bd
#define mmCM2_CM_SHAPER_RAMA_REGION_2_3_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMA_REGION_4_5                                                                0x10be
#define mmCM2_CM_SHAPER_RAMA_REGION_4_5_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMA_REGION_6_7                                                                0x10bf
#define mmCM2_CM_SHAPER_RAMA_REGION_6_7_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMA_REGION_8_9                                                                0x10c0
#define mmCM2_CM_SHAPER_RAMA_REGION_8_9_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMA_REGION_10_11                                                              0x10c1
#define mmCM2_CM_SHAPER_RAMA_REGION_10_11_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_REGION_12_13                                                              0x10c2
#define mmCM2_CM_SHAPER_RAMA_REGION_12_13_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_REGION_14_15                                                              0x10c3
#define mmCM2_CM_SHAPER_RAMA_REGION_14_15_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_REGION_16_17                                                              0x10c4
#define mmCM2_CM_SHAPER_RAMA_REGION_16_17_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_REGION_18_19                                                              0x10c5
#define mmCM2_CM_SHAPER_RAMA_REGION_18_19_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_REGION_20_21                                                              0x10c6
#define mmCM2_CM_SHAPER_RAMA_REGION_20_21_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_REGION_22_23                                                              0x10c7
#define mmCM2_CM_SHAPER_RAMA_REGION_22_23_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_REGION_24_25                                                              0x10c8
#define mmCM2_CM_SHAPER_RAMA_REGION_24_25_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_REGION_26_27                                                              0x10c9
#define mmCM2_CM_SHAPER_RAMA_REGION_26_27_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_REGION_28_29                                                              0x10ca
#define mmCM2_CM_SHAPER_RAMA_REGION_28_29_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_REGION_30_31                                                              0x10cb
#define mmCM2_CM_SHAPER_RAMA_REGION_30_31_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMA_REGION_32_33                                                              0x10cc
#define mmCM2_CM_SHAPER_RAMA_REGION_32_33_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_START_CNTL_B                                                              0x10cd
#define mmCM2_CM_SHAPER_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_START_CNTL_G                                                              0x10ce
#define mmCM2_CM_SHAPER_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_START_CNTL_R                                                              0x10cf
#define mmCM2_CM_SHAPER_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_END_CNTL_B                                                                0x10d0
#define mmCM2_CM_SHAPER_RAMB_END_CNTL_B_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMB_END_CNTL_G                                                                0x10d1
#define mmCM2_CM_SHAPER_RAMB_END_CNTL_G_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMB_END_CNTL_R                                                                0x10d2
#define mmCM2_CM_SHAPER_RAMB_END_CNTL_R_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMB_REGION_0_1                                                                0x10d3
#define mmCM2_CM_SHAPER_RAMB_REGION_0_1_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMB_REGION_2_3                                                                0x10d4
#define mmCM2_CM_SHAPER_RAMB_REGION_2_3_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMB_REGION_4_5                                                                0x10d5
#define mmCM2_CM_SHAPER_RAMB_REGION_4_5_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMB_REGION_6_7                                                                0x10d6
#define mmCM2_CM_SHAPER_RAMB_REGION_6_7_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMB_REGION_8_9                                                                0x10d7
#define mmCM2_CM_SHAPER_RAMB_REGION_8_9_BASE_IDX                                                       2
#define mmCM2_CM_SHAPER_RAMB_REGION_10_11                                                              0x10d8
#define mmCM2_CM_SHAPER_RAMB_REGION_10_11_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_REGION_12_13                                                              0x10d9
#define mmCM2_CM_SHAPER_RAMB_REGION_12_13_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_REGION_14_15                                                              0x10da
#define mmCM2_CM_SHAPER_RAMB_REGION_14_15_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_REGION_16_17                                                              0x10db
#define mmCM2_CM_SHAPER_RAMB_REGION_16_17_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_REGION_18_19                                                              0x10dc
#define mmCM2_CM_SHAPER_RAMB_REGION_18_19_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_REGION_20_21                                                              0x10dd
#define mmCM2_CM_SHAPER_RAMB_REGION_20_21_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_REGION_22_23                                                              0x10de
#define mmCM2_CM_SHAPER_RAMB_REGION_22_23_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_REGION_24_25                                                              0x10df
#define mmCM2_CM_SHAPER_RAMB_REGION_24_25_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_REGION_26_27                                                              0x10e0
#define mmCM2_CM_SHAPER_RAMB_REGION_26_27_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_REGION_28_29                                                              0x10e1
#define mmCM2_CM_SHAPER_RAMB_REGION_28_29_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_REGION_30_31                                                              0x10e2
#define mmCM2_CM_SHAPER_RAMB_REGION_30_31_BASE_IDX                                                     2
#define mmCM2_CM_SHAPER_RAMB_REGION_32_33                                                              0x10e3
#define mmCM2_CM_SHAPER_RAMB_REGION_32_33_BASE_IDX                                                     2
#define mmCM2_CM_MEM_PWR_CTRL2                                                                         0x10e4
#define mmCM2_CM_MEM_PWR_CTRL2_BASE_IDX                                                                2
#define mmCM2_CM_MEM_PWR_STATUS2                                                                       0x10e5
#define mmCM2_CM_MEM_PWR_STATUS2_BASE_IDX                                                              2
#define mmCM2_CM_3DLUT_MODE                                                                            0x10e6
#define mmCM2_CM_3DLUT_MODE_BASE_IDX                                                                   2
#define mmCM2_CM_3DLUT_INDEX                                                                           0x10e7
#define mmCM2_CM_3DLUT_INDEX_BASE_IDX                                                                  2
#define mmCM2_CM_3DLUT_DATA                                                                            0x10e8
#define mmCM2_CM_3DLUT_DATA_BASE_IDX                                                                   2
#define mmCM2_CM_3DLUT_DATA_30BIT                                                                      0x10e9
#define mmCM2_CM_3DLUT_DATA_30BIT_BASE_IDX                                                             2
#define mmCM2_CM_3DLUT_READ_WRITE_CONTROL                                                              0x10ea
#define mmCM2_CM_3DLUT_READ_WRITE_CONTROL_BASE_IDX                                                     2
#define mmCM2_CM_3DLUT_OUT_NORM_FACTOR                                                                 0x10eb
#define mmCM2_CM_3DLUT_OUT_NORM_FACTOR_BASE_IDX                                                        2
#define mmCM2_CM_3DLUT_OUT_OFFSET_R                                                                    0x10ec
#define mmCM2_CM_3DLUT_OUT_OFFSET_R_BASE_IDX                                                           2
#define mmCM2_CM_3DLUT_OUT_OFFSET_G                                                                    0x10ed
#define mmCM2_CM_3DLUT_OUT_OFFSET_G_BASE_IDX                                                           2
#define mmCM2_CM_3DLUT_OUT_OFFSET_B                                                                    0x10ee
#define mmCM2_CM_3DLUT_OUT_OFFSET_B_BASE_IDX                                                           2
#define mmCM2_CM_TEST_DEBUG_INDEX                                                                      0x10ef
#define mmCM2_CM_TEST_DEBUG_INDEX_BASE_IDX                                                             2
#define mmCM2_CM_TEST_DEBUG_DATA                                                                       0x10f0
#define mmCM2_CM_TEST_DEBUG_DATA_BASE_IDX                                                              2


// addressBlock: dce_dc_dpp2_dispdec_dpp_dcperfmon_dc_perfmon_dispdec
// base address: 0x43e8
#define mmDC_PERFMON13_PERFCOUNTER_CNTL                                                                0x10fa
#define mmDC_PERFMON13_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON13_PERFCOUNTER_CNTL2                                                               0x10fb
#define mmDC_PERFMON13_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON13_PERFCOUNTER_STATE                                                               0x10fc
#define mmDC_PERFMON13_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON13_PERFMON_CNTL                                                                    0x10fd
#define mmDC_PERFMON13_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON13_PERFMON_CNTL2                                                                   0x10fe
#define mmDC_PERFMON13_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON13_PERFMON_CVALUE_INT_MISC                                                         0x10ff
#define mmDC_PERFMON13_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON13_PERFMON_CVALUE_LOW                                                              0x1100
#define mmDC_PERFMON13_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON13_PERFMON_HI                                                                      0x1101
#define mmDC_PERFMON13_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON13_PERFMON_LOW                                                                     0x1102
#define mmDC_PERFMON13_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dpp3_dispdec_dpp_top_dispdec
// base address: 0x1104
#define mmDPP_TOP3_DPP_CONTROL                                                                         0x1106
#define mmDPP_TOP3_DPP_CONTROL_BASE_IDX                                                                2
#define mmDPP_TOP3_DPP_SOFT_RESET                                                                      0x1107
#define mmDPP_TOP3_DPP_SOFT_RESET_BASE_IDX                                                             2
#define mmDPP_TOP3_DPP_CRC_VAL_R_G                                                                     0x1108
#define mmDPP_TOP3_DPP_CRC_VAL_R_G_BASE_IDX                                                            2
#define mmDPP_TOP3_DPP_CRC_VAL_B_A                                                                     0x1109
#define mmDPP_TOP3_DPP_CRC_VAL_B_A_BASE_IDX                                                            2
#define mmDPP_TOP3_DPP_CRC_CTRL                                                                        0x110a
#define mmDPP_TOP3_DPP_CRC_CTRL_BASE_IDX                                                               2
#define mmDPP_TOP3_HOST_READ_CONTROL                                                                   0x110b
#define mmDPP_TOP3_HOST_READ_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_dpp3_dispdec_cnvc_cfg_dispdec
// base address: 0x1104
#define mmCNVC_CFG3_CNVC_SURFACE_PIXEL_FORMAT                                                          0x1110
#define mmCNVC_CFG3_CNVC_SURFACE_PIXEL_FORMAT_BASE_IDX                                                 2
#define mmCNVC_CFG3_FORMAT_CONTROL                                                                     0x1111
#define mmCNVC_CFG3_FORMAT_CONTROL_BASE_IDX                                                            2
#define mmCNVC_CFG3_FCNV_FP_BIAS_R                                                                     0x1112
#define mmCNVC_CFG3_FCNV_FP_BIAS_R_BASE_IDX                                                            2
#define mmCNVC_CFG3_FCNV_FP_BIAS_G                                                                     0x1113
#define mmCNVC_CFG3_FCNV_FP_BIAS_G_BASE_IDX                                                            2
#define mmCNVC_CFG3_FCNV_FP_BIAS_B                                                                     0x1114
#define mmCNVC_CFG3_FCNV_FP_BIAS_B_BASE_IDX                                                            2
#define mmCNVC_CFG3_FCNV_FP_SCALE_R                                                                    0x1115
#define mmCNVC_CFG3_FCNV_FP_SCALE_R_BASE_IDX                                                           2
#define mmCNVC_CFG3_FCNV_FP_SCALE_G                                                                    0x1116
#define mmCNVC_CFG3_FCNV_FP_SCALE_G_BASE_IDX                                                           2
#define mmCNVC_CFG3_FCNV_FP_SCALE_B                                                                    0x1117
#define mmCNVC_CFG3_FCNV_FP_SCALE_B_BASE_IDX                                                           2
#define mmCNVC_CFG3_COLOR_KEYER_CONTROL                                                                0x1118
#define mmCNVC_CFG3_COLOR_KEYER_CONTROL_BASE_IDX                                                       2
#define mmCNVC_CFG3_COLOR_KEYER_ALPHA                                                                  0x1119
#define mmCNVC_CFG3_COLOR_KEYER_ALPHA_BASE_IDX                                                         2
#define mmCNVC_CFG3_COLOR_KEYER_RED                                                                    0x111a
#define mmCNVC_CFG3_COLOR_KEYER_RED_BASE_IDX                                                           2
#define mmCNVC_CFG3_COLOR_KEYER_GREEN                                                                  0x111b
#define mmCNVC_CFG3_COLOR_KEYER_GREEN_BASE_IDX                                                         2
#define mmCNVC_CFG3_COLOR_KEYER_BLUE                                                                   0x111c
#define mmCNVC_CFG3_COLOR_KEYER_BLUE_BASE_IDX                                                          2
#define mmCNVC_CFG3_ALPHA_2BIT_LUT                                                                     0x111e
#define mmCNVC_CFG3_ALPHA_2BIT_LUT_BASE_IDX                                                            2
#define mmCNVC_CFG3_PRE_DEALPHA                                                                        0x111f
#define mmCNVC_CFG3_PRE_DEALPHA_BASE_IDX                                                               2
#define mmCNVC_CFG3_PRE_CSC_MODE                                                                       0x1120
#define mmCNVC_CFG3_PRE_CSC_MODE_BASE_IDX                                                              2
#define mmCNVC_CFG3_PRE_CSC_C11_C12                                                                    0x1121
#define mmCNVC_CFG3_PRE_CSC_C11_C12_BASE_IDX                                                           2
#define mmCNVC_CFG3_PRE_CSC_C13_C14                                                                    0x1122
#define mmCNVC_CFG3_PRE_CSC_C13_C14_BASE_IDX                                                           2
#define mmCNVC_CFG3_PRE_CSC_C21_C22                                                                    0x1123
#define mmCNVC_CFG3_PRE_CSC_C21_C22_BASE_IDX                                                           2
#define mmCNVC_CFG3_PRE_CSC_C23_C24                                                                    0x1124
#define mmCNVC_CFG3_PRE_CSC_C23_C24_BASE_IDX                                                           2
#define mmCNVC_CFG3_PRE_CSC_C31_C32                                                                    0x1125
#define mmCNVC_CFG3_PRE_CSC_C31_C32_BASE_IDX                                                           2
#define mmCNVC_CFG3_PRE_CSC_C33_C34                                                                    0x1126
#define mmCNVC_CFG3_PRE_CSC_C33_C34_BASE_IDX                                                           2
#define mmCNVC_CFG3_PRE_CSC_B_C11_C12                                                                  0x1127
#define mmCNVC_CFG3_PRE_CSC_B_C11_C12_BASE_IDX                                                         2
#define mmCNVC_CFG3_PRE_CSC_B_C13_C14                                                                  0x1128
#define mmCNVC_CFG3_PRE_CSC_B_C13_C14_BASE_IDX                                                         2
#define mmCNVC_CFG3_PRE_CSC_B_C21_C22                                                                  0x1129
#define mmCNVC_CFG3_PRE_CSC_B_C21_C22_BASE_IDX                                                         2
#define mmCNVC_CFG3_PRE_CSC_B_C23_C24                                                                  0x112a
#define mmCNVC_CFG3_PRE_CSC_B_C23_C24_BASE_IDX                                                         2
#define mmCNVC_CFG3_PRE_CSC_B_C31_C32                                                                  0x112b
#define mmCNVC_CFG3_PRE_CSC_B_C31_C32_BASE_IDX                                                         2
#define mmCNVC_CFG3_PRE_CSC_B_C33_C34                                                                  0x112c
#define mmCNVC_CFG3_PRE_CSC_B_C33_C34_BASE_IDX                                                         2
#define mmCNVC_CFG3_CNVC_COEF_FORMAT                                                                   0x112d
#define mmCNVC_CFG3_CNVC_COEF_FORMAT_BASE_IDX                                                          2
#define mmCNVC_CFG3_PRE_DEGAM                                                                          0x112e
#define mmCNVC_CFG3_PRE_DEGAM_BASE_IDX                                                                 2
#define mmCNVC_CFG3_PRE_REALPHA                                                                        0x112f
#define mmCNVC_CFG3_PRE_REALPHA_BASE_IDX                                                               2


// addressBlock: dce_dc_dpp3_dispdec_cnvc_cur_dispdec
// base address: 0x1104
#define mmCNVC_CUR3_CURSOR0_CONTROL                                                                    0x1132
#define mmCNVC_CUR3_CURSOR0_CONTROL_BASE_IDX                                                           2
#define mmCNVC_CUR3_CURSOR0_COLOR0                                                                     0x1133
#define mmCNVC_CUR3_CURSOR0_COLOR0_BASE_IDX                                                            2
#define mmCNVC_CUR3_CURSOR0_COLOR1                                                                     0x1134
#define mmCNVC_CUR3_CURSOR0_COLOR1_BASE_IDX                                                            2
#define mmCNVC_CUR3_CURSOR0_FP_SCALE_BIAS                                                              0x1135
#define mmCNVC_CUR3_CURSOR0_FP_SCALE_BIAS_BASE_IDX                                                     2


// addressBlock: dce_dc_dpp3_dispdec_dscl_dispdec
// base address: 0x1104
#define mmDSCL3_SCL_COEF_RAM_TAP_SELECT                                                                0x113a
#define mmDSCL3_SCL_COEF_RAM_TAP_SELECT_BASE_IDX                                                       2
#define mmDSCL3_SCL_COEF_RAM_TAP_DATA                                                                  0x113b
#define mmDSCL3_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                         2
#define mmDSCL3_SCL_MODE                                                                               0x113c
#define mmDSCL3_SCL_MODE_BASE_IDX                                                                      2
#define mmDSCL3_SCL_TAP_CONTROL                                                                        0x113d
#define mmDSCL3_SCL_TAP_CONTROL_BASE_IDX                                                               2
#define mmDSCL3_DSCL_CONTROL                                                                           0x113e
#define mmDSCL3_DSCL_CONTROL_BASE_IDX                                                                  2
#define mmDSCL3_DSCL_2TAP_CONTROL                                                                      0x113f
#define mmDSCL3_DSCL_2TAP_CONTROL_BASE_IDX                                                             2
#define mmDSCL3_SCL_MANUAL_REPLICATE_CONTROL                                                           0x1140
#define mmDSCL3_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                  2
#define mmDSCL3_SCL_HORZ_FILTER_SCALE_RATIO                                                            0x1141
#define mmDSCL3_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define mmDSCL3_SCL_HORZ_FILTER_INIT                                                                   0x1142
#define mmDSCL3_SCL_HORZ_FILTER_INIT_BASE_IDX                                                          2
#define mmDSCL3_SCL_HORZ_FILTER_SCALE_RATIO_C                                                          0x1143
#define mmDSCL3_SCL_HORZ_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define mmDSCL3_SCL_HORZ_FILTER_INIT_C                                                                 0x1144
#define mmDSCL3_SCL_HORZ_FILTER_INIT_C_BASE_IDX                                                        2
#define mmDSCL3_SCL_VERT_FILTER_SCALE_RATIO                                                            0x1145
#define mmDSCL3_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define mmDSCL3_SCL_VERT_FILTER_INIT                                                                   0x1146
#define mmDSCL3_SCL_VERT_FILTER_INIT_BASE_IDX                                                          2
#define mmDSCL3_SCL_VERT_FILTER_INIT_BOT                                                               0x1147
#define mmDSCL3_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                      2
#define mmDSCL3_SCL_VERT_FILTER_SCALE_RATIO_C                                                          0x1148
#define mmDSCL3_SCL_VERT_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define mmDSCL3_SCL_VERT_FILTER_INIT_C                                                                 0x1149
#define mmDSCL3_SCL_VERT_FILTER_INIT_C_BASE_IDX                                                        2
#define mmDSCL3_SCL_VERT_FILTER_INIT_BOT_C                                                             0x114a
#define mmDSCL3_SCL_VERT_FILTER_INIT_BOT_C_BASE_IDX                                                    2
#define mmDSCL3_SCL_BLACK_COLOR                                                                        0x114b
#define mmDSCL3_SCL_BLACK_COLOR_BASE_IDX                                                               2
#define mmDSCL3_DSCL_UPDATE                                                                            0x114c
#define mmDSCL3_DSCL_UPDATE_BASE_IDX                                                                   2
#define mmDSCL3_DSCL_AUTOCAL                                                                           0x114d
#define mmDSCL3_DSCL_AUTOCAL_BASE_IDX                                                                  2
#define mmDSCL3_DSCL_EXT_OVERSCAN_LEFT_RIGHT                                                           0x114e
#define mmDSCL3_DSCL_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                  2
#define mmDSCL3_DSCL_EXT_OVERSCAN_TOP_BOTTOM                                                           0x114f
#define mmDSCL3_DSCL_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                  2
#define mmDSCL3_OTG_H_BLANK                                                                            0x1150
#define mmDSCL3_OTG_H_BLANK_BASE_IDX                                                                   2
#define mmDSCL3_OTG_V_BLANK                                                                            0x1151
#define mmDSCL3_OTG_V_BLANK_BASE_IDX                                                                   2
#define mmDSCL3_RECOUT_START                                                                           0x1152
#define mmDSCL3_RECOUT_START_BASE_IDX                                                                  2
#define mmDSCL3_RECOUT_SIZE                                                                            0x1153
#define mmDSCL3_RECOUT_SIZE_BASE_IDX                                                                   2
#define mmDSCL3_MPC_SIZE                                                                               0x1154
#define mmDSCL3_MPC_SIZE_BASE_IDX                                                                      2
#define mmDSCL3_LB_DATA_FORMAT                                                                         0x1155
#define mmDSCL3_LB_DATA_FORMAT_BASE_IDX                                                                2
#define mmDSCL3_LB_MEMORY_CTRL                                                                         0x1156
#define mmDSCL3_LB_MEMORY_CTRL_BASE_IDX                                                                2
#define mmDSCL3_LB_V_COUNTER                                                                           0x1157
#define mmDSCL3_LB_V_COUNTER_BASE_IDX                                                                  2
#define mmDSCL3_DSCL_MEM_PWR_CTRL                                                                      0x1158
#define mmDSCL3_DSCL_MEM_PWR_CTRL_BASE_IDX                                                             2
#define mmDSCL3_DSCL_MEM_PWR_STATUS                                                                    0x1159
#define mmDSCL3_DSCL_MEM_PWR_STATUS_BASE_IDX                                                           2
#define mmDSCL3_OBUF_CONTROL                                                                           0x115a
#define mmDSCL3_OBUF_CONTROL_BASE_IDX                                                                  2
#define mmDSCL3_OBUF_MEM_PWR_CTRL                                                                      0x115b
#define mmDSCL3_OBUF_MEM_PWR_CTRL_BASE_IDX                                                             2


// addressBlock: dce_dc_dpp3_dispdec_cm_dispdec
// base address: 0x1104
#define mmCM3_CM_CONTROL                                                                               0x1161
#define mmCM3_CM_CONTROL_BASE_IDX                                                                      2
#define mmCM3_CM_POST_CSC_CONTROL                                                                      0x1162
#define mmCM3_CM_POST_CSC_CONTROL_BASE_IDX                                                             2
#define mmCM3_CM_POST_CSC_C11_C12                                                                      0x1163
#define mmCM3_CM_POST_CSC_C11_C12_BASE_IDX                                                             2
#define mmCM3_CM_POST_CSC_C13_C14                                                                      0x1164
#define mmCM3_CM_POST_CSC_C13_C14_BASE_IDX                                                             2
#define mmCM3_CM_POST_CSC_C21_C22                                                                      0x1165
#define mmCM3_CM_POST_CSC_C21_C22_BASE_IDX                                                             2
#define mmCM3_CM_POST_CSC_C23_C24                                                                      0x1166
#define mmCM3_CM_POST_CSC_C23_C24_BASE_IDX                                                             2
#define mmCM3_CM_POST_CSC_C31_C32                                                                      0x1167
#define mmCM3_CM_POST_CSC_C31_C32_BASE_IDX                                                             2
#define mmCM3_CM_POST_CSC_C33_C34                                                                      0x1168
#define mmCM3_CM_POST_CSC_C33_C34_BASE_IDX                                                             2
#define mmCM3_CM_POST_CSC_B_C11_C12                                                                    0x1169
#define mmCM3_CM_POST_CSC_B_C11_C12_BASE_IDX                                                           2
#define mmCM3_CM_POST_CSC_B_C13_C14                                                                    0x116a
#define mmCM3_CM_POST_CSC_B_C13_C14_BASE_IDX                                                           2
#define mmCM3_CM_POST_CSC_B_C21_C22                                                                    0x116b
#define mmCM3_CM_POST_CSC_B_C21_C22_BASE_IDX                                                           2
#define mmCM3_CM_POST_CSC_B_C23_C24                                                                    0x116c
#define mmCM3_CM_POST_CSC_B_C23_C24_BASE_IDX                                                           2
#define mmCM3_CM_POST_CSC_B_C31_C32                                                                    0x116d
#define mmCM3_CM_POST_CSC_B_C31_C32_BASE_IDX                                                           2
#define mmCM3_CM_POST_CSC_B_C33_C34                                                                    0x116e
#define mmCM3_CM_POST_CSC_B_C33_C34_BASE_IDX                                                           2
#define mmCM3_CM_GAMUT_REMAP_CONTROL                                                                   0x116f
#define mmCM3_CM_GAMUT_REMAP_CONTROL_BASE_IDX                                                          2
#define mmCM3_CM_GAMUT_REMAP_C11_C12                                                                   0x1170
#define mmCM3_CM_GAMUT_REMAP_C11_C12_BASE_IDX                                                          2
#define mmCM3_CM_GAMUT_REMAP_C13_C14                                                                   0x1171
#define mmCM3_CM_GAMUT_REMAP_C13_C14_BASE_IDX                                                          2
#define mmCM3_CM_GAMUT_REMAP_C21_C22                                                                   0x1172
#define mmCM3_CM_GAMUT_REMAP_C21_C22_BASE_IDX                                                          2
#define mmCM3_CM_GAMUT_REMAP_C23_C24                                                                   0x1173
#define mmCM3_CM_GAMUT_REMAP_C23_C24_BASE_IDX                                                          2
#define mmCM3_CM_GAMUT_REMAP_C31_C32                                                                   0x1174
#define mmCM3_CM_GAMUT_REMAP_C31_C32_BASE_IDX                                                          2
#define mmCM3_CM_GAMUT_REMAP_C33_C34                                                                   0x1175
#define mmCM3_CM_GAMUT_REMAP_C33_C34_BASE_IDX                                                          2
#define mmCM3_CM_GAMUT_REMAP_B_C11_C12                                                                 0x1176
#define mmCM3_CM_GAMUT_REMAP_B_C11_C12_BASE_IDX                                                        2
#define mmCM3_CM_GAMUT_REMAP_B_C13_C14                                                                 0x1177
#define mmCM3_CM_GAMUT_REMAP_B_C13_C14_BASE_IDX                                                        2
#define mmCM3_CM_GAMUT_REMAP_B_C21_C22                                                                 0x1178
#define mmCM3_CM_GAMUT_REMAP_B_C21_C22_BASE_IDX                                                        2
#define mmCM3_CM_GAMUT_REMAP_B_C23_C24                                                                 0x1179
#define mmCM3_CM_GAMUT_REMAP_B_C23_C24_BASE_IDX                                                        2
#define mmCM3_CM_GAMUT_REMAP_B_C31_C32                                                                 0x117a
#define mmCM3_CM_GAMUT_REMAP_B_C31_C32_BASE_IDX                                                        2
#define mmCM3_CM_GAMUT_REMAP_B_C33_C34                                                                 0x117b
#define mmCM3_CM_GAMUT_REMAP_B_C33_C34_BASE_IDX                                                        2
#define mmCM3_CM_BIAS_CR_R                                                                             0x117c
#define mmCM3_CM_BIAS_CR_R_BASE_IDX                                                                    2
#define mmCM3_CM_BIAS_Y_G_CB_B                                                                         0x117d
#define mmCM3_CM_BIAS_Y_G_CB_B_BASE_IDX                                                                2
#define mmCM3_CM_GAMCOR_CONTROL                                                                        0x117e
#define mmCM3_CM_GAMCOR_CONTROL_BASE_IDX                                                               2
#define mmCM3_CM_GAMCOR_LUT_INDEX                                                                      0x117f
#define mmCM3_CM_GAMCOR_LUT_INDEX_BASE_IDX                                                             2
#define mmCM3_CM_GAMCOR_LUT_DATA                                                                       0x1180
#define mmCM3_CM_GAMCOR_LUT_DATA_BASE_IDX                                                              2
#define mmCM3_CM_GAMCOR_LUT_CONTROL                                                                    0x1181
#define mmCM3_CM_GAMCOR_LUT_CONTROL_BASE_IDX                                                           2
#define mmCM3_CM_GAMCOR_RAMA_START_CNTL_B                                                              0x1182
#define mmCM3_CM_GAMCOR_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMA_START_CNTL_G                                                              0x1183
#define mmCM3_CM_GAMCOR_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMA_START_CNTL_R                                                              0x1184
#define mmCM3_CM_GAMCOR_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B                                                        0x1185
#define mmCM3_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define mmCM3_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G                                                        0x1186
#define mmCM3_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define mmCM3_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R                                                        0x1187
#define mmCM3_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define mmCM3_CM_GAMCOR_RAMA_START_BASE_CNTL_B                                                         0x1188
#define mmCM3_CM_GAMCOR_RAMA_START_BASE_CNTL_B_BASE_IDX                                                2
#define mmCM3_CM_GAMCOR_RAMA_START_BASE_CNTL_G                                                         0x1189
#define mmCM3_CM_GAMCOR_RAMA_START_BASE_CNTL_G_BASE_IDX                                                2
#define mmCM3_CM_GAMCOR_RAMA_START_BASE_CNTL_R                                                         0x118a
#define mmCM3_CM_GAMCOR_RAMA_START_BASE_CNTL_R_BASE_IDX                                                2
#define mmCM3_CM_GAMCOR_RAMA_END_CNTL1_B                                                               0x118b
#define mmCM3_CM_GAMCOR_RAMA_END_CNTL1_B_BASE_IDX                                                      2
#define mmCM3_CM_GAMCOR_RAMA_END_CNTL2_B                                                               0x118c
#define mmCM3_CM_GAMCOR_RAMA_END_CNTL2_B_BASE_IDX                                                      2
#define mmCM3_CM_GAMCOR_RAMA_END_CNTL1_G                                                               0x118d
#define mmCM3_CM_GAMCOR_RAMA_END_CNTL1_G_BASE_IDX                                                      2
#define mmCM3_CM_GAMCOR_RAMA_END_CNTL2_G                                                               0x118e
#define mmCM3_CM_GAMCOR_RAMA_END_CNTL2_G_BASE_IDX                                                      2
#define mmCM3_CM_GAMCOR_RAMA_END_CNTL1_R                                                               0x118f
#define mmCM3_CM_GAMCOR_RAMA_END_CNTL1_R_BASE_IDX                                                      2
#define mmCM3_CM_GAMCOR_RAMA_END_CNTL2_R                                                               0x1190
#define mmCM3_CM_GAMCOR_RAMA_END_CNTL2_R_BASE_IDX                                                      2
#define mmCM3_CM_GAMCOR_RAMA_OFFSET_B                                                                  0x1191
#define mmCM3_CM_GAMCOR_RAMA_OFFSET_B_BASE_IDX                                                         2
#define mmCM3_CM_GAMCOR_RAMA_OFFSET_G                                                                  0x1192
#define mmCM3_CM_GAMCOR_RAMA_OFFSET_G_BASE_IDX                                                         2
#define mmCM3_CM_GAMCOR_RAMA_OFFSET_R                                                                  0x1193
#define mmCM3_CM_GAMCOR_RAMA_OFFSET_R_BASE_IDX                                                         2
#define mmCM3_CM_GAMCOR_RAMA_REGION_0_1                                                                0x1194
#define mmCM3_CM_GAMCOR_RAMA_REGION_0_1_BASE_IDX                                                       2
#define mmCM3_CM_GAMCOR_RAMA_REGION_2_3                                                                0x1195
#define mmCM3_CM_GAMCOR_RAMA_REGION_2_3_BASE_IDX                                                       2
#define mmCM3_CM_GAMCOR_RAMA_REGION_4_5                                                                0x1196
#define mmCM3_CM_GAMCOR_RAMA_REGION_4_5_BASE_IDX                                                       2
#define mmCM3_CM_GAMCOR_RAMA_REGION_6_7                                                                0x1197
#define mmCM3_CM_GAMCOR_RAMA_REGION_6_7_BASE_IDX                                                       2
#define mmCM3_CM_GAMCOR_RAMA_REGION_8_9                                                                0x1198
#define mmCM3_CM_GAMCOR_RAMA_REGION_8_9_BASE_IDX                                                       2
#define mmCM3_CM_GAMCOR_RAMA_REGION_10_11                                                              0x1199
#define mmCM3_CM_GAMCOR_RAMA_REGION_10_11_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMA_REGION_12_13                                                              0x119a
#define mmCM3_CM_GAMCOR_RAMA_REGION_12_13_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMA_REGION_14_15                                                              0x119b
#define mmCM3_CM_GAMCOR_RAMA_REGION_14_15_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMA_REGION_16_17                                                              0x119c
#define mmCM3_CM_GAMCOR_RAMA_REGION_16_17_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMA_REGION_18_19                                                              0x119d
#define mmCM3_CM_GAMCOR_RAMA_REGION_18_19_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMA_REGION_20_21                                                              0x119e
#define mmCM3_CM_GAMCOR_RAMA_REGION_20_21_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMA_REGION_22_23                                                              0x119f
#define mmCM3_CM_GAMCOR_RAMA_REGION_22_23_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMA_REGION_24_25                                                              0x11a0
#define mmCM3_CM_GAMCOR_RAMA_REGION_24_25_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMA_REGION_26_27                                                              0x11a1
#define mmCM3_CM_GAMCOR_RAMA_REGION_26_27_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMA_REGION_28_29                                                              0x11a2
#define mmCM3_CM_GAMCOR_RAMA_REGION_28_29_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMA_REGION_30_31                                                              0x11a3
#define mmCM3_CM_GAMCOR_RAMA_REGION_30_31_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMA_REGION_32_33                                                              0x11a4
#define mmCM3_CM_GAMCOR_RAMA_REGION_32_33_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_START_CNTL_B                                                              0x11a5
#define mmCM3_CM_GAMCOR_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_START_CNTL_G                                                              0x11a6
#define mmCM3_CM_GAMCOR_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_START_CNTL_R                                                              0x11a7
#define mmCM3_CM_GAMCOR_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B                                                        0x11a8
#define mmCM3_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define mmCM3_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G                                                        0x11a9
#define mmCM3_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define mmCM3_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R                                                        0x11aa
#define mmCM3_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define mmCM3_CM_GAMCOR_RAMB_START_BASE_CNTL_B                                                         0x11ab
#define mmCM3_CM_GAMCOR_RAMB_START_BASE_CNTL_B_BASE_IDX                                                2
#define mmCM3_CM_GAMCOR_RAMB_START_BASE_CNTL_G                                                         0x11ac
#define mmCM3_CM_GAMCOR_RAMB_START_BASE_CNTL_G_BASE_IDX                                                2
#define mmCM3_CM_GAMCOR_RAMB_START_BASE_CNTL_R                                                         0x11ad
#define mmCM3_CM_GAMCOR_RAMB_START_BASE_CNTL_R_BASE_IDX                                                2
#define mmCM3_CM_GAMCOR_RAMB_END_CNTL1_B                                                               0x11ae
#define mmCM3_CM_GAMCOR_RAMB_END_CNTL1_B_BASE_IDX                                                      2
#define mmCM3_CM_GAMCOR_RAMB_END_CNTL2_B                                                               0x11af
#define mmCM3_CM_GAMCOR_RAMB_END_CNTL2_B_BASE_IDX                                                      2
#define mmCM3_CM_GAMCOR_RAMB_END_CNTL1_G                                                               0x11b0
#define mmCM3_CM_GAMCOR_RAMB_END_CNTL1_G_BASE_IDX                                                      2
#define mmCM3_CM_GAMCOR_RAMB_END_CNTL2_G                                                               0x11b1
#define mmCM3_CM_GAMCOR_RAMB_END_CNTL2_G_BASE_IDX                                                      2
#define mmCM3_CM_GAMCOR_RAMB_END_CNTL1_R                                                               0x11b2
#define mmCM3_CM_GAMCOR_RAMB_END_CNTL1_R_BASE_IDX                                                      2
#define mmCM3_CM_GAMCOR_RAMB_END_CNTL2_R                                                               0x11b3
#define mmCM3_CM_GAMCOR_RAMB_END_CNTL2_R_BASE_IDX                                                      2
#define mmCM3_CM_GAMCOR_RAMB_OFFSET_B                                                                  0x11b4
#define mmCM3_CM_GAMCOR_RAMB_OFFSET_B_BASE_IDX                                                         2
#define mmCM3_CM_GAMCOR_RAMB_OFFSET_G                                                                  0x11b5
#define mmCM3_CM_GAMCOR_RAMB_OFFSET_G_BASE_IDX                                                         2
#define mmCM3_CM_GAMCOR_RAMB_OFFSET_R                                                                  0x11b6
#define mmCM3_CM_GAMCOR_RAMB_OFFSET_R_BASE_IDX                                                         2
#define mmCM3_CM_GAMCOR_RAMB_REGION_0_1                                                                0x11b7
#define mmCM3_CM_GAMCOR_RAMB_REGION_0_1_BASE_IDX                                                       2
#define mmCM3_CM_GAMCOR_RAMB_REGION_2_3                                                                0x11b8
#define mmCM3_CM_GAMCOR_RAMB_REGION_2_3_BASE_IDX                                                       2
#define mmCM3_CM_GAMCOR_RAMB_REGION_4_5                                                                0x11b9
#define mmCM3_CM_GAMCOR_RAMB_REGION_4_5_BASE_IDX                                                       2
#define mmCM3_CM_GAMCOR_RAMB_REGION_6_7                                                                0x11ba
#define mmCM3_CM_GAMCOR_RAMB_REGION_6_7_BASE_IDX                                                       2
#define mmCM3_CM_GAMCOR_RAMB_REGION_8_9                                                                0x11bb
#define mmCM3_CM_GAMCOR_RAMB_REGION_8_9_BASE_IDX                                                       2
#define mmCM3_CM_GAMCOR_RAMB_REGION_10_11                                                              0x11bc
#define mmCM3_CM_GAMCOR_RAMB_REGION_10_11_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_REGION_12_13                                                              0x11bd
#define mmCM3_CM_GAMCOR_RAMB_REGION_12_13_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_REGION_14_15                                                              0x11be
#define mmCM3_CM_GAMCOR_RAMB_REGION_14_15_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_REGION_16_17                                                              0x11bf
#define mmCM3_CM_GAMCOR_RAMB_REGION_16_17_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_REGION_18_19                                                              0x11c0
#define mmCM3_CM_GAMCOR_RAMB_REGION_18_19_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_REGION_20_21                                                              0x11c1
#define mmCM3_CM_GAMCOR_RAMB_REGION_20_21_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_REGION_22_23                                                              0x11c2
#define mmCM3_CM_GAMCOR_RAMB_REGION_22_23_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_REGION_24_25                                                              0x11c3
#define mmCM3_CM_GAMCOR_RAMB_REGION_24_25_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_REGION_26_27                                                              0x11c4
#define mmCM3_CM_GAMCOR_RAMB_REGION_26_27_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_REGION_28_29                                                              0x11c5
#define mmCM3_CM_GAMCOR_RAMB_REGION_28_29_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_REGION_30_31                                                              0x11c6
#define mmCM3_CM_GAMCOR_RAMB_REGION_30_31_BASE_IDX                                                     2
#define mmCM3_CM_GAMCOR_RAMB_REGION_32_33                                                              0x11c7
#define mmCM3_CM_GAMCOR_RAMB_REGION_32_33_BASE_IDX                                                     2
#define mmCM3_CM_BLNDGAM_CONTROL                                                                       0x11c8
#define mmCM3_CM_BLNDGAM_CONTROL_BASE_IDX                                                              2
#define mmCM3_CM_BLNDGAM_LUT_INDEX                                                                     0x11c9
#define mmCM3_CM_BLNDGAM_LUT_INDEX_BASE_IDX                                                            2
#define mmCM3_CM_BLNDGAM_LUT_DATA                                                                      0x11ca
#define mmCM3_CM_BLNDGAM_LUT_DATA_BASE_IDX                                                             2
#define mmCM3_CM_BLNDGAM_LUT_CONTROL                                                                   0x11cb
#define mmCM3_CM_BLNDGAM_LUT_CONTROL_BASE_IDX                                                          2
#define mmCM3_CM_BLNDGAM_RAMA_START_CNTL_B                                                             0x11cc
#define mmCM3_CM_BLNDGAM_RAMA_START_CNTL_B_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMA_START_CNTL_G                                                             0x11cd
#define mmCM3_CM_BLNDGAM_RAMA_START_CNTL_G_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMA_START_CNTL_R                                                             0x11ce
#define mmCM3_CM_BLNDGAM_RAMA_START_CNTL_R_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_B                                                       0x11cf
#define mmCM3_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                              2
#define mmCM3_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_G                                                       0x11d0
#define mmCM3_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                              2
#define mmCM3_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_R                                                       0x11d1
#define mmCM3_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                              2
#define mmCM3_CM_BLNDGAM_RAMA_START_BASE_CNTL_B                                                        0x11d2
#define mmCM3_CM_BLNDGAM_RAMA_START_BASE_CNTL_B_BASE_IDX                                               2
#define mmCM3_CM_BLNDGAM_RAMA_START_BASE_CNTL_G                                                        0x11d3
#define mmCM3_CM_BLNDGAM_RAMA_START_BASE_CNTL_G_BASE_IDX                                               2
#define mmCM3_CM_BLNDGAM_RAMA_START_BASE_CNTL_R                                                        0x11d4
#define mmCM3_CM_BLNDGAM_RAMA_START_BASE_CNTL_R_BASE_IDX                                               2
#define mmCM3_CM_BLNDGAM_RAMA_END_CNTL1_B                                                              0x11d5
#define mmCM3_CM_BLNDGAM_RAMA_END_CNTL1_B_BASE_IDX                                                     2
#define mmCM3_CM_BLNDGAM_RAMA_END_CNTL2_B                                                              0x11d6
#define mmCM3_CM_BLNDGAM_RAMA_END_CNTL2_B_BASE_IDX                                                     2
#define mmCM3_CM_BLNDGAM_RAMA_END_CNTL1_G                                                              0x11d7
#define mmCM3_CM_BLNDGAM_RAMA_END_CNTL1_G_BASE_IDX                                                     2
#define mmCM3_CM_BLNDGAM_RAMA_END_CNTL2_G                                                              0x11d8
#define mmCM3_CM_BLNDGAM_RAMA_END_CNTL2_G_BASE_IDX                                                     2
#define mmCM3_CM_BLNDGAM_RAMA_END_CNTL1_R                                                              0x11d9
#define mmCM3_CM_BLNDGAM_RAMA_END_CNTL1_R_BASE_IDX                                                     2
#define mmCM3_CM_BLNDGAM_RAMA_END_CNTL2_R                                                              0x11da
#define mmCM3_CM_BLNDGAM_RAMA_END_CNTL2_R_BASE_IDX                                                     2
#define mmCM3_CM_BLNDGAM_RAMA_OFFSET_B                                                                 0x11db
#define mmCM3_CM_BLNDGAM_RAMA_OFFSET_B_BASE_IDX                                                        2
#define mmCM3_CM_BLNDGAM_RAMA_OFFSET_G                                                                 0x11dc
#define mmCM3_CM_BLNDGAM_RAMA_OFFSET_G_BASE_IDX                                                        2
#define mmCM3_CM_BLNDGAM_RAMA_OFFSET_R                                                                 0x11dd
#define mmCM3_CM_BLNDGAM_RAMA_OFFSET_R_BASE_IDX                                                        2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_0_1                                                               0x11de
#define mmCM3_CM_BLNDGAM_RAMA_REGION_0_1_BASE_IDX                                                      2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_2_3                                                               0x11df
#define mmCM3_CM_BLNDGAM_RAMA_REGION_2_3_BASE_IDX                                                      2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_4_5                                                               0x11e0
#define mmCM3_CM_BLNDGAM_RAMA_REGION_4_5_BASE_IDX                                                      2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_6_7                                                               0x11e1
#define mmCM3_CM_BLNDGAM_RAMA_REGION_6_7_BASE_IDX                                                      2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_8_9                                                               0x11e2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_8_9_BASE_IDX                                                      2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_10_11                                                             0x11e3
#define mmCM3_CM_BLNDGAM_RAMA_REGION_10_11_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_12_13                                                             0x11e4
#define mmCM3_CM_BLNDGAM_RAMA_REGION_12_13_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_14_15                                                             0x11e5
#define mmCM3_CM_BLNDGAM_RAMA_REGION_14_15_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_16_17                                                             0x11e6
#define mmCM3_CM_BLNDGAM_RAMA_REGION_16_17_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_18_19                                                             0x11e7
#define mmCM3_CM_BLNDGAM_RAMA_REGION_18_19_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_20_21                                                             0x11e8
#define mmCM3_CM_BLNDGAM_RAMA_REGION_20_21_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_22_23                                                             0x11e9
#define mmCM3_CM_BLNDGAM_RAMA_REGION_22_23_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_24_25                                                             0x11ea
#define mmCM3_CM_BLNDGAM_RAMA_REGION_24_25_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_26_27                                                             0x11eb
#define mmCM3_CM_BLNDGAM_RAMA_REGION_26_27_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_28_29                                                             0x11ec
#define mmCM3_CM_BLNDGAM_RAMA_REGION_28_29_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_30_31                                                             0x11ed
#define mmCM3_CM_BLNDGAM_RAMA_REGION_30_31_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMA_REGION_32_33                                                             0x11ee
#define mmCM3_CM_BLNDGAM_RAMA_REGION_32_33_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_START_CNTL_B                                                             0x11ef
#define mmCM3_CM_BLNDGAM_RAMB_START_CNTL_B_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_START_CNTL_G                                                             0x11f0
#define mmCM3_CM_BLNDGAM_RAMB_START_CNTL_G_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_START_CNTL_R                                                             0x11f1
#define mmCM3_CM_BLNDGAM_RAMB_START_CNTL_R_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_B                                                       0x11f2
#define mmCM3_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                              2
#define mmCM3_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_G                                                       0x11f3
#define mmCM3_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                              2
#define mmCM3_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_R                                                       0x11f4
#define mmCM3_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                              2
#define mmCM3_CM_BLNDGAM_RAMB_START_BASE_CNTL_B                                                        0x11f5
#define mmCM3_CM_BLNDGAM_RAMB_START_BASE_CNTL_B_BASE_IDX                                               2
#define mmCM3_CM_BLNDGAM_RAMB_START_BASE_CNTL_G                                                        0x11f6
#define mmCM3_CM_BLNDGAM_RAMB_START_BASE_CNTL_G_BASE_IDX                                               2
#define mmCM3_CM_BLNDGAM_RAMB_START_BASE_CNTL_R                                                        0x11f7
#define mmCM3_CM_BLNDGAM_RAMB_START_BASE_CNTL_R_BASE_IDX                                               2
#define mmCM3_CM_BLNDGAM_RAMB_END_CNTL1_B                                                              0x11f8
#define mmCM3_CM_BLNDGAM_RAMB_END_CNTL1_B_BASE_IDX                                                     2
#define mmCM3_CM_BLNDGAM_RAMB_END_CNTL2_B                                                              0x11f9
#define mmCM3_CM_BLNDGAM_RAMB_END_CNTL2_B_BASE_IDX                                                     2
#define mmCM3_CM_BLNDGAM_RAMB_END_CNTL1_G                                                              0x11fa
#define mmCM3_CM_BLNDGAM_RAMB_END_CNTL1_G_BASE_IDX                                                     2
#define mmCM3_CM_BLNDGAM_RAMB_END_CNTL2_G                                                              0x11fb
#define mmCM3_CM_BLNDGAM_RAMB_END_CNTL2_G_BASE_IDX                                                     2
#define mmCM3_CM_BLNDGAM_RAMB_END_CNTL1_R                                                              0x11fc
#define mmCM3_CM_BLNDGAM_RAMB_END_CNTL1_R_BASE_IDX                                                     2
#define mmCM3_CM_BLNDGAM_RAMB_END_CNTL2_R                                                              0x11fd
#define mmCM3_CM_BLNDGAM_RAMB_END_CNTL2_R_BASE_IDX                                                     2
#define mmCM3_CM_BLNDGAM_RAMB_OFFSET_B                                                                 0x11fe
#define mmCM3_CM_BLNDGAM_RAMB_OFFSET_B_BASE_IDX                                                        2
#define mmCM3_CM_BLNDGAM_RAMB_OFFSET_G                                                                 0x11ff
#define mmCM3_CM_BLNDGAM_RAMB_OFFSET_G_BASE_IDX                                                        2
#define mmCM3_CM_BLNDGAM_RAMB_OFFSET_R                                                                 0x1200
#define mmCM3_CM_BLNDGAM_RAMB_OFFSET_R_BASE_IDX                                                        2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_0_1                                                               0x1201
#define mmCM3_CM_BLNDGAM_RAMB_REGION_0_1_BASE_IDX                                                      2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_2_3                                                               0x1202
#define mmCM3_CM_BLNDGAM_RAMB_REGION_2_3_BASE_IDX                                                      2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_4_5                                                               0x1203
#define mmCM3_CM_BLNDGAM_RAMB_REGION_4_5_BASE_IDX                                                      2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_6_7                                                               0x1204
#define mmCM3_CM_BLNDGAM_RAMB_REGION_6_7_BASE_IDX                                                      2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_8_9                                                               0x1205
#define mmCM3_CM_BLNDGAM_RAMB_REGION_8_9_BASE_IDX                                                      2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_10_11                                                             0x1206
#define mmCM3_CM_BLNDGAM_RAMB_REGION_10_11_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_12_13                                                             0x1207
#define mmCM3_CM_BLNDGAM_RAMB_REGION_12_13_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_14_15                                                             0x1208
#define mmCM3_CM_BLNDGAM_RAMB_REGION_14_15_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_16_17                                                             0x1209
#define mmCM3_CM_BLNDGAM_RAMB_REGION_16_17_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_18_19                                                             0x120a
#define mmCM3_CM_BLNDGAM_RAMB_REGION_18_19_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_20_21                                                             0x120b
#define mmCM3_CM_BLNDGAM_RAMB_REGION_20_21_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_22_23                                                             0x120c
#define mmCM3_CM_BLNDGAM_RAMB_REGION_22_23_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_24_25                                                             0x120d
#define mmCM3_CM_BLNDGAM_RAMB_REGION_24_25_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_26_27                                                             0x120e
#define mmCM3_CM_BLNDGAM_RAMB_REGION_26_27_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_28_29                                                             0x120f
#define mmCM3_CM_BLNDGAM_RAMB_REGION_28_29_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_30_31                                                             0x1210
#define mmCM3_CM_BLNDGAM_RAMB_REGION_30_31_BASE_IDX                                                    2
#define mmCM3_CM_BLNDGAM_RAMB_REGION_32_33                                                             0x1211
#define mmCM3_CM_BLNDGAM_RAMB_REGION_32_33_BASE_IDX                                                    2
#define mmCM3_CM_HDR_MULT_COEF                                                                         0x1212
#define mmCM3_CM_HDR_MULT_COEF_BASE_IDX                                                                2
#define mmCM3_CM_MEM_PWR_CTRL                                                                          0x1213
#define mmCM3_CM_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define mmCM3_CM_MEM_PWR_STATUS                                                                        0x1214
#define mmCM3_CM_MEM_PWR_STATUS_BASE_IDX                                                               2
#define mmCM3_CM_DEALPHA                                                                               0x1216
#define mmCM3_CM_DEALPHA_BASE_IDX                                                                      2
#define mmCM3_CM_COEF_FORMAT                                                                           0x1217
#define mmCM3_CM_COEF_FORMAT_BASE_IDX                                                                  2
#define mmCM3_CM_SHAPER_CONTROL                                                                        0x1218
#define mmCM3_CM_SHAPER_CONTROL_BASE_IDX                                                               2
#define mmCM3_CM_SHAPER_OFFSET_R                                                                       0x1219
#define mmCM3_CM_SHAPER_OFFSET_R_BASE_IDX                                                              2
#define mmCM3_CM_SHAPER_OFFSET_G                                                                       0x121a
#define mmCM3_CM_SHAPER_OFFSET_G_BASE_IDX                                                              2
#define mmCM3_CM_SHAPER_OFFSET_B                                                                       0x121b
#define mmCM3_CM_SHAPER_OFFSET_B_BASE_IDX                                                              2
#define mmCM3_CM_SHAPER_SCALE_R                                                                        0x121c
#define mmCM3_CM_SHAPER_SCALE_R_BASE_IDX                                                               2
#define mmCM3_CM_SHAPER_SCALE_G_B                                                                      0x121d
#define mmCM3_CM_SHAPER_SCALE_G_B_BASE_IDX                                                             2
#define mmCM3_CM_SHAPER_LUT_INDEX                                                                      0x121e
#define mmCM3_CM_SHAPER_LUT_INDEX_BASE_IDX                                                             2
#define mmCM3_CM_SHAPER_LUT_DATA                                                                       0x121f
#define mmCM3_CM_SHAPER_LUT_DATA_BASE_IDX                                                              2
#define mmCM3_CM_SHAPER_LUT_WRITE_EN_MASK                                                              0x1220
#define mmCM3_CM_SHAPER_LUT_WRITE_EN_MASK_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_START_CNTL_B                                                              0x1221
#define mmCM3_CM_SHAPER_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_START_CNTL_G                                                              0x1222
#define mmCM3_CM_SHAPER_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_START_CNTL_R                                                              0x1223
#define mmCM3_CM_SHAPER_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_END_CNTL_B                                                                0x1224
#define mmCM3_CM_SHAPER_RAMA_END_CNTL_B_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMA_END_CNTL_G                                                                0x1225
#define mmCM3_CM_SHAPER_RAMA_END_CNTL_G_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMA_END_CNTL_R                                                                0x1226
#define mmCM3_CM_SHAPER_RAMA_END_CNTL_R_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMA_REGION_0_1                                                                0x1227
#define mmCM3_CM_SHAPER_RAMA_REGION_0_1_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMA_REGION_2_3                                                                0x1228
#define mmCM3_CM_SHAPER_RAMA_REGION_2_3_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMA_REGION_4_5                                                                0x1229
#define mmCM3_CM_SHAPER_RAMA_REGION_4_5_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMA_REGION_6_7                                                                0x122a
#define mmCM3_CM_SHAPER_RAMA_REGION_6_7_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMA_REGION_8_9                                                                0x122b
#define mmCM3_CM_SHAPER_RAMA_REGION_8_9_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMA_REGION_10_11                                                              0x122c
#define mmCM3_CM_SHAPER_RAMA_REGION_10_11_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_REGION_12_13                                                              0x122d
#define mmCM3_CM_SHAPER_RAMA_REGION_12_13_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_REGION_14_15                                                              0x122e
#define mmCM3_CM_SHAPER_RAMA_REGION_14_15_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_REGION_16_17                                                              0x122f
#define mmCM3_CM_SHAPER_RAMA_REGION_16_17_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_REGION_18_19                                                              0x1230
#define mmCM3_CM_SHAPER_RAMA_REGION_18_19_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_REGION_20_21                                                              0x1231
#define mmCM3_CM_SHAPER_RAMA_REGION_20_21_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_REGION_22_23                                                              0x1232
#define mmCM3_CM_SHAPER_RAMA_REGION_22_23_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_REGION_24_25                                                              0x1233
#define mmCM3_CM_SHAPER_RAMA_REGION_24_25_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_REGION_26_27                                                              0x1234
#define mmCM3_CM_SHAPER_RAMA_REGION_26_27_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_REGION_28_29                                                              0x1235
#define mmCM3_CM_SHAPER_RAMA_REGION_28_29_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_REGION_30_31                                                              0x1236
#define mmCM3_CM_SHAPER_RAMA_REGION_30_31_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMA_REGION_32_33                                                              0x1237
#define mmCM3_CM_SHAPER_RAMA_REGION_32_33_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_START_CNTL_B                                                              0x1238
#define mmCM3_CM_SHAPER_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_START_CNTL_G                                                              0x1239
#define mmCM3_CM_SHAPER_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_START_CNTL_R                                                              0x123a
#define mmCM3_CM_SHAPER_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_END_CNTL_B                                                                0x123b
#define mmCM3_CM_SHAPER_RAMB_END_CNTL_B_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMB_END_CNTL_G                                                                0x123c
#define mmCM3_CM_SHAPER_RAMB_END_CNTL_G_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMB_END_CNTL_R                                                                0x123d
#define mmCM3_CM_SHAPER_RAMB_END_CNTL_R_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMB_REGION_0_1                                                                0x123e
#define mmCM3_CM_SHAPER_RAMB_REGION_0_1_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMB_REGION_2_3                                                                0x123f
#define mmCM3_CM_SHAPER_RAMB_REGION_2_3_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMB_REGION_4_5                                                                0x1240
#define mmCM3_CM_SHAPER_RAMB_REGION_4_5_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMB_REGION_6_7                                                                0x1241
#define mmCM3_CM_SHAPER_RAMB_REGION_6_7_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMB_REGION_8_9                                                                0x1242
#define mmCM3_CM_SHAPER_RAMB_REGION_8_9_BASE_IDX                                                       2
#define mmCM3_CM_SHAPER_RAMB_REGION_10_11                                                              0x1243
#define mmCM3_CM_SHAPER_RAMB_REGION_10_11_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_REGION_12_13                                                              0x1244
#define mmCM3_CM_SHAPER_RAMB_REGION_12_13_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_REGION_14_15                                                              0x1245
#define mmCM3_CM_SHAPER_RAMB_REGION_14_15_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_REGION_16_17                                                              0x1246
#define mmCM3_CM_SHAPER_RAMB_REGION_16_17_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_REGION_18_19                                                              0x1247
#define mmCM3_CM_SHAPER_RAMB_REGION_18_19_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_REGION_20_21                                                              0x1248
#define mmCM3_CM_SHAPER_RAMB_REGION_20_21_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_REGION_22_23                                                              0x1249
#define mmCM3_CM_SHAPER_RAMB_REGION_22_23_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_REGION_24_25                                                              0x124a
#define mmCM3_CM_SHAPER_RAMB_REGION_24_25_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_REGION_26_27                                                              0x124b
#define mmCM3_CM_SHAPER_RAMB_REGION_26_27_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_REGION_28_29                                                              0x124c
#define mmCM3_CM_SHAPER_RAMB_REGION_28_29_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_REGION_30_31                                                              0x124d
#define mmCM3_CM_SHAPER_RAMB_REGION_30_31_BASE_IDX                                                     2
#define mmCM3_CM_SHAPER_RAMB_REGION_32_33                                                              0x124e
#define mmCM3_CM_SHAPER_RAMB_REGION_32_33_BASE_IDX                                                     2
#define mmCM3_CM_MEM_PWR_CTRL2                                                                         0x124f
#define mmCM3_CM_MEM_PWR_CTRL2_BASE_IDX                                                                2
#define mmCM3_CM_MEM_PWR_STATUS2                                                                       0x1250
#define mmCM3_CM_MEM_PWR_STATUS2_BASE_IDX                                                              2
#define mmCM3_CM_3DLUT_MODE                                                                            0x1251
#define mmCM3_CM_3DLUT_MODE_BASE_IDX                                                                   2
#define mmCM3_CM_3DLUT_INDEX                                                                           0x1252
#define mmCM3_CM_3DLUT_INDEX_BASE_IDX                                                                  2
#define mmCM3_CM_3DLUT_DATA                                                                            0x1253
#define mmCM3_CM_3DLUT_DATA_BASE_IDX                                                                   2
#define mmCM3_CM_3DLUT_DATA_30BIT                                                                      0x1254
#define mmCM3_CM_3DLUT_DATA_30BIT_BASE_IDX                                                             2
#define mmCM3_CM_3DLUT_READ_WRITE_CONTROL                                                              0x1255
#define mmCM3_CM_3DLUT_READ_WRITE_CONTROL_BASE_IDX                                                     2
#define mmCM3_CM_3DLUT_OUT_NORM_FACTOR                                                                 0x1256
#define mmCM3_CM_3DLUT_OUT_NORM_FACTOR_BASE_IDX                                                        2
#define mmCM3_CM_3DLUT_OUT_OFFSET_R                                                                    0x1257
#define mmCM3_CM_3DLUT_OUT_OFFSET_R_BASE_IDX                                                           2
#define mmCM3_CM_3DLUT_OUT_OFFSET_G                                                                    0x1258
#define mmCM3_CM_3DLUT_OUT_OFFSET_G_BASE_IDX                                                           2
#define mmCM3_CM_3DLUT_OUT_OFFSET_B                                                                    0x1259
#define mmCM3_CM_3DLUT_OUT_OFFSET_B_BASE_IDX                                                           2
#define mmCM3_CM_TEST_DEBUG_INDEX                                                                      0x125a
#define mmCM3_CM_TEST_DEBUG_INDEX_BASE_IDX                                                             2
#define mmCM3_CM_TEST_DEBUG_DATA                                                                       0x125b
#define mmCM3_CM_TEST_DEBUG_DATA_BASE_IDX                                                              2


// addressBlock: dce_dc_dpp3_dispdec_dpp_dcperfmon_dc_perfmon_dispdec
// base address: 0x4994
#define mmDC_PERFMON14_PERFCOUNTER_CNTL                                                                0x1265
#define mmDC_PERFMON14_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON14_PERFCOUNTER_CNTL2                                                               0x1266
#define mmDC_PERFMON14_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON14_PERFCOUNTER_STATE                                                               0x1267
#define mmDC_PERFMON14_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON14_PERFMON_CNTL                                                                    0x1268
#define mmDC_PERFMON14_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON14_PERFMON_CNTL2                                                                   0x1269
#define mmDC_PERFMON14_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON14_PERFMON_CVALUE_INT_MISC                                                         0x126a
#define mmDC_PERFMON14_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON14_PERFMON_CVALUE_LOW                                                              0x126b
#define mmDC_PERFMON14_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON14_PERFMON_HI                                                                      0x126c
#define mmDC_PERFMON14_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON14_PERFMON_LOW                                                                     0x126d
#define mmDC_PERFMON14_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dpp4_dispdec_dpp_top_dispdec
// base address: 0x16b0
#define mmDPP_TOP4_DPP_CONTROL                                                                         0x1271
#define mmDPP_TOP4_DPP_CONTROL_BASE_IDX                                                                2
#define mmDPP_TOP4_DPP_SOFT_RESET                                                                      0x1272
#define mmDPP_TOP4_DPP_SOFT_RESET_BASE_IDX                                                             2
#define mmDPP_TOP4_DPP_CRC_VAL_R_G                                                                     0x1273
#define mmDPP_TOP4_DPP_CRC_VAL_R_G_BASE_IDX                                                            2
#define mmDPP_TOP4_DPP_CRC_VAL_B_A                                                                     0x1274
#define mmDPP_TOP4_DPP_CRC_VAL_B_A_BASE_IDX                                                            2
#define mmDPP_TOP4_DPP_CRC_CTRL                                                                        0x1275
#define mmDPP_TOP4_DPP_CRC_CTRL_BASE_IDX                                                               2
#define mmDPP_TOP4_HOST_READ_CONTROL                                                                   0x1276
#define mmDPP_TOP4_HOST_READ_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_dpp4_dispdec_cnvc_cfg_dispdec
// base address: 0x16b0
#define mmCNVC_CFG4_CNVC_SURFACE_PIXEL_FORMAT                                                          0x127b
#define mmCNVC_CFG4_CNVC_SURFACE_PIXEL_FORMAT_BASE_IDX                                                 2
#define mmCNVC_CFG4_FORMAT_CONTROL                                                                     0x127c
#define mmCNVC_CFG4_FORMAT_CONTROL_BASE_IDX                                                            2
#define mmCNVC_CFG4_FCNV_FP_BIAS_R                                                                     0x127d
#define mmCNVC_CFG4_FCNV_FP_BIAS_R_BASE_IDX                                                            2
#define mmCNVC_CFG4_FCNV_FP_BIAS_G                                                                     0x127e
#define mmCNVC_CFG4_FCNV_FP_BIAS_G_BASE_IDX                                                            2
#define mmCNVC_CFG4_FCNV_FP_BIAS_B                                                                     0x127f
#define mmCNVC_CFG4_FCNV_FP_BIAS_B_BASE_IDX                                                            2
#define mmCNVC_CFG4_FCNV_FP_SCALE_R                                                                    0x1280
#define mmCNVC_CFG4_FCNV_FP_SCALE_R_BASE_IDX                                                           2
#define mmCNVC_CFG4_FCNV_FP_SCALE_G                                                                    0x1281
#define mmCNVC_CFG4_FCNV_FP_SCALE_G_BASE_IDX                                                           2
#define mmCNVC_CFG4_FCNV_FP_SCALE_B                                                                    0x1282
#define mmCNVC_CFG4_FCNV_FP_SCALE_B_BASE_IDX                                                           2
#define mmCNVC_CFG4_COLOR_KEYER_CONTROL                                                                0x1283
#define mmCNVC_CFG4_COLOR_KEYER_CONTROL_BASE_IDX                                                       2
#define mmCNVC_CFG4_COLOR_KEYER_ALPHA                                                                  0x1284
#define mmCNVC_CFG4_COLOR_KEYER_ALPHA_BASE_IDX                                                         2
#define mmCNVC_CFG4_COLOR_KEYER_RED                                                                    0x1285
#define mmCNVC_CFG4_COLOR_KEYER_RED_BASE_IDX                                                           2
#define mmCNVC_CFG4_COLOR_KEYER_GREEN                                                                  0x1286
#define mmCNVC_CFG4_COLOR_KEYER_GREEN_BASE_IDX                                                         2
#define mmCNVC_CFG4_COLOR_KEYER_BLUE                                                                   0x1287
#define mmCNVC_CFG4_COLOR_KEYER_BLUE_BASE_IDX                                                          2
#define mmCNVC_CFG4_ALPHA_2BIT_LUT                                                                     0x1289
#define mmCNVC_CFG4_ALPHA_2BIT_LUT_BASE_IDX                                                            2
#define mmCNVC_CFG4_PRE_DEALPHA                                                                        0x128a
#define mmCNVC_CFG4_PRE_DEALPHA_BASE_IDX                                                               2
#define mmCNVC_CFG4_PRE_CSC_MODE                                                                       0x128b
#define mmCNVC_CFG4_PRE_CSC_MODE_BASE_IDX                                                              2
#define mmCNVC_CFG4_PRE_CSC_C11_C12                                                                    0x128c
#define mmCNVC_CFG4_PRE_CSC_C11_C12_BASE_IDX                                                           2
#define mmCNVC_CFG4_PRE_CSC_C13_C14                                                                    0x128d
#define mmCNVC_CFG4_PRE_CSC_C13_C14_BASE_IDX                                                           2
#define mmCNVC_CFG4_PRE_CSC_C21_C22                                                                    0x128e
#define mmCNVC_CFG4_PRE_CSC_C21_C22_BASE_IDX                                                           2
#define mmCNVC_CFG4_PRE_CSC_C23_C24                                                                    0x128f
#define mmCNVC_CFG4_PRE_CSC_C23_C24_BASE_IDX                                                           2
#define mmCNVC_CFG4_PRE_CSC_C31_C32                                                                    0x1290
#define mmCNVC_CFG4_PRE_CSC_C31_C32_BASE_IDX                                                           2
#define mmCNVC_CFG4_PRE_CSC_C33_C34                                                                    0x1291
#define mmCNVC_CFG4_PRE_CSC_C33_C34_BASE_IDX                                                           2
#define mmCNVC_CFG4_PRE_CSC_B_C11_C12                                                                  0x1292
#define mmCNVC_CFG4_PRE_CSC_B_C11_C12_BASE_IDX                                                         2
#define mmCNVC_CFG4_PRE_CSC_B_C13_C14                                                                  0x1293
#define mmCNVC_CFG4_PRE_CSC_B_C13_C14_BASE_IDX                                                         2
#define mmCNVC_CFG4_PRE_CSC_B_C21_C22                                                                  0x1294
#define mmCNVC_CFG4_PRE_CSC_B_C21_C22_BASE_IDX                                                         2
#define mmCNVC_CFG4_PRE_CSC_B_C23_C24                                                                  0x1295
#define mmCNVC_CFG4_PRE_CSC_B_C23_C24_BASE_IDX                                                         2
#define mmCNVC_CFG4_PRE_CSC_B_C31_C32                                                                  0x1296
#define mmCNVC_CFG4_PRE_CSC_B_C31_C32_BASE_IDX                                                         2
#define mmCNVC_CFG4_PRE_CSC_B_C33_C34                                                                  0x1297
#define mmCNVC_CFG4_PRE_CSC_B_C33_C34_BASE_IDX                                                         2
#define mmCNVC_CFG4_CNVC_COEF_FORMAT                                                                   0x1298
#define mmCNVC_CFG4_CNVC_COEF_FORMAT_BASE_IDX                                                          2
#define mmCNVC_CFG4_PRE_DEGAM                                                                          0x1299
#define mmCNVC_CFG4_PRE_DEGAM_BASE_IDX                                                                 2
#define mmCNVC_CFG4_PRE_REALPHA                                                                        0x129a
#define mmCNVC_CFG4_PRE_REALPHA_BASE_IDX                                                               2


// addressBlock: dce_dc_dpp4_dispdec_cnvc_cur_dispdec
// base address: 0x16b0
#define mmCNVC_CUR4_CURSOR0_CONTROL                                                                    0x129d
#define mmCNVC_CUR4_CURSOR0_CONTROL_BASE_IDX                                                           2
#define mmCNVC_CUR4_CURSOR0_COLOR0                                                                     0x129e
#define mmCNVC_CUR4_CURSOR0_COLOR0_BASE_IDX                                                            2
#define mmCNVC_CUR4_CURSOR0_COLOR1                                                                     0x129f
#define mmCNVC_CUR4_CURSOR0_COLOR1_BASE_IDX                                                            2
#define mmCNVC_CUR4_CURSOR0_FP_SCALE_BIAS                                                              0x12a0
#define mmCNVC_CUR4_CURSOR0_FP_SCALE_BIAS_BASE_IDX                                                     2


// addressBlock: dce_dc_dpp4_dispdec_dscl_dispdec
// base address: 0x16b0
#define mmDSCL4_SCL_COEF_RAM_TAP_SELECT                                                                0x12a5
#define mmDSCL4_SCL_COEF_RAM_TAP_SELECT_BASE_IDX                                                       2
#define mmDSCL4_SCL_COEF_RAM_TAP_DATA                                                                  0x12a6
#define mmDSCL4_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                         2
#define mmDSCL4_SCL_MODE                                                                               0x12a7
#define mmDSCL4_SCL_MODE_BASE_IDX                                                                      2
#define mmDSCL4_SCL_TAP_CONTROL                                                                        0x12a8
#define mmDSCL4_SCL_TAP_CONTROL_BASE_IDX                                                               2
#define mmDSCL4_DSCL_CONTROL                                                                           0x12a9
#define mmDSCL4_DSCL_CONTROL_BASE_IDX                                                                  2
#define mmDSCL4_DSCL_2TAP_CONTROL                                                                      0x12aa
#define mmDSCL4_DSCL_2TAP_CONTROL_BASE_IDX                                                             2
#define mmDSCL4_SCL_MANUAL_REPLICATE_CONTROL                                                           0x12ab
#define mmDSCL4_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                  2
#define mmDSCL4_SCL_HORZ_FILTER_SCALE_RATIO                                                            0x12ac
#define mmDSCL4_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define mmDSCL4_SCL_HORZ_FILTER_INIT                                                                   0x12ad
#define mmDSCL4_SCL_HORZ_FILTER_INIT_BASE_IDX                                                          2
#define mmDSCL4_SCL_HORZ_FILTER_SCALE_RATIO_C                                                          0x12ae
#define mmDSCL4_SCL_HORZ_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define mmDSCL4_SCL_HORZ_FILTER_INIT_C                                                                 0x12af
#define mmDSCL4_SCL_HORZ_FILTER_INIT_C_BASE_IDX                                                        2
#define mmDSCL4_SCL_VERT_FILTER_SCALE_RATIO                                                            0x12b0
#define mmDSCL4_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                   2
#define mmDSCL4_SCL_VERT_FILTER_INIT                                                                   0x12b1
#define mmDSCL4_SCL_VERT_FILTER_INIT_BASE_IDX                                                          2
#define mmDSCL4_SCL_VERT_FILTER_INIT_BOT                                                               0x12b2
#define mmDSCL4_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                      2
#define mmDSCL4_SCL_VERT_FILTER_SCALE_RATIO_C                                                          0x12b3
#define mmDSCL4_SCL_VERT_FILTER_SCALE_RATIO_C_BASE_IDX                                                 2
#define mmDSCL4_SCL_VERT_FILTER_INIT_C                                                                 0x12b4
#define mmDSCL4_SCL_VERT_FILTER_INIT_C_BASE_IDX                                                        2
#define mmDSCL4_SCL_VERT_FILTER_INIT_BOT_C                                                             0x12b5
#define mmDSCL4_SCL_VERT_FILTER_INIT_BOT_C_BASE_IDX                                                    2
#define mmDSCL4_SCL_BLACK_COLOR                                                                        0x12b6
#define mmDSCL4_SCL_BLACK_COLOR_BASE_IDX                                                               2
#define mmDSCL4_DSCL_UPDATE                                                                            0x12b7
#define mmDSCL4_DSCL_UPDATE_BASE_IDX                                                                   2
#define mmDSCL4_DSCL_AUTOCAL                                                                           0x12b8
#define mmDSCL4_DSCL_AUTOCAL_BASE_IDX                                                                  2
#define mmDSCL4_DSCL_EXT_OVERSCAN_LEFT_RIGHT                                                           0x12b9
#define mmDSCL4_DSCL_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                  2
#define mmDSCL4_DSCL_EXT_OVERSCAN_TOP_BOTTOM                                                           0x12ba
#define mmDSCL4_DSCL_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                  2
#define mmDSCL4_OTG_H_BLANK                                                                            0x12bb
#define mmDSCL4_OTG_H_BLANK_BASE_IDX                                                                   2
#define mmDSCL4_OTG_V_BLANK                                                                            0x12bc
#define mmDSCL4_OTG_V_BLANK_BASE_IDX                                                                   2
#define mmDSCL4_RECOUT_START                                                                           0x12bd
#define mmDSCL4_RECOUT_START_BASE_IDX                                                                  2
#define mmDSCL4_RECOUT_SIZE                                                                            0x12be
#define mmDSCL4_RECOUT_SIZE_BASE_IDX                                                                   2
#define mmDSCL4_MPC_SIZE                                                                               0x12bf
#define mmDSCL4_MPC_SIZE_BASE_IDX                                                                      2
#define mmDSCL4_LB_DATA_FORMAT                                                                         0x12c0
#define mmDSCL4_LB_DATA_FORMAT_BASE_IDX                                                                2
#define mmDSCL4_LB_MEMORY_CTRL                                                                         0x12c1
#define mmDSCL4_LB_MEMORY_CTRL_BASE_IDX                                                                2
#define mmDSCL4_LB_V_COUNTER                                                                           0x12c2
#define mmDSCL4_LB_V_COUNTER_BASE_IDX                                                                  2
#define mmDSCL4_DSCL_MEM_PWR_CTRL                                                                      0x12c3
#define mmDSCL4_DSCL_MEM_PWR_CTRL_BASE_IDX                                                             2
#define mmDSCL4_DSCL_MEM_PWR_STATUS                                                                    0x12c4
#define mmDSCL4_DSCL_MEM_PWR_STATUS_BASE_IDX                                                           2
#define mmDSCL4_OBUF_CONTROL                                                                           0x12c5
#define mmDSCL4_OBUF_CONTROL_BASE_IDX                                                                  2
#define mmDSCL4_OBUF_MEM_PWR_CTRL                                                                      0x12c6
#define mmDSCL4_OBUF_MEM_PWR_CTRL_BASE_IDX                                                             2


// addressBlock: dce_dc_dpp4_dispdec_cm_dispdec
// base address: 0x16b0
#define mmCM4_CM_CONTROL                                                                               0x12cc
#define mmCM4_CM_CONTROL_BASE_IDX                                                                      2
#define mmCM4_CM_POST_CSC_CONTROL                                                                      0x12cd
#define mmCM4_CM_POST_CSC_CONTROL_BASE_IDX                                                             2
#define mmCM4_CM_POST_CSC_C11_C12                                                                      0x12ce
#define mmCM4_CM_POST_CSC_C11_C12_BASE_IDX                                                             2
#define mmCM4_CM_POST_CSC_C13_C14                                                                      0x12cf
#define mmCM4_CM_POST_CSC_C13_C14_BASE_IDX                                                             2
#define mmCM4_CM_POST_CSC_C21_C22                                                                      0x12d0
#define mmCM4_CM_POST_CSC_C21_C22_BASE_IDX                                                             2
#define mmCM4_CM_POST_CSC_C23_C24                                                                      0x12d1
#define mmCM4_CM_POST_CSC_C23_C24_BASE_IDX                                                             2
#define mmCM4_CM_POST_CSC_C31_C32                                                                      0x12d2
#define mmCM4_CM_POST_CSC_C31_C32_BASE_IDX                                                             2
#define mmCM4_CM_POST_CSC_C33_C34                                                                      0x12d3
#define mmCM4_CM_POST_CSC_C33_C34_BASE_IDX                                                             2
#define mmCM4_CM_POST_CSC_B_C11_C12                                                                    0x12d4
#define mmCM4_CM_POST_CSC_B_C11_C12_BASE_IDX                                                           2
#define mmCM4_CM_POST_CSC_B_C13_C14                                                                    0x12d5
#define mmCM4_CM_POST_CSC_B_C13_C14_BASE_IDX                                                           2
#define mmCM4_CM_POST_CSC_B_C21_C22                                                                    0x12d6
#define mmCM4_CM_POST_CSC_B_C21_C22_BASE_IDX                                                           2
#define mmCM4_CM_POST_CSC_B_C23_C24                                                                    0x12d7
#define mmCM4_CM_POST_CSC_B_C23_C24_BASE_IDX                                                           2
#define mmCM4_CM_POST_CSC_B_C31_C32                                                                    0x12d8
#define mmCM4_CM_POST_CSC_B_C31_C32_BASE_IDX                                                           2
#define mmCM4_CM_POST_CSC_B_C33_C34                                                                    0x12d9
#define mmCM4_CM_POST_CSC_B_C33_C34_BASE_IDX                                                           2
#define mmCM4_CM_GAMUT_REMAP_CONTROL                                                                   0x12da
#define mmCM4_CM_GAMUT_REMAP_CONTROL_BASE_IDX                                                          2
#define mmCM4_CM_GAMUT_REMAP_C11_C12                                                                   0x12db
#define mmCM4_CM_GAMUT_REMAP_C11_C12_BASE_IDX                                                          2
#define mmCM4_CM_GAMUT_REMAP_C13_C14                                                                   0x12dc
#define mmCM4_CM_GAMUT_REMAP_C13_C14_BASE_IDX                                                          2
#define mmCM4_CM_GAMUT_REMAP_C21_C22                                                                   0x12dd
#define mmCM4_CM_GAMUT_REMAP_C21_C22_BASE_IDX                                                          2
#define mmCM4_CM_GAMUT_REMAP_C23_C24                                                                   0x12de
#define mmCM4_CM_GAMUT_REMAP_C23_C24_BASE_IDX                                                          2
#define mmCM4_CM_GAMUT_REMAP_C31_C32                                                                   0x12df
#define mmCM4_CM_GAMUT_REMAP_C31_C32_BASE_IDX                                                          2
#define mmCM4_CM_GAMUT_REMAP_C33_C34                                                                   0x12e0
#define mmCM4_CM_GAMUT_REMAP_C33_C34_BASE_IDX                                                          2
#define mmCM4_CM_GAMUT_REMAP_B_C11_C12                                                                 0x12e1
#define mmCM4_CM_GAMUT_REMAP_B_C11_C12_BASE_IDX                                                        2
#define mmCM4_CM_GAMUT_REMAP_B_C13_C14                                                                 0x12e2
#define mmCM4_CM_GAMUT_REMAP_B_C13_C14_BASE_IDX                                                        2
#define mmCM4_CM_GAMUT_REMAP_B_C21_C22                                                                 0x12e3
#define mmCM4_CM_GAMUT_REMAP_B_C21_C22_BASE_IDX                                                        2
#define mmCM4_CM_GAMUT_REMAP_B_C23_C24                                                                 0x12e4
#define mmCM4_CM_GAMUT_REMAP_B_C23_C24_BASE_IDX                                                        2
#define mmCM4_CM_GAMUT_REMAP_B_C31_C32                                                                 0x12e5
#define mmCM4_CM_GAMUT_REMAP_B_C31_C32_BASE_IDX                                                        2
#define mmCM4_CM_GAMUT_REMAP_B_C33_C34                                                                 0x12e6
#define mmCM4_CM_GAMUT_REMAP_B_C33_C34_BASE_IDX                                                        2
#define mmCM4_CM_BIAS_CR_R                                                                             0x12e7
#define mmCM4_CM_BIAS_CR_R_BASE_IDX                                                                    2
#define mmCM4_CM_BIAS_Y_G_CB_B                                                                         0x12e8
#define mmCM4_CM_BIAS_Y_G_CB_B_BASE_IDX                                                                2
#define mmCM4_CM_GAMCOR_CONTROL                                                                        0x12e9
#define mmCM4_CM_GAMCOR_CONTROL_BASE_IDX                                                               2
#define mmCM4_CM_GAMCOR_LUT_INDEX                                                                      0x12ea
#define mmCM4_CM_GAMCOR_LUT_INDEX_BASE_IDX                                                             2
#define mmCM4_CM_GAMCOR_LUT_DATA                                                                       0x12eb
#define mmCM4_CM_GAMCOR_LUT_DATA_BASE_IDX                                                              2
#define mmCM4_CM_GAMCOR_LUT_CONTROL                                                                    0x12ec
#define mmCM4_CM_GAMCOR_LUT_CONTROL_BASE_IDX                                                           2
#define mmCM4_CM_GAMCOR_RAMA_START_CNTL_B                                                              0x12ed
#define mmCM4_CM_GAMCOR_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMA_START_CNTL_G                                                              0x12ee
#define mmCM4_CM_GAMCOR_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMA_START_CNTL_R                                                              0x12ef
#define mmCM4_CM_GAMCOR_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B                                                        0x12f0
#define mmCM4_CM_GAMCOR_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define mmCM4_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G                                                        0x12f1
#define mmCM4_CM_GAMCOR_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define mmCM4_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R                                                        0x12f2
#define mmCM4_CM_GAMCOR_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define mmCM4_CM_GAMCOR_RAMA_START_BASE_CNTL_B                                                         0x12f3
#define mmCM4_CM_GAMCOR_RAMA_START_BASE_CNTL_B_BASE_IDX                                                2
#define mmCM4_CM_GAMCOR_RAMA_START_BASE_CNTL_G                                                         0x12f4
#define mmCM4_CM_GAMCOR_RAMA_START_BASE_CNTL_G_BASE_IDX                                                2
#define mmCM4_CM_GAMCOR_RAMA_START_BASE_CNTL_R                                                         0x12f5
#define mmCM4_CM_GAMCOR_RAMA_START_BASE_CNTL_R_BASE_IDX                                                2
#define mmCM4_CM_GAMCOR_RAMA_END_CNTL1_B                                                               0x12f6
#define mmCM4_CM_GAMCOR_RAMA_END_CNTL1_B_BASE_IDX                                                      2
#define mmCM4_CM_GAMCOR_RAMA_END_CNTL2_B                                                               0x12f7
#define mmCM4_CM_GAMCOR_RAMA_END_CNTL2_B_BASE_IDX                                                      2
#define mmCM4_CM_GAMCOR_RAMA_END_CNTL1_G                                                               0x12f8
#define mmCM4_CM_GAMCOR_RAMA_END_CNTL1_G_BASE_IDX                                                      2
#define mmCM4_CM_GAMCOR_RAMA_END_CNTL2_G                                                               0x12f9
#define mmCM4_CM_GAMCOR_RAMA_END_CNTL2_G_BASE_IDX                                                      2
#define mmCM4_CM_GAMCOR_RAMA_END_CNTL1_R                                                               0x12fa
#define mmCM4_CM_GAMCOR_RAMA_END_CNTL1_R_BASE_IDX                                                      2
#define mmCM4_CM_GAMCOR_RAMA_END_CNTL2_R                                                               0x12fb
#define mmCM4_CM_GAMCOR_RAMA_END_CNTL2_R_BASE_IDX                                                      2
#define mmCM4_CM_GAMCOR_RAMA_OFFSET_B                                                                  0x12fc
#define mmCM4_CM_GAMCOR_RAMA_OFFSET_B_BASE_IDX                                                         2
#define mmCM4_CM_GAMCOR_RAMA_OFFSET_G                                                                  0x12fd
#define mmCM4_CM_GAMCOR_RAMA_OFFSET_G_BASE_IDX                                                         2
#define mmCM4_CM_GAMCOR_RAMA_OFFSET_R                                                                  0x12fe
#define mmCM4_CM_GAMCOR_RAMA_OFFSET_R_BASE_IDX                                                         2
#define mmCM4_CM_GAMCOR_RAMA_REGION_0_1                                                                0x12ff
#define mmCM4_CM_GAMCOR_RAMA_REGION_0_1_BASE_IDX                                                       2
#define mmCM4_CM_GAMCOR_RAMA_REGION_2_3                                                                0x1300
#define mmCM4_CM_GAMCOR_RAMA_REGION_2_3_BASE_IDX                                                       2
#define mmCM4_CM_GAMCOR_RAMA_REGION_4_5                                                                0x1301
#define mmCM4_CM_GAMCOR_RAMA_REGION_4_5_BASE_IDX                                                       2
#define mmCM4_CM_GAMCOR_RAMA_REGION_6_7                                                                0x1302
#define mmCM4_CM_GAMCOR_RAMA_REGION_6_7_BASE_IDX                                                       2
#define mmCM4_CM_GAMCOR_RAMA_REGION_8_9                                                                0x1303
#define mmCM4_CM_GAMCOR_RAMA_REGION_8_9_BASE_IDX                                                       2
#define mmCM4_CM_GAMCOR_RAMA_REGION_10_11                                                              0x1304
#define mmCM4_CM_GAMCOR_RAMA_REGION_10_11_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMA_REGION_12_13                                                              0x1305
#define mmCM4_CM_GAMCOR_RAMA_REGION_12_13_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMA_REGION_14_15                                                              0x1306
#define mmCM4_CM_GAMCOR_RAMA_REGION_14_15_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMA_REGION_16_17                                                              0x1307
#define mmCM4_CM_GAMCOR_RAMA_REGION_16_17_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMA_REGION_18_19                                                              0x1308
#define mmCM4_CM_GAMCOR_RAMA_REGION_18_19_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMA_REGION_20_21                                                              0x1309
#define mmCM4_CM_GAMCOR_RAMA_REGION_20_21_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMA_REGION_22_23                                                              0x130a
#define mmCM4_CM_GAMCOR_RAMA_REGION_22_23_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMA_REGION_24_25                                                              0x130b
#define mmCM4_CM_GAMCOR_RAMA_REGION_24_25_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMA_REGION_26_27                                                              0x130c
#define mmCM4_CM_GAMCOR_RAMA_REGION_26_27_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMA_REGION_28_29                                                              0x130d
#define mmCM4_CM_GAMCOR_RAMA_REGION_28_29_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMA_REGION_30_31                                                              0x130e
#define mmCM4_CM_GAMCOR_RAMA_REGION_30_31_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMA_REGION_32_33                                                              0x130f
#define mmCM4_CM_GAMCOR_RAMA_REGION_32_33_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_START_CNTL_B                                                              0x1310
#define mmCM4_CM_GAMCOR_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_START_CNTL_G                                                              0x1311
#define mmCM4_CM_GAMCOR_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_START_CNTL_R                                                              0x1312
#define mmCM4_CM_GAMCOR_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B                                                        0x1313
#define mmCM4_CM_GAMCOR_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                               2
#define mmCM4_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G                                                        0x1314
#define mmCM4_CM_GAMCOR_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                               2
#define mmCM4_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R                                                        0x1315
#define mmCM4_CM_GAMCOR_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                               2
#define mmCM4_CM_GAMCOR_RAMB_START_BASE_CNTL_B                                                         0x1316
#define mmCM4_CM_GAMCOR_RAMB_START_BASE_CNTL_B_BASE_IDX                                                2
#define mmCM4_CM_GAMCOR_RAMB_START_BASE_CNTL_G                                                         0x1317
#define mmCM4_CM_GAMCOR_RAMB_START_BASE_CNTL_G_BASE_IDX                                                2
#define mmCM4_CM_GAMCOR_RAMB_START_BASE_CNTL_R                                                         0x1318
#define mmCM4_CM_GAMCOR_RAMB_START_BASE_CNTL_R_BASE_IDX                                                2
#define mmCM4_CM_GAMCOR_RAMB_END_CNTL1_B                                                               0x1319
#define mmCM4_CM_GAMCOR_RAMB_END_CNTL1_B_BASE_IDX                                                      2
#define mmCM4_CM_GAMCOR_RAMB_END_CNTL2_B                                                               0x131a
#define mmCM4_CM_GAMCOR_RAMB_END_CNTL2_B_BASE_IDX                                                      2
#define mmCM4_CM_GAMCOR_RAMB_END_CNTL1_G                                                               0x131b
#define mmCM4_CM_GAMCOR_RAMB_END_CNTL1_G_BASE_IDX                                                      2
#define mmCM4_CM_GAMCOR_RAMB_END_CNTL2_G                                                               0x131c
#define mmCM4_CM_GAMCOR_RAMB_END_CNTL2_G_BASE_IDX                                                      2
#define mmCM4_CM_GAMCOR_RAMB_END_CNTL1_R                                                               0x131d
#define mmCM4_CM_GAMCOR_RAMB_END_CNTL1_R_BASE_IDX                                                      2
#define mmCM4_CM_GAMCOR_RAMB_END_CNTL2_R                                                               0x131e
#define mmCM4_CM_GAMCOR_RAMB_END_CNTL2_R_BASE_IDX                                                      2
#define mmCM4_CM_GAMCOR_RAMB_OFFSET_B                                                                  0x131f
#define mmCM4_CM_GAMCOR_RAMB_OFFSET_B_BASE_IDX                                                         2
#define mmCM4_CM_GAMCOR_RAMB_OFFSET_G                                                                  0x1320
#define mmCM4_CM_GAMCOR_RAMB_OFFSET_G_BASE_IDX                                                         2
#define mmCM4_CM_GAMCOR_RAMB_OFFSET_R                                                                  0x1321
#define mmCM4_CM_GAMCOR_RAMB_OFFSET_R_BASE_IDX                                                         2
#define mmCM4_CM_GAMCOR_RAMB_REGION_0_1                                                                0x1322
#define mmCM4_CM_GAMCOR_RAMB_REGION_0_1_BASE_IDX                                                       2
#define mmCM4_CM_GAMCOR_RAMB_REGION_2_3                                                                0x1323
#define mmCM4_CM_GAMCOR_RAMB_REGION_2_3_BASE_IDX                                                       2
#define mmCM4_CM_GAMCOR_RAMB_REGION_4_5                                                                0x1324
#define mmCM4_CM_GAMCOR_RAMB_REGION_4_5_BASE_IDX                                                       2
#define mmCM4_CM_GAMCOR_RAMB_REGION_6_7                                                                0x1325
#define mmCM4_CM_GAMCOR_RAMB_REGION_6_7_BASE_IDX                                                       2
#define mmCM4_CM_GAMCOR_RAMB_REGION_8_9                                                                0x1326
#define mmCM4_CM_GAMCOR_RAMB_REGION_8_9_BASE_IDX                                                       2
#define mmCM4_CM_GAMCOR_RAMB_REGION_10_11                                                              0x1327
#define mmCM4_CM_GAMCOR_RAMB_REGION_10_11_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_REGION_12_13                                                              0x1328
#define mmCM4_CM_GAMCOR_RAMB_REGION_12_13_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_REGION_14_15                                                              0x1329
#define mmCM4_CM_GAMCOR_RAMB_REGION_14_15_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_REGION_16_17                                                              0x132a
#define mmCM4_CM_GAMCOR_RAMB_REGION_16_17_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_REGION_18_19                                                              0x132b
#define mmCM4_CM_GAMCOR_RAMB_REGION_18_19_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_REGION_20_21                                                              0x132c
#define mmCM4_CM_GAMCOR_RAMB_REGION_20_21_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_REGION_22_23                                                              0x132d
#define mmCM4_CM_GAMCOR_RAMB_REGION_22_23_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_REGION_24_25                                                              0x132e
#define mmCM4_CM_GAMCOR_RAMB_REGION_24_25_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_REGION_26_27                                                              0x132f
#define mmCM4_CM_GAMCOR_RAMB_REGION_26_27_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_REGION_28_29                                                              0x1330
#define mmCM4_CM_GAMCOR_RAMB_REGION_28_29_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_REGION_30_31                                                              0x1331
#define mmCM4_CM_GAMCOR_RAMB_REGION_30_31_BASE_IDX                                                     2
#define mmCM4_CM_GAMCOR_RAMB_REGION_32_33                                                              0x1332
#define mmCM4_CM_GAMCOR_RAMB_REGION_32_33_BASE_IDX                                                     2
#define mmCM4_CM_BLNDGAM_CONTROL                                                                       0x1333
#define mmCM4_CM_BLNDGAM_CONTROL_BASE_IDX                                                              2
#define mmCM4_CM_BLNDGAM_LUT_INDEX                                                                     0x1334
#define mmCM4_CM_BLNDGAM_LUT_INDEX_BASE_IDX                                                            2
#define mmCM4_CM_BLNDGAM_LUT_DATA                                                                      0x1335
#define mmCM4_CM_BLNDGAM_LUT_DATA_BASE_IDX                                                             2
#define mmCM4_CM_BLNDGAM_LUT_CONTROL                                                                   0x1336
#define mmCM4_CM_BLNDGAM_LUT_CONTROL_BASE_IDX                                                          2
#define mmCM4_CM_BLNDGAM_RAMA_START_CNTL_B                                                             0x1337
#define mmCM4_CM_BLNDGAM_RAMA_START_CNTL_B_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMA_START_CNTL_G                                                             0x1338
#define mmCM4_CM_BLNDGAM_RAMA_START_CNTL_G_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMA_START_CNTL_R                                                             0x1339
#define mmCM4_CM_BLNDGAM_RAMA_START_CNTL_R_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_B                                                       0x133a
#define mmCM4_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                              2
#define mmCM4_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_G                                                       0x133b
#define mmCM4_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                              2
#define mmCM4_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_R                                                       0x133c
#define mmCM4_CM_BLNDGAM_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                              2
#define mmCM4_CM_BLNDGAM_RAMA_START_BASE_CNTL_B                                                        0x133d
#define mmCM4_CM_BLNDGAM_RAMA_START_BASE_CNTL_B_BASE_IDX                                               2
#define mmCM4_CM_BLNDGAM_RAMA_START_BASE_CNTL_G                                                        0x133e
#define mmCM4_CM_BLNDGAM_RAMA_START_BASE_CNTL_G_BASE_IDX                                               2
#define mmCM4_CM_BLNDGAM_RAMA_START_BASE_CNTL_R                                                        0x133f
#define mmCM4_CM_BLNDGAM_RAMA_START_BASE_CNTL_R_BASE_IDX                                               2
#define mmCM4_CM_BLNDGAM_RAMA_END_CNTL1_B                                                              0x1340
#define mmCM4_CM_BLNDGAM_RAMA_END_CNTL1_B_BASE_IDX                                                     2
#define mmCM4_CM_BLNDGAM_RAMA_END_CNTL2_B                                                              0x1341
#define mmCM4_CM_BLNDGAM_RAMA_END_CNTL2_B_BASE_IDX                                                     2
#define mmCM4_CM_BLNDGAM_RAMA_END_CNTL1_G                                                              0x1342
#define mmCM4_CM_BLNDGAM_RAMA_END_CNTL1_G_BASE_IDX                                                     2
#define mmCM4_CM_BLNDGAM_RAMA_END_CNTL2_G                                                              0x1343
#define mmCM4_CM_BLNDGAM_RAMA_END_CNTL2_G_BASE_IDX                                                     2
#define mmCM4_CM_BLNDGAM_RAMA_END_CNTL1_R                                                              0x1344
#define mmCM4_CM_BLNDGAM_RAMA_END_CNTL1_R_BASE_IDX                                                     2
#define mmCM4_CM_BLNDGAM_RAMA_END_CNTL2_R                                                              0x1345
#define mmCM4_CM_BLNDGAM_RAMA_END_CNTL2_R_BASE_IDX                                                     2
#define mmCM4_CM_BLNDGAM_RAMA_OFFSET_B                                                                 0x1346
#define mmCM4_CM_BLNDGAM_RAMA_OFFSET_B_BASE_IDX                                                        2
#define mmCM4_CM_BLNDGAM_RAMA_OFFSET_G                                                                 0x1347
#define mmCM4_CM_BLNDGAM_RAMA_OFFSET_G_BASE_IDX                                                        2
#define mmCM4_CM_BLNDGAM_RAMA_OFFSET_R                                                                 0x1348
#define mmCM4_CM_BLNDGAM_RAMA_OFFSET_R_BASE_IDX                                                        2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_0_1                                                               0x1349
#define mmCM4_CM_BLNDGAM_RAMA_REGION_0_1_BASE_IDX                                                      2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_2_3                                                               0x134a
#define mmCM4_CM_BLNDGAM_RAMA_REGION_2_3_BASE_IDX                                                      2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_4_5                                                               0x134b
#define mmCM4_CM_BLNDGAM_RAMA_REGION_4_5_BASE_IDX                                                      2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_6_7                                                               0x134c
#define mmCM4_CM_BLNDGAM_RAMA_REGION_6_7_BASE_IDX                                                      2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_8_9                                                               0x134d
#define mmCM4_CM_BLNDGAM_RAMA_REGION_8_9_BASE_IDX                                                      2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_10_11                                                             0x134e
#define mmCM4_CM_BLNDGAM_RAMA_REGION_10_11_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_12_13                                                             0x134f
#define mmCM4_CM_BLNDGAM_RAMA_REGION_12_13_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_14_15                                                             0x1350
#define mmCM4_CM_BLNDGAM_RAMA_REGION_14_15_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_16_17                                                             0x1351
#define mmCM4_CM_BLNDGAM_RAMA_REGION_16_17_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_18_19                                                             0x1352
#define mmCM4_CM_BLNDGAM_RAMA_REGION_18_19_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_20_21                                                             0x1353
#define mmCM4_CM_BLNDGAM_RAMA_REGION_20_21_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_22_23                                                             0x1354
#define mmCM4_CM_BLNDGAM_RAMA_REGION_22_23_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_24_25                                                             0x1355
#define mmCM4_CM_BLNDGAM_RAMA_REGION_24_25_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_26_27                                                             0x1356
#define mmCM4_CM_BLNDGAM_RAMA_REGION_26_27_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_28_29                                                             0x1357
#define mmCM4_CM_BLNDGAM_RAMA_REGION_28_29_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_30_31                                                             0x1358
#define mmCM4_CM_BLNDGAM_RAMA_REGION_30_31_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMA_REGION_32_33                                                             0x1359
#define mmCM4_CM_BLNDGAM_RAMA_REGION_32_33_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_START_CNTL_B                                                             0x135a
#define mmCM4_CM_BLNDGAM_RAMB_START_CNTL_B_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_START_CNTL_G                                                             0x135b
#define mmCM4_CM_BLNDGAM_RAMB_START_CNTL_G_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_START_CNTL_R                                                             0x135c
#define mmCM4_CM_BLNDGAM_RAMB_START_CNTL_R_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_B                                                       0x135d
#define mmCM4_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_B_BASE_IDX                                              2
#define mmCM4_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_G                                                       0x135e
#define mmCM4_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_G_BASE_IDX                                              2
#define mmCM4_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_R                                                       0x135f
#define mmCM4_CM_BLNDGAM_RAMB_START_SLOPE_CNTL_R_BASE_IDX                                              2
#define mmCM4_CM_BLNDGAM_RAMB_START_BASE_CNTL_B                                                        0x1360
#define mmCM4_CM_BLNDGAM_RAMB_START_BASE_CNTL_B_BASE_IDX                                               2
#define mmCM4_CM_BLNDGAM_RAMB_START_BASE_CNTL_G                                                        0x1361
#define mmCM4_CM_BLNDGAM_RAMB_START_BASE_CNTL_G_BASE_IDX                                               2
#define mmCM4_CM_BLNDGAM_RAMB_START_BASE_CNTL_R                                                        0x1362
#define mmCM4_CM_BLNDGAM_RAMB_START_BASE_CNTL_R_BASE_IDX                                               2
#define mmCM4_CM_BLNDGAM_RAMB_END_CNTL1_B                                                              0x1363
#define mmCM4_CM_BLNDGAM_RAMB_END_CNTL1_B_BASE_IDX                                                     2
#define mmCM4_CM_BLNDGAM_RAMB_END_CNTL2_B                                                              0x1364
#define mmCM4_CM_BLNDGAM_RAMB_END_CNTL2_B_BASE_IDX                                                     2
#define mmCM4_CM_BLNDGAM_RAMB_END_CNTL1_G                                                              0x1365
#define mmCM4_CM_BLNDGAM_RAMB_END_CNTL1_G_BASE_IDX                                                     2
#define mmCM4_CM_BLNDGAM_RAMB_END_CNTL2_G                                                              0x1366
#define mmCM4_CM_BLNDGAM_RAMB_END_CNTL2_G_BASE_IDX                                                     2
#define mmCM4_CM_BLNDGAM_RAMB_END_CNTL1_R                                                              0x1367
#define mmCM4_CM_BLNDGAM_RAMB_END_CNTL1_R_BASE_IDX                                                     2
#define mmCM4_CM_BLNDGAM_RAMB_END_CNTL2_R                                                              0x1368
#define mmCM4_CM_BLNDGAM_RAMB_END_CNTL2_R_BASE_IDX                                                     2
#define mmCM4_CM_BLNDGAM_RAMB_OFFSET_B                                                                 0x1369
#define mmCM4_CM_BLNDGAM_RAMB_OFFSET_B_BASE_IDX                                                        2
#define mmCM4_CM_BLNDGAM_RAMB_OFFSET_G                                                                 0x136a
#define mmCM4_CM_BLNDGAM_RAMB_OFFSET_G_BASE_IDX                                                        2
#define mmCM4_CM_BLNDGAM_RAMB_OFFSET_R                                                                 0x136b
#define mmCM4_CM_BLNDGAM_RAMB_OFFSET_R_BASE_IDX                                                        2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_0_1                                                               0x136c
#define mmCM4_CM_BLNDGAM_RAMB_REGION_0_1_BASE_IDX                                                      2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_2_3                                                               0x136d
#define mmCM4_CM_BLNDGAM_RAMB_REGION_2_3_BASE_IDX                                                      2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_4_5                                                               0x136e
#define mmCM4_CM_BLNDGAM_RAMB_REGION_4_5_BASE_IDX                                                      2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_6_7                                                               0x136f
#define mmCM4_CM_BLNDGAM_RAMB_REGION_6_7_BASE_IDX                                                      2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_8_9                                                               0x1370
#define mmCM4_CM_BLNDGAM_RAMB_REGION_8_9_BASE_IDX                                                      2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_10_11                                                             0x1371
#define mmCM4_CM_BLNDGAM_RAMB_REGION_10_11_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_12_13                                                             0x1372
#define mmCM4_CM_BLNDGAM_RAMB_REGION_12_13_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_14_15                                                             0x1373
#define mmCM4_CM_BLNDGAM_RAMB_REGION_14_15_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_16_17                                                             0x1374
#define mmCM4_CM_BLNDGAM_RAMB_REGION_16_17_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_18_19                                                             0x1375
#define mmCM4_CM_BLNDGAM_RAMB_REGION_18_19_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_20_21                                                             0x1376
#define mmCM4_CM_BLNDGAM_RAMB_REGION_20_21_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_22_23                                                             0x1377
#define mmCM4_CM_BLNDGAM_RAMB_REGION_22_23_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_24_25                                                             0x1378
#define mmCM4_CM_BLNDGAM_RAMB_REGION_24_25_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_26_27                                                             0x1379
#define mmCM4_CM_BLNDGAM_RAMB_REGION_26_27_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_28_29                                                             0x137a
#define mmCM4_CM_BLNDGAM_RAMB_REGION_28_29_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_30_31                                                             0x137b
#define mmCM4_CM_BLNDGAM_RAMB_REGION_30_31_BASE_IDX                                                    2
#define mmCM4_CM_BLNDGAM_RAMB_REGION_32_33                                                             0x137c
#define mmCM4_CM_BLNDGAM_RAMB_REGION_32_33_BASE_IDX                                                    2
#define mmCM4_CM_HDR_MULT_COEF                                                                         0x137d
#define mmCM4_CM_HDR_MULT_COEF_BASE_IDX                                                                2
#define mmCM4_CM_MEM_PWR_CTRL                                                                          0x137e
#define mmCM4_CM_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define mmCM4_CM_MEM_PWR_STATUS                                                                        0x137f
#define mmCM4_CM_MEM_PWR_STATUS_BASE_IDX                                                               2
#define mmCM4_CM_DEALPHA                                                                               0x1381
#define mmCM4_CM_DEALPHA_BASE_IDX                                                                      2
#define mmCM4_CM_COEF_FORMAT                                                                           0x1382
#define mmCM4_CM_COEF_FORMAT_BASE_IDX                                                                  2
#define mmCM4_CM_SHAPER_CONTROL                                                                        0x1383
#define mmCM4_CM_SHAPER_CONTROL_BASE_IDX                                                               2
#define mmCM4_CM_SHAPER_OFFSET_R                                                                       0x1384
#define mmCM4_CM_SHAPER_OFFSET_R_BASE_IDX                                                              2
#define mmCM4_CM_SHAPER_OFFSET_G                                                                       0x1385
#define mmCM4_CM_SHAPER_OFFSET_G_BASE_IDX                                                              2
#define mmCM4_CM_SHAPER_OFFSET_B                                                                       0x1386
#define mmCM4_CM_SHAPER_OFFSET_B_BASE_IDX                                                              2
#define mmCM4_CM_SHAPER_SCALE_R                                                                        0x1387
#define mmCM4_CM_SHAPER_SCALE_R_BASE_IDX                                                               2
#define mmCM4_CM_SHAPER_SCALE_G_B                                                                      0x1388
#define mmCM4_CM_SHAPER_SCALE_G_B_BASE_IDX                                                             2
#define mmCM4_CM_SHAPER_LUT_INDEX                                                                      0x1389
#define mmCM4_CM_SHAPER_LUT_INDEX_BASE_IDX                                                             2
#define mmCM4_CM_SHAPER_LUT_DATA                                                                       0x138a
#define mmCM4_CM_SHAPER_LUT_DATA_BASE_IDX                                                              2
#define mmCM4_CM_SHAPER_LUT_WRITE_EN_MASK                                                              0x138b
#define mmCM4_CM_SHAPER_LUT_WRITE_EN_MASK_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_START_CNTL_B                                                              0x138c
#define mmCM4_CM_SHAPER_RAMA_START_CNTL_B_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_START_CNTL_G                                                              0x138d
#define mmCM4_CM_SHAPER_RAMA_START_CNTL_G_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_START_CNTL_R                                                              0x138e
#define mmCM4_CM_SHAPER_RAMA_START_CNTL_R_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_END_CNTL_B                                                                0x138f
#define mmCM4_CM_SHAPER_RAMA_END_CNTL_B_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMA_END_CNTL_G                                                                0x1390
#define mmCM4_CM_SHAPER_RAMA_END_CNTL_G_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMA_END_CNTL_R                                                                0x1391
#define mmCM4_CM_SHAPER_RAMA_END_CNTL_R_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMA_REGION_0_1                                                                0x1392
#define mmCM4_CM_SHAPER_RAMA_REGION_0_1_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMA_REGION_2_3                                                                0x1393
#define mmCM4_CM_SHAPER_RAMA_REGION_2_3_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMA_REGION_4_5                                                                0x1394
#define mmCM4_CM_SHAPER_RAMA_REGION_4_5_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMA_REGION_6_7                                                                0x1395
#define mmCM4_CM_SHAPER_RAMA_REGION_6_7_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMA_REGION_8_9                                                                0x1396
#define mmCM4_CM_SHAPER_RAMA_REGION_8_9_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMA_REGION_10_11                                                              0x1397
#define mmCM4_CM_SHAPER_RAMA_REGION_10_11_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_REGION_12_13                                                              0x1398
#define mmCM4_CM_SHAPER_RAMA_REGION_12_13_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_REGION_14_15                                                              0x1399
#define mmCM4_CM_SHAPER_RAMA_REGION_14_15_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_REGION_16_17                                                              0x139a
#define mmCM4_CM_SHAPER_RAMA_REGION_16_17_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_REGION_18_19                                                              0x139b
#define mmCM4_CM_SHAPER_RAMA_REGION_18_19_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_REGION_20_21                                                              0x139c
#define mmCM4_CM_SHAPER_RAMA_REGION_20_21_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_REGION_22_23                                                              0x139d
#define mmCM4_CM_SHAPER_RAMA_REGION_22_23_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_REGION_24_25                                                              0x139e
#define mmCM4_CM_SHAPER_RAMA_REGION_24_25_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_REGION_26_27                                                              0x139f
#define mmCM4_CM_SHAPER_RAMA_REGION_26_27_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_REGION_28_29                                                              0x13a0
#define mmCM4_CM_SHAPER_RAMA_REGION_28_29_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_REGION_30_31                                                              0x13a1
#define mmCM4_CM_SHAPER_RAMA_REGION_30_31_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMA_REGION_32_33                                                              0x13a2
#define mmCM4_CM_SHAPER_RAMA_REGION_32_33_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_START_CNTL_B                                                              0x13a3
#define mmCM4_CM_SHAPER_RAMB_START_CNTL_B_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_START_CNTL_G                                                              0x13a4
#define mmCM4_CM_SHAPER_RAMB_START_CNTL_G_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_START_CNTL_R                                                              0x13a5
#define mmCM4_CM_SHAPER_RAMB_START_CNTL_R_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_END_CNTL_B                                                                0x13a6
#define mmCM4_CM_SHAPER_RAMB_END_CNTL_B_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMB_END_CNTL_G                                                                0x13a7
#define mmCM4_CM_SHAPER_RAMB_END_CNTL_G_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMB_END_CNTL_R                                                                0x13a8
#define mmCM4_CM_SHAPER_RAMB_END_CNTL_R_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMB_REGION_0_1                                                                0x13a9
#define mmCM4_CM_SHAPER_RAMB_REGION_0_1_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMB_REGION_2_3                                                                0x13aa
#define mmCM4_CM_SHAPER_RAMB_REGION_2_3_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMB_REGION_4_5                                                                0x13ab
#define mmCM4_CM_SHAPER_RAMB_REGION_4_5_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMB_REGION_6_7                                                                0x13ac
#define mmCM4_CM_SHAPER_RAMB_REGION_6_7_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMB_REGION_8_9                                                                0x13ad
#define mmCM4_CM_SHAPER_RAMB_REGION_8_9_BASE_IDX                                                       2
#define mmCM4_CM_SHAPER_RAMB_REGION_10_11                                                              0x13ae
#define mmCM4_CM_SHAPER_RAMB_REGION_10_11_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_REGION_12_13                                                              0x13af
#define mmCM4_CM_SHAPER_RAMB_REGION_12_13_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_REGION_14_15                                                              0x13b0
#define mmCM4_CM_SHAPER_RAMB_REGION_14_15_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_REGION_16_17                                                              0x13b1
#define mmCM4_CM_SHAPER_RAMB_REGION_16_17_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_REGION_18_19                                                              0x13b2
#define mmCM4_CM_SHAPER_RAMB_REGION_18_19_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_REGION_20_21                                                              0x13b3
#define mmCM4_CM_SHAPER_RAMB_REGION_20_21_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_REGION_22_23                                                              0x13b4
#define mmCM4_CM_SHAPER_RAMB_REGION_22_23_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_REGION_24_25                                                              0x13b5
#define mmCM4_CM_SHAPER_RAMB_REGION_24_25_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_REGION_26_27                                                              0x13b6
#define mmCM4_CM_SHAPER_RAMB_REGION_26_27_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_REGION_28_29                                                              0x13b7
#define mmCM4_CM_SHAPER_RAMB_REGION_28_29_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_REGION_30_31                                                              0x13b8
#define mmCM4_CM_SHAPER_RAMB_REGION_30_31_BASE_IDX                                                     2
#define mmCM4_CM_SHAPER_RAMB_REGION_32_33                                                              0x13b9
#define mmCM4_CM_SHAPER_RAMB_REGION_32_33_BASE_IDX                                                     2
#define mmCM4_CM_MEM_PWR_CTRL2                                                                         0x13ba
#define mmCM4_CM_MEM_PWR_CTRL2_BASE_IDX                                                                2
#define mmCM4_CM_MEM_PWR_STATUS2                                                                       0x13bb
#define mmCM4_CM_MEM_PWR_STATUS2_BASE_IDX                                                              2
#define mmCM4_CM_3DLUT_MODE                                                                            0x13bc
#define mmCM4_CM_3DLUT_MODE_BASE_IDX                                                                   2
#define mmCM4_CM_3DLUT_INDEX                                                                           0x13bd
#define mmCM4_CM_3DLUT_INDEX_BASE_IDX                                                                  2
#define mmCM4_CM_3DLUT_DATA                                                                            0x13be
#define mmCM4_CM_3DLUT_DATA_BASE_IDX                                                                   2
#define mmCM4_CM_3DLUT_DATA_30BIT                                                                      0x13bf
#define mmCM4_CM_3DLUT_DATA_30BIT_BASE_IDX                                                             2
#define mmCM4_CM_3DLUT_READ_WRITE_CONTROL                                                              0x13c0
#define mmCM4_CM_3DLUT_READ_WRITE_CONTROL_BASE_IDX                                                     2
#define mmCM4_CM_3DLUT_OUT_NORM_FACTOR                                                                 0x13c1
#define mmCM4_CM_3DLUT_OUT_NORM_FACTOR_BASE_IDX                                                        2
#define mmCM4_CM_3DLUT_OUT_OFFSET_R                                                                    0x13c2
#define mmCM4_CM_3DLUT_OUT_OFFSET_R_BASE_IDX                                                           2
#define mmCM4_CM_3DLUT_OUT_OFFSET_G                                                                    0x13c3
#define mmCM4_CM_3DLUT_OUT_OFFSET_G_BASE_IDX                                                           2
#define mmCM4_CM_3DLUT_OUT_OFFSET_B                                                                    0x13c4
#define mmCM4_CM_3DLUT_OUT_OFFSET_B_BASE_IDX                                                           2
#define mmCM4_CM_TEST_DEBUG_INDEX                                                                      0x13c5
#define mmCM4_CM_TEST_DEBUG_INDEX_BASE_IDX                                                             2
#define mmCM4_CM_TEST_DEBUG_DATA                                                                       0x13c6
#define mmCM4_CM_TEST_DEBUG_DATA_BASE_IDX                                                              2


// addressBlock: dce_dc_dpp4_dispdec_dpp_dcperfmon_dc_perfmon_dispdec
// base address: 0x4f40
#define mmDC_PERFMON15_PERFCOUNTER_CNTL                                                                0x13d0
#define mmDC_PERFMON15_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON15_PERFCOUNTER_CNTL2                                                               0x13d1
#define mmDC_PERFMON15_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON15_PERFCOUNTER_STATE                                                               0x13d2
#define mmDC_PERFMON15_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON15_PERFMON_CNTL                                                                    0x13d3
#define mmDC_PERFMON15_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON15_PERFMON_CNTL2                                                                   0x13d4
#define mmDC_PERFMON15_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON15_PERFMON_CVALUE_INT_MISC                                                         0x13d5
#define mmDC_PERFMON15_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON15_PERFMON_CVALUE_LOW                                                              0x13d6
#define mmDC_PERFMON15_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON15_PERFMON_HI                                                                      0x13d7
#define mmDC_PERFMON15_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON15_PERFMON_LOW                                                                     0x13d8
#define mmDC_PERFMON15_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_opp_fmt0_dispdec
// base address: 0x0
#define mmFMT0_FMT_CLAMP_COMPONENT_R                                                                   0x183c
#define mmFMT0_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define mmFMT0_FMT_CLAMP_COMPONENT_G                                                                   0x183d
#define mmFMT0_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define mmFMT0_FMT_CLAMP_COMPONENT_B                                                                   0x183e
#define mmFMT0_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define mmFMT0_FMT_DYNAMIC_EXP_CNTL                                                                    0x183f
#define mmFMT0_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define mmFMT0_FMT_CONTROL                                                                             0x1840
#define mmFMT0_FMT_CONTROL_BASE_IDX                                                                    2
#define mmFMT0_FMT_BIT_DEPTH_CONTROL                                                                   0x1841
#define mmFMT0_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define mmFMT0_FMT_DITHER_RAND_R_SEED                                                                  0x1842
#define mmFMT0_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define mmFMT0_FMT_DITHER_RAND_G_SEED                                                                  0x1843
#define mmFMT0_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define mmFMT0_FMT_DITHER_RAND_B_SEED                                                                  0x1844
#define mmFMT0_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define mmFMT0_FMT_CLAMP_CNTL                                                                          0x1845
#define mmFMT0_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define mmFMT0_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x1846
#define mmFMT0_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define mmFMT0_FMT_MAP420_MEMORY_CONTROL                                                               0x1847
#define mmFMT0_FMT_MAP420_MEMORY_CONTROL_BASE_IDX                                                      2
#define mmFMT0_FMT_422_CONTROL                                                                         0x1849
#define mmFMT0_FMT_422_CONTROL_BASE_IDX                                                                2


// addressBlock: dce_dc_opp_dpg0_dispdec
// base address: 0x0
#define mmDPG0_DPG_CONTROL                                                                             0x1854
#define mmDPG0_DPG_CONTROL_BASE_IDX                                                                    2
#define mmDPG0_DPG_RAMP_CONTROL                                                                        0x1855
#define mmDPG0_DPG_RAMP_CONTROL_BASE_IDX                                                               2
#define mmDPG0_DPG_DIMENSIONS                                                                          0x1856
#define mmDPG0_DPG_DIMENSIONS_BASE_IDX                                                                 2
#define mmDPG0_DPG_COLOUR_R_CR                                                                         0x1857
#define mmDPG0_DPG_COLOUR_R_CR_BASE_IDX                                                                2
#define mmDPG0_DPG_COLOUR_G_Y                                                                          0x1858
#define mmDPG0_DPG_COLOUR_G_Y_BASE_IDX                                                                 2
#define mmDPG0_DPG_COLOUR_B_CB                                                                         0x1859
#define mmDPG0_DPG_COLOUR_B_CB_BASE_IDX                                                                2
#define mmDPG0_DPG_OFFSET_SEGMENT                                                                      0x185a
#define mmDPG0_DPG_OFFSET_SEGMENT_BASE_IDX                                                             2
#define mmDPG0_DPG_STATUS                                                                              0x185b
#define mmDPG0_DPG_STATUS_BASE_IDX                                                                     2


// addressBlock: dce_dc_opp_oppbuf0_dispdec
// base address: 0x0
#define mmOPPBUF0_OPPBUF_CONTROL                                                                       0x1884
#define mmOPPBUF0_OPPBUF_CONTROL_BASE_IDX                                                              2
#define mmOPPBUF0_OPPBUF_3D_PARAMETERS_0                                                               0x1885
#define mmOPPBUF0_OPPBUF_3D_PARAMETERS_0_BASE_IDX                                                      2
#define mmOPPBUF0_OPPBUF_3D_PARAMETERS_1                                                               0x1886
#define mmOPPBUF0_OPPBUF_3D_PARAMETERS_1_BASE_IDX                                                      2
#define mmOPPBUF0_OPPBUF_CONTROL1                                                                      0x1889
#define mmOPPBUF0_OPPBUF_CONTROL1_BASE_IDX                                                             2


// addressBlock: dce_dc_opp_opp_pipe0_dispdec
// base address: 0x0
#define mmOPP_PIPE0_OPP_PIPE_CONTROL                                                                   0x188c
#define mmOPP_PIPE0_OPP_PIPE_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_opp_opp_pipe_crc0_dispdec
// base address: 0x0
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_CONTROL                                                           0x1891
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_CONTROL_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_MASK                                                              0x1892
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_MASK_BASE_IDX                                                     2
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT0                                                           0x1893
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT0_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT1                                                           0x1894
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT1_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT2                                                           0x1895
#define mmOPP_PIPE_CRC0_OPP_PIPE_CRC_RESULT2_BASE_IDX                                                  2


// addressBlock: dce_dc_opp_fmt1_dispdec
// base address: 0x168
#define mmFMT1_FMT_CLAMP_COMPONENT_R                                                                   0x1896
#define mmFMT1_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define mmFMT1_FMT_CLAMP_COMPONENT_G                                                                   0x1897
#define mmFMT1_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define mmFMT1_FMT_CLAMP_COMPONENT_B                                                                   0x1898
#define mmFMT1_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define mmFMT1_FMT_DYNAMIC_EXP_CNTL                                                                    0x1899
#define mmFMT1_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define mmFMT1_FMT_CONTROL                                                                             0x189a
#define mmFMT1_FMT_CONTROL_BASE_IDX                                                                    2
#define mmFMT1_FMT_BIT_DEPTH_CONTROL                                                                   0x189b
#define mmFMT1_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define mmFMT1_FMT_DITHER_RAND_R_SEED                                                                  0x189c
#define mmFMT1_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define mmFMT1_FMT_DITHER_RAND_G_SEED                                                                  0x189d
#define mmFMT1_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define mmFMT1_FMT_DITHER_RAND_B_SEED                                                                  0x189e
#define mmFMT1_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define mmFMT1_FMT_CLAMP_CNTL                                                                          0x189f
#define mmFMT1_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define mmFMT1_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x18a0
#define mmFMT1_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define mmFMT1_FMT_MAP420_MEMORY_CONTROL                                                               0x18a1
#define mmFMT1_FMT_MAP420_MEMORY_CONTROL_BASE_IDX                                                      2
#define mmFMT1_FMT_422_CONTROL                                                                         0x18a3
#define mmFMT1_FMT_422_CONTROL_BASE_IDX                                                                2


// addressBlock: dce_dc_opp_dpg1_dispdec
// base address: 0x168
#define mmDPG1_DPG_CONTROL                                                                             0x18ae
#define mmDPG1_DPG_CONTROL_BASE_IDX                                                                    2
#define mmDPG1_DPG_RAMP_CONTROL                                                                        0x18af
#define mmDPG1_DPG_RAMP_CONTROL_BASE_IDX                                                               2
#define mmDPG1_DPG_DIMENSIONS                                                                          0x18b0
#define mmDPG1_DPG_DIMENSIONS_BASE_IDX                                                                 2
#define mmDPG1_DPG_COLOUR_R_CR                                                                         0x18b1
#define mmDPG1_DPG_COLOUR_R_CR_BASE_IDX                                                                2
#define mmDPG1_DPG_COLOUR_G_Y                                                                          0x18b2
#define mmDPG1_DPG_COLOUR_G_Y_BASE_IDX                                                                 2
#define mmDPG1_DPG_COLOUR_B_CB                                                                         0x18b3
#define mmDPG1_DPG_COLOUR_B_CB_BASE_IDX                                                                2
#define mmDPG1_DPG_OFFSET_SEGMENT                                                                      0x18b4
#define mmDPG1_DPG_OFFSET_SEGMENT_BASE_IDX                                                             2
#define mmDPG1_DPG_STATUS                                                                              0x18b5
#define mmDPG1_DPG_STATUS_BASE_IDX                                                                     2


// addressBlock: dce_dc_opp_oppbuf1_dispdec
// base address: 0x168
#define mmOPPBUF1_OPPBUF_CONTROL                                                                       0x18de
#define mmOPPBUF1_OPPBUF_CONTROL_BASE_IDX                                                              2
#define mmOPPBUF1_OPPBUF_3D_PARAMETERS_0                                                               0x18df
#define mmOPPBUF1_OPPBUF_3D_PARAMETERS_0_BASE_IDX                                                      2
#define mmOPPBUF1_OPPBUF_3D_PARAMETERS_1                                                               0x18e0
#define mmOPPBUF1_OPPBUF_3D_PARAMETERS_1_BASE_IDX                                                      2
#define mmOPPBUF1_OPPBUF_CONTROL1                                                                      0x18e3
#define mmOPPBUF1_OPPBUF_CONTROL1_BASE_IDX                                                             2


// addressBlock: dce_dc_opp_opp_pipe1_dispdec
// base address: 0x168
#define mmOPP_PIPE1_OPP_PIPE_CONTROL                                                                   0x18e6
#define mmOPP_PIPE1_OPP_PIPE_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_opp_opp_pipe_crc1_dispdec
// base address: 0x168
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_CONTROL                                                           0x18eb
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_CONTROL_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_MASK                                                              0x18ec
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_MASK_BASE_IDX                                                     2
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT0                                                           0x18ed
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT0_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT1                                                           0x18ee
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT1_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT2                                                           0x18ef
#define mmOPP_PIPE_CRC1_OPP_PIPE_CRC_RESULT2_BASE_IDX                                                  2


// addressBlock: dce_dc_opp_fmt2_dispdec
// base address: 0x2d0
#define mmFMT2_FMT_CLAMP_COMPONENT_R                                                                   0x18f0
#define mmFMT2_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define mmFMT2_FMT_CLAMP_COMPONENT_G                                                                   0x18f1
#define mmFMT2_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define mmFMT2_FMT_CLAMP_COMPONENT_B                                                                   0x18f2
#define mmFMT2_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define mmFMT2_FMT_DYNAMIC_EXP_CNTL                                                                    0x18f3
#define mmFMT2_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define mmFMT2_FMT_CONTROL                                                                             0x18f4
#define mmFMT2_FMT_CONTROL_BASE_IDX                                                                    2
#define mmFMT2_FMT_BIT_DEPTH_CONTROL                                                                   0x18f5
#define mmFMT2_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define mmFMT2_FMT_DITHER_RAND_R_SEED                                                                  0x18f6
#define mmFMT2_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define mmFMT2_FMT_DITHER_RAND_G_SEED                                                                  0x18f7
#define mmFMT2_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define mmFMT2_FMT_DITHER_RAND_B_SEED                                                                  0x18f8
#define mmFMT2_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define mmFMT2_FMT_CLAMP_CNTL                                                                          0x18f9
#define mmFMT2_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define mmFMT2_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x18fa
#define mmFMT2_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define mmFMT2_FMT_MAP420_MEMORY_CONTROL                                                               0x18fb
#define mmFMT2_FMT_MAP420_MEMORY_CONTROL_BASE_IDX                                                      2
#define mmFMT2_FMT_422_CONTROL                                                                         0x18fd
#define mmFMT2_FMT_422_CONTROL_BASE_IDX                                                                2


// addressBlock: dce_dc_opp_dpg2_dispdec
// base address: 0x2d0
#define mmDPG2_DPG_CONTROL                                                                             0x1908
#define mmDPG2_DPG_CONTROL_BASE_IDX                                                                    2
#define mmDPG2_DPG_RAMP_CONTROL                                                                        0x1909
#define mmDPG2_DPG_RAMP_CONTROL_BASE_IDX                                                               2
#define mmDPG2_DPG_DIMENSIONS                                                                          0x190a
#define mmDPG2_DPG_DIMENSIONS_BASE_IDX                                                                 2
#define mmDPG2_DPG_COLOUR_R_CR                                                                         0x190b
#define mmDPG2_DPG_COLOUR_R_CR_BASE_IDX                                                                2
#define mmDPG2_DPG_COLOUR_G_Y                                                                          0x190c
#define mmDPG2_DPG_COLOUR_G_Y_BASE_IDX                                                                 2
#define mmDPG2_DPG_COLOUR_B_CB                                                                         0x190d
#define mmDPG2_DPG_COLOUR_B_CB_BASE_IDX                                                                2
#define mmDPG2_DPG_OFFSET_SEGMENT                                                                      0x190e
#define mmDPG2_DPG_OFFSET_SEGMENT_BASE_IDX                                                             2
#define mmDPG2_DPG_STATUS                                                                              0x190f
#define mmDPG2_DPG_STATUS_BASE_IDX                                                                     2


// addressBlock: dce_dc_opp_oppbuf2_dispdec
// base address: 0x2d0
#define mmOPPBUF2_OPPBUF_CONTROL                                                                       0x1938
#define mmOPPBUF2_OPPBUF_CONTROL_BASE_IDX                                                              2
#define mmOPPBUF2_OPPBUF_3D_PARAMETERS_0                                                               0x1939
#define mmOPPBUF2_OPPBUF_3D_PARAMETERS_0_BASE_IDX                                                      2
#define mmOPPBUF2_OPPBUF_3D_PARAMETERS_1                                                               0x193a
#define mmOPPBUF2_OPPBUF_3D_PARAMETERS_1_BASE_IDX                                                      2
#define mmOPPBUF2_OPPBUF_CONTROL1                                                                      0x193d
#define mmOPPBUF2_OPPBUF_CONTROL1_BASE_IDX                                                             2


// addressBlock: dce_dc_opp_opp_pipe2_dispdec
// base address: 0x2d0
#define mmOPP_PIPE2_OPP_PIPE_CONTROL                                                                   0x1940
#define mmOPP_PIPE2_OPP_PIPE_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_opp_opp_pipe_crc2_dispdec
// base address: 0x2d0
#define mmOPP_PIPE_CRC2_OPP_PIPE_CRC_CONTROL                                                           0x1945
#define mmOPP_PIPE_CRC2_OPP_PIPE_CRC_CONTROL_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC2_OPP_PIPE_CRC_MASK                                                              0x1946
#define mmOPP_PIPE_CRC2_OPP_PIPE_CRC_MASK_BASE_IDX                                                     2
#define mmOPP_PIPE_CRC2_OPP_PIPE_CRC_RESULT0                                                           0x1947
#define mmOPP_PIPE_CRC2_OPP_PIPE_CRC_RESULT0_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC2_OPP_PIPE_CRC_RESULT1                                                           0x1948
#define mmOPP_PIPE_CRC2_OPP_PIPE_CRC_RESULT1_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC2_OPP_PIPE_CRC_RESULT2                                                           0x1949
#define mmOPP_PIPE_CRC2_OPP_PIPE_CRC_RESULT2_BASE_IDX                                                  2


// addressBlock: dce_dc_opp_fmt3_dispdec
// base address: 0x438
#define mmFMT3_FMT_CLAMP_COMPONENT_R                                                                   0x194a
#define mmFMT3_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define mmFMT3_FMT_CLAMP_COMPONENT_G                                                                   0x194b
#define mmFMT3_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define mmFMT3_FMT_CLAMP_COMPONENT_B                                                                   0x194c
#define mmFMT3_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define mmFMT3_FMT_DYNAMIC_EXP_CNTL                                                                    0x194d
#define mmFMT3_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define mmFMT3_FMT_CONTROL                                                                             0x194e
#define mmFMT3_FMT_CONTROL_BASE_IDX                                                                    2
#define mmFMT3_FMT_BIT_DEPTH_CONTROL                                                                   0x194f
#define mmFMT3_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define mmFMT3_FMT_DITHER_RAND_R_SEED                                                                  0x1950
#define mmFMT3_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define mmFMT3_FMT_DITHER_RAND_G_SEED                                                                  0x1951
#define mmFMT3_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define mmFMT3_FMT_DITHER_RAND_B_SEED                                                                  0x1952
#define mmFMT3_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define mmFMT3_FMT_CLAMP_CNTL                                                                          0x1953
#define mmFMT3_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define mmFMT3_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x1954
#define mmFMT3_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define mmFMT3_FMT_MAP420_MEMORY_CONTROL                                                               0x1955
#define mmFMT3_FMT_MAP420_MEMORY_CONTROL_BASE_IDX                                                      2
#define mmFMT3_FMT_422_CONTROL                                                                         0x1957
#define mmFMT3_FMT_422_CONTROL_BASE_IDX                                                                2


// addressBlock: dce_dc_opp_dpg3_dispdec
// base address: 0x438
#define mmDPG3_DPG_CONTROL                                                                             0x1962
#define mmDPG3_DPG_CONTROL_BASE_IDX                                                                    2
#define mmDPG3_DPG_RAMP_CONTROL                                                                        0x1963
#define mmDPG3_DPG_RAMP_CONTROL_BASE_IDX                                                               2
#define mmDPG3_DPG_DIMENSIONS                                                                          0x1964
#define mmDPG3_DPG_DIMENSIONS_BASE_IDX                                                                 2
#define mmDPG3_DPG_COLOUR_R_CR                                                                         0x1965
#define mmDPG3_DPG_COLOUR_R_CR_BASE_IDX                                                                2
#define mmDPG3_DPG_COLOUR_G_Y                                                                          0x1966
#define mmDPG3_DPG_COLOUR_G_Y_BASE_IDX                                                                 2
#define mmDPG3_DPG_COLOUR_B_CB                                                                         0x1967
#define mmDPG3_DPG_COLOUR_B_CB_BASE_IDX                                                                2
#define mmDPG3_DPG_OFFSET_SEGMENT                                                                      0x1968
#define mmDPG3_DPG_OFFSET_SEGMENT_BASE_IDX                                                             2
#define mmDPG3_DPG_STATUS                                                                              0x1969
#define mmDPG3_DPG_STATUS_BASE_IDX                                                                     2


// addressBlock: dce_dc_opp_oppbuf3_dispdec
// base address: 0x438
#define mmOPPBUF3_OPPBUF_CONTROL                                                                       0x1992
#define mmOPPBUF3_OPPBUF_CONTROL_BASE_IDX                                                              2
#define mmOPPBUF3_OPPBUF_3D_PARAMETERS_0                                                               0x1993
#define mmOPPBUF3_OPPBUF_3D_PARAMETERS_0_BASE_IDX                                                      2
#define mmOPPBUF3_OPPBUF_3D_PARAMETERS_1                                                               0x1994
#define mmOPPBUF3_OPPBUF_3D_PARAMETERS_1_BASE_IDX                                                      2
#define mmOPPBUF3_OPPBUF_CONTROL1                                                                      0x1997
#define mmOPPBUF3_OPPBUF_CONTROL1_BASE_IDX                                                             2


// addressBlock: dce_dc_opp_opp_pipe3_dispdec
// base address: 0x438
#define mmOPP_PIPE3_OPP_PIPE_CONTROL                                                                   0x199a
#define mmOPP_PIPE3_OPP_PIPE_CONTROL_BASE_IDX                                                          2

// addressBlock: dce_dc_opp_opp_pipe_crc3_dispdec
// base address: 0x438
#define mmOPP_PIPE_CRC3_OPP_PIPE_CRC_CONTROL                                                           0x199f
#define mmOPP_PIPE_CRC3_OPP_PIPE_CRC_CONTROL_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC3_OPP_PIPE_CRC_MASK                                                              0x19a0
#define mmOPP_PIPE_CRC3_OPP_PIPE_CRC_MASK_BASE_IDX                                                     2
#define mmOPP_PIPE_CRC3_OPP_PIPE_CRC_RESULT0                                                           0x19a1
#define mmOPP_PIPE_CRC3_OPP_PIPE_CRC_RESULT0_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC3_OPP_PIPE_CRC_RESULT1                                                           0x19a2
#define mmOPP_PIPE_CRC3_OPP_PIPE_CRC_RESULT1_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC3_OPP_PIPE_CRC_RESULT2                                                           0x19a3
#define mmOPP_PIPE_CRC3_OPP_PIPE_CRC_RESULT2_BASE_IDX                                                  2


// addressBlock: dce_dc_opp_fmt4_dispdec
// base address: 0x5a0
#define mmFMT4_FMT_CLAMP_COMPONENT_R                                                                   0x19a4
#define mmFMT4_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define mmFMT4_FMT_CLAMP_COMPONENT_G                                                                   0x19a5
#define mmFMT4_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define mmFMT4_FMT_CLAMP_COMPONENT_B                                                                   0x19a6
#define mmFMT4_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define mmFMT4_FMT_DYNAMIC_EXP_CNTL                                                                    0x19a7
#define mmFMT4_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define mmFMT4_FMT_CONTROL                                                                             0x19a8
#define mmFMT4_FMT_CONTROL_BASE_IDX                                                                    2
#define mmFMT4_FMT_BIT_DEPTH_CONTROL                                                                   0x19a9
#define mmFMT4_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define mmFMT4_FMT_DITHER_RAND_R_SEED                                                                  0x19aa
#define mmFMT4_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define mmFMT4_FMT_DITHER_RAND_G_SEED                                                                  0x19ab
#define mmFMT4_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define mmFMT4_FMT_DITHER_RAND_B_SEED                                                                  0x19ac
#define mmFMT4_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define mmFMT4_FMT_CLAMP_CNTL                                                                          0x19ad
#define mmFMT4_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define mmFMT4_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x19ae
#define mmFMT4_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define mmFMT4_FMT_MAP420_MEMORY_CONTROL                                                               0x19af
#define mmFMT4_FMT_MAP420_MEMORY_CONTROL_BASE_IDX                                                      2
#define mmFMT4_FMT_422_CONTROL                                                                         0x19b1
#define mmFMT4_FMT_422_CONTROL_BASE_IDX                                                                2


// addressBlock: dce_dc_opp_dpg4_dispdec
// base address: 0x5a0
#define mmDPG4_DPG_CONTROL                                                                             0x19bc
#define mmDPG4_DPG_CONTROL_BASE_IDX                                                                    2
#define mmDPG4_DPG_RAMP_CONTROL                                                                        0x19bd
#define mmDPG4_DPG_RAMP_CONTROL_BASE_IDX                                                               2
#define mmDPG4_DPG_DIMENSIONS                                                                          0x19be
#define mmDPG4_DPG_DIMENSIONS_BASE_IDX                                                                 2
#define mmDPG4_DPG_COLOUR_R_CR                                                                         0x19bf
#define mmDPG4_DPG_COLOUR_R_CR_BASE_IDX                                                                2
#define mmDPG4_DPG_COLOUR_G_Y                                                                          0x19c0
#define mmDPG4_DPG_COLOUR_G_Y_BASE_IDX                                                                 2
#define mmDPG4_DPG_COLOUR_B_CB                                                                         0x19c1
#define mmDPG4_DPG_COLOUR_B_CB_BASE_IDX                                                                2
#define mmDPG4_DPG_OFFSET_SEGMENT                                                                      0x19c2
#define mmDPG4_DPG_OFFSET_SEGMENT_BASE_IDX                                                             2
#define mmDPG4_DPG_STATUS                                                                              0x19c3
#define mmDPG4_DPG_STATUS_BASE_IDX                                                                     2


// addressBlock: dce_dc_opp_oppbuf4_dispdec
// base address: 0x5a0
#define mmOPPBUF4_OPPBUF_CONTROL                                                                       0x19ec
#define mmOPPBUF4_OPPBUF_CONTROL_BASE_IDX                                                              2
#define mmOPPBUF4_OPPBUF_3D_PARAMETERS_0                                                               0x19ed
#define mmOPPBUF4_OPPBUF_3D_PARAMETERS_0_BASE_IDX                                                      2
#define mmOPPBUF4_OPPBUF_3D_PARAMETERS_1                                                               0x19ee
#define mmOPPBUF4_OPPBUF_3D_PARAMETERS_1_BASE_IDX                                                      2
#define mmOPPBUF4_OPPBUF_CONTROL1                                                                      0x19f1
#define mmOPPBUF4_OPPBUF_CONTROL1_BASE_IDX                                                             2


// addressBlock: dce_dc_opp_opp_pipe4_dispdec
// base address: 0x5a0
#define mmOPP_PIPE4_OPP_PIPE_CONTROL                                                                   0x19f4
#define mmOPP_PIPE4_OPP_PIPE_CONTROL_BASE_IDX                                                          2


// addressBlock: dce_dc_opp_opp_pipe_crc4_dispdec
// base address: 0x5a0
#define mmOPP_PIPE_CRC4_OPP_PIPE_CRC_CONTROL                                                           0x19f9
#define mmOPP_PIPE_CRC4_OPP_PIPE_CRC_CONTROL_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC4_OPP_PIPE_CRC_MASK                                                              0x19fa
#define mmOPP_PIPE_CRC4_OPP_PIPE_CRC_MASK_BASE_IDX                                                     2
#define mmOPP_PIPE_CRC4_OPP_PIPE_CRC_RESULT0                                                           0x19fb
#define mmOPP_PIPE_CRC4_OPP_PIPE_CRC_RESULT0_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC4_OPP_PIPE_CRC_RESULT1                                                           0x19fc
#define mmOPP_PIPE_CRC4_OPP_PIPE_CRC_RESULT1_BASE_IDX                                                  2
#define mmOPP_PIPE_CRC4_OPP_PIPE_CRC_RESULT2                                                           0x19fd
#define mmOPP_PIPE_CRC4_OPP_PIPE_CRC_RESULT2_BASE_IDX                                                  2


// addressBlock: dce_dc_opp_opp_top_dispdec
// base address: 0x0
#define mmOPP_TOP_CLK_CONTROL                                                                          0x1a5e
#define mmOPP_TOP_CLK_CONTROL_BASE_IDX                                                                 2
#define mmOPP_ABM_CONTROL                                                                              0x1a60
#define mmOPP_ABM_CONTROL_BASE_IDX                                                                     2


// addressBlock: dce_dc_opp_dscrm0_dispdec
// base address: 0x0
#define mmDSCRM0_DSCRM_DSC_FORWARD_CONFIG                                                              0x1a64
#define mmDSCRM0_DSCRM_DSC_FORWARD_CONFIG_BASE_IDX                                                     2


// addressBlock: dce_dc_opp_dscrm1_dispdec
// base address: 0x4
#define mmDSCRM1_DSCRM_DSC_FORWARD_CONFIG                                                              0x1a65
#define mmDSCRM1_DSCRM_DSC_FORWARD_CONFIG_BASE_IDX                                                     2


// addressBlock: dce_dc_opp_dscrm2_dispdec
// base address: 0x8
#define mmDSCRM2_DSCRM_DSC_FORWARD_CONFIG                                                              0x1a66
#define mmDSCRM2_DSCRM_DSC_FORWARD_CONFIG_BASE_IDX                                                     2


// addressBlock: dce_dc_opp_dscrm3_dispdec
// base address: 0xc
#define mmDSCRM3_DSCRM_DSC_FORWARD_CONFIG                                                              0x1a67
#define mmDSCRM3_DSCRM_DSC_FORWARD_CONFIG_BASE_IDX                                                     2


// addressBlock: dce_dc_opp_dscrm4_dispdec
// base address: 0x10
#define mmDSCRM4_DSCRM_DSC_FORWARD_CONFIG                                                              0x1a68
#define mmDSCRM4_DSCRM_DSC_FORWARD_CONFIG_BASE_IDX                                                     2


// addressBlock: dce_dc_opp_opp_dcperfmon_dc_perfmon_dispdec
// base address: 0x6af8
#define mmDC_PERFMON16_PERFCOUNTER_CNTL                                                                0x1abe
#define mmDC_PERFMON16_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON16_PERFCOUNTER_CNTL2                                                               0x1abf
#define mmDC_PERFMON16_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON16_PERFCOUNTER_STATE                                                               0x1ac0
#define mmDC_PERFMON16_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON16_PERFMON_CNTL                                                                    0x1ac1
#define mmDC_PERFMON16_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON16_PERFMON_CNTL2                                                                   0x1ac2
#define mmDC_PERFMON16_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON16_PERFMON_CVALUE_INT_MISC                                                         0x1ac3
#define mmDC_PERFMON16_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON16_PERFMON_CVALUE_LOW                                                              0x1ac4
#define mmDC_PERFMON16_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON16_PERFMON_HI                                                                      0x1ac5
#define mmDC_PERFMON16_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON16_PERFMON_LOW                                                                     0x1ac6
#define mmDC_PERFMON16_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_optc_odm0_dispdec
// base address: 0x0
#define mmODM0_OPTC_INPUT_GLOBAL_CONTROL                                                               0x1aca
#define mmODM0_OPTC_INPUT_GLOBAL_CONTROL_BASE_IDX                                                      2
#define mmODM0_OPTC_DATA_SOURCE_SELECT                                                                 0x1acb
#define mmODM0_OPTC_DATA_SOURCE_SELECT_BASE_IDX                                                        2
#define mmODM0_OPTC_DATA_FORMAT_CONTROL                                                                0x1acc
#define mmODM0_OPTC_DATA_FORMAT_CONTROL_BASE_IDX                                                       2
#define mmODM0_OPTC_BYTES_PER_PIXEL                                                                    0x1acd
#define mmODM0_OPTC_BYTES_PER_PIXEL_BASE_IDX                                                           2
#define mmODM0_OPTC_WIDTH_CONTROL                                                                      0x1ace
#define mmODM0_OPTC_WIDTH_CONTROL_BASE_IDX                                                             2
#define mmODM0_OPTC_INPUT_CLOCK_CONTROL                                                                0x1acf
#define mmODM0_OPTC_INPUT_CLOCK_CONTROL_BASE_IDX                                                       2
#define mmODM0_OPTC_MEMORY_CONFIG                                                                      0x1ad0
#define mmODM0_OPTC_MEMORY_CONFIG_BASE_IDX                                                             2
#define mmODM0_OPTC_INPUT_SPARE_REGISTER                                                               0x1ad1
#define mmODM0_OPTC_INPUT_SPARE_REGISTER_BASE_IDX                                                      2


// addressBlock: dce_dc_optc_odm1_dispdec
// base address: 0x40
#define mmODM1_OPTC_INPUT_GLOBAL_CONTROL                                                               0x1ada
#define mmODM1_OPTC_INPUT_GLOBAL_CONTROL_BASE_IDX                                                      2
#define mmODM1_OPTC_DATA_SOURCE_SELECT                                                                 0x1adb
#define mmODM1_OPTC_DATA_SOURCE_SELECT_BASE_IDX                                                        2
#define mmODM1_OPTC_DATA_FORMAT_CONTROL                                                                0x1adc
#define mmODM1_OPTC_DATA_FORMAT_CONTROL_BASE_IDX                                                       2
#define mmODM1_OPTC_BYTES_PER_PIXEL                                                                    0x1add
#define mmODM1_OPTC_BYTES_PER_PIXEL_BASE_IDX                                                           2
#define mmODM1_OPTC_WIDTH_CONTROL                                                                      0x1ade
#define mmODM1_OPTC_WIDTH_CONTROL_BASE_IDX                                                             2
#define mmODM1_OPTC_INPUT_CLOCK_CONTROL                                                                0x1adf
#define mmODM1_OPTC_INPUT_CLOCK_CONTROL_BASE_IDX                                                       2
#define mmODM1_OPTC_MEMORY_CONFIG                                                                      0x1ae0
#define mmODM1_OPTC_MEMORY_CONFIG_BASE_IDX                                                             2
#define mmODM1_OPTC_INPUT_SPARE_REGISTER                                                               0x1ae1
#define mmODM1_OPTC_INPUT_SPARE_REGISTER_BASE_IDX                                                      2


// addressBlock: dce_dc_optc_odm2_dispdec
// base address: 0x80
#define mmODM2_OPTC_INPUT_GLOBAL_CONTROL                                                               0x1aea
#define mmODM2_OPTC_INPUT_GLOBAL_CONTROL_BASE_IDX                                                      2
#define mmODM2_OPTC_DATA_SOURCE_SELECT                                                                 0x1aeb
#define mmODM2_OPTC_DATA_SOURCE_SELECT_BASE_IDX                                                        2
#define mmODM2_OPTC_DATA_FORMAT_CONTROL                                                                0x1aec
#define mmODM2_OPTC_DATA_FORMAT_CONTROL_BASE_IDX                                                       2
#define mmODM2_OPTC_BYTES_PER_PIXEL                                                                    0x1aed
#define mmODM2_OPTC_BYTES_PER_PIXEL_BASE_IDX                                                           2
#define mmODM2_OPTC_WIDTH_CONTROL                                                                      0x1aee
#define mmODM2_OPTC_WIDTH_CONTROL_BASE_IDX                                                             2
#define mmODM2_OPTC_INPUT_CLOCK_CONTROL                                                                0x1aef
#define mmODM2_OPTC_INPUT_CLOCK_CONTROL_BASE_IDX                                                       2
#define mmODM2_OPTC_MEMORY_CONFIG                                                                      0x1af0
#define mmODM2_OPTC_MEMORY_CONFIG_BASE_IDX                                                             2
#define mmODM2_OPTC_INPUT_SPARE_REGISTER                                                               0x1af1
#define mmODM2_OPTC_INPUT_SPARE_REGISTER_BASE_IDX                                                      2


// addressBlock: dce_dc_optc_odm3_dispdec
// base address: 0xc0
#define mmODM3_OPTC_INPUT_GLOBAL_CONTROL                                                               0x1afa
#define mmODM3_OPTC_INPUT_GLOBAL_CONTROL_BASE_IDX                                                      2
#define mmODM3_OPTC_DATA_SOURCE_SELECT                                                                 0x1afb
#define mmODM3_OPTC_DATA_SOURCE_SELECT_BASE_IDX                                                        2
#define mmODM3_OPTC_DATA_FORMAT_CONTROL                                                                0x1afc
#define mmODM3_OPTC_DATA_FORMAT_CONTROL_BASE_IDX                                                       2
#define mmODM3_OPTC_BYTES_PER_PIXEL                                                                    0x1afd
#define mmODM3_OPTC_BYTES_PER_PIXEL_BASE_IDX                                                           2
#define mmODM3_OPTC_WIDTH_CONTROL                                                                      0x1afe
#define mmODM3_OPTC_WIDTH_CONTROL_BASE_IDX                                                             2
#define mmODM3_OPTC_INPUT_CLOCK_CONTROL                                                                0x1aff
#define mmODM3_OPTC_INPUT_CLOCK_CONTROL_BASE_IDX                                                       2
#define mmODM3_OPTC_MEMORY_CONFIG                                                                      0x1b00
#define mmODM3_OPTC_MEMORY_CONFIG_BASE_IDX                                                             2
#define mmODM3_OPTC_INPUT_SPARE_REGISTER                                                               0x1b01
#define mmODM3_OPTC_INPUT_SPARE_REGISTER_BASE_IDX                                                      2


// addressBlock: dce_dc_optc_odm4_dispdec
// base address: 0x100
#define mmODM4_OPTC_INPUT_GLOBAL_CONTROL                                                               0x1b0a
#define mmODM4_OPTC_INPUT_GLOBAL_CONTROL_BASE_IDX                                                      2
#define mmODM4_OPTC_DATA_SOURCE_SELECT                                                                 0x1b0b
#define mmODM4_OPTC_DATA_SOURCE_SELECT_BASE_IDX                                                        2
#define mmODM4_OPTC_DATA_FORMAT_CONTROL                                                                0x1b0c
#define mmODM4_OPTC_DATA_FORMAT_CONTROL_BASE_IDX                                                       2
#define mmODM4_OPTC_BYTES_PER_PIXEL                                                                    0x1b0d
#define mmODM4_OPTC_BYTES_PER_PIXEL_BASE_IDX                                                           2
#define mmODM4_OPTC_WIDTH_CONTROL                                                                      0x1b0e
#define mmODM4_OPTC_WIDTH_CONTROL_BASE_IDX                                                             2
#define mmODM4_OPTC_INPUT_CLOCK_CONTROL                                                                0x1b0f
#define mmODM4_OPTC_INPUT_CLOCK_CONTROL_BASE_IDX                                                       2
#define mmODM4_OPTC_MEMORY_CONFIG                                                                      0x1b10
#define mmODM4_OPTC_MEMORY_CONFIG_BASE_IDX                                                             2
#define mmODM4_OPTC_INPUT_SPARE_REGISTER                                                               0x1b11
#define mmODM4_OPTC_INPUT_SPARE_REGISTER_BASE_IDX                                                      2


// addressBlock: dce_dc_optc_otg0_dispdec
// base address: 0x0
#define mmOTG0_OTG_H_TOTAL                                                                             0x1b2a
#define mmOTG0_OTG_H_TOTAL_BASE_IDX                                                                    2
#define mmOTG0_OTG_H_BLANK_START_END                                                                   0x1b2b
#define mmOTG0_OTG_H_BLANK_START_END_BASE_IDX                                                          2
#define mmOTG0_OTG_H_SYNC_A                                                                            0x1b2c
#define mmOTG0_OTG_H_SYNC_A_BASE_IDX                                                                   2
#define mmOTG0_OTG_H_SYNC_A_CNTL                                                                       0x1b2d
#define mmOTG0_OTG_H_SYNC_A_CNTL_BASE_IDX                                                              2
#define mmOTG0_OTG_H_TIMING_CNTL                                                                       0x1b2e
#define mmOTG0_OTG_H_TIMING_CNTL_BASE_IDX                                                              2
#define mmOTG0_OTG_V_TOTAL                                                                             0x1b2f
#define mmOTG0_OTG_V_TOTAL_BASE_IDX                                                                    2
#define mmOTG0_OTG_V_TOTAL_MIN                                                                         0x1b30
#define mmOTG0_OTG_V_TOTAL_MIN_BASE_IDX                                                                2
#define mmOTG0_OTG_V_TOTAL_MAX                                                                         0x1b31
#define mmOTG0_OTG_V_TOTAL_MAX_BASE_IDX                                                                2
#define mmOTG0_OTG_V_TOTAL_MID                                                                         0x1b32
#define mmOTG0_OTG_V_TOTAL_MID_BASE_IDX                                                                2
#define mmOTG0_OTG_V_TOTAL_CONTROL                                                                     0x1b33
#define mmOTG0_OTG_V_TOTAL_CONTROL_BASE_IDX                                                            2
#define mmOTG0_OTG_V_TOTAL_INT_STATUS                                                                  0x1b34
#define mmOTG0_OTG_V_TOTAL_INT_STATUS_BASE_IDX                                                         2
#define mmOTG0_OTG_VSYNC_NOM_INT_STATUS                                                                0x1b35
#define mmOTG0_OTG_VSYNC_NOM_INT_STATUS_BASE_IDX                                                       2
#define mmOTG0_OTG_V_BLANK_START_END                                                                   0x1b36
#define mmOTG0_OTG_V_BLANK_START_END_BASE_IDX                                                          2
#define mmOTG0_OTG_V_SYNC_A                                                                            0x1b37
#define mmOTG0_OTG_V_SYNC_A_BASE_IDX                                                                   2
#define mmOTG0_OTG_V_SYNC_A_CNTL                                                                       0x1b38
#define mmOTG0_OTG_V_SYNC_A_CNTL_BASE_IDX                                                              2
#define mmOTG0_OTG_TRIGA_CNTL                                                                          0x1b39
#define mmOTG0_OTG_TRIGA_CNTL_BASE_IDX                                                                 2
#define mmOTG0_OTG_TRIGA_MANUAL_TRIG                                                                   0x1b3a
#define mmOTG0_OTG_TRIGA_MANUAL_TRIG_BASE_IDX                                                          2
#define mmOTG0_OTG_TRIGB_CNTL                                                                          0x1b3b
#define mmOTG0_OTG_TRIGB_CNTL_BASE_IDX                                                                 2
#define mmOTG0_OTG_TRIGB_MANUAL_TRIG                                                                   0x1b3c
#define mmOTG0_OTG_TRIGB_MANUAL_TRIG_BASE_IDX                                                          2
#define mmOTG0_OTG_FORCE_COUNT_NOW_CNTL                                                                0x1b3d
#define mmOTG0_OTG_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                       2
#define mmOTG0_OTG_FLOW_CONTROL                                                                        0x1b3e
#define mmOTG0_OTG_FLOW_CONTROL_BASE_IDX                                                               2
#define mmOTG0_OTG_STEREO_FORCE_NEXT_EYE                                                               0x1b3f
#define mmOTG0_OTG_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                      2
#define mmOTG0_OTG_CONTROL                                                                             0x1b41
#define mmOTG0_OTG_CONTROL_BASE_IDX                                                                    2
#define mmOTG0_OTG_INTERLACE_CONTROL                                                                   0x1b44
#define mmOTG0_OTG_INTERLACE_CONTROL_BASE_IDX                                                          2
#define mmOTG0_OTG_INTERLACE_STATUS                                                                    0x1b45
#define mmOTG0_OTG_INTERLACE_STATUS_BASE_IDX                                                           2
#define mmOTG0_OTG_PIXEL_DATA_READBACK0                                                                0x1b47
#define mmOTG0_OTG_PIXEL_DATA_READBACK0_BASE_IDX                                                       2
#define mmOTG0_OTG_PIXEL_DATA_READBACK1                                                                0x1b48
#define mmOTG0_OTG_PIXEL_DATA_READBACK1_BASE_IDX                                                       2
#define mmOTG0_OTG_STATUS                                                                              0x1b49
#define mmOTG0_OTG_STATUS_BASE_IDX                                                                     2
#define mmOTG0_OTG_STATUS_POSITION                                                                     0x1b4a
#define mmOTG0_OTG_STATUS_POSITION_BASE_IDX                                                            2
#define mmOTG0_OTG_NOM_VERT_POSITION                                                                   0x1b4b
#define mmOTG0_OTG_NOM_VERT_POSITION_BASE_IDX                                                          2
#define mmOTG0_OTG_STATUS_FRAME_COUNT                                                                  0x1b4c
#define mmOTG0_OTG_STATUS_FRAME_COUNT_BASE_IDX                                                         2
#define mmOTG0_OTG_STATUS_VF_COUNT                                                                     0x1b4d
#define mmOTG0_OTG_STATUS_VF_COUNT_BASE_IDX                                                            2
#define mmOTG0_OTG_STATUS_HV_COUNT                                                                     0x1b4e
#define mmOTG0_OTG_STATUS_HV_COUNT_BASE_IDX                                                            2
#define mmOTG0_OTG_COUNT_CONTROL                                                                       0x1b4f
#define mmOTG0_OTG_COUNT_CONTROL_BASE_IDX                                                              2
#define mmOTG0_OTG_COUNT_RESET                                                                         0x1b50
#define mmOTG0_OTG_COUNT_RESET_BASE_IDX                                                                2
#define mmOTG0_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE                                                        0x1b51
#define mmOTG0_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                               2
#define mmOTG0_OTG_VERT_SYNC_CONTROL                                                                   0x1b52
#define mmOTG0_OTG_VERT_SYNC_CONTROL_BASE_IDX                                                          2
#define mmOTG0_OTG_STEREO_STATUS                                                                       0x1b53
#define mmOTG0_OTG_STEREO_STATUS_BASE_IDX                                                              2
#define mmOTG0_OTG_STEREO_CONTROL                                                                      0x1b54
#define mmOTG0_OTG_STEREO_CONTROL_BASE_IDX                                                             2
#define mmOTG0_OTG_SNAPSHOT_STATUS                                                                     0x1b55
#define mmOTG0_OTG_SNAPSHOT_STATUS_BASE_IDX                                                            2
#define mmOTG0_OTG_SNAPSHOT_CONTROL                                                                    0x1b56
#define mmOTG0_OTG_SNAPSHOT_CONTROL_BASE_IDX                                                           2
#define mmOTG0_OTG_SNAPSHOT_POSITION                                                                   0x1b57
#define mmOTG0_OTG_SNAPSHOT_POSITION_BASE_IDX                                                          2
#define mmOTG0_OTG_SNAPSHOT_FRAME                                                                      0x1b58
#define mmOTG0_OTG_SNAPSHOT_FRAME_BASE_IDX                                                             2
#define mmOTG0_OTG_INTERRUPT_CONTROL                                                                   0x1b59
#define mmOTG0_OTG_INTERRUPT_CONTROL_BASE_IDX                                                          2
#define mmOTG0_OTG_UPDATE_LOCK                                                                         0x1b5a
#define mmOTG0_OTG_UPDATE_LOCK_BASE_IDX                                                                2
#define mmOTG0_OTG_DOUBLE_BUFFER_CONTROL                                                               0x1b5b
#define mmOTG0_OTG_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                      2
#define mmOTG0_OTG_MASTER_EN                                                                           0x1b5c
#define mmOTG0_OTG_MASTER_EN_BASE_IDX                                                                  2
#define mmOTG0_OTG_BLANK_DATA_COLOR                                                                    0x1b5e
#define mmOTG0_OTG_BLANK_DATA_COLOR_BASE_IDX                                                           2
#define mmOTG0_OTG_BLANK_DATA_COLOR_EXT                                                                0x1b5f
#define mmOTG0_OTG_BLANK_DATA_COLOR_EXT_BASE_IDX                                                       2
#define mmOTG0_OTG_VERTICAL_INTERRUPT0_POSITION                                                        0x1b62
#define mmOTG0_OTG_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                               2
#define mmOTG0_OTG_VERTICAL_INTERRUPT0_CONTROL                                                         0x1b63
#define mmOTG0_OTG_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                                2
#define mmOTG0_OTG_VERTICAL_INTERRUPT1_POSITION                                                        0x1b64
#define mmOTG0_OTG_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                               2
#define mmOTG0_OTG_VERTICAL_INTERRUPT1_CONTROL                                                         0x1b65
#define mmOTG0_OTG_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                                2
#define mmOTG0_OTG_VERTICAL_INTERRUPT2_POSITION                                                        0x1b66
#define mmOTG0_OTG_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                               2
#define mmOTG0_OTG_VERTICAL_INTERRUPT2_CONTROL                                                         0x1b67
#define mmOTG0_OTG_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                                2
#define mmOTG0_OTG_CRC_CNTL                                                                            0x1b68
#define mmOTG0_OTG_CRC_CNTL_BASE_IDX                                                                   2
#define mmOTG0_OTG_CRC_CNTL2                                                                           0x1b69
#define mmOTG0_OTG_CRC_CNTL2_BASE_IDX                                                                  2
#define mmOTG0_OTG_CRC0_WINDOWA_X_CONTROL                                                              0x1b6a
#define mmOTG0_OTG_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC0_WINDOWA_Y_CONTROL                                                              0x1b6b
#define mmOTG0_OTG_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC0_WINDOWB_X_CONTROL                                                              0x1b6c
#define mmOTG0_OTG_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC0_WINDOWB_Y_CONTROL                                                              0x1b6d
#define mmOTG0_OTG_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC0_DATA_RG                                                                        0x1b6e
#define mmOTG0_OTG_CRC0_DATA_RG_BASE_IDX                                                               2
#define mmOTG0_OTG_CRC0_DATA_B                                                                         0x1b6f
#define mmOTG0_OTG_CRC0_DATA_B_BASE_IDX                                                                2
#define mmOTG0_OTG_CRC1_WINDOWA_X_CONTROL                                                              0x1b70
#define mmOTG0_OTG_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC1_WINDOWA_Y_CONTROL                                                              0x1b71
#define mmOTG0_OTG_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC1_WINDOWB_X_CONTROL                                                              0x1b72
#define mmOTG0_OTG_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC1_WINDOWB_Y_CONTROL                                                              0x1b73
#define mmOTG0_OTG_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC1_DATA_RG                                                                        0x1b74
#define mmOTG0_OTG_CRC1_DATA_RG_BASE_IDX                                                               2
#define mmOTG0_OTG_CRC1_DATA_B                                                                         0x1b75
#define mmOTG0_OTG_CRC1_DATA_B_BASE_IDX                                                                2
#define mmOTG0_OTG_CRC2_DATA_RG                                                                        0x1b76
#define mmOTG0_OTG_CRC2_DATA_RG_BASE_IDX                                                               2
#define mmOTG0_OTG_CRC2_DATA_B                                                                         0x1b77
#define mmOTG0_OTG_CRC2_DATA_B_BASE_IDX                                                                2
#define mmOTG0_OTG_CRC3_DATA_RG                                                                        0x1b78
#define mmOTG0_OTG_CRC3_DATA_RG_BASE_IDX                                                               2
#define mmOTG0_OTG_CRC3_DATA_B                                                                         0x1b79
#define mmOTG0_OTG_CRC3_DATA_B_BASE_IDX                                                                2
#define mmOTG0_OTG_CRC_SIG_RED_GREEN_MASK                                                              0x1b7a
#define mmOTG0_OTG_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define mmOTG0_OTG_CRC_SIG_BLUE_CONTROL_MASK                                                           0x1b7b
#define mmOTG0_OTG_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define mmOTG0_OTG_STATIC_SCREEN_CONTROL                                                               0x1b82
#define mmOTG0_OTG_STATIC_SCREEN_CONTROL_BASE_IDX                                                      2
#define mmOTG0_OTG_3D_STRUCTURE_CONTROL                                                                0x1b83
#define mmOTG0_OTG_3D_STRUCTURE_CONTROL_BASE_IDX                                                       2
#define mmOTG0_OTG_GSL_VSYNC_GAP                                                                       0x1b84
#define mmOTG0_OTG_GSL_VSYNC_GAP_BASE_IDX                                                              2
#define mmOTG0_OTG_MASTER_UPDATE_MODE                                                                  0x1b85
#define mmOTG0_OTG_MASTER_UPDATE_MODE_BASE_IDX                                                         2
#define mmOTG0_OTG_CLOCK_CONTROL                                                                       0x1b86
#define mmOTG0_OTG_CLOCK_CONTROL_BASE_IDX                                                              2
#define mmOTG0_OTG_VSTARTUP_PARAM                                                                      0x1b87
#define mmOTG0_OTG_VSTARTUP_PARAM_BASE_IDX                                                             2
#define mmOTG0_OTG_VUPDATE_PARAM                                                                       0x1b88
#define mmOTG0_OTG_VUPDATE_PARAM_BASE_IDX                                                              2
#define mmOTG0_OTG_VREADY_PARAM                                                                        0x1b89
#define mmOTG0_OTG_VREADY_PARAM_BASE_IDX                                                               2
#define mmOTG0_OTG_GLOBAL_SYNC_STATUS                                                                  0x1b8a
#define mmOTG0_OTG_GLOBAL_SYNC_STATUS_BASE_IDX                                                         2
#define mmOTG0_OTG_MASTER_UPDATE_LOCK                                                                  0x1b8b
#define mmOTG0_OTG_MASTER_UPDATE_LOCK_BASE_IDX                                                         2
#define mmOTG0_OTG_GSL_CONTROL                                                                         0x1b8c
#define mmOTG0_OTG_GSL_CONTROL_BASE_IDX                                                                2
#define mmOTG0_OTG_GSL_WINDOW_X                                                                        0x1b8d
#define mmOTG0_OTG_GSL_WINDOW_X_BASE_IDX                                                               2
#define mmOTG0_OTG_GSL_WINDOW_Y                                                                        0x1b8e
#define mmOTG0_OTG_GSL_WINDOW_Y_BASE_IDX                                                               2
#define mmOTG0_OTG_VUPDATE_KEEPOUT                                                                     0x1b8f
#define mmOTG0_OTG_VUPDATE_KEEPOUT_BASE_IDX                                                            2
#define mmOTG0_OTG_GLOBAL_CONTROL0                                                                     0x1b90
#define mmOTG0_OTG_GLOBAL_CONTROL0_BASE_IDX                                                            2
#define mmOTG0_OTG_GLOBAL_CONTROL1                                                                     0x1b91
#define mmOTG0_OTG_GLOBAL_CONTROL1_BASE_IDX                                                            2
#define mmOTG0_OTG_GLOBAL_CONTROL2                                                                     0x1b92
#define mmOTG0_OTG_GLOBAL_CONTROL2_BASE_IDX                                                            2
#define mmOTG0_OTG_GLOBAL_CONTROL3                                                                     0x1b93
#define mmOTG0_OTG_GLOBAL_CONTROL3_BASE_IDX                                                            2
#define mmOTG0_OTG_GLOBAL_CONTROL4                                                                     0x1b94
#define mmOTG0_OTG_GLOBAL_CONTROL4_BASE_IDX                                                            2
#define mmOTG0_OTG_TRIG_MANUAL_CONTROL                                                                 0x1b95
#define mmOTG0_OTG_TRIG_MANUAL_CONTROL_BASE_IDX                                                        2
#define mmOTG0_OTG_MANUAL_FLOW_CONTROL                                                                 0x1b96
#define mmOTG0_OTG_MANUAL_FLOW_CONTROL_BASE_IDX                                                        2
#define mmOTG0_OTG_DRR_TIMING_INT_STATUS                                                               0x1b97
#define mmOTG0_OTG_DRR_TIMING_INT_STATUS_BASE_IDX                                                      2
#define mmOTG0_OTG_DRR_V_TOTAL_REACH_RANGE                                                             0x1b98
#define mmOTG0_OTG_DRR_V_TOTAL_REACH_RANGE_BASE_IDX                                                    2
#define mmOTG0_OTG_DRR_V_TOTAL_CHANGE                                                                  0x1b99
#define mmOTG0_OTG_DRR_V_TOTAL_CHANGE_BASE_IDX                                                         2
#define mmOTG0_OTG_DRR_TRIGGER_WINDOW                                                                  0x1b9a
#define mmOTG0_OTG_DRR_TRIGGER_WINDOW_BASE_IDX                                                         2
#define mmOTG0_OTG_DRR_CONTROL                                                                         0x1b9b
#define mmOTG0_OTG_DRR_CONTROL_BASE_IDX                                                                2
#define mmOTG0_OTG_M_CONST_DTO0                                                                        0x1b9c
#define mmOTG0_OTG_M_CONST_DTO0_BASE_IDX                                                               2
#define mmOTG0_OTG_M_CONST_DTO1                                                                        0x1b9d
#define mmOTG0_OTG_M_CONST_DTO1_BASE_IDX                                                               2
#define mmOTG0_OTG_REQUEST_CONTROL                                                                     0x1b9e
#define mmOTG0_OTG_REQUEST_CONTROL_BASE_IDX                                                            2
#define mmOTG0_OTG_DSC_START_POSITION                                                                  0x1b9f
#define mmOTG0_OTG_DSC_START_POSITION_BASE_IDX                                                         2
#define mmOTG0_OTG_PIPE_UPDATE_STATUS                                                                  0x1ba0
#define mmOTG0_OTG_PIPE_UPDATE_STATUS_BASE_IDX                                                         2
#define mmOTG0_OTG_SPARE_REGISTER                                                                      0x1ba2
#define mmOTG0_OTG_SPARE_REGISTER_BASE_IDX                                                             2


// addressBlock: dce_dc_optc_otg1_dispdec
// base address: 0x200
#define mmOTG1_OTG_H_TOTAL                                                                             0x1baa
#define mmOTG1_OTG_H_TOTAL_BASE_IDX                                                                    2
#define mmOTG1_OTG_H_BLANK_START_END                                                                   0x1bab
#define mmOTG1_OTG_H_BLANK_START_END_BASE_IDX                                                          2
#define mmOTG1_OTG_H_SYNC_A                                                                            0x1bac
#define mmOTG1_OTG_H_SYNC_A_BASE_IDX                                                                   2
#define mmOTG1_OTG_H_SYNC_A_CNTL                                                                       0x1bad
#define mmOTG1_OTG_H_SYNC_A_CNTL_BASE_IDX                                                              2
#define mmOTG1_OTG_H_TIMING_CNTL                                                                       0x1bae
#define mmOTG1_OTG_H_TIMING_CNTL_BASE_IDX                                                              2
#define mmOTG1_OTG_V_TOTAL                                                                             0x1baf
#define mmOTG1_OTG_V_TOTAL_BASE_IDX                                                                    2
#define mmOTG1_OTG_V_TOTAL_MIN                                                                         0x1bb0
#define mmOTG1_OTG_V_TOTAL_MIN_BASE_IDX                                                                2
#define mmOTG1_OTG_V_TOTAL_MAX                                                                         0x1bb1
#define mmOTG1_OTG_V_TOTAL_MAX_BASE_IDX                                                                2
#define mmOTG1_OTG_V_TOTAL_MID                                                                         0x1bb2
#define mmOTG1_OTG_V_TOTAL_MID_BASE_IDX                                                                2
#define mmOTG1_OTG_V_TOTAL_CONTROL                                                                     0x1bb3
#define mmOTG1_OTG_V_TOTAL_CONTROL_BASE_IDX                                                            2
#define mmOTG1_OTG_V_TOTAL_INT_STATUS                                                                  0x1bb4
#define mmOTG1_OTG_V_TOTAL_INT_STATUS_BASE_IDX                                                         2
#define mmOTG1_OTG_VSYNC_NOM_INT_STATUS                                                                0x1bb5
#define mmOTG1_OTG_VSYNC_NOM_INT_STATUS_BASE_IDX                                                       2
#define mmOTG1_OTG_V_BLANK_START_END                                                                   0x1bb6
#define mmOTG1_OTG_V_BLANK_START_END_BASE_IDX                                                          2
#define mmOTG1_OTG_V_SYNC_A                                                                            0x1bb7
#define mmOTG1_OTG_V_SYNC_A_BASE_IDX                                                                   2
#define mmOTG1_OTG_V_SYNC_A_CNTL                                                                       0x1bb8
#define mmOTG1_OTG_V_SYNC_A_CNTL_BASE_IDX                                                              2
#define mmOTG1_OTG_TRIGA_CNTL                                                                          0x1bb9
#define mmOTG1_OTG_TRIGA_CNTL_BASE_IDX                                                                 2
#define mmOTG1_OTG_TRIGA_MANUAL_TRIG                                                                   0x1bba
#define mmOTG1_OTG_TRIGA_MANUAL_TRIG_BASE_IDX                                                          2
#define mmOTG1_OTG_TRIGB_CNTL                                                                          0x1bbb
#define mmOTG1_OTG_TRIGB_CNTL_BASE_IDX                                                                 2
#define mmOTG1_OTG_TRIGB_MANUAL_TRIG                                                                   0x1bbc
#define mmOTG1_OTG_TRIGB_MANUAL_TRIG_BASE_IDX                                                          2
#define mmOTG1_OTG_FORCE_COUNT_NOW_CNTL                                                                0x1bbd
#define mmOTG1_OTG_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                       2
#define mmOTG1_OTG_FLOW_CONTROL                                                                        0x1bbe
#define mmOTG1_OTG_FLOW_CONTROL_BASE_IDX                                                               2
#define mmOTG1_OTG_STEREO_FORCE_NEXT_EYE                                                               0x1bbf
#define mmOTG1_OTG_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                      2
#define mmOTG1_OTG_CONTROL                                                                             0x1bc1
#define mmOTG1_OTG_CONTROL_BASE_IDX                                                                    2
#define mmOTG1_OTG_INTERLACE_CONTROL                                                                   0x1bc4
#define mmOTG1_OTG_INTERLACE_CONTROL_BASE_IDX                                                          2
#define mmOTG1_OTG_INTERLACE_STATUS                                                                    0x1bc5
#define mmOTG1_OTG_INTERLACE_STATUS_BASE_IDX                                                           2
#define mmOTG1_OTG_PIXEL_DATA_READBACK0                                                                0x1bc7
#define mmOTG1_OTG_PIXEL_DATA_READBACK0_BASE_IDX                                                       2
#define mmOTG1_OTG_PIXEL_DATA_READBACK1                                                                0x1bc8
#define mmOTG1_OTG_PIXEL_DATA_READBACK1_BASE_IDX                                                       2
#define mmOTG1_OTG_STATUS                                                                              0x1bc9
#define mmOTG1_OTG_STATUS_BASE_IDX                                                                     2
#define mmOTG1_OTG_STATUS_POSITION                                                                     0x1bca
#define mmOTG1_OTG_STATUS_POSITION_BASE_IDX                                                            2
#define mmOTG1_OTG_NOM_VERT_POSITION                                                                   0x1bcb
#define mmOTG1_OTG_NOM_VERT_POSITION_BASE_IDX                                                          2
#define mmOTG1_OTG_STATUS_FRAME_COUNT                                                                  0x1bcc
#define mmOTG1_OTG_STATUS_FRAME_COUNT_BASE_IDX                                                         2
#define mmOTG1_OTG_STATUS_VF_COUNT                                                                     0x1bcd
#define mmOTG1_OTG_STATUS_VF_COUNT_BASE_IDX                                                            2
#define mmOTG1_OTG_STATUS_HV_COUNT                                                                     0x1bce
#define mmOTG1_OTG_STATUS_HV_COUNT_BASE_IDX                                                            2
#define mmOTG1_OTG_COUNT_CONTROL                                                                       0x1bcf
#define mmOTG1_OTG_COUNT_CONTROL_BASE_IDX                                                              2
#define mmOTG1_OTG_COUNT_RESET                                                                         0x1bd0
#define mmOTG1_OTG_COUNT_RESET_BASE_IDX                                                                2
#define mmOTG1_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE                                                        0x1bd1
#define mmOTG1_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                               2
#define mmOTG1_OTG_VERT_SYNC_CONTROL                                                                   0x1bd2
#define mmOTG1_OTG_VERT_SYNC_CONTROL_BASE_IDX                                                          2
#define mmOTG1_OTG_STEREO_STATUS                                                                       0x1bd3
#define mmOTG1_OTG_STEREO_STATUS_BASE_IDX                                                              2
#define mmOTG1_OTG_STEREO_CONTROL                                                                      0x1bd4
#define mmOTG1_OTG_STEREO_CONTROL_BASE_IDX                                                             2
#define mmOTG1_OTG_SNAPSHOT_STATUS                                                                     0x1bd5
#define mmOTG1_OTG_SNAPSHOT_STATUS_BASE_IDX                                                            2
#define mmOTG1_OTG_SNAPSHOT_CONTROL                                                                    0x1bd6
#define mmOTG1_OTG_SNAPSHOT_CONTROL_BASE_IDX                                                           2
#define mmOTG1_OTG_SNAPSHOT_POSITION                                                                   0x1bd7
#define mmOTG1_OTG_SNAPSHOT_POSITION_BASE_IDX                                                          2
#define mmOTG1_OTG_SNAPSHOT_FRAME                                                                      0x1bd8
#define mmOTG1_OTG_SNAPSHOT_FRAME_BASE_IDX                                                             2
#define mmOTG1_OTG_INTERRUPT_CONTROL                                                                   0x1bd9
#define mmOTG1_OTG_INTERRUPT_CONTROL_BASE_IDX                                                          2
#define mmOTG1_OTG_UPDATE_LOCK                                                                         0x1bda
#define mmOTG1_OTG_UPDATE_LOCK_BASE_IDX                                                                2
#define mmOTG1_OTG_DOUBLE_BUFFER_CONTROL                                                               0x1bdb
#define mmOTG1_OTG_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                      2
#define mmOTG1_OTG_MASTER_EN                                                                           0x1bdc
#define mmOTG1_OTG_MASTER_EN_BASE_IDX                                                                  2
#define mmOTG1_OTG_BLANK_DATA_COLOR                                                                    0x1bde
#define mmOTG1_OTG_BLANK_DATA_COLOR_BASE_IDX                                                           2
#define mmOTG1_OTG_BLANK_DATA_COLOR_EXT                                                                0x1bdf
#define mmOTG1_OTG_BLANK_DATA_COLOR_EXT_BASE_IDX                                                       2
#define mmOTG1_OTG_VERTICAL_INTERRUPT0_POSITION                                                        0x1be2
#define mmOTG1_OTG_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                               2
#define mmOTG1_OTG_VERTICAL_INTERRUPT0_CONTROL                                                         0x1be3
#define mmOTG1_OTG_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                                2
#define mmOTG1_OTG_VERTICAL_INTERRUPT1_POSITION                                                        0x1be4
#define mmOTG1_OTG_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                               2
#define mmOTG1_OTG_VERTICAL_INTERRUPT1_CONTROL                                                         0x1be5
#define mmOTG1_OTG_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                                2
#define mmOTG1_OTG_VERTICAL_INTERRUPT2_POSITION                                                        0x1be6
#define mmOTG1_OTG_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                               2
#define mmOTG1_OTG_VERTICAL_INTERRUPT2_CONTROL                                                         0x1be7
#define mmOTG1_OTG_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                                2
#define mmOTG1_OTG_CRC_CNTL                                                                            0x1be8
#define mmOTG1_OTG_CRC_CNTL_BASE_IDX                                                                   2
#define mmOTG1_OTG_CRC_CNTL2                                                                           0x1be9
#define mmOTG1_OTG_CRC_CNTL2_BASE_IDX                                                                  2
#define mmOTG1_OTG_CRC0_WINDOWA_X_CONTROL                                                              0x1bea
#define mmOTG1_OTG_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC0_WINDOWA_Y_CONTROL                                                              0x1beb
#define mmOTG1_OTG_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC0_WINDOWB_X_CONTROL                                                              0x1bec
#define mmOTG1_OTG_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC0_WINDOWB_Y_CONTROL                                                              0x1bed
#define mmOTG1_OTG_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC0_DATA_RG                                                                        0x1bee
#define mmOTG1_OTG_CRC0_DATA_RG_BASE_IDX                                                               2
#define mmOTG1_OTG_CRC0_DATA_B                                                                         0x1bef
#define mmOTG1_OTG_CRC0_DATA_B_BASE_IDX                                                                2
#define mmOTG1_OTG_CRC1_WINDOWA_X_CONTROL                                                              0x1bf0
#define mmOTG1_OTG_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC1_WINDOWA_Y_CONTROL                                                              0x1bf1
#define mmOTG1_OTG_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC1_WINDOWB_X_CONTROL                                                              0x1bf2
#define mmOTG1_OTG_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC1_WINDOWB_Y_CONTROL                                                              0x1bf3
#define mmOTG1_OTG_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC1_DATA_RG                                                                        0x1bf4
#define mmOTG1_OTG_CRC1_DATA_RG_BASE_IDX                                                               2
#define mmOTG1_OTG_CRC1_DATA_B                                                                         0x1bf5
#define mmOTG1_OTG_CRC1_DATA_B_BASE_IDX                                                                2
#define mmOTG1_OTG_CRC2_DATA_RG                                                                        0x1bf6
#define mmOTG1_OTG_CRC2_DATA_RG_BASE_IDX                                                               2
#define mmOTG1_OTG_CRC2_DATA_B                                                                         0x1bf7
#define mmOTG1_OTG_CRC2_DATA_B_BASE_IDX                                                                2
#define mmOTG1_OTG_CRC3_DATA_RG                                                                        0x1bf8
#define mmOTG1_OTG_CRC3_DATA_RG_BASE_IDX                                                               2
#define mmOTG1_OTG_CRC3_DATA_B                                                                         0x1bf9
#define mmOTG1_OTG_CRC3_DATA_B_BASE_IDX                                                                2
#define mmOTG1_OTG_CRC_SIG_RED_GREEN_MASK                                                              0x1bfa
#define mmOTG1_OTG_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define mmOTG1_OTG_CRC_SIG_BLUE_CONTROL_MASK                                                           0x1bfb
#define mmOTG1_OTG_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define mmOTG1_OTG_STATIC_SCREEN_CONTROL                                                               0x1c02
#define mmOTG1_OTG_STATIC_SCREEN_CONTROL_BASE_IDX                                                      2
#define mmOTG1_OTG_3D_STRUCTURE_CONTROL                                                                0x1c03
#define mmOTG1_OTG_3D_STRUCTURE_CONTROL_BASE_IDX                                                       2
#define mmOTG1_OTG_GSL_VSYNC_GAP                                                                       0x1c04
#define mmOTG1_OTG_GSL_VSYNC_GAP_BASE_IDX                                                              2
#define mmOTG1_OTG_MASTER_UPDATE_MODE                                                                  0x1c05
#define mmOTG1_OTG_MASTER_UPDATE_MODE_BASE_IDX                                                         2
#define mmOTG1_OTG_CLOCK_CONTROL                                                                       0x1c06
#define mmOTG1_OTG_CLOCK_CONTROL_BASE_IDX                                                              2
#define mmOTG1_OTG_VSTARTUP_PARAM                                                                      0x1c07
#define mmOTG1_OTG_VSTARTUP_PARAM_BASE_IDX                                                             2
#define mmOTG1_OTG_VUPDATE_PARAM                                                                       0x1c08
#define mmOTG1_OTG_VUPDATE_PARAM_BASE_IDX                                                              2
#define mmOTG1_OTG_VREADY_PARAM                                                                        0x1c09
#define mmOTG1_OTG_VREADY_PARAM_BASE_IDX                                                               2
#define mmOTG1_OTG_GLOBAL_SYNC_STATUS                                                                  0x1c0a
#define mmOTG1_OTG_GLOBAL_SYNC_STATUS_BASE_IDX                                                         2
#define mmOTG1_OTG_MASTER_UPDATE_LOCK                                                                  0x1c0b
#define mmOTG1_OTG_MASTER_UPDATE_LOCK_BASE_IDX                                                         2
#define mmOTG1_OTG_GSL_CONTROL                                                                         0x1c0c
#define mmOTG1_OTG_GSL_CONTROL_BASE_IDX                                                                2
#define mmOTG1_OTG_GSL_WINDOW_X                                                                        0x1c0d
#define mmOTG1_OTG_GSL_WINDOW_X_BASE_IDX                                                               2
#define mmOTG1_OTG_GSL_WINDOW_Y                                                                        0x1c0e
#define mmOTG1_OTG_GSL_WINDOW_Y_BASE_IDX                                                               2
#define mmOTG1_OTG_VUPDATE_KEEPOUT                                                                     0x1c0f
#define mmOTG1_OTG_VUPDATE_KEEPOUT_BASE_IDX                                                            2
#define mmOTG1_OTG_GLOBAL_CONTROL0                                                                     0x1c10
#define mmOTG1_OTG_GLOBAL_CONTROL0_BASE_IDX                                                            2
#define mmOTG1_OTG_GLOBAL_CONTROL1                                                                     0x1c11
#define mmOTG1_OTG_GLOBAL_CONTROL1_BASE_IDX                                                            2
#define mmOTG1_OTG_GLOBAL_CONTROL2                                                                     0x1c12
#define mmOTG1_OTG_GLOBAL_CONTROL2_BASE_IDX                                                            2
#define mmOTG1_OTG_GLOBAL_CONTROL3                                                                     0x1c13
#define mmOTG1_OTG_GLOBAL_CONTROL3_BASE_IDX                                                            2
#define mmOTG1_OTG_GLOBAL_CONTROL4                                                                     0x1c14
#define mmOTG1_OTG_GLOBAL_CONTROL4_BASE_IDX                                                            2
#define mmOTG1_OTG_TRIG_MANUAL_CONTROL                                                                 0x1c15
#define mmOTG1_OTG_TRIG_MANUAL_CONTROL_BASE_IDX                                                        2
#define mmOTG1_OTG_MANUAL_FLOW_CONTROL                                                                 0x1c16
#define mmOTG1_OTG_MANUAL_FLOW_CONTROL_BASE_IDX                                                        2
#define mmOTG1_OTG_DRR_TIMING_INT_STATUS                                                               0x1c17
#define mmOTG1_OTG_DRR_TIMING_INT_STATUS_BASE_IDX                                                      2
#define mmOTG1_OTG_DRR_V_TOTAL_REACH_RANGE                                                             0x1c18
#define mmOTG1_OTG_DRR_V_TOTAL_REACH_RANGE_BASE_IDX                                                    2
#define mmOTG1_OTG_DRR_V_TOTAL_CHANGE                                                                  0x1c19
#define mmOTG1_OTG_DRR_V_TOTAL_CHANGE_BASE_IDX                                                         2
#define mmOTG1_OTG_DRR_TRIGGER_WINDOW                                                                  0x1c1a
#define mmOTG1_OTG_DRR_TRIGGER_WINDOW_BASE_IDX                                                         2
#define mmOTG1_OTG_DRR_CONTROL                                                                         0x1c1b
#define mmOTG1_OTG_DRR_CONTROL_BASE_IDX                                                                2
#define mmOTG1_OTG_M_CONST_DTO0                                                                        0x1c1c
#define mmOTG1_OTG_M_CONST_DTO0_BASE_IDX                                                               2
#define mmOTG1_OTG_M_CONST_DTO1                                                                        0x1c1d
#define mmOTG1_OTG_M_CONST_DTO1_BASE_IDX                                                               2
#define mmOTG1_OTG_REQUEST_CONTROL                                                                     0x1c1e
#define mmOTG1_OTG_REQUEST_CONTROL_BASE_IDX                                                            2
#define mmOTG1_OTG_DSC_START_POSITION                                                                  0x1c1f
#define mmOTG1_OTG_DSC_START_POSITION_BASE_IDX                                                         2
#define mmOTG1_OTG_PIPE_UPDATE_STATUS                                                                  0x1c20
#define mmOTG1_OTG_PIPE_UPDATE_STATUS_BASE_IDX                                                         2
#define mmOTG1_OTG_SPARE_REGISTER                                                                      0x1c22
#define mmOTG1_OTG_SPARE_REGISTER_BASE_IDX                                                             2


// addressBlock: dce_dc_optc_otg2_dispdec
// base address: 0x400
#define mmOTG2_OTG_H_TOTAL                                                                             0x1c2a
#define mmOTG2_OTG_H_TOTAL_BASE_IDX                                                                    2
#define mmOTG2_OTG_H_BLANK_START_END                                                                   0x1c2b
#define mmOTG2_OTG_H_BLANK_START_END_BASE_IDX                                                          2
#define mmOTG2_OTG_H_SYNC_A                                                                            0x1c2c
#define mmOTG2_OTG_H_SYNC_A_BASE_IDX                                                                   2
#define mmOTG2_OTG_H_SYNC_A_CNTL                                                                       0x1c2d
#define mmOTG2_OTG_H_SYNC_A_CNTL_BASE_IDX                                                              2
#define mmOTG2_OTG_H_TIMING_CNTL                                                                       0x1c2e
#define mmOTG2_OTG_H_TIMING_CNTL_BASE_IDX                                                              2
#define mmOTG2_OTG_V_TOTAL                                                                             0x1c2f
#define mmOTG2_OTG_V_TOTAL_BASE_IDX                                                                    2
#define mmOTG2_OTG_V_TOTAL_MIN                                                                         0x1c30
#define mmOTG2_OTG_V_TOTAL_MIN_BASE_IDX                                                                2
#define mmOTG2_OTG_V_TOTAL_MAX                                                                         0x1c31
#define mmOTG2_OTG_V_TOTAL_MAX_BASE_IDX                                                                2
#define mmOTG2_OTG_V_TOTAL_MID                                                                         0x1c32
#define mmOTG2_OTG_V_TOTAL_MID_BASE_IDX                                                                2
#define mmOTG2_OTG_V_TOTAL_CONTROL                                                                     0x1c33
#define mmOTG2_OTG_V_TOTAL_CONTROL_BASE_IDX                                                            2
#define mmOTG2_OTG_V_TOTAL_INT_STATUS                                                                  0x1c34
#define mmOTG2_OTG_V_TOTAL_INT_STATUS_BASE_IDX                                                         2
#define mmOTG2_OTG_VSYNC_NOM_INT_STATUS                                                                0x1c35
#define mmOTG2_OTG_VSYNC_NOM_INT_STATUS_BASE_IDX                                                       2
#define mmOTG2_OTG_V_BLANK_START_END                                                                   0x1c36
#define mmOTG2_OTG_V_BLANK_START_END_BASE_IDX                                                          2
#define mmOTG2_OTG_V_SYNC_A                                                                            0x1c37
#define mmOTG2_OTG_V_SYNC_A_BASE_IDX                                                                   2
#define mmOTG2_OTG_V_SYNC_A_CNTL                                                                       0x1c38
#define mmOTG2_OTG_V_SYNC_A_CNTL_BASE_IDX                                                              2
#define mmOTG2_OTG_TRIGA_CNTL                                                                          0x1c39
#define mmOTG2_OTG_TRIGA_CNTL_BASE_IDX                                                                 2
#define mmOTG2_OTG_TRIGA_MANUAL_TRIG                                                                   0x1c3a
#define mmOTG2_OTG_TRIGA_MANUAL_TRIG_BASE_IDX                                                          2
#define mmOTG2_OTG_TRIGB_CNTL                                                                          0x1c3b
#define mmOTG2_OTG_TRIGB_CNTL_BASE_IDX                                                                 2
#define mmOTG2_OTG_TRIGB_MANUAL_TRIG                                                                   0x1c3c
#define mmOTG2_OTG_TRIGB_MANUAL_TRIG_BASE_IDX                                                          2
#define mmOTG2_OTG_FORCE_COUNT_NOW_CNTL                                                                0x1c3d
#define mmOTG2_OTG_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                       2
#define mmOTG2_OTG_FLOW_CONTROL                                                                        0x1c3e
#define mmOTG2_OTG_FLOW_CONTROL_BASE_IDX                                                               2
#define mmOTG2_OTG_STEREO_FORCE_NEXT_EYE                                                               0x1c3f
#define mmOTG2_OTG_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                      2
#define mmOTG2_OTG_CONTROL                                                                             0x1c41
#define mmOTG2_OTG_CONTROL_BASE_IDX                                                                    2
#define mmOTG2_OTG_INTERLACE_CONTROL                                                                   0x1c44
#define mmOTG2_OTG_INTERLACE_CONTROL_BASE_IDX                                                          2
#define mmOTG2_OTG_INTERLACE_STATUS                                                                    0x1c45
#define mmOTG2_OTG_INTERLACE_STATUS_BASE_IDX                                                           2
#define mmOTG2_OTG_PIXEL_DATA_READBACK0                                                                0x1c47
#define mmOTG2_OTG_PIXEL_DATA_READBACK0_BASE_IDX                                                       2
#define mmOTG2_OTG_PIXEL_DATA_READBACK1                                                                0x1c48
#define mmOTG2_OTG_PIXEL_DATA_READBACK1_BASE_IDX                                                       2
#define mmOTG2_OTG_STATUS                                                                              0x1c49
#define mmOTG2_OTG_STATUS_BASE_IDX                                                                     2
#define mmOTG2_OTG_STATUS_POSITION                                                                     0x1c4a
#define mmOTG2_OTG_STATUS_POSITION_BASE_IDX                                                            2
#define mmOTG2_OTG_NOM_VERT_POSITION                                                                   0x1c4b
#define mmOTG2_OTG_NOM_VERT_POSITION_BASE_IDX                                                          2
#define mmOTG2_OTG_STATUS_FRAME_COUNT                                                                  0x1c4c
#define mmOTG2_OTG_STATUS_FRAME_COUNT_BASE_IDX                                                         2
#define mmOTG2_OTG_STATUS_VF_COUNT                                                                     0x1c4d
#define mmOTG2_OTG_STATUS_VF_COUNT_BASE_IDX                                                            2
#define mmOTG2_OTG_STATUS_HV_COUNT                                                                     0x1c4e
#define mmOTG2_OTG_STATUS_HV_COUNT_BASE_IDX                                                            2
#define mmOTG2_OTG_COUNT_CONTROL                                                                       0x1c4f
#define mmOTG2_OTG_COUNT_CONTROL_BASE_IDX                                                              2
#define mmOTG2_OTG_COUNT_RESET                                                                         0x1c50
#define mmOTG2_OTG_COUNT_RESET_BASE_IDX                                                                2
#define mmOTG2_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE                                                        0x1c51
#define mmOTG2_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                               2
#define mmOTG2_OTG_VERT_SYNC_CONTROL                                                                   0x1c52
#define mmOTG2_OTG_VERT_SYNC_CONTROL_BASE_IDX                                                          2
#define mmOTG2_OTG_STEREO_STATUS                                                                       0x1c53
#define mmOTG2_OTG_STEREO_STATUS_BASE_IDX                                                              2
#define mmOTG2_OTG_STEREO_CONTROL                                                                      0x1c54
#define mmOTG2_OTG_STEREO_CONTROL_BASE_IDX                                                             2
#define mmOTG2_OTG_SNAPSHOT_STATUS                                                                     0x1c55
#define mmOTG2_OTG_SNAPSHOT_STATUS_BASE_IDX                                                            2
#define mmOTG2_OTG_SNAPSHOT_CONTROL                                                                    0x1c56
#define mmOTG2_OTG_SNAPSHOT_CONTROL_BASE_IDX                                                           2
#define mmOTG2_OTG_SNAPSHOT_POSITION                                                                   0x1c57
#define mmOTG2_OTG_SNAPSHOT_POSITION_BASE_IDX                                                          2
#define mmOTG2_OTG_SNAPSHOT_FRAME                                                                      0x1c58
#define mmOTG2_OTG_SNAPSHOT_FRAME_BASE_IDX                                                             2
#define mmOTG2_OTG_INTERRUPT_CONTROL                                                                   0x1c59
#define mmOTG2_OTG_INTERRUPT_CONTROL_BASE_IDX                                                          2
#define mmOTG2_OTG_UPDATE_LOCK                                                                         0x1c5a
#define mmOTG2_OTG_UPDATE_LOCK_BASE_IDX                                                                2
#define mmOTG2_OTG_DOUBLE_BUFFER_CONTROL                                                               0x1c5b
#define mmOTG2_OTG_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                      2
#define mmOTG2_OTG_MASTER_EN                                                                           0x1c5c
#define mmOTG2_OTG_MASTER_EN_BASE_IDX                                                                  2
#define mmOTG2_OTG_BLANK_DATA_COLOR                                                                    0x1c5e
#define mmOTG2_OTG_BLANK_DATA_COLOR_BASE_IDX                                                           2
#define mmOTG2_OTG_BLANK_DATA_COLOR_EXT                                                                0x1c5f
#define mmOTG2_OTG_BLANK_DATA_COLOR_EXT_BASE_IDX                                                       2
#define mmOTG2_OTG_VERTICAL_INTERRUPT0_POSITION                                                        0x1c62
#define mmOTG2_OTG_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                               2
#define mmOTG2_OTG_VERTICAL_INTERRUPT0_CONTROL                                                         0x1c63
#define mmOTG2_OTG_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                                2
#define mmOTG2_OTG_VERTICAL_INTERRUPT1_POSITION                                                        0x1c64
#define mmOTG2_OTG_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                               2
#define mmOTG2_OTG_VERTICAL_INTERRUPT1_CONTROL                                                         0x1c65
#define mmOTG2_OTG_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                                2
#define mmOTG2_OTG_VERTICAL_INTERRUPT2_POSITION                                                        0x1c66
#define mmOTG2_OTG_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                               2
#define mmOTG2_OTG_VERTICAL_INTERRUPT2_CONTROL                                                         0x1c67
#define mmOTG2_OTG_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                                2
#define mmOTG2_OTG_CRC_CNTL                                                                            0x1c68
#define mmOTG2_OTG_CRC_CNTL_BASE_IDX                                                                   2
#define mmOTG2_OTG_CRC_CNTL2                                                                           0x1c69
#define mmOTG2_OTG_CRC_CNTL2_BASE_IDX                                                                  2
#define mmOTG2_OTG_CRC0_WINDOWA_X_CONTROL                                                              0x1c6a
#define mmOTG2_OTG_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define mmOTG2_OTG_CRC0_WINDOWA_Y_CONTROL                                                              0x1c6b
#define mmOTG2_OTG_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG2_OTG_CRC0_WINDOWB_X_CONTROL                                                              0x1c6c
#define mmOTG2_OTG_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define mmOTG2_OTG_CRC0_WINDOWB_Y_CONTROL                                                              0x1c6d
#define mmOTG2_OTG_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG2_OTG_CRC0_DATA_RG                                                                        0x1c6e
#define mmOTG2_OTG_CRC0_DATA_RG_BASE_IDX                                                               2
#define mmOTG2_OTG_CRC0_DATA_B                                                                         0x1c6f
#define mmOTG2_OTG_CRC0_DATA_B_BASE_IDX                                                                2
#define mmOTG2_OTG_CRC1_WINDOWA_X_CONTROL                                                              0x1c70
#define mmOTG2_OTG_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define mmOTG2_OTG_CRC1_WINDOWA_Y_CONTROL                                                              0x1c71
#define mmOTG2_OTG_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG2_OTG_CRC1_WINDOWB_X_CONTROL                                                              0x1c72
#define mmOTG2_OTG_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define mmOTG2_OTG_CRC1_WINDOWB_Y_CONTROL                                                              0x1c73
#define mmOTG2_OTG_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG2_OTG_CRC1_DATA_RG                                                                        0x1c74
#define mmOTG2_OTG_CRC1_DATA_RG_BASE_IDX                                                               2
#define mmOTG2_OTG_CRC1_DATA_B                                                                         0x1c75
#define mmOTG2_OTG_CRC1_DATA_B_BASE_IDX                                                                2
#define mmOTG2_OTG_CRC2_DATA_RG                                                                        0x1c76
#define mmOTG2_OTG_CRC2_DATA_RG_BASE_IDX                                                               2
#define mmOTG2_OTG_CRC2_DATA_B                                                                         0x1c77
#define mmOTG2_OTG_CRC2_DATA_B_BASE_IDX                                                                2
#define mmOTG2_OTG_CRC3_DATA_RG                                                                        0x1c78
#define mmOTG2_OTG_CRC3_DATA_RG_BASE_IDX                                                               2
#define mmOTG2_OTG_CRC3_DATA_B                                                                         0x1c79
#define mmOTG2_OTG_CRC3_DATA_B_BASE_IDX                                                                2
#define mmOTG2_OTG_CRC_SIG_RED_GREEN_MASK                                                              0x1c7a
#define mmOTG2_OTG_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define mmOTG2_OTG_CRC_SIG_BLUE_CONTROL_MASK                                                           0x1c7b
#define mmOTG2_OTG_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define mmOTG2_OTG_STATIC_SCREEN_CONTROL                                                               0x1c82
#define mmOTG2_OTG_STATIC_SCREEN_CONTROL_BASE_IDX                                                      2
#define mmOTG2_OTG_3D_STRUCTURE_CONTROL                                                                0x1c83
#define mmOTG2_OTG_3D_STRUCTURE_CONTROL_BASE_IDX                                                       2
#define mmOTG2_OTG_GSL_VSYNC_GAP                                                                       0x1c84
#define mmOTG2_OTG_GSL_VSYNC_GAP_BASE_IDX                                                              2
#define mmOTG2_OTG_MASTER_UPDATE_MODE                                                                  0x1c85
#define mmOTG2_OTG_MASTER_UPDATE_MODE_BASE_IDX                                                         2
#define mmOTG2_OTG_CLOCK_CONTROL                                                                       0x1c86
#define mmOTG2_OTG_CLOCK_CONTROL_BASE_IDX                                                              2
#define mmOTG2_OTG_VSTARTUP_PARAM                                                                      0x1c87
#define mmOTG2_OTG_VSTARTUP_PARAM_BASE_IDX                                                             2
#define mmOTG2_OTG_VUPDATE_PARAM                                                                       0x1c88
#define mmOTG2_OTG_VUPDATE_PARAM_BASE_IDX                                                              2
#define mmOTG2_OTG_VREADY_PARAM                                                                        0x1c89
#define mmOTG2_OTG_VREADY_PARAM_BASE_IDX                                                               2
#define mmOTG2_OTG_GLOBAL_SYNC_STATUS                                                                  0x1c8a
#define mmOTG2_OTG_GLOBAL_SYNC_STATUS_BASE_IDX                                                         2
#define mmOTG2_OTG_MASTER_UPDATE_LOCK                                                                  0x1c8b
#define mmOTG2_OTG_MASTER_UPDATE_LOCK_BASE_IDX                                                         2
#define mmOTG2_OTG_GSL_CONTROL                                                                         0x1c8c
#define mmOTG2_OTG_GSL_CONTROL_BASE_IDX                                                                2
#define mmOTG2_OTG_GSL_WINDOW_X                                                                        0x1c8d
#define mmOTG2_OTG_GSL_WINDOW_X_BASE_IDX                                                               2
#define mmOTG2_OTG_GSL_WINDOW_Y                                                                        0x1c8e
#define mmOTG2_OTG_GSL_WINDOW_Y_BASE_IDX                                                               2
#define mmOTG2_OTG_VUPDATE_KEEPOUT                                                                     0x1c8f
#define mmOTG2_OTG_VUPDATE_KEEPOUT_BASE_IDX                                                            2
#define mmOTG2_OTG_GLOBAL_CONTROL0                                                                     0x1c90
#define mmOTG2_OTG_GLOBAL_CONTROL0_BASE_IDX                                                            2
#define mmOTG2_OTG_GLOBAL_CONTROL1                                                                     0x1c91
#define mmOTG2_OTG_GLOBAL_CONTROL1_BASE_IDX                                                            2
#define mmOTG2_OTG_GLOBAL_CONTROL2                                                                     0x1c92
#define mmOTG2_OTG_GLOBAL_CONTROL2_BASE_IDX                                                            2
#define mmOTG2_OTG_GLOBAL_CONTROL3                                                                     0x1c93
#define mmOTG2_OTG_GLOBAL_CONTROL3_BASE_IDX                                                            2
#define mmOTG2_OTG_GLOBAL_CONTROL4                                                                     0x1c94
#define mmOTG2_OTG_GLOBAL_CONTROL4_BASE_IDX                                                            2
#define mmOTG2_OTG_TRIG_MANUAL_CONTROL                                                                 0x1c95
#define mmOTG2_OTG_TRIG_MANUAL_CONTROL_BASE_IDX                                                        2
#define mmOTG2_OTG_MANUAL_FLOW_CONTROL                                                                 0x1c96
#define mmOTG2_OTG_MANUAL_FLOW_CONTROL_BASE_IDX                                                        2
#define mmOTG2_OTG_DRR_TIMING_INT_STATUS                                                               0x1c97
#define mmOTG2_OTG_DRR_TIMING_INT_STATUS_BASE_IDX                                                      2
#define mmOTG2_OTG_DRR_V_TOTAL_REACH_RANGE                                                             0x1c98
#define mmOTG2_OTG_DRR_V_TOTAL_REACH_RANGE_BASE_IDX                                                    2
#define mmOTG2_OTG_DRR_V_TOTAL_CHANGE                                                                  0x1c99
#define mmOTG2_OTG_DRR_V_TOTAL_CHANGE_BASE_IDX                                                         2
#define mmOTG2_OTG_DRR_TRIGGER_WINDOW                                                                  0x1c9a
#define mmOTG2_OTG_DRR_TRIGGER_WINDOW_BASE_IDX                                                         2
#define mmOTG2_OTG_DRR_CONTROL                                                                         0x1c9b
#define mmOTG2_OTG_DRR_CONTROL_BASE_IDX                                                                2
#define mmOTG2_OTG_M_CONST_DTO0                                                                        0x1c9c
#define mmOTG2_OTG_M_CONST_DTO0_BASE_IDX                                                               2
#define mmOTG2_OTG_M_CONST_DTO1                                                                        0x1c9d
#define mmOTG2_OTG_M_CONST_DTO1_BASE_IDX                                                               2
#define mmOTG2_OTG_REQUEST_CONTROL                                                                     0x1c9e
#define mmOTG2_OTG_REQUEST_CONTROL_BASE_IDX                                                            2
#define mmOTG2_OTG_DSC_START_POSITION                                                                  0x1c9f
#define mmOTG2_OTG_DSC_START_POSITION_BASE_IDX                                                         2
#define mmOTG2_OTG_PIPE_UPDATE_STATUS                                                                  0x1ca0
#define mmOTG2_OTG_PIPE_UPDATE_STATUS_BASE_IDX                                                         2
#define mmOTG2_OTG_SPARE_REGISTER                                                                      0x1ca2
#define mmOTG2_OTG_SPARE_REGISTER_BASE_IDX                                                             2


// addressBlock: dce_dc_optc_otg3_dispdec
// base address: 0x600
#define mmOTG3_OTG_H_TOTAL                                                                             0x1caa
#define mmOTG3_OTG_H_TOTAL_BASE_IDX                                                                    2
#define mmOTG3_OTG_H_BLANK_START_END                                                                   0x1cab
#define mmOTG3_OTG_H_BLANK_START_END_BASE_IDX                                                          2
#define mmOTG3_OTG_H_SYNC_A                                                                            0x1cac
#define mmOTG3_OTG_H_SYNC_A_BASE_IDX                                                                   2
#define mmOTG3_OTG_H_SYNC_A_CNTL                                                                       0x1cad
#define mmOTG3_OTG_H_SYNC_A_CNTL_BASE_IDX                                                              2
#define mmOTG3_OTG_H_TIMING_CNTL                                                                       0x1cae
#define mmOTG3_OTG_H_TIMING_CNTL_BASE_IDX                                                              2
#define mmOTG3_OTG_V_TOTAL                                                                             0x1caf
#define mmOTG3_OTG_V_TOTAL_BASE_IDX                                                                    2
#define mmOTG3_OTG_V_TOTAL_MIN                                                                         0x1cb0
#define mmOTG3_OTG_V_TOTAL_MIN_BASE_IDX                                                                2
#define mmOTG3_OTG_V_TOTAL_MAX                                                                         0x1cb1
#define mmOTG3_OTG_V_TOTAL_MAX_BASE_IDX                                                                2
#define mmOTG3_OTG_V_TOTAL_MID                                                                         0x1cb2
#define mmOTG3_OTG_V_TOTAL_MID_BASE_IDX                                                                2
#define mmOTG3_OTG_V_TOTAL_CONTROL                                                                     0x1cb3
#define mmOTG3_OTG_V_TOTAL_CONTROL_BASE_IDX                                                            2
#define mmOTG3_OTG_V_TOTAL_INT_STATUS                                                                  0x1cb4
#define mmOTG3_OTG_V_TOTAL_INT_STATUS_BASE_IDX                                                         2
#define mmOTG3_OTG_VSYNC_NOM_INT_STATUS                                                                0x1cb5
#define mmOTG3_OTG_VSYNC_NOM_INT_STATUS_BASE_IDX                                                       2
#define mmOTG3_OTG_V_BLANK_START_END                                                                   0x1cb6
#define mmOTG3_OTG_V_BLANK_START_END_BASE_IDX                                                          2
#define mmOTG3_OTG_V_SYNC_A                                                                            0x1cb7
#define mmOTG3_OTG_V_SYNC_A_BASE_IDX                                                                   2
#define mmOTG3_OTG_V_SYNC_A_CNTL                                                                       0x1cb8
#define mmOTG3_OTG_V_SYNC_A_CNTL_BASE_IDX                                                              2
#define mmOTG3_OTG_TRIGA_CNTL                                                                          0x1cb9
#define mmOTG3_OTG_TRIGA_CNTL_BASE_IDX                                                                 2
#define mmOTG3_OTG_TRIGA_MANUAL_TRIG                                                                   0x1cba
#define mmOTG3_OTG_TRIGA_MANUAL_TRIG_BASE_IDX                                                          2
#define mmOTG3_OTG_TRIGB_CNTL                                                                          0x1cbb
#define mmOTG3_OTG_TRIGB_CNTL_BASE_IDX                                                                 2
#define mmOTG3_OTG_TRIGB_MANUAL_TRIG                                                                   0x1cbc
#define mmOTG3_OTG_TRIGB_MANUAL_TRIG_BASE_IDX                                                          2
#define mmOTG3_OTG_FORCE_COUNT_NOW_CNTL                                                                0x1cbd
#define mmOTG3_OTG_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                       2
#define mmOTG3_OTG_FLOW_CONTROL                                                                        0x1cbe
#define mmOTG3_OTG_FLOW_CONTROL_BASE_IDX                                                               2
#define mmOTG3_OTG_STEREO_FORCE_NEXT_EYE                                                               0x1cbf
#define mmOTG3_OTG_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                      2
#define mmOTG3_OTG_CONTROL                                                                             0x1cc1
#define mmOTG3_OTG_CONTROL_BASE_IDX                                                                    2
#define mmOTG3_OTG_INTERLACE_CONTROL                                                                   0x1cc4
#define mmOTG3_OTG_INTERLACE_CONTROL_BASE_IDX                                                          2
#define mmOTG3_OTG_INTERLACE_STATUS                                                                    0x1cc5
#define mmOTG3_OTG_INTERLACE_STATUS_BASE_IDX                                                           2
#define mmOTG3_OTG_PIXEL_DATA_READBACK0                                                                0x1cc7
#define mmOTG3_OTG_PIXEL_DATA_READBACK0_BASE_IDX                                                       2
#define mmOTG3_OTG_PIXEL_DATA_READBACK1                                                                0x1cc8
#define mmOTG3_OTG_PIXEL_DATA_READBACK1_BASE_IDX                                                       2
#define mmOTG3_OTG_STATUS                                                                              0x1cc9
#define mmOTG3_OTG_STATUS_BASE_IDX                                                                     2
#define mmOTG3_OTG_STATUS_POSITION                                                                     0x1cca
#define mmOTG3_OTG_STATUS_POSITION_BASE_IDX                                                            2
#define mmOTG3_OTG_NOM_VERT_POSITION                                                                   0x1ccb
#define mmOTG3_OTG_NOM_VERT_POSITION_BASE_IDX                                                          2
#define mmOTG3_OTG_STATUS_FRAME_COUNT                                                                  0x1ccc
#define mmOTG3_OTG_STATUS_FRAME_COUNT_BASE_IDX                                                         2
#define mmOTG3_OTG_STATUS_VF_COUNT                                                                     0x1ccd
#define mmOTG3_OTG_STATUS_VF_COUNT_BASE_IDX                                                            2
#define mmOTG3_OTG_STATUS_HV_COUNT                                                                     0x1cce
#define mmOTG3_OTG_STATUS_HV_COUNT_BASE_IDX                                                            2
#define mmOTG3_OTG_COUNT_CONTROL                                                                       0x1ccf
#define mmOTG3_OTG_COUNT_CONTROL_BASE_IDX                                                              2
#define mmOTG3_OTG_COUNT_RESET                                                                         0x1cd0
#define mmOTG3_OTG_COUNT_RESET_BASE_IDX                                                                2
#define mmOTG3_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE                                                        0x1cd1
#define mmOTG3_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                               2
#define mmOTG3_OTG_VERT_SYNC_CONTROL                                                                   0x1cd2
#define mmOTG3_OTG_VERT_SYNC_CONTROL_BASE_IDX                                                          2
#define mmOTG3_OTG_STEREO_STATUS                                                                       0x1cd3
#define mmOTG3_OTG_STEREO_STATUS_BASE_IDX                                                              2
#define mmOTG3_OTG_STEREO_CONTROL                                                                      0x1cd4
#define mmOTG3_OTG_STEREO_CONTROL_BASE_IDX                                                             2
#define mmOTG3_OTG_SNAPSHOT_STATUS                                                                     0x1cd5
#define mmOTG3_OTG_SNAPSHOT_STATUS_BASE_IDX                                                            2
#define mmOTG3_OTG_SNAPSHOT_CONTROL                                                                    0x1cd6
#define mmOTG3_OTG_SNAPSHOT_CONTROL_BASE_IDX                                                           2
#define mmOTG3_OTG_SNAPSHOT_POSITION                                                                   0x1cd7
#define mmOTG3_OTG_SNAPSHOT_POSITION_BASE_IDX                                                          2
#define mmOTG3_OTG_SNAPSHOT_FRAME                                                                      0x1cd8
#define mmOTG3_OTG_SNAPSHOT_FRAME_BASE_IDX                                                             2
#define mmOTG3_OTG_INTERRUPT_CONTROL                                                                   0x1cd9
#define mmOTG3_OTG_INTERRUPT_CONTROL_BASE_IDX                                                          2
#define mmOTG3_OTG_UPDATE_LOCK                                                                         0x1cda
#define mmOTG3_OTG_UPDATE_LOCK_BASE_IDX                                                                2
#define mmOTG3_OTG_DOUBLE_BUFFER_CONTROL                                                               0x1cdb
#define mmOTG3_OTG_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                      2
#define mmOTG3_OTG_MASTER_EN                                                                           0x1cdc
#define mmOTG3_OTG_MASTER_EN_BASE_IDX                                                                  2
#define mmOTG3_OTG_BLANK_DATA_COLOR                                                                    0x1cde
#define mmOTG3_OTG_BLANK_DATA_COLOR_BASE_IDX                                                           2
#define mmOTG3_OTG_BLANK_DATA_COLOR_EXT                                                                0x1cdf
#define mmOTG3_OTG_BLANK_DATA_COLOR_EXT_BASE_IDX                                                       2
#define mmOTG3_OTG_VERTICAL_INTERRUPT0_POSITION                                                        0x1ce2
#define mmOTG3_OTG_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                               2
#define mmOTG3_OTG_VERTICAL_INTERRUPT0_CONTROL                                                         0x1ce3
#define mmOTG3_OTG_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                                2
#define mmOTG3_OTG_VERTICAL_INTERRUPT1_POSITION                                                        0x1ce4
#define mmOTG3_OTG_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                               2
#define mmOTG3_OTG_VERTICAL_INTERRUPT1_CONTROL                                                         0x1ce5
#define mmOTG3_OTG_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                                2
#define mmOTG3_OTG_VERTICAL_INTERRUPT2_POSITION                                                        0x1ce6
#define mmOTG3_OTG_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                               2
#define mmOTG3_OTG_VERTICAL_INTERRUPT2_CONTROL                                                         0x1ce7
#define mmOTG3_OTG_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                                2
#define mmOTG3_OTG_CRC_CNTL                                                                            0x1ce8
#define mmOTG3_OTG_CRC_CNTL_BASE_IDX                                                                   2
#define mmOTG3_OTG_CRC_CNTL2                                                                           0x1ce9
#define mmOTG3_OTG_CRC_CNTL2_BASE_IDX                                                                  2
#define mmOTG3_OTG_CRC0_WINDOWA_X_CONTROL                                                              0x1cea
#define mmOTG3_OTG_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define mmOTG3_OTG_CRC0_WINDOWA_Y_CONTROL                                                              0x1ceb
#define mmOTG3_OTG_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG3_OTG_CRC0_WINDOWB_X_CONTROL                                                              0x1cec
#define mmOTG3_OTG_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define mmOTG3_OTG_CRC0_WINDOWB_Y_CONTROL                                                              0x1ced
#define mmOTG3_OTG_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG3_OTG_CRC0_DATA_RG                                                                        0x1cee
#define mmOTG3_OTG_CRC0_DATA_RG_BASE_IDX                                                               2
#define mmOTG3_OTG_CRC0_DATA_B                                                                         0x1cef
#define mmOTG3_OTG_CRC0_DATA_B_BASE_IDX                                                                2
#define mmOTG3_OTG_CRC1_WINDOWA_X_CONTROL                                                              0x1cf0
#define mmOTG3_OTG_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define mmOTG3_OTG_CRC1_WINDOWA_Y_CONTROL                                                              0x1cf1
#define mmOTG3_OTG_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG3_OTG_CRC1_WINDOWB_X_CONTROL                                                              0x1cf2
#define mmOTG3_OTG_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define mmOTG3_OTG_CRC1_WINDOWB_Y_CONTROL                                                              0x1cf3
#define mmOTG3_OTG_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG3_OTG_CRC1_DATA_RG                                                                        0x1cf4
#define mmOTG3_OTG_CRC1_DATA_RG_BASE_IDX                                                               2
#define mmOTG3_OTG_CRC1_DATA_B                                                                         0x1cf5
#define mmOTG3_OTG_CRC1_DATA_B_BASE_IDX                                                                2
#define mmOTG3_OTG_CRC2_DATA_RG                                                                        0x1cf6
#define mmOTG3_OTG_CRC2_DATA_RG_BASE_IDX                                                               2
#define mmOTG3_OTG_CRC2_DATA_B                                                                         0x1cf7
#define mmOTG3_OTG_CRC2_DATA_B_BASE_IDX                                                                2
#define mmOTG3_OTG_CRC3_DATA_RG                                                                        0x1cf8
#define mmOTG3_OTG_CRC3_DATA_RG_BASE_IDX                                                               2
#define mmOTG3_OTG_CRC3_DATA_B                                                                         0x1cf9
#define mmOTG3_OTG_CRC3_DATA_B_BASE_IDX                                                                2
#define mmOTG3_OTG_CRC_SIG_RED_GREEN_MASK                                                              0x1cfa
#define mmOTG3_OTG_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define mmOTG3_OTG_CRC_SIG_BLUE_CONTROL_MASK                                                           0x1cfb
#define mmOTG3_OTG_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define mmOTG3_OTG_STATIC_SCREEN_CONTROL                                                               0x1d02
#define mmOTG3_OTG_STATIC_SCREEN_CONTROL_BASE_IDX                                                      2
#define mmOTG3_OTG_3D_STRUCTURE_CONTROL                                                                0x1d03
#define mmOTG3_OTG_3D_STRUCTURE_CONTROL_BASE_IDX                                                       2
#define mmOTG3_OTG_GSL_VSYNC_GAP                                                                       0x1d04
#define mmOTG3_OTG_GSL_VSYNC_GAP_BASE_IDX                                                              2
#define mmOTG3_OTG_MASTER_UPDATE_MODE                                                                  0x1d05
#define mmOTG3_OTG_MASTER_UPDATE_MODE_BASE_IDX                                                         2
#define mmOTG3_OTG_CLOCK_CONTROL                                                                       0x1d06
#define mmOTG3_OTG_CLOCK_CONTROL_BASE_IDX                                                              2
#define mmOTG3_OTG_VSTARTUP_PARAM                                                                      0x1d07
#define mmOTG3_OTG_VSTARTUP_PARAM_BASE_IDX                                                             2
#define mmOTG3_OTG_VUPDATE_PARAM                                                                       0x1d08
#define mmOTG3_OTG_VUPDATE_PARAM_BASE_IDX                                                              2
#define mmOTG3_OTG_VREADY_PARAM                                                                        0x1d09
#define mmOTG3_OTG_VREADY_PARAM_BASE_IDX                                                               2
#define mmOTG3_OTG_GLOBAL_SYNC_STATUS                                                                  0x1d0a
#define mmOTG3_OTG_GLOBAL_SYNC_STATUS_BASE_IDX                                                         2
#define mmOTG3_OTG_MASTER_UPDATE_LOCK                                                                  0x1d0b
#define mmOTG3_OTG_MASTER_UPDATE_LOCK_BASE_IDX                                                         2
#define mmOTG3_OTG_GSL_CONTROL                                                                         0x1d0c
#define mmOTG3_OTG_GSL_CONTROL_BASE_IDX                                                                2
#define mmOTG3_OTG_GSL_WINDOW_X                                                                        0x1d0d
#define mmOTG3_OTG_GSL_WINDOW_X_BASE_IDX                                                               2
#define mmOTG3_OTG_GSL_WINDOW_Y                                                                        0x1d0e
#define mmOTG3_OTG_GSL_WINDOW_Y_BASE_IDX                                                               2
#define mmOTG3_OTG_VUPDATE_KEEPOUT                                                                     0x1d0f
#define mmOTG3_OTG_VUPDATE_KEEPOUT_BASE_IDX                                                            2
#define mmOTG3_OTG_GLOBAL_CONTROL0                                                                     0x1d10
#define mmOTG3_OTG_GLOBAL_CONTROL0_BASE_IDX                                                            2
#define mmOTG3_OTG_GLOBAL_CONTROL1                                                                     0x1d11
#define mmOTG3_OTG_GLOBAL_CONTROL1_BASE_IDX                                                            2
#define mmOTG3_OTG_GLOBAL_CONTROL2                                                                     0x1d12
#define mmOTG3_OTG_GLOBAL_CONTROL2_BASE_IDX                                                            2
#define mmOTG3_OTG_GLOBAL_CONTROL3                                                                     0x1d13
#define mmOTG3_OTG_GLOBAL_CONTROL3_BASE_IDX                                                            2
#define mmOTG3_OTG_GLOBAL_CONTROL4                                                                     0x1d14
#define mmOTG3_OTG_GLOBAL_CONTROL4_BASE_IDX                                                            2
#define mmOTG3_OTG_TRIG_MANUAL_CONTROL                                                                 0x1d15
#define mmOTG3_OTG_TRIG_MANUAL_CONTROL_BASE_IDX                                                        2
#define mmOTG3_OTG_MANUAL_FLOW_CONTROL                                                                 0x1d16
#define mmOTG3_OTG_MANUAL_FLOW_CONTROL_BASE_IDX                                                        2
#define mmOTG3_OTG_DRR_TIMING_INT_STATUS                                                               0x1d17
#define mmOTG3_OTG_DRR_TIMING_INT_STATUS_BASE_IDX                                                      2
#define mmOTG3_OTG_DRR_V_TOTAL_REACH_RANGE                                                             0x1d18
#define mmOTG3_OTG_DRR_V_TOTAL_REACH_RANGE_BASE_IDX                                                    2
#define mmOTG3_OTG_DRR_V_TOTAL_CHANGE                                                                  0x1d19
#define mmOTG3_OTG_DRR_V_TOTAL_CHANGE_BASE_IDX                                                         2
#define mmOTG3_OTG_DRR_TRIGGER_WINDOW                                                                  0x1d1a
#define mmOTG3_OTG_DRR_TRIGGER_WINDOW_BASE_IDX                                                         2
#define mmOTG3_OTG_DRR_CONTROL                                                                         0x1d1b
#define mmOTG3_OTG_DRR_CONTROL_BASE_IDX                                                                2
#define mmOTG3_OTG_M_CONST_DTO0                                                                        0x1d1c
#define mmOTG3_OTG_M_CONST_DTO0_BASE_IDX                                                               2
#define mmOTG3_OTG_M_CONST_DTO1                                                                        0x1d1d
#define mmOTG3_OTG_M_CONST_DTO1_BASE_IDX                                                               2
#define mmOTG3_OTG_REQUEST_CONTROL                                                                     0x1d1e
#define mmOTG3_OTG_REQUEST_CONTROL_BASE_IDX                                                            2
#define mmOTG3_OTG_DSC_START_POSITION                                                                  0x1d1f
#define mmOTG3_OTG_DSC_START_POSITION_BASE_IDX                                                         2
#define mmOTG3_OTG_PIPE_UPDATE_STATUS                                                                  0x1d20
#define mmOTG3_OTG_PIPE_UPDATE_STATUS_BASE_IDX                                                         2
#define mmOTG3_OTG_SPARE_REGISTER                                                                      0x1d22
#define mmOTG3_OTG_SPARE_REGISTER_BASE_IDX                                                             2


// addressBlock: dce_dc_optc_otg4_dispdec
// base address: 0x800
#define mmOTG4_OTG_H_TOTAL                                                                             0x1d2a
#define mmOTG4_OTG_H_TOTAL_BASE_IDX                                                                    2
#define mmOTG4_OTG_H_BLANK_START_END                                                                   0x1d2b
#define mmOTG4_OTG_H_BLANK_START_END_BASE_IDX                                                          2
#define mmOTG4_OTG_H_SYNC_A                                                                            0x1d2c
#define mmOTG4_OTG_H_SYNC_A_BASE_IDX                                                                   2
#define mmOTG4_OTG_H_SYNC_A_CNTL                                                                       0x1d2d
#define mmOTG4_OTG_H_SYNC_A_CNTL_BASE_IDX                                                              2
#define mmOTG4_OTG_H_TIMING_CNTL                                                                       0x1d2e
#define mmOTG4_OTG_H_TIMING_CNTL_BASE_IDX                                                              2
#define mmOTG4_OTG_V_TOTAL                                                                             0x1d2f
#define mmOTG4_OTG_V_TOTAL_BASE_IDX                                                                    2
#define mmOTG4_OTG_V_TOTAL_MIN                                                                         0x1d30
#define mmOTG4_OTG_V_TOTAL_MIN_BASE_IDX                                                                2
#define mmOTG4_OTG_V_TOTAL_MAX                                                                         0x1d31
#define mmOTG4_OTG_V_TOTAL_MAX_BASE_IDX                                                                2
#define mmOTG4_OTG_V_TOTAL_MID                                                                         0x1d32
#define mmOTG4_OTG_V_TOTAL_MID_BASE_IDX                                                                2
#define mmOTG4_OTG_V_TOTAL_CONTROL                                                                     0x1d33
#define mmOTG4_OTG_V_TOTAL_CONTROL_BASE_IDX                                                            2
#define mmOTG4_OTG_V_TOTAL_INT_STATUS                                                                  0x1d34
#define mmOTG4_OTG_V_TOTAL_INT_STATUS_BASE_IDX                                                         2
#define mmOTG4_OTG_VSYNC_NOM_INT_STATUS                                                                0x1d35
#define mmOTG4_OTG_VSYNC_NOM_INT_STATUS_BASE_IDX                                                       2
#define mmOTG4_OTG_V_BLANK_START_END                                                                   0x1d36
#define mmOTG4_OTG_V_BLANK_START_END_BASE_IDX                                                          2
#define mmOTG4_OTG_V_SYNC_A                                                                            0x1d37
#define mmOTG4_OTG_V_SYNC_A_BASE_IDX                                                                   2
#define mmOTG4_OTG_V_SYNC_A_CNTL                                                                       0x1d38
#define mmOTG4_OTG_V_SYNC_A_CNTL_BASE_IDX                                                              2
#define mmOTG4_OTG_TRIGA_CNTL                                                                          0x1d39
#define mmOTG4_OTG_TRIGA_CNTL_BASE_IDX                                                                 2
#define mmOTG4_OTG_TRIGA_MANUAL_TRIG                                                                   0x1d3a
#define mmOTG4_OTG_TRIGA_MANUAL_TRIG_BASE_IDX                                                          2
#define mmOTG4_OTG_TRIGB_CNTL                                                                          0x1d3b
#define mmOTG4_OTG_TRIGB_CNTL_BASE_IDX                                                                 2
#define mmOTG4_OTG_TRIGB_MANUAL_TRIG                                                                   0x1d3c
#define mmOTG4_OTG_TRIGB_MANUAL_TRIG_BASE_IDX                                                          2
#define mmOTG4_OTG_FORCE_COUNT_NOW_CNTL                                                                0x1d3d
#define mmOTG4_OTG_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                       2
#define mmOTG4_OTG_FLOW_CONTROL                                                                        0x1d3e
#define mmOTG4_OTG_FLOW_CONTROL_BASE_IDX                                                               2
#define mmOTG4_OTG_STEREO_FORCE_NEXT_EYE                                                               0x1d3f
#define mmOTG4_OTG_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                      2
#define mmOTG4_OTG_CONTROL                                                                             0x1d41
#define mmOTG4_OTG_CONTROL_BASE_IDX                                                                    2
#define mmOTG4_OTG_INTERLACE_CONTROL                                                                   0x1d44
#define mmOTG4_OTG_INTERLACE_CONTROL_BASE_IDX                                                          2
#define mmOTG4_OTG_INTERLACE_STATUS                                                                    0x1d45
#define mmOTG4_OTG_INTERLACE_STATUS_BASE_IDX                                                           2
#define mmOTG4_OTG_PIXEL_DATA_READBACK0                                                                0x1d47
#define mmOTG4_OTG_PIXEL_DATA_READBACK0_BASE_IDX                                                       2
#define mmOTG4_OTG_PIXEL_DATA_READBACK1                                                                0x1d48
#define mmOTG4_OTG_PIXEL_DATA_READBACK1_BASE_IDX                                                       2
#define mmOTG4_OTG_STATUS                                                                              0x1d49
#define mmOTG4_OTG_STATUS_BASE_IDX                                                                     2
#define mmOTG4_OTG_STATUS_POSITION                                                                     0x1d4a
#define mmOTG4_OTG_STATUS_POSITION_BASE_IDX                                                            2
#define mmOTG4_OTG_NOM_VERT_POSITION                                                                   0x1d4b
#define mmOTG4_OTG_NOM_VERT_POSITION_BASE_IDX                                                          2
#define mmOTG4_OTG_STATUS_FRAME_COUNT                                                                  0x1d4c
#define mmOTG4_OTG_STATUS_FRAME_COUNT_BASE_IDX                                                         2
#define mmOTG4_OTG_STATUS_VF_COUNT                                                                     0x1d4d
#define mmOTG4_OTG_STATUS_VF_COUNT_BASE_IDX                                                            2
#define mmOTG4_OTG_STATUS_HV_COUNT                                                                     0x1d4e
#define mmOTG4_OTG_STATUS_HV_COUNT_BASE_IDX                                                            2
#define mmOTG4_OTG_COUNT_CONTROL                                                                       0x1d4f
#define mmOTG4_OTG_COUNT_CONTROL_BASE_IDX                                                              2
#define mmOTG4_OTG_COUNT_RESET                                                                         0x1d50
#define mmOTG4_OTG_COUNT_RESET_BASE_IDX                                                                2
#define mmOTG4_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE                                                        0x1d51
#define mmOTG4_OTG_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                               2
#define mmOTG4_OTG_VERT_SYNC_CONTROL                                                                   0x1d52
#define mmOTG4_OTG_VERT_SYNC_CONTROL_BASE_IDX                                                          2
#define mmOTG4_OTG_STEREO_STATUS                                                                       0x1d53
#define mmOTG4_OTG_STEREO_STATUS_BASE_IDX                                                              2
#define mmOTG4_OTG_STEREO_CONTROL                                                                      0x1d54
#define mmOTG4_OTG_STEREO_CONTROL_BASE_IDX                                                             2
#define mmOTG4_OTG_SNAPSHOT_STATUS                                                                     0x1d55
#define mmOTG4_OTG_SNAPSHOT_STATUS_BASE_IDX                                                            2
#define mmOTG4_OTG_SNAPSHOT_CONTROL                                                                    0x1d56
#define mmOTG4_OTG_SNAPSHOT_CONTROL_BASE_IDX                                                           2
#define mmOTG4_OTG_SNAPSHOT_POSITION                                                                   0x1d57
#define mmOTG4_OTG_SNAPSHOT_POSITION_BASE_IDX                                                          2
#define mmOTG4_OTG_SNAPSHOT_FRAME                                                                      0x1d58
#define mmOTG4_OTG_SNAPSHOT_FRAME_BASE_IDX                                                             2
#define mmOTG4_OTG_INTERRUPT_CONTROL                                                                   0x1d59
#define mmOTG4_OTG_INTERRUPT_CONTROL_BASE_IDX                                                          2
#define mmOTG4_OTG_UPDATE_LOCK                                                                         0x1d5a
#define mmOTG4_OTG_UPDATE_LOCK_BASE_IDX                                                                2
#define mmOTG4_OTG_DOUBLE_BUFFER_CONTROL                                                               0x1d5b
#define mmOTG4_OTG_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                      2
#define mmOTG4_OTG_MASTER_EN                                                                           0x1d5c
#define mmOTG4_OTG_MASTER_EN_BASE_IDX                                                                  2
#define mmOTG4_OTG_BLANK_DATA_COLOR                                                                    0x1d5e
#define mmOTG4_OTG_BLANK_DATA_COLOR_BASE_IDX                                                           2
#define mmOTG4_OTG_BLANK_DATA_COLOR_EXT                                                                0x1d5f
#define mmOTG4_OTG_BLANK_DATA_COLOR_EXT_BASE_IDX                                                       2
#define mmOTG4_OTG_VERTICAL_INTERRUPT0_POSITION                                                        0x1d62
#define mmOTG4_OTG_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                               2
#define mmOTG4_OTG_VERTICAL_INTERRUPT0_CONTROL                                                         0x1d63
#define mmOTG4_OTG_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                                2
#define mmOTG4_OTG_VERTICAL_INTERRUPT1_POSITION                                                        0x1d64
#define mmOTG4_OTG_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                               2
#define mmOTG4_OTG_VERTICAL_INTERRUPT1_CONTROL                                                         0x1d65
#define mmOTG4_OTG_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                                2
#define mmOTG4_OTG_VERTICAL_INTERRUPT2_POSITION                                                        0x1d66
#define mmOTG4_OTG_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                               2
#define mmOTG4_OTG_VERTICAL_INTERRUPT2_CONTROL                                                         0x1d67
#define mmOTG4_OTG_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                                2
#define mmOTG4_OTG_CRC_CNTL                                                                            0x1d68
#define mmOTG4_OTG_CRC_CNTL_BASE_IDX                                                                   2
#define mmOTG4_OTG_CRC_CNTL2                                                                           0x1d69
#define mmOTG4_OTG_CRC_CNTL2_BASE_IDX                                                                  2
#define mmOTG4_OTG_CRC0_WINDOWA_X_CONTROL                                                              0x1d6a
#define mmOTG4_OTG_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define mmOTG4_OTG_CRC0_WINDOWA_Y_CONTROL                                                              0x1d6b
#define mmOTG4_OTG_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG4_OTG_CRC0_WINDOWB_X_CONTROL                                                              0x1d6c
#define mmOTG4_OTG_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define mmOTG4_OTG_CRC0_WINDOWB_Y_CONTROL                                                              0x1d6d
#define mmOTG4_OTG_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG4_OTG_CRC0_DATA_RG                                                                        0x1d6e
#define mmOTG4_OTG_CRC0_DATA_RG_BASE_IDX                                                               2
#define mmOTG4_OTG_CRC0_DATA_B                                                                         0x1d6f
#define mmOTG4_OTG_CRC0_DATA_B_BASE_IDX                                                                2
#define mmOTG4_OTG_CRC1_WINDOWA_X_CONTROL                                                              0x1d70
#define mmOTG4_OTG_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                     2
#define mmOTG4_OTG_CRC1_WINDOWA_Y_CONTROL                                                              0x1d71
#define mmOTG4_OTG_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG4_OTG_CRC1_WINDOWB_X_CONTROL                                                              0x1d72
#define mmOTG4_OTG_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                     2
#define mmOTG4_OTG_CRC1_WINDOWB_Y_CONTROL                                                              0x1d73
#define mmOTG4_OTG_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                     2
#define mmOTG4_OTG_CRC1_DATA_RG                                                                        0x1d74
#define mmOTG4_OTG_CRC1_DATA_RG_BASE_IDX                                                               2
#define mmOTG4_OTG_CRC1_DATA_B                                                                         0x1d75
#define mmOTG4_OTG_CRC1_DATA_B_BASE_IDX                                                                2
#define mmOTG4_OTG_CRC2_DATA_RG                                                                        0x1d76
#define mmOTG4_OTG_CRC2_DATA_RG_BASE_IDX                                                               2
#define mmOTG4_OTG_CRC2_DATA_B                                                                         0x1d77
#define mmOTG4_OTG_CRC2_DATA_B_BASE_IDX                                                                2
#define mmOTG4_OTG_CRC3_DATA_RG                                                                        0x1d78
#define mmOTG4_OTG_CRC3_DATA_RG_BASE_IDX                                                               2
#define mmOTG4_OTG_CRC3_DATA_B                                                                         0x1d79
#define mmOTG4_OTG_CRC3_DATA_B_BASE_IDX                                                                2
#define mmOTG4_OTG_CRC_SIG_RED_GREEN_MASK                                                              0x1d7a
#define mmOTG4_OTG_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define mmOTG4_OTG_CRC_SIG_BLUE_CONTROL_MASK                                                           0x1d7b
#define mmOTG4_OTG_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define mmOTG4_OTG_STATIC_SCREEN_CONTROL                                                               0x1d82
#define mmOTG4_OTG_STATIC_SCREEN_CONTROL_BASE_IDX                                                      2
#define mmOTG4_OTG_3D_STRUCTURE_CONTROL                                                                0x1d83
#define mmOTG4_OTG_3D_STRUCTURE_CONTROL_BASE_IDX                                                       2
#define mmOTG4_OTG_GSL_VSYNC_GAP                                                                       0x1d84
#define mmOTG4_OTG_GSL_VSYNC_GAP_BASE_IDX                                                              2
#define mmOTG4_OTG_MASTER_UPDATE_MODE                                                                  0x1d85
#define mmOTG4_OTG_MASTER_UPDATE_MODE_BASE_IDX                                                         2
#define mmOTG4_OTG_CLOCK_CONTROL                                                                       0x1d86
#define mmOTG4_OTG_CLOCK_CONTROL_BASE_IDX                                                              2
#define mmOTG4_OTG_VSTARTUP_PARAM                                                                      0x1d87
#define mmOTG4_OTG_VSTARTUP_PARAM_BASE_IDX                                                             2
#define mmOTG4_OTG_VUPDATE_PARAM                                                                       0x1d88
#define mmOTG4_OTG_VUPDATE_PARAM_BASE_IDX                                                              2
#define mmOTG4_OTG_VREADY_PARAM                                                                        0x1d89
#define mmOTG4_OTG_VREADY_PARAM_BASE_IDX                                                               2
#define mmOTG4_OTG_GLOBAL_SYNC_STATUS                                                                  0x1d8a
#define mmOTG4_OTG_GLOBAL_SYNC_STATUS_BASE_IDX                                                         2
#define mmOTG4_OTG_MASTER_UPDATE_LOCK                                                                  0x1d8b
#define mmOTG4_OTG_MASTER_UPDATE_LOCK_BASE_IDX                                                         2
#define mmOTG4_OTG_GSL_CONTROL                                                                         0x1d8c
#define mmOTG4_OTG_GSL_CONTROL_BASE_IDX                                                                2
#define mmOTG4_OTG_GSL_WINDOW_X                                                                        0x1d8d
#define mmOTG4_OTG_GSL_WINDOW_X_BASE_IDX                                                               2
#define mmOTG4_OTG_GSL_WINDOW_Y                                                                        0x1d8e
#define mmOTG4_OTG_GSL_WINDOW_Y_BASE_IDX                                                               2
#define mmOTG4_OTG_VUPDATE_KEEPOUT                                                                     0x1d8f
#define mmOTG4_OTG_VUPDATE_KEEPOUT_BASE_IDX                                                            2
#define mmOTG4_OTG_GLOBAL_CONTROL0                                                                     0x1d90
#define mmOTG4_OTG_GLOBAL_CONTROL0_BASE_IDX                                                            2
#define mmOTG4_OTG_GLOBAL_CONTROL1                                                                     0x1d91
#define mmOTG4_OTG_GLOBAL_CONTROL1_BASE_IDX                                                            2
#define mmOTG4_OTG_GLOBAL_CONTROL2                                                                     0x1d92
#define mmOTG4_OTG_GLOBAL_CONTROL2_BASE_IDX                                                            2
#define mmOTG4_OTG_GLOBAL_CONTROL3                                                                     0x1d93
#define mmOTG4_OTG_GLOBAL_CONTROL3_BASE_IDX                                                            2
#define mmOTG4_OTG_GLOBAL_CONTROL4                                                                     0x1d94
#define mmOTG4_OTG_GLOBAL_CONTROL4_BASE_IDX                                                            2
#define mmOTG4_OTG_TRIG_MANUAL_CONTROL                                                                 0x1d95
#define mmOTG4_OTG_TRIG_MANUAL_CONTROL_BASE_IDX                                                        2
#define mmOTG4_OTG_MANUAL_FLOW_CONTROL                                                                 0x1d96
#define mmOTG4_OTG_MANUAL_FLOW_CONTROL_BASE_IDX                                                        2
#define mmOTG4_OTG_DRR_TIMING_INT_STATUS                                                               0x1d97
#define mmOTG4_OTG_DRR_TIMING_INT_STATUS_BASE_IDX                                                      2
#define mmOTG4_OTG_DRR_V_TOTAL_REACH_RANGE                                                             0x1d98
#define mmOTG4_OTG_DRR_V_TOTAL_REACH_RANGE_BASE_IDX                                                    2
#define mmOTG4_OTG_DRR_V_TOTAL_CHANGE                                                                  0x1d99
#define mmOTG4_OTG_DRR_V_TOTAL_CHANGE_BASE_IDX                                                         2
#define mmOTG4_OTG_DRR_TRIGGER_WINDOW                                                                  0x1d9a
#define mmOTG4_OTG_DRR_TRIGGER_WINDOW_BASE_IDX                                                         2
#define mmOTG4_OTG_DRR_CONTROL                                                                         0x1d9b
#define mmOTG4_OTG_DRR_CONTROL_BASE_IDX                                                                2
#define mmOTG4_OTG_M_CONST_DTO0                                                                        0x1d9c
#define mmOTG4_OTG_M_CONST_DTO0_BASE_IDX                                                               2
#define mmOTG4_OTG_M_CONST_DTO1                                                                        0x1d9d
#define mmOTG4_OTG_M_CONST_DTO1_BASE_IDX                                                               2
#define mmOTG4_OTG_REQUEST_CONTROL                                                                     0x1d9e
#define mmOTG4_OTG_REQUEST_CONTROL_BASE_IDX                                                            2
#define mmOTG4_OTG_DSC_START_POSITION                                                                  0x1d9f
#define mmOTG4_OTG_DSC_START_POSITION_BASE_IDX                                                         2
#define mmOTG4_OTG_PIPE_UPDATE_STATUS                                                                  0x1da0
#define mmOTG4_OTG_PIPE_UPDATE_STATUS_BASE_IDX                                                         2
#define mmOTG4_OTG_SPARE_REGISTER                                                                      0x1da2
#define mmOTG4_OTG_SPARE_REGISTER_BASE_IDX                                                             2


// addressBlock: dce_dc_optc_optc_misc_dispdec
// base address: 0x0
#define mmDWB_SOURCE_SELECT                                                                            0x1e2a
#define mmDWB_SOURCE_SELECT_BASE_IDX                                                                   2
#define mmGSL_SOURCE_SELECT                                                                            0x1e2b
#define mmGSL_SOURCE_SELECT_BASE_IDX                                                                   2
#define mmOPTC_CLOCK_CONTROL                                                                           0x1e2c
#define mmOPTC_CLOCK_CONTROL_BASE_IDX                                                                  2
#define mmODM_MEM_PWR_CTRL                                                                             0x1e2d
#define mmODM_MEM_PWR_CTRL_BASE_IDX                                                                    2
#define mmODM_MEM_PWR_CTRL2                                                                            0x1e2e
#define mmODM_MEM_PWR_CTRL2_BASE_IDX                                                                   2
#define mmODM_MEM_PWR_CTRL3                                                                            0x1e2f
#define mmODM_MEM_PWR_CTRL3_BASE_IDX                                                                   2
#define mmODM_MEM_PWR_STATUS                                                                           0x1e30
#define mmODM_MEM_PWR_STATUS_BASE_IDX                                                                  2
#define mmOPTC_MISC_SPARE_REGISTER                                                                     0x1e31
#define mmOPTC_MISC_SPARE_REGISTER_BASE_IDX                                                            2


// addressBlock: dce_dc_optc_optc_dcperfmon_dc_perfmon_dispdec
// base address: 0x79a8
#define mmDC_PERFMON17_PERFCOUNTER_CNTL                                                                0x1e6a
#define mmDC_PERFMON17_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON17_PERFCOUNTER_CNTL2                                                               0x1e6b
#define mmDC_PERFMON17_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON17_PERFCOUNTER_STATE                                                               0x1e6c
#define mmDC_PERFMON17_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON17_PERFMON_CNTL                                                                    0x1e6d
#define mmDC_PERFMON17_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON17_PERFMON_CNTL2                                                                   0x1e6e
#define mmDC_PERFMON17_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON17_PERFMON_CVALUE_INT_MISC                                                         0x1e6f
#define mmDC_PERFMON17_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON17_PERFMON_CVALUE_LOW                                                              0x1e70
#define mmDC_PERFMON17_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON17_PERFMON_HI                                                                      0x1e71
#define mmDC_PERFMON17_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON17_PERFMON_LOW                                                                     0x1e72
#define mmDC_PERFMON17_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dio_dout_i2c_dispdec
// base address: 0x0
#define mmDC_I2C_CONTROL                                                                               0x1e98
#define mmDC_I2C_CONTROL_BASE_IDX                                                                      2
#define mmDC_I2C_ARBITRATION                                                                           0x1e99
#define mmDC_I2C_ARBITRATION_BASE_IDX                                                                  2
#define mmDC_I2C_INTERRUPT_CONTROL                                                                     0x1e9a
#define mmDC_I2C_INTERRUPT_CONTROL_BASE_IDX                                                            2
#define mmDC_I2C_SW_STATUS                                                                             0x1e9b
#define mmDC_I2C_SW_STATUS_BASE_IDX                                                                    2
#define mmDC_I2C_DDC1_HW_STATUS                                                                        0x1e9c
#define mmDC_I2C_DDC1_HW_STATUS_BASE_IDX                                                               2
#define mmDC_I2C_DDC2_HW_STATUS                                                                        0x1e9d
#define mmDC_I2C_DDC2_HW_STATUS_BASE_IDX                                                               2
#define mmDC_I2C_DDC3_HW_STATUS                                                                        0x1e9e
#define mmDC_I2C_DDC3_HW_STATUS_BASE_IDX                                                               2
#define mmDC_I2C_DDC4_HW_STATUS                                                                        0x1e9f
#define mmDC_I2C_DDC4_HW_STATUS_BASE_IDX                                                               2
#define mmDC_I2C_DDC5_HW_STATUS                                                                        0x1ea0
#define mmDC_I2C_DDC5_HW_STATUS_BASE_IDX                                                               2
#define mmDC_I2C_DDC1_SPEED                                                                            0x1ea2
#define mmDC_I2C_DDC1_SPEED_BASE_IDX                                                                   2
#define mmDC_I2C_DDC1_SETUP                                                                            0x1ea3
#define mmDC_I2C_DDC1_SETUP_BASE_IDX                                                                   2
#define mmDC_I2C_DDC2_SPEED                                                                            0x1ea4
#define mmDC_I2C_DDC2_SPEED_BASE_IDX                                                                   2
#define mmDC_I2C_DDC2_SETUP                                                                            0x1ea5
#define mmDC_I2C_DDC2_SETUP_BASE_IDX                                                                   2
#define mmDC_I2C_DDC3_SPEED                                                                            0x1ea6
#define mmDC_I2C_DDC3_SPEED_BASE_IDX                                                                   2
#define mmDC_I2C_DDC3_SETUP                                                                            0x1ea7
#define mmDC_I2C_DDC3_SETUP_BASE_IDX                                                                   2
#define mmDC_I2C_DDC4_SPEED                                                                            0x1ea8
#define mmDC_I2C_DDC4_SPEED_BASE_IDX                                                                   2
#define mmDC_I2C_DDC4_SETUP                                                                            0x1ea9
#define mmDC_I2C_DDC4_SETUP_BASE_IDX                                                                   2
#define mmDC_I2C_DDC5_SPEED                                                                            0x1eaa
#define mmDC_I2C_DDC5_SPEED_BASE_IDX                                                                   2
#define mmDC_I2C_DDC5_SETUP                                                                            0x1eab
#define mmDC_I2C_DDC5_SETUP_BASE_IDX                                                                   2
#define mmDC_I2C_TRANSACTION0                                                                          0x1eae
#define mmDC_I2C_TRANSACTION0_BASE_IDX                                                                 2
#define mmDC_I2C_TRANSACTION1                                                                          0x1eaf
#define mmDC_I2C_TRANSACTION1_BASE_IDX                                                                 2
#define mmDC_I2C_TRANSACTION2                                                                          0x1eb0
#define mmDC_I2C_TRANSACTION2_BASE_IDX                                                                 2
#define mmDC_I2C_TRANSACTION3                                                                          0x1eb1
#define mmDC_I2C_TRANSACTION3_BASE_IDX                                                                 2
#define mmDC_I2C_DATA                                                                                  0x1eb2
#define mmDC_I2C_DATA_BASE_IDX                                                                         2
#define mmDC_I2C_EDID_DETECT_CTRL                                                                      0x1eb6
#define mmDC_I2C_EDID_DETECT_CTRL_BASE_IDX                                                             2
#define mmDC_I2C_READ_REQUEST_INTERRUPT                                                                0x1eb7
#define mmDC_I2C_READ_REQUEST_INTERRUPT_BASE_IDX                                                       2


// addressBlock: dce_dc_dio_dio_misc_dispdec
// base address: 0x0
#define mmDIO_SCRATCH0                                                                                 0x1eca
#define mmDIO_SCRATCH0_BASE_IDX                                                                        2
#define mmDIO_SCRATCH1                                                                                 0x1ecb
#define mmDIO_SCRATCH1_BASE_IDX                                                                        2
#define mmDIO_SCRATCH2                                                                                 0x1ecc
#define mmDIO_SCRATCH2_BASE_IDX                                                                        2
#define mmDIO_SCRATCH3                                                                                 0x1ecd
#define mmDIO_SCRATCH3_BASE_IDX                                                                        2
#define mmDIO_SCRATCH4                                                                                 0x1ece
#define mmDIO_SCRATCH4_BASE_IDX                                                                        2
#define mmDIO_SCRATCH5                                                                                 0x1ecf
#define mmDIO_SCRATCH5_BASE_IDX                                                                        2
#define mmDIO_SCRATCH6                                                                                 0x1ed0
#define mmDIO_SCRATCH6_BASE_IDX                                                                        2
#define mmDIO_SCRATCH7                                                                                 0x1ed1
#define mmDIO_SCRATCH7_BASE_IDX                                                                        2
#define mmDIO_MEM_PWR_STATUS                                                                           0x1edd
#define mmDIO_MEM_PWR_STATUS_BASE_IDX                                                                  2
#define mmDIO_MEM_PWR_CTRL                                                                             0x1ede
#define mmDIO_MEM_PWR_CTRL_BASE_IDX                                                                    2
#define mmDIO_MEM_PWR_CTRL2                                                                            0x1edf
#define mmDIO_MEM_PWR_CTRL2_BASE_IDX                                                                   2
#define mmDIO_CLK_CNTL                                                                                 0x1ee0
#define mmDIO_CLK_CNTL_BASE_IDX                                                                        2
#define mmDIO_POWER_MANAGEMENT_CNTL                                                                    0x1ee4
#define mmDIO_POWER_MANAGEMENT_CNTL_BASE_IDX                                                           2
#define mmDIG_SOFT_RESET                                                                               0x1eee
#define mmDIG_SOFT_RESET_BASE_IDX                                                                      2
#define mmDIO_CLK_CNTL2                                                                                0x1ef2
#define mmDIO_CLK_CNTL2_BASE_IDX                                                                       2
#define mmDIO_CLK_CNTL3                                                                                0x1ef3
#define mmDIO_CLK_CNTL3_BASE_IDX                                                                       2
#define mmDIO_HDMI_RXSTATUS_TIMER_CONTROL                                                              0x1eff
#define mmDIO_HDMI_RXSTATUS_TIMER_CONTROL_BASE_IDX                                                     2
#define mmDIO_GENERIC_INTERRUPT_MESSAGE                                                                0x1f02
#define mmDIO_GENERIC_INTERRUPT_MESSAGE_BASE_IDX                                                       2
#define mmDIO_GENERIC_INTERRUPT_CLEAR                                                                  0x1f03
#define mmDIO_GENERIC_INTERRUPT_CLEAR_BASE_IDX                                                         2


// addressBlock: dce_dc_dio_hpd0_dispdec
// base address: 0x0
#define mmHPD0_DC_HPD_INT_STATUS                                                                       0x1f14
#define mmHPD0_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define mmHPD0_DC_HPD_INT_CONTROL                                                                      0x1f15
#define mmHPD0_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define mmHPD0_DC_HPD_CONTROL                                                                          0x1f16
#define mmHPD0_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define mmHPD0_DC_HPD_FAST_TRAIN_CNTL                                                                  0x1f17
#define mmHPD0_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define mmHPD0_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x1f18
#define mmHPD0_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_dio_hpd1_dispdec
// base address: 0x20
#define mmHPD1_DC_HPD_INT_STATUS                                                                       0x1f1c
#define mmHPD1_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define mmHPD1_DC_HPD_INT_CONTROL                                                                      0x1f1d
#define mmHPD1_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define mmHPD1_DC_HPD_CONTROL                                                                          0x1f1e
#define mmHPD1_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define mmHPD1_DC_HPD_FAST_TRAIN_CNTL                                                                  0x1f1f
#define mmHPD1_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define mmHPD1_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x1f20
#define mmHPD1_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_dio_hpd2_dispdec
// base address: 0x40
#define mmHPD2_DC_HPD_INT_STATUS                                                                       0x1f24
#define mmHPD2_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define mmHPD2_DC_HPD_INT_CONTROL                                                                      0x1f25
#define mmHPD2_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define mmHPD2_DC_HPD_CONTROL                                                                          0x1f26
#define mmHPD2_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define mmHPD2_DC_HPD_FAST_TRAIN_CNTL                                                                  0x1f27
#define mmHPD2_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define mmHPD2_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x1f28
#define mmHPD2_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_dio_hpd3_dispdec
// base address: 0x60
#define mmHPD3_DC_HPD_INT_STATUS                                                                       0x1f2c
#define mmHPD3_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define mmHPD3_DC_HPD_INT_CONTROL                                                                      0x1f2d
#define mmHPD3_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define mmHPD3_DC_HPD_CONTROL                                                                          0x1f2e
#define mmHPD3_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define mmHPD3_DC_HPD_FAST_TRAIN_CNTL                                                                  0x1f2f
#define mmHPD3_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define mmHPD3_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x1f30
#define mmHPD3_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_dio_hpd4_dispdec
// base address: 0x80
#define mmHPD4_DC_HPD_INT_STATUS                                                                       0x1f34
#define mmHPD4_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define mmHPD4_DC_HPD_INT_CONTROL                                                                      0x1f35
#define mmHPD4_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define mmHPD4_DC_HPD_CONTROL                                                                          0x1f36
#define mmHPD4_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define mmHPD4_DC_HPD_FAST_TRAIN_CNTL                                                                  0x1f37
#define mmHPD4_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define mmHPD4_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x1f38
#define mmHPD4_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_dio_dio_dcperfmon_dc_perfmon_dispdec
// base address: 0x7d10
#define mmDC_PERFMON18_PERFCOUNTER_CNTL                                                                0x1f44
#define mmDC_PERFMON18_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON18_PERFCOUNTER_CNTL2                                                               0x1f45
#define mmDC_PERFMON18_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON18_PERFCOUNTER_STATE                                                               0x1f46
#define mmDC_PERFMON18_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON18_PERFMON_CNTL                                                                    0x1f47
#define mmDC_PERFMON18_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON18_PERFMON_CNTL2                                                                   0x1f48
#define mmDC_PERFMON18_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON18_PERFMON_CVALUE_INT_MISC                                                         0x1f49
#define mmDC_PERFMON18_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON18_PERFMON_CVALUE_LOW                                                              0x1f4a
#define mmDC_PERFMON18_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON18_PERFMON_HI                                                                      0x1f4b
#define mmDC_PERFMON18_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON18_PERFMON_LOW                                                                     0x1f4c
#define mmDC_PERFMON18_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dio_dp_aux0_dispdec
// base address: 0x0
#define mmDP_AUX0_AUX_CONTROL                                                                          0x1f50
#define mmDP_AUX0_AUX_CONTROL_BASE_IDX                                                                 2
#define mmDP_AUX0_AUX_SW_CONTROL                                                                       0x1f51
#define mmDP_AUX0_AUX_SW_CONTROL_BASE_IDX                                                              2
#define mmDP_AUX0_AUX_ARB_CONTROL                                                                      0x1f52
#define mmDP_AUX0_AUX_ARB_CONTROL_BASE_IDX                                                             2
#define mmDP_AUX0_AUX_INTERRUPT_CONTROL                                                                0x1f53
#define mmDP_AUX0_AUX_INTERRUPT_CONTROL_BASE_IDX                                                       2
#define mmDP_AUX0_AUX_SW_STATUS                                                                        0x1f54
#define mmDP_AUX0_AUX_SW_STATUS_BASE_IDX                                                               2
#define mmDP_AUX0_AUX_LS_STATUS                                                                        0x1f55
#define mmDP_AUX0_AUX_LS_STATUS_BASE_IDX                                                               2
#define mmDP_AUX0_AUX_SW_DATA                                                                          0x1f56
#define mmDP_AUX0_AUX_SW_DATA_BASE_IDX                                                                 2
#define mmDP_AUX0_AUX_LS_DATA                                                                          0x1f57
#define mmDP_AUX0_AUX_LS_DATA_BASE_IDX                                                                 2
#define mmDP_AUX0_AUX_DPHY_TX_REF_CONTROL                                                              0x1f58
#define mmDP_AUX0_AUX_DPHY_TX_REF_CONTROL_BASE_IDX                                                     2
#define mmDP_AUX0_AUX_DPHY_TX_CONTROL                                                                  0x1f59
#define mmDP_AUX0_AUX_DPHY_TX_CONTROL_BASE_IDX                                                         2
#define mmDP_AUX0_AUX_DPHY_RX_CONTROL0                                                                 0x1f5a
#define mmDP_AUX0_AUX_DPHY_RX_CONTROL0_BASE_IDX                                                        2
#define mmDP_AUX0_AUX_DPHY_RX_CONTROL1                                                                 0x1f5b
#define mmDP_AUX0_AUX_DPHY_RX_CONTROL1_BASE_IDX                                                        2
#define mmDP_AUX0_AUX_DPHY_TX_STATUS                                                                   0x1f5c
#define mmDP_AUX0_AUX_DPHY_TX_STATUS_BASE_IDX                                                          2
#define mmDP_AUX0_AUX_DPHY_RX_STATUS                                                                   0x1f5d
#define mmDP_AUX0_AUX_DPHY_RX_STATUS_BASE_IDX                                                          2
#define mmDP_AUX0_AUX_GTC_SYNC_CONTROL                                                                 0x1f5e
#define mmDP_AUX0_AUX_GTC_SYNC_CONTROL_BASE_IDX                                                        2
#define mmDP_AUX0_AUX_GTC_SYNC_ERROR_CONTROL                                                           0x1f5f
#define mmDP_AUX0_AUX_GTC_SYNC_ERROR_CONTROL_BASE_IDX                                                  2
#define mmDP_AUX0_AUX_GTC_SYNC_CONTROLLER_STATUS                                                       0x1f60
#define mmDP_AUX0_AUX_GTC_SYNC_CONTROLLER_STATUS_BASE_IDX                                              2
#define mmDP_AUX0_AUX_GTC_SYNC_STATUS                                                                  0x1f61
#define mmDP_AUX0_AUX_GTC_SYNC_STATUS_BASE_IDX                                                         2
#define mmDP_AUX0_AUX_PHY_WAKE_CNTL                                                                    0x1f66
#define mmDP_AUX0_AUX_PHY_WAKE_CNTL_BASE_IDX                                                           2


// addressBlock: dce_dc_dio_dp_aux1_dispdec
// base address: 0x70
#define mmDP_AUX1_AUX_CONTROL                                                                          0x1f6c
#define mmDP_AUX1_AUX_CONTROL_BASE_IDX                                                                 2
#define mmDP_AUX1_AUX_SW_CONTROL                                                                       0x1f6d
#define mmDP_AUX1_AUX_SW_CONTROL_BASE_IDX                                                              2
#define mmDP_AUX1_AUX_ARB_CONTROL                                                                      0x1f6e
#define mmDP_AUX1_AUX_ARB_CONTROL_BASE_IDX                                                             2
#define mmDP_AUX1_AUX_INTERRUPT_CONTROL                                                                0x1f6f
#define mmDP_AUX1_AUX_INTERRUPT_CONTROL_BASE_IDX                                                       2
#define mmDP_AUX1_AUX_SW_STATUS                                                                        0x1f70
#define mmDP_AUX1_AUX_SW_STATUS_BASE_IDX                                                               2
#define mmDP_AUX1_AUX_LS_STATUS                                                                        0x1f71
#define mmDP_AUX1_AUX_LS_STATUS_BASE_IDX                                                               2
#define mmDP_AUX1_AUX_SW_DATA                                                                          0x1f72
#define mmDP_AUX1_AUX_SW_DATA_BASE_IDX                                                                 2
#define mmDP_AUX1_AUX_LS_DATA                                                                          0x1f73
#define mmDP_AUX1_AUX_LS_DATA_BASE_IDX                                                                 2
#define mmDP_AUX1_AUX_DPHY_TX_REF_CONTROL                                                              0x1f74
#define mmDP_AUX1_AUX_DPHY_TX_REF_CONTROL_BASE_IDX                                                     2
#define mmDP_AUX1_AUX_DPHY_TX_CONTROL                                                                  0x1f75
#define mmDP_AUX1_AUX_DPHY_TX_CONTROL_BASE_IDX                                                         2
#define mmDP_AUX1_AUX_DPHY_RX_CONTROL0                                                                 0x1f76
#define mmDP_AUX1_AUX_DPHY_RX_CONTROL0_BASE_IDX                                                        2
#define mmDP_AUX1_AUX_DPHY_RX_CONTROL1                                                                 0x1f77
#define mmDP_AUX1_AUX_DPHY_RX_CONTROL1_BASE_IDX                                                        2
#define mmDP_AUX1_AUX_DPHY_TX_STATUS                                                                   0x1f78
#define mmDP_AUX1_AUX_DPHY_TX_STATUS_BASE_IDX                                                          2
#define mmDP_AUX1_AUX_DPHY_RX_STATUS                                                                   0x1f79
#define mmDP_AUX1_AUX_DPHY_RX_STATUS_BASE_IDX                                                          2
#define mmDP_AUX1_AUX_GTC_SYNC_CONTROL                                                                 0x1f7a
#define mmDP_AUX1_AUX_GTC_SYNC_CONTROL_BASE_IDX                                                        2
#define mmDP_AUX1_AUX_GTC_SYNC_ERROR_CONTROL                                                           0x1f7b
#define mmDP_AUX1_AUX_GTC_SYNC_ERROR_CONTROL_BASE_IDX                                                  2
#define mmDP_AUX1_AUX_GTC_SYNC_CONTROLLER_STATUS                                                       0x1f7c
#define mmDP_AUX1_AUX_GTC_SYNC_CONTROLLER_STATUS_BASE_IDX                                              2
#define mmDP_AUX1_AUX_GTC_SYNC_STATUS                                                                  0x1f7d
#define mmDP_AUX1_AUX_GTC_SYNC_STATUS_BASE_IDX                                                         2
#define mmDP_AUX1_AUX_PHY_WAKE_CNTL                                                                    0x1f82
#define mmDP_AUX1_AUX_PHY_WAKE_CNTL_BASE_IDX                                                           2


// addressBlock: dce_dc_dio_dp_aux2_dispdec
// base address: 0xe0
#define mmDP_AUX2_AUX_CONTROL                                                                          0x1f88
#define mmDP_AUX2_AUX_CONTROL_BASE_IDX                                                                 2
#define mmDP_AUX2_AUX_SW_CONTROL                                                                       0x1f89
#define mmDP_AUX2_AUX_SW_CONTROL_BASE_IDX                                                              2
#define mmDP_AUX2_AUX_ARB_CONTROL                                                                      0x1f8a
#define mmDP_AUX2_AUX_ARB_CONTROL_BASE_IDX                                                             2
#define mmDP_AUX2_AUX_INTERRUPT_CONTROL                                                                0x1f8b
#define mmDP_AUX2_AUX_INTERRUPT_CONTROL_BASE_IDX                                                       2
#define mmDP_AUX2_AUX_SW_STATUS                                                                        0x1f8c
#define mmDP_AUX2_AUX_SW_STATUS_BASE_IDX                                                               2
#define mmDP_AUX2_AUX_LS_STATUS                                                                        0x1f8d
#define mmDP_AUX2_AUX_LS_STATUS_BASE_IDX                                                               2
#define mmDP_AUX2_AUX_SW_DATA                                                                          0x1f8e
#define mmDP_AUX2_AUX_SW_DATA_BASE_IDX                                                                 2
#define mmDP_AUX2_AUX_LS_DATA                                                                          0x1f8f
#define mmDP_AUX2_AUX_LS_DATA_BASE_IDX                                                                 2
#define mmDP_AUX2_AUX_DPHY_TX_REF_CONTROL                                                              0x1f90
#define mmDP_AUX2_AUX_DPHY_TX_REF_CONTROL_BASE_IDX                                                     2
#define mmDP_AUX2_AUX_DPHY_TX_CONTROL                                                                  0x1f91
#define mmDP_AUX2_AUX_DPHY_TX_CONTROL_BASE_IDX                                                         2
#define mmDP_AUX2_AUX_DPHY_RX_CONTROL0                                                                 0x1f92
#define mmDP_AUX2_AUX_DPHY_RX_CONTROL0_BASE_IDX                                                        2
#define mmDP_AUX2_AUX_DPHY_RX_CONTROL1                                                                 0x1f93
#define mmDP_AUX2_AUX_DPHY_RX_CONTROL1_BASE_IDX                                                        2
#define mmDP_AUX2_AUX_DPHY_TX_STATUS                                                                   0x1f94
#define mmDP_AUX2_AUX_DPHY_TX_STATUS_BASE_IDX                                                          2
#define mmDP_AUX2_AUX_DPHY_RX_STATUS                                                                   0x1f95
#define mmDP_AUX2_AUX_DPHY_RX_STATUS_BASE_IDX                                                          2
#define mmDP_AUX2_AUX_GTC_SYNC_CONTROL                                                                 0x1f96
#define mmDP_AUX2_AUX_GTC_SYNC_CONTROL_BASE_IDX                                                        2
#define mmDP_AUX2_AUX_GTC_SYNC_ERROR_CONTROL                                                           0x1f97
#define mmDP_AUX2_AUX_GTC_SYNC_ERROR_CONTROL_BASE_IDX                                                  2
#define mmDP_AUX2_AUX_GTC_SYNC_CONTROLLER_STATUS                                                       0x1f98
#define mmDP_AUX2_AUX_GTC_SYNC_CONTROLLER_STATUS_BASE_IDX                                              2
#define mmDP_AUX2_AUX_GTC_SYNC_STATUS                                                                  0x1f99
#define mmDP_AUX2_AUX_GTC_SYNC_STATUS_BASE_IDX                                                         2
#define mmDP_AUX2_AUX_PHY_WAKE_CNTL                                                                    0x1f9e
#define mmDP_AUX2_AUX_PHY_WAKE_CNTL_BASE_IDX                                                           2


// addressBlock: dce_dc_dio_dp_aux3_dispdec
// base address: 0x150
#define mmDP_AUX3_AUX_CONTROL                                                                          0x1fa4
#define mmDP_AUX3_AUX_CONTROL_BASE_IDX                                                                 2
#define mmDP_AUX3_AUX_SW_CONTROL                                                                       0x1fa5
#define mmDP_AUX3_AUX_SW_CONTROL_BASE_IDX                                                              2
#define mmDP_AUX3_AUX_ARB_CONTROL                                                                      0x1fa6
#define mmDP_AUX3_AUX_ARB_CONTROL_BASE_IDX                                                             2
#define mmDP_AUX3_AUX_INTERRUPT_CONTROL                                                                0x1fa7
#define mmDP_AUX3_AUX_INTERRUPT_CONTROL_BASE_IDX                                                       2
#define mmDP_AUX3_AUX_SW_STATUS                                                                        0x1fa8
#define mmDP_AUX3_AUX_SW_STATUS_BASE_IDX                                                               2
#define mmDP_AUX3_AUX_LS_STATUS                                                                        0x1fa9
#define mmDP_AUX3_AUX_LS_STATUS_BASE_IDX                                                               2
#define mmDP_AUX3_AUX_SW_DATA                                                                          0x1faa
#define mmDP_AUX3_AUX_SW_DATA_BASE_IDX                                                                 2
#define mmDP_AUX3_AUX_LS_DATA                                                                          0x1fab
#define mmDP_AUX3_AUX_LS_DATA_BASE_IDX                                                                 2
#define mmDP_AUX3_AUX_DPHY_TX_REF_CONTROL                                                              0x1fac
#define mmDP_AUX3_AUX_DPHY_TX_REF_CONTROL_BASE_IDX                                                     2
#define mmDP_AUX3_AUX_DPHY_TX_CONTROL                                                                  0x1fad
#define mmDP_AUX3_AUX_DPHY_TX_CONTROL_BASE_IDX                                                         2
#define mmDP_AUX3_AUX_DPHY_RX_CONTROL0                                                                 0x1fae
#define mmDP_AUX3_AUX_DPHY_RX_CONTROL0_BASE_IDX                                                        2
#define mmDP_AUX3_AUX_DPHY_RX_CONTROL1                                                                 0x1faf
#define mmDP_AUX3_AUX_DPHY_RX_CONTROL1_BASE_IDX                                                        2
#define mmDP_AUX3_AUX_DPHY_TX_STATUS                                                                   0x1fb0
#define mmDP_AUX3_AUX_DPHY_TX_STATUS_BASE_IDX                                                          2
#define mmDP_AUX3_AUX_DPHY_RX_STATUS                                                                   0x1fb1
#define mmDP_AUX3_AUX_DPHY_RX_STATUS_BASE_IDX                                                          2
#define mmDP_AUX3_AUX_GTC_SYNC_CONTROL                                                                 0x1fb2
#define mmDP_AUX3_AUX_GTC_SYNC_CONTROL_BASE_IDX                                                        2
#define mmDP_AUX3_AUX_GTC_SYNC_ERROR_CONTROL                                                           0x1fb3
#define mmDP_AUX3_AUX_GTC_SYNC_ERROR_CONTROL_BASE_IDX                                                  2
#define mmDP_AUX3_AUX_GTC_SYNC_CONTROLLER_STATUS                                                       0x1fb4
#define mmDP_AUX3_AUX_GTC_SYNC_CONTROLLER_STATUS_BASE_IDX                                              2
#define mmDP_AUX3_AUX_GTC_SYNC_STATUS                                                                  0x1fb5
#define mmDP_AUX3_AUX_GTC_SYNC_STATUS_BASE_IDX                                                         2
#define mmDP_AUX3_AUX_PHY_WAKE_CNTL                                                                    0x1fba
#define mmDP_AUX3_AUX_PHY_WAKE_CNTL_BASE_IDX                                                           2


// addressBlock: dce_dc_dio_dp_aux4_dispdec
// base address: 0x1c0
#define mmDP_AUX4_AUX_CONTROL                                                                          0x1fc0
#define mmDP_AUX4_AUX_CONTROL_BASE_IDX                                                                 2
#define mmDP_AUX4_AUX_SW_CONTROL                                                                       0x1fc1
#define mmDP_AUX4_AUX_SW_CONTROL_BASE_IDX                                                              2
#define mmDP_AUX4_AUX_ARB_CONTROL                                                                      0x1fc2
#define mmDP_AUX4_AUX_ARB_CONTROL_BASE_IDX                                                             2
#define mmDP_AUX4_AUX_INTERRUPT_CONTROL                                                                0x1fc3
#define mmDP_AUX4_AUX_INTERRUPT_CONTROL_BASE_IDX                                                       2
#define mmDP_AUX4_AUX_SW_STATUS                                                                        0x1fc4
#define mmDP_AUX4_AUX_SW_STATUS_BASE_IDX                                                               2
#define mmDP_AUX4_AUX_LS_STATUS                                                                        0x1fc5
#define mmDP_AUX4_AUX_LS_STATUS_BASE_IDX                                                               2
#define mmDP_AUX4_AUX_SW_DATA                                                                          0x1fc6
#define mmDP_AUX4_AUX_SW_DATA_BASE_IDX                                                                 2
#define mmDP_AUX4_AUX_LS_DATA                                                                          0x1fc7
#define mmDP_AUX4_AUX_LS_DATA_BASE_IDX                                                                 2
#define mmDP_AUX4_AUX_DPHY_TX_REF_CONTROL                                                              0x1fc8
#define mmDP_AUX4_AUX_DPHY_TX_REF_CONTROL_BASE_IDX                                                     2
#define mmDP_AUX4_AUX_DPHY_TX_CONTROL                                                                  0x1fc9
#define mmDP_AUX4_AUX_DPHY_TX_CONTROL_BASE_IDX                                                         2
#define mmDP_AUX4_AUX_DPHY_RX_CONTROL0                                                                 0x1fca
#define mmDP_AUX4_AUX_DPHY_RX_CONTROL0_BASE_IDX                                                        2
#define mmDP_AUX4_AUX_DPHY_RX_CONTROL1                                                                 0x1fcb
#define mmDP_AUX4_AUX_DPHY_RX_CONTROL1_BASE_IDX                                                        2
#define mmDP_AUX4_AUX_DPHY_TX_STATUS                                                                   0x1fcc
#define mmDP_AUX4_AUX_DPHY_TX_STATUS_BASE_IDX                                                          2
#define mmDP_AUX4_AUX_DPHY_RX_STATUS                                                                   0x1fcd
#define mmDP_AUX4_AUX_DPHY_RX_STATUS_BASE_IDX                                                          2
#define mmDP_AUX4_AUX_GTC_SYNC_CONTROL                                                                 0x1fce
#define mmDP_AUX4_AUX_GTC_SYNC_CONTROL_BASE_IDX                                                        2
#define mmDP_AUX4_AUX_GTC_SYNC_ERROR_CONTROL                                                           0x1fcf
#define mmDP_AUX4_AUX_GTC_SYNC_ERROR_CONTROL_BASE_IDX                                                  2
#define mmDP_AUX4_AUX_GTC_SYNC_CONTROLLER_STATUS                                                       0x1fd0
#define mmDP_AUX4_AUX_GTC_SYNC_CONTROLLER_STATUS_BASE_IDX                                              2
#define mmDP_AUX4_AUX_GTC_SYNC_STATUS                                                                  0x1fd1
#define mmDP_AUX4_AUX_GTC_SYNC_STATUS_BASE_IDX                                                         2
#define mmDP_AUX4_AUX_PHY_WAKE_CNTL                                                                    0x1fd6
#define mmDP_AUX4_AUX_PHY_WAKE_CNTL_BASE_IDX                                                           2


// addressBlock: dce_dc_dio_dig0_vpg_vpg_dispdec
// base address: 0x154a0
#define mmVPG0_VPG_GENERIC_PACKET_ACCESS_CTRL                                                          0x2068
#define mmVPG0_VPG_GENERIC_PACKET_ACCESS_CTRL_BASE_IDX                                                 2
#define mmVPG0_VPG_GENERIC_PACKET_DATA                                                                 0x2069
#define mmVPG0_VPG_GENERIC_PACKET_DATA_BASE_IDX                                                        2
#define mmVPG0_VPG_GSP_FRAME_UPDATE_CTRL                                                               0x206a
#define mmVPG0_VPG_GSP_FRAME_UPDATE_CTRL_BASE_IDX                                                      2
#define mmVPG0_VPG_GSP_IMMEDIATE_UPDATE_CTRL                                                           0x206b
#define mmVPG0_VPG_GSP_IMMEDIATE_UPDATE_CTRL_BASE_IDX                                                  2
#define mmVPG0_VPG_GENERIC_STATUS                                                                      0x206c
#define mmVPG0_VPG_GENERIC_STATUS_BASE_IDX                                                             2
#define mmVPG0_VPG_MEM_PWR                                                                             0x206d
#define mmVPG0_VPG_MEM_PWR_BASE_IDX                                                                    2
#define mmVPG0_VPG_ISRC1_2_ACCESS_CTRL                                                                 0x206e
#define mmVPG0_VPG_ISRC1_2_ACCESS_CTRL_BASE_IDX                                                        2
#define mmVPG0_VPG_ISRC1_2_DATA                                                                        0x206f
#define mmVPG0_VPG_ISRC1_2_DATA_BASE_IDX                                                               2
#define mmVPG0_VPG_MPEG_INFO0                                                                          0x2070
#define mmVPG0_VPG_MPEG_INFO0_BASE_IDX                                                                 2
#define mmVPG0_VPG_MPEG_INFO1                                                                          0x2071
#define mmVPG0_VPG_MPEG_INFO1_BASE_IDX                                                                 2


// addressBlock: dce_dc_dio_dig0_afmt_afmt_dispdec
// base address: 0x154cc
#define mmAFMT0_AFMT_VBI_PACKET_CONTROL                                                                0x2074
#define mmAFMT0_AFMT_VBI_PACKET_CONTROL_BASE_IDX                                                       2
#define mmAFMT0_AFMT_AUDIO_PACKET_CONTROL2                                                             0x2075
#define mmAFMT0_AFMT_AUDIO_PACKET_CONTROL2_BASE_IDX                                                    2
#define mmAFMT0_AFMT_AUDIO_INFO0                                                                       0x2076
#define mmAFMT0_AFMT_AUDIO_INFO0_BASE_IDX                                                              2
#define mmAFMT0_AFMT_AUDIO_INFO1                                                                       0x2077
#define mmAFMT0_AFMT_AUDIO_INFO1_BASE_IDX                                                              2
#define mmAFMT0_AFMT_60958_0                                                                           0x2078
#define mmAFMT0_AFMT_60958_0_BASE_IDX                                                                  2
#define mmAFMT0_AFMT_60958_1                                                                           0x2079
#define mmAFMT0_AFMT_60958_1_BASE_IDX                                                                  2
#define mmAFMT0_AFMT_AUDIO_CRC_CONTROL                                                                 0x207a
#define mmAFMT0_AFMT_AUDIO_CRC_CONTROL_BASE_IDX                                                        2
#define mmAFMT0_AFMT_RAMP_CONTROL0                                                                     0x207b
#define mmAFMT0_AFMT_RAMP_CONTROL0_BASE_IDX                                                            2
#define mmAFMT0_AFMT_RAMP_CONTROL1                                                                     0x207c
#define mmAFMT0_AFMT_RAMP_CONTROL1_BASE_IDX                                                            2
#define mmAFMT0_AFMT_RAMP_CONTROL2                                                                     0x207d
#define mmAFMT0_AFMT_RAMP_CONTROL2_BASE_IDX                                                            2
#define mmAFMT0_AFMT_RAMP_CONTROL3                                                                     0x207e
#define mmAFMT0_AFMT_RAMP_CONTROL3_BASE_IDX                                                            2
#define mmAFMT0_AFMT_60958_2                                                                           0x207f
#define mmAFMT0_AFMT_60958_2_BASE_IDX                                                                  2
#define mmAFMT0_AFMT_AUDIO_CRC_RESULT                                                                  0x2080
#define mmAFMT0_AFMT_AUDIO_CRC_RESULT_BASE_IDX                                                         2
#define mmAFMT0_AFMT_STATUS                                                                            0x2081
#define mmAFMT0_AFMT_STATUS_BASE_IDX                                                                   2
#define mmAFMT0_AFMT_AUDIO_PACKET_CONTROL                                                              0x2082
#define mmAFMT0_AFMT_AUDIO_PACKET_CONTROL_BASE_IDX                                                     2
#define mmAFMT0_AFMT_INFOFRAME_CONTROL0                                                                0x2083
#define mmAFMT0_AFMT_INFOFRAME_CONTROL0_BASE_IDX                                                       2
#define mmAFMT0_AFMT_INTERRUPT_STATUS                                                                  0x2084
#define mmAFMT0_AFMT_INTERRUPT_STATUS_BASE_IDX                                                         2
#define mmAFMT0_AFMT_AUDIO_SRC_CONTROL                                                                 0x2085
#define mmAFMT0_AFMT_AUDIO_SRC_CONTROL_BASE_IDX                                                        2
#define mmAFMT0_AFMT_MEM_PWR                                                                           0x2087
#define mmAFMT0_AFMT_MEM_PWR_BASE_IDX                                                                  2


// addressBlock: dce_dc_dio_dig0_dme_dme_dispdec
// base address: 0x15524
#define mmDME0_DME_CONTROL                                                                             0x2089
#define mmDME0_DME_CONTROL_BASE_IDX                                                                    2
#define mmDME0_DME_MEMORY_CONTROL                                                                      0x208a
#define mmDME0_DME_MEMORY_CONTROL_BASE_IDX                                                             2


// addressBlock: dce_dc_dio_dig0_dispdec
// base address: 0x0
#define mmDIG0_DIG_FE_CNTL                                                                             0x208b
#define mmDIG0_DIG_FE_CNTL_BASE_IDX                                                                    2
#define mmDIG0_DIG_OUTPUT_CRC_CNTL                                                                     0x208c
#define mmDIG0_DIG_OUTPUT_CRC_CNTL_BASE_IDX                                                            2
#define mmDIG0_DIG_OUTPUT_CRC_RESULT                                                                   0x208d
#define mmDIG0_DIG_OUTPUT_CRC_RESULT_BASE_IDX                                                          2
#define mmDIG0_DIG_CLOCK_PATTERN                                                                       0x208e
#define mmDIG0_DIG_CLOCK_PATTERN_BASE_IDX                                                              2
#define mmDIG0_DIG_TEST_PATTERN                                                                        0x208f
#define mmDIG0_DIG_TEST_PATTERN_BASE_IDX                                                               2
#define mmDIG0_DIG_RANDOM_PATTERN_SEED                                                                 0x2090
#define mmDIG0_DIG_RANDOM_PATTERN_SEED_BASE_IDX                                                        2
#define mmDIG0_DIG_FIFO_STATUS                                                                         0x2091
#define mmDIG0_DIG_FIFO_STATUS_BASE_IDX                                                                2
#define mmDIG0_HDMI_METADATA_PACKET_CONTROL                                                            0x2092
#define mmDIG0_HDMI_METADATA_PACKET_CONTROL_BASE_IDX                                                   2
#define mmDIG0_HDMI_CONTROL                                                                            0x2093
#define mmDIG0_HDMI_CONTROL_BASE_IDX                                                                   2
#define mmDIG0_HDMI_STATUS                                                                             0x2094
#define mmDIG0_HDMI_STATUS_BASE_IDX                                                                    2
#define mmDIG0_HDMI_AUDIO_PACKET_CONTROL                                                               0x2095
#define mmDIG0_HDMI_AUDIO_PACKET_CONTROL_BASE_IDX                                                      2
#define mmDIG0_HDMI_ACR_PACKET_CONTROL                                                                 0x2096
#define mmDIG0_HDMI_ACR_PACKET_CONTROL_BASE_IDX                                                        2
#define mmDIG0_HDMI_VBI_PACKET_CONTROL                                                                 0x2097
#define mmDIG0_HDMI_VBI_PACKET_CONTROL_BASE_IDX                                                        2
#define mmDIG0_HDMI_INFOFRAME_CONTROL0                                                                 0x2098
#define mmDIG0_HDMI_INFOFRAME_CONTROL0_BASE_IDX                                                        2
#define mmDIG0_HDMI_INFOFRAME_CONTROL1                                                                 0x2099
#define mmDIG0_HDMI_INFOFRAME_CONTROL1_BASE_IDX                                                        2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL0                                                            0x209a
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL0_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL6                                                            0x209b
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL6_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL5                                                            0x209c
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL5_BASE_IDX                                                   2
#define mmDIG0_HDMI_GC                                                                                 0x209d
#define mmDIG0_HDMI_GC_BASE_IDX                                                                        2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL1                                                            0x209e
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL1_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL2                                                            0x209f
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL2_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL3                                                            0x20a0
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL3_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL4                                                            0x20a1
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL4_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL7                                                            0x20a2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL7_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL8                                                            0x20a3
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL8_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL9                                                            0x20a4
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL9_BASE_IDX                                                   2
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL10                                                           0x20a5
#define mmDIG0_HDMI_GENERIC_PACKET_CONTROL10_BASE_IDX                                                  2
#define mmDIG0_HDMI_DB_CONTROL                                                                         0x20a6
#define mmDIG0_HDMI_DB_CONTROL_BASE_IDX                                                                2
#define mmDIG0_HDMI_ACR_32_0                                                                           0x20a7
#define mmDIG0_HDMI_ACR_32_0_BASE_IDX                                                                  2
#define mmDIG0_HDMI_ACR_32_1                                                                           0x20a8
#define mmDIG0_HDMI_ACR_32_1_BASE_IDX                                                                  2
#define mmDIG0_HDMI_ACR_44_0                                                                           0x20a9
#define mmDIG0_HDMI_ACR_44_0_BASE_IDX                                                                  2
#define mmDIG0_HDMI_ACR_44_1                                                                           0x20aa
#define mmDIG0_HDMI_ACR_44_1_BASE_IDX                                                                  2
#define mmDIG0_HDMI_ACR_48_0                                                                           0x20ab
#define mmDIG0_HDMI_ACR_48_0_BASE_IDX                                                                  2
#define mmDIG0_HDMI_ACR_48_1                                                                           0x20ac
#define mmDIG0_HDMI_ACR_48_1_BASE_IDX                                                                  2
#define mmDIG0_HDMI_ACR_STATUS_0                                                                       0x20ad
#define mmDIG0_HDMI_ACR_STATUS_0_BASE_IDX                                                              2
#define mmDIG0_HDMI_ACR_STATUS_1                                                                       0x20ae
#define mmDIG0_HDMI_ACR_STATUS_1_BASE_IDX                                                              2
#define mmDIG0_AFMT_CNTL                                                                               0x20af
#define mmDIG0_AFMT_CNTL_BASE_IDX                                                                      2
#define mmDIG0_DIG_BE_CNTL                                                                             0x20b0
#define mmDIG0_DIG_BE_CNTL_BASE_IDX                                                                    2
#define mmDIG0_DIG_BE_EN_CNTL                                                                          0x20b1
#define mmDIG0_DIG_BE_EN_CNTL_BASE_IDX                                                                 2
#define mmDIG0_TMDS_CNTL                                                                               0x20d7
#define mmDIG0_TMDS_CNTL_BASE_IDX                                                                      2
#define mmDIG0_TMDS_CONTROL_CHAR                                                                       0x20d8
#define mmDIG0_TMDS_CONTROL_CHAR_BASE_IDX                                                              2
#define mmDIG0_TMDS_CONTROL0_FEEDBACK                                                                  0x20d9
#define mmDIG0_TMDS_CONTROL0_FEEDBACK_BASE_IDX                                                         2
#define mmDIG0_TMDS_STEREOSYNC_CTL_SEL                                                                 0x20da
#define mmDIG0_TMDS_STEREOSYNC_CTL_SEL_BASE_IDX                                                        2
#define mmDIG0_TMDS_SYNC_CHAR_PATTERN_0_1                                                              0x20db
#define mmDIG0_TMDS_SYNC_CHAR_PATTERN_0_1_BASE_IDX                                                     2
#define mmDIG0_TMDS_SYNC_CHAR_PATTERN_2_3                                                              0x20dc
#define mmDIG0_TMDS_SYNC_CHAR_PATTERN_2_3_BASE_IDX                                                     2
#define mmDIG0_TMDS_CTL_BITS                                                                           0x20de
#define mmDIG0_TMDS_CTL_BITS_BASE_IDX                                                                  2
#define mmDIG0_TMDS_DCBALANCER_CONTROL                                                                 0x20df
#define mmDIG0_TMDS_DCBALANCER_CONTROL_BASE_IDX                                                        2
#define mmDIG0_TMDS_SYNC_DCBALANCE_CHAR                                                                0x20e0
#define mmDIG0_TMDS_SYNC_DCBALANCE_CHAR_BASE_IDX                                                       2
#define mmDIG0_TMDS_CTL0_1_GEN_CNTL                                                                    0x20e1
#define mmDIG0_TMDS_CTL0_1_GEN_CNTL_BASE_IDX                                                           2
#define mmDIG0_TMDS_CTL2_3_GEN_CNTL                                                                    0x20e2
#define mmDIG0_TMDS_CTL2_3_GEN_CNTL_BASE_IDX                                                           2
#define mmDIG0_DIG_VERSION                                                                             0x20e4
#define mmDIG0_DIG_VERSION_BASE_IDX                                                                    2
#define mmDIG0_DIG_LANE_ENABLE                                                                         0x20e5
#define mmDIG0_DIG_LANE_ENABLE_BASE_IDX                                                                2
#define mmDIG0_FORCE_DIG_DISABLE                                                                       0x20e6
#define mmDIG0_FORCE_DIG_DISABLE_BASE_IDX                                                              2

// addressBlock: dce_dc_dio_dp0_dispdec
// base address: 0x0
#define mmDP0_DP_LINK_CNTL                                                                             0x2108
#define mmDP0_DP_LINK_CNTL_BASE_IDX                                                                    2
#define mmDP0_DP_PIXEL_FORMAT                                                                          0x2109
#define mmDP0_DP_PIXEL_FORMAT_BASE_IDX                                                                 2
#define mmDP0_DP_MSA_COLORIMETRY                                                                       0x210a
#define mmDP0_DP_MSA_COLORIMETRY_BASE_IDX                                                              2
#define mmDP0_DP_CONFIG                                                                                0x210b
#define mmDP0_DP_CONFIG_BASE_IDX                                                                       2
#define mmDP0_DP_VID_STREAM_CNTL                                                                       0x210c
#define mmDP0_DP_VID_STREAM_CNTL_BASE_IDX                                                              2
#define mmDP0_DP_STEER_FIFO                                                                            0x210d
#define mmDP0_DP_STEER_FIFO_BASE_IDX                                                                   2
#define mmDP0_DP_MSA_MISC                                                                              0x210e
#define mmDP0_DP_MSA_MISC_BASE_IDX                                                                     2
#define mmDP0_DP_DPHY_INTERNAL_CTRL                                                                    0x210f
#define mmDP0_DP_DPHY_INTERNAL_CTRL_BASE_IDX                                                           2
#define mmDP0_DP_VID_TIMING                                                                            0x2110
#define mmDP0_DP_VID_TIMING_BASE_IDX                                                                   2
#define mmDP0_DP_VID_N                                                                                 0x2111
#define mmDP0_DP_VID_N_BASE_IDX                                                                        2
#define mmDP0_DP_VID_M                                                                                 0x2112
#define mmDP0_DP_VID_M_BASE_IDX                                                                        2
#define mmDP0_DP_LINK_FRAMING_CNTL                                                                     0x2113
#define mmDP0_DP_LINK_FRAMING_CNTL_BASE_IDX                                                            2
#define mmDP0_DP_HBR2_EYE_PATTERN                                                                      0x2114
#define mmDP0_DP_HBR2_EYE_PATTERN_BASE_IDX                                                             2
#define mmDP0_DP_VID_MSA_VBID                                                                          0x2115
#define mmDP0_DP_VID_MSA_VBID_BASE_IDX                                                                 2
#define mmDP0_DP_VID_INTERRUPT_CNTL                                                                    0x2116
#define mmDP0_DP_VID_INTERRUPT_CNTL_BASE_IDX                                                           2
#define mmDP0_DP_DPHY_CNTL                                                                             0x2117
#define mmDP0_DP_DPHY_CNTL_BASE_IDX                                                                    2
#define mmDP0_DP_DPHY_TRAINING_PATTERN_SEL                                                             0x2118
#define mmDP0_DP_DPHY_TRAINING_PATTERN_SEL_BASE_IDX                                                    2
#define mmDP0_DP_DPHY_SYM0                                                                             0x2119
#define mmDP0_DP_DPHY_SYM0_BASE_IDX                                                                    2
#define mmDP0_DP_DPHY_SYM1                                                                             0x211a
#define mmDP0_DP_DPHY_SYM1_BASE_IDX                                                                    2
#define mmDP0_DP_DPHY_SYM2                                                                             0x211b
#define mmDP0_DP_DPHY_SYM2_BASE_IDX                                                                    2
#define mmDP0_DP_DPHY_8B10B_CNTL                                                                       0x211c
#define mmDP0_DP_DPHY_8B10B_CNTL_BASE_IDX                                                              2
#define mmDP0_DP_DPHY_PRBS_CNTL                                                                        0x211d
#define mmDP0_DP_DPHY_PRBS_CNTL_BASE_IDX                                                               2
#define mmDP0_DP_DPHY_SCRAM_CNTL                                                                       0x211e
#define mmDP0_DP_DPHY_SCRAM_CNTL_BASE_IDX                                                              2
#define mmDP0_DP_DPHY_CRC_EN                                                                           0x211f
#define mmDP0_DP_DPHY_CRC_EN_BASE_IDX                                                                  2
#define mmDP0_DP_DPHY_CRC_CNTL                                                                         0x2120
#define mmDP0_DP_DPHY_CRC_CNTL_BASE_IDX                                                                2
#define mmDP0_DP_DPHY_CRC_RESULT                                                                       0x2121
#define mmDP0_DP_DPHY_CRC_RESULT_BASE_IDX                                                              2
#define mmDP0_DP_DPHY_CRC_MST_CNTL                                                                     0x2122
#define mmDP0_DP_DPHY_CRC_MST_CNTL_BASE_IDX                                                            2
#define mmDP0_DP_DPHY_CRC_MST_STATUS                                                                   0x2123
#define mmDP0_DP_DPHY_CRC_MST_STATUS_BASE_IDX                                                          2
#define mmDP0_DP_DPHY_FAST_TRAINING                                                                    0x2124
#define mmDP0_DP_DPHY_FAST_TRAINING_BASE_IDX                                                           2
#define mmDP0_DP_DPHY_FAST_TRAINING_STATUS                                                             0x2125
#define mmDP0_DP_DPHY_FAST_TRAINING_STATUS_BASE_IDX                                                    2
#define mmDP0_DP_SEC_CNTL                                                                              0x212b
#define mmDP0_DP_SEC_CNTL_BASE_IDX                                                                     2
#define mmDP0_DP_SEC_CNTL1                                                                             0x212c
#define mmDP0_DP_SEC_CNTL1_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_FRAMING1                                                                          0x212d
#define mmDP0_DP_SEC_FRAMING1_BASE_IDX                                                                 2
#define mmDP0_DP_SEC_FRAMING2                                                                          0x212e
#define mmDP0_DP_SEC_FRAMING2_BASE_IDX                                                                 2
#define mmDP0_DP_SEC_FRAMING3                                                                          0x212f
#define mmDP0_DP_SEC_FRAMING3_BASE_IDX                                                                 2
#define mmDP0_DP_SEC_FRAMING4                                                                          0x2130
#define mmDP0_DP_SEC_FRAMING4_BASE_IDX                                                                 2
#define mmDP0_DP_SEC_AUD_N                                                                             0x2131
#define mmDP0_DP_SEC_AUD_N_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_AUD_N_READBACK                                                                    0x2132
#define mmDP0_DP_SEC_AUD_N_READBACK_BASE_IDX                                                           2
#define mmDP0_DP_SEC_AUD_M                                                                             0x2133
#define mmDP0_DP_SEC_AUD_M_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_AUD_M_READBACK                                                                    0x2134
#define mmDP0_DP_SEC_AUD_M_READBACK_BASE_IDX                                                           2
#define mmDP0_DP_SEC_TIMESTAMP                                                                         0x2135
#define mmDP0_DP_SEC_TIMESTAMP_BASE_IDX                                                                2
#define mmDP0_DP_SEC_PACKET_CNTL                                                                       0x2136
#define mmDP0_DP_SEC_PACKET_CNTL_BASE_IDX                                                              2
#define mmDP0_DP_MSE_RATE_CNTL                                                                         0x2137
#define mmDP0_DP_MSE_RATE_CNTL_BASE_IDX                                                                2
#define mmDP0_DP_MSE_RATE_UPDATE                                                                       0x2139
#define mmDP0_DP_MSE_RATE_UPDATE_BASE_IDX                                                              2
#define mmDP0_DP_MSE_SAT0                                                                              0x213a
#define mmDP0_DP_MSE_SAT0_BASE_IDX                                                                     2
#define mmDP0_DP_MSE_SAT1                                                                              0x213b
#define mmDP0_DP_MSE_SAT1_BASE_IDX                                                                     2
#define mmDP0_DP_MSE_SAT2                                                                              0x213c
#define mmDP0_DP_MSE_SAT2_BASE_IDX                                                                     2
#define mmDP0_DP_MSE_SAT_UPDATE                                                                        0x213d
#define mmDP0_DP_MSE_SAT_UPDATE_BASE_IDX                                                               2
#define mmDP0_DP_MSE_LINK_TIMING                                                                       0x213e
#define mmDP0_DP_MSE_LINK_TIMING_BASE_IDX                                                              2
#define mmDP0_DP_MSE_MISC_CNTL                                                                         0x213f
#define mmDP0_DP_MSE_MISC_CNTL_BASE_IDX                                                                2
#define mmDP0_DP_DPHY_BS_SR_SWAP_CNTL                                                                  0x2144
#define mmDP0_DP_DPHY_BS_SR_SWAP_CNTL_BASE_IDX                                                         2
#define mmDP0_DP_DPHY_HBR2_PATTERN_CONTROL                                                             0x2145
#define mmDP0_DP_DPHY_HBR2_PATTERN_CONTROL_BASE_IDX                                                    2
#define mmDP0_DP_MSE_SAT0_STATUS                                                                       0x2147
#define mmDP0_DP_MSE_SAT0_STATUS_BASE_IDX                                                              2
#define mmDP0_DP_MSE_SAT1_STATUS                                                                       0x2148
#define mmDP0_DP_MSE_SAT1_STATUS_BASE_IDX                                                              2
#define mmDP0_DP_MSE_SAT2_STATUS                                                                       0x2149
#define mmDP0_DP_MSE_SAT2_STATUS_BASE_IDX                                                              2
#define mmDP0_DP_MSA_TIMING_PARAM1                                                                     0x214c
#define mmDP0_DP_MSA_TIMING_PARAM1_BASE_IDX                                                            2
#define mmDP0_DP_MSA_TIMING_PARAM2                                                                     0x214d
#define mmDP0_DP_MSA_TIMING_PARAM2_BASE_IDX                                                            2
#define mmDP0_DP_MSA_TIMING_PARAM3                                                                     0x214e
#define mmDP0_DP_MSA_TIMING_PARAM3_BASE_IDX                                                            2
#define mmDP0_DP_MSA_TIMING_PARAM4                                                                     0x214f
#define mmDP0_DP_MSA_TIMING_PARAM4_BASE_IDX                                                            2
#define mmDP0_DP_MSO_CNTL                                                                              0x2150
#define mmDP0_DP_MSO_CNTL_BASE_IDX                                                                     2
#define mmDP0_DP_MSO_CNTL1                                                                             0x2151
#define mmDP0_DP_MSO_CNTL1_BASE_IDX                                                                    2
#define mmDP0_DP_DSC_CNTL                                                                              0x2152
#define mmDP0_DP_DSC_CNTL_BASE_IDX                                                                     2
#define mmDP0_DP_SEC_CNTL2                                                                             0x2153
#define mmDP0_DP_SEC_CNTL2_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_CNTL3                                                                             0x2154
#define mmDP0_DP_SEC_CNTL3_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_CNTL4                                                                             0x2155
#define mmDP0_DP_SEC_CNTL4_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_CNTL5                                                                             0x2156
#define mmDP0_DP_SEC_CNTL5_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_CNTL6                                                                             0x2157
#define mmDP0_DP_SEC_CNTL6_BASE_IDX                                                                    2
#define mmDP0_DP_SEC_CNTL7                                                                             0x2158
#define mmDP0_DP_SEC_CNTL7_BASE_IDX                                                                    2
#define mmDP0_DP_DB_CNTL                                                                               0x2159
#define mmDP0_DP_DB_CNTL_BASE_IDX                                                                      2
#define mmDP0_DP_MSA_VBID_MISC                                                                         0x215a
#define mmDP0_DP_MSA_VBID_MISC_BASE_IDX                                                                2
#define mmDP0_DP_SEC_METADATA_TRANSMISSION                                                             0x215b
#define mmDP0_DP_SEC_METADATA_TRANSMISSION_BASE_IDX                                                    2
#define mmDP0_DP_DSC_BYTES_PER_PIXEL                                                                   0x215c
#define mmDP0_DP_DSC_BYTES_PER_PIXEL_BASE_IDX                                                          2
#define mmDP0_DP_ALPM_CNTL                                                                             0x215d
#define mmDP0_DP_ALPM_CNTL_BASE_IDX                                                                    2
#define mmDP0_DP_GSP8_CNTL                                                                             0x215e
#define mmDP0_DP_GSP8_CNTL_BASE_IDX                                                                    2
#define mmDP0_DP_GSP9_CNTL                                                                             0x215f
#define mmDP0_DP_GSP9_CNTL_BASE_IDX                                                                    2
#define mmDP0_DP_GSP10_CNTL                                                                            0x2160
#define mmDP0_DP_GSP10_CNTL_BASE_IDX                                                                   2
#define mmDP0_DP_GSP11_CNTL                                                                            0x2161
#define mmDP0_DP_GSP11_CNTL_BASE_IDX                                                                   2
#define mmDP0_DP_GSP_EN_DB_STATUS                                                                      0x2162
#define mmDP0_DP_GSP_EN_DB_STATUS_BASE_IDX                                                             2


// addressBlock: dce_dc_dio_dig1_vpg_vpg_dispdec
// base address: 0x158a0
#define mmVPG1_VPG_GENERIC_PACKET_ACCESS_CTRL                                                          0x2168
#define mmVPG1_VPG_GENERIC_PACKET_ACCESS_CTRL_BASE_IDX                                                 2
#define mmVPG1_VPG_GENERIC_PACKET_DATA                                                                 0x2169
#define mmVPG1_VPG_GENERIC_PACKET_DATA_BASE_IDX                                                        2
#define mmVPG1_VPG_GSP_FRAME_UPDATE_CTRL                                                               0x216a
#define mmVPG1_VPG_GSP_FRAME_UPDATE_CTRL_BASE_IDX                                                      2
#define mmVPG1_VPG_GSP_IMMEDIATE_UPDATE_CTRL                                                           0x216b
#define mmVPG1_VPG_GSP_IMMEDIATE_UPDATE_CTRL_BASE_IDX                                                  2
#define mmVPG1_VPG_GENERIC_STATUS                                                                      0x216c
#define mmVPG1_VPG_GENERIC_STATUS_BASE_IDX                                                             2
#define mmVPG1_VPG_MEM_PWR                                                                             0x216d
#define mmVPG1_VPG_MEM_PWR_BASE_IDX                                                                    2
#define mmVPG1_VPG_ISRC1_2_ACCESS_CTRL                                                                 0x216e
#define mmVPG1_VPG_ISRC1_2_ACCESS_CTRL_BASE_IDX                                                        2
#define mmVPG1_VPG_ISRC1_2_DATA                                                                        0x216f
#define mmVPG1_VPG_ISRC1_2_DATA_BASE_IDX                                                               2
#define mmVPG1_VPG_MPEG_INFO0                                                                          0x2170
#define mmVPG1_VPG_MPEG_INFO0_BASE_IDX                                                                 2
#define mmVPG1_VPG_MPEG_INFO1                                                                          0x2171
#define mmVPG1_VPG_MPEG_INFO1_BASE_IDX                                                                 2


// addressBlock: dce_dc_dio_dig1_afmt_afmt_dispdec
// base address: 0x158cc
#define mmAFMT1_AFMT_VBI_PACKET_CONTROL                                                                0x2174
#define mmAFMT1_AFMT_VBI_PACKET_CONTROL_BASE_IDX                                                       2
#define mmAFMT1_AFMT_AUDIO_PACKET_CONTROL2                                                             0x2175
#define mmAFMT1_AFMT_AUDIO_PACKET_CONTROL2_BASE_IDX                                                    2
#define mmAFMT1_AFMT_AUDIO_INFO0                                                                       0x2176
#define mmAFMT1_AFMT_AUDIO_INFO0_BASE_IDX                                                              2
#define mmAFMT1_AFMT_AUDIO_INFO1                                                                       0x2177
#define mmAFMT1_AFMT_AUDIO_INFO1_BASE_IDX                                                              2
#define mmAFMT1_AFMT_60958_0                                                                           0x2178
#define mmAFMT1_AFMT_60958_0_BASE_IDX                                                                  2
#define mmAFMT1_AFMT_60958_1                                                                           0x2179
#define mmAFMT1_AFMT_60958_1_BASE_IDX                                                                  2
#define mmAFMT1_AFMT_AUDIO_CRC_CONTROL                                                                 0x217a
#define mmAFMT1_AFMT_AUDIO_CRC_CONTROL_BASE_IDX                                                        2
#define mmAFMT1_AFMT_RAMP_CONTROL0                                                                     0x217b
#define mmAFMT1_AFMT_RAMP_CONTROL0_BASE_IDX                                                            2
#define mmAFMT1_AFMT_RAMP_CONTROL1                                                                     0x217c
#define mmAFMT1_AFMT_RAMP_CONTROL1_BASE_IDX                                                            2
#define mmAFMT1_AFMT_RAMP_CONTROL2                                                                     0x217d
#define mmAFMT1_AFMT_RAMP_CONTROL2_BASE_IDX                                                            2
#define mmAFMT1_AFMT_RAMP_CONTROL3                                                                     0x217e
#define mmAFMT1_AFMT_RAMP_CONTROL3_BASE_IDX                                                            2
#define mmAFMT1_AFMT_60958_2                                                                           0x217f
#define mmAFMT1_AFMT_60958_2_BASE_IDX                                                                  2
#define mmAFMT1_AFMT_AUDIO_CRC_RESULT                                                                  0x2180
#define mmAFMT1_AFMT_AUDIO_CRC_RESULT_BASE_IDX                                                         2
#define mmAFMT1_AFMT_STATUS                                                                            0x2181
#define mmAFMT1_AFMT_STATUS_BASE_IDX                                                                   2
#define mmAFMT1_AFMT_AUDIO_PACKET_CONTROL                                                              0x2182
#define mmAFMT1_AFMT_AUDIO_PACKET_CONTROL_BASE_IDX                                                     2
#define mmAFMT1_AFMT_INFOFRAME_CONTROL0                                                                0x2183
#define mmAFMT1_AFMT_INFOFRAME_CONTROL0_BASE_IDX                                                       2
#define mmAFMT1_AFMT_INTERRUPT_STATUS                                                                  0x2184
#define mmAFMT1_AFMT_INTERRUPT_STATUS_BASE_IDX                                                         2
#define mmAFMT1_AFMT_AUDIO_SRC_CONTROL                                                                 0x2185
#define mmAFMT1_AFMT_AUDIO_SRC_CONTROL_BASE_IDX                                                        2
#define mmAFMT1_AFMT_MEM_PWR                                                                           0x2187
#define mmAFMT1_AFMT_MEM_PWR_BASE_IDX                                                                  2


// addressBlock: dce_dc_dio_dig1_dme_dme_dispdec
// base address: 0x15924
#define mmDME1_DME_CONTROL                                                                             0x2189
#define mmDME1_DME_CONTROL_BASE_IDX                                                                    2
#define mmDME1_DME_MEMORY_CONTROL                                                                      0x218a
#define mmDME1_DME_MEMORY_CONTROL_BASE_IDX                                                             2


// addressBlock: dce_dc_dio_dig1_dispdec
// base address: 0x400
#define mmDIG1_DIG_FE_CNTL                                                                             0x218b
#define mmDIG1_DIG_FE_CNTL_BASE_IDX                                                                    2
#define mmDIG1_DIG_OUTPUT_CRC_CNTL                                                                     0x218c
#define mmDIG1_DIG_OUTPUT_CRC_CNTL_BASE_IDX                                                            2
#define mmDIG1_DIG_OUTPUT_CRC_RESULT                                                                   0x218d
#define mmDIG1_DIG_OUTPUT_CRC_RESULT_BASE_IDX                                                          2
#define mmDIG1_DIG_CLOCK_PATTERN                                                                       0x218e
#define mmDIG1_DIG_CLOCK_PATTERN_BASE_IDX                                                              2
#define mmDIG1_DIG_TEST_PATTERN                                                                        0x218f
#define mmDIG1_DIG_TEST_PATTERN_BASE_IDX                                                               2
#define mmDIG1_DIG_RANDOM_PATTERN_SEED                                                                 0x2190
#define mmDIG1_DIG_RANDOM_PATTERN_SEED_BASE_IDX                                                        2
#define mmDIG1_DIG_FIFO_STATUS                                                                         0x2191
#define mmDIG1_DIG_FIFO_STATUS_BASE_IDX                                                                2
#define mmDIG1_HDMI_METADATA_PACKET_CONTROL                                                            0x2192
#define mmDIG1_HDMI_METADATA_PACKET_CONTROL_BASE_IDX                                                   2
#define mmDIG1_HDMI_CONTROL                                                                            0x2193
#define mmDIG1_HDMI_CONTROL_BASE_IDX                                                                   2
#define mmDIG1_HDMI_STATUS                                                                             0x2194
#define mmDIG1_HDMI_STATUS_BASE_IDX                                                                    2
#define mmDIG1_HDMI_AUDIO_PACKET_CONTROL                                                               0x2195
#define mmDIG1_HDMI_AUDIO_PACKET_CONTROL_BASE_IDX                                                      2
#define mmDIG1_HDMI_ACR_PACKET_CONTROL                                                                 0x2196
#define mmDIG1_HDMI_ACR_PACKET_CONTROL_BASE_IDX                                                        2
#define mmDIG1_HDMI_VBI_PACKET_CONTROL                                                                 0x2197
#define mmDIG1_HDMI_VBI_PACKET_CONTROL_BASE_IDX                                                        2
#define mmDIG1_HDMI_INFOFRAME_CONTROL0                                                                 0x2198
#define mmDIG1_HDMI_INFOFRAME_CONTROL0_BASE_IDX                                                        2
#define mmDIG1_HDMI_INFOFRAME_CONTROL1                                                                 0x2199
#define mmDIG1_HDMI_INFOFRAME_CONTROL1_BASE_IDX                                                        2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL0                                                            0x219a
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL0_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL6                                                            0x219b
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL6_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL5                                                            0x219c
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL5_BASE_IDX                                                   2
#define mmDIG1_HDMI_GC                                                                                 0x219d
#define mmDIG1_HDMI_GC_BASE_IDX                                                                        2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL1                                                            0x219e
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL1_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL2                                                            0x219f
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL2_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL3                                                            0x21a0
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL3_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL4                                                            0x21a1
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL4_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL7                                                            0x21a2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL7_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL8                                                            0x21a3
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL8_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL9                                                            0x21a4
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL9_BASE_IDX                                                   2
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL10                                                           0x21a5
#define mmDIG1_HDMI_GENERIC_PACKET_CONTROL10_BASE_IDX                                                  2
#define mmDIG1_HDMI_DB_CONTROL                                                                         0x21a6
#define mmDIG1_HDMI_DB_CONTROL_BASE_IDX                                                                2
#define mmDIG1_HDMI_ACR_32_0                                                                           0x21a7
#define mmDIG1_HDMI_ACR_32_0_BASE_IDX                                                                  2
#define mmDIG1_HDMI_ACR_32_1                                                                           0x21a8
#define mmDIG1_HDMI_ACR_32_1_BASE_IDX                                                                  2
#define mmDIG1_HDMI_ACR_44_0                                                                           0x21a9
#define mmDIG1_HDMI_ACR_44_0_BASE_IDX                                                                  2
#define mmDIG1_HDMI_ACR_44_1                                                                           0x21aa
#define mmDIG1_HDMI_ACR_44_1_BASE_IDX                                                                  2
#define mmDIG1_HDMI_ACR_48_0                                                                           0x21ab
#define mmDIG1_HDMI_ACR_48_0_BASE_IDX                                                                  2
#define mmDIG1_HDMI_ACR_48_1                                                                           0x21ac
#define mmDIG1_HDMI_ACR_48_1_BASE_IDX                                                                  2
#define mmDIG1_HDMI_ACR_STATUS_0                                                                       0x21ad
#define mmDIG1_HDMI_ACR_STATUS_0_BASE_IDX                                                              2
#define mmDIG1_HDMI_ACR_STATUS_1                                                                       0x21ae
#define mmDIG1_HDMI_ACR_STATUS_1_BASE_IDX                                                              2
#define mmDIG1_AFMT_CNTL                                                                               0x21af
#define mmDIG1_AFMT_CNTL_BASE_IDX                                                                      2
#define mmDIG1_DIG_BE_CNTL                                                                             0x21b0
#define mmDIG1_DIG_BE_CNTL_BASE_IDX                                                                    2
#define mmDIG1_DIG_BE_EN_CNTL                                                                          0x21b1
#define mmDIG1_DIG_BE_EN_CNTL_BASE_IDX                                                                 2
#define mmDIG1_TMDS_CNTL                                                                               0x21d7
#define mmDIG1_TMDS_CNTL_BASE_IDX                                                                      2
#define mmDIG1_TMDS_CONTROL_CHAR                                                                       0x21d8
#define mmDIG1_TMDS_CONTROL_CHAR_BASE_IDX                                                              2
#define mmDIG1_TMDS_CONTROL0_FEEDBACK                                                                  0x21d9
#define mmDIG1_TMDS_CONTROL0_FEEDBACK_BASE_IDX                                                         2
#define mmDIG1_TMDS_STEREOSYNC_CTL_SEL                                                                 0x21da
#define mmDIG1_TMDS_STEREOSYNC_CTL_SEL_BASE_IDX                                                        2
#define mmDIG1_TMDS_SYNC_CHAR_PATTERN_0_1                                                              0x21db
#define mmDIG1_TMDS_SYNC_CHAR_PATTERN_0_1_BASE_IDX                                                     2
#define mmDIG1_TMDS_SYNC_CHAR_PATTERN_2_3                                                              0x21dc
#define mmDIG1_TMDS_SYNC_CHAR_PATTERN_2_3_BASE_IDX                                                     2
#define mmDIG1_TMDS_CTL_BITS                                                                           0x21de
#define mmDIG1_TMDS_CTL_BITS_BASE_IDX                                                                  2
#define mmDIG1_TMDS_DCBALANCER_CONTROL                                                                 0x21df
#define mmDIG1_TMDS_DCBALANCER_CONTROL_BASE_IDX                                                        2
#define mmDIG1_TMDS_SYNC_DCBALANCE_CHAR                                                                0x21e0
#define mmDIG1_TMDS_SYNC_DCBALANCE_CHAR_BASE_IDX                                                       2
#define mmDIG1_TMDS_CTL0_1_GEN_CNTL                                                                    0x21e1
#define mmDIG1_TMDS_CTL0_1_GEN_CNTL_BASE_IDX                                                           2
#define mmDIG1_TMDS_CTL2_3_GEN_CNTL                                                                    0x21e2
#define mmDIG1_TMDS_CTL2_3_GEN_CNTL_BASE_IDX                                                           2
#define mmDIG1_DIG_VERSION                                                                             0x21e4
#define mmDIG1_DIG_VERSION_BASE_IDX                                                                    2
#define mmDIG1_DIG_LANE_ENABLE                                                                         0x21e5
#define mmDIG1_DIG_LANE_ENABLE_BASE_IDX                                                                2
#define mmDIG1_FORCE_DIG_DISABLE                                                                       0x21e6
#define mmDIG1_FORCE_DIG_DISABLE_BASE_IDX                                                              2

// addressBlock: dce_dc_dio_dp1_dispdec
// base address: 0x400
#define mmDP1_DP_LINK_CNTL                                                                             0x2208
#define mmDP1_DP_LINK_CNTL_BASE_IDX                                                                    2
#define mmDP1_DP_PIXEL_FORMAT                                                                          0x2209
#define mmDP1_DP_PIXEL_FORMAT_BASE_IDX                                                                 2
#define mmDP1_DP_MSA_COLORIMETRY                                                                       0x220a
#define mmDP1_DP_MSA_COLORIMETRY_BASE_IDX                                                              2
#define mmDP1_DP_CONFIG                                                                                0x220b
#define mmDP1_DP_CONFIG_BASE_IDX                                                                       2
#define mmDP1_DP_VID_STREAM_CNTL                                                                       0x220c
#define mmDP1_DP_VID_STREAM_CNTL_BASE_IDX                                                              2
#define mmDP1_DP_STEER_FIFO                                                                            0x220d
#define mmDP1_DP_STEER_FIFO_BASE_IDX                                                                   2
#define mmDP1_DP_MSA_MISC                                                                              0x220e
#define mmDP1_DP_MSA_MISC_BASE_IDX                                                                     2
#define mmDP1_DP_DPHY_INTERNAL_CTRL                                                                    0x220f
#define mmDP1_DP_DPHY_INTERNAL_CTRL_BASE_IDX                                                           2
#define mmDP1_DP_VID_TIMING                                                                            0x2210
#define mmDP1_DP_VID_TIMING_BASE_IDX                                                                   2
#define mmDP1_DP_VID_N                                                                                 0x2211
#define mmDP1_DP_VID_N_BASE_IDX                                                                        2
#define mmDP1_DP_VID_M                                                                                 0x2212
#define mmDP1_DP_VID_M_BASE_IDX                                                                        2
#define mmDP1_DP_LINK_FRAMING_CNTL                                                                     0x2213
#define mmDP1_DP_LINK_FRAMING_CNTL_BASE_IDX                                                            2
#define mmDP1_DP_HBR2_EYE_PATTERN                                                                      0x2214
#define mmDP1_D