/*
 * SH7723 Pinmux
 *
 *  Copyright (C) 2008  Magnus Damm
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <cpu/sh7723.h>

#include "sh_pfc.h"

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	PTA7_DATA, PTA6_DATA, PTA5_DATA, PTA4_DATA,
	PTA3_DATA, PTA2_DATA, PTA1_DATA, PTA0_DATA,
	PTB7_DATA, PTB6_DATA, PTB5_DATA, PTB4_DATA,
	PTB3_DATA, PTB2_DATA, PTB1_DATA, PTB0_DATA,
	PTC7_DATA, PTC6_DATA, PTC5_DATA, PTC4_DATA,
	PTC3_DATA, PTC2_DATA, PTC1_DATA, PTC0_DATA,
	PTD7_DATA, PTD6_DATA, PTD5_DATA, PTD4_DATA,
	PTD3_DATA, PTD2_DATA, PTD1_DATA, PTD0_DATA,
	PTE5_DATA, PTE4_DATA, PTE3_DATA, PTE2_DATA, PTE1_DATA, PTE0_DATA,
	PTF7_DATA, PTF6_DATA, PTF5_DATA, PTF4_DATA,
	PTF3_DATA, PTF2_DATA, PTF1_DATA, PTF0_DATA,
	PTG5_DATA, PTG4_DATA, PTG3_DATA, PTG2_DATA, PTG1_DATA, PTG0_DATA,
	PTH7_DATA, PTH6_DATA, PTH5_DATA, PTH4_DATA,
	PTH3_DATA, PTH2_DATA, PTH1_DATA, PTH0_DATA,
	PTJ7_DATA, PTJ5_DATA, PTJ3_DATA, PTJ2_DATA, PTJ1_DATA, PTJ0_DATA,
	PTK7_DATA, PTK6_DATA, PTK5_DATA, PTK4_DATA,
	PTK3_DATA, PTK2_DATA, PTK1_DATA, PTK0_DATA,
	PTL7_DATA, PTL6_DATA, PTL5_DATA, PTL4_DATA,
	PTL3_DATA, PTL2_DATA, PTL1_DATA, PTL0_DATA,
	PTM7_DATA, PTM6_DATA, PTM5_DATA, PTM4_DATA,
	PTM3_DATA, PTM2_DATA, PTM1_DATA, PTM0_DATA,
	PTN7_DATA, PTN6_DATA, PTN5_DATA, PTN4_DATA,
	PTN3_DATA, PTN2_DATA, PTN1_DATA, PTN0_DATA,
	PTQ3_DATA, PTQ2_DATA, PTQ1_DATA, PTQ0_DATA,
	PTR7_DATA, PTR6_DATA, PTR5_DATA, PTR4_DATA,
	PTR3_DATA, PTR2_DATA, PTR1_DATA, PTR0_DATA,
	PTS7_DATA, PTS6_DATA, PTS5_DATA, PTS4_DATA,
	PTS3_DATA, PTS2_DATA, PTS1_DATA, PTS0_DATA,
	PTT5_DATA, PTT4_DATA, PTT3_DATA, PTT2_DATA, PTT1_DATA, PTT0_DATA,
	PTU5_DATA, PTU4_DATA, PTU3_DATA, PTU2_DATA, PTU1_DATA, PTU0_DATA,
	PTV7_DATA, PTV6_DATA, PTV5_DATA, PTV4_DATA,
	PTV3_DATA, PTV2_DATA, PTV1_DATA, PTV0_DATA,
	PTW7_DATA, PTW6_DATA, PTW5_DATA, PTW4_DATA,
	PTW3_DATA, PTW2_DATA, PTW1_DATA, PTW0_DATA,
	PTX7_DATA, PTX6_DATA, PTX5_DATA, PTX4_DATA,
	PTX3_DATA, PTX2_DATA, PTX1_DATA, PTX0_DATA,
	PTY7_DATA, PTY6_DATA, PTY5_DATA, PTY4_DATA,
	PTY3_DATA, PTY2_DATA, PTY1_DATA, PTY0_DATA,
	PTZ7_DATA, PTZ6_DATA, PTZ5_DATA, PTZ4_DATA,
	PTZ3_DATA, PTZ2_DATA, PTZ1_DATA, PTZ0_DATA,
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	PTA7_IN, PTA6_IN, PTA5_IN, PTA4_IN,
	PTA3_IN, PTA2_IN, PTA1_IN, PTA0_IN,
	PTB7_IN, PTB6_IN, PTB5_IN, PTB4_IN,
	PTB3_IN, PTB2_IN, PTB1_IN, PTB0_IN,
	PTC7_IN, PTC6_IN, PTC5_IN, PTC4_IN,
	PTC3_IN, PTC2_IN, PTC1_IN, PTC0_IN,
	PTD7_IN, PTD6_IN, PTD5_IN, PTD4_IN,
	PTD3_IN, PTD2_IN, PTD1_IN, PTD0_IN,
	PTE5_IN, PTE4_IN, PTE3_IN, PTE2_IN, PTE1_IN, PTE0_IN,
	PTF7_IN, PTF6_IN, PTF5_IN, PTF4_IN,
	PTF3_IN, PTF2_IN, PTF1_IN, PTF0_IN,
	PTH7_IN, PTH6_IN, PTH5_IN, PTH4_IN,
	PTH3_IN, PTH2_IN, PTH1_IN, PTH0_IN,
	PTJ3_IN, PTJ2_IN, PTJ1_IN, PTJ0_IN,
	PTK7_IN, PTK6_IN, PTK5_IN, PTK4_IN,
	PTK3_IN, PTK2_IN, PTK1_IN, PTK0_IN,
	PTL7_IN, PTL6_IN, PTL5_IN, PTL4_IN,
	PTL3_IN, PTL2_IN, PTL1_IN, PTL0_IN,
	PTM7_IN, PTM6_IN, PTM5_IN, PTM4_IN,
	PTM3_IN, PTM2_IN, PTM1_IN, PTM0_IN,
	PTN7_IN, PTN6_IN, PTN5_IN, PTN4_IN,
	PTN3_IN, PTN2_IN, PTN1_IN, PTN0_IN,
	PTQ3_IN, PTQ2_IN, PTQ1_IN, PTQ0_IN,
	PTR7_IN, PTR6_IN, PTR5_IN, PTR4_IN,
	PTR3_IN, PTR2_IN, PTR1_IN, PTR0_IN,
	PTS7_IN, PTS6_IN, PTS5_IN, PTS4_IN,
	PTS3_IN, PTS2_IN, PTS1_IN, PTS0_IN,
	PTT5_IN, PTT4_IN, PTT3_IN, PTT2_IN, PTT1_IN, PTT0_IN,
	PTU5_IN, PTU4_IN, PTU3_IN, PTU2_IN, PTU1_IN, PTU0_IN,
	PTV7_IN, PTV6_IN, PTV5_IN, PTV4_IN,
	PTV3_IN, PTV2_IN, PTV1_IN, PTV0_IN,
	PTW7_IN, PTW6_IN, PTW5_IN, PTW4_IN,
	PTW3_IN, PTW2_IN, PTW1_IN, PTW0_IN,
	PTX7_IN, PTX6_IN, PTX5_IN, PTX4_IN,
	PTX3_IN, PTX2_IN, PTX1_IN, PTX0_IN,
	PTY7_IN, PTY6_IN, PTY5_IN, PTY4_IN,
	PTY3_IN, PTY2_IN, PTY1_IN, PTY0_IN,
	PTZ7_IN, PTZ6_IN, PTZ5_IN, PTZ4_IN,
	PTZ3_IN, PTZ2_IN, PTZ1_IN, PTZ0_IN,
	PINMUX_INPUT_END,

	PINMUX_INPUT_PULLUP_BEGIN,
	PTA4_IN_PU, PTA3_IN_PU, PTA2_IN_PU, PTA1_IN_PU, PTA0_IN_PU,
	PTB2_IN_PU, PTB1_IN_PU,
	PTR2_IN_PU,
	PINMUX_INPUT_PULLUP_END,

	PINMUX_OUTPUT_BEGIN,
	PTA7_OUT, PTA6_OUT, PTA5_OUT, PTA4_OUT,
	PTA3_OUT, PTA2_OUT, PTA1_OUT, PTA0_OUT,
	PTB7_OUT, PTB6_OUT, PTB5_OUT, PTB4_OUT,
	PTB3_OUT, PTB2_OUT, PTB1_OUT, PTB0_OUT,
	PTC7_OUT, PTC6_OUT, PTC5_OUT, PTC4_OUT,
	PTC3_OUT, PTC2_OUT, PTC1_OUT, PTC0_OUT,
	PTD7_OUT, PTD6_OUT, PTD5_OUT, PTD4_OUT,
	PTD3_OUT, PTD2_OUT, PTD1_OUT, PTD0_OUT,
	PTE5_OUT, PTE4_OUT, PTE3_OUT, PTE2_OUT, PTE1_OUT, PTE0_OUT,
	PTF7_OUT, PTF6_OUT, PTF5_OUT, PTF4_OUT,
	PTF3_OUT, PTF2_OUT, PTF1_OUT, PTF0_OUT,
	PTG5_OUT, PTG4_OUT, PTG3_OUT, PTG2_OUT, PTG1_OUT, PTG0_OUT,
	PTH7_OUT, PTH6_OUT, PTH5_OUT, PTH4_OUT,
	PTH3_OUT, PTH2_OUT, PTH1_OUT, PTH0_OUT,
	PTJ7_OUT, PTJ5_OUT, PTJ3_OUT, PTJ2_OUT, PTJ1_OUT, PTJ0_OUT,
	PTK7_OUT, PTK6_OUT, PTK5_OUT, PTK4_OUT,
	PTK3_OUT, PTK2_OUT, PTK1_OUT, PTK0_OUT,
	PTL7_OUT, PTL6_OUT, PTL5_OUT, PTL4_OUT,
	PTL3_OUT, PTL2_OUT, PTL1_OUT, PTL0_OUT,
	PTM7_OUT, PTM6_OUT, PTM5_OUT, PTM4_OUT,
	PTM3_OUT, PTM2_OUT, PTM1_OUT, PTM0_OUT,
	PTN7_OUT, PTN6_OUT, PTN5_OUT, PTN4_OUT,
	PTN3_OUT, PTN2_OUT, PTN1_OUT, PTN0_OUT,
	PTR7_OUT, PTR6_OUT, PTR5_OUT, PTR4_OUT,
	PTR1_OUT, PTR0_OUT,
	PTS7_OUT, PTS6_OUT, PTS5_OUT, PTS4_OUT,
	PTS3_OUT, PTS2_OUT, PTS1_OUT, PTS0_OUT,
	PTT5_OUT, PTT4_OUT, PTT3_OUT, PTT2_OUT, PTT1_OUT, PTT0_OUT,
	PTU5_OUT, PTU4_OUT, PTU3_OUT, PTU2_OUT, PTU1_OUT, PTU0_OUT,
	PTV7_OUT, PTV6_OUT, PTV5_OUT, PTV4_OUT,
	PTV3_OUT, PTV2_OUT, PTV1_OUT, PTV0_OUT,
	PTW7_OUT, PTW6_OUT, PTW5_OUT, PTW4_OUT,
	PTW3_OUT, PTW2_OUT, PTW1_OUT, PTW0_OUT,
	PTX7_OUT, PTX6_OUT, PTX5_OUT, PTX4_OUT,
	PTX3_OUT, PTX2_OUT, PTX1_OUT, PTX0_OUT,
	PTY7_OUT, PTY6_OUT, PTY5_OUT, PTY4_OUT,
	PTY3_OUT, PTY2_OUT, PTY1_OUT, PTY0_OUT,
	PTZ7_OUT, PTZ6_OUT, PTZ5_OUT, PTZ4_OUT,
	PTZ3_OUT, PTZ2_OUT, PTZ1_OUT, PTZ0_OUT,
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	PTA7_FN, PTA6_FN, PTA5_FN, PTA4_FN,
	PTA3_FN, PTA2_FN, PTA1_FN, PTA0_FN,
	PTB7_FN, PTB6_FN, PTB5_FN, PTB4_FN,
	PTB3_FN, PTB2_FN, PTB1_FN, PTB0_FN,
	PTC7_FN, PTC6_FN, PTC5_FN, PTC4_FN,
	PTC3_FN, PTC2_FN, PTC1_FN, PTC0_FN,
	PTD7_FN, PTD6_FN, PTD5_FN, PTD4_FN,
	PTD3_FN, PTD2_FN, PTD1_FN, PTD0_FN,
	PTE5_FN, PTE4_FN, PTE3_FN, PTE2_FN, PTE1_FN, PTE0_FN,
	PTF7_FN, PTF6_FN, PTF5_FN, PTF4_FN,
	PTF3_FN, PTF2_FN, PTF1_FN, PTF0_FN,
	PTG5_FN, PTG4_FN, PTG3_FN, PTG2_FN, PTG1_FN, PTG0_FN,
	PTH7_FN, PTH6_FN, PTH5_FN, PTH4_FN,
	PTH3_FN, PTH2_FN, PTH1_FN, PTH0_FN,
	PTJ7_FN, PTJ5_FN, PTJ3_FN, PTJ2_FN, PTJ1_FN, PTJ0_FN,
	PTK7_FN, PTK6_FN, PTK5_FN, PTK4_FN,
	PTK3_FN, PTK2_FN, PTK1_FN, PTK0_FN,
	PTL7_FN, PTL6_FN, PTL5_FN, PTL4_FN,
	PTL3_FN, PTL2_FN, PTL1_FN, PTL0_FN,
	PTM7_FN, PTM6_FN, PTM5_FN, PTM4_FN,
	PTM3_FN, PTM2_FN, PTM1_FN, PTM0_FN,
	PTN7_FN, PTN6_FN, PTN5_FN, PTN4_FN,
	PTN3_FN, PTN2_FN, PTN1_FN, PTN0_FN,
	PTQ3_FN, PTQ2_FN, PTQ1_FN, PTQ0_FN,
	PTR7_FN, PTR6_FN, PTR5_FN, PTR4_FN,
	PTR3_FN, PTR2_FN, PTR1_FN, PTR0_FN,
	PTS7_FN, PTS6_FN, PTS5_FN, PTS4_FN,
	PTS3_FN, PTS2_FN, PTS1_FN, PTS0_FN,
	PTT5_FN, PTT4_FN, PTT3_FN, PTT2_FN, PTT1_FN, PTT0_FN,
	PTU5_FN, PTU4_FN, PTU3_FN, PTU2_FN, PTU1_FN, PTU0_FN,
	PTV7_FN, PTV6_FN, PTV5_FN, PTV4_FN,
	PTV3_FN, PTV2_FN, PTV1_FN, PTV0_FN,
	PTW7_FN, PTW6_FN, PTW5_FN, PTW4_FN,
	PTW3_FN, PTW2_FN, PTW1_FN, PTW0_FN,
	PTX7_FN, PTX6_FN, PTX5_FN, PTX4_FN,
	PTX3_FN, PTX2_FN, PTX1_FN, PTX0_FN,
	PTY7_FN, PTY6_FN, PTY5_FN, PTY4_FN,
	PTY3_FN, PTY2_FN, PTY1_FN, PTY0_FN,
	PTZ7_FN, PTZ6_FN, PTZ5_FN, PTZ4_FN,
	PTZ3_FN, PTZ2_FN, PTZ1_FN, PTZ0_FN,


	PSA15_PSA14_FN1, PSA15_PSA14_FN2,
	PSA13_PSA12_FN1, PSA13_PSA12_FN2,
	PSA11_PSA10_FN1, PSA11_PSA10_FN2,
	PSA5_PSA4_FN1, PSA5_PSA4_FN2, PSA5_PSA4_FN3,
	PSA3_PSA2_FN1, PSA3_PSA2_FN2,
	PSB15_PSB14_FN1, PSB15_PSB14_FN2,
	PSB13_PSB12_LCDC_RGB, PSB13_PSB12_LCDC_SYS,
	PSB9_PSB8_FN1, PSB9_PSB8_FN2, PSB9_PSB8_FN3,
	PSB7_PSB6_FN1, PSB7_PSB6_FN2,
	PSB5_PSB4_FN1, PSB5_PSB4_FN2,
	PSB3_PSB2_FN1, PSB3_PSB2_FN2,
	PSC15_PSC14_FN1, PSC15_PSC14_FN2,
	PSC13_PSC12_FN1, PSC13_PSC12_FN2,
	PSC11_PSC10_FN1, PSC11_PSC10_FN2, PSC11_PSC10_FN3,
	PSC9_PSC8_FN1, PSC9_PSC8_FN2,
	PSC7_PSC6_FN1, PSC7_PSC6_FN2, PSC7_PSC6_FN3,
	PSD15_PSD14_FN1, PSD15_PSD14_FN2,
	PSD13_PSD12_FN1, PSD13_PSD12_FN2,
	PSD11_PSD10_FN1, PSD11_PSD10_FN2, PSD11_PSD10_FN3,
	PSD9_PSD8_FN1, PSD9_PSD8_FN2,
	PSD7_PSD6_FN1, PSD7_PSD6_FN2,
	PSD5_PSD4_FN1, PSD5_PSD4_FN2,
	PSD3_PSD2_FN1, PSD3_PSD2_FN2,
	PSD1_PSD0_FN1, PSD1_PSD0_FN2,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,
	SCIF0_PTT_TXD_MARK, SCIF0_PTT_RXD_MARK,
	SCIF0_PTT_SCK_MARK, SCIF0_PTU_TXD_MARK,
	SCIF0_PTU_RXD_MARK, SCIF0_PTU_SCK_MARK,

	SCIF1_PTS_TXD_MARK, SCIF1_PTS_RXD_MARK,
	SCIF1_PTS_SCK_MARK, SCIF1_PTV_TXD_MARK,
	SCIF1_PTV_RXD_MARK, SCIF1_PTV_SCK_MARK,

	SCIF2_PTT_TXD_MARK, SCIF2_PTT_RXD_MARK,
	SCIF2_PTT_SCK_MARK, SCIF2_PTU_TXD_MARK,
	SCIF2_PTU_RXD_MARK, SCIF2_PTU_SCK_MARK,

	SCIF3_PTS_TXD_MARK, SCIF3_PTS_RXD_MARK,
	SCIF3_PTS_SCK_MARK, SCIF3_PTS_RTS_MARK,
	SCIF3_PTS_CTS_MARK, SCIF3_PTV_TXD_MARK,
	SCIF3_PTV_RXD_MARK, SCIF3_PTV_SCK_MARK,
	SCIF3_PTV_RTS_MARK, SCIF3_PTV_CTS_MARK,

	SCIF4_PTE_TXD_MARK, SCIF4_PTE_RXD_MARK,
	SCIF4_PTE_SCK_MARK, SCIF4_PTN_TXD_MARK,
	SCIF4_PTN_RXD_MARK, SCIF4_PTN_SCK_MARK,

	SCIF5_PTE_TXD_MARK, SCIF5_PTE_RXD_MARK,
	SCIF5_PTE_SCK_MARK, SCIF5_PTN_TXD_MARK,
	SCIF5_PTN_RXD_MARK, SCIF5_PTN_SCK_MARK,

	VIO_D15_MARK, VIO_D14_MARK, VIO_D13_MARK, VIO_D12_MARK,
	VIO_D11_MARK, VIO_D10_MARK, VIO_D9_MARK, VIO_D8_MARK,
	VIO_D7_MARK, VIO_D6_MARK, VIO_D5_MARK, VIO_D4_MARK,
	VIO_D3_MARK, VIO_D2_MARK, VIO_D1_MARK, VIO_D0_MARK,
	VIO_FLD_MARK, VIO_CKO_MARK,
	VIO_VD1_MARK, VIO_HD1_MARK, VIO_CLK1_MARK,
	VIO_HD2_MARK, VIO_VD2_MARK, VIO_CLK2_MARK,

	LCDD23_MARK, LCDD22_MARK, LCDD21_MARK, LCDD20_MARK,
	LCDD19_MARK, LCDD18_MARK, LCDD17_MARK, LCDD16_MARK,
	LCDD15_MARK, LCDD14_MARK, LCDD13_MARK, LCDD12_MARK,
	LCDD11_MARK, LCDD10_MARK, LCDD9_MARK, LCDD8_MARK,
	LCDD7_MARK, LCDD6_MARK, LCDD5_MARK, LCDD4_MARK,
	LCDD3_MARK, LCDD2_MARK, LCDD1_MARK, LCDD0_MARK,
	LCDDON_MARK, LCDVCPWC_MARK, LCDVEPWC_MARK,
	LCDVSYN_MARK, LCDDCK_MARK, LCDHSYN_MARK, LCDDISP_MARK,
	LCDRS_MARK, LCDCS_MARK, LCDWR_MARK, LCDRD_MARK,
	LCDLCLK_PTR_MARK, LCDLCLK_PTW_MARK,

	IRQ0_MARK, IRQ1_MARK, IRQ2_MARK, IRQ3_MARK,
	IRQ4_MARK, IRQ5_MARK, IRQ6_MARK, IRQ7_MARK,

	AUDATA3_MARK, AUDATA2_MARK, AUDATA1_MARK, AUDATA0_MARK,
	AUDCK_MARK, AUDSYNC_MARK,

	SDHI0CD_PTD_MARK, SDHI0WP_PTD_MARK,
	SDHI0D3_PTD_MARK, SDHI0D2_PTD_MARK,
	SDHI0D1_PTD_MARK, SDHI0D0_PTD_MARK,
	SDHI0CMD_PTD_MARK, SDHI0CLK_PTD_MARK,

	SDHI0CD_PTS_MARK, SDHI0WP_PTS_MARK,
	SDHI0D3_PTS_MARK, SDHI0D2_PTS_MARK,
	SDHI0D1_PTS_MARK, SDHI0D0_PTS_MARK,
	SDHI0CMD_PTS_MARK, SDHI0CLK_PTS_MARK,

	SDHI1CD_MARK, SDHI1WP_MARK, SDHI1D3_MARK, SDHI1D2_MARK,
	SDHI1D1_MARK, SDHI1D0_MARK, SDHI1CMD_MARK, SDHI1CLK_MARK,

	SIUAFCK_MARK, SIUAILR_MARK, SIUAIBT_MARK, SIUAISLD_MARK,
	SIUAOLR_MARK, SIUAOBT_MARK, SIUAOSLD_MARK, SIUAMCK_MARK,
	SIUAISPD_MARK, SIUAOSPD_MARK,

	SIUBFCK_MARK, SIUBILR_MARK, SIUBIBT_MARK, SIUBISLD_MARK,
	SIUBOLR_MARK, SIUBOBT_MARK, SIUBOSLD_MARK, SIUBMCK_MARK,

	IRDA_IN_MARK, IRDA_OUT_MARK,

	DV_CLKI_MARK, DV_CLK_MARK, DV_HSYNC_MARK, DV_VSYNC_MARK,
	DV_D15_MARK, DV_D14_MARK, DV_D13_MARK, DV_D12_MARK,
	DV_D11_MARK, DV_D10_MARK, DV_D9_MARK, DV_D8_MARK,
	DV_D7_MARK, DV_D6_MARK, DV_D5_MARK, DV_D4_MARK,
	DV_D3_MARK, DV_D2_MARK, DV_D1_MARK, DV_D0_MARK,

	KEYIN0_MARK, KEYIN1_MARK, KEYIN2_MARK, KEYIN3_MARK, KEYIN4_MARK,
	KEYOUT0_MARK, KEYOUT1_MARK, KEYOUT2_MARK, KEYOUT3_MARK,
	KEYOUT4_IN6_MARK, KEYOUT5_IN5_MARK,

	MSIOF0_PTF_TXD_MARK, MSIOF0_PTF_RXD_MARK, MSIOF0_PTF_MCK_MARK,
	MSIOF0_PTF_TSYNC_MARK, MSIOF0_PTF_TSCK_MARK, MSIOF0_PTF_RSYNC_MARK,
	MSIOF0_PTF_RSCK_MARK, MSIOF0_PTF_SS1_MARK, MSIOF0_PTF_SS2_MARK,

	MSIOF0_PTT_TXD_MARK, MSIOF0_PTT_RXD_MARK, MSIOF0_PTX_MCK_MARK,
	MSIOF0_PTT_TSYNC_MARK, MSIOF0_PTT_TSCK_MARK, MSIOF0_PTT_RSYNC_MARK,
	MSIOF0_PTT_RSCK_MARK, MSIOF0_PTT_SS1_MARK, MSIOF0_PTT_SS2_MARK,

	MSIOF1_TXD_MARK, MSIOF1_RXD_MARK, MSIOF1_MCK_MARK,
	MSIOF1_TSYNC_MARK, MSIOF1_TSCK_MARK, MSIOF1_RSYNC_MARK,
	MSIOF1_RSCK_MARK, MSIOF1_SS1_MARK, MSIOF1_SS2_MARK,

	TS0_SDAT_MARK, TS0_SCK_MARK, TS0_SDEN_MARK, TS0_SPSYNC_MARK,

	FCE_MARK, NAF7_MARK, NAF6_MARK, NAF5_MARK, NAF4_MARK,
	NAF3_MARK, NAF2_MARK, NAF1_MARK, NAF0_MARK, FCDE_MARK,
	FOE_MARK, FSC_MARK, FWE_MARK, FRB_MARK,

	DACK1_MARK, DREQ1_MARK, DACK0_MARK, DREQ0_MARK,

	AN3_MARK, AN2_MARK, AN1_MARK, AN0_MARK, ADTRG_MARK,

	STATUS0_MARK, PDSTATUS_MARK,

	TPUTO3_MARK, TPUTO2_MARK, TPUTO1_MARK, TPUTO0_MARK,

	D31_MARK, D30_MARK, D29_MARK, D28_MARK,
	D27_MARK, D26_MARK, D25_MARK, D24_MARK,
	D23_MARK, D22_MARK, D21_MARK, D20_MARK,
	D19_MARK, D18_MARK, D17_MARK, D16_MARK,
	IOIS16_MARK, WAIT_MARK, BS_MARK,
	A25_MARK, A24_MARK, A23_MARK, A22_MARK,
	CS6B_CE1B_MARK, CS6A_CE2B_MARK,
	CS5B_CE1A_MARK, CS5A_CE2A_MARK,
	WE3_ICIOWR_MARK, WE2_ICIORD_MARK,

	IDED15_MARK, IDED14_MARK, IDED13_MARK, IDED12_MARK,
	IDED11_MARK, IDED10_MARK, IDED9_MARK, IDED8_MARK,
	IDED7_MARK, IDED6_MARK, IDED5_MARK, IDED4_MARK,
	IDED3_MARK, IDED2_MARK, IDED1_MARK, IDED0_MARK,
	DIRECTION_MARK, EXBUF_ENB_MARK, IDERST_MARK, IODACK_MARK,
	IODREQ_MARK, IDEIORDY_MARK, IDEINT_MARK, IDEIOWR_MARK,
	IDEIORD_MARK, IDECS1_MARK, IDECS0_MARK, IDEA2_MARK,
	IDEA1_MARK, IDEA0_MARK,
	PINMUX_MARK_END,
};

static pinmux_enum_t pinmux_data[] = {
	/* PTA GPIO */
	PINMUX_DATA(PTA7_DATA, PTA7_IN, PTA7_OUT),
	PINMUX_DATA(PTA6_DATA, PTA6_IN, PTA6_OUT),
	PINMUX_DATA(PTA5_DATA, PTA5_IN, PTA5_OUT),
	PINMUX_DATA(PTA4_DATA, PTA4_IN, PTA4_OUT, PTA4_IN_PU),
	PINMUX_DATA(PTA3_DATA, PTA3_IN, PTA3_OUT, PTA3_IN_PU),
	PINMUX_DATA(PTA2_DATA, PTA2_IN, PTA2_OUT, PTA2_IN_PU),
	PINMUX_DATA(PTA1_DATA, PTA1_IN, PTA1_OUT, PTA1_IN_PU),
	PINMUX_DATA(PTA0_DATA, PTA0_IN, PTA0_OUT, PTA0_IN_PU),

	/* PTB GPIO */
	PINMUX_DATA(PTB7_DATA, PTB7_IN, PTB7_OUT),
	PINMUX_DATA(PTB6_DATA, PTB6_IN, PTB6_OUT),
	PINMUX_DATA(PTB5_DATA, PTB5_IN, PTB5_OUT),
	PINMUX_DATA(PTB4_DATA, PTB4_IN, PTB4_OUT),
	PINMUX_DATA(PTB3_DATA, PTB3_IN, PTB3_OUT),
	PINMUX_DATA(PTB2_DATA, PTB2_IN, PTB2_OUT, PTB2_IN_PU),
	PINMUX_DATA(PTB1_DATA, PTB1_IN, PTB1_OUT, PTB1_IN_PU),
	PINMUX_DATA(PTB0_DATA, PTB0_IN, PTB0_OUT),

	/* PTC GPIO */
	PINMUX_DATA(PTC7_DATA, PTC7_IN, PTC7_OUT),
	PINMUX_DATA(PTC6_DATA, PTC6_IN, PTC6_OUT),
	PINMUX_DATA(PTC5_DATA, PTC5_IN, PTC5_OUT),
	PINMUX_DATA(PTC4_DATA, PTC4_IN, PTC4_OUT),
	PINMUX_DATA(PTC3_DATA, PTC3_IN, PTC3_OUT),
	PINMUX_DATA(PTC2_DATA, PTC2_IN, PTC2_OUT),
	PINMUX_DATA(PTC1_DATA, PTC1_IN, PTC1_OUT),
	PINMUX_DATA(PTC0_DATA, PTC0_IN, PTC0_OUT),

	/* PTD GPIO */
	PINMUX_DATA(PTD7_DATA, PTD7_IN, PTD7_OUT),
	PINMUX_DATA(PTD6_DATA, PTD6_IN, PTD6_OUT),
	PINMUX_DATA(PTD5_DATA, PTD5_IN, PTD5_OUT),
	PINMUX_DATA(PTD4_DATA, PTD4_IN, PTD4_OUT),
	PINMUX_DATA(PTD3_DATA, PTD3_IN, PTD3_OUT),
	PINMUX_DATA(PTD2_DATA, PTD2_IN, PTD2_OUT),
	PINMUX_DATA(PTD1_DATA, PTD1_IN, PTD1_OUT),
	PINMUX_DATA(PTD0_DATA, PTD0_IN, PTD0_OUT),

	/* PTE GPIO */
	PINMUX_DATA(PTE5_DATA, PTE5_IN, PTE5_OUT),
	PINMUX_DATA(PTE4_DATA, PTE4_IN, PTE4_OUT),
	PINMUX_DATA(PTE3_DATA, PTE3_IN, PTE3_OUT),
	PINMUX_DATA(PTE2_DATA, PTE2_IN, PTE2_OUT),
	PINMUX_DATA(PTE1_DATA, PTE1_IN, PTE1_OUT),
	PINMUX_DATA(PTE0_DATA, PTE0_IN, PTE0_OUT),

	/* PTF GPIO */
	PINMUX_DATA(PTF7_DATA, PTF7_IN, PTF7_OUT),
	PINMUX_DATA(PTF6_DATA, PTF6_IN, PTF6_OUT),
	PINMUX_DATA(PTF5_DATA, PTF5_IN, PTF5_OUT),
	PINMUX_DATA(PTF4_DATA, PTF4_IN, PTF4_OUT),
	PINMUX_DATA(PTF3_DATA, PTF3_IN, PTF3_OUT),
	PINMUX_DATA(PTF2_DATA, PTF2_IN, PTF2_OUT),
	PINMUX_DATA(PTF1_DATA, PTF1_IN, PTF1_OUT),
	PINMUX_DATA(PTF0_DATA, PTF0_IN, PTF0_OUT),

	/* PTG GPIO */
	PINMUX_DATA(PTG5_DATA, PTG5_OUT),
	PINMUX_DATA(PTG4_DATA, PTG4_OUT),
	PINMUX_DATA(PTG3_DATA, PTG3_OUT),
	PINMUX_DATA(PTG2_DATA, PTG2_OUT),
	PINMUX_DATA(PTG1_DATA, PTG1_OUT),
	PINMUX_DATA(PTG0_DATA, PTG0_OUT),

	/* PTH GPIO */
	PINMUX_DATA(PTH7_DATA, PTH7_IN, PTH7_OUT),
	PINMUX_DATA(PTH6_DATA, PTH6_IN, PTH6_OUT),
	PINMUX_DATA(PTH5_DATA, PTH5_IN, PTH5_OUT),
	PINMUX_DATA(PTH4_DATA, PTH4_IN, PTH4_OUT),
	PINMUX_DATA(PTH3_DATA, PTH3_IN, PTH3_OUT),
	PINMUX_DATA(PTH2_DATA, PTH2_IN, PTH2_OUT),
	PINMUX_DATA(PTH1_DATA, PTH1_IN, PTH1_OUT),
	PINMUX_DATA(PTH0_DATA, PTH0_IN, PTH0_OUT),

	/* PTJ GPIO */
	PINMUX_DATA(PTJ7_DATA, PTJ7_OUT),
	PINMUX_DATA(PTJ5_DATA, PTJ5_OUT),
	PINMUX_DATA(PTJ3_DATA, PTJ3_IN, PTJ3_OUT),
	PINMUX_DATA(PTJ2_DATA, PTJ2_IN, PTJ2_OUT),
	PINMUX_DATA(PTJ1_DATA, PTJ1_IN, PTJ1_OUT),
	PINMUX_DATA(PTJ0_DATA, PTJ0_IN, PTJ0_OUT),

	/* PTK GPIO */
	PINMUX_DATA(PTK7_DATA, PTK7_IN, PTK7_OUT),
	PINMUX_DATA(PTK6_DATA, PTK6_IN, PTK6_OUT),
	PINMUX_DATA(PTK5_DATA, PTK5_IN, PTK5_OUT),
	PINMUX_DATA(PTK4_DATA, PTK4_IN, PTK4_OUT),
	PINMUX_DATA(PTK3_DATA, PTK3_IN, PTK3_OUT),
	PINMUX_DATA(PTK2_DATA, PTK2_IN, PTK2_OUT),
	PINMUX_DATA(PTK1_DATA, PTK1_IN, PTK1_OUT),
	PINMUX_DATA(PTK0_DATA, PTK0_IN, PTK0_OUT),

	/* PTL GPIO */
	PINMUX_DATA(PTL7_DATA, PTL7_IN, PTL7_OUT),
	PINMUX_DATA(PTL6_DATA, PTL6_IN, PTL6_OUT),
	PINMUX_DATA(PTL5_DATA, PTL5_IN, PTL5_OUT),
	PINMUX_DATA(PTL4_DATA, PTL4_IN, PTL4_OUT),
	PINMUX_DATA(PTL3_DATA, PTL3_IN, PTL3_OUT),
	PINMUX_DATA(PTL2_DATA, PTL2_IN, PTL2_OUT),
	PINMUX_DATA(PTL1_DATA, PTL1_IN, PTL1_OUT),
	PINMUX_DATA(PTL0_DATA, PTL0_IN, PTL0_OUT),

	/* PTM GPIO */
	PINMUX_DATA(PTM7_DATA, PTM7_IN, PTM7_OUT),
	PINMUX_DATA(PTM6_DATA, PTM6_IN, PTM6_OUT),
	PINMUX_DATA(PTM5_DATA, PTM5_IN, PTM5_OUT),
	PINMUX_DATA(PTM4_DATA, PTM4_IN, PTM4_OUT),
	PINMUX_DATA(PTM3_DATA, PTM3_IN, PTM3_OUT),
	PINMUX_DATA(PTM2_DATA, PTM2_IN, PTM2_OUT),
	PINMUX_DATA(PTM1_DATA, PTM1_IN, PTM1_OUT),
	PINMUX_DATA(PTM0_DATA, PTM0_IN, PTM0_OUT),

	/* PTN GPIO */
	PINMUX_DATA(PTN7_DATA, PTN7_IN, PTN7_OUT),
	PINMUX_DATA(PTN6_DATA, PTN6_IN, PTN6_OUT),
	PINMUX_DATA(PTN5_DATA, PTN5_IN, PTN5_OUT),
	PINMUX_DATA(PTN4_DATA, PTN4_IN, PTN4_OUT),
	PINMUX_DATA(PTN3_DATA, PTN3_IN, PTN3_OUT),
	PINMUX_DATA(PTN2_DATA, PTN2_IN, PTN2_OUT),
	PINMUX_DATA(PTN1_DATA, PTN1_IN, PTN1_OUT),
	PINMUX_DATA(PTN0_DATA, PTN0_IN, PTN0_OUT),

	/* PTQ GPIO */
	PINMUX_DATA(PTQ3_DATA, PTQ3_IN),
	PINMUX_DATA(PTQ2_DATA, PTQ2_IN),
	PINMUX_DATA(PTQ1_DATA, PTQ1_IN),
	PINMUX_DATA(PTQ0_DATA, PTQ0_IN),

	/* PTR GPIO */
	PINMUX_DATA(PTR7_DATA, PTR7_IN, PTR7_OUT),
	PINMUX_DATA(PTR6_DATA, PTR6_IN, PTR6_OUT),
	PINMUX_DATA(PTR5_DATA, PTR5_IN, PTR5_OUT),
	PINMUX_DATA(PTR4_DATA, PTR4_IN, PTR4_OUT),
	PINMUX_DATA(PTR3_DATA, PTR3_IN),
	PINMUX_DATA(PTR2_DATA, PTR2_IN, PTR2_IN_PU),
	PINMUX_DATA(PTR1_DATA, PTR1_IN, PTR1_OUT),
	PINMUX_DATA(PTR0_DATA, PTR0_IN, PTR0_OUT),

	/* PTS GPIO */
	PINMUX_DATA(PTS7_DATA, PTS7_IN, PTS7_OUT),
	PINMUX_DATA(PTS6_DATA, PTS6_IN, PTS6_OUT),
	PINMUX_DATA(PTS5_DATA, PTS5_IN, PTS5_OUT),
	PINMUX_DATA(PTS4_DATA, PTS4_IN, PTS4_OUT),
	PINMUX_DATA(PTS3_DATA, PTS3_IN, PTS3_OUT),
	PINMUX_DATA(PTS2_DATA, PTS2_IN, PTS2_OUT),
	PINMUX_DATA(PTS1_DATA, PTS1_IN, PTS1_OUT),
	PINMUX_DATA(PTS0_DATA, PTS0_IN, PTS0_OUT),

	/* PTT GPIO */
	PINMUX_DATA(PTT5_DATA, PTT5_IN, PTT5_OUT),
	PINMUX_DATA(PTT4_DATA, PTT4_IN, PTT4_OUT),
	PINMUX_DATA(PTT3_DATA, PTT3_IN, PTT3_OUT),
	PINMUX_DATA(PTT2_DATA, PTT2_IN, PTT2_OUT),
	PINMUX_DATA(PTT1_DATA, PTT1_IN, PTT1_OUT),
	PINMUX_DATA(PTT0_DATA, PTT0_IN, PTT0_OUT),

	/* PTU GPIO */
	PINMUX_DATA(PTU5_DATA, PTU5_IN, PTU5_OUT),
	PINMUX_DATA(PTU4_DATA, PTU4_IN, PTU4_OUT),
	PINMUX_DATA(PTU3_DATA, PTU3_IN, PTU3_OUT),
	PINMUX_DATA(PTU2_DATA, PTU2_IN, PTU2_OUT),
	PINMUX_DATA(PTU1_DATA, PTU1_IN, PTU1_OUT),
	PINMUX_DATA(PTU0_DATA, PTU0_IN, PTU0_OUT),

	/* PTV GPIO */
	PINMUX_DATA(PTV7_DATA, PTV7_IN, PTV7_OUT),
	PINMUX_DATA(PTV6_DATA, PTV6_IN, PTV6_OUT),
	PINMUX_DATA(PTV5_DATA, PTV5_IN, PTV5_OUT),
	PINMUX_DATA(PTV4_DATA, PTV4_IN, PTV4_OUT),
	PINMUX_DATA(PTV3_DATA, PTV3_IN, PTV3_OUT),
	PINMUX_DATA(PTV2_DATA, PTV2_IN, PTV2_OUT),
	PINMUX_DATA(PTV1_DATA, PTV1_IN, PTV1_OUT),
	PINMUX_DATA(PTV0_DATA, PTV0_IN, PTV0_OUT),

	/* PTW GPIO */
	PINMUX_DATA(PTW7_DATA, PTW7_IN, PTW7_OUT),
	PINMUX_DATA(PTW6_DATA, PTW6_IN, PTW6_OUT),
	PINMUX_DATA(PTW5_DATA, PTW5_IN, PTW5_OUT),
	PINMUX_DATA(PTW4_DATA, PTW4_IN, PTW4_OUT),
	PINMUX_DATA(PTW3_DATA, PTW3_IN, PTW3_OUT),
	PINMUX_DATA(PTW2_DATA, PTW2_IN, PTW2_OUT),
	PINMUX_DATA(PTW1_DATA, PTW1_IN, PTW1_OUT),
	PINMUX_DATA(PTW0_DATA, PTW0_IN, PTW0_OUT),

	/* PTX GPIO */
	PINMUX_DATA(PTX7_DATA, PTX7_IN, PTX7_OUT),
	PINMUX_DATA(PTX6_DATA, PTX6_IN, PTX6_OUT),
	PINMUX_DATA(PTX5_DATA, PTX5_IN, PTX5_OUT),
	PINMUX_DATA(PTX4_DATA, PTX4_IN, PTX4_OUT),
	PINMUX_DATA(PTX3_DATA, PTX3_IN, PTX3_OUT),
	PINMUX_DATA(PTX2_DATA, PTX2_IN, PTX2_OUT),
	PINMUX_DATA(PTX1_DATA, PTX1_IN, PTX1_OUT),
	PINMUX_DATA(PTX0_DATA, PTX0_IN, PTX0_OUT),

	/* PTY GPIO */
	PINMUX_DATA(PTY7_DATA, PTY7_IN, PTY7_OUT),
	PINMUX_DATA(PTY6_DATA, PTY6_IN, PTY6_OUT),
	PINMUX_DATA(PTY5_DATA, PTY5_IN, PTY5_OUT),
	PINMUX_DATA(PTY4_DATA, PTY4_IN, PTY4_OUT),
	PINMUX_DATA(PTY3_DATA, PTY3_IN, PTY3_OUT),
	PINMUX_DATA(PTY2_DATA, PTY2_IN, PTY2_OUT),
	PINMUX_DATA(PTY1_DATA, PTY1_IN, PTY1_OUT),
	PINMUX_DATA(PTY0_DATA, PTY0_IN, PTY0_OUT),

	/* PTZ GPIO */
	PINMUX_DATA(PTZ7_DATA, PTZ7_IN, PTZ7_OUT),
	PINMUX_DATA(PTZ6_DATA, PTZ6_IN, PTZ6_OUT),
	PINMUX_DATA(PTZ5_DATA, PTZ5_IN, PTZ5_OUT),
	PINMUX_DATA(PTZ4_DATA, PTZ4_IN, PTZ4_OUT),
	PINMUX_DATA(PTZ3_DATA, PTZ3_IN, PTZ3_OUT),
	PINMUX_DATA(PTZ2_DATA, PTZ2_IN, PTZ2_OUT),
	PINMUX_DATA(PTZ1_DATA, PTZ1_IN, PTZ1_OUT),
	PINMUX_DATA(PTZ0_DATA, PTZ0_IN, PTZ0_OUT),

	/* PTA FN */
	PINMUX_DATA(D23_MARK, PSA15_PSA14_FN1, PTA7_FN),
	PINMUX_DATA(KEYOUT2_MARK, PSA15_PSA14_FN2, PTA7_FN),
	PINMUX_DATA(D22_MARK, PSA15_PSA14_FN1, PTA6_FN),
	PINMUX_DATA(KEYOUT1_MARK, PSA15_PSA14_FN2, PTA6_FN),
	PINMUX_DATA(D21_MARK, PSA15_PSA14_FN1, PTA5_FN),
	PINMUX_DATA(KEYOUT0_MARK, PSA15_PSA14_FN2, PTA5_FN),
	PINMUX_DATA(D20_MARK, PSA15_PSA14_FN1, PTA4_FN),
	PINMUX_DATA(KEYIN4_MARK, PSA15_PSA14_FN2, PTA4_FN),
	PINMUX_DATA(D19_MARK, PSA15_PSA14_FN1, PTA3_FN),
	PINMUX_DATA(KEYIN3_MARK, PSA15_PSA14_FN2, PTA3_FN),
	PINMUX_DATA(D18_MARK, PSA15_PSA14_FN1, PTA2_FN),
	PINMUX_DATA(KEYIN2_MARK, PSA15_PSA14_FN2, PTA2_FN),
	PINMUX_DATA(D17_MARK, PSA15_PSA14_FN1, PTA1_FN),
	PINMUX_DATA(KEYIN1_MARK, PSA15_PSA14_FN2, PTA1_FN),
	PINMUX_DATA(D16_MARK, PSA15_PSA14_FN1, PTA0_FN),
	PINMUX_DATA(KEYIN0_MARK, PSA15_PSA14_FN2, PTA0_FN),

	/* PTB FN */
	PINMUX_DATA(D31_MARK, PTB7_FN),
	PINMUX_DATA(D30_MARK, PTB6_FN),
	PINMUX_DATA(D29_MARK, PTB5_FN),
	PINMUX_DATA(D28_MARK, PTB4_FN),
	PINMUX_DATA(D27_MARK, PTB3_FN),
	PINMUX_DATA(D26_MARK, PSA15_PSA14_FN1, PTB2_FN),
	PINMUX_DATA(KEYOUT5_IN5_MARK, PSA15_PSA14_FN2, PTB2_FN),
	PINMUX_DATA(D25_MARK, PSA15_PSA14_FN1, PTB1_FN),
	PINMUX_DATA(KEYOUT4_IN6_MARK, PSA15_PSA14_FN2, PTB1_FN),
	PINMUX_DATA(D24_MARK, PSA15_PSA14_FN1, PTB0_FN),
	PINMUX_DATA(KEYOUT3_MARK, PSA15_PSA14_FN2, PTB0_FN),

	/* PTC FN */
	PINMUX_DATA(IDED15_MARK, PSA11_PSA10_FN1, PTC7_FN),
	PINMUX_DATA(SDHI1CD_MARK, PSA11_PSA10_FN2, PTC7_FN),
	PINMUX_DATA(IDED14_MARK, PSA11_PSA10_FN1, PTC6_FN),
	PINMUX_DATA(SDHI1WP_MARK, PSA11_PSA10_FN2, PTC6_FN),
	PINMUX_DATA(IDED13_MARK, PSA11_PSA10_FN1, PTC5_FN),
	PINMUX_DATA(SDHI1D3_MARK, PSA11_PSA10_FN2, PTC5_FN),
	PINMUX_DATA(IDED12_MARK, PSA11_PSA10_FN1, PTC4_FN),
	PINMUX_DATA(SDHI1D2_MARK, PSA11_PSA10_FN2, PTC4_FN),
	PINMUX_DATA(IDED11_MARK, PSA11_PSA10_FN1, PTC3_FN),
	PINMUX_DATA(SDHI1D1_MARK, PSA11_PSA10_FN2, PTC3_FN),
	PINMUX_DATA(IDED10_MARK, PSA11_PSA10_FN1, PTC2_FN),
	PINMUX_DATA(SDHI1D0_MARK, PSA11_PSA10_FN2, PTC2_FN),
	PINMUX_DATA(IDED9_MARK, PSA11_PSA10_FN1, PTC1_FN),
	PINMUX_DATA(SDHI1CMD_MARK, PSA11_PSA10_FN2, PTC1_FN),
	PINMUX_DATA(IDED8_MARK, PSA11_PSA10_FN1, PTC0_FN),
	PINMUX_DATA(SDHI1CLK_MARK, PSA11_PSA10_FN2, PTC0_FN),

	/* PTD FN */
	PINMUX_DATA(IDED7_MARK, PSA11_PSA10_FN1, PTD7_FN),
	PINMUX_DATA(SDHI0CD_PTD_MARK, PSA11_PSA10_FN2, PTD7_FN),
	PINMUX_DATA(IDED6_MARK, PSA11_PSA10_FN1, PTD6_FN),
	PINMUX_DATA(SDHI0WP_PTD_MARK, PSA11_PSA10_FN2, PTD6_FN),
	PINMUX_DATA(IDED5_MARK, PSA11_PSA10_FN1, PTD5_FN),
	PINMUX_DATA(SDHI0D3_PTD_MARK, PSA11_PSA10_FN2, PTD5_FN),
	PINMUX_DATA(IDED4_MARK, PSA11_PSA10_FN1, PTD4_FN),
	PINMUX_DATA(SDHI0D2_PTD_MARK, PSA11_PSA10_FN2, PTD4_FN),
	PINMUX_DATA(IDED3_MARK, PSA11_PSA10_FN1, PTD3_FN),
	PINMUX_DATA(SDHI0D1_PTD_MARK, PSA11_PSA10_FN2, PTD3_FN),
	PINMUX_DATA(IDED2_MARK, PSA11_PSA10_FN1, PTD2_FN),
	PINMUX_DATA(SDHI0D0_PTD_MARK, PSA11_PSA10_FN2, PTD2_FN),
	PINMUX_DATA(IDED1_MARK, PSA11_PSA10_FN1, PTD1_FN),
	PINMUX_DATA(SDHI0CMD_PTD_MARK, PSA11_PSA10_FN2, PTD1_FN),
	PINMUX_DATA(IDED0_MARK, PSA11_PSA10_FN1, PTD0_FN),
	PINMUX_DATA(SDHI0CLK_PTD_MARK, PSA11_PSA10_FN2, PTD0_FN),

	/* PTE FN */
	PINMUX_DATA(DIRECTION_MARK, PSA11_PSA10_FN1, PTE5_FN),
	PINMUX_DATA(SCIF5_PTE_SCK_MARK, PSA11_PSA10_FN2, PTE5_FN),
	PINMUX_DATA(EXBUF_ENB_MARK, PSA11_PSA10_FN1, PTE4_FN),
	PINMUX_DATA(SCIF5_PTE_RXD_MARK, PSA11_PSA10_FN2, PTE4_FN),
	PINMUX_DATA(IDERST_MARK, PSA11_PSA10_FN1, PTE3_FN),
	PINMUX_DATA(SCIF5_PTE_TXD_MARK, PSA11_PSA10_FN2, PTE3_FN),
	PINMUX_DATA(IODACK_MARK, PSA11_PSA10_FN1, PTE2_FN),
	PINMUX_DATA(SCIF4_PTE_SCK_MARK, PSA11_PSA10_FN2, PTE2_FN),
	PINMUX_DATA(IODREQ_MARK, PSA11_PSA10_FN1, PTE1_FN),
	PINMUX_DATA(SCIF4_PTE_RXD_MARK, PSA11_PSA10_FN2, PTE1_FN),
	PINMUX_DATA(IDEIORDY_MARK, PSA11_PSA10_FN1, PTE0_FN),
	PINMUX_DATA(SCIF4_PTE_TXD_MARK, PSA11_PSA10_FN2, PTE0_FN),

	/* PTF FN */
	PINMUX_DATA(IDEINT_MARK, PTF7_FN),
	PINMUX_DATA(IDEIOWR_MARK, PSA5_PSA4_FN1, PTF6_FN),
	PINMUX_DATA(MSIOF0_PTF_SS2_MARK, PSA5_PSA4_FN2, PTF6_FN),
	PINMUX_DATA(MSIOF0_PTF_RSYNC_MARK, PSA5_PSA4_FN3, PTF6_FN),
	PINMUX_DATA(IDEIORD_MARK, PSA5_PSA4_FN1, PTF5_FN),
	PINMUX_DATA(MSIOF0_PTF_SS1_MARK, PSA5_PSA4_FN2, PTF5_FN),
	PINMUX_DATA(MSIOF0_PTF_RSCK_MARK, PSA5_PSA4_FN3, PTF5_FN),
	PINMUX_DATA(IDECS1_MARK, PSA11_PSA10_FN1, PTF4_FN),
	PINMUX_DATA(MSIOF0_PTF_TSYNC_MARK, PSA11_PSA10_FN2, PTF4_FN),
	PINMUX_DATA(IDECS0_MARK, PSA11_PSA10_FN1, PTF3_FN),
	PINMUX_DATA(MSIOF0_PTF_TSCK_MARK, PSA11_PSA10_FN2, PTF3_FN),
	PINMUX_DATA(IDEA2_MARK, PSA11_PSA10_FN1, PTF2_FN),
	PINMUX_DATA(MSIOF0_PTF_RXD_MARK, PSA11_PSA10_FN2, PTF2_FN),
	PINMUX_DATA(IDEA1_MARK, PSA11_PSA10_FN1, PTF1_FN),
	PINMUX_DATA(MSIOF0_PTF_TXD_MARK, PSA11_PSA10_FN2, PTF1_FN),
	PINMUX_DATA(IDEA0_MARK, PSA11_PSA10_FN1, PTF0_FN),
	PINMUX_DATA(MSIOF0_PTF_MCK_MARK, PSA11_PSA10_FN2, PTF0_FN),

	/* PTG FN */
	PINMUX_DATA(AUDCK_MARK, PTG5_FN),
	PINMUX_DATA(AUDSYNC_MARK, PTG4_FN),
	PINMUX_DATA(AUDATA3_MARK, PSA3_PSA2_FN1, PTG3_FN),
	PINMUX_DATA(TPUTO3_MARK, PSA3_PSA2_FN2, PTG3_FN),
	PINMUX_DATA(AUDATA2_MARK, PSA3_PSA2_FN1, PTG2_FN),
	PINMUX_DATA(TPUTO2_MARK, PSA3_PSA2_FN2, PTG2_FN),
	PINMUX_DATA(AUDATA1_MARK, PSA3_PSA2_FN1, PTG1_FN),
	PINMUX_DATA(TPUTO1_MARK, PSA3_PSA2_FN2, PTG1_FN),
	PINMUX_DATA(AUDATA0_MARK, PSA3_PSA2_FN1, PTG0_FN),
	PINMUX_DATA(TPUTO0_MARK, PSA3_PSA2_FN2, PTG0_FN),

	/* PTG FN */
	PINMUX_DATA(LCDVCPWC_MARK, PTH7_FN),
	PINMUX_DATA(LCDRD_MARK, PSB15_PSB14_FN1, PTH6_FN),
	PINMUX_DATA(DV_CLKI_MARK, PSB15_PSB14_FN2, PTH6_FN),
	PINMUX_DATA(LCDVSYN_MARK, PSB15_PSB14_FN1, PTH5_FN),
	PINMUX_DATA(DV_CLK_MARK, PSB15_PSB14_FN2, PTH5_FN),
	PINMUX_DATA(LCDDISP_MARK, PSB13_PSB12_LCDC_RGB, PTH4_FN),
	PINMUX_DATA(LCDRS_MARK, PSB13_PSB12_LCDC_SYS, PTH4_FN),
	PINMUX_DATA(LCDHSYN_MARK, PSB13_PSB12_LCDC_RGB, PTH3_FN),
	PINMUX_DATA(LCDCS_MARK, PSB13_PSB12_LCDC_SYS, PTH3_FN),
	PINMUX_DATA(LCDDON_MARK, PTH2_FN),
	PINMUX_DATA(LCDDCK_MARK, PSB13_PSB12_LCDC_RGB, PTH1_FN),
	PINMUX_DATA(LCDWR_MARK, PSB13_PSB12_LCDC_SYS, PTH1_FN),
	PINMUX_DATA(LCDVEPWC_MARK, PTH0_FN),

	/* PTJ FN */
	PINMUX_DATA(STATUS0_MARK, PTJ7_FN),
	PINMUX_DATA(PDSTATUS_MARK, PTJ5_FN),
	PINMUX_DATA(A25_MARK, PTJ3_FN),
	PINMUX_DATA(A24_MARK, PTJ2_FN),
	PINMUX_DATA(A23_MARK, PTJ1_FN),
	PINMUX_DATA(A22_MARK, PTJ0_FN),

	/* PTK FN */
	PINMUX_DATA(SIUAFCK_MARK, PTK7_FN),
	PINMUX_DATA(SIUAILR_MARK, PSB9_PSB8_FN1, PTK6_FN),
	PINMUX_DATA(MSIOF1_SS2_MARK, PSB9_PSB8_FN2, PTK6_FN),
	PINMUX_DATA(MSIOF1_RSYNC_MARK, PSB9_PSB8_FN3, PTK6_FN),
	PINMUX_DATA(SIUAIBT_MARK, PSB9_PSB8_FN1, PTK5_FN),
	PINMUX_DATA(MSIOF1_SS1_MARK, PSB9_PSB8_FN2, PTK5_FN),
	PINMUX_DATA(MSIOF1_RSCK_MARK, PSB9_PSB8_FN3, PTK5_FN),
	PINMUX_DATA(SIUAISLD_MARK, PSB7_PSB6_FN1, PTK4_FN),
	PINMUX_DATA(MSIOF1_RXD_MARK, PSB7_PSB6_FN2, PTK4_FN),
	PINMUX_DATA(SIUAOLR_MARK, PSB7_PSB6_FN1, PTK3_FN),
	PINMUX_DATA(MSIOF1_TSYNC_MARK, PSB7_PSB6_FN2, PTK3_FN),
	PINMUX_DATA(SIUAOBT_MARK, PSB7_PSB6_FN1, PTK2_FN),
	PINMUX_DATA(MSIOF1_TSCK_MARK, PSB7_PSB6_FN2, PTK2_FN),
	PINMUX_DATA(SIUAOSLD_MARK, PSB7_PSB6_FN1, PTK1_FN),
	PINMUX_DATA(MSIOF1_RXD_MARK, PSB7_PSB6_FN2, PTK1_FN),
	PINMUX_DATA(SIUAMCK_MARK, PSB7_PSB6_FN1, PTK0_FN),
	PINMUX_DATA(MSIOF1_MCK_MARK, PSB7_PSB6_FN2, PTK0_FN),

	/* PTL FN */
	PINMUX_DATA(LCDD15_MARK, PSB5_PSB4_FN1, PTL7_FN),
	PINMUX_DATA(DV_D15_MARK, PSB5_PSB4_FN2, PTL7_FN),
	PINMUX_DATA(LCDD14_MARK, PSB5_PSB4_FN1, PTL6_FN),
	PINMUX_DATA(DV_D14_MARK, PSB5_PSB4_FN2, PTL6_FN),
	PINMUX_DATA(LCDD13_MARK, PSB5_PSB4_FN1, PTL5_FN),
	PINMUX_DATA(DV_D13_MARK, PSB5_PSB4_FN2, PTL5_FN),
	PINMUX_DATA(LCDD12_MARK, PSB5_PSB4_FN1, PTL4_FN),
	PINMUX_DATA(DV_D12_MARK, PSB5_PSB4_FN2, PTL4_FN),
	PINMUX_DATA(LCDD11_MARK, PSB5_PSB4_FN1, PTL3_FN),
	PINMUX_DATA(DV_D11_MARK, PSB5_PSB4_FN2, PTL3_FN),
	PINMUX_DATA(LCDD10_MARK, PSB5_PSB4_FN1, PTL2_FN),
	PINMUX_DATA(DV_D10_MARK, PSB5_PSB4_FN2, PTL2_FN),
	PINMUX_DATA(LCDD9_MARK, PSB5_PSB4_FN1, PTL1_FN),
	PINMUX_DATA(DV_D9_MARK, PSB5_PSB4_FN2, PTL1_FN),
	PINMUX_DATA(LCDD8_MARK, PSB5_PSB4_FN1, PTL0_FN),
	PINMUX_DATA(DV_D8_MARK, PSB5_PSB4_FN2, PTL0_FN),

	/* PTM FN */
	PINMUX_DATA(LCDD7_MARK, PSB5_PSB4_FN1, PTM7_FN),
	PINMUX_DATA(DV_D7_MARK, PSB5_PSB4_FN2, PTM7_FN),
	PINMUX_DATA(LCDD6_MARK, PSB5_PSB4_FN1, PTM6_FN),
	PINMUX_DATA(DV_D6_MARK, PSB5_PSB4_FN2, PTM6_FN),
	PINMUX_DATA(LCDD5_MARK, PSB5_PSB4_FN1, PTM5_FN),
	PINMUX_DATA(DV_D5_MARK, PSB5_PSB4_FN2, PTM5_FN),
	PINMUX_DATA(LCDD4_MARK, PSB5_PSB4_FN1, PTM4_FN),
	PINMUX_DATA(DV_D4_MARK, PSB5_PSB4_FN2, PTM4_FN),
	PINMUX_DATA(LCDD3_MARK, PSB5_PSB4_FN1, PTM3_FN),
	PINMUX_DATA(DV_D3_MARK, PSB5_PSB4_FN2, PTM3_FN),
	PINMUX_DATA(LCDD2_MARK, PSB5_PSB4_FN1, PTM2_FN),
	PINMUX_DATA(DV_D2_MARK, PSB5_PSB4_FN2, PTM2_FN),
	PINMUX_DATA(LCDD1_MARK, PSB5_PSB4_FN1, PTM1_FN),
	PINMUX_DATA(DV_D1_MARK, PSB5_PSB4_FN2, PTM1_FN),
	PINMUX_DATA(LCDD0_MARK, PSB5_PSB4_FN1, PTM0_FN),
	PINMUX_DATA(DV_D0_MARK, PSB5_PSB4_FN2, PTM0_FN),

	/* PTN FN */
	PINMUX_DATA(LCDD23_MARK, PSB3_PSB2_FN1, PTN7_FN),
	PINMUX_DATA(SCIF5_PTN_SCK_MARK, PSB3_PSB2_FN2, PTN7_FN),
	PINMUX_DATA(LCDD22_MARK, PSB3_PSB2_FN1, PTN6_FN),
	PINMUX_DATA(SCIF5_PTN_RXD_MARK, PSB3_PSB2_FN2, PTN6_FN),
	PINMUX_DATA(LCDD21_MARK, PSB3_PSB2_FN1, PTN5_FN),
	PINMUX_DATA(SCIF5_PTN_TXD_MARK, PSB3_PSB2_FN2, PTN5_FN),
	PINMUX_DATA(LCDD20_MARK, PSB3_PSB2_FN1, PTN4_FN),
	PINMUX_DATA(SCIF4_PTN_SCK_MARK, PSB3_PSB2_FN2, PTN4_FN),
	PINMUX_DATA(LCDD19_MARK, PSB3_PSB2_FN1, PTN3_FN),
	PINMUX_DATA(SCIF4_PTN_RXD_MARK, PSB3_PSB2_FN2, PTN3_FN),
	PINMUX_DATA(LCDD18_MARK, PSB3_PSB2_FN1, PTN2_FN),
	PINMUX_DATA(SCIF4_PTN_TXD_MARK, PSB3_PSB2_FN2, PTN2_FN),
	PINMUX_DATA(LCDD17_MARK, PSB5_PSB4_FN1, PTN1_FN),
	PINMUX_DATA(DV_VSYNC_MARK, PSB5_PSB4_FN2, PTN1_FN),
	PINMUX_DATA(LCDD16_MARK, PSB5_PSB4_FN1, PTN0_FN),
	PINMUX_DATA(DV_HSYNC_MARK, PSB5_PSB4_FN2, PTN0_FN),

	/* PTQ FN */
	PINMUX_DATA(AN3_MARK, PTQ3_FN),
	PINMUX_DATA(AN2_MARK, PTQ2_FN),
	PINMUX_DATA(AN1_MARK, PTQ1_FN),
	PINMUX_DATA(AN0_MARK, PTQ0_FN),

	/* PTR FN */
	PINMUX_DATA(CS6B_CE1B_MARK, PTR7_FN),
	PINMUX_DATA(CS6A_CE2B_MARK, PTR6_FN),
	PINMUX_DATA(CS5B_CE1A_MARK, PTR5_FN),
	PINMUX_DATA(CS5A_CE2A_MARK, PTR4_FN),
	PINMUX_DATA(IOIS16_MARK, PSA13_PSA12_FN1, PTR3_FN),
	PINMUX_DATA(LCDLCLK_PTR_MARK, PSA13_PSA12_FN2, PTR3_FN),
	PINMUX_DATA(WAIT_MARK, PTR2_FN),
	PINMUX_DATA(WE3_ICIOWR_MARK, PTR1_FN),
	PINMUX_DATA(WE2_ICIORD_MARK, PTR0_FN),

	/* PTS FN */
	PINMUX_DATA(SCIF1_PTS_SCK_MARK, PSC15_PSC14_FN1, PTS7_FN),
	PINMUX_DATA(SDHI0CD_PTS_MARK, PSC15_PSC14_FN2, PTS7_FN),
	PINMUX_DATA(SCIF1_PTS_RXD_MARK, PSC15_PSC14_FN1, PTS6_FN),
	PINMUX_DATA(SDHI0WP_PTS_MARK, PSC15_PSC14_FN2, PTS6_FN),
	PINMUX_DATA(SCIF1_PTS_TXD_MARK, PSC15_PSC14_FN1, PTS5_FN),
	PINMUX_DATA(SDHI0D3_PTS_MARK, PSC15_PSC14_FN2, PTS5_FN),
	PINMUX_DATA(SCIF3_PTS_CTS_MARK, PSC15_PSC14_FN1, PTS4_FN),
	PINMUX_DATA(SDHI0D2_PTS_MARK, PSC15_PSC14_FN2, PTS4_FN),
	PINMUX_DATA(SCIF3_PTS_RTS_MARK, PSC15_PSC14_FN1, PTS3_FN),
	PINMUX_DATA(SDHI0D1_PTS_MARK, PSC15_PSC14_FN2, PTS3_FN),
	PINMUX_DATA(SCIF3_PTS_SCK_MARK, PSC15_PSC14_FN1, PTS2_FN),
	PINMUX_DATA(SDHI0D0_PTS_MARK, PSC15_PSC14_FN2, PTS2_FN),
	PINMUX_DATA(SCIF3_PTS_RXD_MARK, PSC15_PSC14_FN1, PTS1_FN),
	PINMUX_DATA(SDHI0CMD_PTS_MARK, PSC15_PSC14_FN2, PTS1_FN),
	PINMUX_DATA(SCIF3_PTS_TXD_MARK, PSC15_PSC14_FN1, PTS0_FN),
	PINMUX_DATA(SDHI0CLK_PTS_MARK, PSC15_PSC14_FN2, PTS0_FN),

	/* PTT FN */
	PINMUX_DATA(SCIF0_PTT_SCK_MARK, PSC13_PSC12_FN1, PTT5_FN),
	PINMUX_DATA(MSIOF0_PTT_TSCK_MARK, PSC13_PSC12_FN2, PTT5_FN),
	PINMUX_DATA(SCIF0_PTT_RXD_MARK, PSC13_PSC12_FN1, PTT4_FN),
	PINMUX_DATA(MSIOF0_PTT_RXD_MARK, PSC13_PSC12_FN2, PTT4_FN),
	PINMUX_DATA(SCIF0_PTT_TXD_MARK, PSC13_PSC12_FN1, PTT3_FN),
	PINMUX_DATA(MSIOF0_PTT_TXD_MARK, PSC13_PSC12_FN2, PTT3_FN),
	PINMUX_DATA(SCIF2_PTT_SCK_MARK, PSC11_PSC10_FN1, PTT2_FN),
	PINMUX_DATA(MSIOF0_PTT_TSYNC_MARK, PSC11_PSC10_FN2, PTT2_FN),
	PINMUX_DATA(SCIF2_PTT_RXD_MARK, PSC11_PSC10_FN1, PTT1_FN),
	PINMUX_DATA(MSIOF0_PTT_SS1_MARK, PSC11_PSC10_FN2, PTT1_FN),
	PINMUX_DATA(MSIOF0_PTT_RSCK_MARK, PSC11_PSC10_FN3, PTT1_FN),
	PINMUX_DATA(SCIF2_PTT_TXD_MARK, PSC11_PSC10_FN1, PTT0_FN),
	PINMUX_DATA(MSIOF0_PTT_SS2_MARK, PSC11_PSC10_FN2, PTT0_FN),
	PINMUX_DATA(MSIOF0_PTT_RSYNC_MARK, PSC11_PSC10_FN3, PTT0_FN),

	/* PTU FN */
	PINMUX_DATA(FCDE_MARK, PSC9_PSC8_FN1, PTU5_FN),
	PINMUX_DATA(SCIF0_PTU_SCK_MARK, PSC9_PSC8_FN2, PTU5_FN),
	PINMUX_DATA(FSC_MARK, PSC9_PSC8_FN1, PTU4_FN),
	PINMUX_DATA(SCIF0_PTU_RXD_MARK, PSC9_PSC8_FN2, PTU4_FN),
	PINMUX_DATA(FWE_MARK, PSC9_PSC8_FN1, PTU3_FN),
	PINMUX_DATA(SCIF0_PTU_TXD_MARK, PSC9_PSC8_FN2, PTU3_FN),
	PINMUX_DATA(FOE_MARK, PSC7_PSC6_FN1, PTU2_FN),
	PINMUX_DATA(SCIF2_PTU_SCK_MARK, PSC7_PSC6_FN2, PTU2_FN),
	PINMUX_DATA(VIO_VD2_MARK, PSC7_PSC6_FN3, PTU2_FN),
	PINMUX_DATA(FRB_MARK, PSC7_PSC6_FN1, PTU1_FN),
	PINMUX_DATA(SCIF2_PTU_RXD_MARK, PSC7_PSC6_FN2, PTU1_FN),
	PINMUX_DATA(VIO_CLK2_MARK, PSC7_PSC6_FN3, PTU1_FN),
	PINMUX_DATA(FCE_MARK, PSC7_PSC6_FN1, PTU0_FN),
	PINMUX_DATA(SCIF2_PTU_TXD_MARK, PSC7_PSC6_FN2, PTU0_FN),
	PINMUX_DATA(VIO_HD2_MARK, PSC7_PSC6_FN3, PTU0_FN),

	/* PTV FN */
	PINMUX_DATA(NAF7_MARK, PSC7_PSC6_FN1, PTV7_FN),
	PINMUX_DATA(SCIF1_PTV_SCK_MARK, PSC7_PSC6_FN2, PTV7_FN),
	PINMUX_DATA(VIO_D15_MARK, PSC7_PSC6_FN3, PTV7_FN),
	PINMUX_DATA(NAF6_MARK, PSC7_PSC6_FN1, PTV6_FN),
	PINMUX_DATA(SCIF1_PTV_RXD_MARK, PSC7_PSC6_FN2, PTV6_FN),
	PINMUX_DATA(VIO_D14_MARK, PSC7_PSC6_FN3, PTV6_FN),
	PINMUX_DATA(NAF5_MARK, PSC7_PSC6_FN1, PTV5_FN),
	PINMUX_DATA(SCIF1_PTV_TXD_MARK, PSC7_PSC6_FN2, PTV5_FN),
	PINMUX_DATA(VIO_D13_MARK, PSC7_PSC6_FN3, PTV5_FN),
	PINMUX_DATA(NAF4_MARK, PSC7_PSC6_FN1, PTV4_FN),
	PINMUX_DATA(SCIF3_PTV_CTS_MARK, PSC7_PSC6_FN2, PTV4_FN),
	PINMUX_DATA(VIO_D12_MARK, PSC7_PSC6_FN3, PTV4_FN),
	PINMUX_DATA(NAF3_MARK, PSC7_PSC6_FN1, PTV3_FN),
	PINMUX_DATA(SCIF3_PTV_RTS_MARK, PSC7_PSC6_FN2, PTV3_FN),
	PINMUX_DATA(VIO_D11_MARK, PSC7_PSC6_FN3, PTV3_FN),
	PINMUX_DATA(NAF2_MARK, PSC7_PSC6_FN1, PTV2_FN),
	PINMUX_DATA(SCIF3_PTV_SCK_MARK, PSC7_PSC6_FN2, PTV2_FN),
	PINMUX_DATA(VIO_D10_MARK, PSC7_PSC6_FN3, PTV2_FN),
	PINMUX_DATA(NAF1_MARK, PSC7_PSC6_FN1, PTV1_FN),
	PINMUX_DATA(SCIF3_PTV_RXD_MARK, PSC7_PSC6_FN2, PTV1_FN),
	PINMUX_DATA(VIO_D9_MARK, PSC7_PSC6_FN3, PTV1_FN),
	PINMUX_DATA(NAF0_MARK, PSC7_PSC6_FN1, PTV0_FN),
	PINMUX_DATA(SCIF3_PTV_TXD_MARK, PSC7_PSC6_FN2, PTV0_FN),
	PINMUX_DATA(VIO_D8_MARK, PSC7_PSC6_FN3, PTV0_FN),

	/* PTW FN */
	PINMUX_DATA(IRQ7_MARK, PTW7_FN),
	PINMUX_DATA(IRQ6_MARK, PTW6_FN),
	PINMUX_DATA(IRQ5_MARK, PTW5_FN),
	PINMUX_DATA(IRQ4_MARK, PSD15_PSD14_FN1, PTW4_FN),
	PINMUX_DATA(LCDLCLK_PTW_MARK, PSD15_PSD14_FN2, PTW4_FN),
	PINMUX_DATA(IRQ3_MARK, PSD13_PSD12_FN1, PTW3_FN),
	PINMUX_DATA(ADTRG_MARK, PSD13_PSD12_FN2, PTW3_FN),
	PINMUX_DATA(IRQ2_MARK, PSD11_PSD10_FN1, PTW2_FN),
	PINMUX_DATA(BS_MARK, PSD11_PSD10_FN2, PTW2_FN),
	PINMUX_DATA(VIO_CKO_MARK, PSD11_PSD10_FN3, PTW2_FN),
	PINMUX_DATA(IRQ1_MARK, PSD9_PSD8_FN1, PTW1_FN),
	PINMUX_DATA(SIUAISPD_MARK, PSD9_PSD8_FN2, PTW1_FN),
	PINMUX_DATA(IRQ0_MARK, PSD7_PSD6_FN1, PTW0_FN),
	PINMUX_DATA(SIUAOSPD_MARK, PSD7_PSD6_FN2, PTW0_FN),

	/* PTX FN */
	PINMUX_DATA(DACK1_MARK, PTX7_FN),
	PINMUX_DATA(DREQ1_MARK, PSD3_PSD2_FN1, PTX6_FN),
	PINMUX_DATA(MSIOF0_PTX_MCK_MARK, PSD3_PSD2_FN2, PTX6_FN),
	PINMUX_DATA(DACK1_MARK, PTX5_FN),
	PINMUX_DATA(IRDA_OUT_MARK, PSD5_PSD4_FN2, PTX5_FN),
	PINMUX_DATA(DREQ1_MARK, PTX4_FN),
	PINMUX_DATA(IRDA_IN_MARK, PSD5_PSD4_FN2, PTX4_FN),
	PINMUX_DATA(TS0_SDAT_MARK, PTX3_FN),
	PINMUX_DATA(TS0_SCK_MARK, PTX2_FN),
	PINMUX_DATA(TS0_SDEN_MARK, PTX1_FN),
	PINMUX_DATA(TS0_SPSYNC_MARK, PTX0_FN),

	/* PTY FN */
	PINMUX_DATA(VIO_D7_MARK, PTY7_FN),
	PINMUX_DATA(VIO_D6_MARK, PTY6_FN),
	PINMUX_DATA(VIO_D5_MARK, PTY5_FN),
	PINMUX_DATA(VIO_D4_MARK, PTY4_FN),
	PINMUX_DATA(VIO_D3_MARK, PTY3_FN),
	PINMUX_DATA(VIO_D2_MARK, PTY2_FN),
	PINMUX_DATA(VIO_D1_MARK, PTY1_FN),
	PINMUX_DATA(VIO_D0_MARK, PTY0_FN),

	/* PTZ FN */
	PINMUX_DATA(SIUBOBT_MARK, PTZ7_FN),
	PINMUX_DATA(SIUBOLR_MARK, PTZ6_FN),
	PINMUX_DATA(SIUBOSLD_MARK, PTZ5_FN),
	PINMUX_DATA(SIUBMCK_MARK, PTZ4_FN),
	PINMUX_DATA(VIO_FLD_MARK, PSD1_PSD0_FN1, PTZ3_FN),
	PINMUX_DATA(SIUBFCK_MARK, PSD1_PSD0_FN2, PTZ3_FN),
	PINMUX_DATA(VIO_HD1_MARK, PSD1_PSD0_FN1, PTZ2_FN),
	PINMUX_DATA(SIUBILR_MARK, PSD1_PSD0_FN2, PTZ2_FN),
	PINMUX_DATA(VIO_VD1_MARK, PSD1_PSD0_FN1, PTZ1_FN),
	PINMUX_DATA(SIUBIBT_MARK, PSD1_PSD0_FN2, PTZ1_FN),
	PINMUX_DATA(VIO_CLK1_MARK, PSD1_PSD0_FN1, PTZ0_FN),
	PINMUX_DATA(SIUBISLD_MARK, PSD1_PSD0_FN2, PTZ0_FN),
};

static struct pinmux_gpio pinmux_gpios[] = {
	/* PTA */
	PINMUX_GPIO(GPIO_PTA7, PTA7_DATA),
	PINMUX_GPIO(GPIO_PTA6, PTA6_DATA),
	PINMUX_GPIO(GPIO_PTA5, PTA5_DATA),
	PINMUX_GPIO(GPIO_PTA4, PTA4_DATA),
	PINMUX_GPIO(GPIO_PTA3, PTA3_DATA),
	PINMUX_GPIO(GPIO_PTA2, PTA2_DATA),
	PINMUX_GPIO(GPIO_PTA1, PTA1_DATA),
	PINMUX_GPIO(GPIO_PTA0, PTA0_DATA),

	/* PTB */
	PINMUX_GPIO(GPIO_PTB7, PTB7_DATA),
	PINMUX_GPIO(GPIO_PTB6, PTB6_DATA),
	PINMUX_GPIO(GPIO_PTB5, PTB5_DATA),
	PINMUX_GPIO(GPIO_PTB4, PTB4_DATA),
	PINMUX_GPIO(GPIO_PTB3, PTB3_DATA),
	PINMUX_GPIO(GPIO_PTB2, PTB2_DATA),
	PINMUX_GPIO(GPIO_PTB1, PTB1_DATA),
	PINMUX_GPIO(GPIO_PTB0, PTB0_DATA),

	/* PTC */
	PINMUX_GPIO(GPIO_PTC7, PTC7_DATA),
	PINMUX_GPIO(GPIO_PTC6, PTC6_DATA),
	PINMUX_GPIO(GPIO_PTC5, PTC5_DATA),
	PINMUX_GPIO(GPIO_PTC4, PTC4_DATA),
	PINMUX_GPIO(GPIO_PTC3, PTC3_DATA),
	PINMUX_GPIO(GPIO_PTC2, PTC2_DATA),
	PINMUX_GPIO(GPIO_PTC1, PTC1_DATA),
	PINMUX_GPIO(GPIO_PTC0, PTC0_DATA),

	/* PTD */
	PINMUX_GPIO(GPIO_PTD7, PTD7_DATA),
	PINMUX_GPIO(GPIO_PTD6, PTD6_DATA),
	PINMUX_GPIO(GPIO_PTD5, PTD5_DATA),
	PINMUX_GPIO(GPIO_PTD4, PTD4_DATA),
	PINMUX_GPIO(GPIO_PTD3, PTD3_DATA),
	PINMUX_GPIO(GPIO_PTD2, PTD2_DATA),
	PINMUX_GPIO(GPIO_PTD1, PTD1_DATA),
	PINMUX_GPIO(GPIO_PTD0, PTD0_DATA),

	/* PTE */
	PINMUX_GPIO(GPIO_PTE5, PTE5_DATA),
	PINMUX_GPIO(GPIO_PTE4, PTE4_DATA),
	PINMUX_GPIO(GPIO_PTE3, PTE3_DATA),
	PINMUX_GPIO(GPIO_PTE2, PTE2_DATA),
	PINMUX_GPIO(GPIO_PTE1, PTE1_DATA),
	PINMUX_GPIO(GPIO_PTE0, PTE0_DATA),

	/* PTF */
	PINMUX_GPIO(GPIO_PTF7, PTF7_DATA),
	PINMUX_GPIO(GPIO_PTF6, PTF6_DATA),
	PINMUX_GPIO(GPIO_PTF5, PTF5_DATA),
	PINMUX_GPIO(GPIO_PTF4, PTF4_DATA),
	PINMUX_GPIO(GPIO_PTF3, PTF3_DATA),
	PINMUX_GPIO(GPIO_PTF2, PTF2_DATA),
	PINMUX_GPIO(GPIO_PTF1, PTF1_DATA),
	PINMUX_GPIO(GPIO_PTF0, PTF0_DATA),

	/* PTG */
	PINMUX_GPIO(GPIO_PTG5, PTG5_DATA),
	PINMUX_GPIO(GPIO_PTG4, PTG4_DATA),
	PINMUX_GPIO(GPIO_PTG3, PTG3_DATA),
	PINMUX_GPIO(GPIO_PTG2, PTG2_DATA),
	PINMUX_GPIO(GPIO_PTG1, PTG1_DATA),
	PINMUX_GPIO(GPIO_PTG0, PTG0_DATA),

	/* PTH */
	PINMUX_GPIO(GPIO_PTH7, PTH7_DATA),
	PINMUX_GPIO(GPIO_PTH6, PTH6_DATA),
	PINMUX_GPIO(GPIO_PTH5, PTH5_DATA),
	PINMUX_GPIO(GPIO_PTH4, PTH4_DATA),
	PINMUX_GPIO(GPIO_PTH3, PTH3_DATA),
	PINMUX_GPIO(GPIO_PTH2, PTH2_DATA),
	PINMUX_GPIO(GPIO_PTH1, PTH1_DATA),
	PINMUX_GPIO(GPIO_PTH0, PTH0_DATA),

	/* PTJ */
	PINMUX_GPIO(GPIO_PTJ7, PTJ7_DATA),
	PINMUX_GPIO(GPIO_PTJ5, PTJ5_DATA),
	PINMUX_GPIO(GPIO_PTJ3, PTJ3_DATA),
	PINMUX_GPIO(GPIO_PTJ2, PTJ2_DATA),
	PINMUX_GPIO(GPIO_PTJ1, PTJ1_DATA),
	PINMUX_GPIO(GPIO_PTJ0, PTJ0_DATA),

	/* PTK */
	PINMUX_GPIO(GPIO_PTK7, PTK7_DATA),
	PINMUX_GPIO(GPIO_PTK6, PTK6_DATA),
	PINMUX_GPIO(GPIO_PTK5, PTK5_DATA),
	PINMUX_GPIO(GPIO_PTK4, PTK4_DATA),
	PINMUX_GPIO(GPIO_PTK3, PTK3_DATA),
	PINMUX_GPIO(GPIO_PTK2, PTK2_DATA),
	PINMUX_GPIO(GPIO_PTK1, PTK1_DATA),
	PINMUX_GPIO(GPIO_PTK0, PTK0_DATA),

	/* PTL */
	PINMUX_GPIO(GPIO_PTL7, PTL7_DATA),
	PINMUX_GPIO(GPIO_PTL6, PTL6_DATA),
	PINMUX_GPIO(GPIO_PTL5, PTL5_DATA),
	PINMUX_GPIO(GPIO_PTL4, PTL4_DATA),
	PINMUX_GPIO(GPIO_PTL3, PTL3_DATA),
	PINMUX_GPIO(GPIO_PTL2, PTL2_DATA),
	PINMUX_GPIO(GPIO_PTL1, PTL1_DATA),
	PINMUX_GPIO(GPIO_PTL0, PTL0_DATA),

	/* PTM */
	PINMUX_GPIO(GPIO_PTM7, PTM7_DATA),
	PINMUX_GPIO(GPIO_PTM6, PTM6_DATA),
	PINMUX_GPIO(GPIO_PTM5, PTM5_DATA),
	PINMUX_GPIO(GPIO_PTM4, PTM4_DATA),
	PINMUX_GPIO(GPIO_PTM3, PTM3_DATA),
	PINMUX_GPIO(GPIO_PTM2, PTM2_DATA),
	PINMUX_GPIO(GPIO_PTM1, PTM1_DATA),
	PINMUX_GPIO(GPIO_PTM0, PTM0_DATA),

	/* PTN */
	PINMUX_GPIO(GPIO_PTN7, PTN7_DATA),
	PINMUX_GPIO(GPIO_PTN6, PTN6_DATA),
	PINMUX_GPIO(GPIO_PTN5, PTN5_DATA),
	PINMUX_GPIO(GPIO_PTN4, PTN4_DATA),
	PINMUX_GPIO(GPIO_PTN3, PTN3_DATA),
	PINMUX_GPIO(GPIO_PTN2, PTN2_DATA),
	PINMUX_GPIO(GPIO_PTN1, PTN1_DATA),
	PINMUX_GPIO(GPIO_PTN0, PTN0_DATA),

	/* PTQ */
	PINMUX_GPIO(GPIO_PTQ3, PTQ3_DATA),
	PINMUX_GPIO(GPIO_PTQ2, PTQ2_DATA),
	PINMUX_GPIO(GPIO_PTQ1, PTQ1_DATA),
	PINMUX_GPIO(GPIO_PTQ0, PTQ0_DATA),

	/* PTR */
	PINMUX_GPIO(GPIO_PTR7, PTR7_DATA),
	PINMUX_GPIO(GPIO_PTR6, PTR6_DATA),
	PINMUX_GPIO(GPIO_PTR5, PTR5_DATA),
	PINMUX_GPIO(GPIO_PTR4, PTR4_DATA),
	PINMUX_GPIO(GPIO_PTR3, PTR3_DATA),
	PINMUX_GPIO(GPIO_PTR2, PTR2_DATA),
	PINMUX_GPIO(GPIO_PTR1, PTR1_DATA),
	PINMUX_GPIO(GPIO_PTR0, PTR0_DATA),

	/* PTS */
	PINMUX_GPIO(GPIO_PTS7, PTS7_DATA),
	PINMUX_GPIO(GPIO_PTS6, PTS6_DATA),
	PINMUX_GPIO(GPIO_PTS5, PTS5_DATA),
	PINMUX_GPIO(GPIO_PTS4, PTS4_DATA),
	PINMUX_GPIO(GPIO_PTS3, PTS3_DATA),
	PINMUX_GPIO(GPIO_PTS2, PTS2_DATA),
	PINMUX_GPIO(GPIO_PTS1, PTS1_DATA),
	PINMUX_GPIO(GPIO_PTS0, PTS0_DATA),

	/* PTT */
	PINMUX_GPIO(GPIO_PTT5, PTT5_DATA),
	PINMUX_GPIO(GPIO_PTT4, PTT4_DATA),
	PINMUX_GPIO(GPIO_PTT3, PTT3_DATA),
	PINMUX_GPIO(GPIO_PTT2, PTT2_DATA),
	PINMUX_GPIO(GPIO_PTT1, PTT1_DATA),
	PINMUX_GPIO(GPIO_PTT0, PTT0_DATA),

	/* PTU */
	PINMUX_GPIO(GPIO_PTU5, PTU5_DATA),
	PINMUX_GPIO(GPIO_PTU4, PTU4_DATA),
	PINMUX_GPIO(GPIO_PTU3, PTU3_DATA),
	PINMUX_GPIO(GPIO_PTU2, PTU2_DATA),
	PINMUX_GPIO(GPIO_PTU1, PTU1_DATA),
	PINMUX_GPIO(GPIO_PTU0, PTU0_DATA),

	/* PTV */
	PINMUX_GPIO(GPIO_PTV7, PTV7_DATA),
	PINMUX_GPIO(GPIO_PTV6, PTV6_DATA),
	PINMUX_GPIO(GPIO_PTV5, PTV5_DATA),
	PINMUX_GPIO(GPIO_PTV4, PTV4_DATA),
	PINMUX_GPIO(GPIO_PTV3, PTV3_DATA),
	PINMUX_GPIO(GPIO_PTV2, PTV2_DATA),
	PINMUX_GPIO(GPIO_PTV1, PTV1_DATA),
	PINMUX_GPIO(GPIO_PTV0, PTV0_DATA),

	/* PTW */
	PINMUX_GPIO(GPIO_PTW7, PTW7_DATA),
	PINMUX_GPIO(GPIO_PTW6, PTW6_DATA),
	PINMUX_GPIO(GPIO_PTW5, PTW5_DATA),
	PINMUX_GPIO(GPIO_PTW4, PTW4_DATA),
	PINMUX_GPIO(GPIO_PTW3, PTW3_DATA),
	PINMUX_GPIO(GPIO_PTW2, PTW2_DATA),
	PINMUX_GPIO(GPIO_PTW1, PTW1_DATA),
	PINMUX_GPIO(GPIO_PTW0, PTW0_DATA),

	/* PTX */
	PINMUX_GPIO(GPIO_PTX7, PTX7_DATA),
	PINMUX_GPIO(GPIO_PTX6, PTX6_DATA),
	PINMUX_GPIO(GPIO_PTX5, PTX5_DATA),
	PINMUX_GPIO(GPIO_PTX4, PTX4_DATA),
	PINMUX_GPIO(GPIO_PTX3, PTX3_DATA),
	PINMUX_GPIO(GPIO_PTX2, PTX2_DATA),
	PINMUX_GPIO(GPIO_PTX1, PTX1_DATA),
	PINMUX_GPIO(GPIO_PTX0, PTX0_DATA),

	/* PTY */
	PINMUX_GPIO(GPIO_PTY7, PTY7_DATA),
	PINMUX_GPIO(GPIO_PTY6, PTY6_DATA),
	PINMUX_GPIO(GPIO_PTY5, PTY5_DATA),
	PINMUX_GPIO(GPIO_PTY4, PTY4_DATA),
	PINMUX_GPIO(GPIO_PTY3, PTY3_DATA),
	PINMUX_GPIO(GPIO_PTY2, PTY2_DATA),
	PINMUX_GPIO(GPIO_PTY1, PTY1_DATA),
	PINMUX_GPIO(GPIO_PTY0, PTY0_DATA),

	/* PTZ */
	PINMUX_GPIO(GPIO_PTZ7, PTZ7_DATA),
	PINMUX_GPIO(GPIO_PTZ6, PTZ6_DATA),
	PINMUX_GPIO(GPIO_PTZ5, PTZ5_DATA),
	PINMUX_GPIO(GPIO_PTZ4, PTZ4_DATA),
	PINMUX_GPIO(GPIO_PTZ3, PTZ3_DATA),
	PINMUX_GPIO(GPIO_PTZ2, PTZ2_DATA),
	PINMUX_GPIO(GPIO_PTZ1, PTZ1_DATA),
	PINMUX_GPIO(GPIO_PTZ0, PTZ0_DATA),

	/* SCIF0 */
	PINMUX_GPIO(GPIO_FN_SCIF0_PTT_TXD, SCIF0_PTT_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF0_PTT_RXD, SCIF0_PTT_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF0_PTT_SCK, SCIF0_PTT_SCK_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF0_PTU_TXD, SCIF0_PTU_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF0_PTU_RXD, SCIF0_PTU_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF0_PTU_SCK, SCIF0_PTU_SCK_MARK),

	/* SCIF1 */
	PINMUX_GPIO(GPIO_FN_SCIF1_PTS_TXD, SCIF1_PTS_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF1_PTS_RXD, SCIF1_PTS_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF1_PTS_SCK, SCIF1_PTS_SCK_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF1_PTV_TXD, SCIF1_PTV_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF1_PTV_RXD, SCIF1_PTV_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF1_PTV_SCK, SCIF1_PTV_SCK_MARK),

	/* SCIF2 */
	PINMUX_GPIO(GPIO_FN_SCIF2_PTT_TXD, SCIF2_PTT_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF2_PTT_RXD, SCIF2_PTT_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF2_PTT_SCK, SCIF2_PTT_SCK_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF2_PTU_TXD, SCIF2_PTU_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF2_PTU_RXD, SCIF2_PTU_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF2_PTU_SCK, SCIF2_PTU_SCK_MARK),

	/* SCIF3 */
	PINMUX_GPIO(GPIO_FN_SCIF3_PTS_TXD, SCIF3_PTS_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF3_PTS_RXD, SCIF3_PTS_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF3_PTS_SCK, SCIF3_PTS_SCK_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF3_PTS_RTS, SCIF3_PTS_RTS_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF3_PTS_CTS, SCIF3_PTS_CTS_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF3_PTV_TXD, SCIF3_PTV_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF3_PTV_RXD, SCIF3_PTV_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF3_PTV_SCK, SCIF3_PTV_SCK_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF3_PTV_RTS, SCIF3_PTV_RTS_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF3_PTV_CTS, SCIF3_PTV_CTS_MARK),

	/* SCIF4 */
	PINMUX_GPIO(GPIO_FN_SCIF4_PTE_TXD, SCIF4_PTE_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF4_PTE_RXD, SCIF4_PTE_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF4_PTE_SCK, SCIF4_PTE_SCK_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF4_PTN_TXD, SCIF4_PTN_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF4_PTN_RXD, SCIF4_PTN_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF4_PTN_SCK, SCIF4_PTN_SCK_MARK),

	/* SCIF5 */
	PINMUX_GPIO(GPIO_FN_SCIF5_PTE_TXD, SCIF5_PTE_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF5_PTE_RXD, SCIF5_PTE_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF5_PTE_SCK, SCIF5_PTE_SCK_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF5_PTN_TXD, SCIF5_PTN_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF5_PTN_RXD, SCIF5_PTN_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_SCIF5_PTN_SCK, SCIF5_PTN_SCK_MARK),

	/* CEU */
	PINMUX_GPIO(GPIO_FN_VIO_D15, VIO_D15_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D14, VIO_D14_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D13, VIO_D13_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D12, VIO_D12_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D11, VIO_D11_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D10, VIO_D10_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D9, VIO_D9_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D8, VIO_D8_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D7, VIO_D7_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D6, VIO_D6_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D5, VIO_D5_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D4, VIO_D4_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D3, VIO_D3_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D2, VIO_D2_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D1, VIO_D1_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_D0, VIO_D0_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_CLK1, VIO_CLK1_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_VD1, VIO_VD1_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_HD1, VIO_HD1_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_FLD, VIO_FLD_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_CKO, VIO_CKO_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_VD2, VIO_VD2_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_HD2, VIO_HD2_MARK),
	PINMUX_GPIO(GPIO_FN_VIO_CLK2, VIO_CLK2_MARK),

	/* LCDC */
	PINMUX_GPIO(GPIO_FN_LCDD23, LCDD23_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD22, LCDD22_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD21, LCDD21_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD20, LCDD20_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD19, LCDD19_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD18, LCDD18_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD17, LCDD17_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD16, LCDD16_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD15, LCDD15_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD14, LCDD14_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD13, LCDD13_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD12, LCDD12_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD11, LCDD11_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD10, LCDD10_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD9, LCDD9_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD8, LCDD8_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD7, LCDD7_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD6, LCDD6_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD5, LCDD5_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD4, LCDD4_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD3, LCDD3_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD2, LCDD2_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD1, LCDD1_MARK),
	PINMUX_GPIO(GPIO_FN_LCDD0, LCDD0_MARK),
	PINMUX_GPIO(GPIO_FN_LCDLCLK_PTR, LCDLCLK_PTR_MARK),
	PINMUX_GPIO(GPIO_FN_LCDLCLK_PTW, LCDLCLK_PTW_MARK),
	/* Main LCD */
	PINMUX_GPIO(GPIO_FN_LCDDON, LCDDON_MARK),
	PINMUX_GPIO(GPIO_FN_LCDVCPWC, LCDVCPWC_MARK),
	PINMUX_GPIO(GPIO_FN_LCDVEPWC, LCDVEPWC_MARK),
	PINMUX_GPIO(GPIO_FN_LCDVSYN, LCDVSYN_MARK),
	/* Main LCD - RGB Mode */
	PINMUX_GPIO(GPIO_FN_LCDDCK, LCDDCK_MARK),
	PINMUX_GPIO(GPIO_FN_LCDHSYN, LCDHSYN_MARK),
	PINMUX_GPIO(GPIO_FN_LCDDISP, LCDDISP_MARK),
	/* Main LCD - SYS Mode */
	PINMUX_GPIO(GPIO_FN_LCDRS, LCDRS_MARK),
	PINMUX_GPIO(GPIO_FN_LCDCS, LCDCS_MARK),
	PINMUX_GPIO(GPIO_FN_LCDWR, LCDWR_MARK),
	PINMUX_GPIO(GPIO_FN_LCDRD, LCDRD_MARK),

	/* IRQ */
	PINMUX_GPIO(GPIO_FN_IRQ0, IRQ0_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ1, IRQ1_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ2, IRQ2_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ3, IRQ3_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ4, IRQ4_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ5, IRQ5_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ6, IRQ6_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ7, IRQ7_MARK),

	/* AUD */
	PINMUX_GPIO(GPIO_FN_AUDCK, AUDCK_MARK),
	PINMUX_GPIO(GPIO_FN_AUDSYNC, AUDSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_AUDATA3, AUDATA3_MARK),
	PINMUX_GPIO(GPIO_FN_AUDATA2, AUDATA2_MARK),
	PINMUX_GPIO(GPIO_FN_AUDATA1, AUDATA1_MARK),
	PINMUX_GPIO(GPIO_FN_AUDATA0, AUDATA0_MARK),

	/* SDHI0 (PTD) */
	PINMUX_GPIO(GPIO_FN_SDHI0CD_PTD, SDHI0CD_PTD_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI0WP_PTD, SDHI0WP_PTD_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI0D3_PTD, SDHI0D3_PTD_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI0D2_PTD, SDHI0D2_PTD_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI0D1_PTD, SDHI0D1_PTD_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI0D0_PTD, SDHI0D0_PTD_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI0CMD_PTD, SDHI0CMD_PTD_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI0CLK_PTD, SDHI0CLK_PTD_MARK),

	/* SDHI0 (PTS) */
	PINMUX_GPIO(GPIO_FN_SDHI0CD_PTS, SDHI0CD_PTS_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI0WP_PTS, SDHI0WP_PTS_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI0D3_PTS, SDHI0D3_PTS_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI0D2_PTS, SDHI0D2_PTS_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI0D1_PTS, SDHI0D1_PTS_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI0D0_PTS, SDHI0D0_PTS_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI0CMD_PTS, SDHI0CMD_PTS_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI0CLK_PTS, SDHI0CLK_PTS_MARK),

	/* SDHI1 */
	PINMUX_GPIO(GPIO_FN_SDHI1CD, SDHI1CD_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI1WP, SDHI1WP_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI1D3, SDHI1D3_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI1D2, SDHI1D2_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI1D1, SDHI1D1_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI1D0, SDHI1D0_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI1CMD, SDHI1CMD_MARK),
	PINMUX_GPIO(GPIO_FN_SDHI1CLK, SDHI1CLK_MARK),

	/* SIUA */
	PINMUX_GPIO(GPIO_FN_SIUAFCK, SIUAFCK_MARK),
	PINMUX_GPIO(GPIO_FN_SIUAILR, SIUAILR_MARK),
	PINMUX_GPIO(GPIO_FN_SIUAIBT, SIUAIBT_MARK),
	PINMUX_GPIO(GPIO_FN_SIUAISLD, SIUAISLD_MARK),
	PINMUX_GPIO(GPIO_FN_SIUAOLR, SIUAOLR_MARK),
	PINMUX_GPIO(GPIO_FN_SIUAOBT, SIUAOBT_MARK),
	PINMUX_GPIO(GPIO_FN_SIUAOSLD, SIUAOSLD_MARK),
	PINMUX_GPIO(GPIO_FN_SIUAMCK, SIUAMCK_MARK),
	PINMUX_GPIO(GPIO_FN_SIUAISPD, SIUAISPD_MARK),
	PINMUX_GPIO(GPIO_FN_SIUAOSPD, SIUAOSPD_MARK),

	/* SIUB */
	PINMUX_GPIO(GPIO_FN_SIUBFCK, SIUBFCK_MARK),
	PINMUX_GPIO(GPIO_FN_SIUBILR, SIUBILR_MARK),
	PINMUX_GPIO(GPIO_FN_SIUBIBT, SIUBIBT_MARK),
	PINMUX_GPIO(GPIO_FN_SIUBISLD, SIUBISLD_MARK),
	PINMUX_GPIO(GPIO_FN_SIUBOLR, SIUBOLR_MARK),
	PINMUX_GPIO(GPIO_FN_SIUBOBT, SIUBOBT_MARK),
	PINMUX_GPIO(GPIO_FN_SIUBOSLD, SIUBOSLD_MARK),
	PINMUX_GPIO(GPIO_FN_SIUBMCK, SIUBMCK_MARK),

	/* IRDA */
	PINMUX_GPIO(GPIO_FN_IRDA_IN, IRDA_IN_MARK),
	PINMUX_GPIO(GPIO_FN_IRDA_OUT, IRDA_OUT_MARK),

	/* VOU */
	PINMUX_GPIO(GPIO_FN_DV_CLKI, DV_CLKI_MARK),
	PINMUX_GPIO(GPIO_FN_DV_CLK, DV_CLK_MARK),
	PINMUX_GPIO(GPIO_FN_DV_HSYNC, DV_HSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_DV_VSYNC, DV_VSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D15, DV_D15_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D14, DV_D14_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D13, DV_D13_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D12, DV_D12_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D11, DV_D11_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D10, DV_D10_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D9, DV_D9_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D8, DV_D8_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D7, DV_D7_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D6, DV_D6_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D5, DV_D5_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D4, DV_D4_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D3, DV_D3_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D2, DV_D2_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D1, DV_D1_MARK),
	PINMUX_GPIO(GPIO_FN_DV_D0, DV_D0_MARK),

	/* KEYSC */
	PINMUX_GPIO(GPIO_FN_KEYIN0, KEYIN0_MARK),
	PINMUX_GPIO(GPIO_FN_KEYIN1, KEYIN1_MARK),
	PINMUX_GPIO(GPIO_FN_KEYIN2, KEYIN2_MARK),
	PINMUX_GPIO(GPIO_FN_KEYIN3, KEYIN3_MARK),
	PINMUX_GPIO(GPIO_FN_KEYIN4, KEYIN4_MARK),
	PINMUX_GPIO(GPIO_FN_KEYOUT0, KEYOUT0_MARK),
	PINMUX_GPIO(GPIO_FN_KEYOUT1, KEYOUT1_MARK),
	PINMUX_GPIO(GPIO_FN_KEYOUT2, KEYOUT2_MARK),
	PINMUX_GPIO(GPIO_FN_KEYOUT3, KEYOUT3_MARK),
	PINMUX_GPIO(GPIO_FN_KEYOUT4_IN6, KEYOUT4_IN6_MARK),
	PINMUX_GPIO(GPIO_FN_KEYOUT5_IN5, KEYOUT5_IN5_MARK),

	/* MSIOF0 (PTF) */
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTF_TXD, MSIOF0_PTF_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTF_RXD, MSIOF0_PTF_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTF_MCK, MSIOF0_PTF_MCK_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTF_TSYNC, MSIOF0_PTF_TSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTF_TSCK, MSIOF0_PTF_TSCK_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTF_RSYNC, MSIOF0_PTF_RSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTF_RSCK, MSIOF0_PTF_RSCK_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTF_SS1, MSIOF0_PTF_SS1_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTF_SS2, MSIOF0_PTF_SS2_MARK),

	/* MSIOF0 (PTT+PTX) */
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTT_TXD, MSIOF0_PTT_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTT_RXD, MSIOF0_PTT_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTX_MCK, MSIOF0_PTX_MCK_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTT_TSYNC, MSIOF0_PTT_TSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTT_TSCK, MSIOF0_PTT_TSCK_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTT_RSYNC, MSIOF0_PTT_RSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTT_RSCK, MSIOF0_PTT_RSCK_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTT_SS1, MSIOF0_PTT_SS1_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF0_PTT_SS2, MSIOF0_PTT_SS2_MARK),

	/* MSIOF1 */
	PINMUX_GPIO(GPIO_FN_MSIOF1_TXD, MSIOF1_TXD_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF1_RXD, MSIOF1_RXD_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF1_MCK, MSIOF1_MCK_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF1_TSYNC, MSIOF1_TSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF1_TSCK, MSIOF1_TSCK_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF1_RSYNC, MSIOF1_RSYNC_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF1_RSCK, MSIOF1_RSCK_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF1_SS1, MSIOF1_SS1_MARK),
	PINMUX_GPIO(GPIO_FN_MSIOF1_SS2, MSIOF1_SS2_MARK),

	/* TSIF */
	PINMUX_GPIO(GPIO_FN_TS0_SDAT, TS0_SDAT_MARK),
	PINMUX_GPIO(GPIO_FN_TS0_SCK, TS0_SCK_MARK),
	PINMUX_GPIO(GPIO_FN_TS0_SDEN, TS0_SDEN_MARK),
	PINMUX_GPIO(GPIO_FN_TS0_SPSYNC, TS0_SPSYNC_MARK),

	/* FLCTL */
	PINMUX_GPIO(GPIO_FN_FCE, FCE_MARK),
	PINMUX_GPIO(GPIO_FN_NAF7, NAF7_MARK),
	PINMUX_GPIO(GPIO_FN_NAF6, NAF6_MARK),
	PINMUX_GPIO(GPIO_FN_NAF5, NAF5_MARK),
	PINMUX_GPIO(GPIO_FN_NAF4, NAF4_MARK),
	PINMUX_GPIO(GPIO_FN_NAF3, NAF3_MARK),
	PINMUX_GPIO(GPIO_FN_NAF2, NAF2_MARK),
	PINMUX_GPIO(GPIO_FN_NAF1, NAF1_MARK),
	PINMUX_GPIO(GPIO_FN_NAF0, NAF0_MARK),
	PINMUX_GPIO(GPIO_FN_FCDE, FCDE_MARK),
	PINMUX_GPIO(GPIO_FN_FOE, FOE_MARK),
	PINMUX_GPIO(GPIO_FN_FSC, FSC_MARK),
	PINMUX_GPIO(GPIO_FN_FWE, FWE_MARK),
	PINMUX_GPIO(GPIO_FN_FRB, FRB_MARK),

	/* DMAC */
	PINMUX_GPIO(GPIO_FN_DACK1, DACK1_MARK),
	PINMUX_GPIO(GPIO_FN_DREQ1, DREQ1_MARK),
	PINMUX_GPIO(GPIO_FN_DACK0, DACK0_MARK),
	PINMUX_GPIO(GPIO_FN_DREQ0, DREQ0_MARK),

	/* ADC */
	PINMUX_GPIO(GPIO_FN_AN3, AN3_MARK),
	PINMUX_GPIO(GPIO_FN_AN2, AN2_MARK),
	PINMUX_GPIO(GPIO_FN_AN1, AN1_MARK),
	PINMUX_GPIO(GPIO_FN_AN0, AN0_MARK),
	PINMUX_GPIO(GPIO_FN_ADTRG, ADTRG_MARK),

	/* CPG */
	PINMUX_GPIO(GPIO_FN_STATUS0, STATUS0_MARK),
	PINMUX_GPIO(GPIO_FN_PDSTATUS, PDSTATUS_MARK),

	/* TPU */
	PINMUX_GPIO(GPIO_FN_TPUTO0, TPUTO0_MARK),
	PINMUX_GPIO(GPIO_FN_TPUTO1, TPUTO1_MARK),
	PINMUX_GPIO(GPIO_FN_TPUTO2, TPUTO2_MARK),
	PINMUX_GPIO(GPIO_FN_TPUTO3, TPUTO3_MARK),

	/* BSC */
	PINMUX_GPIO(GPIO_FN_D31, D31_MARK),
	PINMUX_GPIO(GPIO_FN_D30, D30_MARK),
	PINMUX_GPIO(GPIO_FN_D29, D29_MARK),
	PINMUX_GPIO(GPIO_FN_D28, D28_MARK),
	PINMUX_GPIO(GPIO_FN_D27, D27_MARK),
	PINMUX_GPIO(GPIO_FN_D26, D26_MARK),
	PINMUX_GPIO(GPIO_FN_D25, D25_MARK),
	PINMUX_GPIO(GPIO_FN_D24, D24_MARK),
	PINMUX_GPIO(GPIO_FN_D23, D23_MARK),
	PINMUX_GPIO(GPIO_FN_D22, D22_MARK),
	PINMUX_GPIO(GPIO_FN_D21, D21_MARK),
	PINMUX_GPIO(GPIO_FN_D20, D20_MARK),
	PINMUX_GPIO(GPIO_FN_D19, D19_MARK),
	PINMUX_GPIO(GPIO_FN_D18, D18_MARK),
	PINMUX_GPIO(GPIO_FN_D17, D17_MARK),
	PINMUX_GPIO(GPIO_FN_D16, D16_MARK),
	PINMUX_GPIO(GPIO_FN_IOIS16, IOIS16_MARK),
	PINMUX_GPIO(GPIO_FN_WAIT, WAIT_MARK),
	PINMUX_GPIO(GPIO_FN_BS, BS_MARK),
	PINMUX_GPIO(GPIO_FN_A25, A25_MARK),
	PINMUX_GPIO(GPIO_FN_A24, A24_MARK),
	PINMUX_GPIO(GPIO_FN_A23, A23_MARK),
	PINMUX_GPIO(GPIO_FN_A22, A22_MARK),
	PINMUX_GPIO(GPIO_FN_CS6B_CE1B, CS6B_CE1B_MARK),
	PINMUX_GPIO(GPIO_FN_CS6A_CE2B, CS6A_CE2B_MARK),
	PINMUX_GPIO(GPIO_FN_CS5B_CE1A, CS5B_CE1A_MARK),
	PINMUX_GPIO(GPIO_FN_CS5A_CE2A, CS5A_CE2A_MARK),
	PINMUX_GPIO(GPIO_FN_WE3_ICIOWR, WE3_ICIOWR_MARK),
	PINMUX_GPIO(GPIO_FN_WE2_ICIORD, WE2_ICIORD_MARK),

	/* ATAPI */
	PINMUX_GPIO(GPIO_FN_IDED15, IDED15_MARK),
	PINMUX_GPIO(GPIO_FN_IDED14, IDED14_MARK),
	PINMUX_GPIO(GPIO_FN_IDED13, IDED13_MARK),
	PINMUX_GPIO(GPIO_FN_IDED12, IDED12_MARK),
	PINMUX_GPIO(GPIO_FN_IDED11, IDED11_MARK),
	PINMUX_GPIO(GPIO_FN_IDED10, IDED10_MARK),
	PINMUX_GPIO(GPIO_FN_IDED9, IDED9_MARK),
	PINMUX_GPIO(GPIO_FN_IDED8, IDED8_MARK),
	PINMUX_GPIO(GPIO_FN_IDED7, IDED7_MARK),
	PINMUX_GPIO(GPIO_FN_IDED6, IDED6_MARK),
	PINMUX_GPIO(GPIO_FN_IDED5, IDED5_MARK),
	PINMUX_GPIO(GPIO_FN_IDED4, IDED4_MARK),
	PINMUX_GPIO(GPIO_FN_IDED3, IDED3_MARK),
	PINMUX_GPIO(GPIO_FN_IDED2, IDED2_MARK),
	PINMUX_GPIO(GPIO_FN_IDED1, IDED1_MARK),
	PINMUX_GPIO(GPIO_FN_IDED0, IDED0_MARK),
	PINMUX_GPIO(GPIO_FN_DIRECTION, DIRECTION_MARK),
	PINMUX_GPIO(GPIO_FN_EXBUF_ENB, EXBUF_ENB_MARK),
	PINMUX_GPIO(GPIO_FN_IDERST, IDERST_MARK),
	PINMUX_GPIO(GPIO_FN_IODACK, IODACK_MARK),
	PINMUX_GPIO(GPIO_FN_IODREQ, IODREQ_MARK),
	PINMUX_GPIO(GPIO_FN_IDEIORDY, IDEIORDY_MARK),
	PINMUX_GPIO(GPIO_FN_IDEINT, IDEINT_MARK),
	PINMUX_GPIO(GPIO_FN_IDEIOWR, IDEIOWR_MARK),
	PINMUX_GPIO(GPIO_FN_IDEIORD, IDEIORD_MARK),
	PINMUX_GPIO(GPIO_FN_IDECS1, IDECS1_MARK),
	PINMUX_GPIO(GPIO_FN_IDECS0, IDECS0_MARK),
	PINMUX_GPIO(GPIO_FN_IDEA2, IDEA2_MARK),
	PINMUX_GPIO(GPIO_FN_IDEA1, IDEA1_MARK),
	PINMUX_GPIO(GPIO_FN_IDEA0, IDEA0_MARK),
};

static struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("PACR", 0xa4050100, 16, 2) {
		PTA7_FN, PTA7_OUT, 0, PTA7_IN,
		PTA6_FN, PTA6_OUT, 0, PTA6_IN,
		PTA5_FN, PTA5_OUT, 0, PTA5_IN,
		PTA4_FN, PTA4_OUT, PTA4_IN_PU, PTA4_IN,
		PTA3_FN, PTA3_OUT, PTA3_IN_PU, PTA3_IN,
		PTA2_FN, PTA2_OUT, PTA2_IN_PU, PTA2_IN,
		PTA1_FN, PTA1_OUT, PTA1_IN_PU, PTA1_IN,
		PTA0_FN, PTA0_OUT, PTA0_IN_PU, PTA0_IN }
	},
	{ PINMUX_CFG_REG("PBCR", 0xa4050102, 16, 2) {
		PTB7_FN, PTB7_OUT, 0, PTB7_IN,
		PTB6_FN, PTB6_OUT, 0, PTB6_IN,
		PTB5_FN, PTB5_OUT, 0, PTB5_IN,
		PTB4_FN, PTB4_OUT, 0, PTB4_IN,
		PTB3_FN, PTB3_OUT, 0, PTB3_IN,
		PTB2_FN, PTB2_OUT, PTB2_IN_PU, PTB2_IN,
		PTB1_FN, PTB1_OUT, PTB1_IN_PU, PTB1_IN,
		PTB0_FN, PTB0_OUT, 0, PTB0_IN }
	},
	{ PINMUX_CFG_REG("PCCR", 0xa4050104, 16, 2) {
		PTC7_FN, PTC7_OUT, 0, PTC7_IN,
		PTC6_FN, PTC6_OUT, 0, PTC6_IN,
		PTC5_FN, PTC5_OUT, 0, PTC5_IN,
		PTC4_FN, PTC4_OUT, 0, PTC4_IN,
		PTC3_FN, PTC3_OUT, 0, PTC3_IN,
		PTC2_FN, PTC2_OUT, 0, PTC2_IN,
		PTC1_FN, PTC1_OUT, 0, PTC1_IN,
		PTC0_FN, PTC0_OUT, 0, PTC0_IN }
	},
	{ PINMUX_CFG_REG("PDCR", 0xa4050106, 16, 2) {
		PTD7_FN, PTD7_OUT, 0, PTD7_IN,
		PTD6_FN, PTD6_OUT, 0, PTD6_IN,
		PTD5_FN, PTD5_OUT, 0, PTD5_IN,
		PTD4_FN, PTD4_OUT, 0, PTD4_IN,
		PTD3_FN, PTD3_OUT, 0, PTD3_IN,
		PTD2_FN, PTD2_OUT, 0, PTD2_IN,
		PTD1_FN, PTD1_OUT, 0, PTD1_IN,
		PTD0_FN, PTD0_OUT, 0, PTD0_IN }
	},
	{ PINMUX_CFG_REG("PECR", 0xa4050108, 16, 2) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		PTE5_FN, PTE5_OUT, 0, PTE5_IN,
		PTE4_FN, PTE4_OUT, 0, PTE4_IN,
		PTE3_FN, PTE3_OUT, 0, PTE3_IN,
		PTE2_FN, PTE2_OUT, 0, PTE2_IN,
		PTE1_FN, PTE1_OUT, 0, PTE1_IN,
		PTE0_FN, PTE0_OUT, 0, PTE0_IN }
	},
	{ PINMUX_CFG_REG("PFCR", 0xa405010a, 16, 2) {
		PTF7_FN, PTF7_OUT, 0, PTF7_IN,
		PTF6_FN, PTF6_OUT, 0, PTF6_IN,
		PTF5_FN, PTF5_OUT, 0, PTF5_IN,
		PTF4_FN, PTF4_OUT, 0, PTF4_IN,
		PTF3_FN, PTF3_OUT, 0, PTF3_IN,
		PTF2_FN, PTF2_OUT, 0, PTF2_IN,
		PTF1_FN, PTF1_OUT, 0, PTF1_IN,
		PTF0_FN, PTF0_OUT, 0, PTF0_IN }
	},
	{ PINMUX_CFG_REG("PGCR", 0xa405010c, 16, 2) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		PTG5_FN, PTG5_OUT, 0, 0,
		PTG4_FN, PTG4_OUT, 0, 0,
		PTG3_FN, PTG3_OUT, 0, 0,
		PTG2_FN, PTG2_OUT, 0, 0,
		PTG1_FN, PTG1_OUT, 0, 0,
		PTG0_FN, PTG0_OUT, 0, 0 }
	},
	{ PINMUX_CFG_REG("PHCR", 0xa405010e, 16, 2) {
		PTH7_FN, PTH7_OUT, 0, PTH7_IN,
		PTH6_FN, PTH6_OUT, 0, PTH6_IN,
		PTH5_FN, PTH5_OUT, 0, PTH5_IN,
		PTH4_FN, PTH4_OUT, 0, PTH4_IN,
		PTH3_FN, PTH3_OUT, 0, PTH3_IN,
		PTH2_FN, PTH2_OUT, 0, PTH2_IN,
		PTH1_FN, PTH1_OUT, 0, PTH1_IN,
		PTH0_FN, PTH0_OUT, 0, PTH0_IN }
	},
	{ PINMUX_CFG_REG("PJCR", 0xa4050110, 16, 2) {
		PTJ7_FN, PTJ7_OUT, 0, 0,
		0, 0, 0, 0,
		PTJ5_FN, PTJ5_OUT, 0, 0,
		0, 0, 0, 0,
		PTJ3_FN, PTJ3_OUT, 0, PTJ3_IN,
		PTJ2_FN, PTJ2_OUT, 0, PTJ2_IN,
		PTJ1_FN, PTJ1_OUT, 0, PTJ1_IN,
		PTJ0_FN, PTJ0_OUT, 0, PTJ0_IN }
	},
	{ PINMUX_CFG_REG("PKCR", 0xa4050112, 16, 2) {
		PTK7_FN, PTK7_OUT, 0, PTK7_IN,
		PTK6_FN, PTK6_OUT, 0, PTK6_IN,
		PTK5_FN, PTK5_OUT, 0, PTK5_IN,
		PTK4_FN, PTK4_OUT, 0, PTK4_IN,
		PTK3_FN, PTK3_OUT, 0, PTK3_IN,
		PTK2_FN, PTK2_OUT, 0, PTK2_IN,
		PTK1_FN, PTK1_OUT, 0, PTK1_IN,
		PTK0_FN, PTK0_OUT, 0, PTK0_IN }
	},
	{ PINMUX_CFG_REG("PLCR", 0xa4050114, 16, 2) {
		PTL7_FN, PTL7_OUT, 0, PTL7_IN,
		PTL6_FN, PTL6_OUT, 0, PTL6_IN,
		PTL5_FN, PTL5_OUT, 0, PTL5_IN,
		PTL4_FN, PTL4_OUT, 0, PTL4_IN,
		PTL3_FN, PTL3_OUT, 0, PTL3_IN,
		PTL2_FN, PTL2_OUT, 0, PTL2_IN,
		PTL1_FN, PTL1_OUT, 0, PTL1_IN,
		PTL0_FN, PTL0_OUT, 0, PTL0_IN }
	},
	{ PINMUX_CFG_REG("PMCR", 0xa4050116, 16, 2) {
		PTM7_FN, PTM7_OUT, 0, PTM7_IN,
		PTM6_FN, PTM6_OUT, 0, PTM6_IN,
		PTM5_FN, PTM5_OUT, 0, PTM5_IN,
		PTM4_FN, PTM4_OUT, 0, PTM4_IN,
		PTM3_FN, PTM3_OUT, 0, PTM3_IN,
		PTM2_FN, PTM2_OUT, 0, PTM2_IN,
		PTM1_FN, PTM1_OUT, 0, PTM1_IN,
		PTM0_FN, PTM0_OUT, 0, PTM0_IN }
	},
	{ PINMUX_CFG_REG("PNCR", 0xa4050118, 16, 2) {
		PTN7_FN, PTN7_OUT, 0, PTN7_IN,
		PTN6_FN, PTN6_OUT, 0, PTN6_IN,
		PTN5_FN, PTN5_OUT, 0, PTN5_IN,
		PTN4_FN, PTN4_OUT, 0, PTN4_IN,
		PTN3_FN, PTN3_OUT, 0, PTN3_IN,
		PTN2_FN, PTN2_OUT, 0, PTN2_IN,
		PTN1_FN, PTN1_OUT, 0, PTN1_IN,
		PTN0_FN, PTN0_OUT, 0, PTN0_IN }
	},
	{ PINMUX_CFG_REG("PQCR", 0xa405011a, 16, 2) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		PTQ3_FN, 0, 0, PTQ3_IN,
		PTQ2_FN, 0, 0, PTQ2_IN,
		PTQ1_FN, 0, 0, PTQ1_IN,
		PTQ0_FN, 0, 0, PTQ0_IN }
	},
	{ PINMUX_CFG_REG("PRCR", 0xa405011c, 16, 2) {
		PTR7_FN, PTR7_OUT, 0, PTR7_IN,
		PTR6_FN, PTR6_OUT, 0, PTR6_IN,
		PTR5_FN, PTR5_OUT, 0, PTR5_IN,
		PTR4_FN, PTR4_OUT, 0, PTR4_IN,
		PTR3_FN, 0, 0, PTR3_IN,
		PTR2_FN, 0, PTR2_IN_PU, PTR2_IN,
		PTR1_FN, PTR1_OUT, 0, PTR1_IN,
		PTR0_FN, PTR0_OUT, 0, PTR0_IN }
	},
	{ PINMUX_CFG_REG("PSCR", 0xa405011e, 16, 2) {
		PTS7_FN, PTS7_OUT, 0, PTS7_IN,
		PTS6_FN, PTS6_OUT, 0, PTS6_IN,
		PTS5_FN, PTS5_OUT, 0, PTS5_IN,
		PTS4_FN, PTS4_OUT, 0, PTS4_IN,
		PTS3_FN, PTS3_OUT, 0, PTS3_IN,
		PTS2_FN, PTS2_OUT, 0, PTS2_IN,
		PTS1_FN, PTS1_OUT, 0, PTS1_IN,
		PTS0_FN, PTS0_OUT, 0, PTS0_IN }
	},
	{ PINMUX_CFG_REG("PTCR", 0xa4050140, 16, 2) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		PTT5_FN, PTT5_OUT, 0, PTT5_IN,
		PTT4_FN, PTT4_OUT, 0, PTT4_IN,
		PTT3_FN, PTT3_OUT, 0, PTT3_IN,
		PTT2_FN, PTT2_OUT, 0, PTT2_IN,
		PTT1_FN, PTT1_OUT, 0, PTT1_IN,
		PTT0_FN, PTT0_OUT, 0, PTT0_IN }
	},
	{ PINMUX_CFG_REG("PUCR", 0xa4050142, 16, 2) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		PTU5_FN, PTU5_OUT, 0, PTU5_IN,
		PTU4_FN, PTU4_OUT, 0, PTU4_IN,
		PTU3_FN, PTU3_OUT, 0, PTU3_IN,
		PTU2_FN, PTU2_OUT, 0, PTU2_IN,
		PTU1_FN, PTU1_OUT, 0, PTU1_IN,
		PTU0_FN, PTU0_OUT, 0, PTU0_IN }
	},
	{ PINMUX_CFG_REG("PVCR", 0xa4050144, 16, 2) {
		PTV7_FN, PTV7_OUT, 0, PTV7_IN,
		PTV6_FN, PTV6_OUT, 0, PTV6_IN,
		PTV5_FN, PTV5_OUT, 0, PTV5_IN,
		PTV4_FN, PTV4_OUT, 0, PTV4_IN,
		PTV3_FN, PTV3_OUT, 0, PTV3_IN,
		PTV2_FN, PTV2_OUT, 0, PTV2_IN,
		PTV1_FN, PTV1_OUT, 0, PTV1_IN,
		PTV0_FN, PTV0_OUT, 0, PTV0_IN }
	},
	{ PINMUX_CFG_REG("PWCR", 0xa4050146, 16, 2) {
		PTW7_FN, PTW7_OUT, 0, PTW7_IN,
		PTW6_FN, PTW6_OUT, 0, PTW6_IN,
		PTW5_FN, PTW5_OUT, 0, PTW5_IN,
		PTW4_FN, PTW4_OUT, 0, PTW4_IN,
		PTW3_FN, PTW3_OUT, 0, PTW3_IN,
		PTW2_FN, PTW2_OUT, 0, PTW2_IN,
		PTW1_FN, PTW1_OUT, 0, PTW1_IN,
		PTW0_FN, PTW0_OUT, 0, PTW0_IN }
	},
	{ PINMUX_CFG_REG("PXCR", 0xa4050148, 16, 2) {
		PTX7_FN, PTX7_OUT, 0, PTX7_IN,
		PTX6_FN, PTX6_OUT, 0, PTX6_IN,
		PTX5_FN, PTX5_OUT, 0, PTX5_IN,
		PTX4_FN, PTX4_OUT, 0, PTX4_IN,
		PTX3_FN, PTX3_OUT, 0, PTX3_IN,
		PTX2_FN, PTX2_OUT, 0, PTX2_IN,
		PTX1_FN, PTX1_OUT, 0, PTX1_IN,
		PTX0_FN, PTX0_OUT, 0, PTX0_IN }
	},
	{ PINMUX_CFG_REG("PYCR", 0xa405014a, 16, 2) {
		PTY7_FN, PTY7_OUT, 0, PTY7_IN,
		PTY6_FN, PTY6_OUT, 0, PTY6_IN,
		PTY5_FN, PTY5_OUT, 0, PTY5_IN,
		PTY4_FN, PTY4_OUT, 0, PTY4_IN,
		PTY3_FN, PTY3_OUT, 0, PTY3_IN,
		PTY2_FN, PTY2_OUT, 0, PTY2_IN,
		PTY1_FN, PTY1_OUT, 0, PTY1_IN,
		PTY0_FN, PTY0_OUT, 0, PTY0_IN }
	},
	{ PINMUX_CFG_REG("PZCR", 0xa405014c, 16, 2) {
		PTZ7_FN, PTZ7_OUT, 0, PTZ7_IN,
		PTZ6_FN, PTZ6_OUT, 0, PTZ6_IN,
		PTZ5_FN, PTZ5_OUT, 0, PTZ5_IN,
		PTZ4_FN, PTZ4_OUT, 0, PTZ4_IN,
		PTZ3_FN, PTZ3_OUT, 0, PTZ3_IN,
		PTZ2_FN, PTZ2_OUT, 0, PTZ2_IN,
		PTZ1_FN, PTZ1_OUT, 0, PTZ1_IN,
		PTZ0_FN, PTZ0_OUT, 0, PTZ0_IN }
	},
	{ PINMUX_CFG_REG("PSELA", 0xa405014e, 16, 2) {
		PSA15_PSA14_FN1, PSA15_PSA14_FN2, 0, 0,
		PSA13_PSA12_FN1, PSA13_PSA12_FN2, 0, 0,
		PSA11_PSA10_FN1, PSA11_PSA10_FN2, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		PSA5_PSA4_FN1, PSA5_PSA4_FN2, PSA5_PSA4_FN3, 0,
		PSA3_PSA2_FN1, PSA3_PSA2_FN2, 0, 0,
		0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PSELB", 0xa4050150, 16, 2) {
		PSB15_PSB14_FN1, PSB15_PSB14_FN2, 0, 0,
		PSB13_PSB12_LCDC_RGB, PSB13_PSB12_LCDC_SYS, 0, 0,
		0, 0, 0, 0,
		PSB9_PSB8_FN1, PSB9_PSB8_FN2, PSB9_PSB8_FN3, 0,
		PSB7_PSB6_FN1, PSB7_PSB6_FN2, 0, 0,
		PSB5_PSB4_FN1, PSB5_PSB4_FN2, 0, 0,
		PSB3_PSB2_FN1, PSB3_PSB2_FN2, 0, 0,
		0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PSELC", 0xa4050152, 16, 2) {
		PSC15_PSC14_FN1, PSC15_PSC14_FN2, 0, 0,
		PSC13_PSC12_FN1, PSC13_PSC12_FN2, 0, 0,
		PSC11_PSC10_FN1, PSC11_PSC10_FN2, PSC11_PSC10_FN3, 0,
		PSC9_PSC8_FN1, PSC9_PSC8_FN2, 0, 0,
		PSC7_PSC6_FN1, PSC7_PSC6_FN2, PSC7_PSC6_FN3, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PSELD", 0xa4050154, 16, 2) {
		PSD15_PSD14_FN1, PSD15_PSD14_FN2, 0, 0,
		PSD13_PSD12_FN1, PSD13_PSD12_FN2, 0, 0,
		PSD11_PSD10_FN1, PSD11_PSD10_FN2, PSD11_PSD10_FN3, 0,
		PSD9_PSD8_FN1, PSD9_PSD8_FN2, 0, 0,
		PSD7_PSD6_FN1, PSD7_PSD6_FN2, 0, 0,
		PSD5_PSD4_FN1, PSD5_PSD4_FN2, 0, 0,
		PSD3_PSD2_FN1, PSD3_PSD2_FN2, 0, 0,
		PSD1_PSD0_FN1, PSD1_PSD0_FN2, 0, 0 }
	},
	{}
};

static struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PADR", 0xa4050120, 8) {
		PTA7_DATA, PTA6_DATA, PTA5_DATA, PTA4_DATA,
		PTA3_DATA, PTA2_DATA, PTA1_DATA, PTA0_DATA }
	},
	{ PINMUX_DATA_REG("PBDR", 0xa4050122, 8) {
		PTB7_DATA, PTB6_DATA, PTB5_DATA, PTB4_DATA,
		PTB3_DATA, PTB2_DATA, PTB1_DATA, PTB0_DATA }
	},
	{ PINMUX_DATA_REG("PCDR", 0xa4050124, 8) {
		PTC7_DATA, PTC6_DATA, PTC5_DATA, PTC4_DATA,
		PTC3_DATA, PTC2_DATA, PTC1_DATA, PTC0_DATA }
	},
	{ PINMUX_DATA_REG("PDDR", 0xa4050126, 8) {
		PTD7_DATA, PTD6_DATA, PTD5_DATA, PTD4_DATA,
		PTD3_DATA, PTD2_DATA, PTD1_DATA, PTD0_DATA }
	},
	{ PINMUX_DATA_REG("PEDR", 0xa4050128, 8) {
		0, 0, PTE5_DATA, PTE4_DATA,
		PTE3_DATA, PTE2_DATA, PTE1_DATA, PTE0_DATA }
	},
	{ PINMUX_DATA_REG("PFDR", 0xa405012a, 8) {
		PTF7_DATA, PTF6_DATA, PTF5_DATA, PTF4_DATA,
		PTF3_DATA, PTF2_DATA, PTF1_DATA, PTF0_DATA }
	},
	{ PINMUX_DATA_REG("PGDR", 0xa405012c, 8) {
		0, 0, PTG5_DATA, PTG4_DATA,
		PTG3_DATA, PTG2_DATA, PTG1_DATA, PTG0_DATA }
	},
	{ PINMUX_DATA_REG("PHDR", 0xa405012e, 8) {
		PTH7_DATA, PTH6_DATA, PTH5_DATA, PTH4_DATA,
		PTH3_DATA, PTH2_DATA, PTH1_DATA, PTH0_DATA }
	},
	{ PINMUX_DATA_REG("PJDR", 0xa4050130, 8) {
		PTJ7_DATA, 0, PTJ5_DATA, 0,
		PTJ3_DATA, PTJ2_DATA, PTJ1_DATA, PTJ0_DATA }
	},
	{ PINMUX_DATA_REG("PKDR", 0xa4050132, 8) {
		PTK7_DATA, PTK6_DATA, PTK5_DATA, PTK4_DATA,
		PTK3_DATA, PTK2_DATA, PTK1_DATA, PTK0_DATA }
	},
	{ PINMUX_DATA_REG("PLDR", 0xa4050134, 8) {
		PTL7_DATA, PTL6_DATA, PTL5_DATA, PTL4_DATA,
		PTL3_DATA, PTL2_DATA, PTL1_DATA, PTL0_DATA }
	},
	{ PINMUX_DATA_REG("PMDR", 0xa4050136, 8) {
		PTM7_DATA, PTM6_DATA, PTM5_DATA, PTM4_DATA,
		PTM3_DATA, PTM2_DATA, PTM1_DATA, PTM0_DATA }
	},
	{ PINMUX_DATA_REG("PNDR", 0xa4050138, 8) {
		PTN7_DATA, PTN6_DATA, PTN5_DATA, PTN4_DATA,
		PTN3_DATA, PTN2_DATA, PTN1_DATA, PTN0_DATA }
	},
	{ PINMUX_DATA_REG("PQDR", 0xa405013a, 8) {
		0, 0, 0, 0,
		PTQ3_DATA, PTQ2_DATA, PTQ1_DATA, PTQ0_DATA }
	},
	{ PINMUX_DATA_REG("PRDR", 0xa405013c, 8) {
		PTR7_DATA, PTR6_DATA, PTR5_DATA, PTR4_DATA,
		PTR3_DATA, PTR2_DATA, PTR1_DATA, PTR0_DATA }
	},
	{ PINMUX_DATA_REG("PSDR", 0xa405013e, 8) {
		PTS7_DATA, PTS6_DATA, PTS5_DATA, PTS4_DATA,
		PTS3_DATA, PTS2_DATA, PTS1_DATA, PTS0_DATA }
	},
	{ PINMUX_DATA_REG("PTDR", 0xa4050160, 8) {
		0, 0, PTT5_DATA, PTT4_DATA,
		PTT3_DATA, PTT2_DATA, PTT1_DATA, PTT0_DATA }
	},
	{ PINMUX_DATA_REG("PUDR", 0xa4050162, 8) {
		0, 0, PTU5_DATA, PTU4_DATA,
		PTU3_DATA, PTU2_DATA, PTU1_DATA, PTU0_DATA }
	},
	{ PINMUX_DATA_REG("PVDR", 0xa4050164, 8) {
		PTV7_DATA, PTV6_DATA, PTV5_DATA, PTV4_DATA,
		PTV3_DATA, PTV2_DATA, PTV1_DATA, PTV0_DATA }
	},
	{ PINMUX_DATA_REG("PWDR", 0xa4050166, 8) {
		PTW7_DATA, PTW6_DATA, PTW5_DATA, PTW4_DATA,
		PTW3_DATA, PTW2_DATA, PTW1_DATA, PTW0_DATA }
	},
	{ PINMUX_DATA_REG("PXDR", 0xa4050168, 8) {
		PTX7_DATA, PTX6_DATA, PTX5_DATA, PTX4_DATA,
		PTX3_DATA, PTX2_DATA, PTX1_DATA, PTX0_DATA }
	},
	{ PINMUX_DATA_REG("PYDR", 0xa405016a, 8) {
		PTY7_DATA, PTY6_DATA, PTY5_DATA, PTY4_DATA,
		PTY3_DATA, PTY2_DATA, PTY1_DATA, PTY0_DATA }
	},
	{ PINMUX_DATA_REG("PZDR", 0xa405016c, 8) {
		PTZ7_DATA, PTZ6_DATA, PTZ5_DATA, PTZ4_DATA,
		PTZ3_DATA, PTZ2_DATA, PTZ1_DATA, PTZ0_DATA }
	},
	{ },
};

struct sh_pfc_soc_info sh7723_pinmux_info = {
	.name = "sh7723_pfc",
	.reserved_id = PINMUX_RESERVED,
	.data = { PINMUX_DATA_BEGIN, PINMUX_DATA_END },
	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END },
	.input_pu = { PINMUX_INPUT_PULLUP_BEGIN, PINMUX_INPUT_PULLUP_END },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END },
	.mark = { PINMUX_MARK_BEGIN, PINMUX_MARK_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.first_gpio = GPIO_PTA7,
	.last_gpio = GPIO_FN_IDEA0,

	.gpios = pinmux_gpios,
	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.gpio_data = pinmux_data,
	.gpio_data_size = ARRAY_SIZE(pinmux_data),
};
