#ifndef AIO_SYSCALL
#define AIO_SYSCALL

#include <asm/unistd.h>
#undef __syscall_return
#ifndef __powerpc__
#define __syscall_return(type, res) \
do { \
	return (type) (res); \
} while (0)
#else
//<_Marcus_>
#define __syscall_return(type)  \
	do { \
		return (type)__sc_ret; \
	} while (0)
#endif

#ifndef __NR_io_setup
#ifdef __s390__
#define __NR_io_setup		243
#define __NR_io_destroy		244
#define __NR_io_getevents	245
#define __NR_io_submit		246
#define __NR_io_cancel		247
#endif
#ifdef __i386__
#define __NR_io_setup		245
#define __NR_io_destroy		246
#define __NR_io_getevents	247
#define __NR_io_submit		248
#define __NR_io_cancel		249
#endif
#ifdef __x86_64__
#define __NR_io_setup		206
#define __NR_io_destroy 	207
#define __NR_io_getevents       208
#define __NR_io_submit  	209
#define __NR_io_cancel   	210
#endif
#endif

#define __NR_sys_io_setup          __NR_io_setup
#define __NR_sys_io_destroy        __NR_io_destroy
#define __NR_sys_io_getevents      __NR_io_getevents
#define __NR_sys_io_submit         __NR_io_submit
#define __NR_sys_io_cancel         __NR_io_cancel

static inline _syscall2(long, sys_io_setup, unsigned int, nr_reqs, io_context_t *, ctxp)
static inline _syscall1(long, sys_io_destroy, io_context_t, ctx)
static inline _syscall3(long, sys_io_submit, io_context_t, ctx_id,
			long, nr, struct iocb **, iocbpp)
static inline _syscall3(long, sys_io_cancel, io_context_t, ctx_id,
			struct iocb *, iocb, struct io_event *, result)
static inline _syscall5(long, sys_io_getevents, io_context_t, ctx_id,
			long, min_nr, long, nr, struct io_event *, events,
			struct timespec *, timeout)

#endif /* AIO_SYSCALL */
